/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   SchRepeat.c
Author(s)   :   Michelle Tse
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date	    :   December 2nd, 1999
Purpose	    :   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/

#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

//#define DEBUG
//#define DEBUG_VOICE_ALARM
//#define DEBUG_MICH
/**************************** Global Variables ************************/
// Use function from ToDoList application
void ToDoPackDueDate(BYTE *ptr, SHORT year, SHORT month, SHORT day)
{
	SHORT	wday, nth_week;
	SHORT	wlen;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	//RtcYMDToWday1(year, month-1, day, &wday, &nth_week);
	wday = Dt_Date_WDay(year, month - 1, day);
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	if (wday == SYSETUP_SUN)
	{
		strcpy(ptr,SCHSUN);
		wlen = strlen(SCHSUN);
	}
	else if (wday == SYSETUP_MON)
	{
		strcpy(ptr,SCHMON);
		wlen = strlen(SCHMON);
	}
	else if (wday == SYSETUP_TUE)
	{
		strcpy(ptr,SCHTUE);
		wlen = strlen(SCHTUE);
	}
	else if (wday == SYSETUP_WED)
	{
		strcpy(ptr,SCHWED);
		wlen = strlen(SCHWED);
	}
	else if (wday == SYSETUP_THU)
	{
		strcpy(ptr,SCHTHU);
		wlen = strlen(SCHTHU);
	}
	else if (wday == SYSETUP_FRI)
	{
		strcpy(ptr,SCHFRI);
		wlen = strlen(SCHFRI);
	}
	else if (wday == SYSETUP_SAT)
	{
		strcpy(ptr,SCHSAT);
		wlen = strlen(SCHSAT);
	}
	
	if (country.date_fmt == SYSETUP_MDY)
	{
		if (month == 1)
		{
			strcat((char*)ptr,SCHJAN1);
			wlen += strlen(SCHJAN1);
		}
		else if (month == 2)
		{
			strcat((char*)ptr,SCHFEB1);
			wlen += strlen(SCHFEB1);
		}
		else if (month == 3)
		{
			strcat((char*)ptr,SCHMAR1);
			wlen += strlen(SCHMAR1);
		}
		else if (month == 4)
		{
			strcat((char*)ptr,SCHAPR1);
			wlen += strlen(SCHAPR1);
		}
		else if (month == 5)
		{
			strcat((char*)ptr,SCHMAY1);
			wlen += strlen(SCHMAY1);
		}
		else if (month == 6)
		{
			strcat((char*)ptr,SCHJUN1);
			wlen += strlen(SCHJUN1);
		}
		else if (month == 7)
		{
			strcat((char*)ptr,SCHJUL1);
			wlen += strlen(SCHJUL1);
		}
		else if (month == 8)
		{
			strcat((char*)ptr,SCHAUG1);
			wlen += strlen(SCHAUG1);
		}
		else if (month == 9)
		{
			strcat((char*)ptr,SCHSEP1);
			wlen += strlen(SCHSEP1);
		}
		else if (month == 10)
		{
			strcat((char*)ptr,SCHOCT1);
			wlen += strlen(SCHOCT1);
		}
		else if (month == 11)
		{
			strcat((char*)ptr,SCHNOV1);
			wlen += strlen(SCHNOV1);
		}
		else if (month == 12)
		{
			strcat((char*)ptr,SCHDEC1);
			wlen += strlen(SCHDEC1);
		}
		
		ptr += wlen;
		if (day <10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",day);
			ptr += 2;
		}
		*(ptr++) = ' ';
		sprintf((char*)ptr,"%d",year);
	}
	else if (country.date_fmt == SYSETUP_DMY)
	{
		ptr += wlen;
		if (day <10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",day);
			ptr += 2;
		}
		*(ptr++) = ' ';
		
		wlen = 0;
		switch(month)
		{
		case 1:
			sprintf((char*)ptr, "%s", SCHJAN1);
			wlen = strlen(SCHJAN1);
			break;
		case 2:
			sprintf((char*)ptr, "%s", SCHFEB1);
			wlen = strlen(SCHFEB1);
			break;
		case 3:
			sprintf((char*)ptr, "%s", SCHMAR1);
			wlen = strlen(SCHMAR1);
			break;
		case 4:
			sprintf((char*)ptr, "%s", SCHAPR1);
			wlen = strlen(SCHAPR1);
			break;
		case 5:
			sprintf((char*)ptr, "%s", SCHMAY1);
			wlen = strlen(SCHMAY1);
			break;
		case 6:
			sprintf((char*)ptr, "%s", SCHJUN1);
			wlen = strlen(SCHJUN1);
			break;
		case 7:
			sprintf((char*)ptr, "%s", SCHJUL1);
			wlen = strlen(SCHJUL1);
			break;
		case 8:
			sprintf((char*)ptr, "%s", SCHAUG1);
			wlen = strlen(SCHAUG1);
			break;
		case 9:
			sprintf((char*)ptr, "%s", SCHSEP1);
			wlen = strlen(SCHSEP1);
			break;
		case 10:
			sprintf((char*)ptr, "%s", SCHOCT1);
			wlen = strlen(SCHOCT1);
			break;
		case 11:
			sprintf((char*)ptr, "%s", SCHNOV1);
			wlen = strlen(SCHNOV1);
			break;
		case 12:
			sprintf((char*)ptr, "%s", SCHDEC1);
			wlen = strlen(SCHDEC1);
			break;
		}
		ptr += wlen;
		sprintf((char*)ptr, "%d", year);
	}
	else
	{
		ptr += wlen;
		sprintf((char*)ptr, "%d", year);
		ptr += 4;
		*(ptr++) = ' ';
		
		wlen = 0;
		switch(month)
		{
		case 1:
			sprintf((char*)ptr, "%s", SCHJAN1);
			wlen = strlen(SCHJAN1);
			break;
		case 2:
			sprintf((char*)ptr, "%s", SCHFEB1);
			wlen = strlen(SCHFEB1);
			break;
		case 3:
			sprintf((char*)ptr, "%s", SCHMAR1);
			wlen = strlen(SCHMAR1);
			break;
		case 4:
			sprintf((char*)ptr, "%s", SCHAPR1);
			wlen = strlen(SCHAPR1);
			break;
		case 5:
			sprintf((char*)ptr, "%s", SCHMAY1);
			wlen = strlen(SCHMAY1);
			break;
		case 6:
			sprintf((char*)ptr, "%s", SCHJUN1);
			wlen = strlen(SCHJUN1);
			break;
		case 7:
			sprintf((char*)ptr, "%s", SCHJUL1);
			wlen = strlen(SCHJUL1);
			break;
		case 8:
			sprintf((char*)ptr, "%s", SCHAUG1);
			wlen = strlen(SCHAUG1);
			break;
		case 9:
			sprintf((char*)ptr, "%s", SCHSEP1);
			wlen = strlen(SCHSEP1);
			break;
		case 10:
			sprintf((char*)ptr, "%s", SCHOCT1);
			wlen = strlen(SCHOCT1);
			break;
		case 11:
			sprintf((char*)ptr, "%s", SCHNOV1);
			wlen = strlen(SCHNOV1);
			break;
		case 12:
			sprintf((char*)ptr, "%s", SCHDEC1);
			wlen = strlen(SCHDEC1);
			break;
		}
		ptr += wlen;
		if (day <10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
		}
		else
			sprintf((char*)ptr,"%d",day);
	}
}

/********************************************************
* Function:	SchedulerInitRepeatSettings
* Purpose: 	This function is called to initialize all the
*		global variables of structure repeat_settings 
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerInitRepeatSettings()
{
	SHORT i;
	
	repeat_settings.change = 0;
	repeat_settings.default_method = 255;
	repeat_settings.method = 255;
	repeat_settings.every_info = 0;
	repeat_settings.exception = 0;
	repeat_settings.new_repeat = 0;
	repeat_settings.every_data = 0;
	repeat_settings.n_week = 0;
	repeat_settings.repeat_num = 0;
	i = 6;
	do
	{
		repeat_settings.start_date[i] = 0xFF;
		i--;
	}while (i > 0);
	i = 6;
	do
	{
		repeat_settings.end_date[i] = 0xFF;
		i--;
	}while (i > 0);
	return;
}

/********************************************************
* Function:	SchedulerRepeatSetUpScreen
* Purpose: 	This function is called to set up the Repeat
*			setting form
* Scope:	application/internal
* Input:	repeat_status	The status indicate the repeat
*			method chosen by user
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerRepeatSetUpScreen(SHORT repeat_status)
{
	BYTE object_type;
	BYTE *text;
	BYTE buffer[20];
	SHORT text_length;
	SHORT start, end;
	void *addr;
	UBYTE date[4];
	SHORT year, month, day, wday, n_week, resource_id, data_id;
	SHORT i, j, k;
	SHORT status;
	BYTE data, every_data, new_repeat;
	//TRUE when start of week = SUN, FALSE when start of week = MON
	BOOLEAN weekday_flag = TRUE;
	CountrySettings country;
	
	start = STRING_SCH_REPEAT_EVERY;
	end = PUSHBUTTON_SCH_REPEAT_MONTH_DAY + 1;
	if (repeat_status == NONE)
	{
		i = PUSHBUTTON_SCH_REPEAT_NONE;
		j = PUSHBUTTON_SCH_REPEAT_YEAR + 1;
		k = i;
		do
		{
			FormGetObjectPointer(i, &object_type, (void**)&addr);
			if (i == k)
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
			else
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
			i++;
		} while (i != j);
		
		while(start != end)
		{
			FormGetObjectPointer(start, &object_type, (void**)&addr);
			switch(object_type)
			{
			case CONTROL:
				((Control*)addr)->control_attr.control_visible = FALSE;
				ControlEraseControl(start);
				break;
			case STRING:
				((String*)addr)->string_attr.string_visible = FALSE;
				StringEraseString(start);
				break;
			case TEXTBOX:
				((Textbox*)addr)->textbox_attr.textbox_visible = FALSE;
				TextboxEraseTextbox(start);
				break;
			}
			start++;
		}
		repeat_settings.method = 0;
		return;
	}
	else if (repeat_status == DAY)
	{
		i = PUSHBUTTON_SCH_REPEAT_NONE;
		j = PUSHBUTTON_SCH_REPEAT_YEAR + 1;
		k = PUSHBUTTON_SCH_REPEAT_DAY;
		do
		{
			FormGetObjectPointer(i, &object_type, (void**)&addr);
			if (i == k)
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
			else
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
			i++;
		} while (i != j);
		while(start != end)
		{
			if (start == POPUP_TRIGGER_REPEAT_END_SELECT && repeat_settings.new_repeat) ControlInitControl(start);
			if (start == TEXTBOX_SCH_REPEAT_VALUE && repeat_settings.new_repeat) TextboxInitTextbox(start);
			FormGetObjectPointer(start, &object_type, (void**)&addr);
			switch(object_type)
			{
			case CONTROL:
				if (start == POPUP_TRIGGER_REPEAT_END_SELECT)
				{
					if (!repeat_settings.new_repeat)
					{
						i = 2;
						do
						{
							if ((BYTE)repeat_settings.end_date[i] != -1)
								break;
							i--;
						}while (i >= 0);
						if (i > 0)
						{
							ControlPopupSetSelectedItem(start, 1);
							date[0] = repeat_settings.end_date[0];
							date[1] = repeat_settings.end_date[1];
							date[2] = repeat_settings.end_date[2];
							ToDoPackDueDate(buffer, (date[0]+SYSETUP_YEAR_OFFSET), date[1], date[2]);
							ControlSetLabel(start, buffer);
						}
						else
						{
							i = 6;
							do
							{
								repeat_settings.end_date[i] = 0xFF;
								i--;
							} while(i > 0);
							ControlPopupSetSelectedItem(start, 0);
						}
					}
					((Control*)addr)->control_attr.control_visible = TRUE;
					ControlEraseControl(start);
					ControlDrawControl(start);
				}
				else
				{
					((Control*)addr)->control_attr.control_visible = FALSE;
					ControlEraseControl(start);
				}
				break;
			case STRING:
				if (start == STRING_SCH_REPEAT_UNIT)
				{
					((String*)addr)->string_attr.string_visible = TRUE;
					StringSetText(start, SCHDAYS);
					StringEraseString(start);
					StringDrawString(start);
				}
				else if (start == STRING_SCH_REPEAT_OPTION_SELECT)
				{
					((String*)addr)->string_attr.string_visible = FALSE;
					StringEraseString(start);
				}
				else
				{
					((String*)addr)->string_attr.string_visible = TRUE;
					StringDrawString(start);
				}
				break;
			case TEXTBOX:
				if (!repeat_settings.new_repeat)
				{
					sprintf((char*)((Textbox*)addr)->textbox_string, "%d", repeat_settings.every_info);
				}
				else repeat_settings.every_info = atol((const char*)((Textbox*)addr)->textbox_string);
				((Textbox*)addr)->textbox_attr.textbox_visible = TRUE;
				TextboxEraseTextbox(start);
				TextboxDrawTextbox(start);
				break;
			}
			start++;
		}
		repeat_settings.method = 1;
		return;
	}
	else if (repeat_status == WEEK)
	{
		i = PUSHBUTTON_SCH_REPEAT_NONE;
		j = PUSHBUTTON_SCH_REPEAT_YEAR + 1;
		k = PUSHBUTTON_SCH_REPEAT_WEEK;
		do
		{
			FormGetObjectPointer(i, &object_type, (void**)&addr);
			if (i == k)
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
			else
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
			i++;
		} while (i != j);
		while(start != end)
		{
			if (start <= PUSHBUTTON_SCH_REPEAT_SUN || start >= PUSHBUTTON_SCH_REPEAT_SAT)
			{
				if (start == POPUP_TRIGGER_REPEAT_END_SELECT && repeat_settings.new_repeat) ControlInitControl(start);
				if (start == TEXTBOX_SCH_REPEAT_VALUE && repeat_settings.new_repeat) TextboxInitTextbox(start);
				FormGetObjectPointer(start, &object_type, (void**)&addr);
				switch(object_type)
				{
				case CONTROL:
					if (start == POPUP_TRIGGER_REPEAT_END_SELECT)
					{
						if (!repeat_settings.new_repeat)
						{
							i = 2;
							do
							{
								if ((BYTE)repeat_settings.end_date[i] != -1)
									break;
								i--;
							}while (i >= 0);
							if (i > 0)
							{
								ControlPopupSetSelectedItem(start, 1);
								date[0] = repeat_settings.end_date[0];
								date[1] = repeat_settings.end_date[1];
								date[2] = repeat_settings.end_date[2];
								ToDoPackDueDate(buffer, (date[0]+SYSETUP_YEAR_OFFSET), date[1], date[2]);
								ControlSetLabel(start, buffer);
							}
							else
							{
								i = 6;
								do
								{
									repeat_settings.end_date[i] = 0xFF;
									i--;
								} while(i > 0);
								ControlPopupSetSelectedItem(start, 0);
							}
						}
						((Control*)addr)->control_attr.control_visible = TRUE;
						ControlEraseControl(start);
						ControlDrawControl(start);
					}
					else
					{
						((Control*)addr)->control_attr.control_visible = FALSE;
						ControlEraseControl(start);
					}
					break;
				case STRING:
					if (start == STRING_SCH_REPEAT_UNIT)
					{
						((String*)addr)->string_attr.string_visible = TRUE;
						StringSetText(start, SCHWEEKS);
						StringEraseString(start);
						StringDrawString(start);
					}
					else if (start == STRING_SCH_REPEAT_OPTION_SELECT)
					{
						((String*)addr)->string_attr.string_visible = TRUE;
						StringSetText(start, SCHREPON);
						StringEraseString(start);
						StringDrawString(start);
					}
					else
					{
						((String*)addr)->string_attr.string_visible = TRUE;
						StringDrawString(start);
					}
					break;
				case TEXTBOX:
					if (!repeat_settings.new_repeat)
						sprintf((char*)((Textbox*)addr)->textbox_string, "%d", repeat_settings.every_info);
					else repeat_settings.every_info = atol((const char*)((Textbox*)addr)->textbox_string);
					((Textbox*)addr)->textbox_attr.textbox_visible = TRUE;
					TextboxEraseTextbox(start);
					TextboxDrawTextbox(start);
					break;
				}
			}
			start++;
		}
		start = PUSHBUTTON_SCH_REPEAT_SUN;
		end = PUSHBUTTON_SCH_REPEAT_SAT + 1;
		SchedulerGetDayViewDate(date);
		year = (SHORT)(date[0] + SYSETUP_YEAR_OFFSET);
		month = (SHORT)(date[1] - 1);
		day = (SHORT)date[2];
		//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
		//RtcYMDToWday1(year, month, day, &wday, &n_week);
		wday = Dt_Date_WDay(year, month, day);
		//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
		resource_id = wday+PUSHBUTTON_SCH_REPEAT_SUN;
		SySetupGetCountrySettings(&country);
		if (country.start_of_week == SYSETUP_SUN) weekday_flag = TRUE;
		else
		{
			weekday_flag = FALSE;
			if (resource_id == PUSHBUTTON_SCH_REPEAT_SUN)
				resource_id = PUSHBUTTON_SCH_REPEAT_SAT;
			else resource_id--;
		}
		new_repeat = repeat_settings.new_repeat;
		every_data = repeat_settings.every_data;
		data_id = PUSHBUTTON_SCH_REPEAT_SUN;
		data = 64;
		while(start != end)
		{
			if (new_repeat)
			{
				ControlInitControl(start);
				// start of week is monday
				if (!weekday_flag)
				{
					if (start == PUSHBUTTON_SCH_REPEAT_SUN)
						ControlSetLabel(start, SCHMON2);
					else if (start == PUSHBUTTON_SCH_REPEAT_MON)
						ControlSetLabel(start, SCHTUE2);
					else if (start == PUSHBUTTON_SCH_REPEAT_TUE)
						ControlSetLabel(start, SCHWED2);
					else if (start == PUSHBUTTON_SCH_REPEAT_WED)
						ControlSetLabel(start, SCHTHU2);
					else if (start == PUSHBUTTON_SCH_REPEAT_THU)
						ControlSetLabel(start, SCHFRI2);
					else if (start == PUSHBUTTON_SCH_REPEAT_FRI)
						ControlSetLabel(start, SCHSAT2);
					else if (start == PUSHBUTTON_SCH_REPEAT_SAT)
						ControlSetLabel(start, SCHSUN2);
				}
				if (start == resource_id)
				{
					if (!weekday_flag)
					{
						if (wday == 0) wday = 6;
						else wday--;
					}
					FormGetObjectPointer(wday+PUSHBUTTON_SCH_REPEAT_SUN, &object_type, (void**)&addr);
					((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
					if (resource_id == PUSHBUTTON_SCH_REPEAT_SUN)
						repeat_settings.every_data = 64;
					else if (resource_id == PUSHBUTTON_SCH_REPEAT_MON)
						repeat_settings.every_data = 32;
					else if (resource_id == PUSHBUTTON_SCH_REPEAT_TUE)
						repeat_settings.every_data = 16;
					else if (resource_id == PUSHBUTTON_SCH_REPEAT_WED)
						repeat_settings.every_data = 8;
					else if (resource_id == PUSHBUTTON_SCH_REPEAT_THU)
						repeat_settings.every_data = 4;
					else if (resource_id == PUSHBUTTON_SCH_REPEAT_FRI)
						repeat_settings.every_data = 2;
					else if (resource_id == PUSHBUTTON_SCH_REPEAT_SAT)
						repeat_settings.every_data = 1;
				}
				else FormGetObjectPointer(start, &object_type, (void**)&addr);
			}
			else
			{
				if (!weekday_flag)
				{
					FormGetObjectPointer(start, &object_type, (void**)&addr);
					// Shift the label of the pushbuttons
					if (start == PUSHBUTTON_SCH_REPEAT_SUN)
						ControlSetLabel(start, SCHMON2);
					else if (start == PUSHBUTTON_SCH_REPEAT_MON)
						ControlSetLabel(start, SCHTUE2);
					else if (start == PUSHBUTTON_SCH_REPEAT_TUE)
						ControlSetLabel(start, SCHWED2);
					else if (start == PUSHBUTTON_SCH_REPEAT_WED)
						ControlSetLabel(start, SCHTHU2);
					else if (start == PUSHBUTTON_SCH_REPEAT_THU)
						ControlSetLabel(start, SCHFRI2);
					else if (start == PUSHBUTTON_SCH_REPEAT_FRI)
						ControlSetLabel(start, SCHSAT2);
					else if (start == PUSHBUTTON_SCH_REPEAT_SAT)
						ControlSetLabel(start, SCHSUN2);
				}
				if (every_data)
				{
					FormGetObjectPointer(start, &object_type, (void**)&addr);
					if ((every_data & data) == data)
						((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
					else
						((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
					data = data / 2;
				}
			}
			((Control*)addr)->control_attr.control_visible = TRUE;
			ControlEraseControl(start);
			ControlDrawControl(start);
			start++;
		}
		repeat_settings.method = 2;
		return;
	}
	else if (repeat_status == MONTH)
	{
		i = PUSHBUTTON_SCH_REPEAT_NONE;
		j = PUSHBUTTON_SCH_REPEAT_YEAR + 1;
		k = PUSHBUTTON_SCH_REPEAT_MONTH;
		do
		{
			FormGetObjectPointer(i, &object_type, (void**)&addr);
			if (i == k)
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
			else
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
			i++;
		} while (i != j);
		while(start != end)
		{
			if ((start == POPUP_TRIGGER_REPEAT_END_SELECT || 
				start == PUSHBUTTON_SCH_REPEAT_MONTH_DATE ||
				start == PUSHBUTTON_SCH_REPEAT_MONTH_DAY) && repeat_settings.new_repeat)
				ControlInitControl(start);
			if (start == TEXTBOX_SCH_REPEAT_VALUE && repeat_settings.new_repeat) TextboxInitTextbox(start);
			FormGetObjectPointer(start, &object_type, (void**)&addr);
			switch(object_type)
			{
			case CONTROL:
				if (start == POPUP_TRIGGER_REPEAT_END_SELECT)
				{
					if (!repeat_settings.new_repeat)
					{
						i = 2;
						do
						{
							if ((BYTE)repeat_settings.end_date[i] != -1)
								break;
							i--;
						}while (i >= 0);
						if (i > 0)
						{
							ControlPopupSetSelectedItem(start, 1);
							date[0] = repeat_settings.end_date[0];
							date[1] = repeat_settings.end_date[1];
							date[2] = repeat_settings.end_date[2];
							ToDoPackDueDate(buffer, (date[0]+SYSETUP_YEAR_OFFSET), date[1], date[2]);
							ControlSetLabel(start, buffer);
						}
						else
						{
							i = 6;
							do
							{
								repeat_settings.end_date[i] = 0xFF;
								i--;
							} while(i > 0);
							ControlPopupSetSelectedItem(start, 0);
						}
					}
					((Control*)addr)->control_attr.control_visible = TRUE;
					ControlEraseControl(start);
					ControlDrawControl(start);
				}
				else if (start == PUSHBUTTON_SCH_REPEAT_MONTH_DATE)
				{
					if (!repeat_settings.new_repeat && repeat_settings.default_method > 0)
					{
						if (repeat_settings.default_method == REPEAT_MONTHLY_DATE)
							((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
						else ((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
					}
					((Control*)addr)->control_attr.control_visible = TRUE;
					ControlDrawControl(start);
					repeat_settings.method = 3;
				}
				else if (start == PUSHBUTTON_SCH_REPEAT_MONTH_DAY)
				{
					if (!repeat_settings.new_repeat && repeat_settings.default_method > 0)
					{
						if (repeat_settings.default_method == REPEAT_MONTHLY_DAY)
							((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
						else ((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
					}
					((Control*)addr)->control_attr.control_visible = TRUE;
					ControlDrawControl(start);
					repeat_settings.method = 4;
					SchedulerGetDayViewDate(date);
					year = (SHORT)(date[0] + SYSETUP_YEAR_OFFSET);
					month = (SHORT)date[1];
					day = (SHORT)date[2];
					//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
					//RtcYMDToWday2(year, (month - 1), day, &wday, &n_week);
					wday = Dt_Date_WDay(year, month - 1, day);
					n_week = Dt_Date_M7day(year, month - 1, day);
					//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
					repeat_settings.n_week = n_week;
					repeat_settings.every_data = wday;
				}
				else
				{
					((Control*)addr)->control_attr.control_visible = FALSE;
					ControlEraseControl(start);
				}
				break;
			case STRING:
				if (start == STRING_SCH_REPEAT_UNIT)
				{
					((String*)addr)->string_attr.string_visible = TRUE;
					StringSetText(start, SCHMONTHS);
					StringEraseString(start);
					StringDrawString(start);
				}
				else if (start == STRING_SCH_REPEAT_OPTION_SELECT)
				{
					((String*)addr)->string_attr.string_visible = TRUE;
					StringSetText(start, SCHREPBY);
					StringEraseString(start);
					StringDrawString(start);
				}
				else
				{
					((String*)addr)->string_attr.string_visible = TRUE;
					StringDrawString(start);
				}
				break;
			case TEXTBOX:
				if (!repeat_settings.new_repeat)
					sprintf((char*)((Textbox*)addr)->textbox_string, "%d", repeat_settings.every_info);
				else repeat_settings.every_info = atol((const char*)((Textbox*)addr)->textbox_string);
				((Textbox*)addr)->textbox_attr.textbox_visible = TRUE;
				TextboxEraseTextbox(start);
				TextboxDrawTextbox(start);
				break;
			}
			start++;
		}
		return;
	}
	else if (repeat_status == YEAR)
	{
		i = PUSHBUTTON_SCH_REPEAT_NONE;
		j = PUSHBUTTON_SCH_REPEAT_YEAR + 1;
		k = PUSHBUTTON_SCH_REPEAT_YEAR;
		do
		{
			FormGetObjectPointer(i, &object_type, (void**)&addr);
			if (i == k)
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = TRUE;
			else
				((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value = FALSE;
			i++;
		} while (i != j);
		while(start != end)
		{
			if (start == POPUP_TRIGGER_REPEAT_END_SELECT) ControlInitControl(start);
			if (start == TEXTBOX_SCH_REPEAT_VALUE) TextboxInitTextbox(start);
			FormGetObjectPointer(start, &object_type, (void**)&addr);
			switch(object_type)
			{
			case CONTROL:
				if (start == POPUP_TRIGGER_REPEAT_END_SELECT)
				{
					if (!repeat_settings.new_repeat)
					{
						i = 2;
						do
						{
							if ((BYTE)repeat_settings.end_date[i] != -1)
								break;
							i--;
						}while (i >= 0);
						if (i > 0)
						{
							ControlPopupSetSelectedItem(start, 1);
							date[0] = repeat_settings.end_date[0];
							date[1] = repeat_settings.end_date[1];
							date[2] = repeat_settings.end_date[2];
							ToDoPackDueDate(buffer, (date[0]+SYSETUP_YEAR_OFFSET), date[1], date[2]);
							ControlSetLabel(start, buffer);
						}
						else
						{
							i = 6;
							do
							{
								repeat_settings.end_date[i] = 0xFF;
								i--;
							} while(i > 0);
							ControlPopupSetSelectedItem(start, 0);
						}
					}
					((Control*)addr)->control_attr.control_visible = TRUE;
					ControlEraseControl(start);
					ControlDrawControl(start);
				}
				else
				{
					((Control*)addr)->control_attr.control_visible = FALSE;
					ControlEraseControl(start);
				}
				break;
			case STRING:
				if (start == STRING_SCH_REPEAT_UNIT)
				{
					((String*)addr)->string_attr.string_visible = TRUE;
					StringSetText(start, SCHYEARS);
					StringEraseString(start);
					StringDrawString(start);
				}
				else if (start == STRING_SCH_REPEAT_OPTION_SELECT)
				{
					((String*)addr)->string_attr.string_visible = FALSE;
					StringEraseString(start);
				}
				else
				{
					((String*)addr)->string_attr.string_visible = TRUE;
					StringDrawString(start);
				}
				break;
			case TEXTBOX:
				if (!repeat_settings.new_repeat)
					sprintf((char*)((Textbox*)addr)->textbox_string, "%d", repeat_settings.every_info);
				else repeat_settings.every_info = atol((const char*)((Textbox*)addr)->textbox_string);
				((Textbox*)addr)->textbox_attr.textbox_visible = TRUE;
				TextboxEraseTextbox(start);
				TextboxDrawTextbox(start);
				break;
			}
			start++;
		}
		repeat_settings.method = 5;
		return;
	}
}

/********************************************************
* Function:	SchedulerSaveRepeatSettings
* Purpose: 	This function is called to save the repeat setting 
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerSaveRepeatSettings(BOOLEAN save_string_only, BOOLEAN save_date)
{
	BOOLEAN new_record = FALSE;
	BOOLEAN display = TRUE;
	UWORD rec_num;
	SHORT item_no, day_in_yr;
	RecordID rec_id = 0;
	UBYTE date[4];
	BYTE repeat_no[5];
	UBYTE start_date[7];
	UBYTE end_date[7];
	UWORD num_content;
	SHORT i, year, day, month, str_length;
	SHORT wday, n_week;
	WORD active_row, next_active_row;
	RepeatAttr repeat_attr;
	BYTE *string;
	CountrySettings country;
	AlarmAttr alarm_attr;
	
	BYTE *field_text;
	
	SySetupGetCountrySettings(&country);
	if (!save_string_only)
	{
		if (repeat_settings.repeat_num)
		{
			active_row = virtual_table.vt_active_row;
			next_active_row = virtual_table.vt_items[virtual_table.vt_active_row]->appointment;
			virtual_table.vt_items[active_row]->repeat_num = repeat_settings.repeat_num;
			virtual_table.vt_items[active_row]->repeat = TRUE;
			ControlPopupGetSelectedItem(POPUP_TRIGGER_REPEAT_END_SELECT, &item_no);
			if (item_no == 0)
			{
				i = 2;
				do
				{
					repeat_settings.end_date[i] = 0xFF;
					i--;
				} while(i > 0);
			}
			repeat_settings.end_date[3] = virtual_table.vt_items[next_active_row]->hour;
			repeat_settings.end_date[4] = virtual_table.vt_items[next_active_row]->minute;
			year = (SHORT)(repeat_settings.end_date[0] + SYSETUP_YEAR_OFFSET);
			month = (SHORT)repeat_settings.end_date[1];
			day = (SHORT)repeat_settings.end_date[2];
            
			if (((BYTE)(repeat_settings.end_date[1])) == -1 && ((BYTE)(repeat_settings.end_date[2])) == -1)
				day_in_yr = 0;
			else day_in_yr = GetDayOfYear(year, month, day);
			
			SchedulerConvertBYTEtoSHORT((BYTE*)(repeat_settings.end_date+5), day_in_yr);
			
			virtual_table.vt_items[active_row]->repeat_method = repeat_settings.method;			
			
			virtual_table.vt_items[active_row]->repeat_every_info = repeat_settings.every_info;
			virtual_table.vt_items[active_row]->repeat_every_data = repeat_settings.every_data;
			repeat_settings.change = FALSE;
			*(UWORD*)repeat_no = virtual_table.vt_items[active_row]->repeat_num;
			repeat_no[4] = 0;
			if (DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id) != TRUE)
				new_record = TRUE;
			else
			{
				if (repeat_settings.method == REPEAT_NONE)
				{
					virtual_table.vt_items[active_row]->repeat = FALSE;
					virtual_table.vt_items[active_row]->repeat_num = 0;
					repeat_settings.repeat_num = 0;
					DataDeleteRecord(sch_repeat_dbid, rec_id, FALSE);
					return;
				}
			}
			if (save_date)
			{
				SchedulerGetDayViewDate(date);
				i = 2;
				do
				{
					start_date[i] = date[i];
					i--;
				}while(i >= 0);
			}
			else
			{
				i = 2;
				do
				{
					start_date[i] = repeat_settings.start_date[i];
					i--;
				}while(i >= 0);
			}
			start_date[3] = virtual_table.vt_items[active_row]->hour;
			start_date[4] = virtual_table.vt_items[active_row]->minute;
			year = (SHORT)(start_date[0] + SYSETUP_YEAR_OFFSET);
			month = (SHORT)start_date[1];
			day = (SHORT)start_date[2];
			day_in_yr = GetDayOfYear(year, month, day);
			
			SchedulerConvertBYTEtoSHORT((repeat_settings.start_date+5), day_in_yr);
			
			i = 6;
			do
			{
				end_date[i] = repeat_settings.end_date[i];
				i--;
			}while(i >= 0);
			repeat_attr.method = repeat_settings.method;
			repeat_attr.every_info = repeat_settings.every_info;
			repeat_attr.every_data = repeat_settings.every_data;
			printf("\nSTART ----> SchedulerSaveRepeatSettings");
			printf("\n repeat_attr.every_data = %ld", repeat_settings.every_data);
			
			//Michelle add 260100
			if (repeat_settings.method == REPEAT_WEEKLY)
			{
				if (country.start_of_week == SYSETUP_SUN)
					repeat_attr.every_data = repeat_attr.every_data | 128;
			}
			printf("\n repeat_attr.every_data = %ld", repeat_attr.every_data);
			printf("\nEND ----> SchedulerSaveRepeatSettings");
			//end add 260100
			repeat_attr.n_week = repeat_settings.n_week;
			alarm_attr.time = repeat_settings.alarm_time;
			alarm_attr.type = repeat_settings.alarm;
			alarm_attr.num = repeat_settings.alarm_num;
		}
		if (new_record)
		{
			DataNewRecord(sch_repeat_dbid, 0, 10, &rec_id);
			//		*(UWORD*)repeat_no = rec_id;
			*(UWORD*)repeat_no = repeat_settings.repeat_num;
			DataWriteField(sch_repeat_dbid, rec_id, F_REPEAT_NUM, sizeof(UWORD), (BYTE*)&repeat_no);
			DataWriteField(sch_repeat_dbid, rec_id, F_EXCEPT_FLAG, 1, (BYTE*)&repeat_settings.exception);
			DataWriteField(sch_repeat_dbid, rec_id, F_START_TIME, 7, (BYTE*)start_date);
			DataWriteField(sch_repeat_dbid, rec_id, F_END_TIME, 7, (BYTE*)end_date);
			DataWriteField(sch_repeat_dbid, rec_id, F_REPEAT_ATTR, 4, (BYTE*)&repeat_attr);
			DataWriteField(sch_repeat_dbid, rec_id, F_ALARM_FLAG, 1, (BYTE*)&virtual_table.vt_items[active_row]->alarm);
			DataWriteField(sch_repeat_dbid, rec_id, F_VOICE_RECID, sizeof(UWORD), (BYTE*)&repeat_settings.voice_recid);
			num_content = (UWORD)(strlen(virtual_table.vt_items[active_row]->ptr->field_string) + 1);
			//Michelle modified 280100
			DataWriteField(sch_repeat_dbid, rec_id, F_ALARM_SETTINGS, sizeof(AlarmAttr), (BYTE*)&alarm_attr);
			//280100
			DataWriteField(sch_repeat_dbid, rec_id, F_CONTENTS, num_content, virtual_table.vt_items[active_row]->ptr->field_string);
			//initialize the alarm date
			date[0] = -1;
			date[1] = -1;
			date[2] = -1;
			date[3] = 0;
			DataWriteField(sch_repeat_dbid, rec_id, F_ALARM_DATE, 4, date);
			DataCloseRecord(sch_repeat_dbid, rec_id);
		}
		else
		{
			DataRecIDtoNum(sch_repeat_dbid, rec_id, &rec_num);
			DataOpenRecord(sch_repeat_dbid, rec_num, &rec_id, NULL);
			DataWriteField(sch_repeat_dbid, rec_id, F_REPEAT_NUM, sizeof(UWORD), (BYTE*)&repeat_no);
			DataWriteField(sch_repeat_dbid, rec_id, F_EXCEPT_FLAG, 1, (BYTE*)&repeat_settings.exception);
			DataWriteField(sch_repeat_dbid, rec_id, F_START_TIME, 6, (BYTE*)start_date);
			DataWriteField(sch_repeat_dbid, rec_id, F_END_TIME, 6, (BYTE*)end_date);
			DataWriteField(sch_repeat_dbid, rec_id, F_REPEAT_ATTR, 4, (BYTE*)&repeat_attr);
			DataWriteField(sch_repeat_dbid, rec_id, F_ALARM_FLAG, 1, (BYTE*)&virtual_table.vt_items[active_row]->alarm);
			DataWriteField(sch_repeat_dbid, rec_id, F_VOICE_RECID, sizeof(UWORD), (BYTE*)&repeat_settings.voice_recid);
			num_content = (UWORD)(strlen(virtual_table.vt_items[active_row]->ptr->field_string) + 1);
			//Michelle modified 280100
			DataWriteField(sch_repeat_dbid, rec_id, F_ALARM_SETTINGS, sizeof(AlarmAttr), (BYTE*)&alarm_attr);
			//280100
			DataWriteField(sch_repeat_dbid, rec_id, F_CONTENTS, num_content, virtual_table.vt_items[active_row]->ptr->field_string);
			DataCloseRecord(sch_repeat_dbid, rec_id);
		}
	}
	else
	{
		active_row = virtual_table.vt_active_row;
		*(UWORD*)repeat_no = virtual_table.vt_items[active_row]->repeat_num;
		repeat_no[4] = 0;
		DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id);
		DataRecIDtoNum(sch_repeat_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_repeat_dbid, rec_num, &rec_id, NULL);
		
		FieldGetTextPointer((ObjectID)(virtual_table.vt_active_row - 
			virtual_table.vt_top_row_num +
			FIELD_SCH_DAY_VIEW_0), &field_text);
		//		if (strlen(field_text) != 0)
		//		{
		num_content = (UWORD)(strlen(virtual_table.vt_items[active_row]->ptr->field_string) + 1);
		DataWriteField(sch_repeat_dbid, rec_id, F_CONTENTS, num_content, virtual_table.vt_items[active_row]->ptr->field_string);
		DataCloseRecord(sch_repeat_dbid, rec_id);
		//		}
		//		else
		//		{
		//			DataCloseRecord(sch_repeat_dbid, rec_id);
		//			DataDeleteRecord(sch_repeat_dbid, rec_id, FALSE);
		//		}
	}
	return;
}

/********************************************************
* Function:	SchedulerRestoreRepeatSettings
* Purpose: 	This function is called to restore the repeat setting 
* Scope:	application/internal
* Input:	None
* Output:	repeat_status
* Return:	TRUE - It is a new repeat record
*			FALSE - It is not a new repeat record
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerRestoreRepeatSettings(SHORT *status, UWORD repeat_num)
{
	BYTE repeat_no[5];
	UWORD rec_num;
	RecordID rec_id = 0;
	BYTE *buffer;
	UWORD byte_read;
	SHORT alarm_flag, i = 5;
	WORD active_row, next_active_row;
	AlarmAttr *alarm_attr;
	RepeatAttr *repeat_attr;
	//Bug Fixed 6-Feb-2001
	//---------------------------- Adding Codes
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	//---------------------------- Adding Codes
	if (repeat_num == 0)
	{
		*(UWORD*)repeat_no = virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num;
		repeat_no[4] = 0;
	}
	else
	{
		*(UWORD*)repeat_no = repeat_num;
		repeat_no[4] = 0;
	}
	if (DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id) != TRUE)
	{
		if (!repeat_settings.change) *status = NONE;
		return TRUE;
	}
	else
	{
		if (repeat_num == 0)
		{
			active_row = virtual_table.vt_active_row;
			repeat_settings.repeat_num = virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num;
			virtual_table.vt_items[active_row]->repeat = TRUE;
		}
		else repeat_settings.repeat_num = repeat_num;
		DataRecIDtoNum(sch_repeat_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_repeat_dbid, rec_num, &rec_id, NULL);
		DataGetField(sch_repeat_dbid, rec_id, F_START_TIME, &buffer, &byte_read);
		do
		{
			repeat_settings.start_date[i] = buffer[i];
			i--;
		} while (i >= 0);
		qfree(buffer);
		DataGetField(sch_repeat_dbid, rec_id, F_END_TIME, &buffer, &byte_read);
		i = 6;
		do
		{
			repeat_settings.end_date[i] = buffer[i];
			i--;
		} while (i >= 0);
		qfree(buffer);
		
		//Bug Fixed 20-Feb-2001
		//--------------------------------------------------------------------- Adding Codes
		DataGetField(sch_repeat_dbid, rec_id, F_EXCEPT_FLAG, &buffer, &byte_read);
		repeat_settings.exception = *buffer;
		qfree(buffer);
		//--------------------------------------------------------------------- Adding Codes
		
		DataGetField(sch_repeat_dbid, rec_id, F_REPEAT_ATTR, (BYTE**)&repeat_attr, &byte_read);
		repeat_settings.method = repeat_attr->method;
		if (repeat_num == 0)
			virtual_table.vt_items[active_row]->repeat_method = repeat_attr->method;
		if ((repeat_settings.method == REPEAT_MONTHLY_DATE) || (repeat_settings.method == REPEAT_MONTHLY_DAY))
			*status = MONTH;
		else if (repeat_settings.method == REPEAT_YEARLY)
			*status = YEAR;
		else *status = repeat_settings.method;
		repeat_settings.default_method = repeat_attr->method;
		repeat_settings.every_info = repeat_attr->every_info;
		if (repeat_num == 0)
			virtual_table.vt_items[active_row]->repeat_every_info = repeat_attr->every_info;
		
#ifdef DEBUG_MICH
		printf("\nSTART ----------> SchedulerRestoreRepeatSettings");
		printf("\nREP_METHOD - %ld", repeat_attr->method);
		printf("\nREP_DATA - %ld", repeat_attr->every_data);
#endif
		//Bug Fixed 6-Feb-2001
		//Restore the weekly repeat pattern depending on 
		//the start_of_week when the record was saved
		//-------------------------------------------------- Modifying Codes
		if (repeat_settings.method == REPEAT_MONTHLY_DATE)
		{
			if (repeat_attr->every_data & 128)
				repeat_settings.every_data = repeat_attr->every_data + 128;
		}
		else if (repeat_settings.method == REPEAT_WEEKLY)
		{
			// start_of_week is SUNDAY when the record is saved
			if (repeat_attr->every_data & 128)
			{
				repeat_settings.every_data = repeat_attr->every_data + 128;
#ifdef DEBUG_MICH
				printf("\nPoint 0: REP_SET_DATA - %ld", repeat_settings.every_data);
#endif DEBUG_MICH
				if (country.start_of_week == SYSETUP_MON)
				{
					if (repeat_attr->every_data & 64)
					{
						repeat_settings.every_data <<= 1;
						repeat_settings.every_data += 1;
						if (repeat_settings.every_data & 128)
							repeat_settings.every_data += 128;
					}
					else repeat_settings.every_data <<= 1;
				}
#ifdef DEBUG_MICH
				printf("\nPoint 1: REP_SET_DATA - %ld", repeat_settings.every_data);
#endif DEBUG_MICH
			}
			else
			{
				repeat_settings.every_data = repeat_attr->every_data;
				if (country.start_of_week == SYSETUP_SUN)
				{
					if (repeat_attr->every_data & 1)
					{
						repeat_settings.every_data >>= 1;
						repeat_settings.every_data += 64;
						if (repeat_settings.every_data & 128)
							repeat_settings.every_data += 128;
					}
					else repeat_settings.every_data >>= 1;
				}
#ifdef DEBUG_MICH
				printf("\nPoint 2: REP_SET_DATA - %ld", repeat_settings.every_data);
#endif DEBUG_MICH
			}
		}
		else
			repeat_settings.every_data = repeat_attr->every_data;
		
		//-------------------------------------------------- Modifying Codes
#ifdef DEBUG_MICH
		printf("\nAfter Process:");
		printf("\nREP_DATA - %ld", repeat_settings.every_data);
		printf("\nEND ----------> SchedulerRestoreRepeatSettings");
#endif DEBUG_MICH
		
		if (repeat_num == 0)
			virtual_table.vt_items[active_row]->repeat_every_data = repeat_settings.every_data;
		repeat_settings.n_week = repeat_attr->n_week;
		qfree(repeat_attr);
		//Michelle modified 280100
		DataGetField(sch_repeat_dbid, rec_id, F_ALARM_SETTINGS, (BYTE**)&alarm_attr, &byte_read);
		repeat_settings.alarm_time = alarm_attr->time;
		repeat_settings.alarm = alarm_attr->type;
		repeat_settings.alarm_num = alarm_attr->num;
		//280100
		
		//Michelle add 310100
		DataGetField(sch_repeat_dbid, rec_id, F_VOICE_RECID, &buffer, &byte_read);
		repeat_settings.voice_recid = *((UWORD*)buffer);
		qfree(buffer);
#ifdef DEBUG_VOICE_ALARM
		printf("\n ===== Restore repeat settings =====");
		printf("\n repeat_settings.voice_recid = %ld", repeat_settings.voice_recid);
#endif
		if (repeat_num == 0)
		{
			//Michelle modified 280100
			virtual_table.vt_items[active_row]->alarm = alarm_attr->type;
			virtual_table.vt_items[active_row]->alarm_time = alarm_attr->time;
			virtual_table.vt_items[active_row]->alarm_num = alarm_attr->num;
			virtual_table.vt_items[active_row]->recid = repeat_settings.voice_recid;
			//280100
		}
		qfree(alarm_attr);
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerSaveException
* Purpose: 	This function is called to save the exception date
*			in exception database
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerSaveException()
{
	BYTE		repeat_no[5];
	BOOLEAN 	new_record, found;
	UWORD 		rec_num, repeat_rec_num, reset_alarm = FALSE;
	RecordID 	rec_id, repeat_rec_id, appmt_rec_id;
	UBYTE 		date[4], today[4], *alarm_date, next_alarm_date[4], appmt_alarm_date[4];
	UBYTE		test_date[4];
	BYTE 		*buffer, *temp, *a;
	UWORD		byte_read, b;
	USHORT 		num_length;
	SHORT 		i = 0, count, day_in_month;
	RTM			time;
	
	SchedulerGetDayViewDate(date);
	RtcGetTime(&time);
	today[0] = (UBYTE)(time.year - SYSETUP_YEAR_OFFSET);
	today[1] = (UBYTE)(time.mon + 1);
	today[2] = (UBYTE)(time.mday);
	today[3] = 0;
	
	if (prev_status == TIME_STATUS)
		*(UWORD*)repeat_no = repeat_settings.repeat_num;
	else
		*(UWORD*)repeat_no = virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num;
	repeat_no[4] = 0;
	
	//Find the repeat record
	DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &repeat_rec_id);
	DataRecIDtoNum(sch_repeat_dbid, repeat_rec_id, &repeat_rec_num);
	DataOpenRecord(sch_repeat_dbid, repeat_rec_num, &repeat_rec_id, NULL);
	if (DataGetField(sch_repeat_dbid, repeat_rec_id, F_ALARM_DATE, (BYTE**)&alarm_date, &byte_read))
	{
		if (((BYTE)alarm_date[0] != -1) && ((BYTE)alarm_date[1] != -1) && ((BYTE)alarm_date[2] != -1))
		{
			SchedulerRepeatFindDate(repeat_rec_id, alarm_date, today, next_alarm_date, FALSE);
			if (SchedulerCompareDate(next_alarm_date, date) == 1)
			{
				do
				{
					test_date[i] = next_alarm_date[i];
					next_alarm_date[i] = 0;
					i++;
				}while (i <= 2);
				reset_alarm = TRUE;
			}
		}
	}
	qfree(alarm_date);
	
	//Find the corresponding exception record
	if (DataFindBinRecord(sch_except_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id) != TRUE)
	{
		repeat_settings.exception = 1;
		DataWriteField(sch_repeat_dbid, repeat_rec_id, F_EXCEPT_FLAG, 1, (BYTE*)&repeat_settings.exception);
		new_record = TRUE;
	}
	else new_record = FALSE;
	
	DataCloseRecord(sch_repeat_dbid, repeat_rec_id);
	
	if (new_record)
	{
		DataNewRecord(sch_except_dbid, 0, 2, &rec_id);
		DataWriteField(sch_except_dbid, rec_id, F_REPEAT_NUM, sizeof(UWORD), (BYTE*)&repeat_no);
		DataWriteField(sch_except_dbid, rec_id, F_EXCEPT_DATE, 4, (BYTE*)&date);
		DataCloseRecord(sch_except_dbid, rec_id);
	}
	else
	{
		DataRecIDtoNum(sch_except_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_except_dbid, rec_num, &rec_id, NULL);
		DataGetField(sch_except_dbid, rec_id, F_EXCEPT_DATE, &buffer, &byte_read);
		num_length = (SHORT)byte_read;
		temp = (BYTE*)qmalloc((num_length)*sizeof(BYTE));
		for(i = 0; i < num_length; i++)
			temp[i] = buffer[i];
		count = 0;
		for(i = num_length - 1; i < num_length + 3; i++)
		{
			temp[i] = date[count];
			count++;
		}
		DataWriteField(sch_except_dbid, rec_id, F_EXCEPT_DATE, (num_length + 3), temp);
		DataCloseRecord(sch_except_dbid, rec_id);
	}
	virtual_table.vt_items[virtual_table.vt_active_row]->repeat = FALSE;
	virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num = 0;
	virtual_table.vt_items[virtual_table.vt_active_row]->repeat_every_info = 0;
	virtual_table.vt_items[virtual_table.vt_active_row]->repeat_every_data = 0;
	virtual_table.vt_items[virtual_table.vt_active_row]->repeat_method = 255;
	if (prev_status == DELETE_STATUS)
	{
		virtual_table.vt_items[virtual_table.vt_active_row]->alarm = 0;
		virtual_table.vt_items[virtual_table.vt_active_row]->alarm_num = 0;
		virtual_table.vt_items[virtual_table.vt_active_row]->alarm_time = 0;
	}
	if (prev_status != ALARM_SET_STATUS && prev_status != ALARM_CHANGE_STATUS && prev_status != TIME_STATUS)
	{
		strcpy(virtual_table.vt_items[virtual_table.vt_active_row]->ptr->field_string, "");
		virtual_table.vt_items[virtual_table.vt_active_row]->appointment = -1;
		virtual_table.vt_active_row = -1;
	}
	SchedulerDayViewSaveAppmtData(&virtual_table, date);
	
	if (reset_alarm)
	{
		DataRecIDtoNum(sch_repeat_dbid, repeat_rec_id, &repeat_rec_num);
		DataOpenRecord(sch_repeat_dbid, repeat_rec_num, &repeat_rec_id, NULL);
		SchedulerRepeatFindDate(repeat_rec_id, test_date, date, next_alarm_date, FALSE);
		DataCloseRecord(sch_repeat_dbid, repeat_rec_id);
		if (SchedulerFindNextAppmtAlarmDate(date, appmt_alarm_date))
		{
			if (SchedulerCompareDate(next_alarm_date, appmt_alarm_date) <= 1)
				SchedulerSetAppmtWholeDayAlarm(appmt_alarm_date);
			else
				SchedulerSetAppmtWholeDayAlarm(next_alarm_date);
		}
		else SchedulerSetAppmtWholeDayAlarm(next_alarm_date);
	}
	else
	{
		if (SchedulerCheckEarliestDayWithAlarm(date) == TRUE)
			SchedulerSetAppmtWholeDayAlarm(date);
	}
	return;
}

/********************************************************
* Function:	SchedulerDeleteRepeatDB
* Purpose: 	This function is called to delete the repeat database
* Scope:	application/internal
* Input:	repeat_num	the repeat number of the repeat record
*		delete_all	A flag to indicate whether delete the whole
*				DB or just save exception
* Output:	None
* Return:	TRUE - no error
*		FALSE - error
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerDeleteRepeatDB(UWORD repeat_num, BOOLEAN delete_all)
{
	BYTE repeat_no[5], *buffer, exception;
	RecordID rec_id, voice_recid;
	WORD active_row, appointment;
	UWORD rec_num, voice_rec_num, byte_read, voice_count;
	SHORT i;
	Err error;
	AlarmAttr *alarm_attr;
	
	*(UWORD*)repeat_no = repeat_num;
	repeat_no[4] = 0;
	if (DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id) != TRUE)
		return FALSE;
	
	DataRecIDtoNum(sch_repeat_dbid, rec_id, &rec_num);
	DataOpenRecord(sch_repeat_dbid, rec_num, &rec_id, NULL);
	DataGetField(sch_repeat_dbid, rec_id, F_EXCEPT_FLAG, &buffer, &byte_read);
	exception = *buffer;
	qfree(buffer);
	DataGetField(sch_repeat_dbid, rec_id, F_ALARM_SETTINGS, (BYTE**)&alarm_attr, &byte_read);
	if (alarm_attr->type == VOICE_ALARM)
	{
		DataGetField(sch_repeat_dbid, rec_id, F_VOICE_RECID, &buffer, &byte_read);
		voice_recid = *((UWORD*)buffer);
		qfree(buffer);
		DataRecIDtoNum(sch_voice_dbid, voice_recid, &voice_rec_num);
		DataOpenRecord(sch_voice_dbid, voice_rec_num, &voice_recid, NULL);
		DataGetField(sch_voice_dbid, voice_recid, 2, &buffer, &byte_read);
		voice_count = *((UWORD*)buffer);
		qfree(buffer);
		if (voice_count == 1)
		{
			DataCloseRecord(sch_voice_dbid, voice_recid);
			DataDeleteRecord(sch_voice_dbid, voice_recid, FALSE);
		}
		else
		{
			voice_count--;
			DataOpenRecord(sch_voice_dbid, voice_rec_num, &voice_recid, NULL);
			DataWriteField(sch_voice_dbid, voice_recid, 2, sizeof(UWORD), (BYTE*)&voice_count);
			DataCloseRecord(sch_voice_dbid, voice_recid);
		}
	}
	qfree(alarm_attr);
	//end 310100
	DataCloseRecord(sch_repeat_dbid, rec_id);
	error = DataDeleteRecord(sch_repeat_dbid, rec_id, FALSE);
	active_row = virtual_table.vt_active_row;
	appointment = virtual_table.vt_items[active_row]->appointment;
	virtual_table.vt_items[active_row]->repeat = FALSE;
	virtual_table.vt_items[active_row]->repeat_num = 0;
	virtual_table.vt_items[active_row]->repeat_every_data = 0;
	virtual_table.vt_items[active_row]->repeat_every_info = 0;
	virtual_table.vt_items[active_row]->repeat_method = 255;
	virtual_table.vt_items[active_row]->alarm = 0;
	virtual_table.vt_items[active_row]->alarm_time = 0;
	virtual_table.vt_items[active_row]->alarm_num = 0;
	if (delete_all)
	{
		if (exception == 1)
		{
			DataFindBinRecord(sch_except_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id);
			DataRecIDtoNum(sch_except_dbid, rec_id, &rec_num);
			DataOpenRecord(sch_except_dbid, rec_num, &rec_id, NULL);
			DataCloseRecord(sch_except_dbid, rec_id);
			DataDeleteRecord(sch_except_dbid, rec_id, FALSE);
		}
		strcpy(virtual_table.vt_items[active_row]->ptr->field_string, (BYTE*)"");
		virtual_table.vt_items[active_row]->appointment = -1;
		virtual_table.vt_active_row = -1;
	}
	return TRUE;
}

/********************************************************
* Function:	SchedulerConvertBYTEtoSHORT
* Purpose: 	This function is called to save a short number to a byte pointer
* Scope:	application/internal
* Input:	byte_ptr	A byte pointer used for saving
*		number		A short number used to save to byte pointer
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerConvertBYTEtoSHORT(BYTE *byte_ptr, SHORT number)
{
	*byte_ptr = *(BYTE*)&number;
	*(byte_ptr+1) = *(BYTE*)(((BYTE*)&number)+1);
	return;
}

/********************************************************
* Function:	SchedulerConvertBYTEtoUWORD
* Purpose: 	This function is called to save a uword number to a
*		byte pointer or reverse the case
* Scope:	application/internal
* Input:	byte_ptr	A byte pointer
*		number		A uword number
*		forward		indicate the direction for saving
*				(TRUE - save a uword number to pointer)
*				(FALSE - put the content in byte pointer to uword number)
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerConvertBYTEtoUWORD(BYTE *byte_ptr, UWORD *number, BOOLEAN forward)
{
	if (forward == TRUE)
	{
		*byte_ptr = *(BYTE*)&number;
		*(byte_ptr+1) = *(BYTE*)(((BYTE*)&number)+1);
		*(byte_ptr+2) = *(BYTE*)(((BYTE*)&number)+2);
		*(byte_ptr+3) = *(BYTE*)(((BYTE*)&number)+3);
	}
	else
	{
		*(BYTE*)number = *byte_ptr;
		*(BYTE*)(((BYTE*)number)+1) = *(byte_ptr+1);
		*(BYTE*)(((BYTE*)number)+2) = *(byte_ptr+2);
		*(BYTE*)(((BYTE*)number)+3) = *(byte_ptr+3);
	}
	return;
}
