/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   schtime.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

extern BYTE     hour_difference;
extern BYTE     minute_difference;

/********************************************************
* Function:	SchedulerTimeSettingsSetScreen
* Purpose: 	This function is called to set the screen
layout of FORM_SCH_TIME_SETTINGS
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	This function is called whenever the screen 
is required to re-setup again when something happens
*********************************************************/
void SchedulerTimeSettingsSetScreen()
{
	CountrySettings country;
	String *string_ptr, *string_ptr1;
	BYTE object_type;
	BYTE time[10];
    Form *form_ptr;
	
    if (FormGetObjectPointer(FORM_SCH_TIME_SETTINGS, &object_type, (void**)&form_ptr) != TRUE)
        FormInitAllFormObjects(FORM_SCH_TIME_SETTINGS);
	
	SySetupGetCountrySettings(&country);
	
	FormGetObjectPointer(STRING_SCH_TIME_1, &object_type, (void**)&string_ptr);
	FormGetObjectPointer(STRING_SCH_TIME_3, &object_type, (void**)&string_ptr1);
	
	if (country.time_fmt == SYSETUP_12HR_DISPLAY)
	{	
		ListInitList(LIST_SCH_TIME_HOUR_1);
		ListDeleteItem(LIST_SCH_TIME_HOUR_0, 0);
		ListInsertItem(LIST_SCH_TIME_HOUR_0, 0, SCHSTR1);
	}
	else
	{
		ListDeleteItem(LIST_SCH_TIME_HOUR_0, 0);
		ListInsertItem(LIST_SCH_TIME_HOUR_0, 0, (BYTE*)("00"));
		ListDeleteAllItems(LIST_SCH_TIME_HOUR_1);
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 0, (BYTE*)("12"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 1, (BYTE*)("13"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 2, (BYTE*)("14"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 3, (BYTE*)("15"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 4, (BYTE*)("16"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 5, (BYTE*)("17"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 6, (BYTE*)("18"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 7, (BYTE*)("19"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 8, (BYTE*)("20"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 9, (BYTE*)("21"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 10, (BYTE*)("22"));
		ListInsertItem(LIST_SCH_TIME_HOUR_1, 11, (BYTE*)("23"));
	}
	
	if (time_settings.new_appointment == TRUE && time_settings.new_appointment_with_time == FALSE)
	{
		SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_1, -1, -1);
		StringSetText(STRING_SCH_TIME_3, (BYTE*)(""));
		time_settings.hour_start = -1;
		time_settings.hour_end = -1;
		time_settings.minute_start = -1;
		time_settings.minute_end = -1;
		time_settings.alarm = NO_ALARM;
		time_settings.alarm_time = NO_ALARM;
		time_settings.alarm_num = 0;
		time_settings.dbid = 0;
		time_settings.recid = 0;
		
		time_settings.row_num = -1;
		
		string_ptr->string_color = COLOR_BLACK;
		string_ptr->string_bg_color = COLOR_WHITE;
		string_ptr1->string_color = COLOR_BLACK;
		string_ptr1->string_bg_color = COLOR_WHITE;
	}
	else if ((time_settings.new_appointment == TRUE && time_settings.new_appointment_with_time == TRUE) ||
		(time_settings.new_appointment == FALSE && time_settings.new_appointment_with_time == TRUE))
	{
		SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_1, time_settings.hour_start, time_settings.minute_start);
		if (time_settings.hour_end == -1 || time_settings.minute_end == -1)
		{
			if (time_settings.hour_start == 23)
			{
				time_settings.hour_end = 23;
				time_settings.minute_end = 55;
			}
			else
			{
				time_settings.hour_end = time_settings.hour_start + 1;
				time_settings.minute_end = time_settings.minute_start;
			}
		}
		SchedulerHourMinuteToString(time_settings.hour_end, time_settings.minute_end, time, TRUE);
		StringSetText(STRING_SCH_TIME_3, time);
		string_ptr->string_color = COLOR_WHITE;
		string_ptr->string_bg_color = COLOR_BLACK;
		string_ptr1->string_color = COLOR_BLACK;
		string_ptr1->string_bg_color = COLOR_WHITE;
	}
}

/********************************************************
* Function:	SchedulerListSelectToTimeSettingsScreen
* Purpose: 	This function is called to handle the actions 
taken when an item in the list is changed
* Scope:		application/internal
* Input:		Event			the pointer to an EVT_LIST_SELECT
* Output:		None
* Return:		None
* Comment: 	This function is called whenever the screen 
is required to re-setup again when something happens
*********************************************************/
void SchedulerListSelectToTimeSettingsScreen(EvtType *Event)
{
	BYTE 		hour = 0, hour1 = 0, hour2 = 0;
	BYTE 		minute = 0, minute1 = 0, minute2 = 0;
	String 		*string_ptr, *string_ptr1;
	BYTE 		object_type;
    BYTE 		time[10], am_pm, difference = 0;
	
	SHORT 		list_selected_item_hour_0;
	SHORT 		list_selected_item_hour_1;
	SHORT 		list_selected_item_min;
	
	BOOLEAN 	string_0_highlight = FALSE;
	BOOLEAN 	string_1_highlight = FALSE;
    BOOLEAN 	change = TRUE;
	
	CountrySettings country;
	
	BYTE *string;
	
	if (Event->para1 == -1)
		return;
	
	ListGetSelectedItem(LIST_SCH_TIME_HOUR_0, &list_selected_item_hour_0);
	ListGetSelectedItem(LIST_SCH_TIME_HOUR_1, &list_selected_item_hour_1);
	ListGetSelectedItem(LIST_SCH_TIME_MIN, &list_selected_item_min);
	
	FormGetObjectPointer(STRING_SCH_TIME_1, &object_type, (void**)&string_ptr);
	FormGetObjectPointer(STRING_SCH_TIME_3, &object_type, (void**)&string_ptr1);
	SySetupGetCountrySettings(&country);
	
	if ((Event->eventID == LIST_SCH_TIME_HOUR_0 ||
		Event->eventID == LIST_SCH_TIME_HOUR_1) &&
		list_selected_item_min == -1)
		ListSetSelectedItem(LIST_SCH_TIME_MIN, 0);
	
	if (list_selected_item_hour_0 != -1)
		hour = (BYTE)(list_selected_item_hour_0);
	else hour = (BYTE)(list_selected_item_hour_1 + 12);
	if (list_selected_item_min == -1)
		list_selected_item_min = 0;
	minute = (BYTE)(list_selected_item_min * 5);
	
	if (string_ptr->string_color == COLOR_WHITE)
		string_0_highlight = TRUE;
	if (string_ptr1->string_color == COLOR_WHITE)
		string_1_highlight = TRUE;
	
	if (string_0_highlight || (string_0_highlight == FALSE && string_1_highlight == FALSE))
	{	
		SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_1, hour, minute);
		StringDrawString(STRING_SCH_TIME_1);		
		
		hour += hour_difference;
		minute += minute_difference;
		if (minute >= 60)
		{
			hour ++;
			minute = minute - 60;
		}			
		
		if (hour > 23)
		{
			hour = 23;
			minute = 55;
		}					
		
		SchedulerHourMinuteToString(hour, minute, time, TRUE);
		StringSetText(STRING_SCH_TIME_3, time);
        StringDrawString(STRING_SCH_TIME_3);
    }
    else
    {       
        StringGetText(STRING_SCH_TIME_1, &string);
		SchedulerTimeSettingsStringToHourMinute(string, &hour1, &minute1, &am_pm);
        
        if ((hour < hour1) || (hour == hour1 && minute < minute1))
        {
			hour = hour1;
			minute = minute1;
        }
        
        SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_3, hour, minute);
        StringDrawString(STRING_SCH_TIME_3);    	
		
		hour_difference = hour - hour1;
		minute_difference = minute - minute1;
		if (minute_difference < 0)
		{
            minute_difference = 60 + minute_difference;
			hour_difference --;
		}			   			
    }   
}

/********************************************************
* Function:	SchedulerPenDownOnString
* Purpose: 	This function is called to change the color/highlight
of STRING_SCH_TIME_1 or STRING_SCH_TIME_3
* Scope:		application/internal
* Input:		Event
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerPenDownOnString(EvtType *Event)
{
	String *string_ptr, *string_ptr1;
	BYTE object_type;
	BOOLEAN on = FALSE, first = FALSE;
	List *list_hour_0;
	List *list_hour_1;
	List *list_min;
	CountrySettings country;
	BYTE *string;
	BYTE hour, minute, am_pm;
	
	if (Event->eventID != PEN_DOWN)
		return;
	
	FormGetObjectPointer(STRING_SCH_TIME_1, &object_type, (void**)&string_ptr);
	FormGetObjectPointer(STRING_SCH_TIME_3, &object_type, (void**)&string_ptr1);	
	FormGetObjectPointer(LIST_SCH_TIME_HOUR_0, &object_type, (void**)&list_hour_0);	
	FormGetObjectPointer(LIST_SCH_TIME_HOUR_1, &object_type, (void**)&list_hour_1);	
	FormGetObjectPointer(LIST_SCH_TIME_MIN, &object_type, (void**)&list_min);	
	SySetupGetCountrySettings(&country);
	
	if (Event->para1 >= string_ptr->bounds.xcoord &&
		Event->para1 < (string_ptr->bounds.xcoord + string_ptr->bounds.width) &&
		Event->para2 >= string_ptr->bounds.ycoord &&
		Event->para2 < (string_ptr->bounds.ycoord + string_ptr->bounds.height) &&
		string_ptr->string_color != COLOR_WHITE)
	{
		string_ptr->string_color = COLOR_WHITE;
		string_ptr->string_bg_color = COLOR_BLACK;
		string_ptr1->string_color = COLOR_BLACK;
		string_ptr1->string_bg_color = COLOR_WHITE;
		on = TRUE;
		StringGetText(STRING_SCH_TIME_1, &string);		
		SchedulerTimeSettingsStringToHourMinute(string, &hour, &minute, &am_pm);
		SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_1, hour, minute);
		if (hour == -1 && minute == -1)
		{
			hour = 8;
			minute = 0;
			SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_1, hour, minute);
			if (country.time_fmt == SYSETUP_12HR_DISPLAY)
				StringSetText(STRING_SCH_TIME_3, SCHSTR2);
			else
				StringSetText(STRING_SCH_TIME_3, (BYTE*)("9:00"));
		}
		else SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_1, hour, minute);
	}
	else if (Event->para1 >= string_ptr1->bounds.xcoord &&
		Event->para1 < (string_ptr1->bounds.xcoord + string_ptr1->bounds.width) &&
		Event->para2 >= string_ptr1->bounds.ycoord &&
		Event->para2 < (string_ptr1->bounds.ycoord + string_ptr1->bounds.height) &&
		string_ptr1->string_color != COLOR_WHITE)
	{
		string_ptr1->string_color = COLOR_WHITE;
		string_ptr1->string_bg_color = COLOR_BLACK;
		string_ptr->string_color = COLOR_BLACK;
		string_ptr->string_bg_color = COLOR_WHITE;
		on = TRUE;
		StringGetText(STRING_SCH_TIME_3, &string);		
		SchedulerTimeSettingsStringToHourMinute(string, &hour, &minute, &am_pm);
		SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_3, hour, minute);
		if (hour == -1 && minute == -1)
		{
			hour = 9;
			minute = 0;
			SchedulerTimeSettingsSetStringList(STRING_SCH_TIME_3, hour, minute);
			if (country.time_fmt == SYSETUP_12HR_DISPLAY)
				StringSetText(STRING_SCH_TIME_1, SCHSTR3);
			else
				StringSetText(STRING_SCH_TIME_1, (BYTE*)("8:00"));
		}
	}
	if (on)
	{
		StringDrawString(STRING_SCH_TIME_1);
		StringDrawString(STRING_SCH_TIME_3);
		ListDrawList(LIST_SCH_TIME_HOUR_0);
		ListDrawList(LIST_SCH_TIME_HOUR_1);
		ListDrawList(LIST_SCH_TIME_MIN);
#ifdef PR31700
		SndPlaySndEffect(SNDRES5_BEEP);
#endif
	}
}

/********************************************************
* Function:	SchedulerTiemSettingsStringToHourMinute
* Purpose: 	This function is called convert string
to hour and minute
* Scope:		application/internal
* Input:		string			
* Output:		hour
minute
am_pm
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerTimeSettingsStringToHourMinute(BYTE *string, BYTE *hour, BYTE *minute, BYTE *am_pm)
{
	CountrySettings country;
	BYTE temp_string[10];
	WORD temp;
	USHORT count;
	
	if (strlen(string) == 0)
	{
		*hour = -1;
		*minute = -1;
		*am_pm = AM;
		return;
	}
	SySetupGetCountrySettings(&country);
	strcpy(temp_string, string);
	if (country.time_fmt == SYSETUP_12HR_DISPLAY)
	{
		if (temp_string[strlen(string) - 2] == 'a')
			*am_pm = AM;
		else *am_pm = PM;
		temp_string[strlen(string) - 3] = '\0';
	}
	
	for (count = 0; count < strlen(string); count++)
	{
		if (temp_string[count] == ':')
			temp_string[count] = '\0';
	}
	temp = atol((char*)temp_string);
	if (temp == 12 && *am_pm == AM && country.time_fmt == SYSETUP_12HR_DISPLAY)
		*hour = 0;
	else *hour = (BYTE)temp;
	temp = atol((char*)(temp_string + strlen(temp_string) + 1));
	*minute = (BYTE)temp;
	
	if (country.time_fmt == SYSETUP_12HR_DISPLAY)
	{
		if (*am_pm == PM && *hour >= 1 && *hour <= 11)
			*hour += 12;
	}
	else
	{
		if (*hour >= 12)
			*am_pm = PM;
		else *am_pm = AM;
	}
}

/********************************************************
* Function:	SchedulerTimeSettingsSetStringList
* Purpose: 	This function is called to set the text of string and the selected item 
in the list objects	
* Scope:		application/internal
* Input:		string_id
hour
minute
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerTimeSettingsSetStringList(ObjectID string_id, BYTE hour, BYTE minute)
{
	BYTE am_pm;
	BYTE string[10];
	
	SchedulerHourMinuteToString(hour, minute, string, TRUE);
	StringSetText(string_id, string);
	if (strlen(string) != 0)
	{
		SchedulerTimeSettingsStringToHourMinute(string, &hour, &minute, &am_pm);
		if (hour < 12)
		{
			ListSetSelectedItem(LIST_SCH_TIME_HOUR_0, (SHORT)hour);
			ListSetHighlightedItem(LIST_SCH_TIME_HOUR_0, (SHORT)hour);
			ListSetSelectedItem(LIST_SCH_TIME_HOUR_1, -1);
			ListSetHighlightedItem(LIST_SCH_TIME_HOUR_1, -1);
		}
		else
		{
			ListSetSelectedItem(LIST_SCH_TIME_HOUR_0, -1);
			ListSetHighlightedItem(LIST_SCH_TIME_HOUR_0, -1);
			if (hour >= 12)
				hour -= 12;
			ListSetSelectedItem(LIST_SCH_TIME_HOUR_1, (SHORT)hour);
			ListSetHighlightedItem(LIST_SCH_TIME_HOUR_1, (SHORT)hour);
		}
		minute = minute / 5;
		ListSetSelectedItem(LIST_SCH_TIME_MIN, (SHORT)minute);
		ListSetHighlightedItem(LIST_SCH_TIME_MIN, (SHORT)minute);
	}
	else
	{
		ListSetSelectedItem(LIST_SCH_TIME_HOUR_0, -1);
		ListSetHighlightedItem(LIST_SCH_TIME_HOUR_0, -1);
		ListSetSelectedItem(LIST_SCH_TIME_HOUR_1, -1);
		ListSetHighlightedItem(LIST_SCH_TIME_HOUR_1, -1);
		ListSetSelectedItem(LIST_SCH_TIME_MIN, -1);
		ListSetHighlightedItem(LIST_SCH_TIME_MIN, -1);
	}
    ListDrawList(LIST_SCH_TIME_HOUR_0);
    ListDrawList(LIST_SCH_TIME_HOUR_1);
    ListDrawList(LIST_SCH_TIME_MIN);
}

/********************************************************
* Function:	SchedulerTimeSettingsExit
* Purpose: 	This function is called to set up the screen and 
the virtual table while EXIT button in the inlay 
is pressed
* Scope:		application/internal
* Input:		vt				The pointer to virtual object table
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerTimeSettingsExit(VirtualTable *vt)
{
	//Bug Fixed 5-Feb-2001
	//Setup DayView appointment
	//--------------------------------------------- Adding Codes
	SchedulerTimeSettingsDeleteAllEmptyAppmts(vt);
	SchedulerTimeSettingsAddAppmts(vt);
	//--------------------------------------------- Adding Codes
	FormPopupForm(FORM_SCH_DAY_VIEW);
}

/********************************************************
* Function:	SchedulerTimeSettingsOK
* Purpose: 	This function is called to set up the screen and 
the virtual table while OK button in the inlay 
is pressed
* Scope:		application/internal
* Input:		vt				The pointer to virtual object table
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerTimeSettingsOK(VirtualTable *vt)
{
	BYTE status = 0;
	USHORT count = 0;
	BYTE *string_start, *string_end;
	BYTE hour_start, minute_start, am_pm_start;
	BYTE hour_end, minute_end, am_pm_end;
	USHORT *row_num;
	USHORT num_rows;
	WORD target_row_num_0 = -1, target_row_num_1 = -1;
	BOOLEAN output;
	BYTE time[10];
	BYTE *temp_field_string_0, *temp_field_string_1;
	USHORT start_row, end_row;
	BOOLEAN start_deleted, end_deleted;
	UBYTE date[4];
	AlarmEvent evtAlarm;
	RecordID rec_id;
	UWORD rec_num, byte_read;
	BYTE *buffer;
	AppointmentDB *appmt_rec;
	WORD num_appmt;
	WORD row_number;
	WORD active_row, active_next_row;
	UWORD   temp_appmt_num;
	
	evtAlarm.type = 0;
	StringGetText(STRING_SCH_TIME_1, &string_start);
	StringGetText(STRING_SCH_TIME_3, &string_end);
	SchedulerTimeSettingsStringToHourMinute(string_start, &hour_start, &minute_start, &am_pm_start);
	SchedulerTimeSettingsStringToHourMinute(string_end, &hour_end, &minute_end, &am_pm_end);
	
	if (strlen(string_start) == 0 && strlen(string_end) == 0)
	{
		if (prev_status != TIME_STATUS)
			FormPopupForm(FORM_SCH_DAY_VIEW);
		return;
	}
	
	if ((time_settings.new_appointment == FALSE &&
		time_settings.new_appointment_with_time == TRUE &&
		vt->vt_items[time_settings.row_num]->appointment == -1) ||
		(time_settings.new_appointment == TRUE &&
		time_settings.new_appointment_with_time == FALSE))
	{
		time_settings.dbid = sch_voice_dbid;
		time_settings.recid = 0;
		
		new_appointment = TRUE;
		output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
			&end_row, &start_deleted, &end_deleted);
		output = SchedulerDayViewFindRowNum(vt, hour_start, minute_start, &row_num, &num_rows);
		if (output == TRUE)
		{
			for (count = 0; count < num_rows; count++)
			{
				if (virtual_table.vt_items[row_num[count]]->appointment == -1)
				{
					target_row_num_0 = row_num[count];
					break;
				}
			}
			if (target_row_num_0 == -1)
			{
				target_row_num_0 = row_num[num_rows - 1] + 1;
				SchedulerHourMinuteToString(hour_start,  minute_start, time, FALSE);
				VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_start, minute_start, time_settings.alarm,
					time_settings.alarm_time, time_settings.alarm_num, -1, 0, FALSE,
					0, 255, 0, 0, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
			}
		}
		else
		{
			target_row_num_0 = row_num[num_rows - 1];
			SchedulerHourMinuteToString(hour_start,  minute_start, time, FALSE);
			VTInsertRow(vt, row_num[num_rows - 1], hour_start, minute_start, time_settings.alarm, 
				time_settings.alarm_time, time_settings.alarm_num, -1, 0, FALSE,
				0, 255, 0, 0, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
		}
		qfree(row_num);
		output = SchedulerDayViewFindRowNum(vt, hour_end, minute_end, &row_num, &num_rows);
		if (output == TRUE)
		{
			for (count = 0; count < num_rows; count++)
			{
				if (row_num[count] > target_row_num_0)
				{
					target_row_num_1 = row_num[count];
					break;
				}
			}
			if (target_row_num_1 == -1)
			{
				target_row_num_1 = row_num[num_rows - 1] + 1;
				SchedulerHourMinuteToString(hour_end,  minute_end, time, FALSE);
				VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_end, minute_end, NO_ALARM, 
					NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, time_settings.dbid,
					time_settings.recid, time, (BYTE*)(""));
			}
		}
		else
		{
			target_row_num_1 = row_num[num_rows - 1];
			SchedulerHourMinuteToString(hour_end,  minute_end, time, FALSE);
			VTInsertRow(vt, row_num[num_rows - 1], hour_end, minute_end, NO_ALARM, 
				NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, time_settings.dbid,
				time_settings.recid, time, (BYTE*)(""));
		}
		qfree(row_num);
		vt->vt_active_row = (USHORT)target_row_num_0;
		vt->vt_items[target_row_num_0]->appointment = target_row_num_1;
		if (target_row_num_0 < vt->vt_top_row_num)
			vt->vt_top_row_num = (USHORT)target_row_num_0;
		else if (target_row_num_0 >= (vt->vt_top_row_num + vt->vt_num_rows_displayed))
			vt->vt_top_row_num += 2;
		new_appointment = TRUE;
		SchedulerTimeSettingsDeleteAllEmptyAppmts(vt);
		SchedulerTimeSettingsAddAppmts(vt);
		if (prev_status != TIME_STATUS)
			FormPopupForm(FORM_SCH_DAY_VIEW);
		return;
	}
	else if (time_settings.new_appointment == TRUE &&
		time_settings.new_appointment_with_time == TRUE)
	{
		if (time_settings.hour_start != hour_start || time_settings.minute_start != minute_start ||
			time_settings.hour_end != hour_end || time_settings.minute_end != minute_end)
			output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
			&end_row, &start_deleted, &end_deleted);
		
		else
		{
			vt->vt_items[time_settings.row_num]->alarm = time_settings.alarm;
			vt->vt_items[time_settings.row_num]->alarm_time = time_settings.alarm_time;
			vt->vt_items[time_settings.row_num]->alarm_num = time_settings.alarm_num;
			if (prev_status != TIME_STATUS)
				FormPopupForm(FORM_SCH_DAY_VIEW);
			return;
		}
		
		new_appointment = TRUE;
		output = SchedulerDayViewFindRowNum(vt, hour_start, minute_start, &row_num, &num_rows);
		if (output == TRUE)
		{
			for (count = 0; count < num_rows; count++)
			{
				if (virtual_table.vt_items[row_num[count]]->appointment == -1)
				{
					target_row_num_0 = row_num[count];
					break;
				}
			}
			if (target_row_num_0 == -1)
			{
				target_row_num_0 = row_num[num_rows - 1] + 1;
				SchedulerHourMinuteToString(hour_start,  minute_start, time, FALSE);
				if (prev_status != TIME_STATUS)
					VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_start, minute_start, time_settings.alarm, 
					time_settings.alarm_time, time_settings.alarm_num, -1, 0, FALSE, 0, 255,
					0, 0, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
				else VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_start, minute_start, time_settings.alarm, 
					time_settings.alarm_time, time_settings.alarm_num, -1, 0, TRUE,
					repeat_settings.repeat_num, repeat_settings.method, repeat_settings.every_info,
					repeat_settings.every_data, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
			}
		}
		else
		{
			target_row_num_0 = row_num[num_rows - 1];
			SchedulerHourMinuteToString(hour_start,  minute_start, time, FALSE);
			if (prev_status != TIME_STATUS)
				VTInsertRow(vt, row_num[num_rows - 1], hour_start, minute_start, time_settings.alarm, 
				time_settings.alarm_time, time_settings.alarm_num, -1, 0, FALSE, 0, 255,
				0, 0, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
			else VTInsertRow(vt, row_num[num_rows - 1], hour_start, minute_start, time_settings.alarm, 
				time_settings.alarm_time, time_settings.alarm_num, -1, 0, TRUE,
				repeat_settings.repeat_num, repeat_settings.method, repeat_settings.every_info,
				repeat_settings.every_data, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
		}
		qfree(row_num);
		output = SchedulerDayViewFindRowNum(vt, hour_end, minute_end, &row_num, &num_rows);
		if (output == TRUE)
		{
			for (count = 0; count < num_rows; count++)
			{
				if (row_num[count] > target_row_num_0)
				{
					target_row_num_1 = row_num[count];
					break;
				}
			}
			if (target_row_num_1 == -1)
			{
				target_row_num_1 = row_num[num_rows - 1] + 1;
				SchedulerHourMinuteToString(hour_end,  minute_end, time, FALSE);
				VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_end, minute_end, NO_ALARM, 
					NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, 0, 0, time, (BYTE*)(""));
			}
		}
		else
		{
			target_row_num_1 = row_num[num_rows - 1];
			SchedulerHourMinuteToString(hour_end,  minute_end, time, FALSE);
			VTInsertRow(vt, row_num[num_rows - 1], hour_end, minute_end, NO_ALARM, 
				NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, 0, 0, time, (BYTE*)(""));
		}
		qfree(row_num);
		vt->vt_active_row = target_row_num_0;
		vt->vt_items[target_row_num_0]->appointment = target_row_num_1;
		if (target_row_num_0 < vt->vt_top_row_num)
			vt->vt_top_row_num = (USHORT)(target_row_num_0);
		else if (target_row_num_0 >= (vt->vt_top_row_num + vt->vt_num_rows_displayed))
			vt->vt_top_row_num += 2;
		SchedulerTimeSettingsDeleteAllEmptyAppmts(vt);
		SchedulerTimeSettingsAddAppmts(vt);
		if (prev_status != TIME_STATUS)
			FormPopupForm(FORM_SCH_DAY_VIEW);
		return;
	}
	else if (time_settings.new_appointment == FALSE &&
		time_settings.new_appointment_with_time == TRUE &&
		vt->vt_items[time_settings.row_num]->appointment != -1)
	{
	/* this case requires the transfer of field data and alarm data to 
		different time slot*/
		temp_appmt_num = vt->vt_items[time_settings.row_num]->appmt_num;
		vt->vt_items[time_settings.row_num]->appmt_num = 0;
		VTGetFieldTextPointer(vt, (USHORT)time_settings.row_num, &temp_field_string_0);
		temp_field_string_1 = (BYTE*)qmalloc((strlen(temp_field_string_0) + 1) * sizeof (BYTE));
		strcpy(temp_field_string_1, temp_field_string_0);
		
		/* setting up the environment */
		if (time_settings.hour_start != hour_start || time_settings.minute_start != minute_start ||
			time_settings.hour_end != hour_end || time_settings.minute_end != minute_end)
		{	
			vt->vt_active_row = time_settings.row_num;
			new_appointment = TRUE;
			output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
				&end_row, &start_deleted, &end_deleted);
			if (output == VT_TABLE_NOT_CHANGED)
			{
				vt->vt_items[vt->vt_active_row]->appointment = -1;
				strcpy(vt->vt_items[vt->vt_active_row]->ptr->field_string, (BYTE*)(""));
				if (vt->vt_items[vt->vt_active_row]->repeat)
					vt->vt_items[vt->vt_active_row]->repeat = FALSE;
				//Bug Fixed 5-Feb-2001
				//Clear the row
				vt->vt_items[vt->vt_active_row]->alarm = NO_ALARM;
			}
		}
		else
		{
			vt->vt_items[time_settings.row_num]->alarm = time_settings.alarm;
			vt->vt_items[time_settings.row_num]->alarm_time = time_settings.alarm_time;
			vt->vt_items[time_settings.row_num]->alarm_num = time_settings.alarm_num;
			if (prev_status != TIME_STATUS)
				FormPopupForm(FORM_SCH_DAY_VIEW);
			qfree(temp_field_string_1);
			return;
		}
		
		new_appointment = TRUE;
		output = SchedulerDayViewFindRowNum(vt, hour_start, minute_start, &row_num, &num_rows);
		if (output == TRUE)
		{
			for (count = 0; count < num_rows; count++)
			{
				if (virtual_table.vt_items[row_num[count]]->appointment == -1)
				{
					target_row_num_0 = row_num[count];
					break;
				}
			}
			if (target_row_num_0 == -1)
			{
				target_row_num_0 = row_num[num_rows - 1] + 1;
				SchedulerHourMinuteToString(hour_start,  minute_start, time, FALSE);
				if (prev_status != TIME_STATUS)
					VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_start, minute_start, time_settings.alarm, 
					time_settings.alarm_time, time_settings.alarm_num, -1, 0, FALSE, 0, 255,
					0, 0, time_settings.dbid, time_settings.recid, time, temp_field_string_1);
				else VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_start, minute_start, repeat_settings.alarm, 
					repeat_settings.alarm_time, repeat_settings.alarm_num, -1, 0, TRUE, 
					repeat_settings.repeat_num, repeat_settings.method, repeat_settings.every_info,
					repeat_settings.every_data, time_settings.dbid, time_settings.recid, time, temp_field_string_1);
			}
		}
		else
		{
			target_row_num_0 = row_num[num_rows - 1];
			SchedulerHourMinuteToString(hour_start,  minute_start, time, FALSE);
			if (prev_status != TIME_STATUS)
				VTInsertRow(vt, row_num[num_rows - 1], hour_start, minute_start, time_settings.alarm, 
				time_settings.alarm_time, time_settings.alarm_num, -1, 0, FALSE, 0, 255,
				0, 0, time_settings.dbid, time_settings.recid, time, temp_field_string_1);
			else VTInsertRow(vt, row_num[num_rows - 1], hour_start, minute_start, repeat_settings.alarm, 
				repeat_settings.alarm_time, repeat_settings.alarm_num, -1, 0, TRUE,
				repeat_settings.repeat_num, repeat_settings.method,
				repeat_settings.every_info, repeat_settings.every_data,
				time_settings.dbid, time_settings.recid, time, temp_field_string_1);
		}
		qfree(row_num);
		output = SchedulerDayViewFindRowNum(vt, hour_end, minute_end, &row_num, &num_rows);
		if (output == TRUE)
		{
			for (count = 0; count < num_rows; count++)
			{
				if (row_num[count] > target_row_num_0)
				{
					target_row_num_1 = row_num[count];
					break;
				}
			}
			if (target_row_num_1 == -1)
			{
				target_row_num_1 = row_num[num_rows - 1] + 1;
				SchedulerHourMinuteToString(hour_end,  minute_end, time, FALSE);
				VTInsertRow(vt, (row_num[num_rows - 1] + 1), hour_end, minute_end, NO_ALARM, 
					NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, 0, 0, time, (BYTE*)(""));
			}
		}
		else
		{
			target_row_num_1 = row_num[num_rows - 1];
			SchedulerHourMinuteToString(hour_end,  minute_end, time, FALSE);
			VTInsertRow(vt, row_num[num_rows - 1], hour_end, minute_end, NO_ALARM, 
				NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, 0, 0, time, (BYTE*)(""));
		}
		qfree(row_num);
		
		
		//vt->vt_items[target_row_num_0]->appmt_num = (vt->vt_items[time_settings.row_num]->appmt_num)|0x80000000;
		vt->vt_items[target_row_num_0]->appmt_num = temp_appmt_num|0x80000000;
		vt->vt_items[target_row_num_0]->alarm = time_settings.alarm;
		vt->vt_items[target_row_num_0]->alarm_num = time_settings.alarm_num;
		vt->vt_items[target_row_num_0]->alarm_time = time_settings.alarm_time;
		vt->vt_items[target_row_num_0]->dbid = time_settings.dbid;
		vt->vt_items[target_row_num_0]->recid = time_settings.recid;
		//vt->vt_items[time_settings.row_num]->appmt_num = 0;
		
		
		vt->vt_active_row = target_row_num_0;
		vt->vt_items[target_row_num_0]->appointment = target_row_num_1;
		VTSetFieldTextPointer(vt, vt->vt_active_row, temp_field_string_1);
		
		if (target_row_num_0 < vt->vt_top_row_num)
			vt->vt_top_row_num = (USHORT)target_row_num_0;
		else if (target_row_num_0 >= (vt->vt_top_row_num + vt->vt_num_rows_displayed))
			vt->vt_top_row_num += 2;
		
		/* return the environment to normal condition */
		new_appointment = FALSE;
		
		/* try to delete all Alarm Event in the queue */
		SchedulerTimeSettingsDeleteAllEmptyAppmts(vt);
		SchedulerTimeSettingsAddAppmts(vt);
		if (prev_status != TIME_STATUS)
			FormPopupForm(FORM_SCH_DAY_VIEW);
		qfree(temp_field_string_1);
		// Michelle add 131299
		active_row = virtual_table.vt_active_row;
		active_next_row = virtual_table.vt_items[active_row]->appointment;
		repeat_settings.change = TRUE;
		repeat_settings.end_date[3] = virtual_table.vt_items[active_next_row]->hour;
		repeat_settings.end_date[4] = virtual_table.vt_items[active_next_row]->minute;
		return;
	}
}

/********************************************************
* Function:	SchedulerTimeSettingsDeleteAllEmptyAppmts
* Purpose: 	This function is called to delete all empty appointments	
* Scope:		application/internal
* Input:		vt				The pointer to virtual object table
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerTimeSettingsDeleteAllEmptyAppmts(VirtualTable *vt)
{
	WORD		count, count1;
	BOOLEAN		found = FALSE;
	
	for (count = 0; count < vt->vt_num_rows; count++)
	{
		if (vt->vt_items[count]->appointment != -1)
			continue;
		found = FALSE;
		for (count1 = 0; count1 < vt->vt_num_rows; count1++)
		{
			if (count1 == count)
				continue;
			
			if (vt->vt_items[count1]->appointment == count)
			{
				found = TRUE;
				break;
			}
		}
		if (!found)
		{
			VTDeleteRow(vt, (USHORT)count);
			count --;
		}
	}
}

/********************************************************
* Function:	SchedulerTimeSettingsAddAppmts
* Purpose: 	This function is called to add rows to fill
the screen
* Scope:		application/internal
* Input:		vt				The pointer to virtual object table
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerTimeSettingsAddAppmts(VirtualTable *vt)
{
	WORD			total_num_lines, max_num_lines, difference_in_lines, remaining;
    BYTE            starting_hour = 8, object_type, first_hour, last_hour = 23, font_size;
	WORD			num_rows_to_be_added = 0, current_counting_row = 0, index = 0;
	Table			*table_ptr;
	BYTE			time[20];
	CountrySettings	country;
	BOOLEAN			am_pm = FALSE, found = FALSE, done = FALSE;
	WORD			count, count1;
	
    font_size = vt->vt_font_size;
	VTGetTableTotalNumLines(vt, &total_num_lines);
	VTGetTableMaxNumLines(vt, &max_num_lines);
	
	if (total_num_lines >= max_num_lines)
		return;
	
	difference_in_lines = max_num_lines - total_num_lines;
	
	if (difference_in_lines == max_num_lines)
	{
		VTDeleteAllRowItems(vt);
		TableInitTable(TABLE_SCH_DAY_VIEW);
		FormGetObjectPointer(TABLE_SCH_DAY_VIEW, &object_type, (void**)&table_ptr);
        VTInit(vt, table_ptr->bounds, max_num_lines, table_ptr->table_num_column,
			0, table_ptr->table_row_height, table_ptr->table_column_width, 1, SCROLLBAR_SCH_DAY_VIEW);
        vt->vt_font_size = font_size;
		TableUpdateNumRowDisplay(TABLE_SCH_DAY_VIEW, 1);
        for(count = 0; count < max_num_lines; count++)
		{
			VTSetRowHourMinute(vt, (USHORT)count, (BYTE)(8 + count), 0);
			VTSetFieldTextPointer(vt, (USHORT)count, (BYTE*)(""));
			VTSetRowAlarm(vt, (USHORT)count, NO_ALARM, NO_ALARM, 0);
			VTSetRowAppointment(vt, (USHORT)count, -1);
		}
		VTChangeStringFormat(vt);
		vt->vt_active_row = -1;
		return;
	}			
	
	num_rows_to_be_added = vt->vt_items[0]->hour - starting_hour;
	if (vt->vt_items[0]->minute != 0)
		num_rows_to_be_added ++;
	if (num_rows_to_be_added <= 0)
		num_rows_to_be_added = 0;
	if (num_rows_to_be_added > difference_in_lines)
		num_rows_to_be_added = difference_in_lines;
	
	SySetupGetCountrySettings(&country);
	if (country.time_fmt = SYSETUP_12HR_DISPLAY)
		am_pm = TRUE;
	else am_pm = FALSE;
	
	if (vt->vt_items[0]->minute != 0)
		first_hour = vt->vt_items[0]->hour;
	else first_hour = vt->vt_items[0]->hour - 1;
	remaining = difference_in_lines - num_rows_to_be_added;
	while (num_rows_to_be_added)
	{
		current_counting_row ++;
		SchedulerHourMinuteToString(first_hour, 0, time, am_pm);
		VTInsertRow(vt, 0, (BYTE)(first_hour), 0, NO_ALARM, 
			NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, sch_voice_dbid, 0, time, (BYTE*)(""));
		num_rows_to_be_added --;
		first_hour --;
	}
	
	count1 = 0;
	for (count = 0; count < vt->vt_num_rows; count++)
	{
		if (vt->vt_items[count]->appointment != -1)
		{
			count1 ++;
			if (count1 >= 2)
				break;
		}
	}
	
	if (count1 > 1)
	{
		while (remaining > 0)
		{
			done = FALSE;
			for (count = 0; count < vt->vt_num_rows; count++)
			{
				if (vt->vt_items[count]->appointment == -1)
					continue;
				if (vt->vt_items[count]->appointment + 1 >= vt->vt_num_rows)
					break;
				if (vt->vt_items[vt->vt_items[count]->appointment + 1]->appointment == -1)
					continue;
				for (count1 = 0; count1 < vt->vt_items[count]->appointment + 1; count1++)
				{
					if (vt->vt_items[count1]->appointment >= (vt->vt_items[count]->appointment + 1) &&
						count1 != vt->vt_items[count]->appointment + 1)
					{
						found = TRUE;
						break;
					}
				}
				if (found)
					continue;
				
				num_rows_to_be_added = 0;
				num_rows_to_be_added = vt->vt_items[vt->vt_items[count]->appointment + 1]->hour - 
					vt->vt_items[vt->vt_items[count]->appointment]->hour;
				if (vt->vt_items[vt->vt_items[count]->appointment + 1]->minute == 0)
					num_rows_to_be_added --;
				if (num_rows_to_be_added >= remaining)
					num_rows_to_be_added = remaining;
				
				if (vt->vt_items[vt->vt_items[count]->appointment + 1]->minute == 0)
					first_hour = vt->vt_items[vt->vt_items[count]->appointment + 1]->hour - 1;
				else first_hour = vt->vt_items[vt->vt_items[count]->appointment + 1]->hour;
				
				while (num_rows_to_be_added && first_hour > vt->vt_items[vt->vt_items[count]->appointment]->hour &&
					first_hour >= 8)
				{
					SchedulerHourMinuteToString(first_hour, 0, time, am_pm);
					VTInsertRow(vt, vt->vt_items[count]->appointment + 1, first_hour, 0, NO_ALARM, NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, sch_voice_dbid, 0, time, (BYTE*)(""));
					num_rows_to_be_added --;
					remaining --;
					done = TRUE;
					first_hour --;
				}
			}	
			if (!done)
				break;
		}
	}
	
	if (remaining > 0)
	{
		num_rows_to_be_added = last_hour - vt->vt_items[vt->vt_num_rows - 1]->hour;
		if (num_rows_to_be_added <= 0)
			num_rows_to_be_added = 0;
		if (num_rows_to_be_added > remaining)
			num_rows_to_be_added = remaining;
		
		first_hour = vt->vt_items[vt->vt_num_rows - 1]->hour + 1;
		remaining -= num_rows_to_be_added;
		
		while (num_rows_to_be_added)
		{
			SchedulerHourMinuteToString(first_hour, 0, time, am_pm);
			VTInsertRow(vt, vt->vt_num_rows, first_hour++, 0, NO_ALARM, 
				NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, sch_voice_dbid, 0, time, (BYTE*)(""));
			num_rows_to_be_added --;
		}
	}
}

