/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   tdlann.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "mmu.h"
#include "tdlann.h"
#include "str.h"
#include "font.h"
#include "date.h"
#include "SySetup.h"
#include "schlang.h"
#ifdef	PC_SIM
#include "Ann.h"
#include "AnnFunc.h"
#include "AnnDB.h"
#endif
#ifdef	PR31700
DatabaseID	ann_dbid;
#endif
DatabaseID	tdl_dbid;

#define PRIORITY    1

/******************************************************************
* Function:	ToDoAnnGetEventDate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoAnnGetEventDate(SHORT search_year, SHORT search_month, SHORT search_day, RecordID *tdl_recid, RecordID *ann_recid,
						 BYTE *tdl_alarm, BYTE *ann_alarm, BYTE *todo_hit, BYTE *ann_hit)
{
	RecordID	rec_id;
	BYTE		*buffer1, *repeat_buffer;
	BYTE		year_buffer[10], month_buffer[10], day_buffer[10];
	UWORD		rec_num, byte_read, total_num_rec;
	UWORD		rec_year, rec_month, rec_day;
	SHORT		valid_input;
	USHORT		return_val, check_input_year;
	USHORT		rec_wday, rec_week_num, rec_nth_week;
	RTM			pDate;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	/* Search for the records in todo_dbid */
	ToDoListDatabaseChecking();
	DataTotalRecord(tdl_dbid, &total_num_rec);
	*todo_hit = FALSE;
	
    if (total_num_rec != 0)
	{
		for (rec_num=0; rec_num<total_num_rec; rec_num++)
		{
			DataNumtoRecID(tdl_dbid, rec_num, &rec_id);
			DataOpenRecord(tdl_dbid, rec_num, &rec_id, NULL);
			DataGetField(tdl_dbid, rec_id, 4, &buffer1, &byte_read);
			year_buffer[0] = buffer1[0];
			year_buffer[1] = buffer1[1];
			year_buffer[2] = buffer1[2];
			year_buffer[3] = buffer1[3];
            year_buffer[4] = 0;
            rec_year = atol((const char *)year_buffer);
			
			month_buffer[0] = buffer1[5];
			month_buffer[1] = buffer1[6];
            month_buffer[2] = 0;
            rec_month = atol((const char *)month_buffer);
			
			day_buffer[0] = buffer1[8];
			day_buffer[1] = buffer1[9];
            day_buffer[2] = 0;
            rec_day = atol((const char *)day_buffer);
			qfree(buffer1);
			
			if (rec_year == (UWORD)search_year && rec_month == (UWORD)search_month && rec_day == (UWORD)search_day)
			{
				*tdl_recid = rec_id;
				DataGetField(tdl_dbid, rec_id, 1, &buffer1, &byte_read);
				
				if(*buffer1 == NO_ALARM)
					*tdl_alarm = NO_ALARM;
				else if (*buffer1 == TONE_ALARM)
					*tdl_alarm = TONE_ALARM;
				else 				
					*tdl_alarm = VOICE_ALARM;
				
				*todo_hit = TRUE;
				DataCloseRecord(ann_dbid,rec_id);
				qfree(buffer1);
				break;
			}
			else
				DataCloseRecord(ann_dbid,rec_id);
		}
	}
	DataCloseDB(tdl_dbid);
	
	/* Search for the records in ann_dbid */
	AnnDatabaseChecking();
	DataTotalRecord(ann_dbid, &total_num_rec);
	*ann_hit = FALSE;
	
    if (total_num_rec != 0)
	{
		for (rec_num=0; rec_num<total_num_rec; rec_num++)
		{
			DataNumtoRecID(ann_dbid, rec_num, &rec_id);
			DataOpenRecord(ann_dbid, rec_num, &rec_id, NULL);
			
			/* Check the specify schedule date is entried by date settings/week settings */
			/* ##### */
			DataGetField(ann_dbid, rec_id, 7, &buffer1, &byte_read);		//21022000
			rec_wday = (USHORT)atol((const char *)buffer1);
			qfree(buffer1);
			
			DataGetField(ann_dbid, rec_id, 8, &buffer1, &byte_read);	
			rec_week_num = (USHORT)atol((const char *)buffer1);
			qfree(buffer1);
			
			if (rec_week_num >= 1 && rec_week_num < 55)
			{
				DataGetField(ann_dbid, rec_id, 11, &buffer1, &byte_read);
				check_input_year = (USHORT)atol((const char *)buffer1);
				qfree(buffer1);
				
				if (search_year >= check_input_year)
					return_val = ToDoAnnFindDate2(search_year, rec_id);
				else
				{
					return_val = YEAR_ROUNDUP;
					rec_year = check_input_year;
				}
				
				if (return_val == YEAR_FIND_BY_WEEK_NUMBER)
				{
#ifdef	PC_SIM
					valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				else if (return_val == YEAR_ROUNDUP_FROM_LAST_YEAR)
				{
#ifdef	PC_SIM
					Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				else if (return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR)
				{
					if (search_month != 1)
					{
#ifdef	PC_SIM
						Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
					else
					{
#ifdef	PC_SIM
						Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
				}
				else if (return_val == YEAR_FIND_BY_WEEK_AND_NEXT_YEAR)
				{
					if (search_month != 12)
					{
#ifdef	PC_SIM
						valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
					else
					{
#ifdef	PC_SIM
						Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
				}
				else if (return_val == YEAR_ROUNDUP_FROM_NEXT_YEAR)
				{
#ifdef	PC_SIM
					Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				
				if (return_val == YEAR_FIND_BY_WEEK_NUMBER || return_val == YEAR_ROUNDUP_FROM_LAST_YEAR ||
					return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR ||return_val == YEAR_FIND_BY_WEEK_AND_NEXT_YEAR ||
					return_val == YEAR_ROUNDUP_FROM_NEXT_YEAR)
				{
					rec_year = pDate.year;
					rec_month = pDate.mon;
					rec_day = pDate.mday;
					rec_month++;										//21022000
				}
			}
			else if (rec_week_num == 63)
			{
				DataGetField(ann_dbid, rec_id, 2, &buffer1, &byte_read);
				rec_year = (USHORT)atol((const char *)buffer1);
				qfree(buffer1);
				
				DataGetField(ann_dbid, rec_id, 2, &buffer1, &byte_read);
				year_buffer[0] = buffer1[6];
				year_buffer[1] = buffer1[7];
				year_buffer[2] = buffer1[8];
				year_buffer[3] = buffer1[9];
				year_buffer[4] = 0;
				rec_year = (SHORT)atol((const char *)year_buffer);
				qfree(buffer1);
				
				if (search_year >= rec_year)
				{
					DataGetField(ann_dbid, rec_id, 6, &buffer1, &byte_read);
					rec_month = (SHORT)atol((const char *)buffer1);
					qfree(buffer1);
					
					DataGetField(ann_dbid, rec_id, 9, &buffer1, &byte_read);
					rec_nth_week = (USHORT)atol((const char *)buffer1);
					qfree(buffer1);
					
					Dt_M7day_Date (search_year, rec_month-1, rec_nth_week, rec_wday, &pDate);
					rec_year = pDate.year;
					rec_month = pDate.mon + 1;
					rec_day = pDate.mday;
				}
			}
			else
			{
				DataGetField(ann_dbid, rec_id, 2, &buffer1, &byte_read);
				year_buffer[0] = buffer1[6];
				year_buffer[1] = buffer1[7];
				year_buffer[2] = buffer1[8];
				year_buffer[3] = buffer1[9];
				year_buffer[4] = 0;
				rec_year = atol((const char *)year_buffer);
				
				month_buffer[0] = buffer1[0];
				month_buffer[1] = buffer1[1];
				month_buffer[2] = 0;
				rec_month = atol((const char *)month_buffer);
				
				day_buffer[0] = buffer1[3];
				day_buffer[1] = buffer1[4];
				day_buffer[2] = 0;
				rec_day = atol((const char *)day_buffer);
				qfree(buffer1);
			}
			
			DataGetField(ann_dbid, rec_id, 4, &repeat_buffer, &byte_read);
			
			if ((*repeat_buffer == NO_REPEAT && rec_year == (UWORD)search_year && rec_month == (UWORD)search_month && rec_day == (UWORD)search_day) ||
				(*repeat_buffer == YEARLY_REPEAT && rec_year <= (UWORD)search_year && rec_month == (UWORD)search_month && rec_day == (UWORD)search_day))
			{
				*ann_recid = rec_id;
				DataGetField(ann_dbid, rec_id, 0, &buffer1, &byte_read);
				
				if(*buffer1 == NO_ALARM)
					*ann_alarm = NO_ALARM;
				else
					*ann_alarm = TONE_ALARM;
				
				*ann_hit = TRUE;
				DataCloseRecord(ann_dbid,rec_id);
				qfree(buffer1);
				break;
			}
			else
				DataCloseRecord(ann_dbid,rec_id);
		}
	}
	DataCloseDB(ann_dbid);
}

/******************************************************************
* Function:	ToDoAnnGetEventMonth
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoAnnGetEventMonth(SHORT search_year, SHORT search_month, BYTE *month_state, USHORT *num_days)
{
	RecordID	rec_id;
	BYTE		*buffer1, *repeat_buffer;
	BYTE		year_buffer[10], month_buffer[10], day_buffer[10];
	UWORD		rec_num, byte_read, total_num_rec;
	UWORD		rec_year, rec_month, rec_day;
	SHORT		valid_input;
	USHORT		i, return_val, check_input_year;
	USHORT		rec_wday, rec_week_num, rec_nth_week;
	RTM			pDate;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	
	for (i=0; i<31; i++)
		month_state[i] = FALSE;
	
	*num_days = 0;
	/* Search for the records in todo_dbid */
	ToDoListDatabaseChecking();
	DataTotalRecord(tdl_dbid, &total_num_rec);
	
    if (total_num_rec != 0)
	{
		for (rec_num=0; rec_num<total_num_rec; rec_num++)
		{
			DataNumtoRecID(tdl_dbid, rec_num, &rec_id);
			DataOpenRecord(tdl_dbid, rec_num, &rec_id, NULL);
			
			DataGetField(tdl_dbid, rec_id, 4, &buffer1, &byte_read);
			year_buffer[0] = buffer1[0];
			year_buffer[1] = buffer1[1];
			year_buffer[2] = buffer1[2];
			year_buffer[3] = buffer1[3];
            year_buffer[4] = 0;
			rec_year = atol((const char *)year_buffer);
			
			month_buffer[0] = buffer1[5];
			month_buffer[1] = buffer1[6];
            month_buffer[2] = 0;
			rec_month = atol((const char *)month_buffer);			
			
			day_buffer[0] = buffer1[8];
			day_buffer[1] = buffer1[9];
			day_buffer[2] = 0;
			rec_day = atol((const char *)day_buffer);
			
			DataCloseRecord(tdl_dbid,rec_id);
			qfree(buffer1);
			
			if (rec_year == (UWORD)search_year && rec_month == (UWORD)search_month)
			{
				month_state[rec_day-1] = TRUE;
				(*num_days)++;
			}
		}
	}
	DataCloseDB(tdl_dbid);
	
	/* Search for the records in ann_dbid */
	AnnDatabaseChecking();
	DataTotalRecord(ann_dbid, &total_num_rec);
	
    if (total_num_rec != 0)
	{
		for (rec_num=0; rec_num<total_num_rec; rec_num++)
		{
			DataOpenRecord(ann_dbid, rec_num, &rec_id, NULL);
			
			DataGetField(ann_dbid, rec_id, 7, &buffer1, &byte_read);		//21022000
			rec_wday = (USHORT)atol((const char *)buffer1);
			qfree(buffer1);
			
			DataGetField(ann_dbid, rec_id, 8, &buffer1, &byte_read);
			rec_week_num = (USHORT)atol((const char *)buffer1);
			qfree(buffer1);
			
			if (rec_week_num >= 1 && rec_week_num < 55)
			{				
				DataGetField(ann_dbid, rec_id, 11, &buffer1, &byte_read);
				check_input_year = (USHORT)atol((const char *)buffer1);
				qfree(buffer1);
				
				if (search_year >= check_input_year)
					return_val = ToDoAnnFindDate2(search_year, rec_id);
				else
				{
					return_val = YEAR_ROUNDUP;
					rec_year = check_input_year;
				}
				
				if (return_val == YEAR_FIND_BY_WEEK_NUMBER)
				{
#ifdef	PC_SIM
					valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				else if (return_val == YEAR_ROUNDUP_FROM_LAST_YEAR)
				{
#ifdef	PC_SIM
					Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				else if (return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR)
				{
					if (search_month != 1)
					{
#ifdef	PC_SIM
						Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
					else
					{
#ifdef	PC_SIM
						Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
				}
				else if (return_val == YEAR_FIND_BY_WEEK_AND_NEXT_YEAR)
				{
					if (search_month != 12)
					{
#ifdef	PC_SIM
						valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						valid_input = Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
					else
					{
#ifdef	PC_SIM
						Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
						Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
					}
				}
				else if (return_val == YEAR_ROUNDUP_FROM_NEXT_YEAR)
				{
#ifdef	PC_SIM
					Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &pDate);
#else
					Dt_YWeek_Date (search_year+1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
				}
				
				if (return_val == YEAR_FIND_BY_WEEK_NUMBER || return_val == YEAR_ROUNDUP_FROM_LAST_YEAR ||
					return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR || return_val == YEAR_FIND_BY_WEEK_AND_NEXT_YEAR ||
					return_val == YEAR_ROUNDUP_FROM_NEXT_YEAR)
				{
					rec_year = pDate.year;
					rec_month = pDate.mon;
					rec_day = pDate.mday;
					rec_month++;										//21022000
				}
			}
			else if (rec_week_num == 63)
			{
				DataGetField(ann_dbid, rec_id, 2, &buffer1, &byte_read);
				rec_year = (USHORT)atol((const char *)buffer1);
				qfree(buffer1);
				
				DataGetField(ann_dbid, rec_id, 2, &buffer1, &byte_read);
				year_buffer[0] = buffer1[6];
				year_buffer[1] = buffer1[7];
				year_buffer[2] = buffer1[8];
				year_buffer[3] = buffer1[9];
				year_buffer[4] = 0;
				rec_year = (SHORT)atol((const char *)year_buffer);
				qfree(buffer1);
				
				if (search_year >= rec_year)
				{
					DataGetField(ann_dbid, rec_id, 6, &buffer1, &byte_read);
					rec_month = (SHORT)atol((const char *)buffer1);
					qfree(buffer1);
					
					DataGetField(ann_dbid, rec_id, 9, &buffer1, &byte_read);
					rec_nth_week = (USHORT)atol((const char *)buffer1);
					qfree(buffer1);
					
					Dt_M7day_Date (search_year, rec_month-1, rec_nth_week, rec_wday, &pDate);
					rec_year = pDate.year;
					rec_month = pDate.mon + 1;
					rec_day = pDate.mday;
				}
			}
			else
			{
				DataGetField(ann_dbid, rec_id, 2, &buffer1, &byte_read);
				year_buffer[0] = buffer1[6];
				year_buffer[1] = buffer1[7];
				year_buffer[2] = buffer1[8];
				year_buffer[3] = buffer1[9];
				year_buffer[4] = 0;
				rec_year = atol((const char *)year_buffer);
				
				month_buffer[0] = buffer1[0];
				month_buffer[1] = buffer1[1];
				month_buffer[2] = 0;
				rec_month = atol((const char *)month_buffer);			
				
				day_buffer[0] = buffer1[3];
				day_buffer[1] = buffer1[4];
				day_buffer[2] = 0;
				rec_day = atol((const char *)day_buffer);
				qfree(buffer1);
			}
			
			DataGetField(ann_dbid, rec_id, 4, &repeat_buffer, &byte_read);
			DataCloseRecord(ann_dbid,rec_id);
			
			if ((*repeat_buffer == NO_REPEAT && rec_year == (UWORD)search_year && rec_month == (UWORD)search_month) ||
				(*repeat_buffer == YEARLY_REPEAT && rec_year <= (UWORD)search_year && rec_month == (UWORD)search_month))
			{
				month_state[rec_day-1] = TRUE;
				(*num_days)++;
			}
			qfree(repeat_buffer);
		}
	}
	DataCloseDB(ann_dbid);
}

/********************************************************
* Function:	ToDoListDatabaseChecking
* Purpose: 	This function is called to check whether the required database 
is already exist or not. If not, it will creat it
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ToDoListDatabaseChecking()
{
	BYTE application_status, sorted_by, create_font = SMALL_FONT;
	
	if (DataFindDB(TODODB, &tdl_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(TODODB,1,TODODB,&tdl_dbid);
		DataOpenDB(tdl_dbid,2,OPEN_RW);
		/* Create status record */
		DataNewRecordWithID(tdl_dbid, TDL_STATUS, 0, 1);
		DataNewRecordWithID(tdl_dbid, TDL_EDIT_INFO, 0, 34);
		application_status = RESTART_TO_DO_LIST;
		DataWriteField(tdl_dbid, TDL_STATUS, 0, 1, &application_status);
		DataWriteField(tdl_dbid, TDL_EDIT_INFO, 29, 1, (BYTE*)&create_font);
	}
	else if (DataIsDBOpen(tdl_dbid, NULL, NULL) == FALSE)
	{
		DataOpenDB(tdl_dbid,2,OPEN_RW);
	}
	
	if (DataRecordInfo(tdl_dbid, TDL_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(tdl_dbid, TDL_STATUS, 0, 1);
		application_status = RESTART_TO_DO_LIST;
		DataWriteField(tdl_dbid, TDL_STATUS, 0, 1, &application_status);
	}
	
	if (DataRecordInfo(tdl_dbid, TDL_EDIT_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(tdl_dbid, TDL_EDIT_INFO, 0, 34);
		
		sorted_by = PRIORITY;
		DataWriteField(tdl_dbid, TDL_EDIT_INFO, 11, 1, (BYTE*)&sorted_by);
		DataWriteField(tdl_dbid, TDL_EDIT_INFO, 29, 1, (BYTE*)&create_font);
	}
}

#ifdef	PR31700
/********************************************************
* Function:	AnnDatabaseChecking
* Purpose: 	This function is called to check whether the required database 
*				is already exist or not. If not, it will creat it
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void AnnDatabaseChecking()
{
	BYTE	application_status, temp_month, create_font = SMALL_FONT;
	RTM		time;
	
	if (DataFindDB(ANNDB, &ann_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(ANNDB,1,ANNAPP,&ann_dbid);
		DataOpenDB(ann_dbid,2,OPEN_RW);
		/* Create status record */
		DataNewRecordWithID(ann_dbid, ANN_EDIT_INFO, 0, 36);
		RtcGetTime(&time);
		temp_month = time.mon+1;
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 8, 2, (BYTE*)&time.year);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 9, 2, (BYTE*)&temp_month);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 10, 2, (BYTE*)&time.mday);
		
		DataNewRecordWithID(ann_dbid, ANN_STATUS, 0, 1);
		application_status = RESTART_ANNIVER;
		DataWriteField(ann_dbid, ANN_STATUS, 0, 1, &application_status);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 32, 1, (BYTE*)&create_font);
	}
	else if (DataIsDBOpen(ann_dbid, NULL, NULL) == FALSE)
		DataOpenDB(ann_dbid,2,OPEN_RW);
	
	if (DataRecordInfo(ann_dbid, ANN_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(ann_dbid, ANN_STATUS, 0, 1);
		application_status = RESTART_ANNIVER;
		DataWriteField(ann_dbid, ANN_STATUS, 0, 1, &application_status);
	}
	
	if (DataRecordInfo(ann_dbid, ANN_EDIT_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(ann_dbid, ANN_EDIT_INFO, 0, 36);
		
		RtcGetTime(&time);
		temp_month = time.mon+1;
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 8, 2, (BYTE*)&time.year);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 9, 2, (BYTE*)&temp_month);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 10, 2, (BYTE*)&time.mday);
		DataWriteField(ann_dbid, ANN_EDIT_INFO, 32, 1, (BYTE*)&create_font);
	}
}

/********************************************************
* Function:	AnnDatabaseInit
* Purpose: 	This function is used to simulate and initialse the 
*			the datebase in the PDA.Try to preset some records in 
*			the database
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void AnnDatabaseInit()
{
	RecordID rec_id;
	SHORT i;
	
	BYTE alarm_status[15];
	BYTE yearly_repeat[15];
	BYTE *ann_contents[15];
	BYTE *schedule_date[15];
	BYTE *alarm_date[15];
	BYTE temp_buffer[15];
	
	
	
	for (i = 0; i <15; i++)
	{
		alarm_status[i] = TONE_ALARM;
		//		yearly_repeat[i] = NO_REPEAT;
		yearly_repeat[i] = YEARLY_REPEAT;
		temp_buffer[i] = 0;
	}
	alarm_status[7]  = NO_ALARM;
	alarm_status[9]  = NO_ALARM;
	alarm_status[10] = NO_ALARM;
	alarm_status[11] = NO_ALARM;
	alarm_status[13] = NO_ALARM;
	alarm_status[14] = NO_ALARM;
	
	//	yearly_repeat[2]  = YEARLY_REPEAT;
	//	yearly_repeat[4]  = YEARLY_REPEAT;
	yearly_repeat[0]  = NO_REPEAT;
	yearly_repeat[1]  = NO_REPEAT;
	yearly_repeat[2] = NO_REPEAT;
	yearly_repeat[3] = NO_REPEAT;
	
	
	for (i = 0; i <15; i++)
	{	
		ann_contents[i] = (BYTE*)qmalloc(500*sizeof(BYTE));
		schedule_date[i]  = (BYTE*)qmalloc(16*sizeof(BYTE));
		alarm_date[i]  = (BYTE*)qmalloc(16*sizeof(BYTE));	
	}
	
	strcpy(ann_contents[0],SCHCHARA);
	strcpy(ann_contents[1],SCHCHARB);
	strcpy(ann_contents[2],SCHCHARC);
	strcpy(ann_contents[3],SCHCHARD);
	strcpy(ann_contents[4],SCHCHARE);
	strcpy(ann_contents[5],SCHCHARF);
	strcpy(ann_contents[6],SCHCHARG);
	strcpy(ann_contents[7],SCHCHARH);
	strcpy(ann_contents[8],SCHCHARI);
	strcpy(ann_contents[9],SCHCHARJ);
	strcpy(ann_contents[10],SCHCHARK);
	strcpy(ann_contents[11],SCHCHARL);
	strcpy(ann_contents[12],SCHCHARM);
	strcpy(ann_contents[13],SCHCHARN);
	strcpy(ann_contents[14],SCHCHARO);
	
	strcpy(schedule_date[0],"01/01/1905");
	strcpy(schedule_date[1],"02/01/1981");
	strcpy(schedule_date[2],"03/01/1982");
	strcpy(schedule_date[3],"04/01/1983");
	strcpy(schedule_date[4],"05/01/1984");
	strcpy(schedule_date[5],"06/01/1985");
	strcpy(schedule_date[6],"07/01/1986");
	strcpy(schedule_date[7],"08/01/1987");
	strcpy(schedule_date[8],"09/01/1988");
	strcpy(schedule_date[9],"10/01/1989");
	strcpy(schedule_date[10],"11/01/1990");
	strcpy(schedule_date[11],"12/01/1991");
	strcpy(schedule_date[12],"12/02/1992");
	strcpy(schedule_date[13],"12/03/1993");
	strcpy(schedule_date[14],"12/04/1994");
	
	strcpy(alarm_date[0],"01/01/1906");
	strcpy(alarm_date[1],"02/02/1997");
	strcpy(alarm_date[2],"03/19/1999");
	strcpy(alarm_date[3],"03/19/1999");
	strcpy(alarm_date[4],"03/20/1999");
	strcpy(alarm_date[5],"03/20/1999");
	strcpy(alarm_date[6],"03/21/1999");
	strcpy(alarm_date[7],"03/21/1999");
	strcpy(alarm_date[8],"09/09/1999");
	strcpy(alarm_date[9],"10/10/1999");
	strcpy(alarm_date[10],"11/11/1999");
	strcpy(alarm_date[11],"08/08/1999");
	strcpy(alarm_date[12],"09/09/2000");
	strcpy(alarm_date[13],"10/10/2000");
	strcpy(alarm_date[14],"11/11/2000");
	
	/* New Database */
	DataNewDB(ANNDB,1,ANNAPP,&ann_dbid);
	/* Open Database and sort by schedule date */
	DataOpenDB(ann_dbid,2,OPEN_RW);
	/* Open Database */						
	for (i= 0;i<15;i++)
	{
		DataNewRecord(ann_dbid, 0x00, ANN_NUM_FIELD, &rec_id);
		DataWriteField(ann_dbid,rec_id,0,1,(BYTE*) &alarm_status[i]);
		DataWriteField(ann_dbid,rec_id,1,(strlen(ann_contents[i]) + 1),ann_contents[i]);
		DataWriteField(ann_dbid,rec_id,2,(strlen(schedule_date[i]) + 1),schedule_date[i]);
		DataWriteField(ann_dbid,rec_id,3,(strlen(alarm_date[i]) + 1),alarm_date[i]);
		DataWriteField(ann_dbid,rec_id,4,1,(BYTE*) &yearly_repeat[i]);
		DataWriteField(ann_dbid,rec_id,5,1,(BYTE*) &temp_buffer[i]);
		DataWriteField(ann_dbid,rec_id,6,1,(BYTE*) &temp_buffer[i]);
		DataWriteField(ann_dbid,rec_id,7,1,(BYTE*) &temp_buffer[i]);
		DataWriteField(ann_dbid,rec_id,8,1,(BYTE*) &temp_buffer[i]);
		DataWriteField(ann_dbid,rec_id,9,1,(BYTE*) &temp_buffer[i]);
		DataCloseRecord(ann_dbid,rec_id);
	}	
	for (i= 0; i <15; i++)
	{
		qfree(ann_contents[i]);
		qfree(schedule_date[i]);
		qfree(alarm_date[i]);
	}
}
#endif

/********************************************************
* Function:	ToDoDatabaseInit
* Purpose: 	This function is used to simulate and initialse the 
*			the datebase in the PDA.Try to preset some records in 
*			the database
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void ToDoDatabaseInit()
{
	RecordID rec_id;
	SHORT i= 0;
	
	BYTE completed_items[15];
	BYTE alarm_status[15];
	BYTE priority[15];
	BYTE *to_do_contents[15];
	BYTE *schedule_date[15];
	BYTE *alarm_date[15];
	
	/* setting up data */
	for (i = 0; i <15; i++)
	{
		completed_items[i] = INCOMPLETED;
		alarm_status[i] = TONE_ALARM;
	}
	
	alarm_status[2] = VOICE_ALARM;
	alarm_status[5] = 0;
	alarm_status[7] = VOICE_ALARM;
	alarm_status[9] = VOICE_ALARM;
	alarm_status[10] = 0;
	alarm_status[11] = VOICE_ALARM;
	alarm_status[13] = VOICE_ALARM;
	
	priority[0] = 1;
	priority[1] = 5;
	priority[2] = 4;
	priority[3] = 3;
	priority[4] = 2;
	priority[5] = 1;
	priority[6] = 5;
	priority[7] = 5;
	priority[8] = 4;
	priority[9] = 3;
	priority[10] = 5;
	priority[11] = 4;
	priority[12] = 3;
	priority[13] = 2;
	priority[14] = 1;
	
	for (i = 0; i <15; i++)
	{	
		to_do_contents[i] = (BYTE*)qmalloc(500*sizeof(BYTE));
		schedule_date[i]  = (BYTE*)qmalloc(16*sizeof(BYTE));
		alarm_date[i]  = (BYTE*)qmalloc(16*sizeof(BYTE));	
	}
	/*
	strcpy(to_do_contents[0],"Scheduler is an powerful application 12345 67890 12345 67890 12345");
	strcpy(to_do_contents[1],"Wendy");
	strcpy(to_do_contents[2],"Kenny");
	strcpy(to_do_contents[3],"David");
	strcpy(to_do_contents[4],"Kenni");
	strcpy(to_do_contents[5],"Yogi");
	strcpy(to_do_contents[6],"Fiona");
	strcpy(to_do_contents[7],"Brian");
	strcpy(to_do_contents[8],"Rosita");
	strcpy(to_do_contents[9],"Hi Hi");
	strcpy(to_do_contents[10],"U2");
	strcpy(to_do_contents[11],"Chucky");
	strcpy(to_do_contents[12],"CoCo");
	strcpy(to_do_contents[13],"Rubbish");
	strcpy(to_do_contents[14],"Trash");
	*/
	strcpy(to_do_contents[0],SCHCHARA);
	strcpy(to_do_contents[1],SCHCHARB);
	strcpy(to_do_contents[2],SCHCHARC);
	strcpy(to_do_contents[3],SCHCHARD);
	strcpy(to_do_contents[4],SCHCHARE);
	strcpy(to_do_contents[5],SCHCHARF);
	strcpy(to_do_contents[6],SCHCHARG);
	strcpy(to_do_contents[7],SCHCHARH);
	strcpy(to_do_contents[8],SCHCHARI);
	strcpy(to_do_contents[9],SCHCHARJ);
	strcpy(to_do_contents[10],SCHCHARK);
	strcpy(to_do_contents[11],SCHCHARL);
	strcpy(to_do_contents[12],SCHCHARM);
	strcpy(to_do_contents[13],SCHCHARN);
	strcpy(to_do_contents[14],SCHCHARO);
	
	strcpy(schedule_date[0],"1980/01/01");
	strcpy(schedule_date[1],"1981/02/01");
	strcpy(schedule_date[2],"1982/03/01");
	strcpy(schedule_date[3],"1983/04/01");
	strcpy(schedule_date[4],"1984/05/01");
	strcpy(schedule_date[5],"1985/06/01");
	strcpy(schedule_date[6],"1986/07/01");
	strcpy(schedule_date[7],"1987/08/01");
	strcpy(schedule_date[8],"1988/09/01");
	strcpy(schedule_date[9],"1989/10/01");
	strcpy(schedule_date[10],"1990/11/01");
	strcpy(schedule_date[11],"1991/12/01");
	strcpy(schedule_date[12],"1992/12/02");
	strcpy(schedule_date[13],"1993/12/03");
	strcpy(schedule_date[14],"1994/12/04");
	
	strcpy(alarm_date[0],"1999/03/03");
	strcpy(alarm_date[1],"1999/03/03");
	strcpy(alarm_date[2],"1999/03/04");
	strcpy(alarm_date[3],"1999/04/02");
	strcpy(alarm_date[4],"1999/04/03");
	strcpy(alarm_date[5],"1999/04/04");
	strcpy(alarm_date[6],"1999/04/05");
	strcpy(alarm_date[7],"1999/09/09");
	strcpy(alarm_date[8],"1999/09/09");
	strcpy(alarm_date[9],"1999/09/09");
	strcpy(alarm_date[10],"1999/09/09");
	strcpy(alarm_date[11],"1999/09/09");
	strcpy(alarm_date[12],"1999/09/09");
	strcpy(alarm_date[13],"1999/09/09");
	strcpy(alarm_date[14],"1999/09/09");
	
	/* New Database */
	DataNewDB(TODODB,1,TODODB,&tdl_dbid);
	/* Open Database and sort by priority */
	DataOpenDB(tdl_dbid,2,OPEN_RW);
	/* Open Database */						
	for (i = 0;i<15;i++)
	{
		DataNewRecord(tdl_dbid, 0x00, TO_DO_LIST_NUM_FIELD, &rec_id);
		DataWriteField(tdl_dbid,rec_id,0,1,(BYTE*) &completed_items[i]);
		DataWriteField(tdl_dbid,rec_id,1,1,(BYTE*) &alarm_status[i]);
		DataWriteField(tdl_dbid,rec_id,2,1,(BYTE*) &priority[i]);
		DataWriteField(tdl_dbid,rec_id,3,(strlen(to_do_contents[i]) + 1),to_do_contents[i]);
		DataWriteField(tdl_dbid,rec_id,4,(strlen(schedule_date[i]) + 1),schedule_date[i]);
		DataWriteField(tdl_dbid,rec_id,5,(strlen(alarm_date[i]) + 1),alarm_date[i]);
		DataWriteField(tdl_dbid,rec_id,6,1,(BYTE*)(""));
		DataCloseRecord(tdl_dbid,rec_id);
	}	
	
	for (i = 0; i <15; i++)
	{
		qfree(to_do_contents[i]);
		qfree(schedule_date[i]);
		qfree(alarm_date[i]);
	}
}
/********************************************************
* Function:	ToDoAnnFindDate()
* Purpose: 	
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
USHORT ToDoAnnFindDate2(SHORT search_year, RecordID	rec_id)
{
	USHORT		rec_wday, rec_week_num, check_input_year, return_val;
	SHORT		check_roundoff;
	BYTE		*buffer;
	UWORD		byte_read;
	RTM			pDate, current, last;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	
	DataGetField(ann_dbid, rec_id, 7, &buffer, &byte_read);
	rec_wday = (USHORT)atol((const char *)buffer);
	qfree(buffer);
	
	DataGetField(ann_dbid, rec_id, 8, &buffer, &byte_read);
	rec_week_num = (USHORT)atol((const char *)buffer);
	qfree(buffer);
	
	if (rec_week_num == 1)
	{
#ifdef	PC_SIM
		Dt_YWeek_Date (search_year, 1, (SHORT)rec_wday, 0, &current);
		Dt_YWeek_Date (search_year+1, 1, (SHORT)rec_wday, 0, &pDate);
#else
		Dt_YWeek_Date (search_year, 1, (SHORT)rec_wday, country.start_of_week, &current);
		Dt_YWeek_Date (search_year+1, 1, (SHORT)rec_wday, country.start_of_week, &pDate);
#endif
		/* Check Date No RoundUp */
		if (current.year == search_year && pDate.year == search_year) /* Current date No Round up && Next date Round Up */
			return_val = YEAR_FIND_BY_WEEK_AND_NEXT_YEAR;
		else if (current.year != search_year && pDate.year == search_year) /* Current date Round up && Next date Round Up */
			return_val = YEAR_ROUNDUP_FROM_NEXT_YEAR;
		else if (current.year != search_year && pDate.year != search_year) /* Current date Round up && Next date No Round Up */
			return_val = YEAR_ROUNDUP;
		else // current.year == search_year && pDate.year != search_year
			return_val = YEAR_FIND_BY_WEEK_NUMBER; /* No RoundUp of Both Current and Next year Happen !!! */
	}
	else if (rec_week_num == 52)
	{
#ifdef	PC_SIM
		Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &current);
		Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, 0, &last);
#else
		Dt_YWeek_Date (search_year, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &current);
		Dt_YWeek_Date (search_year-1, (SHORT)rec_week_num, (SHORT)rec_wday, country.start_of_week, &last);
#endif
		/* Check Date No RoundUp */
		if (current.year == search_year && last.year == search_year) /* Current date No Round up && Next date Round Up */
			return_val = YEAR_FIND_BY_WEEK_AND_LAST_YEAR;
		else if (current.year != search_year && last.year == search_year) /* Current date Round up && Next date Round Up */
			return_val = YEAR_ROUNDUP_FROM_LAST_YEAR;
		else if (current.year != search_year && pDate.year != search_year) /* Current date Round up && Next date No Round Up */
			return_val = YEAR_ROUNDUP;
		else // current.year == search_year && pDate.year != search_year
			return_val = YEAR_FIND_BY_WEEK_NUMBER; /* No RoundUp of Both Current and last year Happen !!! */
		// Check if last year without week 53
		if (return_val == YEAR_ROUNDUP_FROM_LAST_YEAR || return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR)
		{ 
#ifdef	PC_SIM
			Dt_Date_YWeek (search_year, last.mon, last.mday, 0, &check_roundoff);
#else
			Dt_Date_YWeek (search_year, last.mon, last.mday, country.start_of_week, &check_roundoff);
#endif
			if (check_roundoff != search_year-1)
			{
				if (return_val == YEAR_ROUNDUP_FROM_LAST_YEAR)
					return_val = YEAR_ROUNDUP;
				else	// return_val == YEAR_FIND_BY_WEEK_AND_LAST_YEAR
					return_val = YEAR_FIND_BY_WEEK_NUMBER;
			}
		}
	}
	else
		return_val = YEAR_FIND_BY_WEEK_NUMBER;
	
	return return_val;
}