/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   skhfunc.h
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __SKHFUNC_H_
#define __SKHFUNC_H_

#include "uifunc.h"
#include "ui.h"
#include "alaunch.h"
#include "gf.h"
#include "gotorec.h"
#ifdef PR31700
#include "ioconmsg.h"
#endif

typedef struct _MemoSketch
{
	AppID		app_id;
	RecordID	rec_id;
	USHORT		sketch_status_num;
	USHORT		sketch_field_num;
	BYTE		return_mode;
}MemoSketch;

extern BOOLEAN sketch_memo;
extern MemoSketch *cptr;
extern BYTE font_size;
extern UWORD *sketch_bmp_ptr;

extern DatabaseID dbid;
extern RecordID grecid;
extern Err retval;
extern BOOLEAN		restore_status;
extern BOOLEAN sketch_new;
extern BOOLEAN sketch_alphabet;
extern BOOLEAN sketch_select;
extern BOOLEAN sketch_change;
extern BOOLEAN sketch_goto;

extern BOOLEAN sketch_clear_undo;
extern BOOLEAN sketch_rename;

extern BYTE sketch_thick;
extern BYTE sketch_prevform;
extern BitmapTemplate full_bmp1, full_bmp4, part_bmp3;
extern Bitmap *full_scr;
extern ObjectBounds bounds;
extern SHORT sketch_x, sketch_y;
extern SHORT tmp_x, tmp_y, tmp_r, drag_x, drag_y;
extern BYTE application_status;

extern BOOLEAN sketch_memo_unconditional_exit;

/*****************************************************************
******************** FORM MAIN MENU **********************
*****************************************************************/
#define     FORM_SKETCH_LIST     0
#define     LIST_TITLE     1
#define     SCROLLBAR_SKETCH_LIST     2
#define     BUTTON_NEW_RECORD     3
#define     FORM_SKETCH_INFO     4
#define     STRING_SKETCH_INFO     5
#define     TEXTBOX_SKETCH_INFO     6

#define     FORM_SKETCH_DRAW     7
#define     BUTTON_DELETE_RECORD     8
#define     CHECKBOX_SKETCH_PEN     9
#define     CHECKBOX_SKETCH_ERASER     10
#define     CHECKBOX_SKETCH_FILL     11
#define     CHECKBOX_SKETCH_SELECT     12
#define     CHECKBOX_SKETCH_RECTANGLE     13
#define     CHECKBOX_SKETCH_CIRCLE     14
#define     CHECKBOX_SKETCH_TEXT     15
#define     CHECKBOX_SKETCH_LINE     16
#define	    BITMAP_SKETCH_DRAW	   17
#define     FORM_INPUT_TEXT     18
#define     BITMAP_INPUT_TEXT_X     19
#define		TEXTBOX_INPUT_TEXT		20
#define     FORM_CONFIRM_ERASE     21
#define     STRING_CONFIRM_ERASE_0     22
#define     STRING_CONFIRM_ERASE_1     23
#define     CHECKBOX_ERASE_SAVE_ARCHIVE     24
#define     BUTTON_ERASE_YES     25
#define     BUTTON_ERASE_NO     26
#define     FORM_SAVE_CHANGES     27
#define     BITMAP_SAVE_CHANGES_X     28
#define     STRING_SAVE_CHANGES     29
#define     BUTTON_SAVE_CHANGES_YES     30
#define     BUTTON_SAVE_CHANGES_NO     31
#define		CHECKBOX_SKETCH_THICK1		34
#define		CHECKBOX_SKETCH_THICK2		35
#define		CHECKBOX_SKETCH_THICK3		36
#define		STRING_SKETCH_TITLE			37
#define		FORM_SKETCH_LOW_MEMORY		39
#define		BITMAP_SKETCH_LOW_MEMORY_X	40
#define		STRING_SKETCH_LOW_MEMORY_0	41
#define		STRING_SKETCH_LOW_MEMORY_1	42



#define SKETCH_STATUS		0x80001001
#define SKETCH_EDIT_INFO		0x80001002

#define MEMO_STATUS			0x80001004
#define MEMO_EDIT_INFO                  0x80001005

#define RESTART_SKETCH	0
#define RESTART_SKETCH_INFO	1
#define RESTART_SKETCH_DRAW	2
#define RESTART_SKETCH_TEXT	3
#define RESTART_SKETCH_SAVE	4
#define RESTART_SKETCH_ERASE	5

#define RESTART_MEMO_NEW	2

/*==================== Menu Item ===========================*/
#define MENU_ITEM_COPY						0
#define MENU_ITEM_CUT						1
#define MENU_ITEM_PASTE						2
#define MENU_ITEM_UNDO						3
#define MENU_ITEM_ZOOM						4

#define MENU_ITEM_ERASE						0
#define MENU_ITEM_DELETE					1
#define MENU_ITEM_RENAME					2

#define SKETCH_INFO_MENU					32
#define SKETCH_DRAW_MENU					33
#define SKETCH_LIST_MENU					38

void EventLoop();
BOOLEAN SketchAppLaunch(WORD cmd, void *cmd_ptr);
void SketchInit();
void SketchScrollbarSetList(EvtType *Event);
//BOOLEAN SketchChangeFont();
void SketchMenuSelectedAction(USHORT item_num);
void SketchPrepareFindText(DatabaseID dbid, RecordID rec_id, BYTE **prepare_string);
BOOLEAN SketchFillRegion(SHORT xcoord, SHORT ycoord);
void SketchFromMemo();
void SketchGotoItem(DatabaseID dbid, RecordID goto_rec_id, USHORT field_num, BYTE *search_string);
void SketchGetBitmap();
void SketchNewRecord();

void SketchMenuSetFont(BYTE font_size);
/* DB */
void SketchDatabaseTemp();
void SketchListInit();
void SketchAppSave();
void SketchAppRestore(BOOLEAN restart);
void SketchNewRecord();
void SketchSaveRecordText();
void SketchSaveRecord();
void SketchSaveNewRecord();
void SketchSaveRecordMemo();
void SketchOpenRecord(UWORD rec_num);
void SketchBackMemo();
void SketchEraseRecordMemo();

/*****************************************************************
******************* Calculator Handle Functions ******************
*****************************************************************/
BOOLEAN SketchFormList(EvtType *Event);
BOOLEAN SketchFormInfo(EvtType *Event);
BOOLEAN SketchFormDraw(EvtType *Event);
BOOLEAN SketchFormText(EvtType *Event);
BOOLEAN SketchFormErase(EvtType *Event);
BOOLEAN SketchFormSave(EvtType *Event);
BOOLEAN SketchFormLowMemory(EvtType *Event);


#endif
