/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   skhdb.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "Skhfunc.h"
#include "mmu.h"
#include "slang.h"

//#define DEBUG_H

void SketchDatabaseTemp()
{
	UWORD       total_rec;
	RecordID    rec_id;
	BYTE        *buffer;
	UWORD       byte_read;
	UWORD       i;
	
	if (DataFindDB(SKETCHDB, &dbid) == FALSE)
	{
		retval = DataNewDB(SKETCHDB, 0, SKETCH, &dbid);
	}
	
	retval = DataOpenDB(dbid, SORT_TEXT_MODE|0, OPEN_RW);
}

void SketchListInit()
{
	UWORD       total_rec;
	RecordID    rec_id;
	BYTE        *buffer;
	UWORD       byte_read;
	UWORD       i;
	BYTE		object_type;
	Scrollbar*	scroll_ptr;
	UWORD       rec_num;
	
	rec_num = -1;
	
	DataCloseDB(dbid);
	DataOpenDB(dbid, SORT_TEXT_MODE|0, OPEN_RW);
	
	DataTotalRecord(dbid, &total_rec);
	
	ListInitList(LIST_TITLE);
	
	for (i=0; i<total_rec; i++)
	{
		retval = DataOpenRecord(dbid, i, &rec_id, NULL);
		if (rec_id == grecid)
			rec_num = i;
		retval = DataGetField(dbid, rec_id, 0, &buffer, &byte_read);
		ListInsertItem(LIST_TITLE, i, (BYTE *)buffer);
		qfree(buffer);
		
		retval = DataCloseRecord(dbid, rec_id);
	}
	
	if (total_rec > 12)
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_SKETCH_LIST, TRUE);
		FormGetObjectPointer(SCROLLBAR_SKETCH_LIST, &object_type, (void**)&scroll_ptr);
		scroll_ptr->scrollbar_draw_pagesize = 12;
		if (rec_num == -1)
		{
			ScrollbarSetScrollbar(SCROLLBAR_SKETCH_LIST, 0, total_rec-12, 0, 12, total_rec);
			ListSetTopItemNum(LIST_TITLE, 0);
		}
		else if (total_rec - 12 > rec_num)
		{
			ScrollbarSetScrollbar(SCROLLBAR_SKETCH_LIST, rec_num, total_rec-12, 0, 12, total_rec);
			ListSetTopItemNum(LIST_TITLE, rec_num);
		}
		else
		{
			ScrollbarSetScrollbar(SCROLLBAR_SKETCH_LIST, total_rec -12, total_rec-12, 0, 12, total_rec);
			ListSetTopItemNum(LIST_TITLE, total_rec - 12);
		}
	}
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_SKETCH_LIST, FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_SKETCH_LIST);
	}
}


void SketchAppSave()
{
	BYTE        *info;
	BYTE        *buffer;
	UWORD       byte_read;
	ObjectID    active_form_id;
	
	ObjectID control_id;
	if (DataRecordInfo(dbid, SKETCH_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(dbid, SKETCH_STATUS, 0, 1);
	if (DataRecordInfo(dbid, SKETCH_EDIT_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(dbid, SKETCH_EDIT_INFO, 0, 13);
	
	DataWriteField(dbid, SKETCH_STATUS, 0, 1, &application_status);
	DataWriteField(dbid, SKETCH_EDIT_INFO, 0, sizeof(RecordID), (BYTE*)&grecid);
	DataWriteField(dbid, SKETCH_EDIT_INFO, 1, sizeof(BOOLEAN), (BYTE*)&sketch_new);
	DataWriteField(dbid, SKETCH_EDIT_INFO, 2, sizeof(BOOLEAN), (BYTE*)&sketch_alphabet);
	DataWriteField(dbid, SKETCH_EDIT_INFO, 4, sizeof(BOOLEAN), (BYTE*)&sketch_change);
	DataWriteField(dbid, SKETCH_EDIT_INFO, 6, sizeof(BOOLEAN), (BYTE*)&sketch_rename);
	DataWriteField(dbid, SKETCH_EDIT_INFO, 5, sizeof(BYTE), (BYTE*)&font_size);
	
	if (sketch_select == TRUE)
	{
		sketch_select = FALSE;
		LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
		LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
        FormGetActiveFormID(&active_form_id);
		if (active_form_id != FORM_SKETCH_DRAW && active_form_id != FORM_SKETCH_LIST)
            FormDrawForm(FORM_SKETCH_DRAW);		
		SketchGetBitmap();
		pfree(full_bmp1.bitmap_data);
		pfree(part_bmp3.bitmap_data);
	}
	else if (application_status != RESTART_SKETCH_TEXT &&
		application_status != RESTART_SKETCH_SAVE &&
		application_status != RESTART_SKETCH_ERASE)
	{
		
		MenuCloseMenu();
		KeyboardRestoreBitBehind();
        FormGetActiveFormID(&active_form_id);
		if (active_form_id != FORM_SKETCH_DRAW && active_form_id != FORM_SKETCH_LIST)
            FormDrawForm(FORM_SKETCH_DRAW);
		
		SketchGetBitmap();
		pfree(full_bmp1.bitmap_data);
	}
	
	DataWriteField(dbid, SKETCH_EDIT_INFO, 3, sizeof(BOOLEAN), (BYTE*)&sketch_select);
	DataWriteField(dbid, SKETCH_EDIT_INFO, 7, full_bmp4.size, (BYTE*)full_bmp4.bitmap_data);
	pfree(full_bmp4.bitmap_data);
	
	//if (application_status == RESTART_SKETCH_INFO)
	//{
	
	if (TextboxGetTextPointer(TEXTBOX_SKETCH_INFO, &info) == TRUE)
		DataWriteField(dbid, SKETCH_EDIT_INFO, 10, strlen((BYTE*)info) + 1, (BYTE*)info);
	else		
		DataWriteField(dbid, SKETCH_EDIT_INFO, 10, 1, (BYTE*)(""));
	//}
	
	
	if (application_status == RESTART_SKETCH_DRAW ||
		application_status == RESTART_SKETCH_TEXT ||
		application_status == RESTART_SKETCH_SAVE ||
		application_status == RESTART_SKETCH_ERASE)
	{
		if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 0, &control_id) == TRUE)
			DataWriteField(dbid, SKETCH_EDIT_INFO, 11, sizeof(ObjectID), (BYTE*)&control_id);
		else
		{
			control_id = 0;
			DataWriteField(dbid, SKETCH_EDIT_INFO, 11, sizeof(ObjectID), (BYTE*)&control_id);
		}
		
		if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 1, &control_id) == TRUE)
			DataWriteField(dbid, SKETCH_EDIT_INFO, 12, sizeof(ObjectID), (BYTE*)&control_id);
		else
		{
			control_id = 0;
			DataWriteField(dbid, SKETCH_EDIT_INFO, 12, sizeof(ObjectID), (BYTE*)&control_id);
		}
	}
	DataCloseDB(dbid);
}

void SketchAppRestore(BOOLEAN restart)
{
	BYTE *buffer;
	UWORD byte_read;
	ObjectID control_id;
	BYTE obj_type;
	void *addr;
	UWORD rec_num;
	BYTE *text_ptr;
	
	FormInitAllFormObjects(FORM_SKETCH_LIST);
	FormInitAllFormObjects(FORM_SKETCH_INFO);
	FormInitAllFormObjects(FORM_SKETCH_DRAW);
	FormInitAllFormObjects(FORM_INPUT_TEXT);
	FormInitAllFormObjects(FORM_CONFIRM_ERASE);
	FormInitAllFormObjects(FORM_SAVE_CHANGES);
	
	
	font_size = SMALL_FONT;
	
	sketch_new = FALSE;
	sketch_alphabet = FALSE;
	sketch_select = FALSE;
	sketch_change = FALSE;
	sketch_goto = FALSE;
	sketch_clear_undo = FALSE;
	
	full_bmp1.xcoord = 4;
	full_bmp1.ycoord = 19;
	full_bmp1.width = 153;
	full_bmp1.height = 122;
	full_bmp1.size = 0;
	full_bmp4.xcoord = 4;
	full_bmp4.ycoord = 19;
	full_bmp4.width = 153;
	full_bmp4.height = 122;
	full_bmp4.size = 0;
	part_bmp3.size = 0;
	
	
	if (restart == TRUE)
	{
		application_status = RESTART_SKETCH;
		FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
		LcdGetBitmap(&full_bmp1);
		(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
		(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
		BmpQ4ToBmpQ1(&full_bmp1, &full_bmp4);
		FormPopupForm(FORM_SKETCH_LIST);
	}
	else
	{
		DataGetField(dbid, SKETCH_STATUS, 0, &buffer, &byte_read);
		application_status = (BYTE)(*buffer);
		qfree(buffer);
		DataGetField(dbid, SKETCH_EDIT_INFO, 0, &buffer, &byte_read);
		grecid = *(RecordID *)buffer;
		qfree(buffer);
		DataGetField(dbid, SKETCH_EDIT_INFO, 2, &buffer, &byte_read);
		sketch_alphabet = *(BOOLEAN *)buffer;
		qfree(buffer);
		DataGetField(dbid, SKETCH_EDIT_INFO, 3, &buffer, &byte_read);
		sketch_select = *(BOOLEAN *)buffer;
		qfree(buffer);
		DataGetField(dbid, SKETCH_EDIT_INFO, 4, &buffer, &byte_read);
		sketch_change = *(BOOLEAN *)buffer;
		qfree(buffer);
		DataGetField(dbid, SKETCH_EDIT_INFO, 6, &buffer, &byte_read);
		sketch_rename = *(BOOLEAN *)buffer;
		qfree(buffer);
		DataGetField(dbid, SKETCH_EDIT_INFO, 5, &buffer, &byte_read);
		font_size = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(dbid, SKETCH_EDIT_INFO, 1, &buffer, &byte_read);
		sketch_new = *(BOOLEAN *)buffer;
		qfree(buffer);
		
		if (sketch_new == TRUE)
		{
			MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_RENAME);
			MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_DELETE);
		}
		
		
		DataGetField(dbid, SKETCH_EDIT_INFO, 7, &buffer, &byte_read);
		full_bmp4.bitmap_data = (UWORD*)buffer;
		BmpQ1ToBmpQ4(&full_bmp4, &full_bmp1);
		FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
		(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
		(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
		
		DataGetField(dbid, SKETCH_EDIT_INFO, 10, &buffer, &byte_read);
		TextboxSetText(TEXTBOX_SKETCH_INFO, buffer);
		qfree(buffer);
		
		if (application_status == RESTART_SKETCH)
			FormPopupForm(FORM_SKETCH_LIST);
		else if (application_status == RESTART_SKETCH_INFO)
		{
			DataGetField(dbid, SKETCH_EDIT_INFO, 10, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_SKETCH_INFO, buffer);
			qfree(buffer);
			
			//if (sketch_new == TRUE)
			//	TextboxSetText(TEXTBOX_SKETCH_INFO, (BYTE *)"");
			
			
			TextboxGetTextPointer(TEXTBOX_SKETCH_INFO, &text_ptr);
			if (text_ptr[0] != 0)
				StringSetText(STRING_SKETCH_TITLE, text_ptr);
			else
				StringSetText(STRING_SKETCH_TITLE, SKETCH_NOTITLE);
			FormDrawForm(FORM_SKETCH_DRAW);
			FormPopupForm(FORM_SKETCH_INFO);
		}
		else if (application_status == RESTART_SKETCH_DRAW ||
			application_status == RESTART_SKETCH_TEXT ||
			application_status == RESTART_SKETCH_SAVE ||
			application_status == RESTART_SKETCH_ERASE)
		{
			DataGetField(dbid, SKETCH_EDIT_INFO, 10, &buffer, &byte_read);
			TextboxSetText(TEXTBOX_SKETCH_INFO, buffer);
			qfree(buffer);
			
			DataGetField(dbid, SKETCH_EDIT_INFO, 11, &buffer, &byte_read);
			if ((ObjectID)(*buffer) != 0)
			{
				if (FormGetObjectPointer((ObjectID)*buffer, &obj_type, &addr) == TRUE)
					((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
			}
			qfree(buffer);
			
			DataGetField(dbid, SKETCH_EDIT_INFO, 12, &buffer, &byte_read);
			if ((ObjectID)(*buffer) != 0)
			{
				if (FormGetObjectPointer((ObjectID)*buffer, &obj_type, &addr) == TRUE)
					((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
			}
			qfree(buffer);
			FormPopupForm(FORM_SKETCH_DRAW);
		}
	}
}

void SketchGotoItem(DatabaseID dbid, RecordID goto_rec_id, USHORT field_num, BYTE *search_string)
{
#ifdef PR31700
	WORD	total_num_lines;
	WORD	highlight_char_pos =0, line_num;
	UWORD	rec_num;
	BOOLEAN	found =FALSE;
	Textbox	*addr;
	UWORD	byte_read;
	BYTE	sorted_by, *buffer, object_type;
	BYTE obj_type;
	grecid = goto_rec_id;
	
	FormInitAllFormObjects(FORM_SKETCH_LIST);
	FormInitAllFormObjects(FORM_SKETCH_INFO);
	FormInitAllFormObjects(FORM_SKETCH_DRAW);
	FormInitAllFormObjects(FORM_INPUT_TEXT);
	FormInitAllFormObjects(FORM_CONFIRM_ERASE);
	FormInitAllFormObjects(FORM_SAVE_CHANGES);
	
	if (DataRecordInfo(dbid, SKETCH_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
		font_size = SMALL_FONT;
	else
	{		
		DataGetField(dbid, SKETCH_EDIT_INFO, 5, &buffer, &byte_read);
		font_size = (BYTE)(*buffer);
		qfree(buffer);
		SketchMenuSetFont(font_size);
	}		
	
	sketch_new = FALSE;
	sketch_alphabet = FALSE;
	sketch_select = FALSE;
	sketch_change = FALSE;
	sketch_goto = TRUE;
	sketch_clear_undo = FALSE;
	
	full_bmp1.xcoord = 4;
	full_bmp1.ycoord = 19;
	full_bmp1.width = 153;
	full_bmp1.height = 122;
	full_bmp1.size = 0;
	full_bmp4.xcoord = 4;
	full_bmp4.ycoord = 19;
	full_bmp4.width = 153;
	full_bmp4.height = 122;
	full_bmp4.size = 0;
	part_bmp3.size = 0;
	
	
	FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
	LcdGetBitmap(&full_bmp1);
	(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
	(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
	BmpQ4ToBmpQ1(&full_bmp1, &full_bmp4);
	FormPopupForm(FORM_SKETCH_LIST);
	
	FormGetObjectPointer(TEXTBOX_SKETCH_INFO, &object_type, (void **)&addr);
	
	/* Goto to select text */
	if (search_string != NULL)
	{
		sketch_new = FALSE;
		DataRecIDtoNum(dbid, grecid, &rec_num);
		SketchOpenRecord(rec_num);
		FormPopupForm(FORM_SKETCH_DRAW);
	}
	
#endif
}
void SketchNewRecord()
{
	ObjectID control_id;
	BYTE obj_type;
	BYTE *text_ptr;
	WORD num_char;
	void *addr;
	
	BYTE *buffer;
	UWORD byte_read;
	
	if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 0, &control_id) == TRUE)
	{
		FormGetObjectPointer(control_id, &obj_type, &addr);
		((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = FALSE;
	}
	
	FormGetObjectPointer(CHECKBOX_SKETCH_PEN, &obj_type, &addr);
	((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
	
	if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 1, &control_id) == TRUE)
	{
		FormGetObjectPointer(control_id, &obj_type, &addr);
		((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = FALSE;
	}
	
	FormGetObjectPointer(CHECKBOX_SKETCH_THICK1, &obj_type, &addr);
	((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
}

void SketchSaveRecordText()
{
	ObjectID control_id;
	BYTE obj_type;
	BYTE *text_ptr;
	WORD num_char;
	void *addr;
	
	BYTE *buffer;
	UWORD byte_read;
	
	UWORD rec_num;
	if (DataRecIDtoNum(dbid, grecid, &rec_num) != TRUE)
	{
		SketchSaveNewRecord();
		DataRecIDtoNum(dbid, grecid, &rec_num);
	}
	retval = DataOpenRecord(dbid, rec_num, &grecid, NULL);
	TextboxGetNumOfChars(TEXTBOX_SKETCH_INFO, &num_char);
	if (num_char == 0)
		TextboxSetText(TEXTBOX_SKETCH_INFO, SKETCH_NOTITLE);
	TextboxGetTextPointer(TEXTBOX_SKETCH_INFO, &text_ptr);
	retval = DataWriteField(dbid, grecid, 0, strlen(text_ptr)+1, (BYTE *)text_ptr);
	
	retval = DataCloseRecord(dbid, grecid);
}

void SketchSaveRecord()
{
	ObjectID control_id;
	BYTE obj_type;
	BYTE *text_ptr;
	WORD num_char;
	void *addr;
	
	BYTE *buffer;
	UWORD byte_read;
	
	UWORD rec_num;
	DataRecIDtoNum(dbid, grecid, &rec_num);
	
	retval = DataOpenRecord(dbid, rec_num, &grecid, NULL);
	
	retval = DataWriteField(dbid, grecid, 1, full_bmp4.size, (BYTE *)(full_bmp4.bitmap_data));
	
	
	retval = DataCloseRecord(dbid, grecid);
}

void SketchSaveNewRecord()
{
	retval = DataNewRecord(dbid, 0, 2, &grecid);
	
	retval = DataWriteField(dbid, grecid, 0, strlen(SKETCH_NOTITLE)+1, SKETCH_NOTITLE);
	
	retval = DataWriteField(dbid, grecid, 1, full_bmp4.size, (BYTE *)(full_bmp4.bitmap_data));
	
	retval = DataCloseRecord(dbid, grecid);
}

void SketchSaveRecordMemo()
{
	UWORD   rec_num;
	BYTE    *buffer;
	UWORD	byte_read;
	BOOLEAN sketch_memo_status;
	BYTE	memo_call;
	
	if (DataFindDB(MEMODB, &dbid) == TRUE)
	{
		retval = DataOpenDB(dbid, SORT_TEXT_MODE|0, OPEN_RW);
	}
	
	DataGetField(dbid, MEMO_STATUS, 0, &buffer, &byte_read);
	memo_call = *buffer;
	qfree(buffer);
	
	if (memo_call == RESTART_MEMO_NEW)
	{
		sketch_memo_status = TRUE;
		DataWriteField(dbid, MEMO_EDIT_INFO, 1, 1, (BYTE*)&sketch_memo_status);
		DataWriteField(dbid, MEMO_EDIT_INFO, 17, full_bmp4.size, (BYTE *)(full_bmp4.bitmap_data));
		return;
	}
	
	DataRecIDtoNum(dbid, grecid, &rec_num);
	retval = DataOpenRecord(dbid, rec_num, &grecid, NULL);
	sketch_memo_status = TRUE;
	retval = DataWriteField(dbid, grecid, cptr->sketch_status_num, sizeof(BYTE), (BYTE *)&sketch_memo_status);
	retval = DataWriteField(dbid, MEMO_EDIT_INFO, 1, 1, (BYTE*)&sketch_memo_status);
	retval = DataWriteField(dbid, grecid, cptr->sketch_field_num, full_bmp4.size, (BYTE *)(full_bmp4.bitmap_data));
	retval = DataCloseRecord(dbid, grecid);
}

void SketchOpenRecord(UWORD rec_num)
{
	ObjectID control_id;
	BYTE *buffer;
	UWORD byte_read;
	BYTE obj_type;
	void *addr;
	retval = DataOpenRecord(dbid, rec_num, &grecid, NULL);
	retval = DataGetField(dbid, grecid, 0, &buffer, &byte_read);
	TextboxSetText(TEXTBOX_SKETCH_INFO, (BYTE *)buffer);
	qfree(buffer);
	
	retval = DataGetField(dbid, grecid, 1, &buffer, &byte_read);
	FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
	pfree(full_bmp1.bitmap_data);
	pfree(full_bmp4.bitmap_data);
	full_bmp4.bitmap_data = (UWORD *)buffer;
	BmpQ1ToBmpQ4(&full_bmp4, &full_bmp1);
	(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
	(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
	retval = DataCloseRecord(dbid, grecid);
	
	if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 0, &control_id) == TRUE)
	{
		FormGetObjectPointer(control_id, &obj_type, &addr);
		((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = FALSE;
	}
	
	FormGetObjectPointer(CHECKBOX_SKETCH_PEN, &obj_type, &addr);
	((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
	
	if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 1, &control_id) == TRUE)
	{
		FormGetObjectPointer(control_id, &obj_type, &addr);
		((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = FALSE;
	}
	
	FormGetObjectPointer(CHECKBOX_SKETCH_THICK1, &obj_type, &addr);
	((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
}

void SketchBackMemo()
{
	void *cmd_ptr;
	DataCloseDB(dbid);
	cmd_ptr = (GotoRec*)pmalloc(sizeof(GotoRec));
	((GotoRec*)cmd_ptr)->app_id = SysGetActiveAppID();
	((GotoRec*)cmd_ptr)->dbid = dbid;
	((GotoRec*)cmd_ptr)->rec_id = cptr->rec_id;
	((GotoRec*)cmd_ptr)->field_num = 0;
	((GotoRec*)cmd_ptr)->find_string = NULL;
	sketch_memo_unconditional_exit = FALSE;
	EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
	EvtAppendEvt(EVT_APP_LAUNCH, cptr->app_id, cptr->return_mode, 0, cmd_ptr);
	pfree(cptr);
}

void SketchEraseRecordMemo()
{
	UWORD rec_num;
	BOOLEAN sketch_memo_status;
	BYTE memo_call;
	BYTE *buffer;
	UWORD byte_read;
	
	// =================================================================================
	// modified at 24062000
	if (DataFindDB(MEMODB, &dbid) == TRUE)
	{
		retval = DataOpenDB(dbid, SORT_TEXT_MODE|0, OPEN_RW);
	}
	
	DataGetField(dbid, MEMO_STATUS, 0, &buffer, &byte_read);
	memo_call = *buffer;
	qfree(buffer);
	
	if (memo_call == RESTART_MEMO_NEW)
	{
		sketch_memo_status = FALSE;
		DataWriteField(dbid, MEMO_EDIT_INFO, 1, 1, (BYTE*)&sketch_memo_status);
		return;
	}
	else
		DataRecIDtoNum(dbid, grecid, &rec_num);
	// =================================================================================
	
	retval = DataOpenRecord(dbid, rec_num, &grecid, NULL);
	sketch_memo_status = FALSE;
	retval = DataWriteField(dbid, grecid, cptr->sketch_status_num, sizeof(BYTE), (BYTE *)&sketch_memo_status);
	retval = DataWriteField(dbid, grecid, cptr->sketch_field_num, 0, (BYTE *)NULL);
	retval = DataCloseRecord(dbid, grecid);
}
