/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   skhlch.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "Skhfunc.h"
#include "slang.h"

//#define DEBUG
//#define DEBUG_HENRY

BOOLEAN SketchAppLaunch(WORD cmd, void *cmd_ptr)
{
#ifdef PR31700
	UWORD		num_rec, count, byte_read;
	USHORT		field_num;
	BYTE		*buffer, *prepare_string;
	RecordID	rec_id;
	AppID		app_id;
	ObjectID    active_form_id;
#endif
#ifdef DEBUG
	printf("\n*** Sketch Lanuch Start ***\n");
#endif
	
	if (cmd == LAUNCH_CMD_GOTO_REC && DataRecordInfo(((GotoRec*)cmd_ptr)->dbid, ((GotoRec*)cmd_ptr)->rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		if (((GotoRec*)cmd_ptr)->find_string != NULL)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		
		cmd = LAUNCH_CMD_NORMAL_LAUNCH;
	}
	
	switch(cmd)
	{
	case	LAUNCH_CMD_NORMAL_LAUNCH:
		UIApplicationInit();
		
		if (cmd_ptr != 0)
		{
			DataCloseDB(dbid);
			
			cptr = (MemoSketch *)cmd_ptr;
			
			SketchFromMemo();
		}
		else
			SketchAppRestore(restore_status);
		
		EventLoop();
		
		if (cmd_ptr == 0)
			SketchAppSave();
		else if (sketch_memo_unconditional_exit == TRUE)
		{
			if (sketch_select == TRUE)
			{
				sketch_select = FALSE;
				LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
				LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
				pfree(part_bmp3.bitmap_data);
			}
			else
			{
				MenuCloseMenu();
				KeyboardRestoreBitBehind();					
				FormGetActiveFormID(&active_form_id);
				if (active_form_id != FORM_SKETCH_DRAW && active_form_id != FORM_SKETCH_LIST)
					FormDrawForm(FORM_SKETCH_DRAW);
			}
			SketchGetBitmap();
			if (sketch_change == TRUE)
			{
				SketchSaveRecordMemo();
			}
			DataCloseDB(dbid);
			pfree(cptr);
		}
#ifdef PC_SIM
		SketchAppRestore(FALSE);
		EventLoop();
#endif
		UIDeleteAllAppObjects();
		return TRUE;
		
	case	LAUNCH_CMD_FIND:
#ifdef PR31700
		app_id = SysGetActiveAppID();
		DataTotalRecord(dbid, &num_rec);
		
		for (count =0; count<num_rec; count++)
		{
			DataOpenRecord(dbid, count, &rec_id, NULL);
			
			DataGetField(dbid, rec_id, 0, &buffer, &byte_read);
			
			if (GlobalFindSearchText((BYTE*)cmd_ptr, buffer) >= 0)
			{
				SketchPrepareFindText(dbid, rec_id, &prepare_string);
#ifdef PR31700
				GlobalFindAddItem(app_id, dbid, rec_id, 0, prepare_string, FALSE);
#else
				GlobalFindAddItem(app_id, dbid, rec_id, 0, prepare_string);
#endif
				pfree(prepare_string);
			}
			qfree(buffer);
			DataCloseRecord(dbid, rec_id);
		}
		if (cmd_ptr != NULL)
			pfree(cmd_ptr);
#endif
		return TRUE;
		
	case	LAUNCH_CMD_GOTO_REC:
		SketchGotoItem(((GotoRec*)cmd_ptr)->dbid, ((GotoRec*)cmd_ptr)->rec_id,
			((GotoRec*)cmd_ptr)->field_num, ((GotoRec*)cmd_ptr)->find_string);
		
		/* Check Goto from Find or Other Application */
		if (((GotoRec*)cmd_ptr)->find_string != NULL)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		
		EventLoop();
		/* Exit Goto Record */
		SketchAppSave();
		UIDeleteAllAppObjects();
     			return TRUE;
				
	default:
		return FALSE;
	}
	return FALSE;
}


void SketchFromMemo()
{
	BYTE *buffer;
	UWORD byte_read;
	BYTE obj_type;
	UWORD rec_num;
	ObjectID control_id;
	void *addr;
	BYTE	memo_call;
	BOOLEAN sketch_memo_status;
	Err	retval;
	
	
	FormInitAllFormObjects(FORM_SKETCH_LIST);
	FormInitAllFormObjects(FORM_SKETCH_INFO);
	FormInitAllFormObjects(FORM_SKETCH_DRAW);
	FormInitAllFormObjects(FORM_INPUT_TEXT);
	FormInitAllFormObjects(FORM_CONFIRM_ERASE);
	FormInitAllFormObjects(FORM_SAVE_CHANGES);
	
	
	sketch_alphabet = FALSE;
	sketch_select = FALSE;
	sketch_change = FALSE;
	sketch_goto = FALSE;
	
	sketch_memo_unconditional_exit = TRUE;
	
	full_bmp1.xcoord = 4;
	full_bmp1.ycoord = 19;
	full_bmp1.width = 153;
	full_bmp1.height = 122;
	full_bmp1.size = 0;
	full_bmp4.xcoord = 4;
	full_bmp4.ycoord = 19;
	full_bmp4.width = 153;
	full_bmp4.height = 122;
	full_bmp4.size = 0;
	part_bmp3.size = 0;
	
	if (DataFindDB(MEMODB, &dbid) == TRUE)
	{
		sketch_memo = TRUE;
		retval = DataOpenDB(dbid, SORT_TEXT_MODE|0, OPEN_RW);
	}
	
	DataGetField(dbid, MEMO_STATUS, 0, &buffer, &byte_read);
	memo_call = *buffer;
	qfree(buffer);
	
	DataGetField(dbid, MEMO_EDIT_INFO, 1, &buffer, &byte_read);
	sketch_memo_status = (BOOLEAN)(*(BYTE *)buffer);
	qfree(buffer);
	
	if (memo_call == RESTART_MEMO_NEW)
	{
		if (sketch_memo_status == TRUE)
		{
			sketch_new = FALSE;
			retval = DataGetField(dbid, MEMO_EDIT_INFO, 17, &buffer, &byte_read);
			full_bmp4.bitmap_data = (UWORD *)buffer;
			BmpQ1ToBmpQ4(&full_bmp4, &full_bmp1);
			qfree(buffer);
			
			FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
			
			(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
			(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
		}
		else
		{
			sketch_new = TRUE;
			FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
			LcdGetBitmap(&full_bmp1);
			memset(full_bmp1.bitmap_data, 0, full_bmp1.size);
			(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
			(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
			BmpQ4ToBmpQ1(&full_bmp1, &full_bmp4);
			
			MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_RENAME);
			MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_DELETE);
		}
		
		FormGetObjectPointer(CHECKBOX_SKETCH_PEN, &obj_type, &addr);
		((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
		
		MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_RENAME);
		
		FormPopupForm(FORM_SKETCH_DRAW);
		
		return;
	}
	
	
	DataRecIDtoNum(dbid, cptr->rec_id, &rec_num);
	retval = DataOpenRecord(dbid, rec_num, &grecid, NULL);
	retval = DataGetField(dbid, grecid, cptr->sketch_status_num, &buffer, &byte_read);
	
	if (*(BYTE *)buffer == TRUE)
	{
		sketch_new = FALSE;
		qfree(buffer);
		retval = DataGetField(dbid, grecid, cptr->sketch_field_num, &buffer, &byte_read);
		FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
		full_bmp4.bitmap_data = (UWORD *)buffer;
		BmpQ1ToBmpQ4(&full_bmp4, &full_bmp1);
		
		(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
		(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
	}
	else
	{
		sketch_new = TRUE;
		FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
		LcdGetBitmap(&full_bmp1);
		memset(full_bmp1.bitmap_data, 0, full_bmp1.size);
		(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
		(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
		BmpQ4ToBmpQ1(&full_bmp1, &full_bmp4);
		
		MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_RENAME);
		MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_DELETE);
	}
	
	FormGetObjectPointer(CHECKBOX_SKETCH_PEN, &obj_type, &addr);
	((ControlTemplateCheckBox *)(((Control *)addr)->control_template))->control_value = TRUE;
	
	MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_RENAME);
	
	FormPopupForm(FORM_SKETCH_DRAW);
}

