/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "system.h"
#include "SySdef.h"
#include "SySetup.h"
#include "syslang.h"

//extern UWORD _fdata, etext, _fbss, ebss;

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);
extern REGISTRY app_reg[];


#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
AppID app_id;
extern UBYTE res_data [];
UBYTE sysres_data[1];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
			
		case FORM_SYSETUP_MENU:
			FormSetEventHandler(FORM_SYSETUP_MENU, (void**)&FormDispatchEvent, SySetupMenu);
			break;
			
		case FORM_SYSETUP_CLOCK:
			FormSetEventHandler(FORM_SYSETUP_CLOCK, (void**)&FormDispatchEvent, SySetupClock);
			break;
			
		case FORM_SYSETUP_KEY_MAPPING:
			FormSetEventHandler(FORM_SYSETUP_KEY_MAPPING, (void**)&FormDispatchEvent, SySetupKeyMapping);
			break;
			
		case FORM_SYSETUP_CLOCK_12HR:
			FormSetEventHandler(FORM_SYSETUP_CLOCK_12HR, (void**)&FormDispatchEvent, SySetupClock12Hr);
			break;
			
		case FORM_SYSETUP_CLOCK_24HR:
			FormSetEventHandler(FORM_SYSETUP_CLOCK_24HR, (void**)&FormDispatchEvent, SySetupClock24Hr);
			break;
			
		case FORM_SYSETUP_SCRCAL:
			FormSetEventHandler(FORM_SYSETUP_SCRCAL, (void**)&FormDispatchEvent, SySetupScrCal);
			break;
			
		case FORM_SYSETUP_SOUND:
			FormSetEventHandler(FORM_SYSETUP_SOUND, (void**)&FormDispatchEvent, SySetupSound);
			break;
			
		case FORM_SYSETUP_SYSINFO:
			FormSetEventHandler(FORM_SYSETUP_SYSINFO, (void**)&FormDispatchEvent, SySetupSysInfo);
			break;
			
		case FORM_SYSETUP_SYSINFO_DELAPP:
			FormSetEventHandler(FORM_SYSETUP_SYSINFO_DELAPP, (void**)&FormDispatchEvent, SySetupSysInfoDelApp);
			break;
			
		case FORM_SYSETUP_PASSWORD:
			FormSetEventHandler(FORM_SYSETUP_PASSWORD, (void**)&FormDispatchEvent, SySetupPassword);
			break;
			
		case FORM_SYSETUP_PASSWORD_ENTER:
			FormSetEventHandler(FORM_SYSETUP_PASSWORD_ENTER, (void**)&FormDispatchEvent, SySetupPasswordEnter);
			break;
			
		case FORM_SYSETUP_PASSWORD_HINTS:
			FormSetEventHandler(FORM_SYSETUP_PASSWORD_HINTS, (void**)&FormDispatchEvent, SySetupPasswordHints);
			break;
			
		case FORM_SYSETUP_PASSWORD_FAILURE:
			FormSetEventHandler(FORM_SYSETUP_PASSWORD_FAILURE, (void**)&FormDispatchEvent, SySetupPasswordFailure);
			break;
			
		case FORM_SYSETUP_PASSWORD_ERASE:
			FormSetEventHandler(FORM_SYSETUP_PASSWORD_ERASE, (void**)&FormDispatchEvent, SySetupPasswordErase);
			break;
			
		case FORM_SYSETUP_PASSWORD_SUCCESS:
			FormSetEventHandler(FORM_SYSETUP_PASSWORD_SUCCESS, (void**)&FormDispatchEvent, SySetupPasswordSuccess);
			break;
			
		case FORM_SYSETUP_COUNTRY:
			FormSetEventHandler(FORM_SYSETUP_COUNTRY, (void**)&FormDispatchEvent, SySetupCountry);
			break;
			
		case FORM_SYSETUP_MODEM:
			FormSetEventHandler(FORM_SYSETUP_MODEM, (void**)&FormDispatchEvent, SySetupModem);
			break;
			
		case FORM_SYSETUP_MODEM_CUSTOM:
			FormSetEventHandler(FORM_SYSETUP_MODEM_CUSTOM, (void**)&FormDispatchEvent, SySetupModemCustom);
			break;
			
		case FORM_SYSETUP_DATE:
			FormSetEventHandler(FORM_SYSETUP_DATE, (void**)&FormDispatchEvent, SySetupDate);
			break;
			
		case FORM_SYSETUP_OWNINFO:
			FormSetEventHandler(FORM_SYSETUP_OWNINFO, (void**)&FormDispatchEvent, SySetupOwnInfo);
			break;
			
		case FORM_SYSETUP_EMAIL:
			FormSetEventHandler(FORM_SYSETUP_EMAIL, (void**)&FormDispatchEvent, SySetupEmail);
			break;
			
		case FORM_SYSETUP_EMAIL2:
			FormSetEventHandler(FORM_SYSETUP_EMAIL2, (void**)&FormDispatchEvent, SySetupEmail2);
			break;
			
		case FORM_SYSETUP_DIALOG_LOW_MEMORY:
			FormSetEventHandler(FORM_SYSETUP_DIALOG_LOW_MEMORY, (void**)&FormDispatchEvent, SySetupDialogLowMemory);
			break;
			
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	//----------------------------------------------------------------------------------------------
	//------- For Hardware Keyboard's key ----------------------------------------------------------
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)	
	{
		if ((Event->para2 & 0x00000200))
		{
			FormGetActiveFormID(&form_id);
			switch (form_id)
			{
			case FORM_SYSETUP_MENU:
				switch (Event->para1)
				{
				case LLETTER_MENU_CLOCK:
				case SLETTER_MENU_CLOCK:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_CLOCK;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_SCRCAL:
				case SLETTER_MENU_SCRCAL:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_SCRCAL;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_SOUND:
				case SLETTER_MENU_SOUND:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_SOUND;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_SYSINFO:
				case SLETTER_MENU_SYSINFO:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_SYSINFO;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_PASSWORD:
				case SLETTER_MENU_PASSWORD:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_PASSWORD;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_COUNTRY:
				case SLETTER_MENU_COUNTRY:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_COUNTRY;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_OWNERINFO:
				case SLETTER_MENU_OWNERINFO:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_OWNINFO;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_KEY:
				case SLETTER_MENU_KEY:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_KEY_MAPPING;
					Event->evtPBP		= NULL;
					break;
				case LLETTER_MENU_EMAIL:
				case SLETTER_MENU_EMAIL:
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_SYSETUP_MENU_EMAIL;
					Event->evtPBP		= NULL;
					break;
				default:
					break;
				}
				break;
				case FORM_SYSETUP_CLOCK:
					switch (Event->para1)
					{
					case '1':
						ControlPopupPopupTrigger(POPUP_SYSETUP_CLOCK_VIST_COUNTRY);
						break;
					case '2':
						ControlPopupPopupTrigger(POPUP_SYSETUP_CLOCK_HOME_COUNTRY);
						break;
					case '3':
						ControlPopupPopupTrigger(POPUP_SYSETUP_CLOCK_AUTOFFTIME);
						break;
					default:
						break;
					}
					break;
					case FORM_SYSETUP_COUNTRY:
						switch (Event->para1)
						{
						case '1':
							ControlPopupPopupTrigger(POPUP_SYSETUP_COUNTRY_REGIONAL);
							break;
						case '2':
							ControlPopupPopupTrigger(POPUP_SYSETUP_COUNTRY_TFORMAT);
							break;
						case '3':
							ControlPopupPopupTrigger(POPUP_SYSETUP_COUNTRY_DFORMAT);
							break;
						case '4':
							ControlPopupPopupTrigger(POPUP_SYSETUP_COUNTRY_START_WK);
							break;
						case '5':
							ControlPopupPopupTrigger(POPUP_SYSETUP_COUNTRY_NUM);
							break;
						default:
							break;
						}
						break;
						case FORM_SYSETUP_SYSINFO:
							if (Event->para1 == LLETTER_DEL_APP || Event->para1 == SLETTER_DEL_APP)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_SYSINFO_DELAPP;
								Event->evtPBP		= NULL;
							}
							else if (Event->para1 == '1')
								ControlPopupPopupTrigger(POPUP_SYSETUP_SYSINFO_SYNSPEED);
							
							break;
						case FORM_SYSETUP_SYSINFO_DELAPP:
							if (Event->para1 == LLETTER_DEL_APP || Event->para1 == SLETTER_DEL_APP)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_SYSINFO_DELAPP_DELAPP;
								Event->evtPBP		= NULL;
							}			
							break;
						case FORM_SYSETUP_PASSWORD:
							if (Event->para1 == LLETTER_HINT || Event->para1 == SLETTER_HINT)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_PASSWORD_HINTS;
								Event->evtPBP		= NULL;
							}			
							break;
						case FORM_SYSETUP_KEY_MAPPING:
							if (Event->para1 == LLETTER_KEY_DEFAULT || Event->para1 == SLETTER_KEY_DEFAULT)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_KEY_MAPPING_DEFAULT;
								Event->evtPBP		= NULL;
							}			
							else
							{
								switch (Event->para1)
								{
								case '1':
									ControlPopupPopupTrigger(POPUP_SYSETUP_KEY_MAPPING_KEY2);
									break;
								case '2':
									ControlPopupPopupTrigger(POPUP_SYSETUP_KEY_MAPPING_KEY4);
									break;
								case '3':
									ControlPopupPopupTrigger(POPUP_SYSETUP_KEY_MAPPING_KEY5);
									break;
								case '4':
									ControlPopupPopupTrigger(POPUP_SYSETUP_KEY_MAPPING_KEY1);
									break;
								case '5':
									ControlPopupPopupTrigger(POPUP_SYSETUP_KEY_MAPPING_KEY3);
									break;
								default:
									break;
								}
							}
							break;
						case FORM_SYSETUP_PASSWORD_SUCCESS:
							if (Event->para1 == LLETTER_OK || Event->para1 == SLETTER_OK)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_PASSWORD_SUCCESS_OK;
								Event->evtPBP		= NULL;
							}			
						case FORM_SYSETUP_PASSWORD_ENTER:
							if (Event->para1 == LLETTER_PASS_ENTER || Event->para1 == SLETTER_PASS_ENTER)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_PASSWORD_ENTER;
								Event->evtPBP		= NULL;
							}			
							break;
						case FORM_SYSETUP_PASSWORD_FAILURE:
							if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_PASSWORD_FAILURE_YES;
								Event->evtPBP		= NULL;
							}			
							else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_PASSWORD_FAILURE_NO;
								Event->evtPBP		= NULL;
							}			
							break;
						case FORM_SYSETUP_PASSWORD_ERASE:
							if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_PASSWORD_ERASE_YES;
								Event->evtPBP		= NULL;
							}			
							else if (Event->para1 == LLETTER_NO || Event->para1 == LLETTER_NO)
							{
								Event->eventType	= EVT_CONTROL_SELECT;
								Event->eventID		= BUTTON_SYSETUP_PASSWORD_ERASE_NO;
								Event->evtPBP		= NULL;
							}			
							break;
						case FORM_SYSETUP_EMAIL:
							if (Event->para1 == LLETTER_UP || Event->para1 == SLETTER_UP)
							{
								Event->eventType	= EVT_BITMAP_SELECT;
								Event->eventID		= BITMAP_SYSETUP_EMAIL_DNARW;
								Event->evtPBP		= NULL;
							}			
							break;
						case FORM_SYSETUP_EMAIL2:
							if (Event->para1 == LLETTER_DOWN || Event->para1 == SLETTER_DOWN)
							{
								Event->eventType	= EVT_BITMAP_SELECT;
								Event->eventID		= BITMAP_SYSETUP_EMAIL2_UPARW;
								Event->evtPBP		= NULL;
							}			
							break;
						case FORM_SYSETUP_DIALOG_LOW_MEMORY:
							if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
							{
								Event->eventType	= EVT_BITMAP_SELECT;
								Event->eventID		= BITMAP_SYSETUP_DIALOG_LOW_MEMORY_X;
								Event->evtPBP		= NULL;
							}			
							break;
							
						default:
							break;
			}
		}
	}
	return FALSE;
}
/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	
	do
	{
		EvtGetEvent (&event);
		if (!SySetupHandlePasswordTextboxStatus(&event) && !SySetupHandleEmailPasswords(&event))
		{
			if (!SystemHandleEvent(&event))
				if (!MenuHandleEvent(&event))
					if (!ApplicationHandleEvent(&event))
						FormDispatchEvent(&event);
		}
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}

/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void *cmd_ptr)
{
	SySetupAppLaunch(cmd, (void*)cmd_ptr);
}
