/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sysave.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "sysdef.h"
#include "alaunch.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
BYTE	ShortCutSysInfo;


/*****************************************************************
* Function:	SySetupAppSave
* Purpose: 	This function is called to save the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void SySetupAppSave(void)
{
	SySetupMainAppSave();
	
	return;
}


/********************************************************
* Function:	SySetupAppRestore
* Purpose: 	This function is called to restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restart		whether the application is restart or not
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SySetupAppRestore(void)
{
	BYTE		*buffer;
	UWORD		byte_read;
	DatabaseID	SySetup_dbid;
	
	SySetupInitMDBGlobal();
	
	if (DataFindDB(SYSETUPDB, &SySetup_dbid) != TRUE)
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_ActiveFormID, &buffer, &byte_read) != TRUE)
	{
		SySetupInitMainGlobal(TRUE);
		if (DataNewRecordWithID(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, 0, SYSETUP_MAIN_APP_SAVE_NFIELD) != TRUE)
			return FALSE;
		FormPopupForm(FORM_SYSETUP_MENU);
	}
	else
	{
		SySetupInitMainGlobal(FALSE);
		qfree(buffer);
		
	}
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
	
}



/********************************************************
* Function:	SySetupAppLaunch
* Purpose: 	This function is called to launch the 
SySetup application
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SySetupAppLaunch(WORD cmd, void *cmd_ptr)
{
	DatabaseID	SySetup_dbid;
	
	switch(cmd)
	{
	case LAUNCH_CMD_NORMAL_LAUNCH:
		SySetupSetCalPenMode(0);		
		UIApplicationInit();
		SySetupAppRestore();
		EventLoop();
		SySetupAppSave();
		UIDeleteAllAppObjects();
		return TRUE;
		
#ifdef PR31700			
	case LAUNCH_CMD_CAL_PEN:
		SySetupSetCalPenMode(1);
		AllApplicationDatabaseInit();
		UIApplicationInit();						
		SySetupInitMDBGlobal();
		
		DataFindDB(SYSETUPDB, &SySetup_dbid);
		DataOpenDB(SySetup_dbid, F_App, OPEN_RW);
		SySetupInitMainGlobal(TRUE);
		DataNewRecordWithID(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, 0, SYSETUP_MAIN_APP_SAVE_NFIELD);
		DataCloseDB(SySetup_dbid);							
		
		SySetupInitScrCalData();
		SySetupMenuGotoForm(FORM_SYSETUP_SCRCAL);    
		EventLoop();
		SySetupAppSave();
		UIDeleteAllAppObjects();
		return TRUE;
#endif
		
		/*
        case LAUNCH_CMD_BAT:
		UIApplicationInit();
		SySetupAppRestore();
		
		  BatChkMainLevel();
		  ShortCutSysInfo = 1;			
		  
			EventLoop();
			SySetupAppSave();
			UIDeleteAllAppObjects();
			return TRUE;
		*/
		
	case LAUNCH_CMD_FIND:
		SySetupSetCalPenMode(0);
		pfree(cmd_ptr);
		return TRUE;
		
	case LAUNCH_CMD_GOTO_REC:
		SySetupSetCalPenMode(0);
		if (((GotoRec*)cmd_ptr)->find_string)
			(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_ALARM_HIT:
		SySetupSetCalPenMode(0);
		pfree(cmd_ptr);
		return TRUE;
		
	default:
		SySetupSetCalPenMode(0);
		return FALSE;
	}
	return FALSE;
}



