/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sysmdb.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "sysdef.h"
#include "system.h"
#include "syslang.h"

//#define   DEBUG


/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern	UWORD		Tmr_Label;
extern	RTM			Gtimer;
extern	BYTE		Update_Timing;
extern	BYTE		login_password[];
extern	BYTE		email_password[];

BOOLEAN	home_day_clk, visit_day_clk;
/* R = 23 */
static SHORT CLOCK_HOME_HR_X[60];
/*
= {
118, 119, 120, 121, 122,	123, 124, 125, 126, 127,	127, 128, 128, 129, 129,
129, 129, 129, 128, 128,	127, 127, 126, 125, 124,	123, 122, 121, 120, 119,
118, 117, 116, 115, 114,	113, 112, 111, 110, 109,	109, 108, 108, 107, 107, 
107, 107, 107, 108, 108,	109, 109, 110, 111, 112,	113, 114, 115, 116, 117 
};
*/
static SHORT CLOCK_HOME_HR_Y[60];
/*
= {
36, 36, 36, 36,	37,		37, 38, 38, 39,	40,		41, 42, 43, 44,	45,
47, 49,	50, 51, 52,		53,	54, 55, 56,	56,		57, 57, 58, 58, 58,
58, 58,	58, 58, 57,		57,	56,	56, 55, 54,		53, 52, 51, 50, 49,
47,	45, 44, 43, 42,		41,	40, 39, 38, 38,		37,	37, 36, 36, 36 
};
*/

/* R = 25 */
/*
static SHORT CLOCK_HOME_MIN_X[60] = {
118, 120, 121, 122,	123,	124, 125, 126, 127,	128,	128, 129, 129, 130, 130,
130, 130, 130, 129,	129,	128, 128, 127, 126,	125,	124, 123, 122, 121, 120,
118, 116, 115, 114, 113,	112, 111, 110, 109, 108,	108, 107, 107, 106, 106, 
106, 106, 106, 107, 107,	108, 108, 109, 110, 111,	112, 113, 114, 115, 106 
};

  static SHORT CLOCK_HOME_MIN_Y[60] = {
  35, 35, 35, 36, 36,		37, 37, 38, 39,	40,		41, 42, 43, 44,	45,
  47, 49,	50, 51, 52,		53,	54, 55, 56,	57,		57, 58, 58, 59, 59,
  59, 59,	59, 58, 58,		57,	57,	56, 55, 54,		53, 52, 51, 50, 49,
  47,	45, 44, 43, 42,		41,	40, 39, 38, 37,		37, 36, 36, 35, 35 
  };
*/

/* R = 29 */
static SHORT CLOCK_HOME_MIN_X[60];
/*
= {
118, 120, 122, 123,	124,	125, 127, 128, 129, 130,	131, 131, 131, 132, 132,
132, 132, 132, 131, 131,	131, 130, 129, 128, 127,	125, 124, 123, 122, 120,
118, 116, 114, 113,	112,	111, 109, 108, 107, 106,	105, 105, 105, 104, 104,
104, 104, 104, 105, 105,	105, 106, 107, 108, 109,	111, 112, 113, 114, 116 
};
*/

static SHORT CLOCK_HOME_MIN_Y[60];
/*
= {
33, 33, 34, 34, 34,		35, 36,	37, 38, 40,		41, 42, 43, 44,	45,
47, 49,	50, 51, 52,		53,	54, 56,	57, 58,		59, 60, 60, 60, 61,
61, 61, 60, 60, 60,		59, 58,	57,	56,	54,		53, 52, 51, 50, 49,
47,	45, 44, 43, 42,		41,	40, 38, 37, 36,		35, 34, 34, 34, 33 
};
*/

/* time difference for clock settings*/
static BYTE	TIME_DIFF[101];
/*
= {
-7, 0, -13
};*/

static CountrySP	COUNTRY_SP[28];

//ScrCalData			SCR_CAL_COUNT[NUM_SCR_CAL_SAMPLE];
WORD				ScrCalCBufX[NUM_SCR_CAL_SAMPLE];
WORD				ScrCalCBufY[NUM_SCR_CAL_SAMPLE];
//UWORD				XScrCounter, YScrCounter;
USHORT				G_total_app, G_total_dd;
DelAppData			*G_del_app_ptr, *G_del_dd_ptr;



/*****************************************************************
* Function:	SySetupInitMDBGlobal
* Purpose: 	This function is used to initialize the global variables
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void SySetupInitMDBGlobal(void)
{
	
	home_day_clk = FALSE;
	visit_day_clk = FALSE;
	
	/* R = 23 */
	CLOCK_HOME_HR_X[0] = 	107;
	CLOCK_HOME_HR_X[1] = 	108;
	CLOCK_HOME_HR_X[2] = 	109;
	CLOCK_HOME_HR_X[3] = 	110;
	CLOCK_HOME_HR_X[4] = 	111;
	CLOCK_HOME_HR_X[5] = 	112;
	CLOCK_HOME_HR_X[6] = 	113;
	CLOCK_HOME_HR_X[7] = 	114;
	CLOCK_HOME_HR_X[8] = 	115;
	CLOCK_HOME_HR_X[9] = 	116;
	CLOCK_HOME_HR_X[10] = 	116;
	CLOCK_HOME_HR_X[11] = 	117;
	CLOCK_HOME_HR_X[12] = 	117;
	CLOCK_HOME_HR_X[13] = 	118;
	CLOCK_HOME_HR_X[14] = 	118;
	CLOCK_HOME_HR_X[15] = 	118;
	CLOCK_HOME_HR_X[16] = 	118;
	CLOCK_HOME_HR_X[17] = 	118;
	CLOCK_HOME_HR_X[18] = 	117;
	CLOCK_HOME_HR_X[19] = 	117;
	CLOCK_HOME_HR_X[20] = 	116;
	CLOCK_HOME_HR_X[21] = 	116;
	CLOCK_HOME_HR_X[22] = 	115;
	CLOCK_HOME_HR_X[23] = 	114;
	CLOCK_HOME_HR_X[24] = 	113;
	CLOCK_HOME_HR_X[25] = 	112;
	CLOCK_HOME_HR_X[26] = 	111;
	CLOCK_HOME_HR_X[27] = 	110;
	CLOCK_HOME_HR_X[28] = 	109;
	CLOCK_HOME_HR_X[29] = 	108;
	CLOCK_HOME_HR_X[30] = 	107;
	CLOCK_HOME_HR_X[31] = 	106;
	CLOCK_HOME_HR_X[32] = 	105;
	CLOCK_HOME_HR_X[33] = 	104;
	CLOCK_HOME_HR_X[34] = 	103;
	CLOCK_HOME_HR_X[35] = 	102;
	CLOCK_HOME_HR_X[36] = 	101;
	CLOCK_HOME_HR_X[37] = 	100;
	CLOCK_HOME_HR_X[38] = 	99;
	CLOCK_HOME_HR_X[39] = 	98;
	CLOCK_HOME_HR_X[40] = 	97;
	CLOCK_HOME_HR_X[41] = 	97;
	CLOCK_HOME_HR_X[42] = 	97;
	CLOCK_HOME_HR_X[43] = 	96;
	CLOCK_HOME_HR_X[44] = 	96; 
	CLOCK_HOME_HR_X[45] = 	96;
	CLOCK_HOME_HR_X[46] = 	96;
	CLOCK_HOME_HR_X[47] = 	96;
	CLOCK_HOME_HR_X[48] = 	97;
	CLOCK_HOME_HR_X[49] = 	97;
	CLOCK_HOME_HR_X[50] = 	98;
	CLOCK_HOME_HR_X[51] = 	98;
	CLOCK_HOME_HR_X[52] = 	99;
	CLOCK_HOME_HR_X[53] = 	100;
	CLOCK_HOME_HR_X[54] = 	101;
	CLOCK_HOME_HR_X[55] = 	102;
	CLOCK_HOME_HR_X[56] = 	103;
	CLOCK_HOME_HR_X[57] = 	104;
	CLOCK_HOME_HR_X[58] = 	105;
	CLOCK_HOME_HR_X[59] = 	106;
	
	CLOCK_HOME_HR_Y[0] = 36;
	CLOCK_HOME_HR_Y[1] = 36;
	CLOCK_HOME_HR_Y[2] = 36;
	CLOCK_HOME_HR_Y[3] = 36;
	CLOCK_HOME_HR_Y[4] = 37;
	CLOCK_HOME_HR_Y[5] = 37;
	CLOCK_HOME_HR_Y[6] = 38;
	CLOCK_HOME_HR_Y[7] = 38;
	CLOCK_HOME_HR_Y[8] = 39;
	CLOCK_HOME_HR_Y[9] = 40;
	CLOCK_HOME_HR_Y[10] = 41;
	CLOCK_HOME_HR_Y[11] = 42;
	CLOCK_HOME_HR_Y[12] = 43;
	CLOCK_HOME_HR_Y[13] = 44;
	CLOCK_HOME_HR_Y[14] = 45;
	CLOCK_HOME_HR_Y[15] = 47;
	CLOCK_HOME_HR_Y[16] = 49;
	CLOCK_HOME_HR_Y[17] = 50;
	CLOCK_HOME_HR_Y[18] = 51;
	CLOCK_HOME_HR_Y[19] = 52;
	CLOCK_HOME_HR_Y[20] = 53;
	CLOCK_HOME_HR_Y[21] = 54;
	CLOCK_HOME_HR_Y[22] = 55;
	CLOCK_HOME_HR_Y[23] = 56;
	CLOCK_HOME_HR_Y[24] = 56;
	CLOCK_HOME_HR_Y[25] = 57;
	CLOCK_HOME_HR_Y[26] = 57;
	CLOCK_HOME_HR_Y[27] = 58;
	CLOCK_HOME_HR_Y[28] = 58;
	CLOCK_HOME_HR_Y[29] = 58;
	CLOCK_HOME_HR_Y[30] = 58;
	CLOCK_HOME_HR_Y[31] = 58;
	CLOCK_HOME_HR_Y[32] = 58;
	CLOCK_HOME_HR_Y[33] = 58;
	CLOCK_HOME_HR_Y[34] = 57;	
	CLOCK_HOME_HR_Y[35] = 57;
	CLOCK_HOME_HR_Y[36] = 56;
	CLOCK_HOME_HR_Y[37] = 56;
	CLOCK_HOME_HR_Y[38] = 55;
	CLOCK_HOME_HR_Y[39] = 54;
	CLOCK_HOME_HR_Y[40] = 53;
	CLOCK_HOME_HR_Y[41] = 52;
	CLOCK_HOME_HR_Y[42] = 51;
	CLOCK_HOME_HR_Y[43] = 50;
	CLOCK_HOME_HR_Y[44] = 49;
	CLOCK_HOME_HR_Y[45] = 47;
	CLOCK_HOME_HR_Y[46] = 45;
	CLOCK_HOME_HR_Y[47] = 44;
	CLOCK_HOME_HR_Y[48] = 43;
	CLOCK_HOME_HR_Y[49] = 42;
	CLOCK_HOME_HR_Y[50] = 41;
	CLOCK_HOME_HR_Y[51] = 40;
	CLOCK_HOME_HR_Y[52] = 39;
	CLOCK_HOME_HR_Y[53] = 38;
	CLOCK_HOME_HR_Y[54] = 38;
	CLOCK_HOME_HR_Y[55] = 37;
	CLOCK_HOME_HR_Y[56] = 37;
	CLOCK_HOME_HR_Y[57] = 36;
	CLOCK_HOME_HR_Y[58] = 36;
	CLOCK_HOME_HR_Y[59] = 36;
	
	/* R = 29 */
	CLOCK_HOME_MIN_X[0] = 	107;
	CLOCK_HOME_MIN_X[1] = 	109;
	CLOCK_HOME_MIN_X[2] = 	111;
	CLOCK_HOME_MIN_X[3] = 	112;
	CLOCK_HOME_MIN_X[4] = 	113;
	CLOCK_HOME_MIN_X[5] = 	114;
	CLOCK_HOME_MIN_X[6] = 	116;
	CLOCK_HOME_MIN_X[7] = 	117;
	CLOCK_HOME_MIN_X[8] = 	118;
	CLOCK_HOME_MIN_X[9] = 	119;
	CLOCK_HOME_MIN_X[10] = 	120;
	CLOCK_HOME_MIN_X[11] = 	120;
	CLOCK_HOME_MIN_X[12] = 	120;
	CLOCK_HOME_MIN_X[13] = 	121;
	CLOCK_HOME_MIN_X[14] = 	121;
	CLOCK_HOME_MIN_X[15] = 	121;
	CLOCK_HOME_MIN_X[16] = 	121;
	CLOCK_HOME_MIN_X[17] = 	121;
	CLOCK_HOME_MIN_X[18] = 	120;
	CLOCK_HOME_MIN_X[19] = 	120;
	CLOCK_HOME_MIN_X[20] = 	120;
	CLOCK_HOME_MIN_X[21] = 	119;
	CLOCK_HOME_MIN_X[22] = 	118;
	CLOCK_HOME_MIN_X[23] = 	117;
	CLOCK_HOME_MIN_X[24] = 	116;
	CLOCK_HOME_MIN_X[25] = 	114;
	CLOCK_HOME_MIN_X[26] = 	113;
	CLOCK_HOME_MIN_X[27] = 	112;
	CLOCK_HOME_MIN_X[28] = 	111;
	CLOCK_HOME_MIN_X[29] = 	109;
	CLOCK_HOME_MIN_X[30] = 	107;
	CLOCK_HOME_MIN_X[31] = 	105;
	CLOCK_HOME_MIN_X[32] = 	103;
	CLOCK_HOME_MIN_X[33] = 	102;
	CLOCK_HOME_MIN_X[34] = 	101;
	CLOCK_HOME_MIN_X[35] = 	100;
	CLOCK_HOME_MIN_X[36] = 	98;
	CLOCK_HOME_MIN_X[37] = 	97;
	CLOCK_HOME_MIN_X[38] = 	96;
	CLOCK_HOME_MIN_X[39] = 	95;
	CLOCK_HOME_MIN_X[40] = 	94;
	CLOCK_HOME_MIN_X[41] = 	94;
	CLOCK_HOME_MIN_X[42] = 	94;
	CLOCK_HOME_MIN_X[43] = 	93;
	CLOCK_HOME_MIN_X[44] = 	93;
	CLOCK_HOME_MIN_X[45] = 	93;
	CLOCK_HOME_MIN_X[46] = 	93;
	CLOCK_HOME_MIN_X[47] = 	93;
	CLOCK_HOME_MIN_X[48] = 	94;
	CLOCK_HOME_MIN_X[49] = 	94;
	CLOCK_HOME_MIN_X[50] = 	94;
	CLOCK_HOME_MIN_X[51] = 	95;
	CLOCK_HOME_MIN_X[52] = 	96;
	CLOCK_HOME_MIN_X[53] = 	97;
	CLOCK_HOME_MIN_X[54] = 	98;
	CLOCK_HOME_MIN_X[55] = 	100;
	CLOCK_HOME_MIN_X[56] = 	101;
	CLOCK_HOME_MIN_X[57] = 	102;
	CLOCK_HOME_MIN_X[58] = 	103;
	CLOCK_HOME_MIN_X[59] = 	105;
	CLOCK_HOME_MIN_Y[0] = 33;
	CLOCK_HOME_MIN_Y[1] = 33;
	CLOCK_HOME_MIN_Y[2] = 34;
	CLOCK_HOME_MIN_Y[3] = 34;
	CLOCK_HOME_MIN_Y[4] = 34;
	CLOCK_HOME_MIN_Y[5] = 35;
	CLOCK_HOME_MIN_Y[6] = 36;
	CLOCK_HOME_MIN_Y[7] = 37;
	CLOCK_HOME_MIN_Y[8] = 38;
	CLOCK_HOME_MIN_Y[9] = 40;
	CLOCK_HOME_MIN_Y[10] = 41;
	CLOCK_HOME_MIN_Y[11] = 42;
	CLOCK_HOME_MIN_Y[12] = 43;
	CLOCK_HOME_MIN_Y[13] = 44;
	CLOCK_HOME_MIN_Y[14] = 45;
	CLOCK_HOME_MIN_Y[15] = 47;
	CLOCK_HOME_MIN_Y[16] = 49;
	CLOCK_HOME_MIN_Y[17] = 50;
	CLOCK_HOME_MIN_Y[18] = 51;
	CLOCK_HOME_MIN_Y[19] = 52;
	CLOCK_HOME_MIN_Y[20] = 53;
	CLOCK_HOME_MIN_Y[21] = 54;
	CLOCK_HOME_MIN_Y[22] = 56;
	CLOCK_HOME_MIN_Y[23] = 57;
	CLOCK_HOME_MIN_Y[24] = 58;
	CLOCK_HOME_MIN_Y[25] = 59;
	CLOCK_HOME_MIN_Y[26] = 60;
	CLOCK_HOME_MIN_Y[27] = 60;
	CLOCK_HOME_MIN_Y[28] = 60;
	CLOCK_HOME_MIN_Y[29] = 61;
	
	CLOCK_HOME_MIN_Y[30] = 61;
	CLOCK_HOME_MIN_Y[31] = 61;
	CLOCK_HOME_MIN_Y[32] = 60;
	CLOCK_HOME_MIN_Y[33] = 60;
	CLOCK_HOME_MIN_Y[34] = 60;
	CLOCK_HOME_MIN_Y[35] = 59;
	CLOCK_HOME_MIN_Y[36] = 58;
	CLOCK_HOME_MIN_Y[37] = 57;
	CLOCK_HOME_MIN_Y[38] = 56;
	CLOCK_HOME_MIN_Y[39] = 54;
	CLOCK_HOME_MIN_Y[40] = 53;
	CLOCK_HOME_MIN_Y[41] = 52;
	CLOCK_HOME_MIN_Y[42] = 51;
	CLOCK_HOME_MIN_Y[43] = 50;
	CLOCK_HOME_MIN_Y[44] = 49;
	CLOCK_HOME_MIN_Y[45] = 47;
	CLOCK_HOME_MIN_Y[46] = 45;
	CLOCK_HOME_MIN_Y[47] = 44;
	CLOCK_HOME_MIN_Y[48] = 43;
	CLOCK_HOME_MIN_Y[49] = 42;
	CLOCK_HOME_MIN_Y[50] = 41;
	CLOCK_HOME_MIN_Y[51] = 40;
	CLOCK_HOME_MIN_Y[52] = 38;
	CLOCK_HOME_MIN_Y[53] = 37;
	CLOCK_HOME_MIN_Y[54] = 36;
	CLOCK_HOME_MIN_Y[55] = 35;
	CLOCK_HOME_MIN_Y[56] = 34;
	CLOCK_HOME_MIN_Y[57] = 34;
	CLOCK_HOME_MIN_Y[58] = 34;
	CLOCK_HOME_MIN_Y[59] = 33;
	
	/* time difference for clock settings In GMT*/
	TIME_DIFF[	0	]=	TIME_DIFF_0	 ;
	TIME_DIFF[	1	]=	TIME_DIFF_1  ;
	TIME_DIFF[	2	]=	TIME_DIFF_2  ;
	TIME_DIFF[	3	]=	TIME_DIFF_3  ;
	TIME_DIFF[	4	]=	TIME_DIFF_4  ;
	TIME_DIFF[	5	]=	TIME_DIFF_5  ;
	TIME_DIFF[	6	]=	TIME_DIFF_6  ;
	TIME_DIFF[	7	]=	TIME_DIFF_7  ;
	TIME_DIFF[	8	]=	TIME_DIFF_8  ;
	TIME_DIFF[	9	]=	TIME_DIFF_9  ;
	TIME_DIFF[	10	]=	TIME_DIFF_10 ;
	TIME_DIFF[	11	]=	TIME_DIFF_11 ;
	TIME_DIFF[	12	]=	TIME_DIFF_12 ;
	TIME_DIFF[	13	]=	TIME_DIFF_13 ;
	TIME_DIFF[	14	]=	TIME_DIFF_14 ;
	TIME_DIFF[	15	]=	TIME_DIFF_15 ;
	TIME_DIFF[	16	]=	TIME_DIFF_16 ;
	TIME_DIFF[	17	]=	TIME_DIFF_17 ;
	TIME_DIFF[	18	]=	TIME_DIFF_18 ;
	TIME_DIFF[	19	]=	TIME_DIFF_19 ;
	TIME_DIFF[	20	]=	TIME_DIFF_20 ;
	TIME_DIFF[	21	]=	TIME_DIFF_21 ;
	TIME_DIFF[	22	]=	TIME_DIFF_22 ;
	TIME_DIFF[	23	]=	TIME_DIFF_23 ;
	TIME_DIFF[	24	]=	TIME_DIFF_24 ;
	TIME_DIFF[	25	]=	TIME_DIFF_25 ;
	TIME_DIFF[	26	]=	TIME_DIFF_26 ;
	TIME_DIFF[	27	]=	TIME_DIFF_27 ;
	TIME_DIFF[	28	]=	TIME_DIFF_28 ;
	TIME_DIFF[	29	]=	TIME_DIFF_29 ;
	TIME_DIFF[	30	]=	TIME_DIFF_30 ;
	TIME_DIFF[	31	]=	TIME_DIFF_31 ;
	TIME_DIFF[	32	]=	TIME_DIFF_32 ;
	TIME_DIFF[	33	]=	TIME_DIFF_33 ;
	TIME_DIFF[	34	]=	TIME_DIFF_34 ;
	TIME_DIFF[	35	]=	TIME_DIFF_35 ;
	TIME_DIFF[	36	]=	TIME_DIFF_36 ;
	TIME_DIFF[	37	]=	TIME_DIFF_37 ;
	TIME_DIFF[	38	]=	TIME_DIFF_38 ;
	TIME_DIFF[	39	]=	TIME_DIFF_39 ;
	TIME_DIFF[	40	]=	TIME_DIFF_40 ;
	TIME_DIFF[	41	]=	TIME_DIFF_41 ;
	TIME_DIFF[	42	]=	TIME_DIFF_42 ;
	TIME_DIFF[	43	]=	TIME_DIFF_43 ;
	TIME_DIFF[	44	]=	TIME_DIFF_44 ;
	TIME_DIFF[	45	]=	TIME_DIFF_45 ;
	TIME_DIFF[	46	]=	TIME_DIFF_46 ;
	TIME_DIFF[	47	]=	TIME_DIFF_47 ;
	TIME_DIFF[	48	]=	TIME_DIFF_48 ;
	TIME_DIFF[	49	]=	TIME_DIFF_49 ;
	TIME_DIFF[	50	]=	TIME_DIFF_50 ;
	TIME_DIFF[	51	]=	TIME_DIFF_51 ;
	TIME_DIFF[	52	]=	TIME_DIFF_52 ;
	TIME_DIFF[	53	]=	TIME_DIFF_53 ;
	TIME_DIFF[	54	]=	TIME_DIFF_54 ;
	TIME_DIFF[	55	]=	TIME_DIFF_55 ;
	TIME_DIFF[	56	]=	TIME_DIFF_56 ;
	TIME_DIFF[	57	]=	TIME_DIFF_57 ;
	TIME_DIFF[	58	]=	TIME_DIFF_58 ;
	TIME_DIFF[	59	]=	TIME_DIFF_59 ;
	TIME_DIFF[	60	]=	TIME_DIFF_60 ;
	TIME_DIFF[	61	]=	TIME_DIFF_61 ;
	TIME_DIFF[	62	]=	TIME_DIFF_62 ;
	TIME_DIFF[	63	]=	TIME_DIFF_63 ;
	TIME_DIFF[	64	]=	TIME_DIFF_64 ;
	TIME_DIFF[	65	]=	TIME_DIFF_65 ;
	TIME_DIFF[	66	]=	TIME_DIFF_66 ;
	TIME_DIFF[	67	]=	TIME_DIFF_67 ;
	TIME_DIFF[	68	]=	TIME_DIFF_68 ;
	TIME_DIFF[	69	]=	TIME_DIFF_69 ;
	TIME_DIFF[	70	]=	TIME_DIFF_70 ;
	TIME_DIFF[	71	]=	TIME_DIFF_71 ;
	TIME_DIFF[	72	]=	TIME_DIFF_72 ;
	TIME_DIFF[	73	]=	TIME_DIFF_73 ;
	TIME_DIFF[	74	]=	TIME_DIFF_74 ;
	TIME_DIFF[	75	]=	TIME_DIFF_75 ;
	TIME_DIFF[	76	]=	TIME_DIFF_76 ;
	TIME_DIFF[	77	]=	TIME_DIFF_77 ;
	TIME_DIFF[	78	]=	TIME_DIFF_78 ;
	TIME_DIFF[	79	]=	TIME_DIFF_79 ;
	TIME_DIFF[	80	]=	TIME_DIFF_80 ;
	TIME_DIFF[	81	]=	TIME_DIFF_81 ;
	TIME_DIFF[	82	]=	TIME_DIFF_82 ;
	TIME_DIFF[	83	]=	TIME_DIFF_83 ;
	TIME_DIFF[	84	]=	TIME_DIFF_84 ;
	TIME_DIFF[	85	]=	TIME_DIFF_85 ;
	TIME_DIFF[	86	]=	TIME_DIFF_86 ;
	TIME_DIFF[	87	]=	TIME_DIFF_87 ;
	TIME_DIFF[	88	]=	TIME_DIFF_88 ;
	TIME_DIFF[	89	]=	TIME_DIFF_89 ;
	TIME_DIFF[	90	]=	TIME_DIFF_90 ;
	TIME_DIFF[	91	]=	TIME_DIFF_91 ;
	TIME_DIFF[	92	]=	TIME_DIFF_92 ;
	TIME_DIFF[	93	]=	TIME_DIFF_93 ;
	TIME_DIFF[	94	]=	TIME_DIFF_94 ;
	TIME_DIFF[	95	]=	TIME_DIFF_95 ;
	TIME_DIFF[	96	]=	TIME_DIFF_96 ;
	TIME_DIFF[	97	]=	TIME_DIFF_97 ;
	TIME_DIFF[	98	]=	TIME_DIFF_98 ;
	TIME_DIFF[	99	]=	TIME_DIFF_99 ;
	TIME_DIFF[	100	]=	TIME_DIFF_100;
	
	/* country settings */
	
	COUNTRY_SP[0].t_fmt		= COUNTRY_0_TIME_FORMAT;
	COUNTRY_SP[0].d_fmt		= COUNTRY_0_DATE_FORMAT;
	COUNTRY_SP[0].sof_week	= COUNTRY_0_START_OF_WK;
	COUNTRY_SP[0].num		= COUNTRY_0_NUMBER;
	
	COUNTRY_SP[1].t_fmt		= COUNTRY_1_TIME_FORMAT;
	COUNTRY_SP[1].d_fmt		= COUNTRY_1_DATE_FORMAT;
	COUNTRY_SP[1].sof_week	= COUNTRY_1_START_OF_WK;
	COUNTRY_SP[1].num		= COUNTRY_1_NUMBER;
	
	COUNTRY_SP[2].t_fmt		= COUNTRY_2_TIME_FORMAT;
	COUNTRY_SP[2].d_fmt		= COUNTRY_2_DATE_FORMAT;
	COUNTRY_SP[2].sof_week	= COUNTRY_2_START_OF_WK;
	COUNTRY_SP[2].num		= COUNTRY_2_NUMBER;
	
	COUNTRY_SP[3].t_fmt		= COUNTRY_3_TIME_FORMAT;
	COUNTRY_SP[3].d_fmt		= COUNTRY_3_DATE_FORMAT;
	COUNTRY_SP[3].sof_week	= COUNTRY_3_START_OF_WK;
	COUNTRY_SP[3].num		= COUNTRY_3_NUMBER;
	
	COUNTRY_SP[4].t_fmt		= COUNTRY_4_TIME_FORMAT;
	COUNTRY_SP[4].d_fmt		= COUNTRY_4_DATE_FORMAT;
	COUNTRY_SP[4].sof_week	= COUNTRY_4_START_OF_WK;
	COUNTRY_SP[4].num		= COUNTRY_4_NUMBER;
	
	COUNTRY_SP[5].t_fmt		= COUNTRY_5_TIME_FORMAT;
	COUNTRY_SP[5].d_fmt		= COUNTRY_5_DATE_FORMAT;
	COUNTRY_SP[5].sof_week	= COUNTRY_5_START_OF_WK;
	COUNTRY_SP[5].num		= COUNTRY_5_NUMBER;
	
	COUNTRY_SP[6].t_fmt		= COUNTRY_6_TIME_FORMAT;
	COUNTRY_SP[6].d_fmt		= COUNTRY_6_DATE_FORMAT;
	COUNTRY_SP[6].sof_week	= COUNTRY_6_START_OF_WK;
	COUNTRY_SP[6].num		= COUNTRY_6_NUMBER;
	
	COUNTRY_SP[7].t_fmt		= COUNTRY_7_TIME_FORMAT;
	COUNTRY_SP[7].d_fmt		= COUNTRY_7_DATE_FORMAT;
	COUNTRY_SP[7].sof_week	= COUNTRY_7_START_OF_WK;
	COUNTRY_SP[7].num		= COUNTRY_7_NUMBER;
	
	COUNTRY_SP[8].t_fmt		= COUNTRY_8_TIME_FORMAT;
	COUNTRY_SP[8].d_fmt		= COUNTRY_8_DATE_FORMAT;
	COUNTRY_SP[8].sof_week	= COUNTRY_8_START_OF_WK;
	COUNTRY_SP[8].num		= COUNTRY_8_NUMBER;
	
	COUNTRY_SP[9].t_fmt		= COUNTRY_9_TIME_FORMAT;
	COUNTRY_SP[9].d_fmt		= COUNTRY_9_DATE_FORMAT;
	COUNTRY_SP[9].sof_week	= COUNTRY_9_START_OF_WK;
	COUNTRY_SP[9].num		= COUNTRY_9_NUMBER;
	
	COUNTRY_SP[10].t_fmt	= COUNTRY_10_TIME_FORMAT;
	COUNTRY_SP[10].d_fmt	= COUNTRY_10_DATE_FORMAT;
	COUNTRY_SP[10].sof_week	= COUNTRY_10_START_OF_WK;
	COUNTRY_SP[10].num		= COUNTRY_10_NUMBER;
	
	COUNTRY_SP[11].t_fmt	= COUNTRY_11_TIME_FORMAT;
	COUNTRY_SP[11].d_fmt	= COUNTRY_11_DATE_FORMAT;
	COUNTRY_SP[11].sof_week	= COUNTRY_11_START_OF_WK;
	COUNTRY_SP[11].num		= COUNTRY_11_NUMBER;
	
	COUNTRY_SP[12].t_fmt	= COUNTRY_12_TIME_FORMAT;
	COUNTRY_SP[12].d_fmt	= COUNTRY_12_DATE_FORMAT;
	COUNTRY_SP[12].sof_week	= COUNTRY_12_START_OF_WK;
	COUNTRY_SP[12].num		= COUNTRY_12_NUMBER;
	
	COUNTRY_SP[13].t_fmt	= COUNTRY_13_TIME_FORMAT;
	COUNTRY_SP[13].d_fmt	= COUNTRY_13_DATE_FORMAT;
	COUNTRY_SP[13].sof_week	= COUNTRY_13_START_OF_WK;
	COUNTRY_SP[13].num		= COUNTRY_13_NUMBER;
	
	COUNTRY_SP[14].t_fmt	= COUNTRY_14_TIME_FORMAT;
	COUNTRY_SP[14].d_fmt	= COUNTRY_14_DATE_FORMAT;
	COUNTRY_SP[14].sof_week	= COUNTRY_14_START_OF_WK;
	COUNTRY_SP[14].num		= COUNTRY_14_NUMBER;
	
	COUNTRY_SP[15].t_fmt	= COUNTRY_15_TIME_FORMAT;
	COUNTRY_SP[15].d_fmt	= COUNTRY_15_DATE_FORMAT;
	COUNTRY_SP[15].sof_week	= COUNTRY_15_START_OF_WK;
	COUNTRY_SP[15].num		= COUNTRY_15_NUMBER;
	
	COUNTRY_SP[16].t_fmt	= COUNTRY_16_TIME_FORMAT;
	COUNTRY_SP[16].d_fmt	= COUNTRY_16_DATE_FORMAT;
	COUNTRY_SP[16].sof_week	= COUNTRY_16_START_OF_WK;
	COUNTRY_SP[16].num		= COUNTRY_16_NUMBER;
	
	COUNTRY_SP[17].t_fmt	= COUNTRY_17_TIME_FORMAT;
	COUNTRY_SP[17].d_fmt	= COUNTRY_17_DATE_FORMAT;
	COUNTRY_SP[17].sof_week	= COUNTRY_17_START_OF_WK;
	COUNTRY_SP[17].num		= COUNTRY_17_NUMBER;
	
	COUNTRY_SP[18].t_fmt	= COUNTRY_18_TIME_FORMAT;
	COUNTRY_SP[18].d_fmt	= COUNTRY_18_DATE_FORMAT;
	COUNTRY_SP[18].sof_week	= COUNTRY_18_START_OF_WK;
	COUNTRY_SP[18].num		= COUNTRY_18_NUMBER;
	
	COUNTRY_SP[19].t_fmt	= COUNTRY_19_TIME_FORMAT;
	COUNTRY_SP[19].d_fmt	= COUNTRY_19_DATE_FORMAT;
	COUNTRY_SP[19].sof_week	= COUNTRY_19_START_OF_WK;
	COUNTRY_SP[19].num		= COUNTRY_19_NUMBER;
	
	COUNTRY_SP[20].t_fmt	= COUNTRY_20_TIME_FORMAT;
	COUNTRY_SP[20].d_fmt	= COUNTRY_20_DATE_FORMAT;
	COUNTRY_SP[20].sof_week	= COUNTRY_20_START_OF_WK;
	COUNTRY_SP[20].num		= COUNTRY_20_NUMBER;
	
	COUNTRY_SP[21].t_fmt	= COUNTRY_21_TIME_FORMAT;
	COUNTRY_SP[21].d_fmt	= COUNTRY_21_DATE_FORMAT;
	COUNTRY_SP[21].sof_week	= COUNTRY_21_START_OF_WK;
	COUNTRY_SP[21].num		= COUNTRY_21_NUMBER;
	
	COUNTRY_SP[22].t_fmt	= COUNTRY_22_TIME_FORMAT;
	COUNTRY_SP[22].d_fmt	= COUNTRY_22_DATE_FORMAT;
	COUNTRY_SP[22].sof_week	= COUNTRY_22_START_OF_WK;
	COUNTRY_SP[22].num		= COUNTRY_22_NUMBER;
	
	COUNTRY_SP[23].t_fmt	= COUNTRY_23_TIME_FORMAT;
	COUNTRY_SP[23].d_fmt	= COUNTRY_23_DATE_FORMAT;
	COUNTRY_SP[23].sof_week	= COUNTRY_23_START_OF_WK;
	COUNTRY_SP[23].num		= COUNTRY_23_NUMBER;
	
	COUNTRY_SP[24].t_fmt	= COUNTRY_24_TIME_FORMAT;
	COUNTRY_SP[24].d_fmt	= COUNTRY_24_DATE_FORMAT;
	COUNTRY_SP[24].sof_week	= COUNTRY_24_START_OF_WK;
	COUNTRY_SP[24].num		= COUNTRY_24_NUMBER;
	
	COUNTRY_SP[25].t_fmt	= COUNTRY_25_TIME_FORMAT;
	COUNTRY_SP[25].d_fmt	= COUNTRY_25_DATE_FORMAT;
	COUNTRY_SP[25].sof_week	= COUNTRY_25_START_OF_WK;
	COUNTRY_SP[25].num		= COUNTRY_25_NUMBER;
	
	COUNTRY_SP[26].t_fmt	= COUNTRY_26_TIME_FORMAT;
	COUNTRY_SP[26].d_fmt	= COUNTRY_26_DATE_FORMAT;
	COUNTRY_SP[26].sof_week	= COUNTRY_26_START_OF_WK;
	COUNTRY_SP[26].num		= COUNTRY_26_NUMBER;
	
	COUNTRY_SP[27].t_fmt	= COUNTRY_27_TIME_FORMAT;
	COUNTRY_SP[27].d_fmt	= COUNTRY_27_DATE_FORMAT;
	COUNTRY_SP[27].sof_week	= COUNTRY_27_START_OF_WK;
	COUNTRY_SP[27].num		= COUNTRY_27_NUMBER;;
	
	SySetupInitScrCalData();
	
	return;
}


/*****************************************************************
* Function:	SySetupSetPassword
* Purpose: 	This function is used to set the password settings
*				from the database
* Scope:		internal
* Input:		new_password
confirm_password
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
SHORT SySetupSetPassword(BYTE *new_password, BYTE *confirm_password)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	BOOLEAN		ctrl_value;
	PasswordSettings	password;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return SYSETUP_PASSWORD_NOT_CHANGED;
	
	if (!SySetupGetPasswordSettings(&password))
		return SYSETUP_PASSWORD_NOT_CHANGED;
	qfree(password.hints);
	
	/*
	TextboxGetNumOfCharsDisplayed(TEXTBOX_SYSETUP_PASSWORD_NEW, &num_chars);
	for(i=num_chars; i<20; i++)
	new_password[i] = 0;
	
	  TextboxGetNumOfCharsDisplayed(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, &num_chars);
	  for(i=num_chars; i<20; i++)
	  confirm_password[i] = 0;
	*/
	/*
	for(i=0; i<20; i++)
	{
	if (new_password[i] - confirm_password[i])
	return SYSETUP_CONFIRM_PASSWORD_NOT_MATCH;
	}
	*/
	if (strcmp(new_password, confirm_password))
		return SYSETUP_CONFIRM_PASSWORD_NOT_MATCH;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return SYSETUP_PASSWORD_NOT_CHANGED;
	
	if (DataOpenRecord(SySetup_dbid, PASSWORD, &rec_id, NULL) != TRUE)
		return SYSETUP_PASSWORD_NOT_CHANGED;
	
	FormGetControlValue(CHECKBOX_SYSETUP_PASSWORD_CHECK, &ctrl_value);
	if (ctrl_value)
	{
		if (confirm_password[0] != 0)
			password.check_password = 1;
		else
			password.check_password = 0;
	}
	else
		password.check_password = 0;
	
    SySetupSetCheckPassword(password.check_password);
	
	// ---------------------------------------- New Edit 041699
	ctrl_value = FALSE;
	/*
	for(i=0; i<20; i++)
	{
	if (password.password[i] - confirm_password[i])
	{
	ctrl_value = TRUE;
	break;
	}
	}
	*/
	
	if (strcmp(password.password, confirm_password))
	{
		strcpy(password.password, confirm_password);
		ctrl_value = TRUE;
	}
	
	// ---------------------------------------- 
	/*
	if (ctrl_value)
	{
	for(i=0; i<20; i++)
	password.password[i] = confirm_password[i];
	}
	*/
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(PasswordSettings), (BYTE*)&password) != TRUE)
		return SYSETUP_PASSWORD_NOT_CHANGED;
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return SYSETUP_PASSWORD_NOT_CHANGED;
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return SYSETUP_PASSWORD_NOT_CHANGED;
	
	
	
	if (ctrl_value)
		return SYSETUP_PASSWORD_CHANGED;
	else 
		return 0;
	
}



/*****************************************************************
* Function:	SySetupEditPasswordHints
* Purpose: 	This function is used to edit the password hints settings
*				from the database
* Scope:		internal
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupEditPasswordHints(void)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	BYTE		*text_ptr;
	PasswordSettings	password;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, PASSWORD, &rec_id, NULL) != TRUE)
		return FALSE;
	
	FieldGetTextPointer(FIELD_SYSETUP_PASSWORD_HINTS, &text_ptr);
	password.hints = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(password.hints, text_ptr);
	
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(password.hints)+1, password.hints) != TRUE)
		return FALSE;
	qfree(password.hints);
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupRestorePasswordHints
* Purpose: 	This function is used to restore the password hints
*				from the database
* Scope:		internal
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestorePasswordHints(void)
{
	PasswordSettings password;
	
	if (!SySetupGetPasswordSettings(&password))
		return FALSE;
	
	FieldSetText(FIELD_SYSETUP_PASSWORD_HINTS, password.hints);
	qfree(password.hints);
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupSetCountrySettings
* Purpose: 	This function is used to set the country settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetCountrySettings(void)
{
	DatabaseID	SySetup_dbid;
	ObjectID	popup_id;
	RecordID	rec_id;
	SHORT		item_num;
	CountrySettings	country;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	popup_id=POPUP_SYSETUP_COUNTRY_REGIONAL;
	
	if (DataOpenRecord(SySetup_dbid, COUNTRY, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (ControlPopupGetSelectedItem(POPUP_SYSETUP_COUNTRY_REGIONAL, &item_num) != TRUE)
		return FALSE;
	country.region = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(POPUP_SYSETUP_COUNTRY_TFORMAT, &item_num) != TRUE)
		return FALSE;
	country.time_fmt = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(POPUP_SYSETUP_COUNTRY_DFORMAT, &item_num) != TRUE)
		return FALSE;
	country.date_fmt = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(POPUP_SYSETUP_COUNTRY_START_WK, &item_num) != TRUE)
		return FALSE;
	country.start_of_week = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(POPUP_SYSETUP_COUNTRY_NUM, &item_num) != TRUE)
		return FALSE;
	country.nums = (BYTE)item_num;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(CountrySettings), (BYTE*)&country) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupRestoreCountrySettings
* Purpose: 	This function is used to restore the country settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreCountrySettings(void)
{
	BYTE		text[60] = {0};
	DatabaseID	SySetup_dbid;
	CountrySettings	country;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (!SySetupGetCountrySettings(&country))
		return FALSE;
	
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_REGIONAL, country.region);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_TFORMAT, country.time_fmt);
	switch(country.time_fmt)
	{
	case SYSETUP_12HR_DISPLAY:
		strcpy(text, SYSSTR1);
		break;
	default:
		strcpy(text, "15:04:59         ");
		break;
	}
	StringSetText(STRING_SYSETUP_COUNTRY_TSAMPLE_TIME, text);
	StringDrawString(STRING_SYSETUP_COUNTRY_TSAMPLE_TIME);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_DFORMAT, country.date_fmt);
	switch(country.date_fmt)
	{
	case SYSETUP_YMD:
		strcpy(text, "99/6/30        ");
		break;
	case SYSETUP_DMY:
		strcpy(text, "30/6/99        ");
		break;
	case SYSETUP_MDY:
		strcpy(text, "6/30/99        ");
		break;
		
	default: break;
	}
	StringSetText(STRING_SYSETUP_COUNTRY_DSAMPLE_DATE, text);
	StringDrawString(STRING_SYSETUP_COUNTRY_DSAMPLE_DATE);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_START_WK, country.start_of_week);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_NUM, country.nums);
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupRestoreRegionalSettings
* Purpose: 	This function is used to restore the regional settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreRegionalSettings(void)
{
	BYTE		text[60] = {0};
	SHORT		item_num;
	
	if (ControlPopupGetSelectedItem(POPUP_SYSETUP_COUNTRY_REGIONAL, &item_num) != TRUE)
		return FALSE;
	
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_TFORMAT, COUNTRY_SP[item_num].t_fmt);
	ControlDrawControl(POPUP_SYSETUP_COUNTRY_TFORMAT);
	switch(COUNTRY_SP[item_num].t_fmt)
	{
	case SYSETUP_12HR_DISPLAY:
		strcpy(text, SYSSTR1);
		break;
	default:
		strcpy(text, "15:04:59         ");
		break;
	}
	StringSetText(STRING_SYSETUP_COUNTRY_TSAMPLE_TIME, text);
	StringDrawString(STRING_SYSETUP_COUNTRY_TSAMPLE_TIME);
	
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_DFORMAT, COUNTRY_SP[item_num].d_fmt);
	switch(COUNTRY_SP[item_num].d_fmt)
	{
	case SYSETUP_YMD:
		strcpy(text, "99/6/30        ");
		break;
	case SYSETUP_DMY:
		strcpy(text, "30/6/99        ");
		break;
	case SYSETUP_MDY:
		strcpy(text, "6/30/99        ");
		break;
		
	default: break;
	}
	StringSetText(STRING_SYSETUP_COUNTRY_DSAMPLE_DATE, text);
	StringDrawString(STRING_SYSETUP_COUNTRY_DSAMPLE_DATE);
	
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_START_WK, COUNTRY_SP[item_num].sof_week);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_COUNTRY_NUM, COUNTRY_SP[item_num].num);
	
	ControlDrawControl(POPUP_SYSETUP_COUNTRY_DFORMAT);
	ControlDrawControl(POPUP_SYSETUP_COUNTRY_START_WK);
	ControlDrawControl(POPUP_SYSETUP_COUNTRY_NUM);
	
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetOwnerInfo
* Purpose: 	This function is used to set the owner information
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetOwnerInfo(void)
{
	DatabaseID	SySetup_dbid;
	OwnerInfo	ownerinfo;
	ObjectID	field_id;
	RecordID	rec_id;
	BYTE		*text_ptr;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, OWNINFO, &rec_id, NULL) != TRUE)
		return FALSE;
	
	field_id = FIELD_SYSETUP_OWNINFO_FNAME;
	FieldGetTextPointer(field_id++, &text_ptr);
	ownerinfo.first_name = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(ownerinfo.first_name, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 1, strlen(ownerinfo.first_name)+1, ownerinfo.first_name) != TRUE)
		return FALSE;
	qfree(ownerinfo.first_name);
	
	FieldGetTextPointer(field_id++, &text_ptr);
	ownerinfo.last_name = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(ownerinfo.last_name, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(ownerinfo.last_name)+1, ownerinfo.last_name) != TRUE)
		return FALSE;
	qfree(ownerinfo.last_name);
	
	FieldGetTextPointer(field_id++, &text_ptr);
	ownerinfo.contact_tel = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(ownerinfo.contact_tel, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 3, strlen(ownerinfo.contact_tel)+1, ownerinfo.contact_tel) != TRUE)
		return FALSE;
	qfree(ownerinfo.contact_tel);
	
	FieldGetTextPointer(field_id++, &text_ptr);
	ownerinfo.company_name = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(ownerinfo.company_name, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 4, strlen(ownerinfo.company_name)+1, ownerinfo.company_name) != TRUE)
		return FALSE;
	qfree(ownerinfo.company_name);
	
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupRestoreOwnerInfo
* Purpose: 	This function is used to restore the owner information
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreOwnerInfo(void)
{
	OwnerInfo	ownerinfo;
	ObjectID	field_id;
	
	if (!SySetupGetOwnerInfo(&ownerinfo))
		return FALSE;
	
	field_id = FIELD_SYSETUP_OWNINFO_FNAME;
	FieldSetText(field_id++, ownerinfo.first_name);
	qfree(ownerinfo.first_name);
	FieldSetText(field_id++, ownerinfo.last_name);
	qfree(ownerinfo.last_name);
	FieldSetText(field_id++, ownerinfo.contact_tel);
	qfree(ownerinfo.contact_tel);
	FieldSetText(field_id++, ownerinfo.company_name);
	qfree(ownerinfo.company_name);
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupSetModemSettings
* Purpose: 	This function is used to set the modem settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetModemSettings(void)
{
	DatabaseID	SySetup_dbid;
	ObjectID	object_id;
	RecordID	rec_id;
	BYTE		*text_ptr;
	ModemSettings	modem;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (!SySetupGetModemSettings(&modem))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, MODEM, &rec_id, NULL) != TRUE)
		return FALSE;
	
	ControlGetPushedPushButton(FORM_SYSETUP_MODEM, GROUP_ID_SYSETUP_MODEM_SPEED, &object_id);
	modem.speed_type = (BYTE)(object_id - PUSH_SYSETUP_MODEM_SLOW);
	
	ControlGetPushedPushButton(FORM_SYSETUP_MODEM, GROUP_ID_SYSETUP_MODEM_DIAL, &object_id);
	modem.line_type = (BYTE)(object_id - PUSH_SYSETUP_MODEM_TONE);
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(ModemSettings), (BYTE*)&modem) != TRUE)
		return FALSE;
	
	TextboxGetTextPointer(TEXTBOX_SYSETUP_MODEM_DIAL, &text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(text_ptr)+1, text_ptr) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupSetSyncSpeedSettings
* Purpose: 	This function is used to set the sync. speed settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetSyncSpeedSettings(void)
{
	DatabaseID	SySetup_dbid;
	ObjectID	object_id;
	RecordID	rec_id;
	SHORT		item_num;
	ModemSettings	modem;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (!SySetupGetModemSettings(&modem))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, MODEM, &rec_id, NULL) != TRUE)
		return FALSE;
	
	ControlPopupGetSelectedItem(POPUP_SYSETUP_SYSINFO_SYNSPEED, &item_num);
	modem.sync_speed = (BYTE)item_num;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(ModemSettings), (BYTE*)&modem) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetModemCustomSettings
* Purpose: 	This function is used to set the modem custom
*				settings into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetModemCustomSettings(void)
{
	DatabaseID	SySetup_dbid;
	ObjectID	object_id;
	RecordID	rec_id;
	SHORT		item_num;
	ModemSettings	modem;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (!SySetupGetModemSettings(&modem))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, MODEM, &rec_id, NULL) != TRUE)
		return FALSE;
	
	object_id = POPUP_SYSETUP_MODEM_CUSTOM_SPEED;
	
	ControlPopupGetSelectedItem(object_id++, &item_num);
	modem.speed = (BYTE)item_num;
	
	ControlPopupGetSelectedItem(object_id++, &item_num);
	modem.parity = (BYTE)item_num;
	
	ControlPopupGetSelectedItem(object_id++, &item_num);
	modem.data_bit = (BYTE)item_num;
	
	ControlPopupGetSelectedItem(object_id++, &item_num);
	modem.stop_bit = (BYTE)item_num;
	
	ControlPopupGetSelectedItem(object_id++, &item_num);
	modem.hand_flow_control = (BYTE)item_num;
	
	ControlPopupGetSelectedItem(object_id++, &item_num);
	modem.data_compression = (BYTE)item_num;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(ModemSettings), (BYTE*)&modem) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupRestoreModemSettings
* Purpose: 	This function is used to restore the modem settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreModemSettings(void)
{
	ModemSettings	modem;
	
	if (!SySetupGetModemSettings(&modem))
		return FALSE;
	
	FormSetControlGroupSelection(FORM_SYSETUP_MODEM, (modem.speed_type + PUSH_SYSETUP_MODEM_SLOW));
	FormSetControlGroupSelection(FORM_SYSETUP_MODEM, (modem.line_type + PUSH_SYSETUP_MODEM_TONE));
	TextboxSetText(TEXTBOX_SYSETUP_MODEM_DIAL, modem.dial_out_code);
	qfree(modem.dial_out_code);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupRestoreSyncSpeedSettings
* Purpose: 	This function is used to restore the sync. speed settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreSyncSpeedSettings(void)
{
	ModemSettings	modem;
	
	if (!SySetupGetModemSettings(&modem))
		return FALSE;
	
	ControlPopupSetSelectedItem(POPUP_SYSETUP_SYSINFO_SYNSPEED, modem.sync_speed);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupRestoreModemCustomSettings
* Purpose: 	This function is used to restore the modem custom 
*				settings from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreModemCustomSettings(void)
{
	ModemSettings	modem;
	ObjectID	control_id;
	
	if (!SySetupGetModemSettings(&modem))
		return FALSE;
	
	control_id = POPUP_SYSETUP_MODEM_CUSTOM_SPEED;
	ControlPopupSetSelectedItem(control_id++, modem.speed);
	ControlPopupSetSelectedItem(control_id++, modem.parity);
	ControlPopupSetSelectedItem(control_id++, modem.data_bit);
	ControlPopupSetSelectedItem(control_id++, modem.stop_bit);
	ControlPopupSetSelectedItem(control_id++, modem.hand_flow_control);
	ControlPopupSetSelectedItem(control_id++, modem.data_compression);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetClockTimeUp
* Purpose: 	This function is used to increase the time settings
*				on the display
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetClockTimeUp(ObjectID control_id, BYTE style)
{
	BYTE	*control_label;
	BYTE	set_label[3] = {0};
	
	ControlGetLabel(control_id, &control_label);
	switch(style)
	{
	case SYSETUP_12HR_DISPLAY:
		switch(control_id)
		{
		case PUSH_SYSETUP_CLOCK_12HR_HR:
			if (control_label[1] == 0)
			{	
				if (control_label[0] < '9')
					set_label[0] = control_label[0] + 1;
				else
				{
					set_label[0] = '1';
					set_label[1] = '0';
				}
			}
			else
			{
				if (control_label[1] < '2')
				{
					set_label[0] = '1';
					set_label[1] = control_label[1] + 1;
				}
				else
				{
					set_label[0] = '1';
					set_label[1] = 0;
				}
			}
			break;
			
		case PUSH_SYSETUP_CLOCK_12HR_10MIN:
			if (control_label[0]  < '5')
				set_label[0] = control_label[0] + 1;
			else
				set_label[0] = '0';
			break;
			
		case PUSH_SYSETUP_CLOCK_12HR_MIN:
			if (control_label[0] < '9')
				set_label[0] = control_label[0] + 1;
			else
				set_label[0] = '0';
			break;
			
		default:	return FALSE;
		}
		break;
		
		case SYSETUP_24HR_DISPLAY:
			switch(control_id)
			{
			case PUSH_SYSETUP_CLOCK_24HR_HR:
				if (control_label[0] == '0')
				{	
					if (control_label[1] < '9')
					{
						set_label[0] = '0';
						set_label[1] = control_label[1] + 1;
					}
					else
					{
						set_label[0] = '1';
						set_label[1] = '0';
					}
				}
				else if (control_label[0] == '1')
				{
					if (control_label[1] < '9')
					{
						set_label[0] = '1';
						set_label[1] = control_label[1] + 1;
					}
					else
					{
						set_label[0] = '2';
						set_label[1] = '0';
					}
				}
				else
				{
					if (control_label[1] < '3')
					{
						set_label[0] = '2';
						set_label[1] = control_label[1] + 1;
					}
					else
					{
						set_label[0] = '0';
						set_label[1] = '0';
					}
				}
				break;
				
			case PUSH_SYSETUP_CLOCK_24HR_10MIN:
				if (control_label[0] < '5')
					set_label[0] = control_label[0] + 1;
				else
					set_label[0] = '0';
				break;
				
			case PUSH_SYSETUP_CLOCK_24HR_MIN:
				if (control_label[0] < '9')
					set_label[0] = control_label[0] + 1;
				else
					set_label[0] = '0';
				break;
				
			default:	return FALSE;
			}
			break;
			
			default:	return FALSE;
	}
	
	ControlSetLabel(control_id, set_label);
	ControlDrawControl(control_id);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetClockTimeDn
* Purpose: 	This function is used to decrease the time settings
*				on the display
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetClockTimeDn(ObjectID control_id, BYTE style)
{
	BYTE	*control_label;
	BYTE	set_label[3]={0};
	
	ControlGetLabel(control_id, &control_label);
	switch(style)
	{
	case SYSETUP_12HR_DISPLAY:
		switch(control_id)
		{
		case PUSH_SYSETUP_CLOCK_12HR_HR:
			if (control_label[1] == 0)
			{	
				if (control_label[0] > '1')
					set_label[0] = control_label[0] - 1;
				else
				{
					set_label[0] = '1';
					set_label[1] = '2';
				}
			}
			else
			{
				if (control_label[1] > '0')
				{
					set_label[0] = '1';
					set_label[1] = control_label[1] - 1;
				}
				else
				{
					set_label[0] = '9';
					set_label[1] = 0;
				}
			}
			break;
			
		case PUSH_SYSETUP_CLOCK_12HR_10MIN:
			if (control_label[0] > '0')
				set_label[0] = control_label[0] - 1;
			else
				set_label[0] = '5';
			break;
			
		case PUSH_SYSETUP_CLOCK_12HR_MIN:
			if (control_label[0] > '0')
				set_label[0] = control_label[0] - 1;
			else
				set_label[0] = '9';
			break;
			
		default:	return FALSE;
		}
		break;
		
		case SYSETUP_24HR_DISPLAY:
			switch(control_id)
			{
			case PUSH_SYSETUP_CLOCK_24HR_HR:
				if (control_label[0] == '0')
				{	
					if (control_label[1] > '0')
					{
						set_label[0] = '0';
						set_label[1] = control_label[1] - 1;
					}
					else
					{
						set_label[0] = '2';
						set_label[1] = '3';
					}
				}
				else if(control_label[0] == '2')
				{
					if (control_label[1] > '0')
					{
						set_label[0] = '2';
						set_label[1] = control_label[1] - 1;
					}
					else
					{
						set_label[0] = '1';
						set_label[1] = '9';
					}
				}
				else
				{
					if (control_label[1] > '0')
					{
						set_label[0] = '1';
						set_label[1] = control_label[1] - 1;
					}
					else
					{
						set_label[0] = '0';
						set_label[1] = '9';
					}
				}
				break;
				
			case PUSH_SYSETUP_CLOCK_24HR_10MIN:
				if (control_label[0] > '0')
					set_label[0] = control_label[0] - 1;
				else
					set_label[0] = '5';
				break;
				
			case PUSH_SYSETUP_CLOCK_24HR_MIN:
				if (control_label[0] > '0')
					set_label[0] = control_label[0] - 1;
				else
					set_label[0] = '9';
				break;
				
			default:	return FALSE;
			}
			break;
			
			default:	return FALSE;
	}
	
	ControlSetLabel(control_id, set_label);
	ControlDrawControl(control_id);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupClockWriteTime
* Purpose: 	This function is used to write out the clock settings
*				to the display
* Scope:		internal
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupClockWriteTime(RTM *timer)
{
	BOOLEAN		ctrl_value = TRUE; 
	BYTE		sbuffer[10], ssbuffer[10];
	BYTE		*hr;
	BYTE		*ten_min;
	BYTE		*min;
	SHORT		j, jj;
	SHORT		hr_time=0, hr_time2, min_time, time_diff, day_diff=0, home_dst=0, visit_dst=0;
	SHORT		item_num1, item_num2, visit_day;
	//	RTM			timer;
	BitmapTemplate	bitmap_template_0, bitmap_template_1;
	CountrySettings	country;
	
	/* get home country */
	ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_VIST_COUNTRY, &item_num1);
	/* get visiting country */
	ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_HOME_COUNTRY, &item_num2);
	
	/* get home DST */
	FormGetControlValue(PUSH_SYSETUP_CLOCK_HOME_DST, &ctrl_value);
	if (ctrl_value)
		home_dst = 1;
	/* get visiting DST */
	FormGetControlValue(PUSH_SYSETUP_CLOCK_VIST_DST, &ctrl_value);
	if (ctrl_value)
		visit_dst = 1;
	
	/* get time & date format */
	SySetupGetCountrySettings(&country);
	/* get the time settings from timer */
	//	RtcGetTime(&timer);
	
	/* display time */
	switch(country.time_fmt)
	{
	case SYSETUP_12HR_DISPLAY:
		ControlGetLabel(PUSH_SYSETUP_CLOCK_12HR_HR, &hr);
		if (hr[1] == 0)
			hr_time = hr[0] - 48;
		else
			hr_time = (hr[0]-48)*10 + hr[1] - 48;
		
		if (hr_time > 12)
			j  = sprintf((char*)sbuffer, "%d:", hr_time - 12);
		else
			j  = sprintf((char*)sbuffer, "%d:", hr_time);
		FormGetControlValue(PUSH_SYSETUP_CLOCK_12HR_AM, &ctrl_value);
		if (ctrl_value)
		{
			if (hr_time == 12)
			{
				time_diff = TIME_DIFF[item_num1] - TIME_DIFF[item_num2] + visit_dst - home_dst;
				hr_time = 0;
			}
			else
			{
				time_diff = (SHORT)(hr_time - home_dst + (TIME_DIFF[item_num1] - TIME_DIFF[item_num2]) + visit_dst);
				hr_time *= 5;
			}
		}
		else
		{
			if (hr_time == 12)
			{
				time_diff = 12 + TIME_DIFF[item_num1] - TIME_DIFF[item_num2] + visit_dst - home_dst;
				hr_time = 12*5;
			}
			else
			{
				time_diff = (SHORT)(12 + hr_time - home_dst + (TIME_DIFF[item_num1] - TIME_DIFF[item_num2]) + visit_dst);
				hr_time = (12 + hr_time)*5;
			}
		}
		
		/* 1 day lad */
		if (time_diff < 0)
		{
		/*
		if (!ctrl_value)
		hr_time2 = time_diff + 12;
		else
			*/
			{
				hr_time2 = time_diff + 24;
				day_diff = -1;
			}
		}
		/* 1 day lead */
		else if(time_diff > 23)		
		{
			hr_time2 = time_diff - 24;
			day_diff = 1;
		}
		else						
			hr_time2 = time_diff;
		
		if (hr_time2 > 12)
			jj  = sprintf((char*)ssbuffer, "%d:", hr_time2-12);
		else if(hr_time2 == 0)
			jj  = sprintf((char*)ssbuffer, "%d:", 12);
		else
			jj  = sprintf((char*)ssbuffer, "%d:", hr_time2);
		
		ControlGetLabel(PUSH_SYSETUP_CLOCK_12HR_10MIN, &ten_min);
		j += sprintf((char*)sbuffer + j, "%c", ten_min[0]);
		jj += sprintf((char*)ssbuffer + jj, "%c", ten_min[0]);
		ControlGetLabel(PUSH_SYSETUP_CLOCK_12HR_MIN, &min);
		j += sprintf((char*)sbuffer + j, "%c", min[0]);
		jj += sprintf((char*)ssbuffer + jj, "%c", min[0]);
		if (ctrl_value)
			j += sprintf((char*)sbuffer + j, SYSAM);
		else
			j += sprintf((char*)sbuffer + j, SYSPM);
		if (hr_time2 < 12)
			jj += sprintf((char*)ssbuffer + jj, SYSAM);
		else	jj += sprintf((char*)ssbuffer + jj, SYSPM);
		
		min_time = (ten_min[0]-48)*10 + min[0] - 48;
		break;
		
	case SYSETUP_24HR_DISPLAY:
		ControlGetLabel(PUSH_SYSETUP_CLOCK_24HR_HR, &hr);
		hr_time = (hr[0]-48)*10 + (hr[1]-48);
		if (hr_time > 24)
			j  = sprintf((char*)sbuffer, "%d:", hr_time - 24);
		else
			j  = sprintf((char*)sbuffer, "%d:", hr_time);
		time_diff = (SHORT)(hr_time - home_dst + (TIME_DIFF[item_num1] - TIME_DIFF[item_num2]) + visit_dst);
		hr_time *= 5;
		/* 1 day lad */
		if (time_diff < 0)
		{
			hr_time2 = time_diff + 24;
			day_diff = -1;
		}
		/* 1 day lead */
		else if(time_diff > 23)		
		{
			hr_time2 = time_diff - 24;
			day_diff = 1;
		}
		else						
			hr_time2 = time_diff;
		jj  = sprintf((char*)ssbuffer, "%d:", hr_time2);
		ControlGetLabel(PUSH_SYSETUP_CLOCK_24HR_10MIN, &ten_min);
		j += sprintf((char*)sbuffer + j, "%c", ten_min[0]);
		jj += sprintf((char*)ssbuffer + jj, "%c", ten_min[0]);
		ControlGetLabel(PUSH_SYSETUP_CLOCK_24HR_MIN, &min);
		j += sprintf((char*)sbuffer + j, "%c", min[0]);
		jj += sprintf((char*)ssbuffer + jj, "%c", min[0]);
		
		min_time = (ten_min[0]-48)*10 + min[0] - 48;
		break;
		
	default:	return FALSE;
	}
	
	/* write out the home time */
	ControlSetLabel(BUTTON_SYSETUP_CLOCK_HOME_TIME, sbuffer);
	
	/* write out the visiting time */
	StringSetText(STRING_SYSETUP_CLOCK_VIST_TIME, ssbuffer);
	
	/* write out the visiting date */
	visit_day = timer->mday + day_diff;	
	if (visit_day < 1)
	{
		if (timer->mon == 0)
			SySetupDateWriteDate(timer->year - 1, 11, 31, country.date_fmt, FALSE, TRUE);	
		else
			SySetupDateWriteDate(timer->year, timer->mon - 1, RtcGetDaysInMonth(timer->year, timer->mon - 1), country.date_fmt, FALSE, TRUE);
	}
	else if(visit_day > RtcGetDaysInMonth(timer->year, timer->mon))
	{
		if (timer->mon == 11)
			SySetupDateWriteDate(timer->year + 1, 0, 1, country.date_fmt, FALSE, TRUE);			
		else
			SySetupDateWriteDate(timer->year, timer->mon + 1, 1, country.date_fmt, FALSE, TRUE);
	}
	else
		SySetupDateWriteDate(timer->year, timer->mon, visit_day, country.date_fmt, FALSE, TRUE);
	
	/* home clock day/night graphical display */
	if (hr_time > 29 && hr_time < 90 && !home_day_clk)
	{
		BitmapGetBitmapTemplate(BITMAP_SYSETUP_CLOCK_DAYCLK, &bitmap_template_0, &bitmap_template_1);
		BitmapSetBitmapTemplate(BITMAP_SYSETUP_CLOCK_DAYCLK, bitmap_template_1, bitmap_template_0);
		//home_day_clk = FALSE;
		home_day_clk = TRUE;
	}
	else if(((hr_time >= 0 && hr_time < 30) || (hr_time > 89 && hr_time < 120))  && home_day_clk)
	{
		BitmapGetBitmapTemplate(BITMAP_SYSETUP_CLOCK_DAYCLK, &bitmap_template_0, &bitmap_template_1);
		BitmapSetBitmapTemplate(BITMAP_SYSETUP_CLOCK_DAYCLK, bitmap_template_1, bitmap_template_0);
		//home_day_clk = TRUE;
		home_day_clk = FALSE;
	}
	
	/* visiting clock day/night graphical display */
	hr_time2 *= 5;
	if (hr_time2 > 29 && hr_time2 < 90 && !visit_day_clk)
	{
		BitmapGetBitmapTemplate(BITMAP_SYSETUP_CLOCK_NIGHTCLK, &bitmap_template_0, &bitmap_template_1);
		BitmapSetBitmapTemplate(BITMAP_SYSETUP_CLOCK_NIGHTCLK, bitmap_template_1, bitmap_template_0);
		//visit_day_clk = FALSE;
		visit_day_clk = TRUE;
	}
	else if(((hr_time2 >= 0 && hr_time2 < 30) || (hr_time2 > 89 && hr_time2 < 120)) && visit_day_clk)
	{
		BitmapGetBitmapTemplate(BITMAP_SYSETUP_CLOCK_NIGHTCLK, &bitmap_template_0, &bitmap_template_1);
		BitmapSetBitmapTemplate(BITMAP_SYSETUP_CLOCK_NIGHTCLK, bitmap_template_1, bitmap_template_0);
		visit_day_clk = FALSE;
	}
	
	/* timer settings */
	timer->hour	= hr_time / 5;
	timer->min	= min_time;
	timer->sec	= 0;
	timer->msec	= 0;
	//	RtcSetTime(&timer);
	
	/* home clock graphical display */
	hr_time %= 60;
	hr_time += min_time/12;
	//=================================== modified at 050400 ==============================	
	/*	LineSetPosition(LINE_SYSETUP_CLOCK_HOME_HLINE, CLOCK_HOME_HR_X[hr_time],
	CLOCK_HOME_HR_Y[hr_time], 107, 47);	
	LineSetPosition(LINE_SYSETUP_CLOCK_HOME_MLINE, CLOCK_HOME_MIN_X[min_time],
	CLOCK_HOME_MIN_Y[min_time], 107, 47);	*/
	
	LineSetPosition(LINE_SYSETUP_CLOCK_HOME_HLINE, CLOCK_HOME_HR_X[hr_time]-76,
		CLOCK_HOME_HR_Y[hr_time], 31, 47);	
	LineSetPosition(LINE_SYSETUP_CLOCK_HOME_MLINE, CLOCK_HOME_MIN_X[min_time]-76,
		CLOCK_HOME_MIN_Y[min_time], 31, 47);
	//======================================================================================
	
	
	/* visiting clock graphical display */
	hr_time2 %= 60;
	hr_time2 += min_time/12;
	//=================================== modified at 050400 ===============================	
	/*LineSetPosition(LINE_SYSETUP_CLOCK_VIST_HLINE, CLOCK_HOME_HR_X[hr_time2]-76,
	CLOCK_HOME_HR_Y[hr_time2], 31, 47);
	LineSetPosition(LINE_SYSETUP_CLOCK_VIST_MLINE, CLOCK_HOME_MIN_X[min_time]-76,
	CLOCK_HOME_MIN_Y[min_time], 31, 47);*/
	
	LineSetPosition(LINE_SYSETUP_CLOCK_VIST_HLINE, CLOCK_HOME_HR_X[hr_time2],
		CLOCK_HOME_HR_Y[hr_time2], 107, 47);
	LineSetPosition(LINE_SYSETUP_CLOCK_VIST_MLINE, CLOCK_HOME_MIN_X[min_time],
		CLOCK_HOME_MIN_Y[min_time], 107, 47);
	//======================================================================================	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupClockSetHomeDSTTime
* Purpose: 	This function is used to set the home dst time from timer
*				to the display
* Scope:		internal
* Input:		None
* Output:		*timer				output time
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
void SySetupClockSetHomeDSTTime(RTM *timer)
{
	BOOLEAN	ctrl_value;
	//	RTM		timer;
	SHORT	hour, day, month;
	
	//	RtcGetTime(&timer);
	
	/* get home DST */
	FormGetControlValue(PUSH_SYSETUP_CLOCK_HOME_DST, &ctrl_value);
	if (ctrl_value)
		hour = timer->hour + 1;
	else
		hour = timer->hour - 1;
	
	if (hour > 23)
	{
		timer->hour = 0;
		day = timer->mday + 1;
		if (day > RtcGetDaysInMonth(timer->year, timer->mon))
		{
			timer->mday = 1;
			month = timer->mon + 1;
			if (month > 11)
			{
				timer->mon = 0;
				timer->year += 1;
			}
			else
				timer->mon = month;
		}
		else
			timer->mday++;
		
	}
	else if(hour < 0)
	{
		timer->hour = 23;
		day = timer->mday - 1;
		if (day < 1)
		{
			month = timer->mon - 1;
			if (month < 0)
			{
				timer->mon = 11;
				timer->year -= 1;
			}
			else
				timer->mon = month;
			timer->mday = RtcGetDaysInMonth(timer->year, timer->mon);
		}
		else
			timer->mday--;
	}
	else
		timer->hour = hour;
		/*
		out_time->year = timer.year;
		out_time->mon = timer.mon;
		out_time->mday = timer.mday;
		out_time->hour = timer.hour;
		out_time->min = timer.min;
		out_time->sec = 0;
	*/
	//	RtcSetTime(&timer);
	
	return;
}

/*****************************************************************
* Function:	SySetupClockPutRtmTime
* Purpose: 	This function is used to write out the time from timer
*				to the display
* Scope:		internal
* Input:		timer				input time
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupClockPutRtmTime(RTM timer)
{
	//	RTM		timer;
	SHORT	j, jj;
	BYTE	time12_label[8], time24_label[6], label1[2], label2[3];
	BYTE	object_type;
	Control	*push_ptr;
	CountrySettings	country;
	
	label1[0] = 0;
	label1[1] = 0;
	label2[0] = 0;
	label2[1] = 0;
	label2[2] = 0;
	
	/* get time & date from timer */
	//	RtcGetTime(&timer);
	
	/* get time & date format from country settings */
	if (!SySetupGetCountrySettings(&country))
		return FALSE;
	
	if (timer.hour < 10)
	{
		j  = sprintf((char*)time24_label, "0%d:", timer.hour);
		if (timer.hour == 0)
		{
			jj  = sprintf((char*)time12_label, "%d:", 12);
			sprintf((char*)label2, "%d", 12);
		}
		else
		{
			jj  = sprintf((char*)time12_label, "%d:", timer.hour);
			sprintf((char*)label2, "%d", timer.hour);
		}
	}
	else
	{
		j  = sprintf((char*)time24_label, "%d:", timer.hour);
		if (timer.hour < 13)
		{
			jj  = sprintf((char*)time12_label, "%d:", timer.hour);
			sprintf((char*)label2, "%d", timer.hour);
		}
		else
		{
			jj  = sprintf((char*)time12_label, "%d:", timer.hour - 12);
			sprintf((char*)label2, "%d", timer.hour - 12);
		}
	}
	if (timer.min < 10)
	{
		j += sprintf((char*)time24_label + j, "0%d", timer.min);
		jj += sprintf((char*)time12_label + jj, "0%d", timer.min);
	}
	else
	{
		j += sprintf((char*)time24_label + j, "%d", timer.min);
		jj += sprintf((char*)time12_label + jj, "%d", timer.min);
	}
	
	
	if (timer.hour < 12)
	{
		jj += sprintf((char*)time12_label + jj, SYSAM);
		FormGetObjectPointer(PUSH_SYSETUP_CLOCK_12HR_AM, &object_type, (void**)&push_ptr);
		((ControlTemplatePushButton*)(push_ptr->control_template))->control_value = TRUE;
		FormGetObjectPointer(PUSH_SYSETUP_CLOCK_12HR_PM, &object_type, (void**)&push_ptr);
		((ControlTemplatePushButton*)(push_ptr->control_template))->control_value = FALSE;
	}
	else
	{
		
		jj += sprintf((char*)time12_label + jj, SYSPM);
		FormGetObjectPointer(PUSH_SYSETUP_CLOCK_12HR_PM, &object_type, (void**)&push_ptr);
		((ControlTemplatePushButton*)(push_ptr->control_template))->control_value = TRUE;
		FormGetObjectPointer(PUSH_SYSETUP_CLOCK_12HR_AM, &object_type, (void**)&push_ptr);
		((ControlTemplatePushButton*)(push_ptr->control_template))->control_value = FALSE;
	}
	
	switch(country.time_fmt)
	{
	case SYSETUP_12HR_DISPLAY:
		ControlSetLabel(BUTTON_SYSETUP_CLOCK_HOME_TIME, time12_label);
		break;
		
	case SYSETUP_24HR_DISPLAY:
		ControlSetLabel(BUTTON_SYSETUP_CLOCK_HOME_TIME, time24_label);
		break;
		
	default:	return FALSE;
	}
	
	ControlSetLabel(PUSH_SYSETUP_CLOCK_12HR_HR, label2);
	
	if (timer.hour < 10)
		sprintf((char*)label2, "0%d", timer.hour);
	else
		sprintf((char*)label2, "%d", timer.hour);
	ControlSetLabel(PUSH_SYSETUP_CLOCK_24HR_HR, label2);
	
	sprintf((char*)label1, "%d", timer.min/10);
	ControlSetLabel(PUSH_SYSETUP_CLOCK_12HR_10MIN, label1);
	ControlSetLabel(PUSH_SYSETUP_CLOCK_24HR_10MIN, label1);
	
	sprintf((char*)label1, "%d", timer.min%10);
	ControlSetLabel(PUSH_SYSETUP_CLOCK_12HR_MIN, label1);
	ControlSetLabel(PUSH_SYSETUP_CLOCK_24HR_MIN, label1);
	
	if (!SySetupDateWriteDate(timer.year, timer.mon, timer.mday, country.date_fmt, TRUE, FALSE))
		return FALSE;
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupClockCalTimeDiff
* Purpose: 	This function is used to calculate the time difference between
*				two different home countries
* Scope:		internal
* Input:		new_country					new home country
old_country					old home country
time_source					old home country's time
* Output:		*timer						new home country's time
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupClockCalTimeDiff(SHORT new_country, SHORT old_country, RTM time_source, RTM *timer)
{
	SHORT	time_diff, day_diff=0;
	SHORT	visit_day;
	ClockSettings	clock;
	
	if (!SySetupGetClockSettings(&clock))
		return TRUE;
	
	/* calculate time difference */
	time_diff = (SHORT)(time_source.hour + (TIME_DIFF[new_country] - TIME_DIFF[old_country]));
	
	/* 1 day lad */
	if (time_diff < 0)
	{
		timer->hour = time_diff + 24;
		day_diff = -1;
	}
	/* 1 day lead */
	else if(time_diff > 23)		
	{
		timer->hour = time_diff - 24;
		day_diff = 1;
	}
	else						
		timer->hour = time_diff;
	
	timer->min = time_source.min;
	
	/* write out the required date */
	visit_day = time_source.mday + day_diff;	
	if (visit_day < 1)
	{
		if (time_source.mon == 0)
		{
			timer->year = time_source.year - 1;
			timer->mon = 11;
			timer->mday = 31;
		}
		else
		{
			timer->year = time_source.year;
			timer->mon = time_source.mon - 1;
			timer->mday = RtcGetDaysInMonth(timer->year, timer->mon - 1);
		}
		
	}
	else if(visit_day > RtcGetDaysInMonth(time_source.year, time_source.mon))
	{
		if (time_source.mon == 11)
		{
			timer->year = time_source.year + 1;
			timer->mon = 0;
			timer->mday = 1;
		}
		else
		{
			timer->year = time_source.year;
			timer->mon = time_source.mon + 1;
			timer->mday = 1;
		}
	}
	else
	{
		timer->year = time_source.year;
		timer->mon = time_source.mon;
		timer->mday = visit_day;
	}
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupClockUpdateClockView
* Purpose: 	This function is used to update the clock view
* Scope:		internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupClockUpdateClockView(void)
{
	BitmapDrawBitmap(BITMAP_SYSETUP_CLOCK_NIGHTCLK);
	BitmapDrawBitmap(BITMAP_SYSETUP_CLOCK_VIST_LOGO);
	BitmapDrawBitmap(BITMAP_SYSETUP_CLOCK_DAYCLK);
	BitmapDrawBitmap(BITMAP_SYSETUP_CLOCK_HOME_LOGO);
	LineDrawLine(LINE_SYSETUP_CLOCK_VIST_HLINE);
	LineDrawLine(LINE_SYSETUP_CLOCK_VIST_MLINE);
	LineDrawLine(LINE_SYSETUP_CLOCK_HOME_HLINE);
	LineDrawLine(LINE_SYSETUP_CLOCK_HOME_MLINE);
	StringDrawString(STRING_SYSETUP_CLOCK_VIST_DATE);
	StringDrawString(STRING_SYSETUP_CLOCK_VIST_TIME);
	ControlDrawControl(BUTTON_SYSETUP_CLOCK_HOME_TIME);
	ControlDrawControl(BUTTON_SYSETUP_CLOCK_HOME_DATE);
	
	return;
}



/*****************************************************************
* Function:	SySetupClockUpdateClockTiming
* Purpose: 	This function is used to update the clock timing
* Scope:		internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupClockUpdateClockTiming(void)
{
	ObjectID	active_form_id;
	BOOLEAN		menu_popup_status,	popup_popup_status;
	
#ifdef PR31700
	UICheckObjectPopupStatus(&menu_popup_status, &popup_popup_status);
#endif
	if (popup_popup_status)
	{
#ifdef TMR_DEBUG
		printf("\n ---->>>7 Disable Tmr Int");
#endif
		TmrIntDisable(Tmr_Label);
		Update_Timing = 0;
		return;
	}
	
	RtcGetTime(&Gtimer);
	
	SySetupClockPutRtmTime(Gtimer);
	SySetupClockWriteTime(&Gtimer);
	
	FormGetActiveFormID(&active_form_id);
	if (active_form_id != FORM_SYSETUP_CLOCK)
		return;
	
	SySetupClockUpdateClockView();
	
	return;
}
/*****************************************************************
* Function:	SySetupDateWriteDate
* Purpose: 	This function is used to write out the date 
*				to the display
* Scope:		internal
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupDateWriteDate(SHORT year, SHORT month, SHORT day, BYTE date_fmt, BOOLEAN write_home_date, BOOLEAN write_visit_date)
{
	
	BYTE	date_label[10]={0};
	SHORT	j;
	
	year -= SYSETUP_YEAR_OFFSET;
	if (year < 0)	year += 100;
	month += 1;
	j = 0;
	
	/* display month, day & year */
	switch(date_fmt)
	{
	case SYSETUP_YMD:
		if ((year)%100 < 10)
			j = sprintf((char*)date_label, "0%d/", year%100);
		else
			j = sprintf((char*)date_label, "%d/", year%100);
			/*if (month < 10)
			j += sprintf((char*)date_label + j, "0%d/", month);
		else*/
		j += sprintf((char*)date_label + j, "%d/", month);
		if (day < 10)
			j += sprintf((char*)date_label + j, "0%d", day);
		else
			j += sprintf((char*)date_label + j, "%d", day);
		break;
		
	case SYSETUP_DMY:
		if (day < 10)
			j  = sprintf((char*)date_label,     "0%d/", day);
		else
			j  = sprintf((char*)date_label,     "%d/", day);
			/*if (month < 10)
			j += sprintf((char*)date_label + j, "0%d/", month);
		else*/
		j += sprintf((char*)date_label + j, "%d/", month);
		if (year%100 < 10)
			j += sprintf((char*)date_label + j, "0%d", year%100);
		else
			j += sprintf((char*)date_label + j, "%d", year%100);
		break;
		
	case SYSETUP_MDY:
	/*if (month < 10)
				j  = sprintf((char*)date_label,     "0%d/", month);
		else*/
		j  = sprintf((char*)date_label,     "%d/", month);
		if (day < 10)
			j += sprintf((char*)date_label + j, "0%d/", day);
		else
			j += sprintf((char*)date_label + j, "%d/", day);
		if ((year)%100 < 10)
			j += sprintf((char*)date_label + j, "0%d", year%100);
		else
			j += sprintf((char*)date_label + j, "%d", year%100);
		break;
		
	default:	return FALSE;
		
	}
	
	if (write_home_date)
		ControlSetLabel(BUTTON_SYSETUP_CLOCK_HOME_DATE, date_label);
	
	if (write_visit_date)
		StringSetText(STRING_SYSETUP_CLOCK_VIST_DATE, date_label);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupRestoreClockSettings
* Purpose: 	This function is used to restore the clock settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreClockSettings(void)
{
	BOOLEAN		ctrl_value;
	ClockSettings	clock;
	
	if (!SySetupGetClockSettings(&clock))
		return TRUE;
	
	FormGetControlValue(PUSH_SYSETUP_CLOCK_VIST_DST, &ctrl_value);
	if (ctrl_value != (BOOLEAN)clock.visit_dst_active)
		FormSetControlGroupSelection(FORM_SYSETUP_CLOCK, PUSH_SYSETUP_CLOCK_VIST_DST);
	
	FormGetControlValue(PUSH_SYSETUP_CLOCK_HOME_DST, &ctrl_value);
	if (ctrl_value != (BOOLEAN)clock.home_dst_active)
		FormSetControlGroupSelection(FORM_SYSETUP_CLOCK, PUSH_SYSETUP_CLOCK_HOME_DST);
	
	ControlPopupSetSelectedItem(POPUP_SYSETUP_CLOCK_VIST_COUNTRY, clock.visit_country);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_CLOCK_HOME_COUNTRY, clock.home_country);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_CLOCK_AUTOFFTIME, clock.auto_off_time - 1);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetDateSettings
* Purpose: 	This function is used to set date settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
void SySetupSetDateSettings(USHORT row_num, USHORT col_num, RTM *timer)
{
	
	SHORT	year, month, day;
	RTM		change_timer;
	
	SySetupGetDateSettings(FORM_SYSETUP_DATE, TABLE_SYSETUP_DATE, PUSH_SYSETUP_DATE_JAN, GROUP_ID_SYSETUP_DATE_YEAR, GROUP_ID_SYSETUP_DATE_MONTH, row_num, col_num, &year, &month, &day);
	timer->year = year;
	timer->mon = month;
	timer->mday = day;
	RtcGetTime(&change_timer);
	change_timer.year = year;
	change_timer.mon = month;
	change_timer.mday = day;
	RtcSetTime(&change_timer);
	
	return;
	
}


/*****************************************************************
* Function:	SySetupSetEmailSettings
* Purpose: 	This function is used to set the email settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetEmailSettings(void)
{
	DatabaseID	SySetup_dbid;
	ObjectID	object_id;
	RecordID	rec_id;
	BOOLEAN		ctrl_value;
	SHORT		isp;
	BYTE		*text_ptr;
	EmailSettings	email;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	FormGetControlValue(PUSH_SYSETUP_EMAIL_ISP, &ctrl_value);
	if (!ctrl_value)
	{
		FormGetControlValue(PUSH_SYSETUP_EMAIL_ISP2, &ctrl_value);
		if (!ctrl_value)
		{
			FormGetControlValue(PUSH_SYSETUP_EMAIL_ISP3, &ctrl_value);
			if (!ctrl_value)		isp = EMAIL4;
			else	isp = EMAIL3;
		}
		else	isp = EMAIL2;
	}
	else	isp = EMAIL1;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, isp, &rec_id, NULL) != TRUE)
		return FALSE;
	
	FormGetControlValue(CHECKBOX_SYSETUP_EMAIL2_AUTOMATIC, &ctrl_value);
	if (ctrl_value)
		email.auto_ip_addr = (BYTE)1;
	else
		email.auto_ip_addr = (BYTE)0;
	FormGetControlValue(CHECKBOX_SYSETUP_EMAIL2_APOP, &ctrl_value);
	if (ctrl_value)
		email.apop = 1;
	else
		email.apop = 0;
	FormGetControlValue(CHECKBOX_SYSETUP_EMAIL2_DEL_MAIL, &ctrl_value);
	if (ctrl_value)
		email.del_mail = 1;
	else
		email.del_mail = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(EmailSettings), (BYTE*)&email) != TRUE)
		return FALSE;
	
	object_id = FIELD_SYSETUP_EMAIL_ISP;
	
	FieldGetTextPointer(object_id++, &text_ptr);
	email.isp = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.isp, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(email.isp)+1, email.isp) != TRUE)
		return FALSE;
	qfree(email.isp);
	
	FieldGetTextPointer(object_id++, &text_ptr);
	email.tel = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.tel, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 3, strlen(email.tel)+1, email.tel) != TRUE)
		return FALSE;
	qfree(email.tel);
	
	FieldGetTextPointer(object_id++, &text_ptr);
	email.email_addr = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.email_addr, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 4, strlen(email.email_addr)+1, email.email_addr) != TRUE)
		return FALSE;
	qfree(email.email_addr);
	
	FieldGetTextPointer(object_id++, &text_ptr);
	email.login_name = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.login_name, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 5, strlen(email.login_name)+1, email.login_name) != TRUE)
		return FALSE;
	qfree(email.login_name);
	
	//FieldGetTextPointer(object_id++, &text_ptr);
	object_id++;
	email.login_password = (BYTE*)qmalloc((strlen(login_password)+1)*sizeof(BYTE));
	strcpy(email.login_password, login_password);
	if (DataWriteField(SySetup_dbid, rec_id, 6, strlen(email.login_password)+1, email.login_password) != TRUE)
		return FALSE;
	qfree(email.login_password);
	
	FieldGetTextPointer(object_id++, &text_ptr);
	email.smtp_server = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.smtp_server, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 7, strlen(email.smtp_server)+1, email.smtp_server) != TRUE)
		return FALSE;
	qfree(email.smtp_server);
	
	FieldGetTextPointer(object_id++, &text_ptr);
	email.pop3_server = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.pop3_server, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 8, strlen(email.pop3_server)+1, email.pop3_server) != TRUE)
		return FALSE;
	qfree(email.pop3_server);
	
	FieldGetTextPointer(object_id++, &text_ptr);
	email.user_name = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.user_name, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 9, strlen(email.user_name)+1, email.user_name) != TRUE)
		return FALSE;
	qfree(email.user_name);
	
	//FieldGetTextPointer(object_id++, &text_ptr);
	object_id++;
	email.password = (BYTE*)qmalloc((strlen(email_password)+1)*sizeof(BYTE));
	strcpy(email.password, email_password);
	if (DataWriteField(SySetup_dbid, rec_id, 10, strlen(email.password)+1, email.password) != TRUE)
		return FALSE;
	qfree(email.password);
	
	object_id = TEXTBOX_SYSETUP_EMAIL2_PRIDNS1;	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.pri_dns1 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.pri_dns1, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 11, strlen(email.pri_dns1)+1, email.pri_dns1) != TRUE)
		return FALSE;
	qfree(email.pri_dns1);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.pri_dns2 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.pri_dns2, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 12, strlen(email.pri_dns2)+1, email.pri_dns2) != TRUE)
		return FALSE;
	qfree(email.pri_dns2);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.pri_dns3 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.pri_dns3, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 13, strlen(email.pri_dns3)+1, email.pri_dns3) != TRUE)
		return FALSE;
	qfree(email.pri_dns3);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.pri_dns4 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.pri_dns4, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 14, strlen(email.pri_dns4)+1, email.pri_dns4) != TRUE)
		return FALSE;
	qfree(email.pri_dns4);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.sec_dns1 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.sec_dns1, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 15, strlen(email.sec_dns1)+1, email.sec_dns1) != TRUE)
		return FALSE;
	qfree(email.sec_dns1);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.sec_dns2 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.sec_dns2, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 16, strlen(email.sec_dns2)+1, email.sec_dns2) != TRUE)
		return FALSE;
	qfree(email.sec_dns2);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.sec_dns3 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.sec_dns3, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 17, strlen(email.sec_dns3)+1, email.sec_dns3) != TRUE)
		return FALSE;
	qfree(email.sec_dns3);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.sec_dns4 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.sec_dns4, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 18, strlen(email.sec_dns4)+1, email.sec_dns4) != TRUE)
		return FALSE;
	qfree(email.sec_dns4);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.ip_addr1 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.ip_addr1, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 19, strlen(email.ip_addr1)+1, email.ip_addr1) != TRUE)
		return FALSE;
	qfree(email.ip_addr1);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.ip_addr2 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.ip_addr2, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 20, strlen(email.ip_addr2)+1, email.ip_addr2) != TRUE)
		return FALSE;
	qfree(email.ip_addr2);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.ip_addr3 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.ip_addr3, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 21, strlen(email.ip_addr3)+1, email.ip_addr3) != TRUE)
		return FALSE;
	qfree(email.ip_addr3);
	
	TextboxGetTextPointer(object_id++, &text_ptr);
	email.ip_addr4 = (BYTE*)qmalloc((strlen(text_ptr)+1)*sizeof(BYTE));
	strcpy(email.ip_addr4, text_ptr);
	if (DataWriteField(SySetup_dbid, rec_id, 22, strlen(email.ip_addr4)+1, email.ip_addr4) != TRUE)
		return FALSE;
	qfree(email.ip_addr4);
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupRestoreEmailSettings
* Purpose: 	This function is used to restore the email settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreEmailSettings(void)
{
	EmailSettings	email;
	ObjectID		object_id;
	BOOLEAN			ctrl_value;
	BYTE			sbuffer[7];
	UWORD			isp;
	UWORD			num_chars, count;
	BYTE			temp_string[45];
	
	
	FormGetControlValue(PUSH_SYSETUP_EMAIL_ISP, &ctrl_value);
	if (!ctrl_value)
	{
		FormGetControlValue(PUSH_SYSETUP_EMAIL_ISP2, &ctrl_value);
		if (!ctrl_value)
		{
			FormGetControlValue(PUSH_SYSETUP_EMAIL_ISP3, &ctrl_value);
			if (!ctrl_value)
			{
				object_id = PUSH_SYSETUP_EMAIL_ISP4;
				isp = EMAIL4;
			}
			else
			{
				object_id = PUSH_SYSETUP_EMAIL_ISP3;
				isp = EMAIL3;
			}
			
		}
		else
		{
			object_id = PUSH_SYSETUP_EMAIL_ISP2;
			isp = EMAIL2;
		}
	}
	else
	{
		object_id = PUSH_SYSETUP_EMAIL_ISP;
		isp = EMAIL1;
	}
	
	// ---------------------------------------------------------------**
	if (!SySetupGetEmailSettings(&email, EMAIL1))
		return FALSE;
	if (email.isp[0] != 0)
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP, email.isp);
	else
	{
		strcpy(sbuffer, SYSISPA);
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP, sbuffer);
	}
	// -------------------------------------------------
	if (!SySetupGetEmailSettings(&email, EMAIL2))
		return FALSE;
	if (email.isp[0] != 0)
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP2, email.isp);
	else
	{
		strcpy(sbuffer, SYSISPB);
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP2, sbuffer);
	}
	// -------------------------------------------------
	if (!SySetupGetEmailSettings(&email, EMAIL3))
		return FALSE;
	if (email.isp[0] != 0)
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP3, email.isp);
	else
	{
		strcpy(sbuffer, SYSISPC);
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP3, sbuffer);
	}
	// -------------------------------------------------
	if (!SySetupGetEmailSettings(&email, EMAIL4))
		return FALSE;
	if (email.isp[0] != 0)
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP4, email.isp);
	else
	{
		strcpy(sbuffer, SYSISPD);
		ControlSetLabel(PUSH_SYSETUP_EMAIL_ISP4, sbuffer);
	}
	// ---------------------------------------------------------------**
	
	if (!SySetupGetEmailSettings(&email, isp))
		return FALSE;
	
	FormGetControlValue(CHECKBOX_SYSETUP_EMAIL2_AUTOMATIC, &ctrl_value);
	if (ctrl_value != (BOOLEAN)email.auto_ip_addr)
		FormSetControlGroupSelection(FORM_SYSETUP_EMAIL2, CHECKBOX_SYSETUP_EMAIL2_AUTOMATIC);
	
	FormGetControlValue(CHECKBOX_SYSETUP_EMAIL2_APOP, &ctrl_value);
	if (ctrl_value != (BOOLEAN)email.apop)
		FormSetControlGroupSelection(FORM_SYSETUP_EMAIL2, CHECKBOX_SYSETUP_EMAIL2_APOP);
	
	FormGetControlValue(CHECKBOX_SYSETUP_EMAIL2_DEL_MAIL, &ctrl_value);
	if (ctrl_value != (BOOLEAN)email.del_mail)
		FormSetControlGroupSelection(FORM_SYSETUP_EMAIL2, CHECKBOX_SYSETUP_EMAIL2_DEL_MAIL);
	
	object_id = FIELD_SYSETUP_EMAIL_ISP;
	FieldSetText(object_id++, email.isp);
	qfree(email.isp);
	FieldSetText(object_id++, email.tel);
	qfree(email.tel);
	
	FieldSetText(object_id++, email.email_addr);
	qfree(email.email_addr);
	FieldSetText(object_id++, email.login_name);
	qfree(email.login_name);
	
	//HENRY	
	strcpy(login_password, email.login_password);
	num_chars = strlen(login_password);	
	temp_string[num_chars] = 0;
	for (count = 0; count < num_chars; count ++)
		temp_string[count] = '*';
	FieldSetText(object_id++, temp_string);
	qfree(email.login_password);
	//HENRY	
	
	FieldSetText(object_id++, email.smtp_server);
	qfree(email.smtp_server);
	FieldSetText(object_id++, email.pop3_server);
	qfree(email.pop3_server);
	FieldSetText(object_id++, email.user_name);
	qfree(email.user_name);
	
	//HENRY	
	strcpy(email_password, email.password);
	num_chars = strlen(email_password);	
	temp_string[num_chars] = 0;
	for (count = 0; count < num_chars; count ++)
		temp_string[count] = '*';
	FieldSetText(object_id++, temp_string);
	qfree(email.password);
	//HENRY	
	
	object_id = TEXTBOX_SYSETUP_EMAIL2_PRIDNS1;
	TextboxSetText(object_id++, email.pri_dns1);
	qfree(email.pri_dns1);
	TextboxSetText(object_id++, email.pri_dns2);
	qfree(email.pri_dns2);
	TextboxSetText(object_id++, email.pri_dns3);
	qfree(email.pri_dns3);
	TextboxSetText(object_id++, email.pri_dns4);
	qfree(email.pri_dns4);
	TextboxSetText(object_id++, email.sec_dns1);
	qfree(email.sec_dns1);
	TextboxSetText(object_id++, email.sec_dns2);
	qfree(email.sec_dns2);
	TextboxSetText(object_id++, email.sec_dns3);
	qfree(email.sec_dns3);
	TextboxSetText(object_id++, email.sec_dns4);
	qfree(email.sec_dns4);
	TextboxSetText(object_id++, email.ip_addr1);
	qfree(email.ip_addr1);
	TextboxSetText(object_id++, email.ip_addr2);
	qfree(email.ip_addr2);
	TextboxSetText(object_id++, email.ip_addr3);
	qfree(email.ip_addr3);
	TextboxSetText(object_id++, email.ip_addr4);
	qfree(email.ip_addr4);
	return TRUE;
}



/*****************************************************************
* Function:	SySetupSetSoundSettings
* Purpose: 	This function is used to set the sound settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetSoundSettings(void)
{
	DatabaseID	SySetup_dbid;
	BYTE		object_type;
	Scrollbar	*scroll_ptr;
	RecordID	rec_id;
	SoundSettings	sound;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (!SySetupGetSoundSettings(&sound))
		return FALSE;
	
	FormGetObjectPointer(SCROLLBAR_SYSETUP_SOUND_VOL, &object_type, (void**)&scroll_ptr);
	sound.vol_max	= (BYTE)scroll_ptr->scrollbar_max;
	sound.vol_min	= (BYTE)scroll_ptr->scrollbar_min;
	sound.vol_curr	= (BYTE)scroll_ptr->scrollbar_value;
	
	FormGetObjectPointer(SCROLLBAR_SYSETUP_SOUND_CLICK, &object_type, (void**)&scroll_ptr);
	sound.click_max	= (BYTE)scroll_ptr->scrollbar_max;
	sound.click_min	= (BYTE)scroll_ptr->scrollbar_min;
	sound.click_curr= (BYTE)scroll_ptr->scrollbar_value;
	
	// New add on 04/11/99 "Mic Settings"
	//--------------------------------------------------------
#ifdef MIC_IN_SET
	FormGetObjectPointer(SCROLLBAR_SYSETUP_SOUND_MIC, &object_type, (void**)&scroll_ptr);
	sound.mic_max	= (BYTE)scroll_ptr->scrollbar_max;
	sound.mic_min	= (BYTE)scroll_ptr->scrollbar_min;
	sound.mic_curr	= (BYTE)scroll_ptr->scrollbar_value;
	//--------------------------------------------------------
#endif
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, SOUND, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(SoundSettings), (BYTE*)&sound) != TRUE)
		return FALSE;
	
	if (sound.click_max -  sound.click_min < 1)
	{
		sound.click_max = 14;
		sound.click_min = 0;
	}
	
	
#ifdef PR31700
	if ((sound.vol_curr == 0) && (sound.click_curr == 0))
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, 0, 3))
			return FALSE;
	}
	else if(sound.vol_curr == 0)
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, (SHORT)((4*sound.click_curr)/(sound.click_max-sound.click_min)+23), 3))
			return FALSE;
	}
	else if(sound.click_curr == 0)
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((4*sound.vol_curr)/(sound.click_max-sound.click_min)+23), 0, 3))
			return FALSE;
	}
	else
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*sound.vol_curr)/(sound.click_max-sound.click_min)+23),
			(SHORT)((4*sound.click_curr)/(sound.click_max-sound.click_min)+23), 3))
			return FALSE;
	}
#endif
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupRestoreSoundSettings
* Purpose: 	This function is used to restore the sound settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreSoundSettings(void)
{
	BYTE		object_type;
	Scrollbar	*scroll_ptr;
	SoundSettings	sound;
	
	if (!SySetupGetSoundSettings(&sound))
		return FALSE;
	
	if (sound.click_max -  sound.click_min < 1)
	{
		sound.click_max = 14;
		sound.click_min = 0;
	}
	
#ifdef PR31700
	if ((sound.vol_curr == 0) && (sound.click_curr == 0))
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, 0, 3))
			return FALSE;
	}
	else if(sound.vol_curr == 0)
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, (SHORT)((4*sound.click_curr)/(sound.click_max-sound.click_min)+23), 3))
			return FALSE;
	}
	else if(sound.click_curr == 0)
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*sound.vol_curr)/(sound.click_max-sound.click_min)+23), 0, 3))
			return FALSE;
	}
	else
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*sound.vol_curr)/(sound.click_max-sound.click_min)+23),
			(SHORT)((4*sound.click_curr)/(sound.click_max-sound.click_min)+23), 3))
			return FALSE;
	}
#endif
	
	
	FormGetObjectPointer(SCROLLBAR_SYSETUP_SOUND_VOL, &object_type, (void**)&scroll_ptr);
	ScrollbarSetScrollbar(SCROLLBAR_SYSETUP_SOUND_VOL, sound.vol_curr, sound.vol_max, sound.vol_min, scroll_ptr->scrollbar_pagesize, scroll_ptr->scrollbar_total_num_lines);
	
	FormGetObjectPointer(SCROLLBAR_SYSETUP_SOUND_CLICK, &object_type, (void**)&scroll_ptr);
	ScrollbarSetScrollbar(SCROLLBAR_SYSETUP_SOUND_CLICK, sound.click_curr, sound.click_max, sound.click_min, scroll_ptr->scrollbar_pagesize, scroll_ptr->scrollbar_total_num_lines);
	
	// New add on 04/11/99 "Mic Settings"
#ifdef MIC_IN_SET
	//--------------------------------------------------------
	FormGetObjectPointer(SCROLLBAR_SYSETUP_SOUND_MIC, &object_type, (void**)&scroll_ptr);
	ScrollbarSetScrollbar(SCROLLBAR_SYSETUP_SOUND_MIC, sound.mic_curr, sound.mic_max, sound.mic_min, scroll_ptr->scrollbar_pagesize, scroll_ptr->scrollbar_total_num_lines);
	//--------------------------------------------------------
#endif
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetClockSettings
* Purpose: 	This function is used to set clock settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetClockSettings(void)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	BOOLEAN		ctrl_value;
	SHORT		item_num;
	ClockSettings	clock;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, CLOCK, &rec_id, NULL) != TRUE)
		return FALSE;
	
	FormGetControlValue(PUSH_SYSETUP_CLOCK_VIST_DST, &ctrl_value);
	if (ctrl_value)
		clock.visit_dst_active = 1;
	else
		clock.visit_dst_active = 0;
	
	FormGetControlValue(PUSH_SYSETUP_CLOCK_HOME_DST, &ctrl_value);
	if (ctrl_value)
		clock.home_dst_active = 1;
	else
		clock.home_dst_active = 0;
	
	ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_VIST_COUNTRY, &item_num);
	clock.visit_country = (BYTE)item_num;
	
	ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_HOME_COUNTRY, &item_num);
	clock.home_country = (BYTE)item_num;
	
	ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_AUTOFFTIME, &item_num);
	clock.auto_off_time = (BYTE)(item_num + 1);
	
	SySetupSetAutoOffTime(clock.auto_off_time);
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(ClockSettings), (BYTE*)&clock) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetKeyMappingSettings
* Purpose: 	This function is used to set the key mapping settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetKeyMappingSettings(void)
{
	DatabaseID			SySetup_dbid;
	ObjectID			popup_id;
	RecordID			rec_id;
	SHORT				item_num;
	KeyMappingSettings	key_mapping;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	popup_id=POPUP_SYSETUP_KEY_MAPPING_KEY1;
	
	if (DataOpenRecord(SySetup_dbid, KEY_MAPPING, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (ControlPopupGetSelectedItem(popup_id++, &item_num) != TRUE)
		return FALSE;
	key_mapping.key1 = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(popup_id++, &item_num) != TRUE)
		return FALSE;
	key_mapping.key2 = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(popup_id++, &item_num) != TRUE)
		return FALSE;
	key_mapping.key3 = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(popup_id++, &item_num) != TRUE)
		return FALSE;
	key_mapping.key4 = (BYTE)item_num;
	
	if (ControlPopupGetSelectedItem(popup_id++, &item_num) != TRUE)
		return FALSE;
	key_mapping.key5 = (BYTE)item_num;
	
	SySetupSetKeyMapping(key_mapping);
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(KeyMappingSettings), (BYTE*)&key_mapping) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupRestoreKeyMappingSettings
* Purpose: 	This function is used to restore the key mapping settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreKeyMappingSettings(void)
{
	DatabaseID			SySetup_dbid;
	ObjectID			control_id;
	KeyMappingSettings	key_mapping;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (!SySetupGetKeyMappingSettings(&key_mapping))
		return FALSE;
	
	control_id = POPUP_SYSETUP_KEY_MAPPING_KEY1;
	ControlPopupSetSelectedItem(control_id++, key_mapping.key1);
	ControlPopupSetSelectedItem(control_id++, key_mapping.key2);
	ControlPopupSetSelectedItem(control_id++, key_mapping.key3);
	ControlPopupSetSelectedItem(control_id++, key_mapping.key4);
	ControlPopupSetSelectedItem(control_id++, key_mapping.key5);
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupSetDefaultKeyMappingSettings
* Purpose: 	This function is used to set the default key mapping settings
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetDefaultKeyMappingSettings(void)
{
	DatabaseID			SySetup_dbid;
	RecordID			rec_id;
	KeyMappingSettings	key_mapping;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, KEY_MAPPING, &rec_id, NULL) != TRUE)
		return FALSE;
	
    key_mapping.key1 = SYSETUP_PHONEBOOK;
	key_mapping.key2 = SYSETUP_CALCULATOR;
    key_mapping.key3 = SYSETUP_TO_DO_LIST;
    key_mapping.key4 = SYSETUP_GLOBAL_FIND;
    key_mapping.key5 = SYSETUP_SCHEDULER;
	
	SySetupSetKeyMapping(key_mapping);
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(KeyMappingSettings), (BYTE*)&key_mapping) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	ControlPopupSetSelectedItem(POPUP_SYSETUP_KEY_MAPPING_KEY1, key_mapping.key1);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_KEY_MAPPING_KEY2, key_mapping.key2);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_KEY_MAPPING_KEY3, key_mapping.key3);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_KEY_MAPPING_KEY4, key_mapping.key4);
	ControlPopupSetSelectedItem(POPUP_SYSETUP_KEY_MAPPING_KEY5, key_mapping.key5);
	ControlDrawControl(POPUP_SYSETUP_KEY_MAPPING_KEY1);
	ControlDrawControl(POPUP_SYSETUP_KEY_MAPPING_KEY2);
	ControlDrawControl(POPUP_SYSETUP_KEY_MAPPING_KEY3);
	ControlDrawControl(POPUP_SYSETUP_KEY_MAPPING_KEY4);
	ControlDrawControl(POPUP_SYSETUP_KEY_MAPPING_KEY5);
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupInitScrCalData
* Purpose: 	This function is used to initialize the screen calibration data
*				in the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupInitScrCalData(void)
{
	WORD	i;
	
#ifdef DEBUG
	printf("\nCall SySetupInitScrCalData");
#endif
	
	for(i=0; i<NUM_SCR_CAL_SAMPLE; i++)
	{
		ScrCalCBufX[i] = 0;
		ScrCalCBufY[i] = 0;
		
	}
	
	return;
}

/*****************************************************************
* Function:	SySetupSetScrCalData
* Purpose: 	This function is used to input the screen calibration data
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input or counter overflow
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetScrCalData(SHORT x, SHORT y, SHORT pos)
{
	static BYTE	bitmap_drawn = 0;
	static WORD	x_buf_count = 0, y_buf_count = 0;
	BYTE	object_type, highlight_x = 0;
	Bitmap	*bitmap_ptr;
	
	ScrCalCBufX[(x_buf_count++)%NUM_SCR_CAL_SAMPLE] = x;
	ScrCalCBufY[(y_buf_count++)%NUM_SCR_CAL_SAMPLE] = y;
	switch(pos)
	{
		
	case LT_POS:
		if (x < 370 && y < 340)
		{
			highlight_x = 1;
			bitmap_drawn = 1;
		}
		else
			bitmap_drawn = 0;
		break;
	case RB_POS:
		if (x > 600 && y > 480)
		{
			highlight_x = 1;
			bitmap_drawn = 1;
		}
		else
			bitmap_drawn = 0;
		break;
	case ARB_POS:
		if (x > 570 && y < 400)
		{
			highlight_x = 1;
			bitmap_drawn = 1;
		}
		else
			bitmap_drawn = 0;
		break;
	default:
		break;
	}
	
#ifdef DEBUG
	printf("\n-----[[[[--->1: (%d, %d), pois=%d", x, y, pos);
#endif
	
	FormGetObjectPointer(BITMAP_SYSETUP_SCRCAL, &object_type, (void**)&bitmap_ptr);
	if (bitmap_drawn && (bitmap_ptr->bitmap_attr.bitmap_enter==0) && highlight_x)
	{
		bitmap_ptr->bitmap_attr.bitmap_enter = 1;
		BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
		bitmap_drawn = 0;
		return TRUE;
		
	}
	else if((bitmap_drawn==0) && (bitmap_ptr->bitmap_attr.bitmap_enter==1))
	{
		bitmap_ptr->bitmap_attr.bitmap_enter = 0;
		BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
	}
	
	return FALSE;
	
}


/*****************************************************************
* Function:	SySetupCalScrCalData
* Purpose: 	This function is used to Calibrate the screen calibration data
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupCalScrCalData(SHORT pos, SHORT *x1, SHORT *x2, SHORT *x3, SHORT *y1, SHORT *y2, SHORT *y3)
{
	WORD		i, j;
	UWORD		counts;
	
#ifdef DEBUG
	printf("\n!!!--->: *x1=%d, *x2=%d, *x3=%d, pos=%d", *x1, *x2, *x3, pos);
	printf("\n!!!!!--->: *y1=%d, *y2=%d, *y3=%d, pos=%d", *y1, *y2, *y3, pos);
#endif
	
	*x1 = 0;
	*x2 = 0;
	*x3 = 0;
	counts = 0;
	
	
	for (i=0; i<NUM_SCR_CAL_SAMPLE; i++)
		if	(ScrCalCBufX[i] > 0)
		{
			*x1 += (SHORT)ScrCalCBufX[i];
			counts++;
		}
		
		if (counts == 0)
			*x1 = 0;
		else *x1 /= counts;	
		
		// -----------------------------------------------------------------------------------------------
		*y1 = 0;
		*y2 = 0;
		*y3 = 0;
		counts = 0;
		
		for (i=0; i<NUM_SCR_CAL_SAMPLE; i++)
			if	(ScrCalCBufY[i] > 0)
			{
				*y1 += (SHORT)ScrCalCBufY[i];
				counts++;
			}
			
			if (counts == 0)
				*y1 = 0;
			else *y1 /= counts;	
			
			
			SySetupInitScrCalData();
			return TRUE;
}


/*****************************************************************
* Function:	SySetupVerifyScrCalData
* Purpose: 	This function is used to verify the screen calibration data
*				into the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupVerifyScrCalData(SHORT x1, SHORT x2, SHORT x3, SHORT y1, SHORT y2, SHORT y3)
{
	
    WORD	errX, errY;             /* the error is a ratio around 1.0  */
	WORD	tmpXa, tmpXb, tmpYa, tmpYb;
	
    WORD	Pen_Min_X;
    WORD	Pen_Min_Y;
    WORD	Pen_Max_X;
    WORD	Pen_Max_Y;
	
	
#ifdef DEBUG
	printf("\n++++++ x1=%ld, x2=%ld, x3=%ld : y1=%ld, y2=%ld, y3=%ld", x1, x2, x3, y1, y2, y3);
	printf("\n ==== predict ==> x3=%ld, y3=%ld", (CAL_P1*x2+CAL_P2*x1)/(CAL_P1+CAL_P2), (CAL_H1*y2+CAL_H2*y1)/(CAL_H1+CAL_H2));
#endif
	tmpXa = (CAL_P1+CAL_P2);
	tmpYa = (CAL_H1+CAL_H2);
	
	if (tmpXa==0 || tmpYa==0)
		return FALSE;
	
	tmpXb = (CAL_P1*x2+CAL_P2*x1) / tmpXa;
	tmpYb = (CAL_H1*y2+CAL_H2*y1) / tmpYa;
	
	if (tmpXb==0 || tmpYb==0)
		return FALSE;
	
	errX = x3 - tmpXb;
	errY = y3 - tmpYb;
	
	
#ifdef DEBUG
	printf("\n -------------------> errX=%ld, errY=%ld", errX, errY);
#endif
    /* assume we will accept 5% of error */
    if ((errX<15) && (errX>-15) && (errY<15) && (errY>-15))
    {
		
        Pen_Min_X = x1 - (x2-x1)*CAL_X1 / (CAL_X2-CAL_X1) ;
        Pen_Min_Y = y1 - (y2-y1)*CAL_Y1 / (CAL_Y2-CAL_Y1) ;
		
        Pen_Max_X = x2 + (x2-x1)*(PEN_MAX_X_DOT - CAL_X2) / (CAL_X2-CAL_X1) ;
        Pen_Max_Y = y2 + (y2-y1)*(PEN_MAX_Y_DOT - CAL_Y2) / (CAL_Y2-CAL_Y1) ;
		
#ifdef DEBUG
		printf("\n --------> Pen_Min_X=%ld, Pen_Min_Y=%ld, Pen_Max_X=%ld, Pen_Max_Y=%ld", Pen_Min_X, Pen_Min_Y, Pen_Max_X, Pen_Max_Y);
#endif
#ifdef PR31700
        PenSetCalValue (Pen_Min_X, Pen_Min_Y, Pen_Max_X, Pen_Max_Y ); /* syscall */
#endif
        return TRUE;
        
    }
	
	return FALSE;
}



/*****************************************************************
* Function:	SySetupRestoreSysInfo
* Purpose: 	This function is used to restore the system information settings
*				from the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreSysInfo(void)
{
	DatabaseID			SySetup_dbid;
	RecordID			rec_id;
	UWORD				byte_read;
	BYTE				text[30];
	SysInfoSettings		*sys_info;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, SYSINFO, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&sys_info, &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	sprintf((char*)text, SYSSTR11, sys_info->version);
	StringSetText(STRING_SYSETUP_SYSINFO_VER, text);
	
	sprintf((char*)text, SYSSTR12, sys_info->sdram);
	StringSetText(STRING_SYSETUP_SYSINFO_RAM, text);
	
	if (sys_info->sys_used < 1024)
		sprintf((char*)text, SYSSTR13, sys_info->sys_used);
	else
		sprintf((char*)text, SYSSTR14, (sys_info->sys_used)/1024, 100*((sys_info->sys_used)%1024)/1024);
	StringSetText(STRING_SYSETUP_SYSINFO_SYSUSED, text);
	
	qfree(sys_info);
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupFieldSetFont
* Purpose: 	This function is used to set the font size in field object
* Scope:		application
* Input:		field_id		field object ID
font			font size
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupFieldSetFont(ObjectID field_id, BYTE font)
{
	BYTE	object_type;
	Field	*field_ptr;
	
	FormGetObjectPointer(field_id, &object_type, (void**)&field_ptr);
	field_ptr->field_font_id = font;	
	StrAnalyzeLine(field_ptr);
	
	return;
}


#ifdef PR31700
/********************************************************
* Function:	SySetupCheckMemoryEmpty
* Purpose: 	This function is called to check the memory status
whether it is empty or not
* Scope:		Application
* Input:		None
* Output:		None
* Return:		TRUE
* Comment: 	None
*********************************************************/
BOOLEAN SySetupCheckMemoryEmpty()
{
	
	if (FREE_MEM_BLOCK_LIMIT > MemoryTotalFree())
		return TRUE;
	
	return FALSE;
}



/*****************************************************************
* Function:	SySetupDelAppToList
* Purpose: 	This function is used to show the applications to 
*				the list for application delete
* Scope:		application
* Input:		item_num
* Output:		*top_item_num
* Return:		TRUE				Complete
*				FALSE				Error
* Comment: 	The list object must be initialised first
*				The database must be opened first
*				The function will update the scrollbar too
*****************************************************************/
BOOLEAN SySetupDelAppToList(void)
{
	
	WORD		i;
	UWORD		size;
	BYTE		update = 0, app_size[10];
	
	ListDeleteAllItems(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME);
	ListDeleteAllItems(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE);
	
	G_total_app = SysTotalInstalledApp(BIT_RAM_PRG);
	if (G_total_app > 0)
	{
		G_del_app_ptr = (DelAppData*)qmalloc(G_total_app*sizeof(DelAppData));
		for (i=0; i<G_total_app; i++)
		{
			(G_del_app_ptr+i)->index = i;
			(G_del_app_ptr+i)->app_id = SysGetAppIDFromIndex(i, BIT_RAM_PRG);
			SysGetAppName((G_del_app_ptr+i)->app_id, (G_del_app_ptr+i)->app_name);	
			SysGetAppSize((G_del_app_ptr+i)->app_id, &((G_del_app_ptr+i)->app_size));
			update = 1;
		}
		ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, 0, SYSSTR15);
		ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE, 0, (BYTE*)"-----------");
		SySetupSortDelApp(G_del_app_ptr, G_total_app);
		for (i=0; i<G_total_app; i++)
		{
			ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, i+1, (G_del_app_ptr+i)->app_name);
			sprintf((char*)app_size, "%ldKB", 4*((G_del_app_ptr+i)->app_size));	
			ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE, i+1, app_size);	
		}
	}
	else
		G_del_app_ptr = (DelAppData*)qmalloc(sizeof(DelAppData));
	
	
	G_total_dd = SysTotalInstalledApp(BIT_TYPE);
	if (G_total_dd > 0)
	{
		G_del_dd_ptr = (DelAppData*)qmalloc(G_total_dd*sizeof(DelAppData));
		for (i=0; i<G_total_dd; i++)
		{
			(G_del_dd_ptr+i)->index = i;
			(G_del_dd_ptr+i)->app_id = SysGetAppIDFromIndex(i, BIT_TYPE);
			SysGetAppName((G_del_dd_ptr+i)->app_id, (G_del_dd_ptr+i)->app_name);
			SysGetAppSize((G_del_dd_ptr+i)->app_id, &((G_del_dd_ptr+i)->app_size));
			update = 1;
		}
		ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, G_total_app+1, SYSSTR16);
		ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE, G_total_app+1, (BYTE*)"-----------");
		SySetupSortDelApp(G_del_dd_ptr, G_total_dd);
		for (i=0; i<G_total_dd; i++)
		{
			ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, i+G_total_app+2, (G_del_dd_ptr+i)->app_name);
			sprintf((char*)app_size, "%ldKB", 4*((G_del_dd_ptr+i)->app_size));	
			ListInsertItem(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE, i+G_total_app+2, app_size);
			
		}
	}
	else
		G_del_dd_ptr = (DelAppData*)qmalloc(sizeof(DelAppData));
	
	if (update == 1)
	{
		SySetupDelAppListSetScrollbar();
		return TRUE;
	}
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupDelApp
* Purpose: 	This function is used to delete the applications
* Scope:		application
* Input:		item_num
app_name
* Output:		None
* Return:		TRUE				Complete
*				FALSE				Error
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupDelApp(USHORT item_num, BYTE *app_name)
{
	AppID	app_id;
	
	if (item_num < 1 || (G_total_app > 1 && item_num == G_total_app + 1) || item_num > G_total_app + G_total_dd +1)
		return FALSE;	
	
	if (SysGetAppID(app_name, &app_id) != TRUE)
		return FALSE;
	if (SysRemoveApp(app_id) != TRUE)
		return FALSE;
	
	return TRUE;
	
}


/*****************************************************************
* Function:	SySetupDelApp
* Purpose: 	This function is used to delete the applications
* Scope:		application
* Input:		index
* Output:		None
* Return:		TRUE				Complete
*				FALSE				Error
* Comment: 	None
*****************************************************************/
void SySetupSortDelApp(DelAppData *del_app_ptr, WORD total_app)
{
	WORD		i, j, k;
	BYTE		swap_flag;
	DelAppData	tmp_buf;
	
	if (total_app < 2)
		return;	
	
	for(i=0; i<total_app-1; i++)
	{
		for(j=i+1; j<total_app; j++)
		{
			k = 0;
			swap_flag = 0;
			while(( ((del_app_ptr+i)->app_name[k] != 0 && (del_app_ptr+j)->app_name[k] != 0) ||
				((del_app_ptr+i)->app_name[k] == 0 && (del_app_ptr+j)->app_name[k] == 0)   )&& !swap_flag)
			{
				if ((del_app_ptr+i)->app_name[k] > (del_app_ptr+j)->app_name[k])
				{
					tmp_buf = *(del_app_ptr+i);
					*(del_app_ptr+i) = *(del_app_ptr+j);
					*(del_app_ptr+j) = tmp_buf;
					swap_flag = 1;
				}
				else if((del_app_ptr+i)->app_name[k] == (del_app_ptr+j)->app_name[k])
					k++;
				else
					swap_flag = 1;
			}
			if ((del_app_ptr+i)->app_name[k] != 0 && !swap_flag)
			{
				tmp_buf = *(del_app_ptr+i);
				*(del_app_ptr+i) = *(del_app_ptr+j);
				*(del_app_ptr+j) = tmp_buf;
			}
			
		}
	}
	
	return;
}

#endif
