/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   battery.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   low battery 
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "system.h"
#include "dev_pwr.h"

//#define DEBUG

extern BOOLEAN  (*SystemFormDispatchEvent)(EvtType *Event);
WORD            CheckBatteryEmpty();
void            BatteryWarningRestore(void);
void            BatteryWarningRestore1(void);

AppID           SysGetRealActiveAppID();
extern          AppID    prev_appid;

/********************* Battery Warning Variable ***********************
******************************************************************/
BOOLEAN					battery_shuting_down = FALSE;

BOOLEAN                 battery_popup = FALSE;
BOOLEAN                 battery_pending = FALSE;
BOOLEAN                 battery_keyboard_status = FALSE;
BOOLEAN                 battery_menu_status = FALSE;
BOOLEAN                 battery_popup_status = FALSE;

BYTE                    battery_status 			= BAT_MAIN_LOW;
BYTE					battery_pending_status	= BAT_MAIN_LOW;
BYTE                    battery_enable = 1;
EvtType                 battery_old_event;
EvtType                 battery_inlay_event;

WORD                    battery_timer_label = -1;

AppID                   battery_current_app_id = 0;
ObjectID                battery_current_form_id = 0;
BitmapTemplate          battery_current_display_image;

/*****************************************************************
* Function:    BatteryWarningInit()
* Purpose:     This function is called to init the battery warning
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void BatteryWarningInit(void)
{
	battery_shuting_down = FALSE;
	
    battery_popup = FALSE;
    battery_status 			= BAT_MAIN_LOW;
    battery_pending_status	= BAT_MAIN_LOW;
    battery_keyboard_status = FALSE;
    battery_timer_label = -1;
    battery_pending = FALSE;
    battery_enable  = 1;
    battery_current_app_id = 0;
    battery_current_form_id = 0;
    battery_menu_status = FALSE;
    battery_popup_status = FALSE;
    battery_old_event.eventType = NULL_EVENT;
    battery_inlay_event.eventType = NULL_EVENT;
	
    battery_current_display_image.xcoord = 0;        
    battery_current_display_image.ycoord = 0;        
    battery_current_display_image.width = 160;       
    battery_current_display_image.height = 160;      
    battery_current_display_image.compressed = 0;    
    battery_current_display_image.quantisation = Q_TWO_BIT;
    battery_current_display_image.size = 0;          
    battery_current_display_image.bitmap_data = NULL;
	
    battery_current_display_image.bitmap_data = NULL;
}


/*****************************************************************
* Function:    BatteryWarningReset()
* Purpose:     This function is called to init the battery warning
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void BatteryWarningReset(void)
{
    battery_popup = FALSE;
    battery_status = BAT_MAIN_LOW;
    battery_pending_status = BAT_MAIN_LOW;
    battery_timer_label = -1;
    battery_pending = FALSE;
    battery_current_display_image.bitmap_data = NULL;    
}

/*****************************************************************
* Function:    BatteryWarningHandleEvent
* Purpose:     This function is called to handle the screen of Battery Warning Form
* Scope:		application/internal
* Input:       Event
* Output:		None
* Return:		None
* Comment:     None
******************************************************************/
BOOLEAN BatteryWarningHandleEvent(EvtType *Event)
{
	AppID       app_id = 0xFFFF;
	
	
	switch (Event->eventType)
	{
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X))
		{
			BatteryWarningRestore();
			return TRUE;
		}	
		return FALSE;
	case EVT_APP_STOP:
		if (battery_popup)
		{
			if (battery_current_display_image.bitmap_data != NULL)
			{
				Event->para1    = FROM_SYSTEM_DIALOG;
				Event->evtPBP   = &battery_current_display_image;
			}
			else
			{                    
				Event->para1    = 0;
				Event->evtPBP   = NULL;
			}                                        
		}                    
		
		BatteryWarningRestore1();
		return FALSE;            
	case EVT_BITMAP_SELECT:
		SndPlaySndEffect(SNDRES5_BEEP);
		BatteryWarningRestore();
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			BatteryWarningRestore();
		return TRUE;
	case EVT_FORM_OPEN:
		LcdGetBitmap(&battery_current_display_image);
		FormDrawForm(FORM_BATTERY);
		if (battery_status == BAT_MAIN_EMPTY || battery_status == BAT_DOOR_OPEN)
			BatteryWarningShutDown();
		if (battery_status == BAT_MAIN_LOW)
			battery_popup = TRUE;                
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/*****************************************************************
* Function:    BatteryWarningShutDown
* Purpose:     this function is called by the timer to shut down the system
* Scope:		application/internal
* Input:       Event
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void BatteryWarningShutDown()
{
    AppID       app_id = 0xFFFF;
    
    if (battery_timer_label != -1)
        TmrIntDisable(battery_timer_label);
    battery_timer_label = -1;
	
    BatteryWarningRestore1();
	
    prev_appid = SysGetActiveAppID();
    
    SysGetAppID(SKETCHAPP, &app_id);
    
    if (prev_appid == app_id && battery_current_display_image.bitmap_data != NULL)
		EvtAppendEvt(EVT_APP_STOP, prev_appid, FROM_SYSTEM_DIALOG, 0, &battery_current_display_image);                   
    else EvtAppendEvt(EVT_APP_STOP, prev_appid, 0, 0, NULL);
	
	
    
    EvtAppendEvt(EVT_POWER_DOWN, 0, 0, 0, NULL);   
    battery_shuting_down = TRUE;
}                                               


/*****************************************************************
* Function:    BatteryWarningPopup
* Purpose:     This function is called to popup the Battery Warning Form
* Scope:		application/internal
* Input:       Event
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
BOOLEAN BatteryWarningPopup(EvtType *Event)
{
    ObjectID    active_form_id;
    String      *string_ptr;
    BYTE        object_type;
    EvtType     event;
    void        *addr;
    BOOLEAN     handle = TRUE;
    Scrollbar	*scroll_ptr;
    List        *ptr;
    USHORT      count;
	
	if (battery_shuting_down)
		return FALSE;
	
#ifdef DEBUG
	if (Event->eventType == POWER_EVENT)
		printf("\n in Battery Warning Popup Event = %ld %ld %ld %ld", Event->eventType, Event->eventID, Event->para1, Event->para2);	
	printf("\n in Battery Warning Popup Door Status = %ld", BatDoorOpen());
	printf("\n in Battery Warning Popup Battery Empty = %ld", CheckBatteryEmpty());	
#endif
	
    if (BatDoorOpen() == 1 && !battery_shuting_down)
	{
		if (FormGetActiveFormID(&active_form_id) != TRUE || SysGetRealActiveAppID() == 0)
			return FALSE;
		
		Event->eventType 	= POWER_EVENT;
		Event->eventID		= BAT_DOOR_OPEN;
#ifdef DEBUG
		printf("\n in Battery Door Open in Warning");
#endif
	}
	else if (CheckBatteryEmpty() == 1 && !battery_shuting_down)
	{
		if (FormGetActiveFormID(&active_form_id) != TRUE || SysGetRealActiveAppID() == 0)
			return FALSE;
		
		Event->eventType 	= POWER_EVENT;
		Event->eventID		= BAT_MAIN_EMPTY;
#ifdef DEBUG
		printf("\n in Battery Battery Empty in Warning");
#endif
	}
	else 
	{	
       	if (Event->eventType != POWER_EVENT)
           	return FALSE;
		
		if (battery_pending == FALSE)
		{
			
			if (Event->eventID != BAT_MAIN_LOW &&
				Event->eventID != BAT_MAIN_EMPTY &&
				Event->eventID != BAT_DOOR_OPEN)
				return FALSE;
			
			if ((FormGetActiveFormID(&active_form_id) != TRUE || SysGetRealActiveAppID() == 0 || battery_enable == 0) && (Event->eventID == BAT_MAIN_LOW || Event->eventID == BAT_MAIN_EMPTY))
			{
				battery_pending = TRUE;
				battery_pending_status = Event->eventID;
#ifdef DEBUG
				printf("\n Battery Warning Popup - adding pending Event ------->");
				printf("\n Battery Warning Popup - battery_pending = %ld", battery_pending);             	
				printf("\n Battery Warning Popup - battery_pending_status = %ld", battery_pending_status);             					
#endif
				return FALSE;
			}                
		}
		else
		{
			if (battery_enable == 0)
			{
				if (Event->eventID == BAT_MAIN_LOW)							
					return FALSE;
				
				if ((battery_pending && battery_pending_status == BAT_MAIN_EMPTY) || (Event->eventID == BAT_MAIN_EMPTY) || (Event->eventID == BAT_DOOR_OPEN))
				{
					if (FormGetActiveFormID(&active_form_id) != TRUE || SysGetRealActiveAppID() == 0)
					{
						battery_pending = TRUE;
						battery_pending_status = Event->eventID;       		    
					}	
					else
					{
						Event->eventType 	= POWER_EVENT;
						Event->eventID		= BAT_DOOR_OPEN;
					}
				}
			}
			else
			{
				if (FormGetActiveFormID(&active_form_id) != TRUE || SysGetRealActiveAppID() == 0)
					return FALSE;
				
				if (Event->eventType == POWER_EVENT && (Event->eventID == BAT_MAIN_LOW || Event->eventID == BAT_MAIN_EMPTY ||
					Event->eventType == BAT_DOOR_OPEN))
				{
					battery_pending = FALSE;
					battery_pending_status = BAT_MAIN_LOW;
				}				
				else if (battery_pending_status == BAT_MAIN_LOW || battery_pending_status == BAT_MAIN_EMPTY)
				{	
					battery_pending 		= FALSE;
					battery_pending_status 	= Event->eventID;       		    
					Event->eventType 		= POWER_EVENT;
					Event->eventID			= battery_pending_status;
				}
			}       			
		}        		
    }
    
#ifdef DEBUG
	printf("\n BatteryWarningPopup pass IF ELSE - Event = %ld %ld", Event->eventType, Event->eventID);
#endif
	
    LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
    FormGetActiveFormID(&active_form_id);
    
#ifdef DEBUG
	printf("\n BatteryWarningPopup pass IF ELSE A - batttery_status = %ld active_id = %ld", battery_status, active_form_id);
#endif
	
    if ((battery_popup == TRUE) && (active_form_id == FORM_BATTERY))
    {
#ifdef DEBUG
		printf("\n BatteryWarningPopup - battery_popup = TRUE battery_status = %ld", battery_status);
#endif
		
        if (battery_status == (BYTE)Event->eventID)
            return FALSE;
		
        battery_popup = TRUE;
        battery_status = (BYTE)Event->eventID;
		
        FormGetObjectPointer(STRING_BATTERY, &object_type, (void**)&string_ptr);
		
        switch(Event->eventID)
        {
		case BAT_MAIN_LOW:
			StringSetText(STRING_BATTERY, SYSTR13);
			string_ptr->bounds.xcoord = BATTERY_XCOORD1;
			if (battery_timer_label != -1)
			{
				TmrIntDisable(battery_timer_label);
				battery_timer_label = -1;
			}
			FormDrawForm(FORM_BATTERY);
			FormSetEventHandler(FORM_BATTERY, (void**)&SystemFormDispatchEvent, (void*)BatteryWarningHandleEvent);                                
			break;
		case BAT_MAIN_EMPTY:
#ifdef DEBUG
			printf("\n Battery Warning Popup - BAT_EMPTY - battery_popup = TRUE");
#endif
			StringSetText(STRING_BATTERY, SYSTR14);
			string_ptr->bounds.xcoord = BATTERY_XCOORD2;
			BatteryWarningShutDown();
			return TRUE;                      
			break;
		case BAT_DOOR_OPEN:           
			StringSetText(STRING_BATTERY, SYSTR15);
			string_ptr->bounds.xcoord = BATTERY_XCOORD2;
			BatteryWarningShutDown();
			return TRUE;
		default:
			break;
        }
        return TRUE;
    }
    else if (battery_popup == FALSE)
    {   	
#ifdef DEBUG
		printf("\n Battery Warning Popup 10");
#endif
        BatteryWarningReset();
        if (old_event.eventType != NULL_EVENT)
        {
            event.eventType = PEN_EVENT;
            event.eventID   = PEN_UP;
            event.para1     = -10;
            event.para2     = -10;
            event.evtPBP    = NULL;
            if (old_event.eventType == EVT_KEYBOARD_ENTER || old_event.eventType == EVT_KEYBOARD_EXIT)
            {
				old_event.eventType = NULL_EVENT;
				if (keyboard.keyboard_attr.keyboard_enter)
				{    
					KeyboardDrawInvertKey(keyboard.keyboard_highlight_key);
					keyboard.keyboard_attr.keyboard_enter = FALSE;
                }            	    
			}            		
            else
            {
                FormGetObjectPointer((ObjectID)old_event.eventID, &object_type, (void**)&addr);                     
                switch(object_type)
                {
				case CONTROL:                  
					if (((Control*)addr)->control_style == POPUP_TRIGGER && 
						((ControlTemplatePopupTrigger*)(((Control*)addr)->control_template))->control_value == TRUE)
						ControlPopupTriggerClosePopupTrigger();       
					else
					{                		
						if (((Control*)addr)->control_attr.control_enter)
						{
							((Control*)addr)->control_attr.control_enter = FALSE;
							ControlDrawControl(old_event.eventID);
						}                                       	
					}                    	
					break;
				case FIELD:
					LcdEnableInsertPt(FALSE, 0, 0, ((Field*)addr)->field_font_id);
					break;
				case LIST:					
					ListHighlightOneItem(((List*)addr), ((List*)addr)->list_highlighted_item, FALSE);
					((List*)addr)->list_highlighted_item = -1;
					ListHighlightOneItem(((List*)addr), ((List*)addr)->list_selected_item, TRUE);
					
					count = ((List*)addr)->list_num_related_list;
					while (count)
					{
						count --;
						if (FormGetObjectPointer(((List*)addr)->list_related_list_id[count], &object_type, (void**)&ptr) != TRUE)
							break;
						ListHighlightOneItem(ptr, ptr->list_highlighted_item, FALSE);
						ptr->list_highlighted_item = -1;
						ListHighlightOneItem(ptr, ptr->list_selected_item, TRUE);
					}
					break;
				case SCROLLBAR:
					scroll_ptr = (Scrollbar *)addr;
					if (scroll_ptr->scrollbar_attr.scrollbar_enter ||
						scroll_ptr->scrollbar_attr.scrollbar_enter1 ||
						scroll_ptr->scrollbar_attr.scrollbar_enter2)
					{
						scroll_ptr->scrollbar_attr.scrollbar_enter 	= FALSE;
						scroll_ptr->scrollbar_attr.scrollbar_enter1 = FALSE;
						scroll_ptr->scrollbar_attr.scrollbar_enter2 = FALSE;										
						ScrollbarDrawScrollbar(old_event.eventID);					                					                
					}
					break;
				case TABLE:
					if (((Table*)addr)->table_attr.table_enter)
					{
						((Table*)addr)->table_attr.table_enter = FALSE;
						((Table*)addr)->table_current_row = (USHORT) (old_event.para1);
						((Table*)addr)->table_current_col = (USHORT) (old_event.para2);
						TableDrawTable(old_event.eventID);
					}
					break;
				case SCHLINE:                     
					break;
				case BITMAP:
					if (((Bitmap*)addr)->bitmap_attr.bitmap_enter)
					{
						((Bitmap*)addr)->bitmap_attr.bitmap_enter = FALSE;
						BitmapDrawBitmap(old_event.eventID);
					}
					break;
				case TEXTBOX:
					LcdEnableInsertPt(FALSE, 0, 0, ((Textbox*)addr)->textbox_font_id);
					break;
				case MENU:
					MenuCloseMenu();
					break;                                        
                }
            }
        }             
		
		//        LcdGetBitmap(&battery_current_display_image);
		
        battery_keyboard_status 		= keyboard_status;
        battery_menu_status 			= menu_status;
        battery_popup_status 			= popup_status;
        battery_old_event			 	= old_event;
        battery_inlay_event			 	= inlay_event;
		old_event.eventType				= NULL_EVENT;
		inlay_event.eventType			= NULL_EVENT;
		
		
        FormInitAllFormObjects(FORM_BATTERY);
        FormGetObjectPointer(STRING_BATTERY, &object_type, (void**)&string_ptr);
		
        //battery_popup = TRUE;
        battery_status = Event->eventID;
		
        battery_current_app_id = SysGetActiveAppID();
        battery_current_form_id = active_form_id;
		
        switch(Event->eventID)
        {
		case BAT_MAIN_LOW:
			battery_popup = TRUE;
			StringSetText(STRING_BATTERY, SYSTR13);
			string_ptr->bounds.xcoord = BATTERY_XCOORD1;
			break;
		case BAT_MAIN_EMPTY:
			BatteryWarningShutDown();
        	  	return TRUE;
				
	       case BAT_DOOR_OPEN:
			   BatteryWarningShutDown();
			   return TRUE;
           default:
			   break;
        }       
        FormPopupForm(FORM_BATTERY);
        return TRUE;
    }
    return FALSE;
}

/*****************************************************************
* Function:    BatteryWarningRestore
* Purpose:     This function is called to restore the form back to the application        
* Scope:		application/internal
* Input:       None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void BatteryWarningRestore(void)
{
    EvtType Event; 
	
    if (battery_popup == FALSE)
		return;
	
	if (SysGetRealActiveAppID() == 0)
	{
		if (battery_timer_label != -1)
			TmrIntDisable(battery_timer_label);
		BatteryWarningInit();	
		return;
	}		
	
	if (battery_current_display_image.bitmap_data != NULL)
    {	
		LcdDrawBitmap(&battery_current_display_image, FALSE);
		qfree(battery_current_display_image.bitmap_data);
    }    	
	
    if (battery_timer_label != -1)
    {
        TmrIntDisable(battery_timer_label);
        battery_timer_label = -1;
    }
	
	if (battery_current_form_id >= 2000)
	{
		switch (battery_current_form_id)
		{
		case FORM_GFIND_INPUT:
            FormSetEventHandler(FORM_GFIND_INPUT, (void**)&SystemFormDispatchEvent, (void*)GlobalFindInput);
            break;            
		case FORM_GFIND_RESULT:
            FormSetEventHandler(FORM_GFIND_RESULT, (void**)&SystemFormDispatchEvent, (void*)GlobalFindResult);
            break;
        case FORM_BATTERY:
            FormSetEventHandler(FORM_BATTERY, (void**)&SystemFormDispatchEvent, (void*)BatteryWarningHandleEvent);
            break;
        case FORM_SIO:
            FormSetEventHandler(FORM_BATTERY, (void**)&SystemFormDispatchEvent, (void*)SIOPopupHandleEvent);
            break;
		}            		
	}		
    FormSetActiveForm(battery_current_form_id); 
    
    BatteryWarningRestorePreviousFormStatus();
    
    if (battery_keyboard_status)
    {
		EvtAppendEvt(EVT_FORM_LOAD, battery_current_form_id, 0, 0, NULL);
		keyboard_status = TRUE;
		keyboard.keyboard_attr.keyboard_drawn = TRUE;
		KeyboardDrawKeyboardBitmap(keyboard.keyboard_current_bitmap_index);
		EvtAppendEvt(EVT_KEYBOARD_STATUS, 0, 1, 0, NULL);
    }
    else keyboard_status = FALSE;
	battery_keyboard_status = FALSE;
    BatteryWarningReset();
    LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
    EvtAppendEvt(EVT_FORM_ACTIVE, battery_current_form_id, 0, 0, NULL);
}


/*****************************************************************
* Function:    BatteryWarningRestore1
* Purpose:     This function is called to restore the form back to the application        
* Scope:		application/internal
* Input:       None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void BatteryWarningRestore1(void)
{
    EvtType Event; 
	
    if (battery_popup == FALSE)
		return;
	
	if (SysGetRealActiveAppID() == 0)
	{
		if (battery_timer_label != -1)
			TmrIntDisable(battery_timer_label);
		BatteryWarningInit();	
		return;
	}		
	
    if (battery_timer_label != -1)
    {
        TmrIntDisable(battery_timer_label);
        battery_timer_label = -1;
    }
	
	
	if (battery_current_form_id >= 2000)
	{
		switch (battery_current_form_id)
		{
		case FORM_GFIND_INPUT:
            FormSetEventHandler(FORM_GFIND_INPUT, (void**)&SystemFormDispatchEvent, (void*)GlobalFindInput);
            break;            
		case FORM_GFIND_RESULT:
            FormSetEventHandler(FORM_GFIND_RESULT, (void**)&SystemFormDispatchEvent, (void*)GlobalFindResult);
            break;
        case FORM_BATTERY:
            FormSetEventHandler(FORM_BATTERY, (void**)&SystemFormDispatchEvent, (void*)BatteryWarningHandleEvent);
            break;
        case FORM_SIO:
            FormSetEventHandler(FORM_BATTERY, (void**)&SystemFormDispatchEvent, (void*)SIOPopupHandleEvent);
            break;
		}            		
	}		
    FormSetActiveForm(battery_current_form_id); 
    
    keyboard_status = FALSE;
	battery_keyboard_status = FALSE;
	
    battery_popup = FALSE;
    battery_status = BAT_MAIN_LOW;
    battery_pending_status = BAT_MAIN_LOW;
    battery_timer_label = -1;
    battery_pending = FALSE;
    LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
    EvtAppendEvt(EVT_FORM_ACTIVE, battery_current_form_id, 0, 0, NULL);
}


/*****************************************************************
* Function:    BatteryWarningEnable
* Purpose:     This function is called to enable the showing of Battery Warning 
* Scope:		application/internal
* Input:       Event
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void BatteryWarningSetEnableStatus(BOOLEAN enable)
{
    ObjectID    active_form_id;
    BYTE        object_type;
    String      *string_ptr;
    EvtType 	event;
    void 		*addr;
    Scrollbar	*scroll_ptr;
    List        *ptr;
    USHORT      count;
	
	
	battery_enable = (BYTE)enable;  
    
	if (battery_pending == 0 || !enable || SysGetRealActiveAppID() == 0 || FormGetActiveFormID(&active_form_id) != TRUE)
		return ;
	
	BatteryWarningReset();
	if (old_event.eventType != NULL_EVENT)
	{
		event.eventType = PEN_EVENT;
		event.eventID   = PEN_UP;
		event.para1     = -10;
		event.para2     = -10;
		event.evtPBP    = NULL;
		if (old_event.eventType == EVT_KEYBOARD_ENTER || old_event.eventType == EVT_KEYBOARD_EXIT)
		{
            old_event.eventType = NULL_EVENT;
       	    if (keyboard.keyboard_attr.keyboard_enter)
       	    {
				KeyboardDrawInvertKey(keyboard.keyboard_highlight_key);    
                keyboard.keyboard_attr.keyboard_enter = FALSE;
            }                       		    
		}       		
		else
		{
			FormGetObjectPointer((ObjectID)old_event.eventID, &object_type, (void**)&addr);                     
            switch(object_type)
            {
			case CONTROL:                  
				if (((Control*)addr)->control_style == POPUP_TRIGGER && 
					((ControlTemplatePopupTrigger*)(((Control*)addr)->control_template))->control_value == TRUE)
					ControlPopupTriggerClosePopupTrigger();       
				else
				{                		
					if (((Control*)addr)->control_attr.control_enter)
					{
						((Control*)addr)->control_attr.control_enter = FALSE;
						ControlDrawControl(old_event.eventID);
					}                                       	
				}                    	
				break;
			case FIELD:
				LcdEnableInsertPt(FALSE, 0, 0, ((Field*)addr)->field_font_id);
				break;
			case LIST:					
				ListHighlightOneItem(((List*)addr), ((List*)addr)->list_highlighted_item, FALSE);
				((List*)addr)->list_highlighted_item = -1;
				ListHighlightOneItem(((List*)addr), ((List*)addr)->list_selected_item, TRUE);
				
				count = ((List*)addr)->list_num_related_list;
				while (count)
				{
					count --;
					if (FormGetObjectPointer(((List*)addr)->list_related_list_id[count], &object_type, (void**)&ptr) != TRUE)
						break;
					ListHighlightOneItem(ptr, ptr->list_highlighted_item, FALSE);
					ptr->list_highlighted_item = -1;
					ListHighlightOneItem(ptr, ptr->list_selected_item, TRUE);
				}
				break;
			case SCROLLBAR:
				scroll_ptr = (Scrollbar *)addr;
				if (scroll_ptr->scrollbar_attr.scrollbar_enter ||
					scroll_ptr->scrollbar_attr.scrollbar_enter1 ||
					scroll_ptr->scrollbar_attr.scrollbar_enter2)
				{
					scroll_ptr->scrollbar_attr.scrollbar_enter 	= FALSE;
					scroll_ptr->scrollbar_attr.scrollbar_enter1 = FALSE;
					scroll_ptr->scrollbar_attr.scrollbar_enter2 = FALSE;										
					ScrollbarDrawScrollbar(old_event.eventID);					                					                
				}
				break;
			case TABLE:
				if (((Table*)addr)->table_attr.table_enter)
				{
					((Table*)addr)->table_attr.table_enter = FALSE;
					((Table*)addr)->table_current_row = (USHORT) (old_event.para1);
					((Table*)addr)->table_current_col = (USHORT) (old_event.para2);
					TableDrawTable(old_event.eventID);
				}
				break;
			case SCHLINE:                     
				break;
			case BITMAP:
				if (((Bitmap*)addr)->bitmap_attr.bitmap_enter)
				{
					((Bitmap*)addr)->bitmap_attr.bitmap_enter = FALSE;
					BitmapDrawBitmap(old_event.eventID);
				}
				break;
			case TEXTBOX:
				LcdEnableInsertPt(FALSE, 0, 0, ((Textbox*)addr)->textbox_font_id);
				break;
			case MENU:
				MenuCloseMenu();
				break;                                        
            }
        }
	}             
	
	//LcdGetBitmap(&battery_current_display_image);
	
	battery_keyboard_status 		= keyboard_status;
	battery_menu_status 			= menu_status;
	battery_popup_status 		= popup_status;
	battery_old_event			= old_event;
	battery_inlay_event			= inlay_event;
	old_event.eventType			= NULL_EVENT;
	inlay_event.eventType		= NULL_EVENT;
    
	
	FormInitAllFormObjects(FORM_BATTERY);
	FormGetObjectPointer(STRING_BATTERY, &object_type, (void**)&string_ptr);
	
	battery_popup = TRUE;
	battery_status = battery_pending_status;;
	battery_current_app_id = SysGetActiveAppID();
	battery_current_form_id = active_form_id;
	
	switch(battery_pending_status)
	{
	   case BAT_MAIN_LOW:
		   StringSetText(STRING_BATTERY, SYSTR13);
		   string_ptr->bounds.xcoord = BATTERY_XCOORD1;
		   break;
       case BAT_MAIN_EMPTY:
		   StringSetText(STRING_BATTERY, SYSTR14);
		   string_ptr->bounds.xcoord = BATTERY_XCOORD1;
		   BatteryWarningShutDown();
		   return;
       default:
		   break;
	}
	
	FormPopupForm(FORM_BATTERY);
	battery_pending = FALSE;
	battery_pending_status = BAT_MAIN_LOW;
	return;
}

/********************************************************
* Function:    BatteryWarningRestorePreviousFormStatus
* Purpose:     This function is called to restore previous active form status
* Scope:		application/internal
* Input:       None
* Output:		None
* Return:      None
* Comment: 	None
*********************************************************/
void BatteryWarningRestorePreviousFormStatus()
{
    ObjectID    menu_id, active_object_id;
    BYTE        object_type, temp_undo_action;
    Menu        *menu_ptr;
    Control     *control_ptr;
    USHORT      num_of_objects, count;
    Form        *form_ptr;
    Field       *field_ptr;
    Textbox     *textbox_ptr;
    void        *addr;
	
    menu_status = FALSE;
    popup_status = FALSE;
    old_event = battery_old_event;
    inlay_event = battery_inlay_event;
	
	
    if (battery_menu_status == TRUE)
    {
        battery_menu_status = FALSE;
        FormGetMenuID(battery_current_form_id, &menu_id);
        if (FormGetObjectPointer(menu_id, &object_type, (void**)&menu_ptr) == TRUE)
        {
			if (menu_ptr->menu_attr.menu_drawn == TRUE)
				MenuRestoreBehindBits(menu_id);
			menu_ptr->menu_attr.menu_drawn = FALSE;
			old_event.eventType = NULL_EVENT;
			temp_undo_action = undo_action;
			FormObjectRestoreFocus();
			undo_action = temp_undo_action;
		}        	
    }     
	
    if (battery_popup_status == TRUE)
    {
        battery_popup_status = FALSE;
        if (FormGetObjectPointer(old_event.eventID, &object_type, (void**)&addr) == TRUE)
        {
			if (object_type == CONTROL)
			{       
				if (((Control*)addr)->control_style == POPUP_TRIGGER)
				{
					if (((ControlTemplatePopupTrigger*)(((Control*)addr)->control_template))->control_value == TRUE)
					{                        
						((ControlTemplatePopupTrigger*)(((Control*)addr)->control_template))->control_value = FALSE;
						popup_status = FALSE;
						((Control*)addr)->control_attr.control_enter = FALSE;
						ControlRestoreBitBehind(old_event.eventID);
						FormObjectRestoreFocus();
						old_event.eventType = NULL_EVENT;
					}                		
				}                	
            }
        }
    }
	
	
    if (FormGetObjectPointer(battery_current_form_id, &object_type, (void**)&form_ptr) == TRUE)
    {
		num_of_objects = form_ptr->form_num_objects;
		
		FormGetActiveObject(battery_current_form_id, &active_object_id);
		for (count = 0; count < num_of_objects; count++)
		{
			if (form_ptr->form_objects_list[count].object_id == active_object_id)
			{
				if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) != TRUE)
					continue;
				if (form_ptr->form_objects_list[count].object_type == FIELD)
				{
					if (((Field*)addr)->field_attr.field_insert_pt_visible == TRUE &&
						((Field*)addr)->field_attr.field_drawn == TRUE)                    
						FieldDrawField(form_ptr->form_objects_list[count].object_id);
					break;
				}
				else if (form_ptr->form_objects_list[count].object_type == TEXTBOX)
				{
					if (((Textbox*)addr)->textbox_attr.textbox_insert_pt_visible == TRUE &&
						((Textbox*)addr)->textbox_attr.textbox_drawn == TRUE)                    
						TextboxDrawTextbox(form_ptr->form_objects_list[count].object_id);
					break;
				}
			}
		}
	}    	
    old_event.eventType     = NULL_EVENT;
    inlay_event.eventType   = NULL_EVENT;
}
















