/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   clipboar.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Clipboard
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "stdafx.h"

#include "uidef.h"
#include "uifunc.h"


/*********************************************************************
* Function: ClipboardEraseItem
* Purpose: 	To erase the data in the clipboard
* Scope: 	OS
* Input: 	None
* Output: 	None
* Return: 	Return True if no error
* Comment: 	None
**********************************************************************/
Err ClipboardEraseItem()
{
	switch (clipboard.clipboard_type)
	{
    case CLIP_TEXT_DATA:
		pfree(((BYTE*)(clipboard.clipboard_data)));
		clipboard.clipboard_type = CLIP_EMPTY;
		clipboard.clipboard_size = 0;
		break;
    case CLIP_BITMAP_DATA:
		pfree(((BitmapTemplate*)(clipboard.clipboard_data))->bitmap_data);
		pfree(clipboard.clipboard_data);
		clipboard.clipboard_size = 0;
		clipboard.clipboard_type = CLIP_EMPTY;
		break;
    default:
		break;
	}
	return TRUE;
}
/*********************************************************************
* Function: ClipboardPutItem
* Purpose: 	To store data to clipboard
* Scope: 	OS
* Input: 	data_type 		data_type
data_ptr        Pointer to the data
data_size       size of data
* Output: 	None
* Return: 	Return True if no error
* Comment: 	None
**********************************************************************/
Err ClipboardPutItem(BYTE data_type, void *data_ptr, WORD data_size)
{
    WORD    len = 0;    
	
	ClipboardEraseItem();
	switch (data_type)
	{
    case CLIP_TEXT_DATA:
        len = strlen((BYTE*)data_ptr);
		clipboard.clipboard_type = CLIP_TEXT_DATA;
		clipboard.clipboard_data = (BYTE*)pmalloc((len + 1) * sizeof(BYTE));
		strcpy((BYTE*)clipboard.clipboard_data, (BYTE*)data_ptr);
		clipboard.clipboard_size = len;
		break;
    case CLIP_BITMAP_DATA:
		clipboard.clipboard_type = CLIP_BITMAP_DATA;
		clipboard.clipboard_data = data_ptr;
		clipboard.clipboard_size = data_size;
		break;
    default:
		break;
	}
	return TRUE;
}
/*********************************************************************
* Function: ClipboardGetItem
* Purpose: 	To restore the data from clipboard
* Scope: 	OS
* Input:    None
* Output:   data_type       Pointer to the type of the item
data_size       Pointer to the size of the item
* Return: 	Pointer to the item
* Comment: 	None
**********************************************************************/
void *ClipboardGetItem(BYTE *data_type, WORD *data_size)
{
	BYTE *temp;
	BitmapTemplate *temp1;
	
	
	switch (clipboard.clipboard_type)
	{
    case CLIP_TEXT_DATA:
		temp = (BYTE*)qmalloc((clipboard.clipboard_size + 1)*sizeof(BYTE));
		strcpy(temp, (BYTE*)clipboard.clipboard_data);
		*data_type = CLIP_TEXT_DATA;
		*data_size = clipboard.clipboard_size;
		return (void*)temp;
    case CLIP_BITMAP_DATA:
		temp1 = (BitmapTemplate*)qmalloc(sizeof(BitmapTemplate));
		temp1->xcoord = ((BitmapTemplate*)(clipboard.clipboard_data))->xcoord;
		temp1->ycoord = ((BitmapTemplate*)(clipboard.clipboard_data))->ycoord;
		temp1->width = ((BitmapTemplate*)(clipboard.clipboard_data))->width;
		temp1->height = ((BitmapTemplate*)(clipboard.clipboard_data))->height;
		temp1->compressed = ((BitmapTemplate*)(clipboard.clipboard_data))->compressed;
		temp1->quantisation = ((BitmapTemplate*)(clipboard.clipboard_data))->quantisation;
		temp1->size = ((BitmapTemplate*)(clipboard.clipboard_data))->size;
		temp1->bitmap_data = ((BitmapTemplate*)(clipboard.clipboard_data))->bitmap_data;
		*data_type = CLIP_BITMAP_DATA;
		*data_size = clipboard.clipboard_size;
		return (void*)temp1;
	case CLIP_EMPTY:
		temp = NULL;
		*data_type = CLIP_EMPTY;
		*data_size = 0;	
		return (void*)temp;
    default:
		break;
	}
	return NULL;
}
