/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   handle.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   All UI handle functions
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "uidef.h"
#include "uifunc.h"
#include "ioconmsg.h"
#include "uievent.h"
#include "sndmgr.h"



BYTE    arrow_delay = 0, pass_delay = 0;
extern  BOOLEAN     beep_beep;

/********************************************************
* Function:	ControlHandleEvent
* Purpose:		to handle the event that has occured in the cotnrol object
* Scope:		application/internal
* Input:       addr		Pointer to the control object that is
required to be handled
Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN ControlHandleEvent(Control *addr,EvtType *Event)
{
	ObjectID 	form_id;
	EvtType 	new_event;
	Control 	*pointer;
	ObjectID 	control_id;
	BYTE		*temp_text;
    USHORT      old_max;
	
	
	control_id = addr->identification.ui_object_id;	
	switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			if (old_event.eventType == EVT_CONTROL_ENTER && old_event.para2 == POPUP_TRIGGER &&
				((ControlTemplatePopupTrigger*)(addr->control_template))->control_value == TRUE)
			{
				switch (old_event.para1)
				{
				case 0:
					if (ControlSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) !=-1)
                  	     ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item =
                         ControlSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
					qfree(addr->control_text);
					addr->control_text = (BYTE*)qmalloc(
						(strlen(((ControlTemplatePopupTrigger*)
						(addr->control_template))->popup_items_list[((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item])+1)*sizeof(BYTE));
					strcpy(addr->control_text,((ControlTemplatePopupTrigger*)
						(addr->control_template))->popup_items_list[((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item]);
					((ControlTemplatePopupTrigger*)(addr->control_template))->control_value = FALSE;
					popup_status = FALSE;
					addr->control_attr.control_enter = FALSE;
					ControlRestoreBitBehind(control_id);
					ControlDrawControl(control_id);
					EvtAppendEvt(EVT_CONTROL_POPUP_SELECT, control_id, (WORD) ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item,
						0, (void*)addr);
					old_event.eventType = NULL_EVENT;
					//FormObjectSetFocus(control_id);
					FormObjectRestoreFocus();					  
					break;
				case 1:
					ControlSetPopupScroll(addr,MOVE_UP);
					addr->control_attr.control_enter1 = FALSE;
					ControlDrawControl(control_id);
					old_event.eventType = EVT_CONTROL_SELECT;
					old_event.eventID = control_id;
					old_event.para1 = 1;
					old_event.para2 = addr->control_style;
					old_event.evtPBP = (void*)addr;
					SndPlaySndEffect(SNDRES5_BEEP);
					break;
				case 2:
					ControlSetPopupScroll(addr,MOVE_DOWN);
					addr->control_attr.control_enter2 = FALSE;
					ControlDrawControl(control_id);
					old_event.eventType = EVT_CONTROL_SELECT;
					old_event.eventID = control_id;
					old_event.para1 = 2;
					old_event.para2 = addr->control_style;
					old_event.evtPBP = (void*)addr;
					SndPlaySndEffect(SNDRES5_BEEP);
					break;
				}
				return TRUE;
			}
			else if (old_event.eventType == EVT_CONTROL_EXIT && old_event.para2 == 4 &&
				((ControlTemplatePopupTrigger*)(addr->control_template))->control_value == TRUE)
			{
				switch (old_event.para1)
				{
				case 0:
					((ControlTemplatePopupTrigger*)(addr->control_template))->control_value = FALSE;
					popup_status = FALSE;
					addr->control_attr.control_enter = FALSE;
					ControlRestoreBitBehind(control_id);
					FormObjectRestoreFocus();
					old_event.eventType = NULL_EVENT;
					break;
				case 1:
					addr->control_attr.control_enter1 = FALSE;
					ControlSetPopupTriggerUpDownArrowOnly(addr);
					old_event.eventType = EVT_CONTROL_SELECT;
					old_event.eventID = control_id;
					old_event.para1 = 1;
					old_event.para2 = addr->control_style;
					old_event.evtPBP = (void*)addr;
					break;
				case 2:
					addr->control_attr.control_enter2 = FALSE;
					ControlSetPopupTriggerUpDownArrowOnly(addr);
					old_event.eventType = EVT_CONTROL_SELECT;
					old_event.eventID = control_id;
					old_event.para1 = 2;
					old_event.para2 = addr->control_style;
					old_event.evtPBP = (void*)addr;
					break;
				default:
					old_event.eventType = NULL_EVENT;
					break;
				}         
				return TRUE;
			}
			else if (old_event.eventType == EVT_CONTROL_EXIT)
			{
				FormObjectRestoreFocus();
				old_event.eventType = NULL_EVENT;
				return TRUE;
			}
			else if (old_event.eventType == EVT_CONTROL_ENTER)
			{
				EvtAppendEvt(EVT_CONTROL_SELECT, control_id, 0, (WORD) addr->control_style, (void*)addr);
				if (addr->control_style == 0 || addr->control_style == 2)
				{
					addr->control_attr.control_enter = FALSE;
					ControlDrawControl(control_id);
				}
				if (old_event.para2 != POPUP_TRIGGER)
					FormObjectSetFocus(control_id);
				return TRUE;
			}
			else if (old_event.eventType == EVT_CONTROL_REPEAT)
			{
				EvtAppendEvt(EVT_CONTROL_SELECT, control_id, 0, (WORD) addr->control_style, (void*)addr);
				addr->control_attr.control_enter = FALSE;
				ControlDrawControl(control_id);
				FormObjectSetFocus(control_id);
				old_event.eventType = NULL_EVENT;
				return TRUE;
			}
			else if (old_event.eventType == EVT_CONTROL_SELECT)
				return TRUE;
			break;
		case PEN_DOWN:
			if (FormPointInObject(control_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE && addr->control_attr.control_enable &&
				addr->control_attr.control_drawn)
			{
				new_event.para1 = 0;
				if (addr->identification.ui_object_type == 1 && addr->control_style == 4 &&
					((ControlTemplatePopupTrigger*)(addr->control_template))->control_value)
				{
					if (ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 1 ||
						ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 2)
					{
						new_event.para1 = (WORD)ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
						((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item =
							((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item;
					}
					else
					{
						if (((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item >= 0)
							ControlHighlightOneItem(addr, ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item, FALSE);                         
						
						((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item =
							ControlSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
						if (((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item >= 0)
							ControlHighlightOneItem(addr, ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item, FALSE);
					}
				}
				//FormObjectReleaseFocus(CONTROL);
				LcdEnableInsertPt(FALSE, 0, 0, 0);
				EvtAppendEvt(EVT_CONTROL_ENTER, control_id, new_event.para1, (WORD) addr->control_style, (void*)addr);
				return TRUE;
			}
			if (addr->identification.ui_object_type == 1 && addr->control_style == 4 &&
				((ControlTemplatePopupTrigger*)(addr->control_template))->control_value == TRUE)
			{
				((ControlTemplatePopupTrigger*)(addr->control_template))->control_value = FALSE;
				popup_status = FALSE;
				addr->control_attr.control_enter = FALSE;
				ControlRestoreBitBehind(control_id);
				ControlDrawControl(control_id);
				old_event.eventType = NULL_EVENT;
				FormObjectRestoreFocus();
			}
			old_event.eventType = NULL_EVENT;
			return FALSE;
		case PEN_MOVE:
			switch (old_event.eventType)
			{
			case EVT_CONTROL_ENTER:
				if (FormPointInObject(control_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) != TRUE)
				{
					new_event.para1 = 0;
					if (addr->control_style == 4 && ((ControlTemplatePopupTrigger*)(addr->control_template))->control_value)
					{
						if (old_event.para1 == 1 || old_event.para1 == 2)
							new_event.para1 = old_event.para1;
						else if (old_event.para1 == 0)
						{
							if (((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item >= 0)
								ControlHighlightOneItem(addr, ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item, FALSE);
							((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item =
								ControlSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
						}
					}
					EvtAppendEvt(EVT_CONTROL_EXIT, control_id, new_event.para1, (WORD) addr->control_style, (void*)addr);
				}
				else
				{
					if (addr->control_style == 4 && ((ControlTemplatePopupTrigger*)(addr->control_template))->control_value == TRUE)
					{
						if (old_event.para1 == 1 && ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 1)
							EvtAppendEvt(EVT_CONTROL_EXIT, control_id, 1, (WORD) addr->control_style, (void*)addr);
						else if (old_event.para1 == 2 && ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 2)
							EvtAppendEvt(EVT_CONTROL_EXIT, control_id, 2, (WORD) addr->control_style, (void*)addr);
						else if (old_event.para1 == 0 && ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 0)
						{
							if (((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item !=
								ControlSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)))
							{
								ControlHighlightOneItem(addr, ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item, FALSE);
								((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item =
									ControlSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
								ControlHighlightOneItem(addr, ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item, TRUE);
							}
						}
					}
				}
				return TRUE;
			case EVT_CONTROL_EXIT:
				if (FormPointInObject(control_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE)
				{
					if (addr->identification.ui_object_type == 1 && addr->control_style == 4 &&
						((ControlTemplatePopupTrigger*)(addr->control_template))->control_value)
					{
						if (old_event.para1 == 1 && ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 1)
							return TRUE;
						else if (old_event.para1 == 2 && ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 2)
							return TRUE;
						else if (old_event.para1 == 0 && ControlPopupClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 0)
							((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item =
							ControlSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
					}
					EvtAppendEvt(EVT_CONTROL_ENTER, control_id, old_event.para1, (WORD) addr->control_style, (void*)addr);
				}
				return TRUE;
			case EVT_CONTROL_REPEAT:
				if (FormPointInObject(control_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE)
				{
					if (((ControlTemplateRepeatButton*)(addr->control_template))->repeat_count == TOTAL_REPEAT_COUNT)
					{
						EvtAppendEvt(EVT_CONTROL_REPEAT, control_id, 0, (WORD) addr->control_style, (void*)addr);
						((ControlTemplateRepeatButton*)(addr->control_template))->repeat_count = 0;
					}
					else
					{
						((ControlTemplateRepeatButton*)(addr->control_template))->repeat_count++;
					}
					return TRUE;
				}
				else
				{
					EvtAppendEvt(EVT_CONTROL_EXIT, control_id, 0, (WORD) addr->control_style, (void*)addr);
					return TRUE;
				}
			default:
				return TRUE;
			}
		}
	case EVT_CONTROL_ENTER:
		old_event = *Event;
		addr->control_attr.control_enter = TRUE;
		if (Event->para2 == 2)
			EvtAppendEvt(EVT_CONTROL_REPEAT, control_id, 0, (WORD) addr->control_style, (void*)addr);
		if (Event->para2 == 4)
		{
			if (((ControlTemplatePopupTrigger*)(addr->control_template))->control_value)           
			{
				if (Event->para1 == 1)
					addr->control_attr.control_enter1 = TRUE;
				else 
					addr->control_attr.control_enter1 = FALSE;
				  
				if (Event->para1 == 2) 
					addr->control_attr.control_enter2 = TRUE;
				else 
					addr->control_attr.control_enter2 = FALSE;
				  
				ControlSetPopupTriggerUpDownArrowOnly(addr);
				ControlHighlightOneItem(addr, ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item, TRUE);
				return TRUE;
			}
		}
		ControlDrawControl(control_id);
		return TRUE;
	case EVT_CONTROL_EXIT:
		old_event = *Event;
		addr->control_attr.control_enter = FALSE;
		if (Event->para2 == 2) 
			((ControlTemplateRepeatButton*)(addr->control_template))->repeat_count = 0;
		if (Event->para2 == POPUP_TRIGGER)
		{
			if (((ControlTemplatePopupTrigger*)(addr->control_template))->control_value)
			{
				if (Event->para1 == 1)
					addr->control_attr.control_enter1 = FALSE;
				if (Event->para1 == 2) 
					addr->control_attr.control_enter2 = FALSE;
				if (Event->para1 == 1 || Event->para1 == 2)
					ControlSetPopupTriggerUpDownArrowOnly(addr);
				return TRUE;
			}
		}         		 
		ControlDrawControl(control_id);
		return TRUE;
	case EVT_CONTROL_SELECT:
		old_event = *Event;
		if (old_event.para2 == 1 || old_event.para2 == 3)
		{ 
			FormGetActiveFormID(&form_id);
			pointer = (Control*)(Event->evtPBP);
			((Control*)pointer)->control_attr.control_enter = FALSE;
			FormSetControlGroupSelection((ObjectID)(form_id),(ObjectID)(old_event.eventID));
			old_event.eventType = NULL_EVENT;
			SndPlaySndEffect(SNDRES5_BEEP);            
			return FALSE;
		}
		else if (old_event.para2 == 4 && old_event.para1 != 1 && old_event.para1 != 2)
		{
			popup_status = TRUE;
			addr->control_attr.control_enter  = FALSE;
			ControlDrawControl(control_id);
			if (((ControlTemplatePopupTrigger *)(addr->control_template))->popup_num_objects > 1)
			{			
				((ControlTemplatePopupTrigger*)(addr->control_template))->control_value = TRUE;
				((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item =
						((ControlTemplatePopupTrigger*)(addr->control_template))->popup_selected_item;
				  
				ControlSavePopupBounds(control_id);
				  
				if (((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item 
						>= (((ControlTemplatePopupTrigger*)(addr->control_template))->popup_num_objects - ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_max_num_item_display))
					((ControlTemplatePopupTrigger*)(addr->control_template))->popup_top_item_num = (((ControlTemplatePopupTrigger*)(addr->control_template))->popup_num_objects - ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_max_num_item_display);
				else             
				{
					((ControlTemplatePopupTrigger*)(addr->control_template))->popup_top_item_num = ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_highlighted_item;
					old_max = ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_max_num_item_display;
					ControlSavePopupBounds(control_id);
					if (old_max > ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_max_num_item_display)
					{
						((ControlTemplatePopupTrigger*)(addr->control_template))->popup_top_item_num -=
						(old_max - ((ControlTemplatePopupTrigger*)(addr->control_template))->popup_max_num_item_display);						
					}
				}                
				ControlSavePopupBounds(control_id);
				ControlSaveBehindBits(control_id);
				ControlDrawControl(control_id);
			}
			else
			{
				popup_status = FALSE;
				old_event.eventType = NULL_EVENT;
				if (((ControlTemplatePopupTrigger *)(addr->control_template))->popup_num_objects == 0)
				{
					strcpy(addr->control_text,"");
					((ControlTemplatePopupTrigger *)(addr->control_template))->popup_highlighted_item = -1;
					((ControlTemplatePopupTrigger *)(addr->control_template))->popup_selected_item = -1;
					ControlDrawControl(control_id);
				}
				else
				{              		
					ControlPopupGetPopupItem(control_id, 0, &temp_text);
					qfree(addr->control_text);
					addr->control_text = (BYTE*)qmalloc((strlen(temp_text) + 1) * sizeof(BYTE));
					strcpy(addr->control_text, temp_text);
					((ControlTemplatePopupTrigger *)(addr->control_template))->control_value = FALSE;
					addr->control_attr.control_enter = FALSE;
					ControlDrawControl(control_id);
				}
			}
			if (((ControlTemplatePopupTrigger *)(addr->control_template))->popup_highlighted_item 
					>= 	((ControlTemplatePopupTrigger *)(addr->control_template))->popup_num_objects)
				((ControlTemplatePopupTrigger *)(addr->control_template))->popup_highlighted_item = -1;
			return TRUE;
		}
		else if (old_event.para2 == 4 && (old_event.para1 == 1 || old_event.para1 == 2))
		{
			addr->control_attr.control_enter  = FALSE;
			addr->control_attr.control_enter1 = FALSE;
			addr->control_attr.control_enter2 = FALSE;
			ControlDrawControl(control_id);
		}
	default:
		return FALSE;
	}
}
/********************************************************
* Function:	FormHandleEvent(EvtType *Event)
* Purpose:		to handle the event that has occured in the form
* Scope:		application/internal
* Input:		Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN FormHandleEvent(EvtType *Event)
{
	Form        *form_ptr;
	void        *pointer;
	BYTE        object_type;
    BYTE        old_object_type;
	WORD        i, count, event_key_para2;
	ObjectID    form_id, object_id;
    Menu        *menu_ptr;
	List        *list_ptr;	
	Table       *table_ptr;
	Field		*field_ptr;
	Textbox		*textbox_ptr;
	
	if (old_event.eventType != 0)
		UISearchForAddress((ObjectID)(old_event.eventID),&old_object_type,(void**)&pointer);
	else old_object_type = -1;
	
	switch (Event->eventType)
	{
	case EVT_KEY:
		if (old_event.eventType !=  NULL_EVENT &&
            old_event.eventType !=  EVT_CONTROL_SELECT &&
            old_event.eventType !=  EVT_MENU_SELECT)
            return TRUE;
		
        if ((Event->para2 & 0x00000300) && (!menu_status && !popup_status))
			return FALSE;
		
		if (menu_status)
        {
            MenuKeyboardHandleMenu(Event);
			return TRUE;
        }	        
        else if (popup_status)
        {
            ControlPopupKeyboardHandleControlPopup(Event);	        
            return TRUE;
        }     
		
        if (FormGetActiveFormID(&form_id) != TRUE)
            return FALSE;  
		
		FormGetActiveObject(form_id, &object_id);
		UISearchForAddress(object_id,&object_type,(void**)&pointer);
		if (object_type == FIELD) 
		{
            if (((Field*)pointer)->identification.table_related != 0xFFFF)
            {
                if (FormGetObjectPointer(((Field*)pointer)->identification.table_related, &object_type, (void**)&table_ptr) != TRUE)
                    return TRUE;
                if (table_ptr->table_attr.table_enable == FALSE ||
                    ((Field*)pointer)->field_attr.field_enable == FALSE)
                    return TRUE;                    
            }                                                    
            else
            {
                if (((Field*)pointer)->field_attr.field_enable == FALSE)
                    return TRUE;
            }                    
			if (FieldHandleEvent((Field*)pointer,Event))
                return TRUE;
		}
		if (object_type == TEXTBOX)
		{
            if (((Textbox*)pointer)->identification.table_related != 0xFFFF)
            {
                if (FormGetObjectPointer(((Textbox*)pointer)->identification.table_related, &object_type, (void**)&table_ptr) != TRUE)
                    return TRUE;
                if (table_ptr->table_attr.table_enable == FALSE ||
                    ((Textbox*)pointer)->textbox_attr.textbox_enable == FALSE)
                    return TRUE;                    
            }                                                    
            else
            {
                if (((Textbox*)pointer)->textbox_attr.textbox_enable == FALSE)
                    return TRUE;
            }                    
			if (TextboxHandleEvent((Textbox*)pointer,Event)) return TRUE;
		}
		return FALSE;
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			switch (old_object_type)
			{
			case CONTROL:
				ControlHandleEvent((Control*)(old_event.evtPBP),Event);
				return TRUE;
			case FIELD:
				FieldHandleEvent((Field*)(old_event.evtPBP),Event);
				return TRUE;
			case LIST:
				ListHandleEvent((List*)(old_event.evtPBP),Event);
				return TRUE;
			case MENU: return FALSE;
			case SCROLLBAR:
				ScrollbarHandleEvent((Scrollbar*)(old_event.evtPBP),Event);
				return TRUE;
			case TABLE:
				TableHandleEvent((Table*)(old_event.evtPBP),Event);
				return TRUE;
			case SCHLINE:
				SchlineHandleEvent((Schline*)(old_event.evtPBP),Event);
				return TRUE;
			case BITMAP:
				BitmapHandleEvent((Bitmap*)(old_event.evtPBP),Event);
				return TRUE;
			case TEXTBOX:
				TextboxHandleEvent((Textbox*)(old_event.evtPBP),Event);
				return TRUE;
			default: return FALSE;
			}
			case PEN_DOWN:
#ifdef DEBUG
				printf("\n FormHandleEvent - PEN DOWN");			
#endif			  
				if (old_event.eventType == EVT_CONTROL_SELECT)
				{
					ControlHandleEvent((Control*)(old_event.evtPBP),Event);
					return TRUE;
				}
				if (old_event.eventType == EVT_MENU_SELECT ||
					old_event.eventType == EVT_MENU_ENTER ||
					old_event.eventType == EVT_MENU_EXIT ||
					old_event.eventType == EVT_MENU_SELECT_ITEM ||
					Event->eventType == EVT_MENU_SELECT)
				{
					return FALSE;
				}
				
				if (old_event.eventType != EVT_MENU_SELECT &&
					old_event.eventType != EVT_CONTROL_SELECT)
				{
					if (FormGetActiveFormID(&form_id) != TRUE)
						return FALSE;
#ifdef DEBUG
					printf("\n FormHandleEvent active_form_id = %ld", form_id);			
#endif			  
					
					if (UISearchForAddress(form_id,&object_type,(void**)&form_ptr) != TRUE) return ERR_UI_RES_NOT_FOUND;
					i = form_ptr->form_num_objects;
					
#ifdef DEBUG
					printf("\n FormHandleEvent form_num_objects = %ld", i);			
#endif			  
					
					while (i)
					{
						i--;
						if (UISearchForAddress(form_ptr->form_objects_list[i].object_id,&object_type,(void**)&pointer) != TRUE) return ERR_UI_RES_NOT_FOUND;
#ifdef DEBUG
						printf("\n FormHandleEvent object num = %ld    object_id = %ld    object_type = %ld", i, form_ptr->form_objects_list[i].object_id, form_ptr->form_objects_list[i].object_type);			
#endif			  				  
						switch (form_ptr->form_objects_list[i].object_type)
						{
						case CONTROL:
							if (ControlHandleEvent((Control*)pointer,Event)) return TRUE;
							break;
						case FIELD: 
							if (FieldHandleEvent((Field*)pointer,Event)) return TRUE;
							break;
						case LIST:
							if (ListHandleEvent((List*)pointer,Event)) return TRUE;
							break;
						case SCROLLBAR:
							if (ScrollbarHandleEvent((Scrollbar*)pointer,Event)) return TRUE;
							break;
						case TABLE:
							if (TableHandleEvent((Table*)pointer,Event))return TRUE;
							break;
						case SCHLINE:
							if (SchlineHandleEvent((Schline*)pointer,Event))return TRUE;
							break;
						case BITMAP:
							if (BitmapHandleEvent((Bitmap*)pointer,Event)) return TRUE;
							break;
						case TEXTBOX: 
							if (TextboxHandleEvent((Textbox*)pointer,Event)) return TRUE;
							break;
						default: break;
						}
					}
					old_event.eventType = NULL_EVENT;
					return FALSE;
				}
			case PEN_MOVE:
				switch (old_object_type)
				{
				case CONTROL:
					ControlHandleEvent((Control*)(old_event.evtPBP),Event);
					return TRUE;
				case FIELD: 
					FieldHandleEvent((Field*)(old_event.evtPBP),Event);
					return TRUE;
				case LIST:
					if ((FormPointInObject(((List*)(old_event.evtPBP))->identification.ui_object_id, 
						(SHORT)(Event->para1),(SHORT)(Event->para2)) != TRUE) &&
						(((List*)(old_event.evtPBP))->list_num_related_list > 0))
					{
						count = ((List*)(old_event.evtPBP))->list_num_related_list;
						while (count)
						{
							count--;
							if (FormPointInObject(((List*)(old_event.evtPBP))->list_related_list_id[count],
								(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE)
							{
								UISearchForAddress(((List*)(old_event.evtPBP))->list_related_list_id[count],
									&object_type, (void**)&list_ptr);
								old_event.evtPBP = (void*)list_ptr;
							}
						}
						
					}
					ListHandleEvent((List*)(old_event.evtPBP),Event);
					return TRUE;
				case SCROLLBAR:
					ScrollbarHandleEvent((Scrollbar*)(old_event.evtPBP),Event);
					return TRUE;
				case MENU: return FALSE;
				case TABLE:
					TableHandleEvent((Table*)(old_event.evtPBP),Event);
                    return TRUE;
				case SCHLINE:
					SchlineHandleEvent((Schline*)(old_event.evtPBP),Event);
					return TRUE;
				case BITMAP:
					BitmapHandleEvent((Bitmap*)(old_event.evtPBP),Event);
					return TRUE;
				case TEXTBOX: 
					TextboxHandleEvent((Textbox*)(old_event.evtPBP),Event);
					return TRUE;
				default: return FALSE;
				}
				default: return FALSE;
		 }
      case EVT_IO_KEY_CTRL:
          if (menu_status)
			  return TRUE;
          if (old_event.eventType == EVT_FIELD_ENTER ||
              old_event.eventType == EVT_TEXTBOX_ENTER)
			  return TRUE;
          if (old_event.eventType != EVT_CONTROL_SELECT)
			  return FALSE;
          if (old_event.para2 != POPUP_TRIGGER)
			  return FALSE;     
		  
          if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
          {
			  if (Event->para2 == IO_UP_ARROW)
				  ControlSetPopupScroll((Control*)pointer,MOVE_UP);
			  else if (Event->para2 == IO_DOWN_ARROW)
				  ControlSetPopupScroll((Control*)pointer,MOVE_DOWN);
			  ((Control*)pointer)->control_attr.control_enter1 = FALSE;
			  ((Control*)pointer)->control_attr.control_enter2 = FALSE;
			  ControlDrawControl(old_event.eventID);
			  if (beep_beep)
				  SndPlaySndEffect(SNDRES5_BEEP);
			  return TRUE;
          }
          return FALSE;
	  case EVT_CONTROL_ENTER:
		  ControlHandleEvent((Control*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_FIELD_ENTER: 
		  FieldHandleEvent((Field*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_LIST_ENTER:
		  ListHandleEvent((List*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_MENU_ENTER:
		  return FALSE;
	  case EVT_SCROLLBAR_ENTER:
		  ScrollbarHandleEvent((Scrollbar*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_TABLE_ENTER:
		  TableHandleEvent((Table*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_SCHLINE_ENTER:
		  SchlineHandleEvent((Schline*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_BITMAP_ENTER:
		  BitmapHandleEvent((Bitmap*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_TEXTBOX_ENTER:  
		  TextboxHandleEvent((Textbox*)Event->evtPBP,Event);
		  return TRUE;
	  case EVT_CONTROL_REPEAT:
		  old_event = *Event;
		  return FALSE;
	  case EVT_SCROLLBAR_REPEAT:
		  if (by_pass_scrollbar_event)
			  by_pass_scrollbar_event = FALSE;
		  else old_event = *Event;
		  return FALSE;
      case EVT_SCROLLBAR_ARROW_DELAY:
		  old_event = *Event;
		  return TRUE;               
      case EVT_CONTROL_EXIT:
		  ControlHandleEvent((Control*)(Event->evtPBP),Event);
		  return TRUE;
      case EVT_LIST_EXIT:
		  ListHandleEvent((List*)(Event->evtPBP),Event);
		  return TRUE;
      case EVT_MENU_EXIT:
		  return FALSE;
      case EVT_SCROLLBAR_EXIT:
		  ScrollbarHandleEvent((Scrollbar*)(Event->evtPBP),Event);
		  return TRUE;
      case EVT_TABLE_EXIT:
		  TableHandleEvent((Table*)(Event->evtPBP),Event);
		  return TRUE;
      case EVT_SCHLINE_EXIT:
		  SchlineHandleEvent((Schline*)(Event->evtPBP),Event);
		  return TRUE;
      case EVT_BITMAP_EXIT:
		  BitmapHandleEvent((Bitmap*)(Event->evtPBP),Event);
		  return TRUE;
      case EVT_CONTROL_SELECT:
		  if (Event->para2 == 1 || Event->para2 == 3 || Event->para2 == 4)
		  {
			  if (UISearchForAddress((ObjectID)(old_event.eventID),&object_type,(void**)&pointer) != TRUE)
				  return ERR_UI_RES_NOT_FOUND;
			  if (ControlHandleEvent((Control*)pointer,Event) == TRUE)
			  {
				  SndPlaySndEffect(SNDRES5_BEEP);
				  return TRUE;
			  }
			  else return FALSE;
		  }
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
	  case EVT_CONTROL_POPUP_SELECT:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
	  case EVT_FIELD_SELECT:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
	  case EVT_LIST_SELECT:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
	  case EVT_MENU_SELECT:
          old_event = *Event;
          UISearchForAddress((ObjectID)(Event->eventID),&object_type,(void**)&menu_ptr);
          menu_ptr->menu_attr.menu_drawn = TRUE;
          MenuSaveBehindBits((ObjectID)Event->eventID);
          MenuDrawMenu((ObjectID)Event->eventID);
		  SndPlaySndEffect(SNDRES5_BEEP);
          return TRUE;
	  case EVT_MENU_SELECT_ITEM:
          old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
          return FALSE;
	  case EVT_SCROLLBAR_SELECT:
          old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
          return FALSE;
	  case EVT_TABLE_SELECT:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
	  case EVT_SCHLINE_SELECT:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
	  case EVT_BITMAP_SELECT:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
	  case EVT_TEXTBOX_SELECT:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
      case EVT_LIST_ARROW:
		  old_event.eventType = NULL_EVENT;
		  SndPlaySndEffect(SNDRES5_BEEP);
		  return FALSE;
      case EVT_FIELD_CHANGED:
		  return FALSE;
      case EVT_FIELD_HEIGHT:
		  return FALSE;
      case EVT_FIELD_JOT_PASTE_STRING:
		  if (FormGetActiveFormID(&form_id) != TRUE)
		  {
			  pfree(Event->evtPBP);
			  return TRUE;
		  }
		  
		  if (FormGetActiveObject(form_id, &object_id) != TRUE)
		  {
			  pfree(Event->evtPBP);
			  return TRUE;
		  }
		  
		  if (object_id != Event->eventID)
		  {
			  pfree(Event->evtPBP);
			  return TRUE;
		  }
		  
		  if (FormGetObjectPointer(object_id, &object_type, (void**)&field_ptr) != TRUE)
			  pfree(Event->evtPBP);
		  
		  if (field_ptr->field_attr.field_enable)
		  {
			  FieldPasteString(object_id, (BYTE*)(Event->evtPBP));
			  FieldDrawField(object_id);
		  }  			
		  pfree(Event->evtPBP);
		  return TRUE;
      case EVT_TEXTBOX_JOT_PASTE_STRING:
		  if (FormGetActiveFormID(&form_id) != TRUE)
		  {
			  pfree(Event->evtPBP);
			  return TRUE;
		  }
		  
		  if (FormGetActiveObject(form_id, &object_id) != TRUE)
		  {
			  pfree(Event->evtPBP);
			  return TRUE;
		  }
		  
		  if (object_id != Event->eventID)
		  {
			  pfree(Event->evtPBP);
			  return TRUE;
		  }
		  
		  if (FormGetObjectPointer(object_id, &object_type, (void**)&textbox_ptr) != TRUE)
			  pfree(Event->evtPBP);
		  
		  if (textbox_ptr->textbox_attr.textbox_enable)
		  {	
			  TextboxPasteString(object_id, (BYTE*)(Event->evtPBP));
			  TextboxDrawTextbox(object_id);
		  }        	
		  pfree(Event->evtPBP);
		  return TRUE;     
      default: return FALSE;
   }
   return FALSE;
}
/********************************************************
* Function:	TableHandleEvent
* Purpose:		to handle the event that has occured in the table object
* Scope:		application/internal
* Input:       addr		Pointer to the table object that is
required to be handled
Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN TableHandleEvent(Table *addr, EvtType *Event)
{
    USHORT row_number;
    USHORT col_number;
    USHORT cell_number;
	ObjectID table_id;
	
	table_id = addr->identification.ui_object_id;
    switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			switch (old_event.eventType)
			{
			case EVT_TABLE_ENTER:
				EvtAppendEvt(EVT_TABLE_SELECT, table_id, old_event.para1, old_event.para2, (void*)addr);
				addr->table_attr.table_enter = FALSE;
				if (addr->table_attr.table_highlight_enable == TRUE)
				{
					cell_number = (USHORT)((old_event.para1) * (addr->table_num_column) + old_event.para2);
					if (addr->table_item_ptr[cell_number]->table_cell_highlight == TRUE)
						addr->table_item_ptr[cell_number]->table_cell_highlight = FALSE;
					else addr->table_item_ptr[cell_number]->table_cell_highlight = TRUE;
				}
				TableDrawTable(table_id);
				FormObjectSetFocus(table_id);
				old_event.eventType = NULL_EVENT;
				return TRUE;
			case EVT_TABLE_EXIT:
				old_event.eventType = NULL_EVENT;
				addr->table_attr.table_enter = FALSE;
				TableDrawTable(table_id);
				FormObjectRestoreFocus();
				return TRUE;
			default: return FALSE;
			}
            case PEN_DOWN:
				if (FormPointInObject(table_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
					addr->table_attr.table_enable  && addr->table_attr.table_drawn)
				{
					TableGetClickedCell(table_id, (SHORT)(Event->para1),
						(SHORT)(Event->para2),&row_number,&col_number,&cell_number);
					EvtAppendEvt(EVT_TABLE_ENTER, table_id, row_number, col_number, (void*)addr);
					FormObjectReleaseFocus(TABLE);
					old_event.eventType = NULL_EVENT;
					return TRUE;
				}
				old_event.eventType = NULL_EVENT;
				return FALSE;
            case PEN_MOVE:
				switch (old_event.eventType)
				{
                case EVT_TABLE_ENTER:
					if (FormPointInObject(addr->identification.ui_object_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
						addr->table_attr.table_enable  && addr->table_attr.table_drawn)
					{
						TableGetClickedCell(addr->identification.ui_object_id,(SHORT)(Event->para1),
							(SHORT)(Event->para2),&row_number,&col_number,&cell_number);
						if (row_number == (USHORT)(old_event.para1) && col_number == (USHORT)(old_event.para2))
							return TRUE;
					}
					EvtAppendEvt(EVT_TABLE_EXIT, table_id, old_event.para1, old_event.para2, (void*)addr);
					return TRUE;
                case EVT_TABLE_EXIT:
					if (FormPointInObject(addr->identification.ui_object_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
						addr->table_attr.table_enable  && addr->table_attr.table_drawn)
					{
						TableGetClickedCell(addr->identification.ui_object_id,(SHORT)(Event->para1),
							(SHORT)(Event->para2),&row_number,&col_number,&cell_number);
						if (row_number == (USHORT)(old_event.para1) && col_number == (USHORT)(old_event.para2))
						{
							EvtAppendEvt(EVT_TABLE_ENTER, table_id, old_event.para1, old_event.para2, (void*)addr);
							return TRUE;
						}
					}
					return TRUE;
                default: return FALSE;
				}
				default: return FALSE;
		}
		case EVT_TABLE_ENTER:
			old_event = *Event;
			addr->table_attr.table_enter = TRUE;
			addr->table_current_row = (USHORT) (old_event.para1);
			addr->table_current_col = (USHORT) (old_event.para2);
			TableDrawTable(addr->identification.ui_object_id);
			return TRUE;
		case EVT_TABLE_EXIT:
			old_event = *Event;
			addr->table_attr.table_enter = FALSE;
			addr->table_current_row = (USHORT) (old_event.para1);
			addr->table_current_col = (USHORT) (old_event.para2);
			TableDrawTable(addr->identification.ui_object_id);
			return TRUE;
		default: return FALSE;
    }
}
/********************************************************
* Function:	BitmapHandleEvent
* Purpose:		to handle the event that has occured in the bitmap object
* Scope:		application/internal
* Input:       addr		Pointer to the bitmap object that is
required to be handled
Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN BitmapHandleEvent(Bitmap *addr, EvtType *Event)
{
	ObjectID bitmap_id;
	
	bitmap_id = addr->identification.ui_object_id;
    switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			switch (old_event.eventType)
			{
			case EVT_BITMAP_ENTER:
				EvtAppendEvt(EVT_BITMAP_SELECT, bitmap_id, 0, 0, (void*)addr);
				addr->bitmap_attr.bitmap_enter = FALSE;
				BitmapDrawBitmap(bitmap_id);
				FormObjectSetFocus(bitmap_id);
				old_event.eventType = NULL_EVENT;
				return TRUE;
			case EVT_BITMAP_EXIT:
				old_event.eventType = NULL_EVENT;
				addr->bitmap_attr.bitmap_enter = FALSE;
				BitmapDrawBitmap(bitmap_id);
				FormObjectRestoreFocus();
				return TRUE;
			default: return FALSE;
			}
            case PEN_DOWN:
				if (FormPointInObject(bitmap_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
					addr->bitmap_attr.bitmap_enable  && addr->bitmap_attr.bitmap_drawn)
				{
					//EvtAppendEvt(EVT_BITMAP_ENTER, bitmap_id, 0, 0, (void*)addr);
					old_event.eventType     =   EVT_BITMAP_ENTER;
					old_event.eventID       =   bitmap_id;
					old_event.para1         =   0;
					old_event.para2         =   0;
					old_event.evtPBP        =   (void*)addr;
					addr->bitmap_attr.bitmap_enter = TRUE;
					BitmapDrawBitmap(bitmap_id);               
					FormObjectReleaseFocus(BITMAP);
					return TRUE;
				}
				old_event.eventType = NULL_EVENT;
				return FALSE;
            case PEN_MOVE:
				switch (old_event.eventType)
				{
                case EVT_BITMAP_ENTER:
					if (FormPointInObject(bitmap_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) != TRUE &&
						addr->bitmap_attr.bitmap_enable  && addr->bitmap_attr.bitmap_drawn)
					{
						addr->bitmap_attr.bitmap_enter  =    FALSE;
						BitmapDrawBitmap(bitmap_id);
						old_event.eventType     =    EVT_BITMAP_EXIT;		          
                        old_event.eventID     =    bitmap_id;
						old_event.evtPBP        =    (void*)addr;      
						//EvtAppendEvt(EVT_BITMAP_EXIT, bitmap_id, 0, 0, (void*)addr);
					}					    
					return TRUE;
                case EVT_BITMAP_EXIT:
					if (FormPointInObject(bitmap_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
						addr->bitmap_attr.bitmap_enable  && addr->bitmap_attr.bitmap_drawn)
					{                      
						addr->bitmap_attr.bitmap_enter  =    TRUE;
						BitmapDrawBitmap(bitmap_id);
						old_event.eventType     =    EVT_BITMAP_ENTER;		          
                        old_event.eventID       =    bitmap_id;
						old_event.evtPBP        =    (void*)addr;      
						//EvtAppendEvt(EVT_BITMAP_ENTER, bitmap_id, 0, 0, (void*)addr);
					}					    
					return TRUE;
                default: return FALSE;
				}
				default: return FALSE;
		}
		case EVT_BITMAP_ENTER:
			return TRUE;
		case EVT_BITMAP_EXIT:
			return TRUE;
		default: return FALSE;
    }
}
/********************************************************
* Function:	MenuHandleEvent
* Purpose:		to handle the event that has occured in the menu object
* Scope:		application/internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN MenuHandleEvent(EvtType *Event)
{
    ObjectID menu_id;
    Menu *addr;
	BYTE object_type;
	BYTE temp_undo_action;
	
    if (old_event.eventType == 0) return FALSE;
	if (UISearchForAddress((ObjectID)(old_event.eventID),&object_type,(void**)&addr) != TRUE) return FALSE;
	menu_id = addr->identification.ui_object_id;
	
    if (object_type != MENU) return FALSE;
    switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			switch (old_event.eventType)
			{
			case EVT_MENU_ENTER:
				menu_status = FALSE;	
				addr->menu_selected_item = MenuSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
				EvtAppendEvt(EVT_MENU_SELECT_ITEM, menu_id, addr->menu_selected_item, 0, (void*)addr);
				addr->menu_selected_item = -1;
				addr->menu_highlighted_item = -1;
				addr->menu_attr.menu_drawn = FALSE;
				MenuRestoreBehindBits(menu_id);
				old_event.eventType = NULL_EVENT;
				temp_undo_action = undo_action;
				FormObjectRestoreFocus();
				undo_action = temp_undo_action;
				return TRUE;
			case EVT_MENU_EXIT:
				menu_status = FALSE;	
				old_event.eventType = NULL_EVENT;
				addr->menu_attr.menu_drawn = FALSE;
				MenuRestoreBehindBits(menu_id);
				temp_undo_action = undo_action;
				FormObjectRestoreFocus();
				undo_action = temp_undo_action;
				EvtAppendEvt(EVT_MENU_DESELECT, menu_id, 0, 0, (void*)addr);
				return TRUE;
			default:
				return TRUE;
			}
            case PEN_DOWN:
				if (FormPointInObject(menu_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
					addr->menu_attr.menu_drawn && menu_status == TRUE)
				{
                    addr->menu_highlighted_item = MenuSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
					EvtAppendEvt(EVT_MENU_ENTER, menu_id, 0, 0, (void*)addr);
					temp_undo_action = undo_action;
                    LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
					undo_action = temp_undo_action;
                    return TRUE;
				}
				menu_status = FALSE;
				addr->menu_attr.menu_drawn = FALSE;
				old_event.eventType = NULL_EVENT;
				temp_undo_action = undo_action;
				FormObjectRestoreFocus();
				undo_action = temp_undo_action;
				MenuRestoreBehindBits(menu_id);
				EvtAppendEvt(EVT_MENU_DESELECT, menu_id, 0, 0, (void*)addr);
				return TRUE;
            case PEN_MOVE:
				switch (old_event.eventType)
				{
                case EVT_MENU_ENTER:
					if (FormPointInObject(menu_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) != TRUE &&
						addr->menu_attr.menu_drawn)
					{
						addr->menu_highlighted_item = -1;
						EvtAppendEvt(EVT_MENU_EXIT, menu_id, 0, 0, (void*)addr);
					}
					else
					{
						if (addr->menu_highlighted_item != MenuSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)))
						{
							addr->menu_highlighted_item = MenuSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
							MenuDrawMenu(menu_id);
						}
					}
					return TRUE;
                case EVT_MENU_EXIT:
					if (FormPointInObject(menu_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
						addr->menu_attr.menu_drawn)
					{
						addr->menu_highlighted_item = MenuSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
						EvtAppendEvt(EVT_MENU_ENTER, menu_id, 0, 0, (void*)addr);
						
					}
					return TRUE;
                default: return FALSE;
				}
				default: return FALSE;
		}
		case EVT_MENU_ENTER:
			old_event = *Event;
			MenuDrawMenu(menu_id);
			return TRUE;
		case EVT_MENU_EXIT:
			old_event = *Event;
			addr->menu_highlighted_item = -1;
			MenuDrawMenu(menu_id);
			return TRUE;
		default: return FALSE;
    }
}
/********************************************************
* Function:	ListHandleEvent
* Purpose:		to handle the event that has occured in the list object
* Scope:		application/internal
* Input:       addr		Pointer to the list object that is
required to be handled
Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN ListHandleEvent(List *addr,EvtType *Event)
{
    void *ptr;
	EvtType new_event;
	BYTE object_type;
	ObjectID list_id;
    WORD i;
	
	list_id = addr->identification.ui_object_id;
	switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			if (old_event.eventType == EVT_LIST_ENTER)
			{
				switch (old_event.para1)
				{
				case 0:
					addr->list_selected_item		= ListSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
					addr->list_highlighted_item   = -1;
					//ListDrawList(list_id);
					ListHighlightOneItem (addr, addr->list_selected_item,  FALSE);
					EvtAppendEvt(EVT_LIST_SELECT, list_id, (WORD)(addr->list_selected_item), 0, (void*)addr);
					old_event.eventType = NULL_EVENT;
					if (addr->list_attr.list_synchronous == TRUE)
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = addr->list_highlighted_item;
							((List*)(ptr))->list_selected_item = addr->list_selected_item;
							//ListDrawList(addr->list_related_list_id[i]);
							ListHighlightOneItem ((List*)ptr, addr->list_selected_item,  FALSE);
						} 	
					}
					else
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = -1;
							((List*)(ptr))->list_selected_item = -1;
							ListHighlightOneItem ((List*)ptr, -1,  FALSE);
							//ListDrawList(addr->list_related_list_id[i]);
						}
					}
					FormObjectSetFocus(list_id);
					break;
				case ARROW_UP:
					ListSetScrollList(list_id,MOVE_UP);
					addr->list_attr.list_enter1 = FALSE;
					ListDrawList(list_id);
					if (addr->list_attr.list_synchronous == TRUE)
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = addr->list_highlighted_item;
							((List*)(ptr))->list_attr.list_enter1 = FALSE;
							ListSetScrollList(addr->list_related_list_id[i],MOVE_UP);
							ListDrawList(addr->list_related_list_id[i]);
						}
					}	
					EvtAppendEvt(EVT_LIST_ARROW, list_id, ARROW_UP, 0, (void*)addr);
					old_event.eventType = NULL_EVENT;
					break;
				case ARROW_DOWN:
					ListSetScrollList(addr->identification.ui_object_id,MOVE_DOWN);
					addr->list_attr.list_enter2 = FALSE;
					ListDrawList(list_id);
					if (addr->list_attr.list_synchronous == TRUE)
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = addr->list_highlighted_item;
							((List*)(ptr))->list_attr.list_enter1 = FALSE;
							ListSetScrollList(addr->list_related_list_id[i],MOVE_DOWN);
							ListDrawList(addr->list_related_list_id[i]);
						}
					}
					EvtAppendEvt(EVT_LIST_ARROW, list_id, ARROW_DOWN, 0, (void*)addr);
					old_event.eventType = NULL_EVENT;
					break;
				}
				return TRUE;
			}
			else if (old_event.eventType == EVT_LIST_EXIT)
			{
				switch (old_event.para1)
				{
				case 0:
					addr->list_highlighted_item = addr->list_selected_item = -1;
					//ListHighlightOneItem (addr, -1,  FALSE);
					//ListDrawList(list_id);
					if (addr->list_attr.list_synchronous == TRUE)
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = addr->list_highlighted_item;
							ListHighlightOneItem ((List*)ptr, -1,  FALSE);
							//ListDrawList(addr->list_related_list_id[i]);
						}
					}
					else
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = ((List*)(ptr))->list_selected_item;
							ListHighlightOneItem ((List*)ptr, ((List*)(ptr))->list_highlighted_item,  TRUE);
							//ListDrawList(addr->list_related_list_id[i]);
						}
					}
					FormObjectRestoreFocus();
					break;
				case ARROW_UP:
					addr->list_attr.list_enter1 = FALSE;
					ListDrawList(list_id);
					if (addr->list_attr.list_synchronous == TRUE)
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = addr->list_highlighted_item;
							((List*)(ptr))->list_attr.list_enter1 = FALSE;
							ListDrawList(addr->list_related_list_id[i]);
						}
					}
					FormObjectRestoreFocus();
					break;
				case 2:
					addr->list_attr.list_enter2 = FALSE;
					ListDrawList(list_id);
					if (addr->list_attr.list_synchronous == TRUE)
					{
						i = addr->list_num_related_list;
						while (i)
						{
							i--;
							UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
							((List*)(ptr))->list_highlighted_item = addr->list_highlighted_item;
							((List*)(ptr))->list_attr.list_enter2 = FALSE;
							ListDrawList(addr->list_related_list_id[i]);
						}
					}
					FormObjectRestoreFocus();
					break;
				}
				old_event.eventType = NULL_EVENT;
				return TRUE;
			}
			break;
			case PEN_DOWN:
				if (FormPointInObject(list_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE
					&& addr->list_attr.list_enable && addr->list_attr.list_drawn)
				{
					new_event.para1 = 0;
					new_event.para2 = 0;
					if (ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 1 ||
						ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 2)
					{
						new_event.para1 = (WORD)ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
						addr->list_highlighted_item = addr->list_selected_item;
						new_event.para2 = -1;
					}
					else
					{
						new_event.para2 = addr->list_highlighted_item;
						addr->list_highlighted_item =  ListSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
					}
					FormObjectReleaseFocus(LIST);
					EvtAppendEvt(EVT_LIST_ENTER, list_id, new_event.para1, new_event.para2, (void*)addr);
					return TRUE;
				}
				old_event.eventType = NULL_EVENT;
				return FALSE;
			case PEN_MOVE:
				switch (old_event.eventType)
				{
				case EVT_LIST_ENTER:
					if (FormPointInObject(addr->identification.ui_object_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) != TRUE)
					{
						new_event.para1 = 0;
						new_event.para2 = -1;
						if (old_event.para1 == 1 || old_event.para1 == 2)
							new_event.para1 = old_event.para1;
						else if (old_event.para1 == 0)
						{
							new_event.para2 = addr->list_highlighted_item;
							addr->list_highlighted_item = ListSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
						}
						EvtAppendEvt(EVT_LIST_EXIT, list_id, new_event.para1, new_event.para2, (void*)addr);
					}
					else
					{
						if (old_event.para1 == 1 && ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 1)
							EvtAppendEvt(EVT_LIST_EXIT, list_id, ARROW_UP, -1, (void*)addr);
						else if (old_event.para1 == 2 && ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 2)
							EvtAppendEvt(EVT_LIST_EXIT, list_id, ARROW_DOWN, -1, (void*)addr);
						else if (old_event.para1 == 0 && ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 0)
						{
							if (addr->list_highlighted_item != ListSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)))
							{
								ListHighlightOneItem (addr, addr->list_highlighted_item,  FALSE);
								addr->list_highlighted_item = ListSearchSelectedItem(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
								ListHighlightOneItem (addr, addr->list_highlighted_item,  TRUE);
								
								//ListDrawList(list_id);
								
								if (addr->list_attr.list_synchronous == TRUE)
								{
									i = addr->list_num_related_list;
									while (i)
									{
										i--;
										UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
										ListHighlightOneItem ((List*)ptr, ((List*)ptr)->list_highlighted_item,  FALSE);         
										((List*)(ptr))->list_highlighted_item = addr->list_highlighted_item;
										ListHighlightOneItem ((List*)ptr, ((List*)ptr)->list_highlighted_item,  TRUE);      
										//ListDrawList(addr->list_related_list_id[i]);
									}
								}
								else
								{
									i = addr->list_num_related_list;
									while (i)
									{
										i--;
										UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
										ListHighlightOneItem ((List*)ptr, ((List*)ptr)->list_highlighted_item,  FALSE);         
										((List*)(ptr))->list_highlighted_item = -1;
										//ListDrawList(addr->list_related_list_id[i]);
									}
								}
							}
						}
					}
					return TRUE;
				case EVT_LIST_EXIT:
					if (FormPointInObject(list_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE
						&& addr->list_attr.list_enable && addr->list_attr.list_drawn)
					{
						if (old_event.para1 == 1 && ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 1)
							return TRUE;
						else if (old_event.para1 == 2 && ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) != 2)
							return TRUE;
						else if (old_event.para1 == 0 && ListClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == 0)
							addr->list_highlighted_item = -1;
						EvtAppendEvt(EVT_LIST_ENTER, list_id, old_event.para1, -1, (void*)addr);
					}
					return TRUE;
				default:
					return TRUE;
				}
		 }
      case EVT_LIST_ENTER:
		  old_event = *Event;
		  if (Event->para1 == 1) addr->list_attr.list_enter1 = TRUE;
		  if (Event->para1 == 2) addr->list_attr.list_enter2 = TRUE;
		  //ListDrawList(list_id);
		  ListHighlightOneItem (addr, old_event.para2,  FALSE);      
		  ListHighlightOneItem (addr, addr->list_highlighted_item,  TRUE);       
		  if (addr->list_attr.list_synchronous == TRUE)
		  {
			  i = addr->list_num_related_list;
			  while (i)
			  {
				  i--;
				  UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
				  ((List*)(ptr))->list_highlighted_item = ((List*)(Event->evtPBP))->list_highlighted_item;
				  if (Event->para1 == 1) ((List*)(ptr))->list_attr.list_enter1 = TRUE;
				  if (Event->para1 == 2) ((List*)(ptr))->list_attr.list_enter2 = TRUE;
				  //ListDrawList(addr->list_related_list_id[i]);
				  ListHighlightOneItem ((List*)ptr, old_event.para2,  FALSE);         
				  ListHighlightOneItem ((List*)ptr, addr->list_highlighted_item,  TRUE);      
			  }
		  }
		  else
		  {
			  if (Event->para1 == 0)    
			  {
				  i = addr->list_num_related_list;
				  while (i)
				  {
					  i--;
					  UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
					  ListHighlightOneItem ((List*)ptr, ((List*)(ptr))->list_highlighted_item,  FALSE);        
					  ((List*)(ptr))->list_highlighted_item = -1;
				  }
			  }
		  }
		  return TRUE;
	  case EVT_LIST_EXIT:
		  old_event = *Event;
		  if (Event->para1 == ARROW_UP) addr->list_attr.list_enter1 = FALSE;
		  if (Event->para1 == ARROW_DOWN) addr->list_attr.list_enter2 = FALSE;
		  ListHighlightOneItem (addr, old_event.para2,  FALSE);      
		  if (addr->list_attr.list_synchronous == TRUE)
		  {
			  i = addr->list_num_related_list;
			  while (i)
			  {
				  i--;
				  UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
				  ((List*)(ptr))->list_highlighted_item = ((List*)(Event->evtPBP))->list_highlighted_item;
				  if (Event->para1 == 1) ((List*)(ptr))->list_attr.list_enter1 = FALSE;
				  if (Event->para1 == 2) ((List*)(ptr))->list_attr.list_enter2 = FALSE;
				  ListHighlightOneItem ((List*)ptr, old_event.para2,  FALSE);         
				  ListHighlightOneItem ((List*)ptr, addr->list_highlighted_item,  TRUE);      
			  }
		  }
		  else
		  {
			  if (Event->para1 == 0)
			  {
				  i = addr->list_num_related_list;
				  while (i)
				  {
					  i--;
					  UISearchForAddress((addr->list_related_list_id[i]),&object_type,&ptr);
					  ((List*)(ptr))->list_highlighted_item = -1;
					  ListHighlightOneItem ((List*)ptr, old_event.para2,  FALSE);         
				  }
			  }
		  }
		  return TRUE;
	  default: return FALSE;
	}
}

/********************************************************
* Function:	ScrollbarHandleEvent
* Purpose:		to handle the event that has occured in the scrollbar object
* Scope:		application/internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN ScrollbarHandleEvent(Scrollbar *addr,EvtType *Event)
{
    ObjectID scrollbar_id;
    WORD new_value;
	
    scrollbar_id = addr->identification.ui_object_id;
	
	switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			EvtAppendEvt(EVT_SCROLLBAR_SELECT, scrollbar_id, addr->scrollbar_value, addr->scrollbar_value, (void*)addr);
			arrow_delay = 0;
			pass_delay = 0;
			addr->scrollbar_repeat_count = 0;
			addr->scrollbar_attr.scrollbar_enter = FALSE;
			addr->scrollbar_attr.scrollbar_enter1 = FALSE;
			addr->scrollbar_attr.scrollbar_enter2 = FALSE;
			addr->scrollbar_old_value = addr->scrollbar_value;
			ScrollbarDrawScrollbar(scrollbar_id);
			return TRUE;
		case PEN_DOWN:
			if (FormPointInObject(scrollbar_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
				addr->scrollbar_attr.scrollbar_drawn && addr->scrollbar_attr.scrollbar_enable)
			{
				EvtAppendEvtReplace(EVT_SCROLLBAR_ENTER, scrollbar_id, Event->para1, Event->para2, (void*)addr);
                addr->scrollbar_save_pos_x = (SHORT)Event->para1;
                addr->scrollbar_save_pos_y = (SHORT)Event->para2;
                addr->scrollbar_old_value  = addr->scrollbar_value;
                arrow_delay = 0;
                pass_delay = 0;
                return TRUE;
			}
			old_event.eventType = NULL_EVENT;
			return FALSE;
		case PEN_MOVE:
			switch (old_event.eventType)
			{
			case EVT_SCROLLBAR_ARROW_DELAY:
				if (FormPointInObject(scrollbar_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
					addr->scrollbar_attr.scrollbar_drawn && addr->scrollbar_attr.scrollbar_enable)
				{                          	     
					if (arrow_delay == ARROW_DELAY)
					{
						pass_delay = 1;
						addr->scrollbar_repeat_count = 0;
						ScrollbarCalculateCurrentValue(addr->identification.ui_object_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
						
						if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
						{
							EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
							addr->scrollbar_old_value = new_value;
							old_event.eventType = NULL_EVENT;
						}
						else
						{
							old_event.eventType =   EVT_SCROLLBAR_REPEAT;
							old_event.eventID   =   scrollbar_id;
							old_event.para1     =   new_value;
							old_event.para2     =   new_value;
							old_event.evtPBP    =   (void*)addr;
						}
					}
					else  arrow_delay ++;
				}
				else
				{
					pass_delay = 0;
					arrow_delay = 0;
					EvtAppendEvt(EVT_SCROLLBAR_EXIT, scrollbar_id, 0, 0, (void*)addr);
					addr->scrollbar_attr.scrollbar_enter = FALSE;
					addr->scrollbar_attr.scrollbar_enter1 = FALSE;
					addr->scrollbar_attr.scrollbar_enter2 = FALSE;
					return TRUE;
				}
				return TRUE;
			case EVT_SCROLLBAR_EXIT:
				if (FormPointInObject(scrollbar_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE &&
					addr->scrollbar_attr.scrollbar_drawn && addr->scrollbar_attr.scrollbar_enable)
				{
					switch (ScrollbarGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)))
					{
					case SCROLL_UP_ARROW:
						if (addr->scrollbar_clicked_region == SCROLL_UP_ARROW)
						{
							arrow_delay = 0;
							pass_delay = 0;
							addr->scrollbar_repeat_count = 0;
							ScrollbarCalculateCurrentValue(scrollbar_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
							if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
							{
								EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
								addr->scrollbar_old_value = new_value;
							}
							else
							{
								old_event.eventType =   EVT_SCROLLBAR_REPEAT;
								old_event.eventID   =   scrollbar_id;
								old_event.para1     =   new_value;
								old_event.para2     =   new_value;
								old_event.evtPBP    =   (void*)addr;
							}
							addr->scrollbar_value = new_value;
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;		    
							addr->scrollbar_attr.scrollbar_enter1 = TRUE;
							addr->scrollbar_clicked_region = SCROLL_UP_ARROW;
						}
						return TRUE;
					case SCROLL_DOWN_ARROW:
						if (addr->scrollbar_clicked_region == SCROLL_DOWN_ARROW)
						{
							arrow_delay = 0;
							pass_delay = 0;
							addr->scrollbar_repeat_count = 0;
							ScrollbarCalculateCurrentValue(scrollbar_id, (SHORT)(Event->para1), (SHORT)(Event->para2), &new_value);
							if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
							{
								EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
								addr->scrollbar_old_value = new_value;
							}
							else
							{
								old_event.eventType =   EVT_SCROLLBAR_REPEAT;
								old_event.eventID   =   scrollbar_id;
								old_event.para1     =   new_value;
								old_event.para2     =   new_value;
								old_event.evtPBP    =   (void*)addr;
							}
							addr->scrollbar_value = new_value;
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;		    
							addr->scrollbar_attr.scrollbar_enter2 = TRUE;
							addr->scrollbar_clicked_region = SCROLL_DOWN_ARROW;
						}
						return TRUE;
					case SCROLLCAR_REGION:
						if (addr->scrollbar_clicked_region == SCROLLCAR_REGION)
						{
							arrow_delay = 0;
							pass_delay = 0;
							addr->scrollbar_repeat_count = 0;
							ScrollbarCalculateCurrentValue(scrollbar_id, (SHORT)(Event->para1), (SHORT)(Event->para2), &new_value);
							if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
							{
								EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
								addr->scrollbar_old_value = new_value;
							}
							else
							{
								old_event.eventType =   EVT_SCROLLBAR_REPEAT;
								old_event.eventID   =   scrollbar_id;
								old_event.para1     =   new_value;
								old_event.para2     =   new_value;
								old_event.evtPBP    =   (void*)addr;
							}
							addr->scrollbar_value = new_value;
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;		    
							addr->scrollbar_attr.scrollbar_enter = TRUE;
							addr->scrollbar_clicked_region = SCROLLCAR_REGION;
						}
						return TRUE;
					case SCROLLBAR_UP_REGION:	
						if (addr->scrollbar_clicked_region == SCROLLBAR_UP_REGION)
						{
							arrow_delay = 0;
							pass_delay = 0;
							addr->scrollbar_repeat_count = 0;
							ScrollbarCalculateCurrentValue(scrollbar_id, (SHORT)(Event->para1), (SHORT)(Event->para2), &new_value);
							if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
							{
								EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
								addr->scrollbar_old_value = new_value;
							}
							else
							{
								old_event.eventType =   EVT_SCROLLBAR_REPEAT;
								old_event.eventID   =   scrollbar_id;
								old_event.para1     =   new_value;
								old_event.para2     =   new_value;
								old_event.evtPBP    =   (void*)addr;
							}
							addr->scrollbar_value = new_value;
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;		    
							addr->scrollbar_clicked_region = SCROLLBAR_UP_REGION;
						}
						return TRUE;
					case SCROLLBAR_DOWN_REGION:	
						if (addr->scrollbar_clicked_region == SCROLLBAR_DOWN_REGION)
						{
							arrow_delay = 0;
                            pass_delay = 0;
                            addr->scrollbar_repeat_count = 0;
                            ScrollbarCalculateCurrentValue(scrollbar_id, (SHORT)(Event->para1), (SHORT)(Event->para2), &new_value);
							if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
							{
								EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
								addr->scrollbar_old_value = new_value;
							}
							else
							{
								old_event.eventType =   EVT_SCROLLBAR_REPEAT;
								old_event.eventID   =   scrollbar_id;
								old_event.para1     =   new_value;
								old_event.para2     =   new_value;
								old_event.evtPBP    =   (void*)addr;
							}
							addr->scrollbar_value = new_value;
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;		    
							addr->scrollbar_clicked_region = SCROLLBAR_DOWN_REGION;
						}
						return TRUE;
					default: return TRUE;
					}
				  }
				  return TRUE;
                case EVT_SCROLLBAR_REPEAT:
					if (FormPointInObject(scrollbar_id, (SHORT)(Event->para1), (SHORT)(Event->para2)) == TRUE &&
						addr->scrollbar_attr.scrollbar_drawn && addr->scrollbar_attr.scrollbar_enable)
					{
						switch (ScrollbarGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)))
						{
						case SCROLL_UP_ARROW:
							if (addr->scrollbar_clicked_region != SCROLL_UP_ARROW)
							{
								EvtAppendEvt(EVT_SCROLLBAR_EXIT, scrollbar_id, 0, 0, (void*)addr);
								addr->scrollbar_attr.scrollbar_enter = FALSE;
								addr->scrollbar_attr.scrollbar_enter1 = FALSE;
								addr->scrollbar_attr.scrollbar_enter2 = FALSE;
								return TRUE;
							}
							
							if (TOTAL_REPEAT_COUNT == addr->scrollbar_repeat_count && pass_delay == 1)
							{
								addr->scrollbar_repeat_count = 0;
								ScrollbarCalculateCurrentValue(addr->identification.ui_object_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
								
								if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
								{
									EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
									addr->scrollbar_old_value = new_value;
								}
								else
								{
									old_event.eventType =   EVT_SCROLLBAR_REPEAT;
									old_event.eventID   =   scrollbar_id;
									old_event.para1     =   new_value;
									old_event.para2     =   new_value;
									old_event.evtPBP    =   (void*)addr;
								}
								addr->scrollbar_value = new_value;
							}
							if (pass_delay == 0)
								EvtAppendEvtReplace(EVT_SCROLLBAR_ARROW_DELAY, scrollbar_id, 0, 0, (void*)addr);
							
							addr->scrollbar_repeat_count++;
							addr->scrollbar_attr.scrollbar_enter1 = TRUE;
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;
							addr->scrollbar_clicked_region = SCROLL_UP_ARROW;
							return TRUE;
						case SCROLL_DOWN_ARROW:
							if (addr->scrollbar_clicked_region != SCROLL_DOWN_ARROW)
							{
								EvtAppendEvt(EVT_SCROLLBAR_EXIT, scrollbar_id, 0, 0, (void*)addr);
								addr->scrollbar_attr.scrollbar_enter = FALSE;
								addr->scrollbar_attr.scrollbar_enter1 = FALSE;
								addr->scrollbar_attr.scrollbar_enter2 = FALSE;
								return TRUE;
							}		
							
							if (TOTAL_REPEAT_COUNT == addr->scrollbar_repeat_count && pass_delay == 1)
							{
								addr->scrollbar_repeat_count = 0;
								ScrollbarCalculateCurrentValue(scrollbar_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
								if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
								{
									EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
									addr->scrollbar_old_value = new_value;
								}
								else
								{
									old_event.eventType =   EVT_SCROLLBAR_REPEAT;
									old_event.eventID   =   scrollbar_id;
									old_event.para1     =   new_value;
									old_event.para2     =   new_value;
									old_event.evtPBP    =   (void*)addr;
								}
								addr->scrollbar_value = new_value;
								addr->scrollbar_attr.scrollbar_enter2 = TRUE;
							}
							if (pass_delay == 0)
								EvtAppendEvtReplace(EVT_SCROLLBAR_ARROW_DELAY, scrollbar_id, 0, 0, (void*)addr);
							addr->scrollbar_repeat_count++;
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;
							addr->scrollbar_clicked_region = SCROLL_DOWN_ARROW;
							return TRUE;
						case SCROLLCAR_REGION:
							if (addr->scrollbar_clicked_region != SCROLLCAR_REGION)
							{
								EvtAppendEvt(EVT_SCROLLBAR_EXIT, scrollbar_id, 0, 0, (void*)addr);
								addr->scrollbar_attr.scrollbar_enter = FALSE;
								addr->scrollbar_attr.scrollbar_enter1 = FALSE;
								addr->scrollbar_attr.scrollbar_enter2 = FALSE;
								return TRUE;
							}
							addr->scrollbar_repeat_count = 0;
							ScrollbarCalculateCurrentValue(addr->identification.ui_object_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
							if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
							{
								EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
								addr->scrollbar_old_value = new_value;
							}
							else
							{
								old_event.eventType =   EVT_SCROLLBAR_REPEAT;
								old_event.eventID   =   scrollbar_id;
								old_event.para1     =   new_value;
								old_event.para2     =   new_value;
								old_event.evtPBP    =   (void*)addr;
							}
							
							if (new_value != addr->scrollbar_value)
							{
								if (addr->scrollbar_style == VERTICAL)
								{
									addr->scrollbar_save_pos_x = (SHORT)Event->para1;
									addr->scrollbar_save_pos_y = addr->scrollbar_save_pos_y - ScrollbarGetCarStartCoord(addr, addr->scrollbar_value)
										+ ScrollbarGetCarStartCoord(addr, new_value);
								}
								else
								{
									addr->scrollbar_save_pos_x = addr->scrollbar_save_pos_x - ScrollbarGetCarStartCoord(addr, addr->scrollbar_value)
										+ ScrollbarGetCarStartCoord(addr, new_value);                                      
									addr->scrollbar_save_pos_y = (SHORT)Event->para2;
								}
							}
							
							addr->scrollbar_value = new_value;
							addr->scrollbar_attr.scrollbar_enter = TRUE;
							addr->scrollbar_clicked_region = SCROLLCAR_REGION;
							return TRUE;
						case SCROLLBAR_UP_REGION:
							if (addr->scrollbar_clicked_region == SCROLLCAR_REGION)
							{
								addr->scrollbar_repeat_count = 0;
								ScrollbarCalculateCurrentValue1(addr->identification.ui_object_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
								if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
								{
									EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
									addr->scrollbar_old_value = new_value;
									addr->scrollbar_save_pos_x = (SHORT)Event->para1;
									addr->scrollbar_save_pos_y = (SHORT)Event->para2;         
								}
								else
								{
									old_event.eventType =   EVT_SCROLLBAR_REPEAT;
									old_event.eventID   =   scrollbar_id;
									old_event.para1     =   new_value;
									old_event.para2     =   new_value;
									old_event.evtPBP    =   (void*)addr;
								}
								addr->scrollbar_value = new_value;
								addr->scrollbar_attr.scrollbar_enter = TRUE;                     
								addr->scrollbar_clicked_region = SCROLLCAR_REGION;
								return TRUE;
							}
							if (addr->scrollbar_clicked_region != SCROLLBAR_UP_REGION)
							{	
								EvtAppendEvt(EVT_SCROLLBAR_EXIT, scrollbar_id, 0, 0, (void*)addr);
								addr->scrollbar_attr.scrollbar_enter = FALSE;
								addr->scrollbar_attr.scrollbar_enter1 = FALSE;
								addr->scrollbar_attr.scrollbar_enter2 = FALSE;
								return TRUE;
							}
							// Changed //
							if (pass_delay == 1)
							{
								addr->scrollbar_repeat_count = 0;
								ScrollbarCalculateCurrentValue(addr->identification.ui_object_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
								if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
								{
									EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
									addr->scrollbar_old_value = new_value;
								}
								else
								{
									old_event.eventType =   EVT_SCROLLBAR_REPEAT;
									old_event.eventID   =   scrollbar_id;
									old_event.para1     =   new_value;
									old_event.para2     =   new_value;
									old_event.evtPBP    =   (void*)addr;
								}
							}
							if (pass_delay == 0)
								EvtAppendEvtReplace(EVT_SCROLLBAR_ARROW_DELAY, scrollbar_id, 0, 0, (void*)addr);
							
							if (pass_delay == 1)
							{
								addr->scrollbar_value = new_value;
								pass_delay = 0;
								arrow_delay = 0;
							}
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;
							addr->scrollbar_clicked_region = SCROLLBAR_UP_REGION;
							return TRUE;					
						case SCROLLBAR_DOWN_REGION:
							if (addr->scrollbar_clicked_region == SCROLLCAR_REGION)
							{
								addr->scrollbar_repeat_count = 0;
								ScrollbarCalculateCurrentValue1(addr->identification.ui_object_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
								if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
								{
									EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
									addr->scrollbar_old_value = new_value;
									addr->scrollbar_save_pos_x = (SHORT)Event->para1;
									addr->scrollbar_save_pos_y = (SHORT)Event->para2;         
								}
								else
								{
									old_event.eventType =   EVT_SCROLLBAR_REPEAT;
									old_event.eventID   =   scrollbar_id;
									old_event.para1     =   new_value;
									old_event.para2     =   new_value;
									old_event.evtPBP    =   (void*)addr;
								}
								addr->scrollbar_value = new_value;
								addr->scrollbar_attr.scrollbar_enter = TRUE;                     
								addr->scrollbar_clicked_region = SCROLLCAR_REGION;
								return TRUE;
							}
							
							if (addr->scrollbar_clicked_region != SCROLLBAR_DOWN_REGION)
							{
								EvtAppendEvt(EVT_SCROLLBAR_EXIT, scrollbar_id, 0, 0, (void*)addr);
								addr->scrollbar_attr.scrollbar_enter = FALSE;
								addr->scrollbar_attr.scrollbar_enter1 = FALSE;
								addr->scrollbar_attr.scrollbar_enter2 = FALSE;
								return TRUE;
							}					
							
							if (pass_delay == 1)
							{
								addr->scrollbar_repeat_count = 0;
								ScrollbarCalculateCurrentValue(addr->identification.ui_object_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
								if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
								{
									EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
									addr->scrollbar_old_value = new_value;
								}
								else
								{
									old_event.eventType =   EVT_SCROLLBAR_REPEAT;
									old_event.eventID   =   scrollbar_id;
									old_event.para1     =   new_value;
									old_event.para2     =   new_value;
									old_event.evtPBP    =   (void*)addr;
								}
							}
							
							if (pass_delay == 0)
								EvtAppendEvtReplace(EVT_SCROLLBAR_ARROW_DELAY, scrollbar_id, 0, 0, (void*)addr);
							
							if (pass_delay == 1)
							{
								addr->scrollbar_value = new_value;
								pass_delay = 0;
								arrow_delay = 0;
							}
							
							addr->scrollbar_save_pos_x = (SHORT)Event->para1;
							addr->scrollbar_save_pos_y = (SHORT)Event->para2;
							addr->scrollbar_clicked_region = SCROLLBAR_DOWN_REGION;
							return TRUE;					
						default: return FALSE;
				}
                  }
				  else
                  {
					  EvtAppendEvt(EVT_SCROLLBAR_EXIT, scrollbar_id, 0, 0, (void*)addr);
					  addr->scrollbar_attr.scrollbar_enter = FALSE;
					  addr->scrollbar_attr.scrollbar_enter1 = FALSE;
					  addr->scrollbar_attr.scrollbar_enter2 = FALSE;
					  return TRUE;
                  }
                default: return FALSE;
              }
            default: return FALSE;
         }
      case EVT_SCROLLBAR_ENTER:
		  old_event = *Event;
		  arrow_delay = 0;
		  pass_delay = 0;
		  addr->scrollbar_repeat_count = 0; 
		  ScrollbarCalculateCurrentValue(scrollbar_id, (SHORT)(Event->para1),(SHORT)(Event->para2), &new_value);
		  if (new_value != addr->scrollbar_old_value || addr->scrollbar_total_num_lines == 1)
		  {
			  EvtAppendEvtReplace(EVT_SCROLLBAR_REPEAT, scrollbar_id, addr->scrollbar_value, new_value, (void*)addr);
			  addr->scrollbar_old_value = new_value;
		  }
		  else
		  {
			  old_event.eventType =   EVT_SCROLLBAR_REPEAT;
			  old_event.eventID   =   scrollbar_id;
			  old_event.para1     =   new_value;
			  old_event.para2     =   new_value;
			  old_event.evtPBP    =   (void*)addr;
		  }
		  addr->scrollbar_value = new_value;
		  
		  if (ScrollbarGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == SCROLL_UP_ARROW)
			  addr->scrollbar_attr.scrollbar_enter1 = TRUE;
		  else if (ScrollbarGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == SCROLL_DOWN_ARROW)
			  addr->scrollbar_attr.scrollbar_enter2 = TRUE;
		  else if (ScrollbarGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)) == SCROLLCAR_REGION)
			  addr->scrollbar_attr.scrollbar_enter = TRUE;
		  addr->scrollbar_clicked_region = ScrollbarGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
		  return TRUE;                         
      case EVT_SCROLLBAR_EXIT:
		  old_event = *Event;
		  addr->scrollbar_repeat_count = 0;
		  addr->scrollbar_attr.scrollbar_enter = FALSE;
		  addr->scrollbar_attr.scrollbar_enter1 = FALSE;
		  addr->scrollbar_attr.scrollbar_enter2 = FALSE;
		  ScrollbarDrawScrollbar(scrollbar_id);
		  return TRUE;
      default: return FALSE;
    }
}
/********************************************************
* Function:	FieldHandleEvent
* Purpose:		to handle the event that has occured in the field object
* Scope:		application/internal
* Input:       addr		Pointer to the field object that is
required to be handled
Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN FieldHandleEvent(Field *addr,EvtType *Event)
{
	ObjectID 		field_id;
    ObjectBounds 	bounds;
    WORD 			char_pos,insert_pos;
    SHORT 			xcoord,ycoord, height;
    WORD 			row_num;
    WORD 			line_num, temp_line_num, num_chars;
	WORD 			max_num_lines_displayed;
	BYTE 			*text_pointer, *text_pointer1;
	WORD 			cut_start_char, cut_length, paste_size;
	BYTE 			data_type;
	BOOLEAN 		redraw = FALSE;
	
	
    field_id = addr->identification.ui_object_id;
    switch (Event->eventType)
	{
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			Event->para2 = Event->para2 & 0x000000FF;
			switch (Event->para2)
			{
			case KEY_UNDO:
				FieldUndo(field_id);			   
				//break;
				return TRUE;
			case KEY_HOME:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				LcdEnableInsertPt(FALSE,0,0,0);
				addr->field_highlight_length = 0;
				addr->field_attr.field_highlight = FALSE;  				
				EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				FieldGetDisplayRowNum (field_id, addr->field_insert_pt_y, &row_num);
				addr->field_insert_pt_char_pos = addr->field_lineinfo[addr->field_top_line_num + row_num].start;
				StrAnalyzeLine(addr);
				StrCharPosToXY(addr, addr->field_insert_pt_char_pos,
					&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_END:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0);
				addr->field_highlight_length = 0;
				addr->field_attr.field_highlight = FALSE;  				
				EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				StrGetInsertPtPos(addr, (bounds.xcoord + bounds.width - 1), addr->field_insert_pt_y,
					&(addr->field_insert_pt_char_pos),&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_PAGE_UP:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0);
				addr->field_highlight_length = 0;
				addr->field_attr.field_highlight = FALSE;  				
				EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				addr->field_top_line_num -= addr->field_num_lines_displayed;
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				if (addr->field_top_line_num < 0)
				{
					addr->field_top_line_num = 0;
					addr->field_insert_pt_y = bounds.ycoord + (SHORT)(addr->field_style);
					StrAnalyzeLine(addr);
					StrGetInsertPtPos(addr, addr->field_insert_pt_x, addr->field_insert_pt_y,
						&(addr->field_insert_pt_char_pos),&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				}
				else
				{
					StrAnalyzeLine(addr);
					StrGetInsertPtPos(addr, addr->field_insert_pt_x, addr->field_insert_pt_y,
						&(addr->field_insert_pt_char_pos),&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				} 
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_PAGE_DOWN:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0);
				addr->field_highlight_length = 0;
				addr->field_attr.field_highlight = FALSE;  				
				EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				addr->field_top_line_num += addr->field_num_lines_displayed;
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				if (addr->field_top_line_num > (addr->field_total_num_lines - addr->field_num_lines_displayed))
				{
					addr->field_top_line_num = (addr->field_total_num_lines - addr->field_num_lines_displayed);
					addr->field_insert_pt_y = bounds.ycoord + (SHORT)(addr->field_style) + (addr->field_num_lines_displayed - 1) * (FONT_HEIGHT[addr->field_font_id] + SPACE_LINE);
					StrAnalyzeLine(addr);
					StrGetInsertPtPos(addr, addr->field_insert_pt_x, addr->field_insert_pt_y,
						&(addr->field_insert_pt_char_pos),&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				}
				else
				{
					StrAnalyzeLine(addr);
					StrGetInsertPtPos(addr, addr->field_insert_pt_x, addr->field_insert_pt_y,
						&(addr->field_insert_pt_char_pos),&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				} 
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_UP:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0); 
				ycoord = addr->field_insert_pt_y;
				addr->field_attr.field_highlight = FALSE;
				addr->field_highlight_length = 0;
				FieldGetDisplayRowNum(field_id, ycoord, &row_num);
				if (row_num == 0 && addr->field_top_line_num !=0)
				{
					addr->field_insert_pt_movement = MOVE_UP;
					EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
					addr->field_top_line_num --;
					addr->field_insert_pt_y += (FONT_HEIGHT[addr->field_font_id] + SPACE_LINE);
				}
				else if (row_num != 0)
					addr->field_insert_pt_movement = MOVE_UP;
				else addr->field_insert_pt_movement = NO_MOVEMENT;
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_DOWN:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0); 
				ycoord = addr->field_insert_pt_y;	
				addr->field_highlight_length = 0;
				addr->field_attr.field_highlight = FALSE;
				FieldGetDisplayRowNum(field_id, ycoord, &row_num);
				if (row_num == (addr->field_num_lines_displayed - 1)
					&& (addr->field_top_line_num < (addr->field_total_num_lines
					- addr->field_num_lines_displayed)))
				{
					addr->field_insert_pt_movement = MOVE_DOWN;
					EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
					addr->field_top_line_num ++;  
					addr->field_insert_pt_y -= (FONT_HEIGHT[addr->field_font_id] + SPACE_LINE);
				}
				else if (row_num != (addr->field_num_lines_displayed - 1))
					addr->field_insert_pt_movement = MOVE_DOWN;
				else addr->field_insert_pt_movement = NO_MOVEMENT;
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_LEFT:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;					
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0);  
				addr->field_highlight_length = 0;
				addr->field_attr.field_highlight = FALSE;
				FieldGetFirstVisibleChar(field_id, &char_pos);
				if ((char_pos == addr->field_insert_pt_char_pos) &&
					(addr->field_top_line_num != 0))
				{
					addr->field_insert_pt_movement = MOVE_LEFT;
					EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
					addr->field_top_line_num --;
				}
				else if (char_pos < addr->field_insert_pt_char_pos)
					addr->field_insert_pt_movement = MOVE_LEFT;
				else addr->field_insert_pt_movement = NO_MOVEMENT;
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_RIGHT:
				if (addr->field_attr.field_highlight)
				{       		
					addr->field_attr.field_highlight = FALSE;
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;					
					addr->field_highlight_start_char = 0;
					addr->field_highlight_end_char = 0;					
					
					addr->field_attr.field_insert_pt_visible = TRUE;
					StrCharPosToXY(addr, addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));									
					if (addr->field_attr.field_drawn == TRUE)
						FieldDrawField(field_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0);	
				addr->field_attr.field_highlight = FALSE;
				addr->field_highlight_length = 0;
				
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				
				FieldGetLastVisibleChar(field_id, &char_pos);
				if ((char_pos <= addr->field_insert_pt_char_pos) &&
					(addr->field_top_line_num < (addr->field_total_num_lines -
                    addr->field_num_lines_displayed)))
				{
					addr->field_insert_pt_movement = MOVE_RIGHT;
					EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
					addr->field_top_line_num ++;
				}
				else if (char_pos > addr->field_insert_pt_char_pos)
					addr->field_insert_pt_movement = MOVE_RIGHT;
				else addr->field_insert_pt_movement = NO_MOVEMENT;
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_DEL:
				if (addr->field_attr.field_insert_pt_visible == FALSE &&
					addr->field_attr.field_highlight == FALSE)
					return TRUE;    
				
				LcdEnableInsertPt(FALSE,0,0,0);
				if (addr->field_attr.field_highlight == TRUE)
				{			 
					FieldCutBackspaceHighlightText(addr);
					StrAnalyzeLine(addr);
					if (addr->field_highlight_length <0)
						addr->field_insert_pt_char_pos = addr->field_highlight_end_char;		 
					else addr->field_insert_pt_char_pos = addr->field_highlight_start_char;
					FieldCharPosToLineNum (addr, addr->field_insert_pt_char_pos, &line_num);
					if (addr->field_top_line_num > line_num)	
						addr->field_top_line_num = line_num;
					StrAnalyzeLine(addr);
					StrCharPosToXY(addr,addr->field_insert_pt_char_pos,
						&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
					addr->field_highlight_start_char = addr->field_highlight_end_char;
				}
				else
				{
					if (addr->field_insert_pt_char_pos < addr->field_current_num_chars)
					{
						undo_action = UNDO_BACKSPACE;
						FieldStoreBackspaceChar(field_id, addr->field_string[addr->field_insert_pt_char_pos]);
						FieldDelete(field_id, addr->field_insert_pt_char_pos, 1);
					}
				}		   
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				max_num_lines_displayed = ((bounds.height - 2 * (SHORT)(addr->field_style))/(FONT_HEIGHT[addr->field_font_id] + SPACE_LINE));
				if (addr->field_num_lines_displayed < max_num_lines_displayed) 	
				{
					StrAnalyzeLine(addr);
					FieldCharPosToLineNum (addr, addr->field_insert_pt_char_pos, &line_num);
					line_num -= addr->field_top_line_num;
					row_num = min((max_num_lines_displayed - line_num - 1), (max_num_lines_displayed - addr->field_num_lines_displayed));
					addr->field_top_line_num -= row_num;
					if (addr->field_top_line_num < 0) addr->field_top_line_num = 0;
					StrAnalyzeLine(addr);
					StrCharPosToXY(addr,addr->field_insert_pt_char_pos,
						&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));			   
				}
				EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				EvtAppendEvt(EVT_FIELD_MODIFIED, field_id, 0, 0, (void*)addr);
				addr->field_attr.field_highlight = FALSE;
				addr->field_highlight_length = 0;
				addr->field_attr.field_insert_pt_visible = TRUE;
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				//               undo_action = UNDO_EMPTY; 
				addr->field_attr.field_dirty = TRUE;
				return TRUE;
			case KEY_CUT:
				if (!addr->field_attr.field_highlight)
				{
					StrCharPosToXY(addr,addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));			   
					LcdEnableInsertPt(TRUE, addr->field_insert_pt_x, addr->field_insert_pt_y, addr->field_font_id);
					addr->field_attr.field_insert_pt_visible = TRUE;
					return FALSE;	   
				}
				
				undo_action = UNDO_EMPTY;	
				if (undo_buffer.clipboard_type == CLIP_TEXT_DATA)
				{
					undo_buffer.clipboard_type = CLIP_EMPTY;
					undo_buffer.clipboard_size = 0;
					qfree(undo_buffer.clipboard_data);
				}
				
				cut_start_char = addr->field_highlight_start_char;
				cut_length = addr->field_highlight_length;
				if (addr->field_highlight_length < 0)
				{
					cut_start_char += addr->field_highlight_length;
                    cut_length = abs(cut_length);
				}
				
				if (cut_start_char < 0 || (cut_start_char >= (addr->field_current_num_chars + 1)) ||
					(cut_start_char + cut_length) >=  (addr->field_current_num_chars + 1))
				{
					if (addr->field_attr.field_insert_pt_visible)
					{		
						StrCharPosToXY(addr,addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));			   
						LcdEnableInsertPt(TRUE, addr->field_insert_pt_x, addr->field_insert_pt_y, addr->field_font_id);
						addr->field_attr.field_insert_pt_visible = TRUE;
					}                   		
					return TRUE;
				}                 	 	 			   
				
				FieldCut(field_id);
				
				StrAnalyzeLine(addr);
				if (addr->field_highlight_length <0)
					addr->field_insert_pt_char_pos = addr->field_highlight_end_char;		 
				else addr->field_insert_pt_char_pos = addr->field_highlight_start_char;
				
				FieldCharPosToLineNum (addr, addr->field_insert_pt_char_pos, &line_num);
				if (addr->field_top_line_num > line_num)
					addr->field_top_line_num = line_num;
				
				
				StrCharPosToXY(addr,addr->field_insert_pt_char_pos,
					&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				addr->field_highlight_start_char = addr->field_highlight_end_char;
				addr->field_highlight_length = 0;
				addr->field_attr.field_highlight = FALSE;
				addr->field_attr.field_insert_pt_visible = TRUE;
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				max_num_lines_displayed = ((bounds.height - 2 * (SHORT)(addr->field_style))/(FONT_HEIGHT[addr->field_font_id] + SPACE_LINE));
				if (addr->field_num_lines_displayed < max_num_lines_displayed) 	
				{
					StrAnalyzeLine(addr);
					FieldCharPosToLineNum (addr, addr->field_insert_pt_char_pos, &line_num);
					line_num -= addr->field_top_line_num;
					row_num = min((max_num_lines_displayed - line_num - 1), (max_num_lines_displayed - addr->field_num_lines_displayed));
					addr->field_top_line_num -= row_num;
					if (addr->field_top_line_num < 0) addr->field_top_line_num = 0;
					StrAnalyzeLine(addr);
					StrCharPosToXY(addr,addr->field_insert_pt_char_pos,
						&(addr->field_insert_pt_x), &(addr->field_insert_pt_y));			   
				}
				
				
				if (addr->field_attr.field_drawn == TRUE)
					FieldDrawField(field_id);
				EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				EvtAppendEvt(EVT_FIELD_MODIFIED, field_id, 0, 0, (void*)addr);
				addr->field_attr.field_dirty = TRUE;
				return TRUE;
			case KEY_COPY:
				if (addr->field_attr.field_highlight == FALSE) return TRUE;
				FieldCopy(field_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_PASTE:		             
				if (addr->field_attr.field_insert_pt_visible == FALSE &&
					addr->field_attr.field_highlight == FALSE)
					return TRUE;    
				
				text_pointer1 = (BYTE *) ClipboardGetItem(&data_type,&paste_size);
				
				if (text_pointer1 == NULL) return TRUE;
				if (data_type == CLIP_EMPTY) return TRUE;
				if (addr->field_attr.field_highlight == FALSE)
				{
					if ((paste_size + addr->field_current_num_chars) > addr->field_max_chars)
					{
						qfree(text_pointer1);
						addr->field_attr.field_insert_pt_visible = TRUE;
						LcdEnableInsertPt(TRUE, addr->field_insert_pt_x, addr->field_insert_pt_y, addr->field_font_id);
						return TRUE;
					}
				} 
				else
				{
					if ((paste_size + addr->field_current_num_chars - abs(addr->field_highlight_length)) > addr->field_max_chars)        
					{
						qfree(text_pointer1);
						return TRUE;
					}
				}		   
				undo_action = UNDO_EMPTY;	
				LcdEnableInsertPt(FALSE,0,0,0);	
				if (addr->field_attr.field_highlight == FALSE)	   
				{
					FieldInsert(field_id,&num_chars);
					addr->field_insert_pt_char_pos += num_chars;
					qfree(text_pointer1);
					if (undo_buffer.clipboard_type == CLIP_TEXT_DATA)
					{
						undo_buffer.clipboard_type = CLIP_EMPTY;
						undo_buffer.clipboard_size = 0;
						qfree(undo_buffer.clipboard_data);
					}                 
				}
				else
				{
					cut_start_char = addr->field_highlight_start_char;
					cut_length = addr->field_highlight_length;
					if (addr->field_highlight_length < 0)
					{
						cut_start_char += addr->field_highlight_length;
						cut_length = abs(cut_length);
					}
					
					if (cut_start_char < 0 || (cut_start_char >= (addr->field_current_num_chars + 1)) ||
						(cut_start_char + cut_length) >=  (addr->field_current_num_chars + 1))
					{
						qfree(text_pointer1);
						if (addr->field_attr.field_insert_pt_visible)
						{
							StrCharPosToXY(addr,addr->field_insert_pt_char_pos, &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));			   
							LcdEnableInsertPt(TRUE, addr->field_insert_pt_x, addr->field_insert_pt_y, addr->field_font_id);
							addr->field_attr.field_insert_pt_visible = TRUE;
						}                   		
						return TRUE;
					}                 	 	 
					
					text_pointer = (BYTE*)qmalloc((cut_length + 1)*sizeof(BYTE));
					StrExtract(addr->field_string,cut_start_char,cut_length,text_pointer);			 
					if (undo_buffer.clipboard_type == CLIP_TEXT_DATA)
					{
						undo_buffer.clipboard_type = CLIP_EMPTY;
						undo_buffer.clipboard_size = 0;
						qfree(undo_buffer.clipboard_data);
					}
					undo_buffer.clipboard_type = CLIP_TEXT_DATA;
					undo_buffer.clipboard_size = cut_length;
					undo_buffer.clipboard_data = (void*)text_pointer;
					
					FieldDelete(field_id, addr->field_highlight_start_char, addr->field_highlight_length);
					addr->field_insert_pt_char_pos = cut_start_char;
					FieldInsertFunction(addr,text_pointer1,paste_size);	
					addr->field_current_num_chars = strlen(addr->field_string);
					addr->field_insert_pt_char_pos +=paste_size;
					qfree(text_pointer1);
				}			   
				
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				
				StrAnalyzeLine(addr);
				
				
				FieldCharPosToLineNum (addr, addr->field_insert_pt_char_pos, &line_num);               	
				FieldGetMaxNumLinesDisplay(field_id, &max_num_lines_displayed);
				
				if (addr->field_total_num_lines < max_num_lines_displayed)
					addr->field_top_line_num = 0;
				else if (addr->field_top_line_num >= (addr->field_total_num_lines - max_num_lines_displayed))
                    addr->field_top_line_num = (addr->field_total_num_lines - max_num_lines_displayed);			        
				else if ((line_num < addr->field_top_line_num) && (addr->field_num_lines_displayed < max_num_lines_displayed))
					addr->field_top_line_num = line_num;
				else if (addr->field_num_lines_displayed < max_num_lines_displayed)
                    addr->field_top_line_num = line_num - max_num_lines_displayed;
				else if ((line_num >= (addr->field_top_line_num + max_num_lines_displayed)))
				{
					addr->field_top_line_num = line_num;
					if (addr->field_top_line_num > (addr->field_total_num_lines - max_num_lines_displayed))
						addr->field_top_line_num = addr->field_total_num_lines - max_num_lines_displayed;
				}	
				else if (line_num > (addr->field_total_num_lines - max_num_lines_displayed))
					addr->field_top_line_num = addr->field_total_num_lines - max_num_lines_displayed;
				
				
				
				
				StrAnalyzeLine(addr);
				
				StrCharPosToXY(addr, addr->field_insert_pt_char_pos,
					&(addr->field_insert_pt_x),
					&(addr->field_insert_pt_y));
				
				EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				EvtAppendEvt(EVT_FIELD_MODIFIED, field_id, 0, 0, (void*)addr);
				addr->field_highlight_start_char = addr->field_highlight_end_char;
				addr->field_highlight_length = 0;
				addr->field_attr.field_insert_pt_visible = TRUE;
				addr->field_attr.field_highlight = FALSE;
				if (addr->field_attr.field_drawn == TRUE)
				{
					FieldDrawField(field_id);
				}	           		
				addr->field_attr.field_dirty = TRUE;
				return TRUE;
           }
		   switch (Event->para1)
           {
		   case KEY_BACKSPACE:
			   if (addr->field_attr.field_highlight == TRUE)	
			   {	
				   //FieldCut(field_id);
				   FieldCutBackspaceHighlightText(addr);
				   if (addr->field_highlight_length <0)
					   addr->field_insert_pt_char_pos = addr->field_highlight_end_char;		 
				   else addr->field_insert_pt_char_pos = addr->field_highlight_start_char;
				   StrAnalyzeLine(addr);
				   FieldCharPosToLineNum (addr, addr->field_insert_pt_char_pos, &line_num);
				   temp_line_num = line_num;	
				   temp_line_num -= addr->field_top_line_num;
				   if (addr->identification.table_related == 0xFFFF)
					   bounds = addr->bounds;
				   else bounds = addr->screen_bounds;
				   
				   if (temp_line_num <0)
				   {
					   if (addr->field_top_line_num >= (-temp_line_num))
						   addr->field_top_line_num += temp_line_num;
					   else addr->field_top_line_num = 0;   	
				   }
				   if (temp_line_num >= 0 && addr->field_num_lines_displayed < ((bounds.height - 2 * (SHORT)(addr->field_style))/(FONT_HEIGHT[addr->field_font_id] + SPACE_LINE)))
				   {
					   addr->field_top_line_num -= ((bounds.height - 2 * (SHORT)(addr->field_style))/(FONT_HEIGHT[addr->field_font_id] + SPACE_LINE)) - addr->field_num_lines_displayed;
					   if (addr->field_top_line_num < 0) addr->field_top_line_num = 0;
				   }
				   if (temp_line_num > (addr->field_num_lines_displayed - 1))
				   {
					   addr->field_top_line_num += temp_line_num - (addr->field_num_lines_displayed - 1);	
					   if (addr->field_top_line_num > addr->field_total_num_lines - addr->field_num_lines_displayed)
						   addr->field_top_line_num = addr->field_total_num_lines - addr->field_num_lines_displayed;
				   }
				   StrAnalyzeLine(addr);
				   StrCharPosToXY(addr,addr->field_insert_pt_char_pos,
					   &(addr->field_insert_pt_x), &(addr->field_insert_pt_y));
				   addr->field_highlight_start_char = addr->field_highlight_end_char;
				   addr->field_highlight_length = 0;
				   addr->field_attr.field_highlight = FALSE;
				   addr->field_attr.field_insert_pt_visible = TRUE;
				   if (addr->field_attr.field_drawn == TRUE)
					   FieldDrawField(field_id);
				   EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				   EvtAppendEvt(EVT_FIELD_MODIFIED, field_id, 0, 0, (void*)addr);
				   addr->field_attr.field_dirty = TRUE;
				   return TRUE;
			   }
			   else
			   {
				   if (addr->field_attr.field_insert_pt_visible == FALSE) return TRUE;
				   if (addr->field_insert_pt_char_pos == 0) return TRUE;				 
				   undo_action = UNDO_BACKSPACE;
				   LcdEnableInsertPt(FALSE,0,0,0);
				   FieldGetFirstVisibleChar(field_id, &char_pos);
				   if (addr->field_insert_pt_char_pos == char_pos && addr->field_top_line_num >0)
					   addr->field_top_line_num--;
				   if (addr->identification.table_related == 0xFFFF)
					   height = addr->bounds.height - 2*(SHORT)(addr->field_style);
				   else height = addr->screen_bounds.height - 2*(SHORT)(addr->field_style);
				   /*				 
				   FieldStoreBackspaceChar(field_id, addr->field_string[addr->field_insert_pt_char_pos - 1]);
				   FieldDelete(field_id, (addr->field_insert_pt_char_pos - 1), 1);	
				   addr->field_insert_pt_char_pos --;
				   */
				   if(BackspaceFunction)
					   BackspaceFunction(field_id, FIELD, addr);
				   else
				   {
					   FieldStoreBackspaceChar(field_id, addr->field_string[addr->field_insert_pt_char_pos - 1]);
					   FieldDelete(field_id, (addr->field_insert_pt_char_pos - 1), 1);
					   addr->field_insert_pt_char_pos --;
				   }                 
				   EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
				   EvtAppendEvt(EVT_FIELD_MODIFIED, field_id, 0, 0, (void*)addr);
				   StrAnalyzeLine(addr);
				   FieldCharPosToLineNum (addr, addr->field_insert_pt_char_pos, &line_num);
				   temp_line_num = line_num;	
				   temp_line_num -= addr->field_top_line_num;
				   if (addr->identification.table_related == 0xFFFF)
					   bounds = addr->bounds;
				   else bounds = addr->screen_bounds;
				   if (temp_line_num <0)
				   {
					   if (addr->field_top_line_num >= (-temp_line_num))
						   addr->field_top_line_num += temp_line_num;
					   else addr->field_top_line_num = 0;   	
				   }
				   if (temp_line_num >= 0 && addr->field_num_lines_displayed < ((bounds.height - 2 * (SHORT)(addr->field_style))/(FONT_HEIGHT[addr->field_font_id] + SPACE_LINE)))
				   {
					   addr->field_top_line_num -= ((bounds.height - 2 * (SHORT)(addr->field_style))/(FONT_HEIGHT[addr->field_font_id] + SPACE_LINE)) - addr->field_num_lines_displayed;
					   if (addr->field_top_line_num < 0) addr->field_top_line_num = 0;
				   }
				   if (temp_line_num > (addr->field_num_lines_displayed - 1))
				   {
					   addr->field_top_line_num += temp_line_num - (addr->field_num_lines_displayed - 1);	
					   if (addr->field_top_line_num > addr->field_total_num_lines - addr->field_num_lines_displayed)
						   addr->field_top_line_num = addr->field_total_num_lines - addr->field_num_lines_displayed;
				   }
				   StrAnalyzeLine(addr);
				   StrCharPosToXY(addr, addr->field_insert_pt_char_pos,
					   &(addr->field_insert_pt_x),
					   &(addr->field_insert_pt_y));			 
				   FieldDrawField(field_id);
				   return TRUE;
			   }
             default:     
				 return FALSE;
			}	   
         }
         return FALSE;
	  case PEN_EVENT:
		  switch (Event->eventID)
		  {
		  case PEN_UP:
			  if (old_event.eventType == EVT_FIELD_ENTER)
              {
				  undo_action = UNDO_EMPTY;	
				  EvtAppendEvt(EVT_FIELD_SELECT, field_id, 0, 0, (void*)addr);
				  if (!addr->field_attr.field_highlight)
				  {
					  addr->field_attr.field_insert_pt_visible = TRUE;
					  LcdEnableInsertPt(TRUE,addr->field_insert_pt_x,addr->field_insert_pt_y, addr->field_font_id);
				  }
				  else
				  {
					  LcdEnableInsertPt(FALSE, 0, 0, addr->field_font_id);
					  addr->field_attr.field_insert_pt_visible = FALSE;
				  }
				  old_event.eventType = NULL_EVENT;
				  return TRUE;
              }
			  return FALSE;
		  case PEN_DOWN:
			  if (FormPointInObject(field_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE
                  && addr->field_attr.field_enable && addr->field_attr.field_drawn)
			  {
				  undo_action = UNDO_EMPTY;
				  LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
				  EvtAppendEvt(EVT_FIELD_ENTER, field_id, Event->para1, Event->para2, (void*)addr);
				  old_event.eventType = NULL_EVENT;
				  return TRUE;
				  
			  }
              old_event.eventType = NULL_EVENT;
			  return FALSE;
		  case PEN_MOVE:
			  if (old_event.eventType == EVT_FIELD_ENTER)
              {
#ifdef DEBUG_HIGH
				  printf("\n FIELDHANDLEEVENT - PEN_MOVE = %ld %ld", Event->para1, Event->para2);				
#endif				              	
				  undo_action = UNDO_EMPTY;	
				  
				  if (addr->identification.table_related !=0xFFFF)
					  bounds = addr->screen_bounds;
				  else bounds = addr->bounds;
				  
#ifdef DEBUG_HIGH
				  printf("\n FIELDHANDLEEVENT - Bounds = %ld %ld %ld %ld", bounds.xcoord, bounds.ycoord, bounds.width, bounds.height);				
#endif				              	
				  
				  
				  if (Event->para2 < bounds.ycoord || Event->para2 > (bounds.ycoord +  bounds.height - 1))
				  {              	
					  if (addr->field_repeat_count != FIELD_DRAG_REPEAT_COUNT)
					  {
						  addr->field_repeat_count ++;
						  redraw = FALSE;
						  return TRUE;
					  }
					  addr->field_repeat_count = 0;
					  if (addr->field_top_line_num != 0 && (Event->para2 <= bounds.ycoord))
					  {
#ifdef DEBUG_HIGH
						  printf("\n FIELDHANDLEEVENT TOP");				
#endif				              	
						  
						  addr->field_top_line_num --;
						  FieldGetFirstVisibleChar(field_id, &(addr->field_highlight_end_char));
						  EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
						  StrCharPosToXY(addr,(addr->field_highlight_end_char+1),&xcoord,&ycoord);
						  StrGetInsertPtPos(addr, xcoord, ycoord, &(addr->field_insert_pt_char_pos),
							  &(addr->field_insert_pt_x),
							  &(addr->field_insert_pt_y));
						  addr->field_insert_pt_char_pos = addr->field_highlight_end_char;                   
#ifdef DEBUG_HIGH
						  printf("\n FIELDHANDLEEVENT TOP %ld", addr->field_highlight_end_char);				
#endif				              	
						  
						  redraw = TRUE;
					  }
					  else if ((addr->field_top_line_num <= (addr->field_total_num_lines - addr->field_num_lines_displayed - 1))
						  && (Event->para2 >= (bounds.ycoord + bounds.height - 1)))
					  {
#ifdef DEBUG_HIGH
						  printf("\n FIELDHANDLEEVENT Bottom");				
#endif				              	
						  
						  addr->field_top_line_num ++;
						  StrAnalyzeLine(addr);
						  FieldGetLastVisibleChar(field_id, &(addr->field_highlight_end_char));
						  addr->field_highlight_end_char++;
						  if (addr->field_highlight_end_char >= addr->field_current_num_chars)
							  addr->field_highlight_end_char = addr->field_current_num_chars;
						  EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);
						  StrCharPosToXY(addr,(addr->field_highlight_end_char),&xcoord,&ycoord);
						  StrGetInsertPtPos(addr, xcoord, ycoord, &(addr->field_insert_pt_char_pos),
							  &(addr->field_insert_pt_x),
							  &(addr->field_insert_pt_y));
						  redraw = TRUE;
#ifdef DEBUG_HIGH
						  printf("\n FIELDHANDLEEVENT Bottom %ld", addr->field_highlight_end_char);				
#endif				              						
					  }
					  else
					  {
						  if (Event->para2 >= (bounds.ycoord + bounds.height - 1))
						  {						
							  redraw = FALSE;
							  FieldGetLastVisibleChar(field_id, &char_pos);                			
							  if (addr->field_highlight_end_char != addr->field_current_num_chars)
							  {
								  addr->field_highlight_end_char = addr->field_current_num_chars;
								  EvtAppendEvt(EVT_FIELD_CHANGED, field_id, 0, 0, (void*)addr);																							
								  StrCharPosToXY(addr,(addr->field_highlight_end_char),&xcoord,&ycoord);
								  StrGetInsertPtPos(addr, xcoord, ycoord, &(addr->field_insert_pt_char_pos),
									  &(addr->field_insert_pt_x),
									  &(addr->field_insert_pt_y));								
								  redraw = TRUE;
							  }						               				
						  }
					  }
				  }
				  else if (Event->para2 >= bounds.ycoord && Event->para2 <= (bounds.ycoord + bounds.height - 1))
				  {
#ifdef DEBUG_HIGH
					  printf("\n FIELDHANDLEEVENT - PEN_MOVE - Within Bounds");				
#endif				              	
					  
					  addr->field_repeat_count = 0;
					  StrGetInsertPtPos(addr,(SHORT)(Event->para1),(SHORT)(Event->para2),&insert_pos,&xcoord,&ycoord);
					  FieldSetInsertPointPositionByXY(field_id,xcoord, ycoord);
					  if (insert_pos >= addr->field_current_num_chars)
						  insert_pos = addr->field_current_num_chars;
					  if (insert_pos != addr->field_highlight_end_char)
						  redraw = TRUE;
					  else redraw = FALSE;
					  addr->field_highlight_end_char = insert_pos;
				  }
				  addr->field_highlight_length = addr->field_highlight_end_char - addr->field_highlight_start_char;
				  addr->field_attr.field_insert_pt_visible = FALSE;
				  if (addr->field_highlight_length == 0)
					  addr->field_attr.field_highlight = FALSE;
				  else
					  addr->field_attr.field_highlight = TRUE;
				  if (redraw == TRUE)
					  FieldDrawField2(field_id);
				  return TRUE;
              }
              return FALSE;
            default:
				return TRUE;
		 }
      case EVT_FIELD_ENTER:
		  old_event = *Event;
		  StrGetInsertPtPos(addr,(SHORT)(Event->para1),(SHORT)(Event->para2),&insert_pos,&xcoord,&ycoord);
		  FieldSetInsertPointPositionByXY(field_id,xcoord, ycoord);
		  addr->field_attr.field_insert_pt_visible = FALSE;
		  if (insert_pos >= addr->field_current_num_chars)
			  insert_pos = addr->field_current_num_chars;
		  addr->field_highlight_start_char = insert_pos;
		  addr->field_highlight_end_char = insert_pos;
		  if (addr->field_attr.field_highlight)
		  {
			  addr->field_attr.field_highlight = FALSE;
			  addr->field_highlight_length = 0;
			  FieldDrawField(field_id);
		  }
		  addr->field_repeat_count = 0;
		  FormObjectReleaseFocus(FIELD);
		  FormObjectSetFocus(field_id);
		  //FieldDrawField(field_id);	 
		  return TRUE;
	  default: return FALSE;
	}
}

/********************************************************
* Function:	KeyboardHandleEvent(EvtType *Event)
* Purpose:		to handle the event that has occured by keystroking
* Scope:		application/internal
* Input:		Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN KeyboardHandleEvent(EvtType *Event)
{
	UBYTE ascii;
	BOOLEAN cap,shift,intl;
	
	cap = keyboard.keyboard_attr.keyboard_cap;
	shift = keyboard.keyboard_attr.keyboard_shift;
	intl = keyboard.keyboard_attr.keyboard_international;
    switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			switch (old_event.eventType)
			{
			case EVT_KEYBOARD_ENTER:
				keyboard.keyboard_attr.keyboard_enter = FALSE;
				SndPlaySndEffect(SNDRES5_BEEP);
				switch(keyboard.keyboard_current_bitmap_index)
				{
				case 0:	/*bitmap_index = 0*/
					if (old_event.para1 == 1)	/* cap is pressed */
					{	
						keyboard.keyboard_attr.keyboard_cap = TRUE;
						KeyboardDrawKeyboardBitmap(2);
						KeyboardSendEvent(0,TRUE,FALSE,FALSE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						keyboard.keyboard_attr.keyboard_shift = TRUE;
						KeyboardDrawKeyboardBitmap(1);
						KeyboardSendEvent(0,FALSE,TRUE,FALSE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 3)
					{
						keyboard.keyboard_attr.keyboard_international = TRUE;
						KeyboardDrawKeyboardBitmap(5);
						KeyboardSendEvent(0,FALSE,FALSE,TRUE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else
					{
						KeyboardDrawInvertKey((UBYTE)(old_event.para1));
						KeyboardSendEvent((UBYTE)old_event.para1, FALSE, FALSE, FALSE);
					}
					break;
				case 1:	/*bitmap_index = 1*/
					if (old_event.para1 == 1)
					{	
						keyboard.keyboard_attr.keyboard_cap = TRUE;
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(2);
						KeyboardSendEvent(0,TRUE,FALSE,FALSE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(0);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 3)
					{
						keyboard.keyboard_attr.keyboard_international = TRUE;
						KeyboardDrawKeyboardBitmap(6);
						KeyboardSendEvent(0,FALSE,FALSE,TRUE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(0);
						KeyboardSendEvent((UBYTE)old_event.para1,FALSE,TRUE,FALSE);
					}
					break;
				case 2:	/*bitmap_index = 2*/
					if (old_event.para1 == 1)
					{	
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						keyboard.keyboard_attr.keyboard_cap = FALSE;
						KeyboardDrawKeyboardBitmap(0);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						keyboard.keyboard_attr.keyboard_shift = TRUE;
						KeyboardDrawKeyboardBitmap(3);
						KeyboardSendEvent(0,FALSE,TRUE,FALSE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 3)
					{
						keyboard.keyboard_attr.keyboard_international = TRUE;
						KeyboardDrawKeyboardBitmap(7);
						KeyboardSendEvent(0,FALSE,FALSE,TRUE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else
					{
						KeyboardSendEvent((UBYTE)(old_event.para1),TRUE,FALSE,FALSE);
						KeyboardDrawInvertKey((UBYTE)(old_event.para1));
					}
					break;
				case 3:
					if (old_event.para1 == 1)
					{	
						keyboard.keyboard_attr.keyboard_cap = FALSE;
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(0);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(2);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 3)
					{
						keyboard.keyboard_attr.keyboard_international = TRUE;
						KeyboardDrawKeyboardBitmap(8);
						KeyboardSendEvent(0,FALSE,FALSE,TRUE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else
					{
						KeyboardSendEvent((UBYTE)(old_event.para1),TRUE,TRUE,FALSE);
						KeyboardDrawKeyboardBitmap(2);
					}
					break;
				case 4:
					if (old_event.para1 == 2)
					{
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 3)
					{
						keyboard.keyboard_attr.keyboard_international = TRUE;
						KeyboardSendEvent(0,FALSE,FALSE,TRUE);
						if (keyboard.keyboard_attr.keyboard_cap == TRUE && 
							keyboard.keyboard_attr.keyboard_shift == TRUE)
							KeyboardDrawKeyboardBitmap(8);
						else if (keyboard.keyboard_attr.keyboard_shift == TRUE)
							KeyboardDrawKeyboardBitmap(6);
						else if (keyboard.keyboard_attr.keyboard_cap == TRUE)
							KeyboardDrawKeyboardBitmap(7);
						else KeyboardDrawKeyboardBitmap(5);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 6)
					{
						keyboard.keyboard_attr.keyboard_international = TRUE;
						KeyboardSendEvent(0,FALSE,FALSE,TRUE);
						if (keyboard.keyboard_attr.keyboard_cap == TRUE && 
							keyboard.keyboard_attr.keyboard_shift == TRUE)
							KeyboardDrawKeyboardBitmap(3);
						else if (keyboard.keyboard_attr.keyboard_shift == TRUE)
							KeyboardDrawKeyboardBitmap(1);
						else if (keyboard.keyboard_attr.keyboard_cap == TRUE)
							KeyboardDrawKeyboardBitmap(2);
						else KeyboardDrawKeyboardBitmap(0);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 7)
					{
						KeyboardDrawKeyboardBitmap(9);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else
					{
						KeyboardDrawInvertKey((UBYTE)(old_event.para1));
						KeyboardSendEvent((UBYTE)(old_event.para1),FALSE,FALSE,FALSE);
					}
					break;
				case 5:
					if (old_event.para1 == 1)
					{	
						keyboard.keyboard_attr.keyboard_cap = TRUE;
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardSendEvent(0,TRUE,FALSE,FALSE);
						KeyboardDrawKeyboardBitmap(7);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						keyboard.keyboard_attr.keyboard_shift = TRUE;
						KeyboardDrawKeyboardBitmap(6);
						KeyboardSendEvent(0,FALSE,TRUE,FALSE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 6)
					{
						KeyboardDrawKeyboardBitmap(0);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else
					{
						KeyboardDrawInvertKey((UBYTE)(old_event.para1));
						KeyboardSendEvent((UBYTE)(old_event.para1),FALSE,FALSE,FALSE);
					}
					break;
				case 6:
					if (old_event.para1 == 1)
					{	
						keyboard.keyboard_attr.keyboard_cap = TRUE;
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(7);
						KeyboardSendEvent(0,TRUE,FALSE,FALSE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(5);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 6)
					{
						KeyboardDrawKeyboardBitmap(1);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}						
					else
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(5);
						KeyboardSendEvent((UBYTE)(old_event.para1),FALSE,FALSE,FALSE);
					}
					break;
				case 7:
					if (old_event.para1 == 1)
					{	
						keyboard.keyboard_attr.keyboard_cap = FALSE;
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(5);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						keyboard.keyboard_attr.keyboard_shift = TRUE;
						KeyboardDrawKeyboardBitmap(8);
						KeyboardSendEvent(0,FALSE,TRUE,FALSE);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 6)
					{
						KeyboardDrawKeyboardBitmap(2);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}					
					else
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardSendEvent((UBYTE)(old_event.para1),FALSE,FALSE,FALSE);
						KeyboardDrawInvertKey((UBYTE)(old_event.para1));
					}
					break;
				case 8:
					if (old_event.para1 == 1)
					{	
						keyboard.keyboard_attr.keyboard_cap = FALSE;
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(5);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 2)
					{
						KeyboardDrawKeyboardBitmap(7);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 6)
					{
						KeyboardDrawKeyboardBitmap(3);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}					
					else
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardDrawKeyboardBitmap(7);
						KeyboardSendEvent((UBYTE)(old_event.para1),FALSE,FALSE,FALSE);
					}
					break;
				case 9:
					if (old_event.para1 == 3)
					{
						keyboard.keyboard_attr.keyboard_international = TRUE;
						KeyboardSendEvent(0,FALSE,FALSE,TRUE);
						if (keyboard.keyboard_attr.keyboard_cap == TRUE && 
							keyboard.keyboard_attr.keyboard_shift == TRUE)
							KeyboardDrawKeyboardBitmap(8);
						else if (keyboard.keyboard_attr.keyboard_shift == TRUE)
							KeyboardDrawKeyboardBitmap(6);
						else if (keyboard.keyboard_attr.keyboard_cap == TRUE)
							KeyboardDrawKeyboardBitmap(7);
						else KeyboardDrawKeyboardBitmap(5);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 5)
					{
						keyboard.keyboard_attr.keyboard_international = FALSE;
						KeyboardDrawKeyboardBitmap(4);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}
					else if (old_event.para1 == 6)
					{
						KeyboardDrawKeyboardBitmap(0);
						old_event.eventType = NULL_EVENT;
						return TRUE;
					}					
					else
					{
						keyboard.keyboard_attr.keyboard_shift = FALSE;
						KeyboardSendEvent((UBYTE)(old_event.para1),FALSE,FALSE,FALSE);
						KeyboardDrawInvertKey((UBYTE)(old_event.para1));
					}
					break;
					}
					old_event.eventType = NULL_EVENT;
					return TRUE;
                case EVT_KEYBOARD_EXIT:
					keyboard.keyboard_attr.keyboard_enter = FALSE;				
					keyboard.keyboard_highlight_key = 0;
					old_event.eventType = NULL_EVENT;
                    return TRUE;
                default:
					return FALSE;
              }
            case PEN_DOWN:
				if (keyboard_status != TRUE || keyboard.keyboard_attr.keyboard_drawn != TRUE
					|| menu_status == TRUE || popup_status == TRUE)
					return FALSE;
				if (keyboard_status != TRUE || keyboard.keyboard_attr.keyboard_drawn != TRUE) return FALSE;
				ascii = KeyboardGetClickedKey((SHORT)(Event->para1),(SHORT)(Event->para2));		
				if (ascii == 0)
					return FALSE;
				keyboard.keyboard_highlight_key = ascii;
				EvtAppendEvt(EVT_KEYBOARD_ENTER, 0, ascii, 0, NULL);
				return TRUE;
            case PEN_MOVE:
				switch (old_event.eventType)
				{
                case EVT_KEYBOARD_ENTER:
					if (KeyboardGetClickedKey((SHORT)Event->para1,(SHORT)Event->para2) != old_event.para1)
					{
						EvtAppendEvt(EVT_KEYBOARD_EXIT, 0, old_event.para1, 0, NULL);
						old_event.eventType = EVT_KEYBOARD_EXIT;
						old_event.eventID   = 0;
						old_event.para2     = 0;
						old_event.evtPBP    = NULL;
						return TRUE;
					}
					return TRUE;
                case EVT_KEYBOARD_EXIT:
					if (KeyboardGetClickedKey((SHORT)Event->para1,(SHORT)Event->para2) == old_event.para1)
					{	
						EvtAppendEvt(EVT_KEYBOARD_ENTER, 0, old_event.para1, 0, NULL);
						old_event.eventType = EVT_KEYBOARD_ENTER;
						old_event.eventID   = 0;
						old_event.para2     = 0;
						old_event.evtPBP    = NULL;
						return TRUE;
					}
					return TRUE;
                default: return FALSE;
				}
				default: return FALSE;
         }
      case EVT_KEYBOARD_ENTER:
		  old_event = *Event;
		  keyboard.keyboard_attr.keyboard_enter = TRUE;
		  KeyboardDrawInvertKey((UBYTE)(Event->para1));
		  return TRUE;
      case EVT_KEYBOARD_EXIT:
		  old_event = *Event;
		  keyboard.keyboard_attr.keyboard_enter = FALSE;
		  KeyboardDrawInvertKey((UBYTE)(Event->para1));
		  return TRUE;
      default: return FALSE;
    }
	return FALSE;
}
/********************************************************
* Function:	SchlineHandleEvent
* Purpose:		to handle the event that has occured in the schline object
* Scope:		application/internal
* Input:       addr		Pointer to the schline object that is
required to be handled
Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN SchlineHandleEvent(Schline *addr,EvtType *Event)
{
	ObjectID schline_id;
	
	schline_id = addr->identification.ui_object_id;
	
	switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			if (old_event.eventType == EVT_SCHLINE_ENTER)
			{
				EvtAppendEvt(EVT_SCHLINE_SELECT, schline_id, old_event.para1, 0, (void*)addr);
				addr->schline_highlight_region = -1;
				addr->schline_attr.schline_enter = FALSE;
				//SchlineDrawSchline(schline_id);
				FormObjectSetFocus(schline_id);
				old_event.eventType = NULL_EVENT;
				return TRUE;
			}
			else if (old_event.eventType == EVT_SCHLINE_EXIT)			  
			{
				old_event.eventType = NULL_EVENT;
				addr->schline_attr.schline_enter = FALSE;
				addr->schline_highlight_region = -1;
				//SchlineDrawSchline(schline_id);
				FormObjectRestoreFocus();
				return TRUE;
			}
			break;
		case PEN_DOWN:
			if (FormPointInObject(schline_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE
				&& addr->schline_attr.schline_enable && addr->schline_attr.schline_drawn)
			{
				addr->schline_highlight_region = SchlineGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2));
				FormObjectReleaseFocus(SCHLINE);
				EvtAppendEvt(EVT_SCHLINE_ENTER, schline_id, (WORD)SchlineGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)), 0, (void*)addr);
				return TRUE;
			}
			old_event.eventType = NULL_EVENT;
			return FALSE;
		case PEN_MOVE:
			switch (old_event.eventType)
			{
			case EVT_SCHLINE_ENTER:
				if (FormPointInObject(schline_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) != TRUE ||
					old_event.para1 != SchlineGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)))
					EvtAppendEvt(EVT_SCHLINE_EXIT, schline_id, old_event.para1, 0, (void*)addr);			
				return TRUE;
			case EVT_SCHLINE_EXIT:
				if (FormPointInObject(schline_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE
					&& addr->schline_attr.schline_enable && addr->schline_attr.schline_drawn &&
					old_event.para1 == SchlineGetClickedRegion(addr,(SHORT)(Event->para1),(SHORT)(Event->para2)))
					EvtAppendEvt(EVT_SCHLINE_ENTER, schline_id, old_event.para1, 0, (void*)addr);
				return TRUE;
			default:
				return TRUE;
			}
		}
		case EVT_SCHLINE_ENTER:
			old_event = *Event;
			addr->schline_attr.schline_enter = TRUE;
			//SchlineDrawSchline(schline_id);
			return TRUE;
		case EVT_SCHLINE_EXIT:
			old_event = *Event;
			addr->schline_attr.schline_enter = FALSE;
			//SchlineDrawSchline(schline_id);
			return TRUE;
		default: return FALSE;
	}
}
/********************************************************
* Function:	TextboxHandleEvent
* Purpose:		to handle the event that has occured in the textbox object
* Scope:		application/internal
* Input:       addr		Pointer to the textbox object that is
required to be handled
Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN TextboxHandleEvent(Textbox *addr,EvtType *Event)
{
	ObjectID textbox_id;
    ObjectBounds bounds;
    WORD insert_pos;
    SHORT xcoord,ycoord;
	BYTE *text_pointer, *text_pointer1;
	WORD num_chars;
	WORD cut_start_char, cut_length, paste_size;
	BYTE data_type;
	
    textbox_id = addr->identification.ui_object_id;
	
    switch (Event->eventType)
	{
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			Event->para2 = Event->para2 & 0x000000FF;
			switch (Event->para2)
			{
			case KEY_UNDO:
				TextboxUndo(textbox_id);
				//break;
				return TRUE;
			case KEY_HOME:
				if (addr->textbox_attr.textbox_highlight)
				{       		
					addr->textbox_attr.textbox_highlight = FALSE;
					addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;
					addr->textbox_highlight_start_char = 0;
					addr->textbox_highlight_end_char = 0;					
					
					addr->textbox_attr.textbox_insert_pt_visible = TRUE;					
					StrTextboxCharPosToXY(addr, addr->textbox_insert_pt_char_pos, &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));									
					if (addr->textbox_attr.textbox_drawn == TRUE)
						TextboxDrawTextbox(textbox_id);
					return TRUE; 
				}
				
				LcdEnableInsertPt(FALSE,0,0,0);
				addr->textbox_highlight_length = 0;
				addr->textbox_attr.textbox_highlight = FALSE;  				
				addr->textbox_left_char_pos = 0;
				addr->textbox_right_char_pos = -1;
				addr->textbox_insert_pt_char_pos = 0;
				StrTextboxAnalyze(addr);
				StrTextboxCharPosToXY(addr, addr->textbox_insert_pt_char_pos,
					&(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
				if (addr->textbox_attr.textbox_drawn == TRUE)
					TextboxDrawTextbox(textbox_id);
				EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_END:
				if (addr->textbox_attr.textbox_highlight)
				{       		
					addr->textbox_attr.textbox_highlight = FALSE;
					addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;
					addr->textbox_highlight_start_char = 0;
					addr->textbox_highlight_end_char = 0;					
					
					addr->textbox_attr.textbox_insert_pt_visible = TRUE;
					StrTextboxCharPosToXY(addr, addr->textbox_insert_pt_char_pos, &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));									
					if (addr->textbox_attr.textbox_drawn == TRUE)
						TextboxDrawTextbox(textbox_id);
					return TRUE; 
				}			 
				LcdEnableInsertPt(FALSE,0,0,0);
				addr->textbox_highlight_length = 0;
				addr->textbox_attr.textbox_highlight = FALSE;  				
				addr->textbox_right_char_pos = addr->textbox_current_num_chars - 1;
				addr->textbox_left_char_pos = -1;
				StrTextboxAnalyze(addr);
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				StrTextboxGetInsertPtPos(addr, (bounds.xcoord + bounds.width - 1), (bounds.ycoord + bounds.height - 1),
					&(addr->textbox_insert_pt_char_pos),&(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
				if (addr->textbox_attr.textbox_drawn == TRUE)
					TextboxDrawTextbox(textbox_id);
				EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_LEFT:
				if (addr->textbox_attr.textbox_highlight)
				{       		
					addr->textbox_attr.textbox_highlight = FALSE;
					addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;
					addr->textbox_highlight_start_char = 0;
					addr->textbox_highlight_end_char = 0;					
					
					addr->textbox_attr.textbox_insert_pt_visible = TRUE;
					StrTextboxCharPosToXY(addr, addr->textbox_insert_pt_char_pos, &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));									
					if (addr->textbox_attr.textbox_drawn == TRUE)
						TextboxDrawTextbox(textbox_id);
					return TRUE; 
				}             
				LcdEnableInsertPt(FALSE,0,0,0);  
				addr->textbox_highlight_length = 0;
				addr->textbox_attr.textbox_highlight = FALSE;              
				if ((addr->textbox_insert_pt_char_pos == addr->textbox_left_char_pos) &&
					(addr->textbox_left_char_pos != 0))
				{
					addr->textbox_insert_pt_movement = MOVE_LEFT;
					addr->textbox_left_char_pos --;
					addr->textbox_right_char_pos = -1;
					StrTextboxAnalyze(addr);
					EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
				}
				else if (addr->textbox_insert_pt_char_pos > addr->textbox_left_char_pos)
					addr->textbox_insert_pt_movement = MOVE_LEFT;
				else addr->textbox_insert_pt_movement = NO_MOVEMENT;
				if (addr->textbox_attr.textbox_drawn == TRUE)
					TextboxDrawTextbox(textbox_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_RIGHT:
				if (addr->textbox_attr.textbox_highlight)
				{       		
					addr->textbox_attr.textbox_highlight = FALSE;
					addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;					
					addr->textbox_highlight_start_char = 0;
					addr->textbox_highlight_end_char = 0;					
					
					addr->textbox_attr.textbox_insert_pt_visible = TRUE;
					StrTextboxCharPosToXY(addr, addr->textbox_insert_pt_char_pos, &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));									
					if (addr->textbox_attr.textbox_drawn == TRUE)
						TextboxDrawTextbox(textbox_id);
					return TRUE; 
				}             
				LcdEnableInsertPt(FALSE,0,0,0);	
				addr->textbox_attr.textbox_highlight = FALSE;
				addr->textbox_highlight_length = 0;
				
				if (addr->identification.table_related == 0xFFFF)
					bounds = addr->bounds;
				else bounds = addr->screen_bounds;
				
				if ((addr->textbox_right_char_pos == addr->textbox_insert_pt_char_pos) && 
					(addr->textbox_right_char_pos < addr->textbox_current_num_chars))
				{
					addr->textbox_insert_pt_movement = MOVE_RIGHT;
					addr->textbox_right_char_pos ++;
					addr->textbox_left_char_pos = -1;
					StrTextboxAnalyze(addr);
					EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
				}
				else if (addr->textbox_right_char_pos > addr->textbox_insert_pt_char_pos)
					addr->textbox_insert_pt_movement = MOVE_RIGHT;
				else if ((addr->textbox_right_char_pos < addr->textbox_insert_pt_char_pos) && 
					(addr->textbox_insert_pt_char_pos < addr->textbox_current_num_chars))
				{
					addr->textbox_insert_pt_movement = NO_MOVEMENT;
					addr->textbox_right_char_pos ++;
					addr->textbox_left_char_pos = -1;
					StrTextboxAnalyze(addr);
				}
				if (addr->textbox_attr.textbox_drawn == TRUE)
					TextboxDrawTextbox(textbox_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_DEL:
				if (addr->textbox_attr.textbox_insert_pt_visible == FALSE &&
					addr->textbox_attr.textbox_highlight == FALSE)
					return TRUE;                
				LcdEnableInsertPt(FALSE,0,0,0);
				if (addr->textbox_attr.textbox_highlight == TRUE)
				{			 
					TextboxCutBackspaceHighlightText(addr);
					if (addr->textbox_highlight_length <0)
						addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;		 
					else addr->textbox_insert_pt_char_pos = addr->textbox_highlight_start_char;
					addr->textbox_highlight_start_char = addr->textbox_highlight_end_char;
				}
				else
				{
					if (addr->textbox_insert_pt_char_pos <= addr->textbox_current_num_chars)		   
					{
						undo_action = UNDO_BACKSPACE;
						TextboxStoreBackspaceChar(textbox_id, addr->textbox_string[addr->textbox_insert_pt_char_pos]);
						TextboxDelete(textbox_id, addr->textbox_insert_pt_char_pos, 1);
					}
				}		   
				addr->textbox_right_char_pos = -1;
				StrTextboxAnalyze(addr);
				if (addr->textbox_insert_pt_char_pos < addr->textbox_left_char_pos )   
				{
					addr->textbox_left_char_pos = addr->textbox_insert_pt_char_pos;
					addr->textbox_right_char_pos = -1;
					StrTextboxAnalyze(addr);
				}
				else if (addr->textbox_insert_pt_char_pos > addr->textbox_right_char_pos)
				{
					addr->textbox_right_char_pos = addr->textbox_insert_pt_char_pos;
					addr->textbox_left_char_pos = -1;
					StrTextboxAnalyze(addr);
				}
				StrTextboxCharPosToXY(addr,addr->textbox_insert_pt_char_pos,
					&(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
				addr->textbox_attr.textbox_highlight = FALSE;
				addr->textbox_highlight_length = 0;
				addr->textbox_attr.textbox_insert_pt_visible = TRUE;
				if (addr->textbox_attr.textbox_drawn == TRUE)
					TextboxDrawTextbox(textbox_id);
				//               undo_action = UNDO_EMPTY; 
				addr->textbox_attr.textbox_dirty = TRUE;
				EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
				EvtAppendEvt(EVT_TEXTBOX_MODIFIED, textbox_id, 0, 0, (void*)addr);
				return TRUE;
			case KEY_CUT:
				if (!addr->textbox_attr.textbox_highlight)
				{
					StrTextboxCharPosToXY(addr, addr->textbox_insert_pt_char_pos, &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));             
					LcdEnableInsertPt(TRUE, addr->textbox_insert_pt_x, addr->textbox_insert_pt_y, addr->textbox_font_id);
					addr->textbox_attr.textbox_insert_pt_visible = TRUE;
					return FALSE;	   
				}
				
				undo_action = UNDO_EMPTY;	
				if (undo_buffer.clipboard_type == CLIP_TEXT_DATA)
				{
					undo_buffer.clipboard_type = CLIP_EMPTY;
					undo_buffer.clipboard_size = 0;
					qfree(undo_buffer.clipboard_data);
				}
				
				cut_start_char = addr->textbox_highlight_start_char;
				cut_length = addr->textbox_highlight_length;
				if (addr->textbox_highlight_length < 0)
				{
					cut_start_char += addr->textbox_highlight_length;
                    cut_length = abs(cut_length);
				}
				
				if (cut_start_char < 0 || (cut_start_char >= (addr->textbox_current_num_chars + 1)) ||
					(cut_start_char + cut_length) >=  (addr->textbox_current_num_chars + 1))
				{
					if (addr->textbox_attr.textbox_insert_pt_visible)
					{		
						StrTextboxCharPosToXY(addr, addr->textbox_insert_pt_char_pos, &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));			   
						LcdEnableInsertPt(TRUE, addr->textbox_insert_pt_x, addr->textbox_insert_pt_y, addr->textbox_font_id);
						addr->textbox_attr.textbox_insert_pt_visible = TRUE;
					}                   		
					return TRUE;
				}			   
				
				
				TextboxCut(textbox_id);
				StrTextboxAnalyze(addr);
				if (addr->textbox_highlight_length <0)
					addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;		 
				else addr->textbox_insert_pt_char_pos = addr->textbox_highlight_start_char;
				addr->textbox_right_char_pos = -1;
				StrTextboxAnalyze(addr);
				if (addr->textbox_insert_pt_char_pos < addr->textbox_left_char_pos )   
				{
					addr->textbox_left_char_pos = addr->textbox_insert_pt_char_pos;
					addr->textbox_right_char_pos = -1;
					StrTextboxAnalyze(addr);
				}
				else if (addr->textbox_insert_pt_char_pos > addr->textbox_right_char_pos)
				{
					addr->textbox_right_char_pos = addr->textbox_insert_pt_char_pos;
					addr->textbox_left_char_pos = -1;
					StrTextboxAnalyze(addr);
				}
				StrTextboxCharPosToXY(addr,addr->textbox_insert_pt_char_pos,
					&(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
				addr->textbox_highlight_start_char = addr->textbox_highlight_end_char;
				addr->textbox_highlight_length = 0;
				addr->textbox_attr.textbox_highlight = FALSE;
				addr->textbox_attr.textbox_insert_pt_visible = TRUE;
				if (addr->textbox_attr.textbox_drawn == TRUE)
					TextboxDrawTextbox(textbox_id);
				addr->textbox_attr.textbox_dirty = TRUE;
				EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
				EvtAppendEvt(EVT_TEXTBOX_MODIFIED, textbox_id, 0, 0, (void*)addr);
				return TRUE;
			case KEY_COPY:
				if (addr->textbox_attr.textbox_highlight == FALSE) return TRUE;
				TextboxCopy(textbox_id);
				undo_action = UNDO_EMPTY;	
				return TRUE;
			case KEY_PASTE:
				if (addr->textbox_attr.textbox_insert_pt_visible == FALSE &&
					addr->textbox_attr.textbox_highlight == FALSE)
					return TRUE;    
				
				text_pointer1 = (BYTE *) ClipboardGetItem(&data_type,&paste_size);
				if (text_pointer1 == NULL) return TRUE;
				if (data_type == CLIP_EMPTY) return TRUE;
				if (addr->textbox_attr.textbox_highlight == FALSE)
				{
					if ((paste_size + addr->textbox_current_num_chars) > addr->textbox_max_chars)
					{
						qfree(text_pointer1);
						addr->textbox_attr.textbox_insert_pt_visible = TRUE;
						LcdEnableInsertPt(TRUE, addr->textbox_insert_pt_x, addr->textbox_insert_pt_y, addr->textbox_font_id);
						return TRUE;
					}
				}      
				else
				{
					if ((paste_size + addr->textbox_current_num_chars - abs(addr->textbox_highlight_length)) > addr->textbox_max_chars)      
					{
						qfree(text_pointer1);
						return TRUE;
					}
				}
				undo_action = UNDO_EMPTY;	
				LcdEnableInsertPt(FALSE,0,0,0);	
				if (addr->textbox_attr.textbox_highlight == FALSE)	   
				{	 
					TextboxInsert(textbox_id,&num_chars);
					addr->textbox_insert_pt_char_pos += num_chars;
					qfree(text_pointer1);
					if (undo_buffer.clipboard_type == CLIP_TEXT_DATA)
					{
						undo_buffer.clipboard_type = CLIP_EMPTY;
						undo_buffer.clipboard_size = 0;
						qfree(undo_buffer.clipboard_data);
					}                 	
				}
				else
				{			
					cut_start_char = addr->textbox_highlight_start_char;
					cut_length = addr->textbox_highlight_length;
					if (addr->textbox_highlight_length < 0)
					{
						cut_start_char += addr->textbox_highlight_length;
						cut_length = abs(cut_length);
					}
					
					if (cut_start_char < 0 || (cut_start_char >= (addr->textbox_current_num_chars + 1)) ||
						(cut_start_char + cut_length) >=  (addr->textbox_current_num_chars + 1))
					{
						qfree(text_pointer1);
						if (addr->textbox_attr.textbox_insert_pt_visible)
						{		
							StrTextboxCharPosToXY(addr,addr->textbox_insert_pt_char_pos, &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));			   
							LcdEnableInsertPt(TRUE, addr->textbox_insert_pt_x, addr->textbox_insert_pt_y, addr->textbox_font_id);
							addr->textbox_attr.textbox_insert_pt_visible = TRUE;
						}                   		
						return TRUE;
					}
					
					text_pointer = (BYTE*)qmalloc((cut_length + 1)*sizeof(BYTE));
					StrExtract(addr->textbox_string,cut_start_char,cut_length,text_pointer);			 
					if (undo_buffer.clipboard_type == CLIP_TEXT_DATA)
					{
						undo_buffer.clipboard_type = CLIP_EMPTY;
						undo_buffer.clipboard_size = 0;
						qfree(undo_buffer.clipboard_data);
					}
					undo_buffer.clipboard_type = CLIP_TEXT_DATA;
					undo_buffer.clipboard_size = cut_length;
					undo_buffer.clipboard_data = (void*)text_pointer;
					TextboxDelete(textbox_id, addr->textbox_highlight_start_char, addr->textbox_highlight_length);
					addr->textbox_insert_pt_char_pos = cut_start_char;
					text_pointer1 = (BYTE *) ClipboardGetItem(&data_type,&paste_size);
					TextboxInsertFunction(addr,text_pointer1,paste_size);	
					addr->textbox_current_num_chars = strlen(addr->textbox_string);
					addr->textbox_insert_pt_char_pos +=paste_size;
					qfree(text_pointer1);
				}
				addr->textbox_right_char_pos = -1;
				StrTextboxAnalyze(addr);
				if (addr->textbox_insert_pt_char_pos < addr->textbox_left_char_pos )   
				{
					addr->textbox_left_char_pos = addr->textbox_insert_pt_char_pos;
					addr->textbox_right_char_pos = -1;
					StrTextboxAnalyze(addr);
				}
				else if (addr->textbox_insert_pt_char_pos > addr->textbox_right_char_pos)
				{
					addr->textbox_right_char_pos = addr->textbox_insert_pt_char_pos;
					addr->textbox_left_char_pos = -1;
					StrTextboxAnalyze(addr);
				}
				StrTextboxCharPosToXY(addr,addr->textbox_insert_pt_char_pos,
					&(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
				addr->textbox_highlight_start_char = addr->textbox_highlight_end_char;
				addr->textbox_highlight_length = 0;
				addr->textbox_attr.textbox_insert_pt_visible = TRUE;
				addr->textbox_attr.textbox_highlight = FALSE;
				if (addr->textbox_attr.textbox_drawn == TRUE)
					TextboxDrawTextbox(textbox_id);
				addr->textbox_attr.textbox_dirty = TRUE;
				EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
				EvtAppendEvt(EVT_TEXTBOX_MODIFIED, textbox_id, 0, 0, (void*)addr);
				return TRUE;
           }
		   switch (Event->para1)
           {
		   case KEY_BACKSPACE:
			   if (addr->textbox_attr.textbox_highlight == TRUE)	
			   {	
				   //                 TextboxCut(textbox_id);
				   TextboxCutBackspaceHighlightText(addr);
				   if (addr->textbox_highlight_length <0)
					   addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;		 
				   else addr->textbox_insert_pt_char_pos = addr->textbox_highlight_start_char;
				   addr->textbox_right_char_pos = -1;
				   StrTextboxAnalyze(addr);
				   if (addr->textbox_insert_pt_char_pos < addr->textbox_left_char_pos )   
				   {
					   addr->textbox_left_char_pos = addr->textbox_insert_pt_char_pos;
					   addr->textbox_right_char_pos = -1;
					   StrTextboxAnalyze(addr);
				   }
				   else if (addr->textbox_insert_pt_char_pos > addr->textbox_right_char_pos)
				   {
					   addr->textbox_right_char_pos = addr->textbox_insert_pt_char_pos;
					   addr->textbox_left_char_pos = -1;
					   StrTextboxAnalyze(addr);
				   }
				   StrTextboxCharPosToXY(addr,addr->textbox_insert_pt_char_pos,
					   &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
				   addr->textbox_highlight_start_char = addr->textbox_highlight_end_char;
				   addr->textbox_highlight_length = 0;
				   addr->textbox_attr.textbox_highlight = FALSE;
				   addr->textbox_attr.textbox_insert_pt_visible = TRUE;
				   addr->textbox_attr.textbox_dirty = TRUE;
			   }
			   else
			   {
				   if (addr->textbox_attr.textbox_insert_pt_visible == FALSE) return TRUE;
				   if (addr->textbox_insert_pt_char_pos == 0) return TRUE;
				   undo_action = UNDO_BACKSPACE;
				   LcdEnableInsertPt(FALSE,0,0,0);
				   /*				 
				   TextboxStoreBackspaceChar(textbox_id, addr->textbox_string[addr->textbox_insert_pt_char_pos - 1]);
				   TextboxDelete(textbox_id, (addr->textbox_insert_pt_char_pos - 1), 1);
				   addr->textbox_insert_pt_char_pos --;
				   */			   
				   if(BackspaceFunction != 0)
					   BackspaceFunction(textbox_id, TEXTBOX, addr);
				   else
				   {
					   TextboxStoreBackspaceChar(textbox_id, addr->textbox_string[addr->textbox_insert_pt_char_pos - 1]);
					   TextboxDelete(textbox_id, (addr->textbox_insert_pt_char_pos - 1), 1);
					   addr->textbox_insert_pt_char_pos --;
				   }
				   
				   addr->textbox_right_char_pos = -1;
				   StrTextboxAnalyze(addr);				 
				   
				   
				   if (addr->textbox_insert_pt_char_pos < addr->textbox_left_char_pos ||
					   ((addr->textbox_insert_pt_char_pos > addr->textbox_right_char_pos) &&
					   (addr->textbox_insert_pt_char_pos != addr->textbox_current_num_chars)))
				   { 
					   addr->textbox_left_char_pos = addr->textbox_insert_pt_char_pos;
					   addr->textbox_right_char_pos = -1;
					   StrTextboxAnalyze(addr);
				   }
				   StrTextboxCharPosToXY(addr,addr->textbox_insert_pt_char_pos,
					   &(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
			   }
               if (addr->textbox_attr.textbox_drawn == TRUE)
                   TextboxDrawTextbox(textbox_id);
			   EvtAppendEvt(EVT_TEXTBOX_CHANGED, textbox_id, 0, 0, (void*)addr);
			   EvtAppendEvt(EVT_TEXTBOX_MODIFIED, textbox_id, 0, 0, (void*)addr);
               return TRUE;
		   default:     
               return FALSE;
		   }	   
         }
         return FALSE;
	  case PEN_EVENT:
		  switch (Event->eventID)
		  {
		  case PEN_UP:
			  if (old_event.eventType == EVT_TEXTBOX_ENTER)
              {
				  undo_action = UNDO_EMPTY;	
				  EvtAppendEvt(EVT_TEXTBOX_SELECT, textbox_id, 0, 0, (void*)addr);
				  if (!addr->textbox_attr.textbox_highlight)
				  {
					  addr->textbox_attr.textbox_insert_pt_visible = TRUE;
					  LcdEnableInsertPt(TRUE,addr->textbox_insert_pt_x,addr->textbox_insert_pt_y, addr->textbox_font_id);
				  }
				  else
				  {
					  addr->textbox_attr.textbox_insert_pt_visible = FALSE;
					  LcdEnableInsertPt(FALSE, 0, 0, addr->textbox_font_id);
				  }
				  old_event.eventType = NULL_EVENT;
				  return TRUE;
              }
			  return FALSE;
		  case PEN_DOWN:
#ifdef DEBUG
			  printf("\n TEXTBOX HANDLE EVENT - PEN DOWN CHECKING");
#endif			  			
			  if (FormPointInObject(textbox_id,(SHORT)(Event->para1),(SHORT)(Event->para2)) == TRUE
                  && addr->textbox_attr.textbox_enable && addr->textbox_attr.textbox_drawn)
			  {
#ifdef DEBUG
				  printf("\n TEXTBOX HANDLE EVENT - Without Bounds ID = %ld", textbox_id);
#endif			  			
				  
				  undo_action = UNDO_EMPTY;
				  LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
				  EvtAppendEvt(EVT_TEXTBOX_ENTER, textbox_id, Event->para1, Event->para2, (void*)addr);
			  }
              old_event.eventType = NULL_EVENT;
			  return FALSE;
		  case PEN_MOVE:
			  if (old_event.eventType == EVT_TEXTBOX_ENTER)
              {
				  undo_action = UNDO_EMPTY;	
				  if (addr->identification.table_related !=0xFFFF)
					  bounds = addr->screen_bounds;
				  else bounds = addr->bounds;
				  if (Event->para1 < bounds.xcoord || Event->para1 > (bounds.xcoord +  bounds.width - 1))
				  {
					  if (addr->textbox_repeat_count != TEXTBOX_DRAG_REPEAT_COUNT)
					  {
						  addr->textbox_repeat_count ++;
						  return TRUE;
					  }
					  addr->textbox_repeat_count = 0;
					  if (addr->textbox_left_char_pos != 0 && (Event->para1 <= bounds.xcoord))
					  {
						  addr->textbox_left_char_pos --;
						  addr->textbox_right_char_pos = -1;
						  StrTextboxAnalyze(addr);
						  addr->textbox_highlight_end_char = addr->textbox_left_char_pos;
						  StrTextboxCharPosToXY(addr,(addr->textbox_highlight_end_char+1),&xcoord,&ycoord);
						  StrTextboxGetInsertPtPos(addr, xcoord, ycoord, &(addr->textbox_insert_pt_char_pos),
							  &(addr->textbox_insert_pt_x),
							  &(addr->textbox_insert_pt_y));
						  addr->textbox_insert_pt_char_pos = addr->textbox_highlight_end_char;                   
					  }
					  if ((addr->textbox_right_char_pos <= (addr->textbox_current_num_chars - 1))
						  && (Event->para1 >= (bounds.xcoord + bounds.width - 1)))
					  {
						  addr->textbox_right_char_pos ++;
						  addr->textbox_left_char_pos = -1;
						  StrTextboxAnalyze(addr);
						  addr->textbox_highlight_end_char = addr->textbox_right_char_pos;
						  addr->textbox_highlight_end_char++;
						  if (addr->textbox_highlight_end_char >= addr->textbox_current_num_chars)
							  addr->textbox_highlight_end_char = addr->textbox_current_num_chars;
						  StrTextboxCharPosToXY(addr,(addr->textbox_highlight_end_char),&xcoord,&ycoord);
						  StrTextboxGetInsertPtPos(addr, xcoord, ycoord, &(addr->textbox_insert_pt_char_pos),
							  &(addr->textbox_insert_pt_x),
							  &(addr->textbox_insert_pt_y));
					  }
				  }
				  if (Event->para1 >= bounds.xcoord && Event->para1 <= (bounds.xcoord + bounds.width - 1))
				  {
					  addr->textbox_repeat_count = 0;
					  StrTextboxGetInsertPtPos(addr,(SHORT)(Event->para1),(SHORT)(Event->para2),&insert_pos,&xcoord,&ycoord);
					  TextboxSetInsertPointPositionByXY(textbox_id,xcoord, ycoord);
					  if (insert_pos >= addr->textbox_current_num_chars)
						  insert_pos = addr->textbox_current_num_chars;
					  addr->textbox_highlight_end_char = insert_pos;
				  }
				  addr->textbox_highlight_length = addr->textbox_highlight_end_char
					  - addr->textbox_highlight_start_char;
				  addr->textbox_attr.textbox_insert_pt_visible = FALSE;
				  if (addr->textbox_highlight_length == 0)
					  addr->textbox_attr.textbox_highlight = FALSE;
				  else
					  addr->textbox_attr.textbox_highlight = TRUE;
				  TextboxDrawTextbox2(textbox_id);
				  return TRUE;
              }
              return FALSE;
		  default:
              return TRUE;
		 }
      case EVT_TEXTBOX_ENTER:
		  old_event = *Event;
		  StrTextboxGetInsertPtPos(addr,(SHORT)(Event->para1),(SHORT)(Event->para2),&insert_pos,&xcoord,&ycoord);
		  TextboxSetInsertPointPositionByXY(textbox_id,xcoord, ycoord);
		  addr->textbox_attr.textbox_insert_pt_visible = FALSE;
		  if (insert_pos >= addr->textbox_current_num_chars)
			  insert_pos = addr->textbox_current_num_chars;
		  addr->textbox_highlight_start_char = insert_pos;
		  addr->textbox_highlight_end_char = insert_pos;
		  if (addr->textbox_attr.textbox_highlight)
		  {
			  addr->textbox_attr.textbox_highlight = FALSE;
			  addr->textbox_highlight_length = 0;
			  TextboxDrawTextbox(textbox_id);
		  }                             
		  addr->textbox_repeat_count = 0;
		  FormObjectReleaseFocus(TEXTBOX);
		  FormObjectSetFocus(textbox_id);
		  if (addr->textbox_attr.textbox_insert_pt_visible)
			  LcdEnableInsertPt(TRUE,addr->textbox_insert_pt_x,addr->textbox_insert_pt_y, addr->textbox_font_id);
		  else LcdEnableInsertPt(FALSE, 0, 0, addr->textbox_font_id);                
		  return TRUE;
	  default: return FALSE;
	}
}





