/* cdppub.h                     CIC Proprietary
 *-----------------------------------------------------------------------------
 * SCCS Version 1.1, 17:27:53 3/5/96
 *-----------------------------------------------------------------------------
 * For cdplib.
 *
 * Erica H.     09/01/94        Init
 * J. Wang          27-Mar-95   Add field prompt_transUCAr[] in bw_gdstk(). 
 * David Hwang	07/18/95	Replaced BOOL with CIC_BOOL
 *-----------------------------------------------------------------------------
 */
#ifndef  CDPPUB_H
#define  CDPPUB_H

CDP_MARKING bw_gdstk 
    (
    COUNT     datafmt,		/* which data format it is		     */
    CIC_BOOL      pairwiseB,        /* YES if consecutive characters are allowed */
                                /*   to share a stroke                       */
    COUNT     totalstroke,	/* number of stroke marked		     */
    EDITORREC strokearray[],	/* stroke index into raw data		     */
    COUNT     totalchar,	/* number of chars marked		     */
    EDITORREC chararray[],	/* char index into raw data		     */
    COUNT     totalword,	/* total number of words per sentence	     */
    EDITORREC wordarray[],	/* word array for the words		     */
    COUNT     rawtotal,		/* total pen-down pts in raw data	     */
    COUNT     mrawx[],		/* Raw X-coordinates stroke (w/o pen-up)     */
    COUNT     mrawy[],		/* Raw Y-coordinates stroke (w/o pen-up)     */
    COUNT     rawsegpts[],	/* number of pen dwn for each seg.	     */
    COUNT     rawboxsegpts[],	/* number of pen dwn for each seg.(box)	     */
    COUNT     in_box_x_origin[],/* x origin of box assigned to stroke having */
                                /*   same index in rawboxsegpts array.       */
                                /*   Not used unless in box mode.            */
    COUNT     in_box_y_origin[],/* y origin of box assigned to stroke having */
                                /*   same index in rawboxsegpts array.       */
                                /*   Not used unless in box mode.            */
    COUNT     in_y_base[],      /* y-coord of baseline assigned to stroke    */
                                /*   having same index in rawsegpts array.   */
                                /*   Not used in box mode.                   */
    UTINY     in_promptS[],     /* Input prompt string without white spaces  */
    COUNT    *out_ncharsP,      /* total characters in processed data	     */
    COUNT     out_chrstk[],     /* number of strokes for each character	     */
    CDP_STK_STATUS
              out_stkflagAr[],  /* status of each stroke		     */ 
                                /*   Minimum array dimension is MAXSTROKE    */
    COUNT    *out_nsegsP,       /* total strokes in processed data	     */
    COUNT     out_segpts[],     /* number of pen dwn for each output stroke  */
    COUNT     out_x_origin[],   /* x origin of box assigned to stroke having */
                                /*   same index in output segpts array.      */
                                /*   Invalid unless in box mode.             */
    COUNT     out_y_origin[],   /* y baseline assigned to stroke having same */
                                /*   index in output segpts array. In box    */
                                /*   mode, this is the y-origin of the box.  */
    COUNT     outx[],		/* Output X-coordinates stroke (w/o pen-up)  */
    COUNT     outy[],		/* Output Y-coordinates stroke (w/o pen-up)  */
    UTINY     out_promptS[],    /* Processed prompt string 		     */
    CDP_CHAR_STATUS
              char_begins_wordAr[],
                                /* Marks whether each char begins a word     */
                                /*   Minimum array dimension is MAXCHARS.    */
    CDP_CONN_STATUS
              char_conn_statusAr[],
                                /* Connected status of each char.            */
    CIC_UINT8 prompt_transUCAr[]
				/* Prompt transformation info.		     */
    );

CIC_BOOL cdp_boxchar
    (
    COUNT   nthchar,		/* the nth char in the chararray	*/
    COUNT   datafmt,      	/* which data format it is              */
    COUNT   totalstroke,  	/* number of stroke marked              */
    EDITORREC strokearray[], 	/* stroke index into raw data         	*/
    COUNT   totalchar, 		/* number of chars marked               */
    EDITORREC chararray[],     	/* char index into raw data           	*/
    COUNT   rawtotal,     	/* total pen-down pts in raw data       */
    COUNT   mrawx[],		/* Raw X-coordinates stroke (w/o pen-up)*/
    COUNT   mrawy[],		/* Raw Y-coordinates stroke (w/o pen-up)*/
    COUNT   rawsegpts[],  	/* number of pen dwn for each seg.      */
    COUNT   rawboxsegpts[], 	/* number of pen dwn for each seg.(box) */
    COUNT   *rawtotal_charP,	/* total pen-down pts in raw data       */
    COUNT   *nstroke_charP,	/* number of strokes within nth char	*/
    COUNT   rawsegindex_char[],	/* number of pen dwn for each seg.      */
    COUNT   mrawx_char[],	/* raw X-coordinates stroke (w/o pen-up)*/
    COUNT   mrawy_char[],	/* raw Y-coordinates stroke (w/o pen-up)*/
    COUNT   mboxx[],            /* Box origin's x-coordinate            */
    COUNT   mboxy[],            /* Box origin's y-coordinate            */
    COUNT   *boxxP,		/* box x origin for the char of interest*/ 
    COUNT   *boxyP		/* box y origin for the char of interest*/ 
    );

VOID cdp_charstore
    (
    UTINY promptS[],		/* cdp sentence prompt			*/
    COUNT totalchar,		/* total number in the chararray	*/
    EDITORREC chararray[],	/* cdp character array			*/
    UTINY charlistS[]		/* returned character list 		*/
    );

CIC_BOOL cdp_getchar
    (
    COUNT   nthchar,		/* the nth char in the chararray	*/
    COUNT   datafmt,      	/* which data format it is              */
    COUNT   totalstroke,  	/* number of stroke marked              */
    EDITORREC strokearray[], 	/* stroke index into raw data         	*/
    COUNT   totalchar, 		/* number of chars marked               */
    EDITORREC chararray[],     	/* char index into raw data           	*/
    COUNT   rawtotal,     	/* total pen-down pts in raw data       */
    COUNT   mrawx[],		/* Raw X-coordinates stroke (w/o pen-up)*/
    COUNT   mrawy[],		/* Raw Y-coordinates stroke (w/o pen-up)*/
    COUNT   rawsegpts[],  	/* number of pen dwn for each seg.      */
    COUNT   rawboxsegpts[], 	/* number of pen dwn for each seg.(box) */
    COUNT   *rawtotal_charP,	/* total pen-down pts in raw data       */
    COUNT   *nstroke_charP,	/* number of strokes within nth char	*/
    COUNT   rawsegindex_char[],	/* number of pen dwn for each seg.      */
    COUNT   mrawx_char[],	/* raw X-coordinates stroke (w/o pen-up)*/
    COUNT   mrawy_char[]	/* raw Y-coordinates stroke (w/o pen-up)*/
    );

VOID cdp_getword 
    (
    COUNT   nthword,		/* the nth word in the wordarray	*/
    COUNT   totalstroke, 	/* number of stroke marked              */
    EDITORREC strokearray[], 	/* stroke index into raw data         	*/
    COUNT   totalword, 		/* number of words marked               */
    EDITORREC wordarray[],     	/* word index into raw data           	*/
    COUNT   rawtotal,     	/* total pen-down pts in raw data       */
    COUNT   mrawx[],		/* Raw X-coordinates stroke (w/o pen-up)*/
    COUNT   mrawy[],		/* Raw Y-coordinates stroke (w/o pen-up)*/
    COUNT   rawsegpts[],  	/* number of pen dwn for each seg.      */
    COUNT   *rawtotal_wordP,	/* total pen-down pts in raw data       */
    COUNT   *nstroke_wordP,	/* number of strokes within nth word	*/
    COUNT   rawsegindex_word[],	/* number of pen dwn seg.		*/
    COUNT   mrawx_word[],	/* raw X-coordinates stroke (w/o pen-up)*/
    COUNT   mrawy_word[]	/* raw Y-coordinates stroke (w/o pen-up)*/
    );

CIC_BOOL cdp_header
    (
    FILE  *cdpdatafP,
    CIC_TEXT  *filnamSP,		/* Filename of the Data			     */
    CIC_TEXT  *placeSP,		/* Where the data collection took place	     */
    UTINY placeC,		/* Numeric constant representing the place   */
    UTINY tabletC,		/* Tablet used for data collection	     */
    UTINY rateC,		/* Sampling rate, 0=slow, 1=fast	     */
    UTINY sparouC,		/* 0 = 254 lines/inch, 1 = 1016 lines/inch   */
    UTINY entmodC,		/* Entry mode, 0=sequential, 1=random	     */
    UTINY subtypC,		/* Subj type: single, word, phrase, sentence */
    UTINY dattypC,		/* Data type: 0=subject, 1=variation	     */
    UTINY boxmodC,		/* 0=line mode, 1=box mode		     */
    CIC_TEXT  *profSP,		/* Profession of operator		     */
    CIC_TEXT  *natlySP,		/* Nationality of operator                   */
    CIC_TEXT  *scholSP,		/* State/Region high school went to 	     */
    CIC_TEXT  *gendrSP,		/* Gender of operator			     */
    UTINY handC,		/* 0 = Left hander, 1 = Right hander	     */
    UTINY writeC,		/* Cursive/Printing write style		     */
    COUNT pmtuse,		/* The # of pmts to be used in a session     */
    CIC_TEXT  dateS[],
    CIC_TEXT  timeS[]
    );

VOID cdp_header_if
    (
    FILE  *cdpinfofP,
    UTINY *tabletCP,		/* Tablet used for data collection	     */
    UTINY *subtypCP,		/* Single/Word/Phrase/Sentence		     */
    UTINY *boxmodCP,		/* 0 = Line mode, 1 = Box mode		     */
    COUNT *pmtuseP,		/* The # of prompts used		     */
    UTINY *handCP,		/* 0 = Left hander, 1 = Right hander	     */
    UTINY *writeCP,		/* Cursive/Printing write style		     */
    UTINY *placeCP,		/* Known place where data collection happen  */
    UTINY *rateCP,		/* 0 = 100 pts/sec, 1 = 200 pts/sec	     */
    UTINY *sparouCP,		/* 0 = 254 lines/inch, 1 = 1016 lines/inch   */
    UTINY *entmodCP,		/* Sequentail/Randon			     */
    UTINY *dattypCP,		/* Subject/Variation			     */
    UTINY *lenCP,		/* Length of the place string 		     */
    UTINY *lenpCP,
    UTINY *lennCP,
    UTINY *lensCP,		/* length of schooling string                */
    UTINY *lengCP,
    char  filnamS[],    	/* Filename for opening the data file	     */
    char  placeS[],	        /* Where data collection took place	     */
    char  sessionS[],   	/* Session in char string		     */
    char  dateS[],
    char  timeS[],
    char  profS[],		/* Profession of operator		     */
    char  natlyS[],		/* Nationality of operator                   */
    char  scholS[],	/* State/Region high school went to 	     */
    char  gendrS[]		/* Gender of operator			     */
    );

CIC_BOOL cdp_prolog
    (
    FILE  *incdpdatafP,
    UTINY *tabletCP,	/* Tablet used for data collection	     */
    UTINY *subtypCP,		/* Single/Word/Phrase/Sentence		     */
    UTINY *boxmodCP,		/* 0 = Line mode, 1 = Box mode		     */
    COUNT *pmtuseP,		/* The # of prompts used		     */
    UTINY *handCP,		/* 0 = Left hander, 1 = Right hander	     */
    UTINY *writeCP,		/* Cursive/Printing write style		     */
    UTINY *placeCP,		/* Known place where data collection happen  */
    UTINY *rateCP,		/* 0 = 100 pts/sec, 1 = 200 pts/sec	     */
    UTINY *sparouCP,		/* 0 = 254 lines/inch, 1 = 1016 lines/inch   */
    UTINY *entmodCP,		/* Sequentail/Randon			     */
    UTINY *dattypCP,		/* Subject/Variation			     */
    UTINY *lenCP,		/* Length of the place string 		     */
    UTINY *lenpCP,
    UTINY *lennCP,
    UTINY *lensCP,	/* length of schooling string                */
    UTINY *lengCP,
    char  filnamS[],   	/* Filename for opening the data file	     */
    char  placeS[],	        /* Where data collection took place	     */
    char  sessionS[],   	/* Session in char string		     */
    char  dateS[],
    char  timeS[],
    char  profS[],	/* Profession of operator		     */
    char  natlyS[],		/* Nationality of operator                   */
    char  scholS[],		/* State/Region high school went to 	     */
    char  gendrS[]		/* Gender of operator			     */
    );

CIC_BOOL cdp_samp_time
    (
    FILE  *cdpdatafP,		/* file pointer for the cdp data	*/
    COUNT datafmt,		/* data formats of the cdp data		*/
    COUNT totalstroke,		/* total number of strokes per sentence */
    EDITORREC strokearray[],	/* stroke array for the strokes		*/
    COUNT totalchar,		/* total number of characters per sent	*/
    EDITORREC chararray[],	/* char array for the characters	*/
    COUNT totalword,		/* total number of words per sentence   */
    EDITORREC wordarray[],	/* word array for the words		*/
    COUNT rawtotal,		/* total number of raw data points	*/
    COUNT mrawx[],		/* raw x point for cdp data (no pen-up) */
    COUNT mrawy[],		/* raw y point for cdp data (no pen-up) */
    UTINY boxmodC,		/* mode of cdp data - box or line	*/
    UTINY statusC,		/* status of cdp data 			*/
    COUNT len,			/* length of the prompt			*/
    COUNT idxpmt,		/* index for the prompt			*/
    CIC_TEXT  promptS[],		/* cdp prompt itself			*/
    CIC_TEXT  dateS[],		/* date for the cdp data		*/
    CIC_TEXT  timeS[], 		/* time for the cdp data		*/
    COUNT spacng,		/* y (vertical) spacing between lines  	*/
    COUNT nseg,			/* number of segs(strokes) in line mode */
    COUNT rawsegpts[],		/* number of points for the strokes     */
    COUNT segy[],		/* y base lines for the strokes		*/
    COUNT nbox,			/* number of boxes in box mode		*/
    COUNT nboxseg,		/* number of segsZ(strokes) per box     */
    COUNT rawboxsegpts[],	/* number of points for the stroke      */
    COUNT bxhgt,		/* vertical distance between boxes	*/
    COUNT bxwdth,		/* horizontal distance between boxes	*/
    COUNT mboxx[],		/* x position for the box		*/
    COUNT mboxy[],		/* y position for the box		*/
    CIC_ULONG  *bytectP,	/* pointer for number of bytes gateher  */
    CIC_BOOL  trackinfoB,		/* add tracking info yes/no		*/
    CIC_TEXT  filenameS[],		/* filename of where sent came from	*/
    COUNT sentindex,		/* sentence index in the cdp data file 	*/
    COUNT charindex, 		/* char index in the sentence cdp data  */
    UTINY write_trakC,		/* cursive or print style		*/
    UTINY tablet_trakC,		/* tablet used				*/
    UTINY subtyp_trakC,		/* type of sentence in cdp data 	*/
    COUNT timebeg[],		/* time beg array for time marker       */
    COUNT timeend[]		/* time end array for time marker       */
    );

CIC_BOOL cdp_sample
    (
    FILE  *cdpdatafP,		/* file pointer for the cdp data	*/
    COUNT datafmt,		/* data formats of the cdp data		*/
    COUNT totalstroke,		/* total number of strokes per sentence */
    EDITORREC strokearray[],	/* stroke array for the strokes		*/
    COUNT totalchar,		/* total number of characters per sent	*/
    EDITORREC chararray[],	/* char array for the characters	*/
    COUNT totalword,		/* total number of words per sentence   */
    EDITORREC wordarray[],	/* word array for the words		*/
    COUNT rawtotal,		/* total number of raw data points	*/
    COUNT mrawx[],		/* raw x point for cdp data (no pen-up) */
    COUNT mrawy[],		/* raw y point for cdp data (no pen-up) */
    UTINY boxmodC,		/* mode of cdp data - box or line	*/
    UTINY statusC,		/* status of cdp data 			*/
    COUNT len,			/* length of the prompt			*/
    COUNT idxpmt,		/* index for the prompt			*/
    CIC_TEXT  promptS[],		/* cdp prompt itself			*/
    CIC_TEXT  dateS[],		/* date for the cdp data		*/
    CIC_TEXT  timeS[], 		/* time for the cdp data		*/
    COUNT spacng,		/* y (vertical) spacing between lines  	*/
    COUNT nseg,			/* number of segs(strokes) in line mode */
    COUNT rawsegpts[],		/* number of points for the strokes     */
    COUNT segy[],		/* y base lines for the strokes		*/
    COUNT nbox,			/* number of boxes in box mode		*/
    COUNT nboxseg,		/* number of segsZ(strokes) per box     */
    COUNT rawboxsegpts[],	/* number of points for the stroke      */
    COUNT bxhgt,		/* vertical distance between boxes	*/
    COUNT bxwdth,		/* horizontal distance between boxes	*/
    COUNT mboxx[],		/* x position for the box		*/
    COUNT mboxy[],		/* y position for the box		*/
    CIC_ULONG  *bytectP,	/* pointer for number of bytes gateher  */
    CIC_BOOL  trackinfoB,		/* add tracking info yes/no		*/
    CIC_TEXT  filenameS[],		/* filename of where sent came from	*/
    COUNT sentindex,		/* sentence index in the cdp data file 	*/
    COUNT charindex, 		/* char index in the sentence cdp data  */
    UTINY write_trakC,		/* cursive or print style		*/
    UTINY tablet_trakC,		/* tablet used				*/
    UTINY subtyp_trakC		/* type of sentence in cdp data 	*/
    );

VOID cdp_sample_if
    (
    FILE  *cdpinfofP,
    COUNT *datafmtP,
    COUNT *totalstrokeP,
    EDITORREC strokearray[],
    COUNT *totalcharP,
    EDITORREC chararray[],
    COUNT *totalwordP,
    EDITORREC wordarray[],
    COUNT *rawtotalP,
    COUNT mrawx[],
    COUNT mrawy[],
    UTINY *boxmodCP,
    CIC_ULONG *bytectP,
    UTINY *statusCP,
    COUNT *lenP,
    COUNT *idxpmtP,
    CIC_TEXT  cdppromptS[],
    CIC_TEXT  dateS[],
    CIC_TEXT  timeS[],
    COUNT *spacngP,
    COUNT *nsegP,
    COUNT rawsegpts[],
    COUNT segy[],
    COUNT *nboxsegP,
    COUNT rawboxsegpts[],
    COUNT *bxhgtP,
    COUNT *bxwdthP,
    COUNT mboxx[],
    COUNT mboxy[]
    );

CIC_BOOL cdp_sent_time
    (
    FILE  *incdpdatafP,
    ULONG *bytcntLP,
    CIC_ULONG  *bytectP,
    COUNT *datafmtP,       /* data formats of the cdp data                 */
    COUNT *totalstrokeP,    /* total number of strokes per sentence         */
    EDITORREC strokearray[],/* stroke array for the strokes                 */
    COUNT *totalcharP,      /* total number of characters per sent          */
    EDITORREC chararray[],  /* char array for the characters                */
    COUNT *totalwordP,      /* total number of words per sentence           */
    EDITORREC wordarray[],  /* word array for the words                     */
    COUNT *rawtotalP,       /* total number of raw data points              */
    COUNT mrawx[],          /* raw x point for cdp data (no pen-up)         */
    COUNT mrawy[],          /* raw y point for cdp data (no pen-up)         */
    UTINY *boxmodCP,        /* mode of cdp data - box or line               */
    UTINY *statusCP,        /* status of cdp data                           */
    COUNT *lenP,            /* length of the prompt                         */
    COUNT *idxpmtP,         /* index for the prompt                         */
    CIC_TEXT  promptS[],        /* cdp prompt itself                            */
    CIC_TEXT  dateS[],          /* date for the cdp data                        */
    CIC_TEXT  timeS[],          /* time for the cdp data                        */
    COUNT *spacngP,         /* y (vertical) spacing between lines           */
    COUNT *nsegP,           /* number of segs(strokes) in line mode         */
    COUNT rawsegpts[],      /* number of points for the strokes             */
    COUNT segy[],           /* y base lines for the strokes                 */
    COUNT *nboxP,           /* number of boxes in box mode                  */
    COUNT *nboxsegP,        /* number of segsZ(strokes) per box             */
    COUNT rawboxsegpts[],   /* number of points for the stroke              */
    COUNT *bxhgtP,          /* vertical distance between boxes              */
    COUNT *bxwdthP,         /* horizontal distance between boxes            */
    COUNT mboxx[],          /* x position for the box                       */
    COUNT mboxy[],          /* y position for the box                       */
    CIC_BOOL  *endoffileBP,     /* end of cdp data file indicator               */ 
    CIC_BOOL  *trackinfoBP,     /* add tracking info yes/no                     */
    CIC_TEXT  filenameS[],      /* filename of where sent came from             */
    COUNT *sentindexP,      /* sentence index in the cdp data file          */
    COUNT *charindexP,      /* char index in the sentence cdp data          */
    UTINY *write_trakCP,    /* cursive or print style                       */
    UTINY *tablet_trakCP,   /* tablet used                                  */
    UTINY *subtyp_trakCP,   /* type of sentence in cdp data                 */
    CIC_BOOL  *hastimeBP,       /* data file has stroke timing info             */
    COUNT timebeg[],	    /* time beg array for time marker               */
    COUNT timeend[]	    /* time end array for time marker               */
    );

CIC_BOOL cdp_sentence
    (
    FILE  *incdpdatafP,
    ULONG *bytcntLP,
    CIC_ULONG  *bytectP,
    COUNT *datafmtP,       /* data formats of the cdp data                 */
    COUNT *totalstrokeP,    /* total number of strokes per sentence         */
    EDITORREC strokearray[],/* stroke array for the strokes                 */
    COUNT *totalcharP,      /* total number of characters per sent          */
    EDITORREC chararray[],  /* char array for the characters                */
    COUNT *totalwordP,      /* total number of words per sentence           */
    EDITORREC wordarray[],  /* word array for the words                     */
    COUNT *rawtotalP,       /* total number of raw data points              */
    COUNT mrawx[],          /* raw x point for cdp data (no pen-up)         */
    COUNT mrawy[],          /* raw y point for cdp data (no pen-up)         */
    UTINY *boxmodCP,        /* mode of cdp data - box or line               */
    UTINY *statusCP,        /* status of cdp data                           */
    COUNT *lenP,            /* length of the prompt                         */
    COUNT *idxpmtP,         /* index for the prompt                         */
    CIC_TEXT  promptS[],        /* cdp prompt itself                            */
    CIC_TEXT  dateS[],          /* date for the cdp data                        */
    CIC_TEXT  timeS[],          /* time for the cdp data                        */
    COUNT *spacngP,         /* y (vertical) spacing between lines           */
    COUNT *nsegP,           /* number of segs(strokes) in line mode         */
    COUNT rawsegpts[],      /* number of points for the strokes             */
    COUNT segy[],           /* y base lines for the strokes                 */
    COUNT *nboxP,           /* number of boxes in box mode                  */
    COUNT *nboxsegP,        /* number of segsZ(strokes) per box             */
    COUNT rawboxsegpts[],   /* number of points for the stroke              */
    COUNT *bxhgtP,          /* vertical distance between boxes              */
    COUNT *bxwdthP,         /* horizontal distance between boxes            */
    COUNT mboxx[],          /* x position for the box                       */
    COUNT mboxy[],          /* y position for the box                       */
    CIC_BOOL  *endoffileBP,     /* end of cdp data file indicator               */ 
    CIC_BOOL  *trackinfoBP,     /* add tracking info yes/no                     */
    CIC_TEXT  filenameS[],      /* filename of where sent came from             */
    COUNT *sentindexP,      /* sentence index in the cdp data file          */
    COUNT *charindexP,      /* char index in the sentence cdp data          */
    UTINY *write_trakCP,    /* cursive or print style                       */
    UTINY *tablet_trakCP,   /* tablet used                                  */
    UTINY *subtyp_trakCP   /* type of sentence in cdp data                 */
    );

VOID cdp_wordstore
    (
    UTINY promptS[],		/* cdp sentence prompt			*/
    COUNT totalword,		/* total number in the wordarray	*/
    EDITORREC wordarray[],	/* cdp word array			*/
    UTINY wordlistS[][MAXCHARINWORD]	/* returned word list		*/
    );

VOID convertdate
    (
    CIC_TEXT dateS[],		/* mm/dd/yy				     */
    CIC_TEXT dateitS[]		/* dd-Mmm-yy				     */
    );

VOID good_strokes
    (
    COUNT     datafmt,		/* which data format it is		     */
    COUNT     totalstroke,	/* number of stroke marked		     */
    EDITORREC strokearray[],	/* stroke index into raw data		     */
    COUNT     totalchar,	/* number of chars marked		     */
    EDITORREC chararray[],	/* char index into raw data		     */
    COUNT     totalword,	/* total number of words per sentence	     */
    EDITORREC wordarray[],	/* word array for the words		     */
    COUNT     rawtotal,		/* total pen-down pts in raw data	     */
    COUNT     mrawx[],		/* Raw X-coordinates stroke (w/o pen-up)     */
    COUNT     mrawy[],		/* Raw Y-coordinates stroke (w/o pen-up)     */
    COUNT     rawsegpts[],	/* number of pen dwn for each seg.	     */
    COUNT     rawboxsegpts[],	/* number of pen dwn for each seg.(box)	     */
    COUNT     segy[],		/* y-coordinate in line mode                 */
    COUNT     *mcharsP,		/* total characters in processed data	     */
    COUNT     chrstk[],		/* number of strokes for each character	     */
    COUNT     *msegsP,		/* total strokes in processed data	     */
    COUNT     segpts[],		/* number of pen dwn for each seg.	     */
    COUNT     msegy[],		/* y-coord. of the baseline	     	     */
    COUNT     mx[],		/* raw X-coordinates stroke (w/o pen-up)     */
    COUNT     my[],		/* raw Y-coordinates stroke (w/o pen-up)     */
    UTINY     charpmtS[],	/* Prompt string without white spaces        */
    UTINY     mpromptS[]	/* processed prompt string 		     */
    );

VOID incrementdate
    (
    CIC_TEXT dateitS[]
    );

VOID jis_charstore
    (
    UTINY promptS[],		/* cdp sentence prompt			*/
    COUNT totalchar,		/* total number in the chararray	*/
    EDITORREC chararray[],	/* cdp character array			*/
    UTINY charlistS[]		/* returned character list 		*/
    );

CIC_BOOL ncrcdp_header
    (
    FILE  *cdpdatafP,
    CIC_TEXT  *filnamSP,		/* Filename of the Data			     */
    CIC_TEXT  *placeSP,		/* Where the data collection took place	     */
    UTINY placeC,		/* Numeric constant representing the place   */
    UTINY tabletC,		/* Tablet used for data collection	     */
    UTINY rateC,		/* Sampling rate, 0=slow, 1=fast	     */
    UTINY sparouC,		/* 0 = 254 lines/inch, 1 = 1016 lines/inch   */
    UTINY entmodC,		/* Entry mode, 0=sequential, 1=random	     */
    UTINY subtypC,		/* Subj type: single, word, phrase, sentence */
    UTINY dattypC,		/* Data type: 0=subject, 1=variation	     */
    UTINY boxmodC,		/* 0=line mode, 1=box mode		     */
    CIC_TEXT  *profSP,		/* Profession of operator		     */
    CIC_TEXT  *natlySP,		/* Nationality of operator                   */
    CIC_TEXT  *scholSP,		/* State/Region high school went to 	     */
    CIC_TEXT  *gendrSP,		/* Gender of operator			     */
    UTINY handC,		/* 0 = Left hander, 1 = Right hander	     */
    UTINY writeC,		/* Cursive/Printing write style		     */
    COUNT pmtuse,		/* The # of pmts to be used in a session     */
    CIC_TEXT  dateS[],
    CIC_TEXT  timeS[],
     
    TINY  prompttypeC,        /*prompt type (CIC_ASCII, CIC_JIS, CIC_UNICODE */
    COUNT charset,            /* char set in bitmask format                  */
    COUNT deltax,             /* width of a grid cell                        */
    COUNT deltay,             /* height of a grid cell                       */
    COUNT deltaxp,            /* width of printed grid cell                  */
    COUNT deltayp,            /* height of printed grid cell                 */
    COUNT xorigine,           /* x-origin of entire writing area             */
    COUNT yorigine           /* y-origin of entire writing area             */
    );
    
VOID ncrcdp_header_if
    (
    FILE  *cdpinfofP,
    UTINY *tabletCP,		/* Tablet used for data collection	     */
    UTINY *subtypCP,		/* Single/Word/Phrase/Sentence		     */
    UTINY *boxmodCP,		/* 0 = Line mode, 1 = Box mode		     */
    COUNT *pmtuseP,	/* The # of prompts used		     */
    UTINY *handCP,		/* 0 = Left hander, 1 = Right hander	     */
    UTINY *writeCP,		/* Cursive/Printing write style		     */
    UTINY *placeCP,		/* Known place where data collection happen  */
    UTINY *rateCP,		/* 0 = 100 pts/sec, 1 = 200 pts/sec	     */
    UTINY *sparouCP,		/* 0 = 254 lines/inch, 1 = 1016 lines/inch   */
    UTINY *entmodCP,		/* Sequentail/Randon			     */
    UTINY *dattypCP,		/* Subject/Variation			     */
    UTINY *lenCP,		/* Length of the place string 		     */
    UTINY *lenpCP,
    UTINY *lennCP,
    UTINY *lensCP,	/* length of schooling string                */
    UTINY *lengCP,
    char  filnamS[],   	/* Filename for opening the data file	     */
    char  placeS[],	        /* Where data collection took place	     */
    char  sessionS[],   	/* Session in char string		     */
    char  dateS[],
    char  timeS[],
    char  profS[],	/* Profession of operator		     */
    char  natlyS[],	/* Nationality of operator                   */
    char  scholS[],	/* State/Region high school went to 	     */
    char  gendrS[],		/* Gender of operator			     */

    TINY  *prompttypeCP,
    COUNT *charsetP,
    COUNT *deltaxP,
    COUNT *deltayP,
    COUNT *deltaxpP,
    COUNT *deltaypP,
    COUNT *xorigineP,
    COUNT *yorigineP
    );

CIC_BOOL ncrcdp_prolog
    (
    FILE  *incdpdatafP,
    UTINY *tabletCP,	/* Tablet used for data collection	     */
    UTINY *subtypCP,		/* Single/Word/Phrase/Sentence		     */
    UTINY *boxmodCP,		/* 0 = Line mode, 1 = Box mode		     */
    COUNT *pmtuseP,		/* The # of prompts used		     */
    UTINY *handCP,		/* 0 = Left hander, 1 = Right hander	     */
    UTINY *writeCP,		/* Cursive/Printing write style		     */
    UTINY *placeCP,		/* Known place where data collection happen  */
    UTINY *rateCP, 	/* 0 = 100 pts/sec, 1 = 200 pts/sec	     */
    UTINY *sparouCP,		/* 0 = 254 lines/inch, 1 = 1016 lines/inch   */
    UTINY *entmodCP,		/* Sequentail/Randon			     */
    UTINY *dattypCP,		/* Subject/Variation			     */
    UTINY *lenCP,		/* Length of the place string 		     */
    UTINY *lenpCP,
    UTINY *lennCP,
    UTINY *lensCP,	/* length of schooling string                */
    UTINY *lengCP,
    char  filnamS[],    	/* Filename for opening the data file	     */
    char  placeS[],	        /* Where data collection took place	     */
    char  sessionS[],   	/* Session in char string		     */
    char  dateS[],
    char  timeS[],
    char  profS[],	/* Profession of operator		     */
    char  natlyS[],		/* Nationality of operator                   */
    char  scholS[],		/* State/Region high school went to 	     */
    char  gendrS[],		/* Gender of operator			     */
     
    TINY  *prompttypeCP,      /* prompt type (CIC_ASCII, CIC_JIS, CIC_UNICODE*/
    COUNT *charsetP,          /* char set in bitmask format                  */
    COUNT *deltaxP,           /* width of a grid cell                        */
    COUNT *deltayP,           /* height of a grid cell                       */
    COUNT *deltaxpP,          /* width of printed grid cell                  */ 
    COUNT *deltaypP,          /* height of printed grid cell                 */
    COUNT *xorigineP,         /* x-origin of entire writing area             */
    COUNT *yorigineP         /* y-origin of entire writing area             */
    );

VOID ncrcdp_sample_if
    (
    FILE  *cdpinfofP,
    COUNT *datafmtP,
    COUNT *totalstrokeP,
    EDITORREC strokearray[],
    COUNT *totalcharP,
    EDITORREC chararray[],
    COUNT *totalwordP,
    EDITORREC wordarray[],
    COUNT *rawtotalP,
    COUNT mrawx[],
    COUNT mrawy[],
    UTINY *boxmodCP,
    CIC_ULONG *bytectP,
    UTINY *statusCP,
    COUNT *lenP,
    COUNT *idxpmtP,
    CIC_TEXT  cdppromptS[],
    CIC_TEXT  dateS[],
    CIC_TEXT  timeS[],
    COUNT *spacngP,
    COUNT *nsegP,
    COUNT rawsegpts[],
    COUNT segy[],
    COUNT *nboxsegP,
    COUNT rawboxsegpts[],
    COUNT *bxhgtP,
    COUNT *bxwdthP,
    COUNT mboxx[],
    COUNT mboxy[]
    );

VOID spasam_char
    (
    COUNT   numstks,		/* number of strokes in a character          */
    COUNT   x[],		/* array that holds x raw points             */
    COUNT   y[],		/* array that holds y raw points             */
    COUNT   segpnt[],		/* array that holds strokes raw pt index     */
    STROKE  strk[]		/* stroke structure for each stroke          */
    );

VOID wrt_chr_data 
    (
    FILE  *udiatdatafP,
    LONG  *recLP,
    COUNT type,
    COUNT jdrow,
    COUNT jdcol,
    COUNT chtype,
    COUNT nstrok,
    COUNT nsound,
    FLOAT resolutionF,
    CIC_TEXT  dateS[],
    CIC_TEXT  timeS[],
    CIC_TEXT  subidS[],
    UTINY brecog[] 
    );

VOID wrt_stk_data  
    (
    FILE   *udiatdatafP,
    LONG   *recLP,
    COUNT  type,
    COUNT  nstrok,
    STROKE strk[]
    );

#endif  /* ifndef CDPPUB_H        */
