/* jotcereg.h						CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS Version %I%, %U% %G%
 *----------------------------------------------------------------------------
 * Header file defines the registry entries for Jot on Windows CE
 *
 * J. Wang          23-Oct-96   Initial.
 *----------------------------------------------------------------------------
 */
#ifndef JOTCEREG_H
#define JOTCEREG_H

#define DllExport	__declspec( dllexport )   

#define JOT_REGISTRATION_NUMBER 881243765

#define JOT_MAX_REG_VALUES 13

#define JOT_REG_INKWIDTH			0
#define JOT_REG_INKCOLOR			1
#define JOT_REG_INKCLEARMODE		2
#define JOT_REG_RESULTOUTPUTMODE	3
#define JOT_REG_SELECTIONTIMEOUT	4
#define JOT_REG_STROKEWAITTIMEOUT	5
#define JOT_REG_MODEMARKSIZE		6
#define JOT_REG_SHOWMODEMARK		7
#define JOT_REG_USERECO				8
#define JOT_REG_TRAINER				9
#define JOT_REG_SMOOTHINK			10
#define JOT_REG_MMDIRECTION			11
#define JOT_REG_HANDTYPE			13

#define JOT_REG_INSTALLATION		254
#define JOT_REG_MMPOS				255

#define JOT_REG_KEY		TEXT("Software\\CIC\\Jot\\2.0")
#define JOT_INSTL_KEY	TEXT("Software\\Apps\\Jot")
#define JOT_INSTL_VALUE TEXT("InstlDir")

// Installed component
#define JOT_INSTALLED_LC			0x1
#define JOT_INSTALLED_UC			0x2
#define JOT_INSTALLED_MACROEDITOR	0x4
#define JOT_INSTALLED_TRAINER		0x8

// Jot state
#define JOT_STATE_JUST_INSTALLED	0
#define JOT_STATE_DRIVER_CHANGED	1
#define JOT_STATE_UNINSTALLED		2
#define JOT_STATE_DRIVER_CHANGED_AND_REMOVE_MACRODB 3
#define JOT_STATE_NORMAL		4

// Ink color
#define INK_COLOR_BLACK		RGB(0,0,0)
#define INK_COLOR_DARKGRAY	RGB(0x80,0x80,0x80)
#define INK_COLOR_LIGHTGRAY RGB(0xC0,0xC0,0xC0)
#define INK_COLOR_WHITE		RGB(0xFF,0xFF,0xFF)
#define INK_COLOR_RED		RGB(255, 0, 0)
#define INK_COLOR_DEFAULT	INK_COLOR_BLACK

// Output mode
#define OUTPUT_AFTER_STROKE          0
#define OUTPUT_AFTER_CHARACTER       1

// Ink clearing mode
#define CLEAR_INK_AFTER_STROKE          0
#define CLEAR_INK_AFTER_CHARACTER       1
#define CLEAR_INK_AFTER_PHRASE          2

// Reco ID
#define JOT_LC			0
#define JOT_UC			1     

// Configure Jot PW 
#define JOTPW_ENABLE	0
#define JOTPW_DISABLE	1

// Mode mark direction
#define JOT_MM_HORIZONTAL 0
#define JOT_MM_VERTICAL   1

// Hand Type
#define JOT_RIGHTHANDER 0
#define JOT_LEFTHANDER  1

typedef struct tagJOT_REG
	{
	DWORD	value_dataAr[JOT_MAX_REG_VALUES];		// The values
	} JOT_REG;

// Private messages
#define WM_JOT_REDRAWMODELINE			0x6000
#define WM_JOT_CONFIGUREGET				0x6001
#define WM_JOT_CONFIGURESET				0x6002
#define WM_JOT_CONFIGURESETDEFAULT		0x6003
#define WM_JOT_SAVEREGISTRY				0x6004
#define WM_JOT_ENABLE					0x6005
#define WM_JOT_DISABLE					0x6006
#define WM_JOT_POWERCHANGE				0x6007
#define WM_JOT_UPDATEAPPEARENCE			0x6100
#define WM_JOT_TRAYNOTIFY				0x6200
#define WM_JOT_TRAYNOTIFYKBD			0x6201
#define WM_JOT_TRAINERGET				0x6300
#define WM_JOT_TRAINERSET				0x6301
#define WM_JOT_TRAINERRESET				0x6302
#define WM_JOT_TRAINERSAVE				0x6303
#define WM_JOT_JOTKB					0x6FFF
#define WM_JOT_NEWSTROKE				0x7000 
#define WM_JOT_NEWPOINT					0x7001
#define WM_JOT_SETHWND					0x7002  
#define WM_JOT_GETTABLETDIM				0x7003
#define WM_JOT_NEWCHAR					0x7004

// Jot reco window name
#define JOT_RECO_CLASS			TEXT("JotRecoWndClass1")
#define JOT_RECO_WINDOW_NAME	TEXT("JOT RECO WINDOW1")

BOOL _cdecl JotConfigure
	(
	int		config,			// JOT_CONFIG_GET or JOT_CONFIG_SET
	JOT_REG	*regP			// Pointer to configure data
	);

#endif /* #ifndef JOTCEREG_H	*/