/* LOWOFF.H	@(#)lowoff.h	1.1   4/21/96   16:24:43
 *----------------------------------------------------------------------------
 * Definition of constants and structures for low end recognizer.
 * Splitted from lowpub.h, it contains the part that is not used by api and
 * core recognizer. It includes the difinitions used only in training, offline
 * testing and UNIX demo.
 *
 * CIC Proprietary      Copyright (C) 1995 CIC Inc.
 *
 * Gordon Sun 	04/21/96
 *----------------------------------------------------------------------------
 */

#ifndef LOWOFF_H
#define LOWOFF_H

/*
 *-----------------------------------------------------------------------------
 * Constants for tablet input
 *-----------------------------------------------------------------------------
 */
#include <tabpub.h>
#include <tools.h>

/*
#define CMP_MAXSIG      CIC_TABLET_MAXPNTS
                                 max length for arrays used in sign. ver. */
/*
#define CMP_MAXSEG      CIC_TABLET_MAXSEGS
                                 maximum number of strokes in a signature */

#define CMP_MAXSIG      1024
                                /* max length for input character. */
#define CMP_MAXSEG      8
                                 /*maximum number of strokes in a charater. */
#define  F_QUIT   1        /* Number of   QUIT function area (on the tablet) */
#define  F_ALIGN  2        /* Number of  ALIGN function area (on the tablet) */
#define  F_ACCEPT 3        /* Number of ACCEPT function area (on the tablet) */

/*
 *-----------------------------------------------------------------------------
 * Constants for learning.
 *-----------------------------------------------------------------------------
 */
 #define	LEARN_DISTANCE	25	/* Threshold for training.	*/
 #define	VER_MERGE	20	/* Threshold for merging.	*/

/*
 *-----------------------------------------------------------------------------
 * Property flag for general information (a field of the structure BUNDLE). 
 *-----------------------------------------------------------------------------
 */
 #define	FL_TRAIN	0x0001	/* Do training.			*/
 #define	FL_PLOT		0x0002	/* Do plotting.			*/
 #define	FL_OFFTEST	0x0004	/* Do offline testing. 		*/
 #define	FL_ONTEST	0x0008	/* Do online testing. 		*/
 #define	FL_CONFIG	0x0010	/* It is configurated. 		*/
 #define	FL_BTOA		0x0020	/* Print ASCII file of a binary model.*/
 #define	FL_ATOB		0x0040	/* Read ASCII file write binary model.*/
 #define	FL_RUNONCE	0x0080	/* Run only once the programm.	*/
 #define	FL_CONVERT	0x0100	/* Do model conversion.		*/
 #define	FL_HMM		0x0200	/* Use hmm model in demo.	*/

/*
 *-----------------------------------------------------------------------------
 * Property flag for training. 
 *-----------------------------------------------------------------------------
 */
 #define	FL_RETRAIN	0x0400	/* Do retraining.	*/
 #define	FL_PRUNE	0x0800	/* Do pruning after training.	*/
 #define	FL_MERGE	0x1000	/* Do version merge after training.*/

/*
 *  This is the structure to hold a floating model for one character version. 
 */
struct charverF
    {
    CIC_INT32	countL;		/* Number of samples for this version.	*/
    CIC_INT16	segnoW;	   	/* Number of segments.			*/
    FLOAT	penaltyF;   	/* Version penalty.			*/
    FLOAT	*angFP;	   	/* Angle of each segment.		*/
    FLOAT	*curFP;	   	/* Curvature of each segment.		*/
    FLOAT	*lenFP;	   	/* Length of each segment.		*/
    };

/*
 *--------------------------------------------------------------------------
 * This structure is used to hold a list of versions for each character.
 * While the list is being built we hold it in a buffer like this;
 * later we transfer it to the model structure.
 *--------------------------------------------------------------------------
 */
typedef struct
    {
    CHARVERF 	*chverFP;
    CIC_INT16   segno_minW;    		/* Min segment number.  */
    CIC_INT16   segno_maxW;    		/* Max segment number.  */
    FLOAT	xbegF[NUM_POS_CENTR];	/* x coordinate of start point.	*/
    FLOAT	ybegF[NUM_POS_CENTR];	/* y coordinate of start point.	*/
    FLOAT	xendF[NUM_POS_CENTR];	/* x coordinate of end point.	*/
    FLOAT	yendF[NUM_POS_CENTR];	/* y coordinate of end point.	*/
    CIC_INT32   nsamplesL[NUM_POS_CENTR];
    CIC_INT32   nallocL;
    CIC_INT32   nusedL;
    } VERBUF;


/*
 *-------------------------------------------------------------------------- 
 * This structure is used for training.
 *-------------------------------------------------------------------------- 
 */ 
typedef struct 
    {
    MODEL              	*modelP; 	/* Model to be trained.		*/
    VERBUF		*vbufP;		/* Version buffer used in training*/
    FLOAT              	lrateF;		/* Learning rate.		*/
    CIC_INT16           angW;           /* threshold for angle rejection.*/
    CIC_INT16           curW;           /* threshold for curvature rejection.*/
    CIC_INT16           lenW;           /* threshold for length rejection.*/
    CIC_INT16		pruneW;		/* Prune threshold of sample number.*/
    CIC_INT16		mergeW;		/* Merge threshold of version dis. */
    CIC_INT16		iterationW;	/* Prune threshold of sample number.*/
    FLOAT		addF;		/* threshold for adding new model.*/
    CIC_INT16		flagW;
    } LTRAIN; 

/*
 *-------------------------------------------------------------------------- 
 * This structure bundles a bunch of information, so it will be 
 * available in the event-driven routines. 
 *-------------------------------------------------------------------------- 
 */ 
typedef struct 
    {
    MODEL               *modelP; 
    LOWREC              *recP;
    LTRAIN		*trainP;
    DATALIST		*dataP;
    CIC_INT16		flagW;
    CIC_TEXT		infS[MAXFNAME];
    CIC_TEXT		outfS[MAXFNAME];
    CIC_TEXT		data_dirS[MAXFNAME];
    CIC_UINT16		mode;
    } BUNDLE; 

#endif          /* closes the ifndef LOWPUB_H at the top of the file */ 
/*---------------------------------------------------------------------------*/
