/* PROTO.H	@(#)proto.h	1.18   4/23/96   19:38:40
 *----------------------------------------------------------------------------
 * Definition of fuction prototypes
 * for low end recognizer.
 *
 * CIC Proprietary      Copyright (C) 1995 CIC Inc.
 *
 * Gordon Sun 	05/22/95
 *----------------------------------------------------------------------------
 */

#ifndef PROTO_H
#define PROTO_H

#include <zorroapi.h>
#include "lowpub.h"


/*
 *-----------------------------------------------------------------------------
 * Function Prototypes
 *-----------------------------------------------------------------------------
 */

CIC_INT16 ang32L
    (
    CIC_INT32 dxL,					/* X difference */
    CIC_INT32 dyL					/* Y difference */
    );

CIC_ULONG cic_sqrt
    (
    CIC_ULONG argUL	     /* variable whose square root is to be obtained */
    );

CIC_VOID divided_by_4
    (
    CIC_INT16   nsamps,                /* number of input points            */
    CIC_INT16   *xWP,                    /* input  array of x-coordinate valus*/
    CIC_INT16   *yWP                     /* input  array of y-coordinate valus*/
    );

CIC_LONG eucdis
    (
    CIC_LONG dxL,
    CIC_LONG dyL
    );

CIC_VOID preprocess
    (
    STKDATA      *stkP                    /* Character data.    */
    );

CIC_UINT8 reclow
    (
    LOWREC     *recP,                   /* Recognition structure.            */
    CHDATA     *chP ,                   /* Do recognition on this Character. */
    CIC_INT    *two_stk_modIP		/* Model index for 2-stk char	     */
    );

CIC_VOID find_box
    (
    DATABOX	*boxP,			/* Data structure for one box.*/
    CIC_INT16 	*xWP,               	/* input  array of x-coordinate valus*/
    CIC_INT16 	*yWP,               	/* input  array of y-coordinate valus*/
    CIC_INT16	lenW			/* Length of the data array.	     */
    );
					/* and shift origin to (minx, miny).*/
CIC_BOOL8 find_crossB
    (
    CIC_INT16	*xWP,
    CIC_INT16	*yWP,
    CIC_INT   	*begIP,
    CIC_INT   	*endIP,
    CIC_INT	dtI,               /* step size for searching next maxW/minW. */
    CIC_INT	*crossIP            /* Pointer to index array of cross points.*/
    );

CIC_INT16  seg_curvatureW
    (
    STKDATA     *stkP,                  /* Raw data of input stroke.    */
    CIC_INT16   begW,
    CIC_INT16   lenW
    );

CIC_VOID reverse_stroke
    (
    STKDATA	*stkP			/* Stroke data.    */
    );

CIC_VOID rec_disamb
    (
    LOWREC      *recP,         	/* Recognition structure.    	*/
    STKDATA     *stkP         	/* Input stroke data.           */
    );

CIC_VOID check_eight
    (
    STKDATA     *stkP,         	/* Input stroke data.           */
    CIC_INT	*recogIP
    );
  
ZO_CHAR shape_to_result
    (
    CIC_UINT8	shapeUC,		/* Returned shape from core	*/			
    ZO_CHAR	mode			/* Current mode			*/
    );

ZO_CHAR get_accented_char
    (
    ZO_CHAR	baseUW,				/* Base character	*/
    ZO_CHAR	markUW				/* Accent mark		*/
    );
    
#endif          /* closes the ifndef PROTO_H at the top of the file */ 
/*---------------------------------------------------------------------------*/
