/* ansicode.h                   CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS Version %I%, %U% %G%
 *----------------------------------------------------------------------------
 * Unicode definition of characters
 *
 * J. Wang          30-Apr-96   Adapted from unicode.h.
 *----------------------------------------------------------------------------
 */
#ifndef ANSICODE_H
#define ANSICODE_H

/*
 *----------------------------------------------------------------------------
 * Define the type of char. For ansi code, this should be a 1-byte, unsigned
 * char.
 * If ZORRO is ported to other systems, this probably needs change.
 *----------------------------------------------------------------------------
 */
typedef unsigned char ZO_CHAR;

#define NC					0x00
#define BACKSPACE				0x08
#define HORIZONTAL_TABULATION			0x09
#define CARRIAGE_RETURN				0x0D
#define SPACE					0x20
#define EXCLAMATION_MARK			0x21
#define QUOTATION_MARK				0x22
#define NUMBER_SIGN				0x23
#define DOLLAR_SIGN				0x24
#define PERCENT_SIGN				0x25
#define AMPERSAND				0x26
#define APOSTROPHE_QUOTE			0x27
#define OPENING_PARENTHESIS			0x28
#define CLOSING_PARENTHESIS			0x29
#define ASTERISK				0x2A
#define PLUS_SIGN				0x2B
#define COMMA					0x2C
#define HYPHEN_MINUS				0x2D
#define PERIOD					0x2E
#define SLASH					0x2F
#define DIGIT_ZERO				0x30
#define DIGIT_ONE				0x31
#define DIGIT_TWO				0x32
#define DIGIT_THREE				0x33
#define DIGIT_FOUR				0x34
#define DIGIT_FIVE				0x35
#define DIGIT_SIX				0x36
#define DIGIT_SEVEN				0x37
#define DIGIT_EIGHT				0x38
#define	DIGIT_NINE				0x39
#define COLON					0x3A
#define SEMICOLON				0x3B
#define LESS_THAN_SIGN				0x3C
#define EQUALS_SIGN				0x3D
#define GREATER_THAN_SIGN			0x3E
#define QUESTION_MARK				0x3F
#define COMMERCIAL_AT				0x40
#define LATIN_CAPITAL_LETTER_A			0x41
#define LATIN_CAPITAL_LETTER_B			0x42
#define LATIN_CAPITAL_LETTER_C			0x43
#define LATIN_CAPITAL_LETTER_D			0x44
#define LATIN_CAPITAL_LETTER_E			0x45
#define LATIN_CAPITAL_LETTER_F			0x46
#define LATIN_CAPITAL_LETTER_G			0x47
#define LATIN_CAPITAL_LETTER_H			0x48
#define LATIN_CAPITAL_LETTER_I			0x49
#define LATIN_CAPITAL_LETTER_J			0x4A
#define LATIN_CAPITAL_LETTER_K			0x4B
#define LATIN_CAPITAL_LETTER_L			0x4C
#define LATIN_CAPITAL_LETTER_M			0x4D
#define LATIN_CAPITAL_LETTER_N			0x4E
#define LATIN_CAPITAL_LETTER_O			0x4F
#define LATIN_CAPITAL_LETTER_P			0x50
#define LATIN_CAPITAL_LETTER_Q			0x51
#define LATIN_CAPITAL_LETTER_R			0x52
#define LATIN_CAPITAL_LETTER_S			0x53
#define LATIN_CAPITAL_LETTER_T			0x54
#define LATIN_CAPITAL_LETTER_U			0x55
#define LATIN_CAPITAL_LETTER_V			0x56
#define LATIN_CAPITAL_LETTER_W			0x57
#define LATIN_CAPITAL_LETTER_X			0x58
#define LATIN_CAPITAL_LETTER_Y			0x59
#define LATIN_CAPITAL_LETTER_Z			0x5A
#define OPENING_SQUARE_BRACKET			0x5B
#define BACKSLASH				0x5C
#define CLOSING_SQUARE_BRACKET			0x5D
#define SPACING_CIRCUMFLEX			0x5E
#define SPACING_UNDERSCORE			0x5F
#define SPACING_GRAVE				0x60
#define LATIN_SMALL_LETTER_A			0x61
#define LATIN_SMALL_LETTER_B			0x62
#define LATIN_SMALL_LETTER_C			0x63
#define LATIN_SMALL_LETTER_D			0x64
#define LATIN_SMALL_LETTER_E			0x65
#define LATIN_SMALL_LETTER_F			0x66
#define LATIN_SMALL_LETTER_G			0x67
#define LATIN_SMALL_LETTER_H			0x68
#define LATIN_SMALL_LETTER_I			0x69
#define LATIN_SMALL_LETTER_J			0x6A
#define LATIN_SMALL_LETTER_K			0x6B
#define LATIN_SMALL_LETTER_L			0x6C
#define LATIN_SMALL_LETTER_M			0x6D
#define LATIN_SMALL_LETTER_N			0x6E
#define LATIN_SMALL_LETTER_O			0x6F
#define LATIN_SMALL_LETTER_P			0x70
#define LATIN_SMALL_LETTER_Q			0x71
#define LATIN_SMALL_LETTER_R			0x72
#define LATIN_SMALL_LETTER_S			0x73
#define LATIN_SMALL_LETTER_T			0x74
#define LATIN_SMALL_LETTER_U			0x75
#define LATIN_SMALL_LETTER_V			0x76
#define LATIN_SMALL_LETTER_W			0x77
#define LATIN_SMALL_LETTER_X			0x78
#define LATIN_SMALL_LETTER_Y			0x79
#define LATIN_SMALL_LETTER_Z			0x7A
#define OPENING_CURLY_BRACKET			0x7B
#define VERTICAL_BAR				0x7C
#define CLOSING_CURLY_BRACKET			0x7D
#define TILDE					0x7E
#define DELETE_KEY  					0x7F

/*
 *----------------------------------------------------------------------------
 * The following part is Windows extension of ANSI characters
 *----------------------------------------------------------------------------
 */
#define LOW_SINGLE_COMMA_QUOTATION_MARK		130
#define FLORIN					            131
#define LOW_DOUBLE_COMMA_QUOTATION_MARK		132
#define HORIZONTAL_ELLIPSIS			        133
#define DAGGER					            134
#define DOUBLE_DAGGER				        135
#define SPACING_CIRCUMFLEX2			        136
#define PER_MILLER_SIGN				        137
#define LATIN_CAPITAL_LETTER_S_HACEK		138
#define LEFT_POINTING_SINGLE_GUILLEMET		139
#define	LATIN_CAPITAL_LETTER_O_E		    140
#define SINGLE_TURNED_COMMA_QUOTATION_MARK	145
#define SINGLE_COMMA_QUOTATION_MARK		    146
#define DOUBLE_TURNED_COMMA_QUOTATION_MARK	147
#define DOUBLE_COMMA_QUOTATION_MARK		    148
#define BULLET					            149
#define EN_DASH                           	150
#define EM_DASH					            151
#define SPACING_TILDE				        152
#define TRADEMARK				            153
#define LATIN_SMALL_LETTER_S_HACEK		    154
#define RIGHT_POINTING_SINGLE_GUILLEMET		155
#define	LATIN_SMALL_LETTER_O_E			    156
#define LATIN_CAPITAL_LETTER_Y_DIAERESIS	159

#define NON_BREAKING_SPACE			0xA0
#define INVERTED_EXCLAMATION_MARK		0xA1
#define CENT_SIGN				0xA2
#define POUND_SIGN				0xA3
#define CURRENCY_SIGN				0xA4
#define YEN_SIGN				0xA5
#define BROKEN_VERTICAL_BAR			0xA6
#define SECTION_SIGN				0xA7
#define SPACING_DIAERESIS			0xA8
#define COPYRIGHT_SIGN				0xA9
#define FEMININE_ORDINAL_INDICATOR		0xAA
#define LEFT_POINTING_GUILLEMET			0xAB
#define NOT_SIGN				0xAC
#define SOFT_HYPHEN				0xAD
#define REGISTERED_TRADE_MARK_SIGN		0xAE
#define SPACING_MACRON				0xAF
#define DEGREE_SIGN				0xB0
#define PLUS_OR_MINUS_SIGN			0xB1
#define SUPERSCRIPT_DIGIT_TWO			0xB2
#define SUPERSCRIPT_DIGIT_THREE			0xB3
#define SPACING_ACUTE				0xB4
#define MICRO_SIGN				0xB5
#define PARAGRAPH_SIGN				0xB6
#define MIDDLE_DOT				0xB7
#define SPACING_CEDILLA				0xB8
#define SUPERSCRIPT_DIGIT_ONE			0xB9
#define MASCULINE_ORDINAL_INDICATOR    		0xBA
#define RIGHT_POINTING_GUILLEMET		0xBB
#define FRACTION_ONE_QUARTER			0xBC
#define FRACTION_ONE_HALF			0xBD
#define FRACTION_THREE_QUARTERS			0xBE
#define INVERTED_QUESTION_MARK			0xBF
#define LATIN_CAPITAL_LETTER_A_GRAVE		0xC0
#define LATIN_CAPITAL_LETTER_A_ACUTE		0xC1
#define LATIN_CAPITAL_LETTER_A_CIRCUMFLEX	0xC2
#define LATIN_CAPITAL_LETTER_A_TILDE		0xC3
#define LATIN_CAPITAL_LETTER_A_DIAERESIS 	0xC4
#define LATIN_CAPITAL_LETTER_A_RING		0xC5
#define LATIN_CAPITAL_LETTER_A_E		0xC6
#define LATIN_CAPITAL_LETTER_CEDILLA  		0xC7
#define LATIN_CAPITAL_LETTER_E_GRAVE		0xC8
#define LATIN_CAPITAL_LETTER_E_ACUTE		0xC9
#define LATIN_CAPITAL_LETTER_E_CIRCUMFLEX	0xCA
#define LATIN_CAPITAL_LETTER_E_DIAERESIS	0xCB
#define LATIN_CAPITAL_LETTER_I_GRAVE		0xCC
#define LATIN_CAPITAL_LETTER_I_ACUTE		0xCD
#define LATIN_CAPITAL_LETTER_I_CIRCUMFLEX	0xCE
#define LATIN_CAPITAL_LETTER_I_DIAERESIS	0xCF
#define LATIN_CAPITAL_LETTER_ETH		0xD0
#define LATIN_CAPITAL_LETTER_N_TILDE		0xD1
#define LATIN_CAPITAL_LETTER_O_GRAVE		0xD2
#define LATIN_CAPITAL_LETTER_O_ACUTE		0xD3
#define LATIN_CAPITAL_LETTER_O_CIRCUMFLEX	0xD4
#define LATIN_CAPITAL_LETTER_O_TILDE		0xD5
#define LATIN_CAPITAL_LETTER_O_DIAERESIS	0xD6
#define MULTIPLICATION_SIGN			0xD7
#define LATIN_CAPITAL_LETTER_O_SLASH		0xD8
#define LATIN_CAPITAL_LETTER_U_GRAVE		0xD9
#define LATIN_CAPITAL_LETTER_U_ACUTE		0xDA
#define LATIN_CAPITAL_LETTER_U_CIRCUMFLEX	0xDB
#define LATIN_CAPITAL_LETTER_U_DIAERESIS	0xDC
#define LATIN_CAPITAL_LETTER_Y_ACUTE		0xDD
#define LATIN_CAPITAL_LETTER_THORN		0xDE
#define LATIN_SMALL_LETTER_SHARP_S		0xDF
#define LATIN_SMALL_LETTER_A_GRAVE		0xE0
#define LATIN_SMALL_LETTER_A_ACUTE		0xE1
#define LATIN_SMALL_LETTER_A_CIRCUMFLEX		0xE2
#define LATIN_SMALL_LETTER_A_TILDE		0xE3
#define LATIN_SMALL_LETTER_A_DIAERESIS 		0xE4
#define LATIN_SMALL_LETTER_A_RING		0xE5
#define LATIN_SMALL_LETTER_A_E			0xE6
#define LATIN_SMALL_LETTER_CEDILLA  		0xE7
#define LATIN_SMALL_LETTER_E_GRAVE		0xE8
#define LATIN_SMALL_LETTER_E_ACUTE		0xE9
#define LATIN_SMALL_LETTER_E_CIRCUMFLEX		0xEA
#define LATIN_SMALL_LETTER_E_DIAERESIS		0xEB
#define LATIN_SMALL_LETTER_I_GRAVE		0xEC
#define LATIN_SMALL_LETTER_I_ACUTE		0xED
#define LATIN_SMALL_LETTER_I_CIRCUMFLEX		0xEE
#define LATIN_SMALL_LETTER_I_DIAERESIS		0xEF
#define LATIN_SMALL_LETTER_ETH			0xF0
#define LATIN_SMALL_LETTER_N_TILDE		0xF1
#define LATIN_SMALL_LETTER_O_GRAVE		0xF2
#define LATIN_SMALL_LETTER_O_ACUTE		0xF3
#define LATIN_SMALL_LETTER_O_CIRCUMFLEX		0xF4
#define LATIN_SMALL_LETTER_O_TILDE		0xF5
#define LATIN_SMALL_LETTER_O_DIAERESIS		0xF6
#define DIVISION_SIGN				0xF7
#define LATIN_SMALL_LETTER_O_SLASH		0xF8
#define LATIN_SMALL_LETTER_U_GRAVE		0xF9
#define LATIN_SMALL_LETTER_U_ACUTE		0xFA
#define LATIN_SMALL_LETTER_U_CIRCUMFLEX		0xFB
#define LATIN_SMALL_LETTER_U_DIAERESIS		0xFC
#define LATIN_SMALL_LETTER_Y_ACUTE		0xFD
#define LATIN_SMALL_LETTER_THORN		0xFE
#define LATIN_SMALL_LETTER_Y_DIAERESIS 		0xFF

#define PZ_NEXT_RESULT_WAITING			0x1F
#define PZ_NEXT_RESULT_END_WAITING		0x1E
#define NON_SPACING_GRAVE			0x1D
#define NON_SPACING_ACUTE			0x1C
#define NON_SPACING_CIRCUMFLEX			0x1B
#define NON_SPACING_DIAERESIS			0x1A
#define NON_SPACING_TILDE			0x19
#define NON_SPACING_RING_ABOVE			0x18

#define PZ_MODE_UCALPHA				0x01
#define PZ_MODE_LCALPHA				0x02
#define PZ_MODE_NUMERIC				0x03
#define PZ_MODE_PUNCTUATION			0x04
#define PZ_MODE_EXTENDED			0x05
#define PZ_MODE_DEFAULT				PZ_MODE_LCALPHA
#define PZ_INK_KEEP_THIS			0x06
#define PZ_INK_CLEAR_ALL                        0x07
#define BACKSPACE				0x08
#define HORIZONTAL_TABULATION			0x09
#define PZ_WAIT_X					0x0A
#define PZ_WAIT_FOUR				0x0B
#define PZ_WAIT						0x0C
#define CARRIAGE_RETURN				0x0D
#define PZ_CHANGE_LAST_CHAR			0x0E
#define PZ_GESTURE_UNDO				0x0F
#define PZ_GESTURE_CUT				0x10
#define PZ_GESTURE_COPY				0x11
#define PZ_GESTURE_PASTE			0x12
#define PZ_GESTURE_DELETE			0x13
#define PZ_GESTURE_END				0x14
#define PZ_MACRO				0x15 
#define PZ_OPERATION				0x16 
#define PZ_SPECIALKEY				0x17
#define PZ_REAL_DOT					0x17

#define NEWLINE					CARRIAGE_RETURN
#define TAB					HORIZONTAL_TABULATION


#endif 
