/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   autopwr.h
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Auto power off header file
Revision    :   1.1
Note        :   None
===========================================================================
*/

#ifndef _AUTOPWROFF_
#define _AUTOPWROFF_

#include "datatype.h"
#include "ioconmsg.h"
#include "iocon.h"
#include "QTYPE.H"
#include "print.h"
#include "uart.h"
#include "pr31700s.h"
#include "pr31700c.h"

extern UWORD are_pda_on;

/* Command For Accessory */
#define Time_On_Pda      10000


void OnPdaInit();
void EnOnPdaTimerInt();
void DisOnPdaTimerInt();
void OnPdaCtrl();
void OffPda();
void OnPda();
void ResetOnPda();
void PdaPwrState(UWORD *pdapwrstate);
void CheckPdaPwr();

#endif  /* _AUTOPWROFF_ */


