/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   datatype.h
Author(s)   :   Ricky Leung
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   These are definitions to relate generic operator       
                lengths to insure portablity among different systems.  
Revision    :   1.1
Note        :   None
===========================================================================
*/

/************************************************************************/
/*              Standard Type Definitions                               */
/************************************************************************/

#ifndef GLOBAL_DATATYPE
#define GLOBAL_DATATYPE

#define PR31700
#ifdef 	PC_SIM

#define BYTE    signed char     /* Signed byte 8-bit                    */
#define UBYTE   unsigned char   /* Unsigned signed byte 8-bit           */
#define SHORT   signed short    /* Signed short word 16-bit             */
#define USHORT  unsigned short  /* Unsigned short word 16-bit           */
#define WORD    long int        /* Signed word 32-bit                   */
#define UWORD   unsigned long int       /* Unsigned signed word 32-bit  */
#define BOOLEAN int             /* 2 valued (true/false) 16-bit         */

#endif	PC_SIM

#ifdef 	PR31700

#define BYTE    signed char     /* Signed byte 8-bit                    */
#define UBYTE   unsigned char   /* Unsigned signed byte 8-bit           */
#define SHORT   signed short    /* Signed short word 16-bit             */
#define USHORT  unsigned short  /* Unsigned short word 16-bit           */
#define WORD    int             /* Signed word 32-bit                   */
#define UWORD   unsigned int    /* Unsigned signed word 32-bit          */
#define BOOLEAN short           /* 2 valued (true/false) 16-bit         */
#define NULL    0

#endif	PR31700

/************************************************************************/
/*              Common Definitions for all programmer                   */
/************************************************************************/
#define TRUE    1
#define FALSE   0
#define BYTE_SIZE	8
#define BYTE_MASK	0xFF
#define WORD_SIZE	32
#define WORD_MASK	0xFFFFFFFF
#define UPPER_WORD(a)	(a >> 16)
#define LOWER_WORD(a)	(a & 0xFFFF)

#ifndef	min
#define min(a,b)	(((a) < (b)) ? (a) : (b))	// return the min variable about a & b
#endif	min

#endif  GLOBAL_DATATYPE

