/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dev_pen.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Header file for Pen Device Driver
Revision    :   1.1
Note        :   23/09/98   Prepared by Andrew Hui (AH)                     
                23/09/98   V1.0 release (AH)                               
                10/12/98   V1.1 release (AH)                               
                15/12/98   V1.2 release (AH) (Optimize to O3)              
===========================================================================
*/

#include "platform.h"
#ifdef PR31700

#ifndef  __PEN_DEVICE_DRIVER__
#define  __PEN_DEVICE_DRIVER__

#include "pr31700s.h"
#include "pr31700c.h"
#include "std.h"
#include "uart.h"
#include "ttp.h"
#include "dev_bety.h"

#include "dev_sib.h"   /* SibInit() only */

#include "intc.h"
#include "datatype.h"
#include "qtype.h"
#include "tmrapi.h"

/* Betty Register Access */
#define BtyReadReg(input)    CPU->REG_SIB_SF0_CTRL = input
#define BtyWriteReg(input)   CPU->REG_SIB_SF0_CTRL = input |BTY_WRT
#define BtyReadADCValue()    (CPU->REG_SIB_SF0_STATUS)
#define BtyRegData()    (CPU->REG_SIB_SF0_STATUS & 0xffff)

#define PEN_TIMER_START     1
#define PEN_TIMER_STOP      2
#define PEN_TIMER_STOPED    3
 
#define PM_IDLE  0
#define PM_PM    1


extern volatile WORD PenState ;      /* state of Pen-Input handler state-machine */

extern volatile WORD PenTmrHandle;
extern volatile WORD PenTmrHdlrState;

extern volatile WORD  PenInitState;

extern volatile WORD PenDint;
extern volatile WORD PenTmrAction;
extern volatile WORD PenMsgSerial;

void PenTmrIntHandler();     /* call by timer */
void PenGetxy();
void PenInit();
void PenRotateInit();
void PenInitSM();

void    PenDownIntEnableSM();
void    PenDownIntEnable();
void    PenRestoreDefault();


#define PEN_INFO_F_ADDRESS  (int*)0x9fc06000  /* to 0x9fc06010 */


#endif   __PEN_DEVICE_DRIVER__


#endif

