/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   font.h
Author(s)   :   Henry Fok, Thomas cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for 3 sets of fonts
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef	_FONT_
#define _FONT_

#include "datatype.h"

#define NUM_OF_FONTS	3
#define NUM_OF_CHARS	256

#define FONT_1_HEIGHT	8
#define FONT_2_HEIGHT	10
#define FONT_3_HEIGHT	17

#define SMALL_FONT		0
#define MEDIUM_FONT		1
#define LARGE_FONT		2

extern const BYTE 		FONT_HEIGHT[NUM_OF_FONTS];

extern const BYTE* 		FontWidth;
extern const USHORT* 	Font1;
extern const USHORT* 	Font2;
extern const USHORT* 	Font3;

//====================== API calls ======================
BYTE SysGetFontHeight(BYTE font_id);
void SysFontRestoreFont();
void SysFontSetCustomFont(const USHORT **CustomFontPtrs, const BYTE* CustomFontWidth);

#endif	_FONT_
