/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   keyapi.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for keyboard defines
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#ifndef	_KEYAPI_
#define	_KEYAPI_

#include "qtype.h"

#define EVT_KEY		2
#define SOFT_KEY	1
#define	HARD_KEY	2

#define	KEY_BACKSPACE	8

/* temp key assignment for para2*/
#define KEY_HOME		20
#define KEY_END			23
#define KEY_PAGE_UP		21
#define KEY_PAGE_DOWN	22
#define KEY_LEFT		31
#define KEY_RIGHT		30
#define KEY_UP			28
#define	KEY_DOWN		29
#define KEY_CUT			18
#define	KEY_COPY		19
#define KEY_UNDO		15
#define KEY_DEL			24
#define KEY_INSERT		16
#define	KEY_PASTE		17
#define KEY_BACKSPACE	8

//#define UI_START_MENU	122
#define UI_UNDO			119
//#define KEYBOARD		120


/* end of temp key assignment */

void KeyDecode(MsgType *msg);

#endif	_KEYAPI_
