//******************************************************************************
//* File		: mips_asm.h
//* Project		: VTech OS (Ver 2.0)
//* Company		: VTech Info-Tech Ltd.
//* By			: Kam Ching
//* Revision	: 1.0
//* Description	: MIPS common assembler macro
//* ----------------------------------------------------------------------------
//* History:
//* Aug. 5,1999	Kam		- Initial release
//******************************************************************************

#ifndef _MIPS_ASM_H_
#define _MIPS_ASM_H_

// Include files ---------------------------------------------------------------

// assembler leaf function routine entry point
#define	LEAF_FUNC(func)	\
		.text;			\
		.globl	func;	\
func:	.ent	func;

// assembler non-leaf function routine entry point
#define	NESTED_FUNC(func, framesize, rpc)\
		.text;			\
		.globl	func;	\
		.ent	func;	\
func:	.frame	sp, framesize, rpc

// assembler addition entry point
#define	AENT_FUNC(func)	\
		.globl	func;	\
func:	

#define	FUNC_END(func)	\
		.end	func

#define	GLOBAL(symbol)	\
		.globl	symbol;	\
symbol:

#define	GLOBAL_WORD(name,num)	\
		.globl	name;			\
name:	.word	num;


#endif	_MIPS_ASM_H_
