/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   msg.h
Author(s)   :   Brian Lee
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for Message queue and message dispatcher
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#ifndef __MSG__
#define	__MSG__

#include "DATATYPE.H"
#include "QTYPE.H"

/* public function prototype */

void 	MsgQueueCreate(MsgQueueType *);
BOOLEAN MsgQueueEmpty(MsgQueueType *);
BOOLEAN MsgQueueFull(MsgQueueType *);
void    MsgAppend(MsgType, MsgQueueType *);
void 	MsgAppendMsg(void (*)(), WORD, WORD, WORD, void * );
void    MsgAppendMsgInt(void (*)(), WORD, WORD, WORD, void * );
void    MsgAppendMsgReplaceInt(void (*)(), WORD, WORD, WORD, void * );
void    MsgAppendInt(MsgType, MsgQueueType *);
BOOLEAN MsgServe(MsgType *, MsgQueueType *);
void	MsgDecode(MsgQueueType *);

#endif  /* __MSG__ */
