/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   qtype.h
Author(s)   :   Brian Lee
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for common type definition
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __COMMON__
#define	__COMMON__

#include "DATATYPE.H"

/* constant assignment */

#define EVT_QUEUE_SIZE          0x80    /* maximum event queue size */
#define MSG_QUEUE_SIZE          0x80    /* maximum message queue size */


#ifdef PR31700
#define DISABLE_INTERRUPT       DIS_GBL_INT
#define ENABLE_INTERRUPT		ENA_GBL_INT
#endif

#ifdef PC_SIM
#define DISABLE_INTERRUPT
#define ENABLE_INTERRUPT
#endif

/* structure for event */

typedef struct {
	WORD                eventType;
	WORD                eventID;
	WORD                para1;
	WORD                para2;
	void                *evtPBP;
    } EvtType;

/* structure for messgae */

typedef struct {
	void				(*ptr_fct)(void *);
	UWORD               msgID;
	UWORD               para1;
	UWORD               para2;
	void                *msgPBP;
    } MsgType;

/* structure for event queue */

typedef struct {
    UWORD               count;
    UWORD               front;
    UWORD               rear;
    EvtType             event[EVT_QUEUE_SIZE];
    } EvtQueueType;

/* structure for message queue */

typedef struct {
    UWORD               count;
    UWORD               front;
    UWORD               rear;
    MsgType             message[MSG_QUEUE_SIZE];
    } MsgQueueType;

#endif  /* __COMMON__ */
