/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   init.c
Author(s)   :   Henry Fok, Andrew Hui, Garick Ngai, Thomas Cheng, Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Initialisation
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "pr31700s.h"
#include "pr31700c.h"
#include "intc.h"
#include "uart.h"
#include "print.h"
#include "tmrapi.h"
#include "msg.h"
#include "eventmgr.h"
#include "mmu.h"
#include "alaunch.h"
#include "CpuIoReg.h"   /* AH */
#include "sio.h"
#include "dev_pwr.h"

extern EvtQueueType     evtQueue;
extern MsgQueueType     msgQueue;
extern UWORD            *sys_page, *app_page, *int_page;
extern WORD             DoorOpenCnt;
void UserDMInit();

//#define DEBUG

//extern BOOLEAN retval;

//extern void Welscr();


int DummyOut(const char *fmt, ...)
{
}

void SysEnableDebug()
{
	UartAOn();
	stdoutput = (void *)UartPrints;
}

void SysDisableDebug()
{
	UartAOff();
	stdoutput = (void *)DummyOut;
}

void InitAll()
{
	
    DatabaseID sys_dbid;
    
    IntInit();
	
    SibInit();      /* AH */
    SibEnable();    /* AH */
	
    HwSioInit();    /* AH */
    HwHotSyncInit();    /* AH990413 */
	
    Delay(0x1fff);  /* AH */
    BettyReset();   /* AH */
	
    UartInit(UART_A, UART_BAUD115200, UART_DATABIT8|UART_PARITY_NONE|UART_STOPBIT1);
	
#ifdef DEBUG
    SysEnableDebug();
    UartAOn();      /* AH */
#else
    SysDisableDebug();
    UartAOff();      /* AH */
#endif
	
	
	//AH replace by UartAOn()        UartEnable(UART_A);
#ifdef DEBUG
    UartPutc(UART_A, 12);
    printf("H   H EEEEE L     III OOOOO     Vtech Helio\n");
    printf("H   H E     L      I  O   O     VT-OS 99 version 1.101 Final\n");
	printf("HHHHH EEEEE L      I  O   O     Copyright 1999 Vtech Informations Ltd.\n");
	printf("H   H E     L      I  O   O     This Product is licensed to:\n");
    printf("H   H EEEEE LLLLL III OOOOO     Vtech guys - 07/10/1999 \n");
#endif
	
	TlbInit();
	MMUInit();
	MemoryGetPageTable(&sys_page, &app_page, &int_page);
	
	
    MsgQueueCreate(&msgQueue);
    EvtQueueCreate(&evtQueue);
    EvtInitHandler();
#ifdef DEBUG
    printf("\n\n\t\t\tAH:Q ready \n");
#endif
	
    BettyInit();  //AH990408
    HwAudioOff();
	
	/*    PenInit();      /* AH */
	
	
	/************************************************************/
	/* (AH) Warning : Only MFIO1 is available for debug purpose */
	/* (AH) Warning : Only MFIO0 is used as Sound Record key    */
	/************************************************************/
	
	
	ResInit();
    SIOPopupInit();
    BatteryWarningInit();
	TmrInit();
	
	//Henry Exchange Rate Database Flag Initialisation
	//    ex_rate_db_init = FALSE;
	
	UIInit();
	JotInit();
    UartMgrInit();
    AlarmMgrInit();
    GlobalFindInit();
    IOKeyCtrlInit();
    ELInit();
    SndDDInit();
    //SIOInit();
    OnPdaInit();
	
    if (((CPU->REG_MFIO_DATA_OUT >>3)&1) ==0)
    {
        LcdInit();   /////
        LcdTurnOn(); /////
    }
    else
    {
        AHTurnLcdOff();
        LcdInit();
        LcdTurnOn();
    }
	
    PenInit();      /* AH */
    PenRotateInit();
	
    DIS_GBL_INT;
    PowerMgrInit();
    ENA_GBL_INT;
	
#ifdef DEBUG
    printf("\n\n\t\t\t======== Bye======= \n");
#endif
}
