/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   iocon.c
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   IO control
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "tmrapi.h"

#include "iocon.h"
#include "el.h"
#include "qtype.h"
#include "eventmgr.h"
#include "msg.h"
#include "dev_pwr.h"

volatile UWORD    check_power_pin;
volatile UWORD    check_key8_pin;
volatile UWORD    check_key1to7_pin;
volatile UWORD    iokey_status;
volatile UWORD    en_power_timer;
volatile UWORD    en_key_timer;
volatile UWORD    en_hot_syn_pin_check;
volatile UWORD    rd_hot_syn_pin;
volatile UWORD    dis_hot_syn_pin_check;
volatile UWORD    check_key8;
volatile UWORD    on_pda_thu_rec_key;
volatile UWORD    key8_value;
volatile UWORD    key_repeat_time;
volatile UWORD    get_no_of_time;

volatile UWORD    check_play_sound_key;
volatile UWORD    play_sound_key_value;
volatile UWORD    get_no_of_play_sound_time;

extern volatile UWORD    el_status_on;



void IOKeyCtrlInit()
{
	CPU->REG_INT_ENABLE_3 |= KEY_8;
	CPU->REG_INT_ENABLE_5 &= DIS_N_KEY_1TO7;
	CPU->REG_INT_ENABLE_5 |= IOKEY_PWRON;
	
	CPU->REG_IO_CTRL |= IO_KEY1TO7_DEBOUN;
	CPU->REG_IO_CTRL &= IO_KEY1TO7_DIRECTN;
	CPU->REG_MFIO_SEL |= MFIO_IOKEY8_SEL;
	CPU->REG_MFIO_DIRECTN &= MFIO_IOKEY8_DIRECTN;
	CPU->REG_MFIO_SEL |= MFIO_HOTSYNC_SEL;
	CPU->REG_MFIO_DIRECTN &= MFIO_HOTSYNC_DIRECTN;
	
	CPU->REG_POWER_CTRL |= POWER_DEBOUN;
	
	CPU->REG_INT_STATUS_4 = MFIONEGINT(25); // POSONBUTNINT
	ENA_MFIOPOSINT(0);
	ENA_MFIONEGINT(25);
	DIS_MFIOPOSINT(25);
	
	
	
	//for EL Module ////////////////////////////////
	CPU->REG_MFIO_SEL |= EL_PIN;
	CPU->REG_MFIO_DIRECTN |= EL_PIN;
	CPU->REG_MFIO_DATA_OUT &= OFF_EL_PIN;
	
	
	check_power_pin = 0;
	check_key8_pin = 0;
	check_key1to7_pin = 0;
	iokey_status = 0;
	key_repeat_time = 0;
	count_rep_power_pin = 0;
	count_rep_iokey = 0;
	pre_iokey_data = 0;
	new_iokey_data = 0;
	chg_iokey_data = 0;
	en_hot_syn_pin_check = 0;
	rd_hot_syn_pin = 0;
	check_key8 = 0;
	key8_value = 0;
	on_pda_thu_rec_key = 0;
	get_no_of_time = 0;
	el_status_on = 0;
	check_play_sound_key = 0;
	play_sound_key_value = 0;
	get_no_of_play_sound_time = 0;
}

void ResetIOIntFlag()
{
	CPU->REG_INT_STATUS_5 = IOPOSINT(0); // POSONBUTNINT
	CPU->REG_INT_STATUS_5 = IOPOSINT(1); // POSONBUTNINT
	CPU->REG_INT_STATUS_5 = IOPOSINT(2); // POSONBUTNINT
	CPU->REG_INT_STATUS_5 = IOPOSINT(3); // POSONBUTNINT
	CPU->REG_INT_STATUS_5 = IOPOSINT(4); // POSONBUTNINT
	CPU->REG_INT_STATUS_5 = IOPOSINT(5); // POSONBUTNINT
	CPU->REG_INT_STATUS_5 = IOPOSINT(6); // POSONBUTNINT
	CPU->REG_INT_STATUS_3 = MFIOPOSINT(0); // POSONBUTNINT
	
}

void ResetPowerFlag()
{
	CPU->REG_INT_STATUS_5 = POSONBUTNINT;
}


void EnPowerPinInt()
{
	CPU->REG_INT_ENABLE_5 |= POWER_PIN;
}

void DisPowerPinInt()
{
	CPU->REG_INT_ENABLE_5 &= DIS_POWER_PIN;
}

void EnPowerTimerInt()
{
	en_power_timer = TmrIntEnableIntPen(50, PowerRepeat);
}

void DisPowerTimerInt()
{
    if(en_power_timer != 0)
        TmrIntDisableInt(en_power_timer);
    en_power_timer = 0;
}

void EnIOKeyInt()
{
	CPU->REG_INT_ENABLE_3 |= KEY_8;
	CPU->REG_INT_ENABLE_5 |= KEY_1TO7;
}

void DisIOKeyInt()
{
	CPU->REG_INT_ENABLE_3 &= DIS_KEY_8;
	CPU->REG_INT_ENABLE_5 &= DIS_KEY_1TO7;
}

void EnIOKeyTimerInt(UWORD io_rep_time)
{
	en_key_timer = TmrIntEnableIntPen(io_rep_time, IOKeyRepeat);
	key_repeat_time = io_rep_time;       
}

void DisIOKeyTimerInt()
{
	if(en_key_timer != 0)
	{
		TmrIntDisableInt(en_key_timer);
		en_key_timer = 0;
	}
}

void IOCtrl()
{
	check_key8_pin = (CPU->REG_MFIO_DATA_IN & KEY_8);
	check_key1to7_pin = (CPU->REG_IO_CTRL & READ_IO_KEY1TO7);
	iokey_status = ((check_key8_pin<<7) | check_key1to7_pin);
	
	
	if(NormalOperation == FALSE)
	{
		if (BatDoorOpen() == 0)
		{
			if(((iokey_status & ~(IO_SOUND_STOP | IO_UP_ARROW  | IO_DOWN_ARROW )) != 0) )
			{
				WakeCpuUp = TRUE;
				if((iokey_status & CHK_IO_KEY1TO8) != 0) 
				{
					MsgAppendMsgInt(IOKeyCtrlMgr, MSG_IOKEY_PRESS, iokey_status, 1,NULL);
				}
			}
		}
	}
	else
	{
		if((iokey_status & CHK_IO_KEY1TO8) != 0)
		{
			DisIOKeyInt();
			MsgAppendMsgInt(IOKeyCtrlMgr, MSG_IOKEY_PRESS, iokey_status, 0,NULL);
			DisIOKeyTimerInt();
			EnIOKeyTimerInt(400);
		}
	}
	
}

void PowerCtrl()
{
    DisPowerPinInt();
	
    if(NormalOperation == FALSE)
    {
        WakeCpuUp = TRUE;
        ResetPowerFlag();
    }
    else
    {
        check_power_pin =  CPU->REG_POWER_CTRL;
        ResetPowerFlag();
        EnPowerTimerInt();
    }
	
    EnPowerPinInt();
}


void PowerRepeat()
{
	check_power_pin =  CPU->REG_POWER_CTRL;
	if((check_power_pin & POWER_REG) != 0)  /* if = 0 then power pin press */
	{
		MsgAppendMsgInt(IOKeyCtrlMgr, MSG_POWER_REPEAT, POWER_REPEAT_ON, 0,NULL);
	}
	else
	{
		DisPowerTimerInt();
		EnPowerPinInt();
		MsgAppendMsgInt(IOKeyCtrlMgr, MSG_POWER_REPEAT, POWER_REPEAT_OFF, 0,NULL);
	}
	
}


void IOKeyRepeat()
{
	check_key8_pin = (CPU->REG_MFIO_DATA_IN & KEY_8);
	check_key1to7_pin = (CPU->REG_IO_CTRL & READ_IO_KEY1TO7);
	
	iokey_status = ((check_key8_pin<<7) | check_key1to7_pin);
	
	if(iokey_status == 0)
	{
		pre_iokey_data = 0;
		
		DisIOKeyTimerInt();
		ResetIOIntFlag();
		
		EnIOKeyInt();
		count_rep_iokey = 0;
	}
	if(key_repeat_time == 400)
	{
		DisIOKeyTimerInt();
		EnIOKeyTimerInt(25);
	}
	
	
	MsgAppendMsgInt(IOKeyCtrlMgr, MSG_IOKEY_REPEAT, iokey_status, 0,NULL);
}

void HotSynDebounCheck()
{                           
    DIS_MFIONEGINT(25);     
    CPU->REG_INT_STATUS_4 = MFIONEGINT(25); // POSONBUTNINT
	
	//    UartInit(UART_A, UART_BAUD115200, UART_DATABIT8|UART_PARITY_NONE|UART_STOPBIT1);
	//    SysEnableDebug();
	//    UartAOn();      /* AH */
	//    printf("\nHot Deb NormalOperation = %d",NormalOperation); 
	
    if(NormalOperation == FALSE)
    {
        SemiPowerOff = TRUE;
    }
	
	
    en_hot_syn_pin_check = 0;
    en_hot_syn_pin_check = TmrIntEnableIntPen(200, HotSyncDet);
}

void HotSyncDet()
{
    if(en_hot_syn_pin_check != 0)
    {
		TmrIntDisableInt(en_hot_syn_pin_check);
		en_hot_syn_pin_check = 0;
    }
	
    rd_hot_syn_pin = 0;
    rd_hot_syn_pin = CPU->REG_MFIO_DATA_IN;
    rd_hot_syn_pin &= 0x02000000;
	
	
    if(NormalOperation == FALSE)
    {
        if(rd_hot_syn_pin == 0)
        {
            SemiPowerOff = FALSE;
            WakeCpuUp = TRUE;
            MsgAppendMsgInt(IOKeyCtrlMgr, MSG_HOTSYN_KEY_PRESS, 0, 0,NULL);
        }
        else
        {
            SemiPowerOff = FALSE;
        }
        CPU->REG_INT_STATUS_4 = MFIONEGINT(25); // POSONBUTNINT
        ENA_MFIONEGINT(25);     
    }
    else
    {
        if(rd_hot_syn_pin == 0)
        {
            MsgAppendMsgInt(IOKeyCtrlMgr, MSG_HOTSYN_KEY_PRESS, 0, 0,NULL);
        }
        CPU->REG_INT_STATUS_4 = MFIONEGINT(25); // POSONBUTNINT
        ENA_MFIONEGINT(25);     
    }
}

void DisHotSynCheck()
{
	
    if(NormalOperation == FALSE)
        WakeCpuUp = FALSE;
	
	DIS_MFIOPOSINT(25);
	dis_hot_syn_pin_check = TmrIntEnableIntPen(50, HotSynPortMoveOut);
}


void HotSynPortMoveOut()
{
	TmrIntDisableInt(dis_hot_syn_pin_check);
	rd_hot_syn_pin = 0;
	DIS_MFIOPOSINT(25);
	CPU->REG_INT_STATUS_3 = MFIOPOSINT(25); // POSONBUTNINT
	ENA_MFIONEGINT(25);
}


void CheckKey8()
{
	
	//    UartInit(UART_A, UART_BAUD115200, UART_DATABIT8|UART_PARITY_NONE|UART_STOPBIT1);
	//    SysEnableDebug();
	//    UartAOn();      /* AH */
	//    printf("\nCheckKey8 NormalOperation = %d",NormalOperation);
    if(NormalOperation == FALSE)
    {
        SemiPowerOff = TRUE;
    }
	
    DIS_MFIOPOSINT(0);
    CPU->REG_INT_STATUS_3 = MFIOPOSINT(0); // POSONBUTNINT
    check_key8 = TmrIntEnableIntPen(20, ReadKey8);
}

void ReadKey8()
{
	
    if(check_key8 != 0)
    {
		TmrIntDisableInt(check_key8);
		check_key8 = 0;
    }
    key8_value = CPU->REG_MFIO_DATA_IN;
    key8_value &= 0x00000001;
	
    if(key8_value == 1)
    {
        if(NormalOperation == FALSE)
        {
            SemiPowerOff = TRUE;
            get_no_of_time = 0;
            on_pda_thu_rec_key = TmrIntEnableIntPen(50, OnPdaTxRecKey);           
        }
        else
        {
            IOCtrl();
            CPU->REG_INT_STATUS_3 = MFIOPOSINT(0); // POSONBUTNINT
            ENA_MFIOPOSINT(0);
        }
    }
    else
    {
        if(NormalOperation == FALSE)
        {
            SemiPowerOff = FALSE;
        }
        CPU->REG_INT_STATUS_3 = MFIOPOSINT(0); // POSONBUTNINT
        ENA_MFIOPOSINT(0);
    }
	
}


void OnPdaTxRecKey()
{
    get_no_of_time++;
    key8_value = CPU->REG_MFIO_DATA_IN;
    key8_value &= 0x00000001;
	
    if(key8_value == 1)
    {
		
        if(get_no_of_time > 24)
        {
            if(on_pda_thu_rec_key != 0)
            {
				TmrIntDisableInt(on_pda_thu_rec_key);
				on_pda_thu_rec_key = 0;
            }
			
			
            check_key8 = 0;
            get_no_of_time = 0;
            SemiPowerOff = FALSE;
            WakeCpuUp = TRUE;
            IOCtrl();           
            CPU->REG_INT_STATUS_3 = MFIOPOSINT(0); // POSONBUTNINT
            ENA_MFIOPOSINT(0);
        }
    }
    else
    {
		if(on_pda_thu_rec_key != 0)
		{
			TmrIntDisableInt(on_pda_thu_rec_key);
			on_pda_thu_rec_key = 0;
		}
		
		SemiPowerOff = FALSE;
		get_no_of_time = 0;
		CPU->REG_INT_STATUS_3 = MFIOPOSINT(0); // POSONBUTNINT
		ENA_MFIOPOSINT(0);
    }
}

void KbPowerCtrl()
{
    if(NormalOperation == FALSE)
    {
        WakeCpuUp = TRUE;
    }
    else
    {
        EnIOKeyInt();
        MsgAppendMsgInt(IOKeyCtrlMgr, MSG_POWER_REPEAT, POWER_REPEAT_OFF, 0,NULL);
    }
}

void KeyUp()
{
    if(NormalOperation == TRUE)
        IOCtrl();
}

void KeyDown()
{
    if(NormalOperation == TRUE)
        IOCtrl();
}

void KeyStop()
{
    if(NormalOperation == TRUE)
        IOCtrl();
}


void PlaySoundKey()
{
    if(NormalOperation == FALSE)
    {
        SemiPowerOff = TRUE;
        check_play_sound_key = TmrIntEnableIntPen(50, ReadPlaySoundKey);
    }
    else
    {
        IOCtrl();
    }
	
}

void ReadPlaySoundKey()
{
    get_no_of_play_sound_time++;
    play_sound_key_value = (CPU->REG_IO_CTRL & 0x00000020);  
    if(play_sound_key_value == 0x00000020)
    {
		
        if(get_no_of_play_sound_time > 30)
        {
            if(check_play_sound_key != 0)
            {
				TmrIntDisableInt(check_play_sound_key);
				check_play_sound_key = 0;
            }
			
            get_no_of_play_sound_time = 0;
            SemiPowerOff = FALSE;
            WakeCpuUp = TRUE;
            IOCtrl();           
        }
    }
    else
    {
		if(check_play_sound_key != 0)
		{
			TmrIntDisableInt(check_play_sound_key);
			check_play_sound_key = 0;
		}
		SemiPowerOff = FALSE;
		get_no_of_play_sound_time = 0;
    }
}

