/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ioconmsg.c
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   IO control manager
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "iocon.h"
#include "el.h"
#include "qtype.h"
#include "eventmgr.h"
#include "msg.h"
#include "dev_pwr.h"

/* Test by Thomas */
#include "uievent.h"

volatile UWORD    count_rep_power_pin;
volatile UWORD    count_rep_iokey;
volatile UWORD    pre_iokey_data;
volatile UWORD    new_iokey_data;
volatile UWORD    chg_iokey_data;

UWORD    el_status_on;

void IOKeyCtrlMgr(MsgType* message)
{
	//    printf("\nmessage->para1 = %x\n",message->para1);
    UWORD    i,j;
    UWORD    new_and_chg;
	
	
    switch(message->msgID)
    {
	case MSG_HOTSYN_KEY_PRESS:
		EvtAppendEvt(EVT_IO_KEY_CTRL, EVT_IO_KEY_PRESS, 0, EVT_HOTSYN_KEY_PRESS, NULL);
		//printf("\nmessage->msgID = HOTSYN_KEY_PRESS\n");
		
		break;                         
		
	case MSG_IOKEY_PRESS:
		new_iokey_data = message->para1;
		chg_iokey_data = new_iokey_data ^ pre_iokey_data;
		pre_iokey_data = new_iokey_data;
		//printf("\nmessage->msgID = IOKEY_PRESS\n");
		ResetELWhenOn();
		ELState(&j);
		
		EvtAppendEvt(EVT_IO_KEY_CTRL, EVT_IO_KEY_PRESS, chg_iokey_data, pre_iokey_data, NULL);
		
		break;
	case MSG_IOKEY_REPEAT:
		new_iokey_data = message->para1;
		chg_iokey_data = new_iokey_data ^ pre_iokey_data;
		pre_iokey_data = new_iokey_data;
		new_and_chg = chg_iokey_data & new_iokey_data;
		
		if(chg_iokey_data == 0)
		{
			count_rep_iokey++;
			if(count_rep_iokey == IO_NUM_OF_REP)
			{
				count_rep_iokey = 0;
				//printf("\nmessage->msgID = IOKEY_REPEAT\n");
				ResetELWhenOn();
				EvtAppendEvt(EVT_IO_KEY_CTRL, EVT_IO_KEY_REPEAT, 0, pre_iokey_data, NULL);
			}
			
		}
		else
		{
			if(new_and_chg != 0)
			{
				count_rep_iokey = 0;
				ResetIOIntFlag();
				
				//printf("\nmessage->msgID = IOKEY_REPEAT_PRESS\n");
				//printf("\nIO %08x\n", CPU->REG_INT_STATUS_5);
				ResetELWhenOn();
				EvtAppendEvt(EVT_IO_KEY_CTRL, EVT_IO_KEY_PRESS, chg_iokey_data, pre_iokey_data, NULL);
			}
		}
		
		break;
		
	case MSG_POWER_PRESS:
		//      printf("\n power_press\n");
		//                          DisPowerPinInt();
		//                          EnPowerTimerInt();
		//Henry&Brian&Kenny&Andrew
		//                          EvtAppendEvt(EVT_IO_KEY_CTRL, EVT_IO_KEY_PRESS, 0, EVT_POWER_OFF, NULL);
		break;
		
	case MSG_POWER_REPEAT:
		if(message->para1 == 0)
		{
			//                              printf("\nPOWER OFF\n");
			//                              DisPowerTimerInt();
			count_rep_power_pin = 0;
			//                              printf("\n P\n");
			EnIOKeyInt();
			EnPowerPinInt();
			EvtAppendEvt(EVT_IO_KEY_CTRL, EVT_IO_KEY_PRESS, 0, EVT_POWER_OFF, NULL);
			ResetPowerFlag();
		}
		else
		{
			count_rep_power_pin++;
			if(count_rep_power_pin == NUM_OF_REP)
			{
				ELState(&el_status_on);                 
				
				if(el_status_on == FALSE)
				{
					//                                  el_status_on = TRUE;
					count_rep_power_pin = 0;
					EnPowerPinInt();
					DisPowerTimerInt();
					OnEL();
				}
				else
				{
					//                                  el_status_on = FALSE;
					count_rep_power_pin = 0;
					EnPowerPinInt();
					DisPowerTimerInt();
					OffEL();
				}
				
			}
		}
		
		break;
	}
}

