/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   memchk.c
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Memory checking at the start up
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "memchk.h"
extern MatInfoList  mat_info[TOTAL_SLOT];
extern UWORD MemDataCRC;
extern mem_alloc_start;
extern  MemBankMap mem_bank_map[TOTAL_SLOT][MAX_BANK_PER_SLOT];


UWORD SysBlockAddr(MatInfoList* mat, USHORT block_num)
{
	UWORD i;
	
	if(block_num > mat->total_entry)
		return 0;
	
	for(i=0;i<MAX_BANK_PER_SLOT-1;i++)
	{  // find block start bank
		if(mem_bank_map[0][i].mat_start_index > block_num)
			break;
	}
	
	return (mem_bank_map[0][i-1].base_addr +
		(block_num - mem_bank_map[0][i-1].mat_start_index) * BLOCK_SIZE);
	
}


/*
Function         : SysMemMATCheckSum
Purpose          : Calculate the check sum of MAT
Scope            : Internal
Input Parameters : MAT pointer
Output Parameters: None
Return	    : The check sum
Comment          :
*/
UWORD SysMemMATCheckSum(MatInfoList *mat)
{
	UWORD i;
	UWORD check_sum = 0;
	
	for(i=0;i<mat->total_entry;i++)
		check_sum ^= mat->mat[i].id ^ *((UWORD*) (&(mat->mat[i].next)));
	
	return check_sum;
}

Err SysMemCheckMAT(MatInfoList *mat)
{
	/* check sum after the last entry of MAT */
	if(SysMemMATCheckSum(mat) != mat->mat[mat->total_entry].id)
		return ERR_MEM_INV_CHKSUM;    /* not equal means invalid check sum */
	return TRUE;
}


/*
Function         : SysMemDataCheckSum
Purpose          : Calculate the check sum of Data
Scope            : Internal
Input Parameters : None
Output Parameters: None
Return	    : The check sum
Comment          :
*/
UWORD SysMemDataCheckSum()
{
	UWORD i, j;
	UWORD check_sum = 0;
	UWORD addr;
	
	for(i=0;i<TOTAL_SLOT;i++)
	{
		for(j=0;j<mat_info[i].total_entry;j++)
			if((BlockType(mat_info[i].mat[j].attribute) == MAT_BLOCK_DB_REC))
			{
				addr = (SysBlockAddr(&mat_info[i], j));
				check_sum ^= *(UWORD*) addr;// ^ *(UWORD*)(addr + HALF_BLOCK_SIZE) ^ *(UWORD*)(addr + BLOCK_SIZE_MINUS_1);
			}
	}
	
	return check_sum;
}

/*
Function         : SysMemCheck()
Purpose          : Check the SysMem & MAT CRC
Scope            : All
Input Parameters : None
Output Parameters: None
Return           : TRUE      SysMem check sum ok
FALSE     SysMem check sum error
Comment          :
*/
BOOLEAN SysMemCheck()
{
	UWORD i;
	UWORD size, addr;
	UWORD *meminfo = (UWORD*) MEM_INFO_ADDR + 1; /* bank 0 size */
	
	
    size = *meminfo++ - (UWORD) (((UWORD)&mem_alloc_start) & 0x00ffffff) - 15 * BLOCK_SIZE;
	addr = (UWORD) &mem_alloc_start + 10 *BLOCK_SIZE;
    addr +=  BLOCK_SIZE - addr % BLOCK_SIZE;  /* align to Block boundary */
    size -= BLOCK_SIZE - addr % BLOCK_SIZE;  
    size = size - size % BLOCK_SIZE; /* make to 4K multiple */
	
	if( (size - mem_bank_map[0][0].bank_size) > 26 * BLOCK_SIZE)
		//        if((mem_bank_map[0][0].bank_size != size) || (mem_bank_map[0][0].base_addr != addr))
	{
#ifdef DEBUG
		printf("\nFatal error: MAT index 0 error ");
#endif
		return FALSE;
	}
	
	i = 1;
	while(*meminfo)
	{
		addr = *meminfo++;
		size = *meminfo++;
       	addr +=  BLOCK_SIZE - addr % BLOCK_SIZE;  /* align to Block boundary */
        size -= BLOCK_SIZE - addr % BLOCK_SIZE;  
        size = size - size % BLOCK_SIZE; /* make to 4K multiple */
		
		if( (mem_bank_map[0][i].base_addr != addr) ||
			(mem_bank_map[0][i].bank_size != size) )
		{
#ifdef DEBUG
			printf("\nFatal error: SysMem map error");
#endif
			return FALSE;
		}
		i++;
	}
	
	/* skip Mat checking */
#ifdef 0
	for(i=0;i<TOTAL_SLOT;i++)
	{
		if(SysMemCheckMAT(&mat_info[i]) != TRUE)
		{
#ifdef DEBUG
			printf("\nFatal error: MAT CRC error\n");
#endif   
			return FALSE;
		}
	}
#ifdef DATA_CHECK_SUM
	if(MemDataCRC != SysMemDataCheckSum())
	{
#ifdef DEBUG
		printf("\nFatal error: SysMem content CRC error\n");
#endif
		return FALSE;
	}
#endif
#ifdef DEBUG
	printf("\nMat Check OK\n");
#endif
#endif
	return TRUE;
	
}
