#include "datatype.h"
#include "lcddrv.h"
#include "uart.h"

extern UWORD lcd_mem[LCD_SIZE];

int (*out_fct)(UWORD);


int ComOut(UWORD data)
{
	while(UartChkTxDmaBusy(UART_A));
	UartWriteBuf(UART_A, (BYTE*)&data, 4);
	return 0;
}

void PrintScr()
{
	int i, j;
	char cs = 0;
	char *p;
	
	out_fct = ComOut;
	
	for(i=0;i<LCD_SIZE;i++)
	{
		(*out_fct)(lcd_mem[i]);
		p = (char*)(lcd_mem + i);
		for(j=0;j<4;j++)
			cs ^= *p++;
	}
	while(UartChkTxDmaBusy(UART_A));
	UartPutc(UART_A, cs);
}
