/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   smtest.c
Author(s)   :   
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "softtype.h"
#include "software.h"
#include "dev_bety.h"
#include "pr31700s.h"
#include "pr31700c.h"
#include "smisr.h"
#include "telecom.h"
#include "smcmd.h"
#include "uart.h"

#define SM_MAX_MEM_SIZE        65536

#define PROTOCOL_COMPRESS			0x1
#define ADDR_CTRL_COMPRESS			0x2
#define MODEM_ONLINE				0x4

#define V24_TXD 		103
#define V24_RXD 		104
#define V24_RTS 		105
#define V24_CTS 		106
#define V24_DSR 		107
#define V24_CD 			109
#define V24_DTR			108
#define V24_RI			125


int PrintOption = 0;
unsigned char sm_mem[SM_MAX_MEM_SIZE];
void *sm_mem_ptr = (void *)(&sm_mem);

short tel_rx_buf[TEL_BLOCK_SIZE*4];
short tel_tx_buf[TEL_BLOCK_SIZE*4];
short snd_tx_buf[TEL_BLOCK_SIZE*4];

void SmInit();
void SmStatusHandler(modemStatusStruct *status);


void SmStart()
{
    char temp[12];
    int i;
    unsigned char c;
    unsigned char ATcmd[255];
    unsigned char ReadBuffer[255];
    modemCommandStruct sm_cmd;
	
	printf("\nSm Start");
	
    TelInit();
	printf("\nTel Init");
    SmInit();
	printf("\nSm Init");
    SetStatusHandlerCmd();
	printf("\nSetStatus Init");
    TelOnHook();
	printf("\nTel OnHook");
    IdleCmd();
	printf("\nIdle Cmd");
    CPU->REG_SIB_DMA_CTRL |= ENDMARXTEL | ENDMATXTEL;
    CPU->REG_SIB_DMA_CTRL |= ENDMATXSND;
    /* Enable Interrupts */
    CPU->REG_INT_ENABLE_1 |= TEL0_5INT | TEL1_0INT;
	printf("\nEna Int");
    V24CircuitChangeCmd();
	printf("\nV24 Cir");
    StartATModeCmd();
	printf("\nStart AT");
	
	while (1)
	{
		int	bytesRead;
		bytesRead = SoftModemRead(1, ReadBuffer);
		if (bytesRead)
		{
			ReadBuffer[bytesRead] = 0;
			UartPrintf(UART_A, ReadBuffer);
		}
		while (UartRxData(UART_A, &c) == UART_SUCCESS)
		{
           	SoftModemWrite(1, &c);
		}
#if 0
		if (SoftModemCountReadPending() == 0 && SoftModemCountWritePending() == 0)
		{
			/* Suspend CPU only, with Dclock */
			CPU->REG_POWER_CTRL |= 3;
			CPU->REG_POWER_CTRL |= (1<<4);
			
		}
#endif
	}
    while(1);
}

void SmInit()
{
    unsigned char *s_ptr, *e_ptr;
    short *rx_s_ptr, *tx_s_ptr, *rx_e_ptr, *tx_e_ptr;
	
    /* Clear memory for softmodem.o */
    s_ptr = sm_mem_ptr;
    e_ptr = s_ptr + SoftModemGetMemorySize();
    do
    {
        *s_ptr = 0;
    } while (++s_ptr != e_ptr);
	
    /* Clear DMA buffer */
    rx_s_ptr = tel_rx_buf;
    tx_s_ptr = tel_tx_buf;
    rx_e_ptr = rx_s_ptr + TEL_BLOCK_SIZE*2;
    do
    {
        *rx_s_ptr++ = *tx_s_ptr++ = 0;
    } while (rx_s_ptr != rx_e_ptr);
	
    SoftModemSetMemoryPtr(sm_mem_ptr);
    SoftModemInit();
}


void SmStatusHandler(modemStatusStruct *status)
{
    char temp[12];
    char statusString[256];
    extern void StatusParser(modemStatusStruct *status, char *dst);
    extern void ATPrintf(uchar *format, void *arg1, void *arg2, void *arg3);
	
	if (PrintOption)
	{
        StatusParser(status, statusString);
		if (statusString[0])
			ATPrintf("%s\n", statusString, nil, nil);
	}
	
    switch(status->code)
    {
	case kSetSampleRate:
		break;
	case kHookStateChange:
		if (status->param.value)
		{
			TelOnHook();
		}
		else
		{
			TelOffHook();
		}
		break;
	case kSpeakerStatus:
		if (status->param.speakerStatus.enabled)
			CPU->REG_SIB_CTRL |= ENSND;
		else
			CPU->REG_SIB_CTRL &= ~ENSND;
		break;
	case kATDebugStatus:
		switch (status->param.value)
		{
		case 1:
			PrintOption = !PrintOption;
			break;
		case 2:
			RingIndicatorCmd(true);
			break;
		case 3:
			RingIndicatorCmd(false);
		default:
			break;
		}
		break;
        case kV24CircuitStatusChange:
			switch (status->param.v24Circuit.code)
			{
			case V24_CD:
				//        			if(status->param.v24Circuit.value) ppp_status |= MODEM_ONLINE;
				//        			else ppp_status &= ~MODEM_ONLINE;
				break;
			default:
				break;
			}
			break;
			default:
				break;
    }
}


void HostPutc(int a)
{
	UartPutc(UART_A, a);
}
