/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sndres.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   sound resource
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "datatype.h"
#include "sndres.h"

//*************************************
// ------- Play beep sound form compressed samples
// ------- Change together with SndMgr.c
//#define       PLAY_COM_BEEP
//*************************************
//2
const BYTE SND_SHARP[SND_SHARP_SIZE] = {
  0,	  2,	  5,	  0,	  0,
-43,	127,	-33,	 -1,	 -1,
-33,	-11,	127,	-60,	-22,
-110,	-20,	126,	-79,	120,
-21,	-58,	 -1,	-86,	-66,	
  1,	 83,	-81,	-16,	-49,	
-58,	 23,	-60,	107,	 -8,	
 15,	-16,	  0,	  5,	 63,	
-49,	 -3,	 27,	-32,	  5,	

  3,	  0,	-10,	 -1,	 -7,	
-101,	-66,	-26,	 16,	 21,	
 -3,	126,	-128,	107,	-19,	
 78,	 95,	-63,	-30,	-127,	
-76,	 59,	 87,	-53,	-78,	
-117,	-64,	107,	-12,	 -3,	
 61,	 59,	 44,	107,	 91,	
-48,	 42,	-58,	-109,	-20,	
 -7,	126,	 78,	-82,	

  3,	 -1,	 -7,	  3,	  3,	
 87,	-11,	-23,	 40,	 45,	
127,	-22,	 30,	 70,	-79,	
-96,	126,	 70,	-117,	 91,	
-56,	-64,	-82,	 -7,	126,	
 69,	 63,	  0,	127,	 44,	
 11,	-57,	-25,	-75,	125,	
 59,	-62,	-28,	 76,	 47,	
125,	-88,	 57,	-79,	

  7,	 -7,	 -3,	  3,	-112,	
-75,	-25,	-21,	111,	  2,
 70,	 86,	-44,	 -7,	-122,	
-88,	-43,	 79,	-109,	-39,	
-84,	 22,	 -3,	125,	 85,	
113,	-76,	-107,	-20,	127,	
 92,	-66,	 70,	-15,	106,	
 95,	-59,	125,	-123,	 74,	
-81,	 85,	-11,	-17,	

 13,	-12,	 -2,	 -5,	-18,	
 -4,	  1,	-70,	 31,	-12,
 16,	108,	 43,	-41,	 -4,	
 31,	-30,	 10,	-65,	 80,	
-67,	 79,	-44,	 42,	-59,
 90,	-37,	-127,	122,	 78,
-67,	  2,	-81,	-59,	 63,
 98,	-112,	 42,	  0,	 -1,
  7,	-22,	-63,	 58,

 14,	  7,	 -1,	  6,	-46,
 49,	 79,	-107,	-32,	120,
 61,	106,	 71,	 -1,	 -5,
-85,	 -4,	 10,	 55,	-86,
 43,	 -1,	 -6,	 -1,	  0,
-81,	 45,	-29,	-88,	 -3,
 95,	-47,	-10,	-87,	 23,
 -3,	 93,	 81,	-72,	-95,
-11,	 -7,	 95,	 87,

};

//3
const BYTE SND_ZHARP[SND_ZHARP_SIZE] = {

  0,	  2,	  0,	  2,	  0,
117,	 85,	 31,	 -1,	 21,	
 84,	 64,	 15,	-59,	 85,	
  1,	-63,	 84,	 31,	 -1,	
-17,	-82,	-16,	 85,	 85,	
  0,	  3,	 11,	123,	-79,	
-13,	-37,	 -2,	 85,	 85,	
 86,	 -3,	 -1,	 -2,	-64,
 92,	 76,	 40,	109,	-128,	

 13,	 -7,	  4,	  0,	 55,	
 48,	 64,	 16,	 81,	 95,	
-43,	 81,	 79,	-12,	-49,	
 95,	 93,	 -3,	 37,	113,	
 -3,	 93,	 85,	126,	111,	
 -2,	-61,	-111,	-11,	 87,	
-81,	 -5,	-88,	 84,	-18,	
 85,	 63,	-82,	-68,	 80,
-27,	127,	 -7,	-61,	

 14,	 -1,	 -1,	 -2,	 -8,
 13,	 60,	 83,	-107,	 45,	
 59,	 -1,	-36,	  0,	 69,	
-128,	 54,	-23,	 15,	 95,	
 -8,	112,	 21,	 87,	-101,	
-50,	 27,	-62,	-39,	 92,	
-86,	 -1,	-105,	-88,	 65,	
  1,	 80,	-28,	122,	-23,	
-17,	-92,	 45,	 13,	

 14,	  2,	  3,	 -1,	 68,	
-124,	 37,	 22,	-65,	 47,	
-20,	 75,	 44,	 14,	-60,	
 18,	  0,	 88,	-83,	127,	
-81,	 -5,	 81,	 64,	 87,	
 89,	-126,	-86,	-87,	 61,	
103,	 -3,	-86,	-48,	-86,	
-43,	 79,	 11,	-126,	-63,	
 84,	-125,	-81,	 -2,	

  5,	  0,	 -1,	  0,	 21,	
-26,	-65,	-31,	  5,	 85,
 82,	-81,	-85,	-23,	 24,	
 12,	 21,	 74,	-109,	  6,	
-78,	 90,	-55,	 89,	 59,	
-13,	-81,	-114,	-85,	 67,	
 53,	 83,	 -5,	 80,	105,	
-97,	-82,	-88,	  5,	 43,	
 81,	 85,	 72,	 31,

 11,	  1,	 -1,	  0,	-22,	
-81,	-69,	-66,	 64,	 21,	
 84,	 20,	-21,	-82,	-69,	
-82,	-11,	 96,	  4,	-43,	
 95,	127,	-66,	 83,	-63,	
-37,	 89,	121,	-33,	-18,	
 64,	 81,	  4,	  6,	112,	
-67,	 -1,	-112,	 18,	-102,	
-69,	  7,	 82,	 16,

};

//4
const BYTE SND_BWOO[SND_BWOO_SIZE] = {

  0,	 62,	-46,	 29,	-17,
 85,	127,	-13,	 61,	 -9,
-40,	-120,	-43,	 -1,	 85,
 63,	 -3,	 85,	 87,	 -1,
 -3,	 85,	 23,	-13,	-75,
 38,	111,	 59,	 22,	102,
-13,	 49,	 38,	124,	-52,
 73,	-97,	 51,	 18,	103,
-52,	-42,	103,	-52,	-42,

 47,	-39,	 32,	-29,	103,
 43,	-103,	-109,	 59,	 64,
108,	-52,	101,	-30,	-122,
 99,	 40,	 73,	 -8,	-44,
-113,	-115,	 74,	 -6,	 86,
 63,	  5,	111,	-55,	 75,
-16,	 82,	 -4,	 86,	-68,
 22,	-68,	 20,	 -2,	 86,
-68,	 86,	 -4,	 87,	

 55,	-53,	 15,	 -8,	-22,	
-120,	 55,	  8,	-120,	-118,	
 32,	-23,	-109,	-60,	123,	
 22,	-67,	 75,	-60,	 62,	
 82,	-11,	-97,	 70,	-55,
 15,	 64,	-12,	 46,	 19,	
-63,	-84,	 94,	-46,	-79,	
122,	 75,	-112,	-31,	 61,	
 11,	 19,	-58,	-79,	

 39,	-73,	 30,	-26,	-116,	
-93,	  8,	-99,	-62,	 34,	
 48,	-99,	 34,	 14,	115,	
 14,	-85,	-100,	-37,	-82,	
-61,	-118,	-45,	-117,	-38,
-33,	-85,	-97,	115,	 12,	
115,	 61,	-56,	-77,	-77,	
-93,	-98,	 59,	-66,	-72,	
-25,	-113,	 58,	 57,	

 40,	-29,	 22,	-27,	-29,
 58,	-68,	-22,	-29,	-70,
-13,	 51,	 99,	-85,	 -2,
-86,	-128,	 -2,	123,	 15,
-69,	-13,	 48,	 15,	 -1,
 85,	127,	-11,	 87,	 -4,
 85,	 -1,	-43,	127,	-59,
 15,	-55,	103,	-31,	 89,
-13,	 88,	 -8,	 86,

 42,	-35,	  6,	-13,	 50,
-126,	104,	-26,	104,	-39,
-94,	 98,	-32,	 75,	-28,
111,	-43,	-69,	 68,	 -8,
 91,	-31,	 47,	-108,	-68,
 91,	-31,	 62,	 16,	-15,
107,	-106,	-71,	 78,	-106,
-71,	110,	 16,	-31,	124,
 26,	-60,	-23,	107,

};

//6
const BYTE SND_DONEDONE[SND_DONEDONE_SIZE] = {

  0,	 28,	 -2,	  1,	-12,
 95,	 -1,	 85,	 95,	 -1,
 85,	 95,	 -1,	 85,	 95,
 -1,	-107,	 87,	-21,	-44,
  7,	-21,	-42,	 23,	-54,
-48,	  7,	-85,	-42,	  7,
-53,	-28,	  5,	-14,	-76,
  5,	-14,	-76,	  5,	-24,
-11,	-127,	-24,	 -3,	  9,

 27,	  0,	  0,	-12,	-24,
-28,	 37,	122,	 57,	  0,
122,	-67,	 96,	122,	-83,
 97,	122,	 61,	105,	 78,
 43,	 66,	 78,	 47,	 90,
 78,	 46,	 72,	 30,	-85,
 88,	 30,	-85,	 16,	 87,
-93,	-48,	-121,	-93,	-48,
-105,	-62,	-48,	-109,

 33,	 -3,	  2,	 -6,	-118,	
-106,	  3,	-54,	-102,	 34,	
 37,	 -1,	 -1,	-43,	 85,	
127,	 -1,	-11,	 68,	 79,	
-22,	 -7,	 88,	 68,	 -6,	
-69,	 86,	 17,	 62,	-85,	
-27,	  1,	 31,	-53,	-71,	
 64,	 20,	 -6,	-69,	 80,	
 17,	 62,	-82,	-43,	

 32,	  0,	  0,	 -7,	-124,	
 79,	-86,	 -3,	 64,	 19,	
-22,	-17,	 80,	  5,	 62,	
-85,	-43,	-124,	 79,	-117,	
-71,	 64,	 23,	-22,	-66,	
 80,	  5,	 -6,	-81,	-108,	
  1,	 95,	-86,	-27,	  0,	
 87,	-22,	-69,	 80,	  5,	
 -6,	-82,	-44,	  1,	

 32,	  0,	  0,	 -6,	 79,	
-86,	-27,	  1,	 23,	-22,
-71,	 64,	 20,	 -6,	-81,	
-107,	-127,	 62,	-85,	-27,	
  0,	 79,	-85,	-67,	 88,	
 17,	 -8,	-70,	-44,	  1,	
126,	 43,	-91,	  0,	 31,	
-86,	 -7,	 64,	 68,	-14,	
-85,	 86,	 17,	 62,	

 26,	  0,	  0,	-12,	 47,
-48,	-111,	 78,	 43,	-71,
 -1,	-11,	 85,	 -1,	-11,	
 69,	 -8,	 -3,	  1,	124,	
-83,	  1,	124,	-83,	  1,	
124,	-83,	  1,	124,	-83,	
  0,	110,	-65,	 64,	 95,	
 43,	 64,	 95,	 43,	 64,	
 95,	 43,	 64,	 94,	

 27,	  0,	  0,	-12,	-113,
 88,	 30,	-113,	-48,	-109,	
-93,	-48,	-105,	-93,	-112,	
  7,	-85,	-42,	  7,	-86,	
-12,	  7,	-54,	-42,	  5,	
-24,	-12,	 36,	-24,	-12,	
 36,	-30,	-12,	 33,	-22,	
-67,	 96,	122,	 49,	  1,	
122,	 61,	  8,	122,	

 38,	-10,	  7,	 -5,	 49,	
 64,	 62,	 41,	 64,	 63,	
 42,	 80,	 15,	-86,	 72,	
-120,	-126,	 33,	 95,	 95,	
 -1,	 -1,	-11,	 85,	 85,	
 95,	 -1,	-69,	-27,	 80,	
 17,	 31,	-22,	-21,	-75,	
 73,	-111,	 67,	 -6,	-24,	
-27,	 96,	 17,	 95,	

 38,	 -2,	  0,	 -4,	-22,	
-84,	-83,	 88,	  0,	 87,	
 -2,	-85,	121,	 90,	  4,
 71,	 -4,	-85,	109,	 92,	
  2,	 83,	-22,	-82,	-119,	
 87,	  0,	 87,	-13,	-86,	
-55,	 82,	  0,	 87,	 -5,	
-86,	-55,	 84,	-60,	  5,	
 -2,	-86,	-31,	 86,	

 40,	 -6,	  2,	 -5,	-112,	
 68,	 -4,	-22,	-22,	 85,	
-128,	 69,	 -4,	-70,	-70,
 84,	 36,	 68,	 -2,	 59,	
-82,	 84,	 36,	 17,	 -2,	
 46,	-21,	 84,	-103,	  1,	
-66,	-85,	-69,	 84,	  0,	
 68,	 -2,	-85,	-69,	 21,	
  1,	 23,	127,	-86,	

 35,	  5,	 -7,	 -2,	110,	
-107,	-64,	-128,	 62,	 42,
-65,	-43,	-91,	 80,	127,	
-86,	-19,	 20,	  4,	-28,	
-65,	-110,	-94,	-76,	-120,	
 37,	124,	 43,	 -1,	-43,	
 64,	 68,	 -2,	-82,	 90,	
-107,	 60,	  8,	 48,	 32,	
-113,	-12,	-87,	 85,	

 36,	  1,	 -7,	 -2,	 94,	
 -6,	-17,	 84,	-111,	 56,	
 47,	-27,	-96,	 14,	 40,	
-71,	 92,	 19,	 -2,	-74,	
 80,	 20,	126,	-86,	-42,	
-124,	 31,	-86,	-75,	 87,	
 -1,	 -1,	-19,	 87,	 16,	
 87,	-29,	-82,	-51,	 66,	
 16,	 87,	-29,	-82,	

};	//529

//7
const BYTE SND_VEEWOO[SND_VEEWOO_SIZE] = {

  0,	  0,	-17,	 -3,	 -8,
 95,	 -1,	 85,	 -1,	-107,
 95,	117,	 87,	-35,	-43,
 -9,	117,	109,	-39,	 91,
 98,	 23,	-52,	-43,	-30,
 37,	-78,	 37,	120,	-127,
124,	-55,	122,	-123,	-13,
  5,	-22,	 23,	-51,	 94,
 49,	120,	-107,	-40,	 91,

 -6,	-24,	 -6,	-17,	112,
124,	-59,	-56,	 31,	 49,
122,	-121,	-52,	 92,	-123,
-13,	 23,	101,	124,	-42,
-35,	 93,	-107,	-56,	 92,
-121,	-55,	 50,	109,	 28,
 95,	 95,	 95,	 95,	 78,
109,	125,	 53,	-10,	-41,
 31,	125,	-76,	-37,	

-71,	-84,	-55,	-24,	108,	
  6,	-111,	 48,	 24,	 50,	
-19,	123,	 24,	  7,	 21,	
 -1,	-80,	 12,	-126,	114,	
-99,	-54,	119,	 62,	-39,	
-18,	 39,	 52,	 74,	-39,	
-52,	-107,	 68,	 99,	 38,	
 59,	-95,	 90,	-47,	-19,	
 24,	-120,	 11,	-69,	

-35,	 31,	 25,	 -3,	 34,	
-126,	-126,	  2,	-79,	-122,	
-102,	 88,	-88,	-17,	 -4,	
-59,	  1,	-26,	-58,	-45,	
-106,	-72,	-66,	-11,	-92,	
-125,	-124,	 14,	 36,	-58,	
-33,	126,	-29,	-24,	108,	
-11,	  5,	 65,	 11,	 -6,	
-65,	-24,	 66,	-108,	

 11,	 18,	  7,	 -7,	 88,	
  9,	-68,	 50,	-14,	-112,	
-55,	-10,	 82,	 55,	 63,	
-98,	  9,	100,	-32,	126,	
-109,	  4,	-38,	 77,	 12,	
-23,	-65,	-113,	 36,	100,	
-44,	-69,	-85,	-70,	 33,
-109,	 84,	 69,	 67,	 -5,	
-114,	-45,	 12,	 39,	

-20,	 41,	 16,	-12,	-84,	
 79,	 60,	 30,	 68,	 26,	
 60,	-65,	 -5,	-111,	-105,	
 73,	-125,	 79,	 14,	-10,	
-115,	 13,	 59,	119,	 92,	
-48,	-38,	  3,	 39,	115,	
 55,	 98,	110,	  1,	 29,	
-36,	-34,	-52,	-95,	  7,	
 71,	103,	 96,	120,	

-40,	 30,	 37,	  1,	 78,	
 -7,	-23,	-56,	-112,	 34,	
 71,	119,	 64,	-82,	-51,	
-52,	-58,	 84,	 52,	 99,	
-49,	-18,	-114,	  4,	 84,	
105,	 16,	-85,	-73,	 -8,	
-19,	-40,	119,	116,	-35,	
-37,	119,	 29,	-114,	103,	
 45,	-38,	 55,	-119,	

-74,	-86,	-52,	-21,	-43,	
-15,	126,	-120,	 34,	-84,	
  7,	 -4,	  4,	 89,	  3,	
-116,	-77,	 28,	112,	-37,	
109,	-77,	-97,	 57,	-12,	
-110,	 77,	 97,	-28,	-61,	
 31,	 78,	 45,	105,	 45,	
 61,	 61,	 60,	109,	111,	
127,	127,	 95,	 31,	

-12,	-25,	-13,	-12,	 86,
-51,	 51,	 95,	-79,	-77,	
 23,	-20,	 95,	-80,	126,	
-63,	 51,	  5,	-69,	-91,	
123,	-23,	 76,	-24,	 27,	
-70,	  5,	-17,	-96,	 92,	
-22,	 37,	-17,	-22,	 19,	
-65,	-88,	 88,	-88,	  1,
 80,	-86,	-86,	-128,	

 11,	-16,	  1,	 -8,	 15,
 -1,	 58,	-69,	-83,	-123,	
 32,	-123,	 64,	 -2,	-123,	
 75,	 -2,	 22,	 63,	-15,	
 85,	-81,	-43,	  2,	 -3,	
 66,	123,	-48,	-125,	-11,	
-116,	 -3,	 98,	 63,	 72,	
-81,	-104,	-113,	-41,	115,	
-12,	-118,	-11,	-36,	

  9,	-24,	  3,	-14,	 -7,	
-120,	-67,	 34,	 61,	102,	
 61,	102,	 61,	102,	 61,	
102,	125,	 34,	 61,	  0,	
 57,	  8,	-11,	 25,	-11,	
-104,	-10,	 35,	-58,	 99,	
-46,	 43,	-103,	-113,	 89,	
-116,	102,	 61,	102,	 53,	
-104,	-10,	 43,	-42,	

  0,	-19,	 -4,	-14,	 99,	
-103,	-113,	 64,	 45,	 70,	
 61,	-120,	-11,	 16,	-44,	
 99,	-103,	-113,	 64,	-83,	
102,	 57,	-104,	-12,	  2,	
-42,	 99,	-103,	-113,	 81,	
 13,	102,	 61,	-120,	-11,	
 16,	-58,	 99,	-48,	 11,	
 81,	 15,	 64,	 61,	

  8,	-24,	  1,	-15,	102,	
 61,	  0,	-75,	 16,	-12,
  2,	-26,	 35,	-42,	107,	
-48,	 15,	 17,	 15,	 89,	
-113,	 64,	-82,	 98,	-67,	
 70,	 61,	102,	 61,	102,	
 61,	 34,	 61,	  0,	-67,	
 34,	-67,	 34,	 -3,	 38,	
-67,	102,	 61,	102,

 10,	-23,	  3,	-13,	 61,	
102,	 61,	102,	 62,	 98,
 63,	 73,	-113,	 89,	-113,	
-104,	-117,	-42,	 99,	-58,	
 98,	-12,	-120,	 -7,	-128,	
-67,	102,	 63,	 73,	-113,	
-40,	-117,	-58,	 99,	-11,	
-104,	 -3,	  4,	107,	 72,	
-113,	-46,	 35,	-12,	

  5,	-17,	  0,	-10,	-120,	
 -3,	102,	 59,	 89,	-118,	
-42,	 98,	-71,	-120,	-65,	
 98,	-81,	-42,	 99,	-75,	
-104,	-81,	 64,	 11,	-42,	
 99,	-67,	-104,	-81,	 89,	
-118,	-12,	  0,	-67,	 70,	
123,	-44,	102,	 57,	  8,	
-81,	 81,	-104,	-11,	

 12,	-21,	  4,	-11,	 25,	
-49,	 64,	-114,	-12,	  0,	
-81,	 80,	 11,	-12,	  0,	
-81,	 81,	  2,	-11,	-104,	
-17,	 88,	-82,	-11,	 17,	
-97,	 81,	  8,	 -7,	-104,	
-81,	-48,	 10,	-67,	 68,	
 99,	-60,	 64,	-81,	 89,	
-118,	-15,	 16,	-113,	

 19,	-23,	  7,	 -9,	-42,	
 99,	 62,	 68,	 64,	-11,	
-103,	-117,	-48,	 35,	-65,
 98,	 42,	-15,	 16,	-117,	
-43,	 80,	 63,	 89,	-116,	
 -3,	 68,	  2,	-11,	 16,	
 11,	-44,	 98,	-81,	-111,	
  0,	-65,	 81,	  2,	 -4,	
 68,	 66,	 -3,	-104,	

 11,	-14,	  2,	 -7,	-126,	
-15,	 80,	 43,	 -7,	 10,	
 -1,	-16,	 68,	  2,	-123,
 80,	-65,	 -8,	  0,	 47,	
 -6,	-82,	-66,	-98,	 -1,	
-41,	115,	-11,	-100,	-17,	
 64,	-113,	-41,	115,	-67,	
-118,	-65,	 89,	-118,	-12,	
  8,	-19,	103,	 59,	

  8,	-18,	  1,	-10,	-48,	
 35,	-67,	-104,	-81,	 81,	
-104,	-11,	 25,	-49,	 64,	
-114,	-12,	  0,	-81,	 80,	
 11,	-12,	  0,	-81,	 81,	
 10,	-11,	  2,	 -1,	 88,	
-82,	-11,	 17,	-113,	 81,	
  8,	 -7,	-104,	-17,	-48,	
 10,	-67,	 68,	 99,	

};	//837

//8
const BYTE SND_KOOKOO[SND_KOOKOO_SIZE] = {

  0,	 17,	  8,	  5,	 -8,
 85,	127,	 -1,	 85,	 85,
111,	 -1,	-15,	 84,	 31,
 59,	-19,	 73,	 83,	 98,
-64,	-43,	 84,	 75,	126,
-41,	 31,	 86,	-37,	-110,
-17,	 34,	 92,	 98,	-65,
 93,	  1,	 97,	-71,	 61,
-11,	 36,	-92,	 11,	-115,

 26,	 -2,	 14,	-12,	-115,
 48,	-106,	-93,	 47,	 13,
 21,	 92,	-23,	 -8,	 25,
 93,	 18,	-54,	-72,	-60,
 66,	-115,	-57,	 -2,	 77,
 22,	-109,	-22,	-96,	110,
 94,	101,	-20,	114,	 48,
 12,	 97,	121,	114,	-118,	
-44,	 71,	 99,	125,

 19,	-12,	 19,	 -4,	107,	
-22,	-106,	 64,	111,	-66,	
-91,	 37,	 43,	-10,	-38,	
-36,	-42,	 37,	 14,	-122,	
-89,	-100,	-106,	 74,	125,	
-63,	 50,	 14,	  1,	110,	
-23,	-11,	 73,	-106,	-93,	
 30,	-55,	-42,	103,	-95,	
-118,	 87,	 60,	 14,	

 19,	-12,	 15,	 -5,	 88,	
-16,	-64,	-59,	110,	 76,	
-60,	 55,	-21,	-12,	 27,	
 66,	122,	-81,	-96,	 69,	
 19,	-67,	-67,	 13,	-87,	
 38,	-105,	-88,	-32,	 86,	
118,	-22,	-44,	 83,	-110,	
-36,	 13,	 50,	 98,	-85,	
-48,	 20,	126,	-68,	

 19,	-11,	 16,	 -9,	-95,
-59,	-101,	102,	-97,	-120,	
-31,	 82,	 79,	 58,	-44,	
 46,	 60,	-88,	-83,	 69,	
-61,	 -2,	 32,	-107,	 54,	
-76,	-27,	 27,	  7,	 98,	
 61,	-55,	 69,	 94,	-21,	
-23,	105,	-112,	-66,	-28,	
-59,	 22,	 35,	-21,	

 25,	 -7,	 14,	-10,	 17,	
 20,	-34,	 15,	 88,	 78,	
112,	106,	 59,	 69,	-104,	
 46,	 62,	-75,	 72,	-89,	
-13,	-84,	 22,	 90,	-18,	
-15,	-39,	 92,	-52,	 40,	
113,	-91,	 42,	  6,	-12,	
 25,	104,	-13,	-26,	-43,	
-102,	 31,	-20,	-102,	

 29,	 -5,	 14,	-13,	 69,	
-125,	-65,	 67,	 69,	 41,	
 60,	 38,	 18,	-107,	-93,	
 15,	 96,	 66,	-41,	 -8,	
-36,	 90,	 78,	 44,	-19,	
 52,	 80,	-36,	 -4,	 97,	
  1,	-118,	-61,	-31,	-45,	
 66,	 58,	126,	-112,	 64,	
 78,	 13,	-91,	 65,	

 29,	  1,	 11,	-16,	121,	
-19,	-58,	  5,	  7,	 -4,	
-32,	-106,	-42,	 59,	-116,	
-99,	 37,	-104,	-14,	-71,	
 73,	 77,	-73,	 52,	-95,	
-46,	-41,	-86,	 20,	  1,	
 59,	-113,	-47,	  4,	 72,	
-19,	-79,	-43,	  9,	-98,	
-52,	-76,	 23,	-110,	

 31,	  2,	 10,	-19,	-26,	
-113,	-48,	 46,	107,	-119,
 38,	 90,	122,	-10,	101,	
 37,	-93,	-25,	-128,	-47,	
 98,	-65,	-40,	-106,	 96,	
 31,	 56,	118,	 89,	-124,	
-77,	 36,	 84,	-106,	-30,	
-10,	 23,	  3,	 79,	-97,	
118,	 98,	 79,	-125,	

 31,	 -2,	 13,	-17,	 33,
  9,	106,	-16,	-55,	-11,	
 94,	 78,	 15,	-108,	-123,	
-68,	-34,	  2,	 38,	 77,	
-68,	  3,	 21,	-119,	 59,	
-55,	  5,	-108,	-74,	 -8,	
-45,	 70,	  7,	-70,	-68,	
 71,	 86,	-84,	-116,	  4,	
 65,	-44,	-10,	 52,	

 27,	  9,	  4,	-16,	 90,
 91,	107,	-60,	-128,	  3,	
-98,	-34,	-102,	 68,	126,	
 59,	-40,	 68,	 99,	124,	
120,	-91,	-122,	 50,	 -9,	
-115,	-106,	-89,	 60,	-58,	
-57,	107,	105,	-24,	  1,	
-75,	 58,	-56,	-47,	 94,	
 75,	-10,	-64,	-111,	

 32,	 -1,	 10,	-16,	-101,	
 31,	-128,	-47,	  3,	114,	
-97,	 88,	 96,	126,	 78,	
-92,	-44,	 36,	-69,	 60,	
 20,	 52,	-85,	-72,	 19,	
 85,	114,	 60,	 13,	-108,	
  7,	-83,	 -7,	 57,	 44,	
-45,	-57,	 52,	 12,	 27,	
-78,	-59,	-48,	  3,	

 29,	  5,	  5,	-14,	-117,	
 37,	 53,	 93,	 62,	 55,	
-124,	-91,	123,	-117,	-91,
-64,	-100,	-100,	 43,	 17,	
  9,	-30,	-115,	 36,	 86,	
-99,	 -4,	 38,	101,	-55,	
-49,	 49,	  9,	 86,	 59,	
-121,	-112,	 72,	 83,	 12,	
 60,	 70,	 96,	126,	

 27,	 10,	  3,	-16,	-36,	
 53,	121,	-88,	-24,	 39,
-107,	-52,	 59,	-127,	 20,	
  3,	-19,	-84,	-112,	 89,	
121,	-16,	 -7,	 64,	  2,	
 44,	 -8,	 86,	 90,	-41,	
-40,	 93,	 64,	 75,	 50,	
-44,	-122,	110,	-113,	 32,	
117,	 54,	111,	-109,	

 30,	  4,	  6,	-16,	-59,	
 33,	114,	-82,	-112,	-123,
-36,	111,	-119,	-48,	-124,	
 -8,	 -3,	 16,	-124,	110,	
 -7,	-58,	-106,	-109,	-77,	
 78,	 85,	 27,	103,	-26,	
-120,	 90,	114,	 62,	-71,	
 39,	 91,	 48,	-26,	100,	
101,	-20,	 19,	 37,	

 36,	 -2,	-17,	  0,	 16,	
 92,	 62,	-84,	-103,	 66,	
-49,	-68,	-127,	 84,	 97,	
 -4,	-36,	 84,	  4,	-100,	
 -4,	 20,	  3,	-106,	 -1,	
 37,	123,	  5,	-65,	-75,	
 35,	-59,	 43,	-28,	-109,	
-27,	 19,	-23,	 19,	-31,	
 19,	-84,	-105,	-20,	

 23,	  1,	-22,	 -6,	 82,	
 30,	-37,	 14,	-102,	 92,	
-110,	 30,	-104,	 90,	-114,	
-100,	-127,	 88,	-67,	 12,
 45,	 85,	105,	 14,	 61,	
 69,	105,	 48,	 61,	 37,	
121,	-96,	120,	 36,	120,	
-80,	114,	-91,	122,	-74,	
 51,	-74,	 70,	-91,	

 23,	  3,	-24,	 -6,	 51,	
-77,	-122,	 37,	 55,	-13,	
-57,	-110,	 23,	-85,	-53,
 10,	-105,	-21,	-45,	 30,	
-109,	 31,	-97,	-114,	-45,	
 94,	-117,	-114,	-104,	 88,	
 14,	 15,	-103,	 89,	105,	
-120,	 61,	 89,	105,	105,	
121,	  9,	105,	-92,	

 28,	 -2,	-19,	 -5,	125,	
 36,	113,	-122,	 57,	-91,	
102,	  4,	 63,	 54,	  6,
  4,	 59,	-10,	-105,	 38,	
-109,	-13,	-109,	  2,	 23,	
-81,	-45,	 12,	-105,	 15,	
-40,	-102,	-103,	-116,	 -3,	
-116,	 73,	-120,	-67,	-64,	
 33,	 65,	 49,	-27,	

 31,	 -1,	-19,	 -2,	113,	
  4,	  2,	101,	 52,	 65,	
 99,	-29,	-61,	  5,	 67,	
-113,	123,	 65,	 80,	 14,	
-49,	 37,	 21,	 25,	-128,	
-26,	-103,	 13,	-69,	 -1,	
-120,	 25,	 58,	 -2,	-63,	
 69,	118,	-84,	-92,	 85,	
 32,	-17,	-24,	  5,	

 39,	 -3,	  0,	-10,	104,	
 76,	-67,	 22,	 49,	  3,	
-72,	101,	 42,	 86,	 62,	
-107,	 12,	  4,	-65,	-91,	
 12,	 18,	127,	-31,	-105,
105,	 67,	-23,	-111,	-63,	
 66,	 47,	-44,	-96,	 81,	
111,	-32,	122,	-91,	 95,	
-22,	 39,	-87,	 88,	

 38,	  1,	 -9,	 -5,	 63,	
-124,	-116,	 85,	 47,	-92,	
 58,	-107,	 75,	-68,	 35,	
-23,	 83,	127,	 11,	-23,
-43,	-117,	106,	-77,	 21,	
-116,	 40,	-117,	-43,	 94,	
 54,	 51,	-39,	 18,	-58,	
 57,	-12,	 65,	 35,	 95,	
-115,	 37,	-122,	108,	

 30,	 11,	  3,	-20,	-62,	
100,	 48,	 30,	 58,	 36,	
-97,	 16,	-18,	-108,	-122,	
-103,	123,	 37,	 82,	 17,
  7,	 -8,	 84,	-31,	120,	
-65,	-107,	-116,	 70,	-17,	
-111,	-66,	 81,	 78,	-76,	
 11,	-108,	-119,	-56,	 94,	
 57,	  8,	 -3,	  7,	

 32,	  1,	 10,	-19,	-42,	
-123,	-65,	 54,	 48,	  5,	
-117,	-22,	 96,	-43,	 18,	
-70,	 53,	-87,	 84,	-68,	
 32,	-11,	 37,	 77,	-12,	
-72,	-107,	  0,	 39,	113,	
-59,	 82,	 59,	 79,	-119,	
 80,	  7,	 11,	-89,	-122,	
 52,	-20,	-20,	 52,	

 27,	 19,	  1,	-20,	  0,	
 31,	 69,	-31,	 22,	-82,	
-51,	 50,	-110,	-81,	 -5,	
-26,	 88,	-118,	-63,	-75,	
-43,	 73,	 97,	-100,	-107,	
112,	  6,	-102,	 55,	 24,
110,	-53,	-64,	 -7,	  7,	
 -5,	108,	116,	-108,	-84,	
 39,	-102,	-107,	 74,	

 29,	 11,	  9,	-23,	-88,	
 92,	-87,	 84,	 37,	-15,	
-36,	 64,	 96,	106,	-51,	
-123,	-41,	-114,	 -8,	-10,	
 12,	 30,	-21,	-74,	 20,
-32,	  7,	-10,	 16,	117,	
116,	-26,	-124,	-31,	-47,	
-50,	-32,	 36,	114,	-89,	
 26,	-79,	 85,	 63,	

 30,	  6,	-12,	-10,	-60,	
 29,	101,	 80,	 -5,	 54,	
  0,	 37,	  3,	 -1,	-111,	
 30,	105,	-113,	-68,	 69,	
 75,	-94,	-117,	-50,	 85,
-17,	-71,	  6,	 99,	 36,	
 -1,	-76,	 16,	-82,	-36,	
109,	 33,	 85,	126,	-90,	
-46,	 28,	 64,	-49,	

 31,	  3,	 -9,	-13,	-83,	
  6,	 67,	-126,	 -2,	-55,	
 17,	 46,	-115,	 17,	117,	
  2,	127,	-46,	 20,	 76,	
-104,	-50,	113,	 69,	 58,	
-93,	-61,	  9,	 82,	 15,	
 57,	 69,	114,	 71,	 52,	
 64,	 81,	-13,	-48,	  1,	
 67,	 34,	 -1,	-123,	

 39,	 -3,	 -8,	 -7,	 80,	
-113,	-38,	 -6,	 97,	 84,	
 59,	-126,	-37,	 73,	 83,	
-113,	-55,	-126,	 40,	 82,	
 55,	-11,	 27,	-118,	-111,	
 76,	-91,	 98,	127,	-44,	
  3,	 34,	-99,	 -2,	 37,
 64,	 63,	  5,	-118,	101,	
 67,	-113,	 81,	 88,	

 36,	  3,	-15,	 -6,	 41,	
-74,	-13,	-43,	-122,	-50,	
-36,	-56,	  1,	  6,	 -5,	
-28,	  0,	 25,	 95,	124,	
  5,	 20,	 54,	 39,	 43,	
-124,	-26,	 -2,	-115,	-126,
-79,	118,	-77,	100,	 87,	
-98,	 12,	 41,	 21,	 88,	
-65,	-90,	-128,	 16,	

 35,	  0,	 -9,	-10,	 19,	
 -1,	-103,	 16,	120,	-91,	
-20,	  5,	 83,	 15,	-47,	
-128,	 33,	 99,	 -1,	-123,	
 71,	 31,	 43,	 56,	-107,	
 88,	 62,	 34,	 18,	  5,
 83,	-50,	-107,	 26,	125,	
-73,	 58,	 37,	 19,	-114,	
-40,	-103,	  5,	 72,	

 39,	 -6,	 -4,	-11,	-16,	
-107,	 87,	-100,	 43,	-94,	
-107,	 92,	-68,	 48,	 51,	
-108,	-37,	-69,	-111,	-119,	
 49,	122,	 46,	 85,	103,	
-115,	-40,	  8,	101,	-113,	
-20,	  5,	  7,	 10,	-29,	
 -4,	 81,	 28,	-83,	-121,	
 54,	 68,	 11,	-29,	

 36,	  2,	-13,	 -7,	-107,	
-119,	 33,	110,	 48,	 85,	
 43,	-13,	-112,	-99,	 80,	
-82,	-67,	 85,	 38,	 36,	
-13,	 56,	 81,	 30,	-83,	
-78,	-104,	 85,	-89,	-16,	
-111,	 32,	 16,	-78,	-12,	
 84,	115,	-13,	-118,	 97,
100,	-33,	 56,	-92,	

 32,	  6,	 -2,	-16,	 97,	
-126,	-125,	-79,	 81,	 18,	
 79,	-22,	-44,	122,	-52,	
-54,	 -9,	 80,	-81,	-78,	
 21,	 94,	 22,	 47,	 61,	
 80,	 98,	 48,	-85,	-104,	
 85,	 99,	 -3,	-90,	-124,
 25,	111,	-31,	-47,	-119,	
-44,	-119,	 17,	 20,	

 25,	 16,	  5,	-24,	122,	
 24,	-110,	 16,	  7,	-49,	
-23,	119,	106,	114,	-53,	
-112,	 84,	-29,	-92,	122,	
-43,	107,	115,	 73,	 56,	
118,	 34,	 -4,	 64,	 15,	
120,	-94,	 -3,	  1,	 91,
-33,	-111,	-31,	-103,	 34,	
-16,	-107,	-109,	  8,	

 25,	 16,	  3,	-22,	 88,	
-32,	-44,	 90,	 -6,	 86,	
119,	 33,	 48,	-80,	-107,	
 91,	-80,	-77,	-67,	101,	
-125,	 -8,	-104,	-102,	 84,	
 57,	-52,	  5,	 87,	-39,	
 14,	 48,	 33,	-83,	-14,	
 30,	 94,	 26,	104,	-16,	
-43,	 66,	-94,	 43,	

 24,	 12,	  8,	-22,	-35,	
101,	 39,	 63,	-59,	-40,	
104,	124,	-80,	-75,	  3,	
-29,	 98,	-24,	 97,	102,	
-87,	-107,	 22,	 88,	 79,	
-12,	-43,	-87,	-53,	-38,	
-119,	  5,	-117,	 -6,	 23,	
 16,	101,	 12,	121,	 64,	
 87,	-92,	-85,	-78,

 28,	 12,	  8,	-23,	 97,	
-17,	-68,	 36,	-97,	 19,	
 50,	-15,	 21,	 96,	-39,	
 28,	-112,	 80,	115,	-106,	
-64,	-55,	 42,	 95,	-80,	
-76,	 43,	  7,	-96,	 97,	
101,	 75,	-115,	 85,	-108,	
  5,	-50,	 38,	 69,	-52,
-82,	110,	-46,	-39,	

 24,	 20,	  2,	-22,	110,	
 -8,	 13,	-63,	-105,	 79,	
 76,	 20,	-127,	-91,	-52,	
  4,	  6,	 79,	-29,	102,	
-108,	-116,	123,	 79,	 96,	
 68,	-31,	-78,	-89,	 82,	
118,	 58,	 13,	 55,	 23,	
-117,	 11,	 86,	 82,	 49,
-78,	 85,	102,	 24,	

 24,	 20,	  6,	-25,	 13,	
 53,	106,	 93,	 58,	-72,	
 29,	-124,	-41,	-128,	-48,	
 20,	105,	 76,	 28,	 81,	
 99,	 28,	 45,	-90,	-86,	
-33,	-113,	104,	 13,	-85,	
 -3,	 98,	-42,	 84,	-80,	
 11,	 89,	 25,	 71,	108,	
 41,	  7,	120,	 -8,	

 23,	 21,	  4,	-25,	-113,	
 99,	 99,	 43,	 -7,	 54,	
-105,	  4,	-32,	-79,	 84,	
-38,	 19,	-72,	-50,	 16,	
127,	 -6,	109,	-75,	 10,	
 94,	 13,	  5,	 41,	-91,	
-44,	-115,	 80,	-100,	-100,	
-123,	-45,	-112,	 59,	 30,	
 77,	 18,	-114,	 54,	

 26,	 17,	  3,	-22,	-121,	
 84,	121,	-78,	-47,	-80,	
 23,	 11,	 54,	 52,	 59,	
  3,	 34,	 89,	 19,	 86,	
-23,	-47,	 52,	105,	 14,	
-118,	 84,	 94,	-114,	-57,	
-39,	105,	107,	 35,	-103,	
  6,	-110,	-124,	-121,	 85,	
118,	 50,	110,	 96,

 28,	 13,	  7,	-23,	  6,	
-33,	 63,	-87,	 64,	-37,	
 27,	 53,	-123,	 20,	126,	
-108,	-40,	-122,	-48,	-53,	
-28,	106,	-16,	 54,	-64,	
 25,	118,	 92,	-83,	 84,	
 66,	 88,	 11,	 21,	 68,	
-54,	 47,	 51,	-107,	-84,	
 -8,	 -5,	-103,	-39,

 31,	 10,	  2,	-17,	-58,	
 74,	 29,	 88,	 98,	 94,	
 18,	 80,	-60,	-113,	-66,	
 71,	 35,	-62,	 -1,	 52,	
116,	-118,	-82,	 71,	-105,	
 84,	 54,	 57,	 57,	 74,	
 19,	-58,	-70,	-107,	 50,	
-58,	-116,	102,	 87,	-56,	
 -7,	-91,	 29,	-84,	

 32,	  8,	  4,	-19,	-116,	
109,	-112,	 91,	112,	-95,	
 57,	 92,	 27,	-102,	-76,	
-126,	114,	103,	-39,	 24,	
 72,	-81,	-27,	 52,	-38,	
123,	 48,	-91,	116,	118,	
 44,	 92,	 23,	-112,	122,	
 38,	 17,	-127,	 10,	-97,	
-55,	-44,	-19,	-13,	

 25,	 20,	  3,	-23,	  4,
 13,	  6,	-91,	-39,	 20,	
  7,	-63,	-54,	-124,	112,	
-113,	-93,	 50,	-27,	 27,	
115,	-26,	 17,	 37,	106,	
 78,	 85,	-112,	 78,	-75,	
-47,	 57,	-117,	-118,	-31,	
 90,	-34,	-120,	 -8,	 89,	
 86,	 83,	113,	-60,	

 31,	  1,	 13,	-20,	-107,	
 73,	-120,	-30,	 69,	 66,	
111,	-74,	 25,	109,	126,	
-114,	 29,	  4,	-66,	121,	
-79,	-47,	 32,	125,	-52,	
 24,	-106,	 98,	-68,	-53,	
 92,	 79,	-10,	-26,	-125,	
100,	-16,	-94,	 84,	106,	
 83,	-26,	-44,	 38,	

 30,	  2,	  4,	-11,	 98,	
 -1,	 44,	  5,	102,	 31,	
-52,	 53,	  4,	121,	 47,	
 28,	 22,	-92,	-83,	-119,	
-91,	 15,	-83,	 56,	-106,	
 36,	-17,	 57,	 57,	 86,	
 83,	-86,	-11,	-47,	 23,	
 34,	 60,	-124,	100,	 79,	
 96,	-60,	-103,	124,	

 29,	  4,	  5,	-12,	-83,	
-108,	-103,	 78,	110,	-83,	
-47,	  1,	 56,	 47,	-56,	
 80,	 36,	 -2,	-18,	 82,	
  4,	-93,	-51,	 70,	 84,	
-10,	-12,	-115,	-95,	115,	
-61,	 53,	 58,	-84,	 80,	
 17,	107,	-30,	-47,	100,	
-113,	-86,	-31,	 84,	

 31,	  5,	 11,	-21,	-114,	
-118,	-16,	 89,	 86,	 91,
112,	-42,	  5,	105,	 34,
-26,	 69,	 34,	111,	 54,
 25,	 45,	126,	-114,	 93,
 36,	-68,	125,	-95,	-47,
-127,	-71,	-84,	 90,	-108,
114,	 60,	-37,	 74,	 95,
-10,	-26,	-125,	102,

 38,	 30,	  4,	  2,	-10,
-10,	-94,	 84,	106,	 91,
-26,	-44,	 36,	114,	-18,
-116,	  5,	102,	 31,	-54,
 53,	 16,	125,	126,	 28,
 18,	-122,	-83,	  9,	-91,
 15,	 61,	 56,	 19,	102,
-21,	 41,	 57,	 86,	 91,
 46,	-75,	-47,	 23,	 34,

};	//2246

const BYTE SND_ROOSTER[SND_ROOSTER_SIZE] = {
  0,	 23,	-14,	  7,	-14,
127,	-11,	 85,	 -1,	 -9,
 95,	 85,	 91,	-10,	 87,
-43,	-42,	 -4,	117,	 62,	
 46,	117,	-38,	 95,	-120,	
-42,	123,	-72,	-106,	-70,	
 61,	 83,	115,	 61,	-106,	
 43,	-84,	 20,	 60,	 -3,	
 22,	-69,	 57,	-111,	-77,	

 35,	-30,	 14,	-11,	 60,	
 17,	-125,	-14,	 25,	 79,	
-56,	-43,	 -6,	 44,	101,	
-64,	 63,	 73,	 19,	 -9,	
-103,	-98,	-122,	-15,	-11,	
111,	 76,	  6,	-73,	-105,	
-22,	-75,	126,	-85,	 26,	
108,	 91,	-57,	-41,	125,	
 49,	-92,	-24,	 79,	

 35,	-46,	 23,	-17,	 76,	
 20,	 -9,	-115,	115,	 37,	
-10,	 45,	 79,	105,	-108,	
-13,	-100,	 72,	-16,	-75,	
-98,	 -5,	 86,	 98,	 -7,	
 69,	 58,	-54,	 83,	 44,	
117,	-32,	-105,	 15,	 57,	
112,	-16,	 23,	111,	 37,	
  7,	-20,	 25,	107,

 29,	-35,	 22,	-21,	-95,	
-26,	 -3,	-46,	111,	-120,	
-37,	109,	-122,	 55,	-127,	
104,	 63,	 37,	 39,	-50,	
-99,	 99,	-39,	-27,	-70,	
 78,	 91,	-41,	-11,	-67,	
 15,	 19,	-44,	-75,	 60,	
 74,	-109,	-12,	  9,	 47,	
 80,	-62,	-11,	 74,

 36,	-42,	 19,	-14,	111,	
 84,	  3,	 -7,	118,	 47,	
-106,	-121,	-71,	 37,	-97,	
 74,	117,	-62,	 98,	 79,
 83,	 98,	-15,	-105,	110,	
101,	119,	-24,	 87,	-97,	
105,	109,	 -9,	 86,	 14,	
117,	107,	-52,	-106,	126,	
-63,	  7,	-34,	 69,	

 29,	-33,	 23,	-23,	 60,	
-87,	 61,	-73,	  5,	-50,	
-117,	 89,	 -4,	-124,	 32,	
-18,	 94,	124,	-108,	-25,	
-15,	 75,	123,	-47,	-25,	
 -7,	108,	127,	-112,	 39,	
 49,	  8,	127,	-105,	-32,	
 49,	121,	-85,	-105,	-48,	
-10,	105,	-34,	113,	

 17,	-32,	  5,	 -9,	105,	
 -6,	 22,	-112,	-24,	-80,	
 95,	 39,	-41,	-72,	-19,	
103,	 24,	-29,	 37,	 44,	
-70,	 84,	-113,	-99,	 64,	
-81,	-91,	-90,	-51,	 10,	
126,	 17,	 51,	-119,	-105,	
123,	 49,	-70,	111,	-45,	
 39,	109,	-32,	120,	

  9,	-31,	  3,	-14,	-100,	
-74,	 32,	-46,	 59,	 92,	
 42,	125,	-63,	 -5,	-110,	
-120,	-71,	 85,	-65,	  6,	
 16,	 59,	-31,	122,	-13,	
-91,	 11,	-72,	 88,	110,	
-19,	-121,	-70,	-110,	123,	
-67,	101,	 35,	-63,	 23,	
-69,	-71,	 32,	 50,	

 14,	-29,	  9,	 -7,	-46,	
-121,	-115,	 38,	104,	-84,	
 75,	100,	-64,	-60,	 61,	
  4,	 95,	-33,	-90,	 44,	
-71,	121,	107,	-94,	 70,
-46,	-75,	-117,	 51,	-104,	
 31,	-31,	122,	-54,	-124,	
 82,	 62,	 93,	 43,	-26,	
-63,	 50,	 62,	 91,	

 26,	-33,	 10,	 -4,	 71,	
-99,	-90,	 61,	 54,	  8,	
 -5,	 66,	-93,	-14,	 20,	
 79,	 78,	  4,	-123,	-61,	
-70,	 92,	 99,	112,	-10,	
-125,	-119,	 79,	 61,	 65,	
-77,	-108,	-13,	-87,	 82,	
 74,	 80,	-66,	 -2,	 -7,	
  0,	 69,	 85,	  7,	

 53,	-46,	 32,	-11,	 58,	
 40,	-118,	-26,	  5,	110,	
 66,	-32,	-12,	-116,	-65,	
 16,	-107,	 99,	-72,	-97,	
108,	-22,	-27,	-106,	 23,	
110,	121,	-53,	-81,	-40,	
 21,	 49,	-94,	 19,	-113,	
-56,	-50,	 82,	-73,	 80,	
-64,	-23,	127,	 76,	

 43,	-40,	 23,	 -4,	-94,
-55,	-75,	 11,	 90,	-33,	
  2,	122,	 -7,	112,	 20,	
 31,	 35,	-51,	 49,	 -9,	
-110,	 91,	 96,	 52,	-68,	
-22,	-105,	 98,	  9,	-91,	
-110,	-97,	 -4,	 16,	-71,	
-111,	-102,	 66,	-113,	-45,	
124,	-88,	-115,	 54,	

 39,	-33,	 14,	 -4,	 89,
  3,	-119,	-30,	 -4,	-49,	
 82,	 41,	 67,	-79,	-66,	
-49,	 94,	-40,	 49,	-84,	
-80,	 62,	-108,	 75,	-98,	
 97,	 21,	 -4,	-62,	  8,
-97,	-28,	 89,	-65,	 84,	
-37,	-93,	 -7,	  1,	 78,	
-88,	 21,	-81,	 -5,	

 50,	-44,	 29,	-14,	 99,	
122,	-95,	-11,	-104,	 90,	
 60,	 13,	-26,	-120,	 63,	
-94,	 37,	125,	-15,	-55,	
 14,	 18,	-54,	 77,	-118,	
-81,	 59,	-59,	 28,	119,	
-72,	 16,	 35,	 23,	123,	
125,	-36,	  8,	-77,	  1,	
-81,	 73,	-23,	 79,	

 46,	-38,	 19,	 -8,	-84,	
 90,	 18,	-125,	-12,	 -1,	
120,	 26,	  1,	113,	-89,	
 91,	-50,	 35,	 -3,	-92,	
  3,	 73,	 59,	-18,	 21,	
-122,	-70,	 -7,	118,	106,	
 40,	-75,	 -8,	 50,	 95,	
-126,	  5,	-12,	 -1,	-31,	
 20,	 15,	-98,	 33,	

  0,	-20,	  3,	 -5,	 72,	
 95,	-13,	 93,	 74,	-11,
-105,	-43,	-97,	 90,	109,	
-90,	125,	110,	  4,	 75,	
-42,	 87,	 72,	-98,	112,	
125,	-82,	-73,	-112,	-21,	
117,	 47,	-37,	 66,	 62,	
-107,	115,	-47,	 20,	 -8,	
 20,	 -1,	 33,	127,	

 22,	-10,	  0,	-15,	-68,	
 91,	-53,	-42,	-50,	-75,
121,	-19,	 90,	126,	-107,	
-25,	-75,	 13,	-17,	 91,	
108,	-43,	 -9,	-15,	 28,	
-21,	 87,	-97,	 21,	 48,	
-15,	110,	 63,	 83,	-33,
-43,	-16,	-15,	120,	-67,	
 83,	-97,	-108,	 -9,	

 23,	-21,	  2,	 -7,	-11,	
110,	-67,	 87,	-49,	 20,	
-13,	-27,	124,	 61,	 95,	
-33,	 87,	 -9,	-43,	-68,	
-75,	 95,	 31,	 87,	-25,	
-43,	 -3,	-11,	127,	125,	
 91,	-33,	 21,	-12,	-27,	
124,	125,	 95,	-33,	 87,	
 -9,	-43,	 61,	-11,	

 14,	-18,	 -1,	 -5,	 95,	
 60,	 87,	-21,	 21,	-67,	
-27,	111,	125,	 91,	-33,	
 86,	 -9,	-43,	-67,	-11,	
127,	125,	 95,	-33,	 86,	
-16,	-59,	-66,	121,	 79,	
-33,	 87,	 -9,	-43,	 -3,	
-11,	127,	125,	 95,	-33,	
 87,	 -9,	-43,	 -3,	

  6,	-12,	-10,	  1,	-11,	
111,	 45,	 83,	-25,	 21,	
 -3,	-27,	127,	125,	 95,
-33,	 87,	 -9,	-43,	 -3,	
-11,	127,	-67,	 95,	 -5,	
 86,	 -4,	-59,	127,	 61,	
 94,	-49,	 87,	-69,	-43,	
 47,	-15,	 83,	 -1,	 85,	
 -1,	-43,	111,	 -7,	

 20,	-10,	 -2,	-10,	 91,	
 63,	 84,	-49,	-27,	115,	
 -3,	 95,	127,	 21,	-53,
-11,	125,	 -2,	 91,	 79,	
-107,	 -9,	-15,	109,	-66,	
 83,	 95,	-108,	-73,	-23,	
 65,	125,	 89,	 95,	100,	
 88,	-25,	 68,	 -3,	-31,
125,	-62,	 95,	-69,	

 20,	-23,	  9,	-12,	 84,	
-50,	-11,	 35,	-19,	 89,	
124,	-59,	-121,	-10,	-123,	
-16,	  8,	 95,	114,	 87,	
-42,	-42,	-76,	-19,	125,	
125,	-109,	103,	-111,	-26,	
-13,	109,	 43,	 71,	 30,	
-104,	 53,	-23,	-64,	111,	
 96,	-92,	-10,	-42,	

 -3,	-26,	  0,	 -7,	 15,	
 25,	110,	-83,	-122,	-13,	
-99,	 46,	114,	  6,	-38,	
-92,	-20,	-39,	127,	113,	
-110,	-54,	-41,	 59,	  1,	
 44,	 -7,	-108,	-69,	-103,	
 79,	-118,	  1,	-30,	-123,	
 -1,	 76,	 40,	 91,	-90,	
-57,	-107,	-68,	109,	

  6,	-45,	  6,	-20,	-88,	
 27,	-122,	-33,	  5,	-84,	
113,	-90,	111,	-46,	107,	
-124,	 -3,	-90,	 -4,	 11,
-113,	 98,	 16,	 -7,	-60,	
-115,	 39,	 88,	 12,	 18,	
 -7,	-58,	-18,	-94,	 95,	
 53,	 89,	-10,	  6,	 14,	
-18,	 77,	-63,	103,	

 14,	-34,	 16,	-22,	-26,	
-112,	  7,	105,	 63,	-91,	
 26,	-37,	 38,	 76,	-62,	
 56,	-48,	 57,	 55,	 86,
 63,	 64,	 46,	103,	-57,	
-52,	-39,	-74,	 45,	-124,	
 42,	-33,	100,	-81,	-35,	
119,	108,	-39,	  6,	-10,	
-35,	 55,	124,	 29,

  9,	-18,	  6,	 -8,	 55,	
 10,	-41,	103,	-21,	-91,	
-54,	-18,	 80,	-66,	-59,	
 20,	 -7,	 69,	-67,	-25,	
 23,	-97,	 89,	-125,	-10,	
 22,	-22,	113,	124,	-15,	
 91,	-45,	 87,	 -6,	-107,	
 63,	 57,	 95,	-49,	 87,	
-81,	-59,	-69,	 -7,	

 24,	-17,	 -2,	 -4,	 74,	
 63,	 83,	-33,	-43,	 57,	
-15,	110,	-50,	 87,	-81,	
-59,	 -9,	 -7,	 92,	 63,	
 87,	-113,	-43,	115,	-67,	
 94,	 63,	 86,	-33,	-27,	
 56,	 -3,	 94,	127,	 20,	
-37,	-11,	 57,	 -3,	 95,	
127,	 86,	-61,	-27,	

 27,	-21,	 -3,	  3,	 56,	
 -3,	 92,	 63,	 86,	-33,	
-27,	 48,	 -3,	 92,	-81,	
 87,	-113,	-27,	 50,	 -3,	
 92,	-81,	 87,	-81,	-27,
 50,	-67,	 94,	 15,	 87,	
-61,	-43,	-72,	-67,	 95,	
 31,	 87,	-61,	-43,	 -7,	
-11,	 79,	111,	 87,	

 15,	-21,	 -4,	  3,	-45,	
-43,	 -3,	-11,	127,	125,	
 83,	-33,	 21,	-14,	-11,	
126,	 61,	 95,	-33,	 86,	
 -9,	-43,	 60,	-11,	 95,
 60,	 87,	-17,	-107,	 -5,	
-27,	127,	 61,	 95,	-49,	
 87,	-13,	-43,	 -3,	-11,	
127,	125,	 95,	-33,	

 14,	-26,	 -2,	  3,	 87,	
-77,	-43,	 61,	-11,	 95,	
 61,	 87,	-33,	 21,	 -9,	
-43,	124,	-15,	 95,	 60,	
 87,	-49,	 21,	-14,	-59,	
126,	-71,	 95,	 46,	 87,	
-61,	 21,	-16,	-27,	122,	
121,	 94,	-98,	 87,	-73,	
-123,	-19,	-27,	123,	

  8,	-15,	-13,	 13,	121,	
 94,	-52,	 87,	-13,	-107,	
-20,	-59,	111,	 49,	 95,	
-50,	 86,	-13,	-107,	-67,	
-59,	111,	 56,	 91,	-34,	
 84,	-13,	-59,	124,	-15,	
 95,	 62,	 87,	-21,	-43,	
-20,	-11,	123,	 61,	 94,	
-53,	 86,	-80,	-43,	

  6,	-20,	-11,	  9,	 62,	
 49,	 95,	-116,	 87,	-29,	
 21,	 -4,	-59,	127,	 57,	
 94,	-50,	 86,	-13,	-43,	
-84,	-15,	 75,	125,	 86,	
-33,	 85,	-77,	-59,	 44,
-75,	 95,	 44,	 87,	-21,	
-107,	 -8,	-28,	127,	 61,	
 31,	-49,	 22,	-77,	

 16,	-24,	 -4,	  7,	-59,	
121,	 -7,	 30,	 47,	 71,	
-85,	-47,	-21,	-15,	106,	
-66,	 82,	-65,	-43,	 43,	
-11,	 75,	 -3,	 86,	-17,	
 85,	 -1,	-59,	127,	-79,
 91,	-17,	 86,	 -5,	-43,	
-82,	-11,	107,	-67,	 90,	
 -1,	 85,	-65,	-59,	

 29,	-21,	 -1,	  0,	114,
-71,	 94,	 47,	 87,	 43,	
-43,	-86,	-15,	 92,	-17,	
 87,	 47,	-43,	-21,	-15,	
 78,	-65,	 87,	-49,	-43,	
 58,	-71,	 95,	-113,	 87,	
-29,	-43,	 -3,	-15,	 79,	
 94,	 87,	-57,	-43,	 -7,	
-11,	127,	125,	 95,	

 22,	-24,	  0,	  2,	-33,	
 84,	 -9,	-59,	 62,	 57,	
 95,	-49,	 87,	 -5,	-43,	
 60,	-15,	 95,	 63,	 87,	
-17,	-43,	 58,	-15,	 78,	
-65,	 87,	 47,	-43,	 51,	
-11,	 92,	 -1,	 86,	-113,	
-43,	119,	 -7,	 88,	 -1,	
 85,	-49,	-59,	 99,	

 29,	-13,	 -7,	 -4,	 -3,	
 78,	127,	 84,	-37,	-27,	
 57,	 -3,	 91,	111,	 21,	
-57,	-11,	 61,	 -3,	 91,	
111,	-106,	-57,	-27,	-87,	
 -3,	 72,	 15,	-105,	 41,	
-11,	114,	125,	 94,	 27,
 20,	-27,	-11,	122,	 76,	
 74,	 95,	-105,	-27,	

 13,	-20,	 -5,	  1,	-27,	
 57,	125,	-116,	-41,	 84,	
 -6,	-47,	126,	 57,	 83,	
 -5,	-107,	 -9,	 53,	 61,	
-24,	 91,	-34,	 86,	 -5,	
-43,	127,	-79,	 95,	-17,	
 85,	 -6,	-27,	126,	 -3,
 87,	-33,	 84,	-77,	-59,	
126,	-11,	 91,	-34,	

  7,	-15,	  1,	-10,	 86,	
-14,	-59,	-36,	-73,	 94,
-67,	 69,	-22,	-44,	119,	
 -7,	-41,	127,	-32,	 87,	
-35,	-36,	 39,	125,	113,	
-91,	-37,	 22,	 27,	 29,	
-123,	 55,	-28,	-109,	-37,	
 73,	 61,	-79,	 64,	-25,	
-37,	 94,	-71,	101,	

 13,	-25,	  8,	-10,	 60,	
-42,	 83,	-36,	 65,	-29,	
 37,	 -2,	-27,	111,	 61,	
 87,	-65,	-43,	-73,	-11,	
109,	 61,	122,	-97,	 23,	
-33,	-47,	119,	125,	-127,	
123,	-99,	-45,	 36,	-39,	
-32,	 15,	-83,	 23,	-70,	
-91,	126,	-15,	102,	

  8,	-23,	 -1,	 -5,	-113,	
 70,	 95,	-15,	-91,	-13,	
  9,	 75,	 92,	102,	 38,	
-44,	-80,	121,	 60,	114,	
-109,	-49,	-92,	-100,	 56,	
-107,	-68,	-80,	 29,	-70,	
 75,	108,	 78,	-90,	-44,	
 -9,	 17,	 44,	 49,	  7,
-82,	 83,	 27,	 88,	

 15,	-26,	  5,	 -7,	-31,	
-59,	 -5,	 53,	 30,	-68,	
 89,	-21,	-47,	 35,	-23,	
 99,	125,	 18,	-33,	 71,	
-70,	-43,	120,	 -7,	 67,	
110,	 87,	-117,	-43,	-86,	
-15,	115,	 61,	 82,	-21,	
 21,	-69,	-27,	 76,	 61,
 88,	-49,	 20,	-61,	

 19,	-25,	  2,	 -5,	-43,	
104,	 61,	107,	 47,	 82,	
-53,	-43,	 55,	-15,	 89,
-17,	 86,	107,	-43,	102,	
-15,	 26,	 13,	 87,	-85,	
-43,	-116,	-11,	 73,	-20,	
 86,	107,	-111,	-54,	-12,	
 76,	 -3,	 82,	 63,	 21,	
-33,	-11,	102,	-67,	

 25,	-21,	 -3,	  3,	 88,	
127,	 86,	 11,	-43,	 54,	
 -7,	 93,	 63,	 86,	 31,	
-47,	 55,	 -7,	 73,	-81,	
 87,	111,	-43,	 55,	-11,	
 93,	-66,	 83,	111,	-43,	
-37,	-11,	 73,	 -2,	 86,	
 15,	-43,	-61,	-11,	 77,	
 -2,	 83,	123,	-43,	

 32,	-29,	  3,	  2,	-37,	
-11,	 96,	 -3,	 82,	123,	
-107,	-37,	-11,	118,	 -3,	
 82,	123,	 20,	-34,	-11,	
 54,	 -3,	 90,	127,	 84,	
-98,	-27,	 54,	 -7,	 93,	
-65,	 86,	 15,	-59,	 55,	
 -7,	 93,	-65,	 86,	 31,	
-43,	 39,	 -7,	 77,

 34,	-33,	  7,	 -2,	 -1,	
 87,	111,	-43,	-121,	-79,	
 77,	 -1,	 87,	111,	-59,	
-57,	-71,	105,	-17,	 83,	
111,	-43,	-45,	-79,	 97,	
-17,	 90,	111,	-44,	-101,	
-79,	118,	-18,	 90,	123,	
-44,	-37,	-11,	118,	 -4,	
 88,	123,	-106,	 30,

 39,	-42,	 17,	 -8,	-11,	
 38,	-18,	 92,	 59,	-106,	
-98,	-11,	 54,	-20,	 93,	
-85,	-105,	 14,	-11,	-89,
-67,	 73,	-85,	 23,	 14,	
-11,	-61,	-67,	 77,	-77,	
 23,	106,	-27,	-61,	 61,	
105,	-17,	 83,	108,	-59,	
-61,	-71,	112,	-17,	

 39,	-41,	 15,	 -7,	 90,	
123,	-44,	-125,	-15,	 97,	
-18,	 90,	123,	-44,	-37,	
-79,	118,	-82,	 90,	123,	
-44,	-101,	-79,	118,	-82,	
 90,	123,	-42,	 11,	-79,	
112,	-18,	 90,	123,	-42,	
-98,	-15,	 54,	-50,	 92,	
 59,	-42,	-98,	-79,	

 33,	-39,	 15,	-10,	118,	
-49,	 92,	 59,	-44,	-101,	
 49,	118,	-49,	 92,	 59,	
-42,	-98,	-79,	118,	-82,	
 90,	123,	-42,	-98,	-75,	
118,	-50,	 92,	 59,	-42,	
-100,	-11,	 34,	-17,	 92,	
 51,	-42,	-98,	-75,	118,	
-50,	 92,	 51,	-42,	

 25,	-29,	  5,	 -3,	-113,	
-75,	104,	-17,	 90,	 59,	
-44,	-117,	 57,	120,	-17,	
 90,	 59,	-43,	-53,	-71,	
114,	-17,	 90,	 59,	-43,	
-125,	 57,	120,	-17,	 90,	
 59,	-43,	-117,	-71,	104,	
-49,	 90,	 58,	-43,	-53,	
 57,	104,	-49,	 82,	

 23,	-28,	  3,	 -1,	 59,	
-59,	-85,	 57,	108,	-17,	
 82,	 59,	-59,	-85,	-67,	
104,	-17,	 87,	 58,	-59,	
-93,	 61,	104,	-17,	 86,
 46,	-27,	-93,	-67,	 76,	
-17,	 82,	-82,	-59,	-77,	
-67,	 72,	-17,	 86,	 44,	
-27,	-77,	-67,	 72,	

 56,	 24,	-27,	  0,	  2,	
-17,	 86,	-114,	-27,	-93,	
-67,	 74,	-65,	 22,	-114,	
-11,	-93,	-67,	 74,	 59,	
 23,	-114,	-11,	-94,	-19,	
 74,	 59,	-106,	-34,	-11,	
 34,	-19,	 90,	 59,	-42,	
-113,	-75,	 96,	-18,	 91,	
 63,	-44,	-117,	-11,	104,	

 23,	-26,	  0,	  3,	-18,	
 90,	 63,	-44,	-85,	-79,	
122,	-17,	 90,	 62,	-43,	
-93,	-71,	104,	-17,	 82,	
 46,	-59,	-29,	-71,	104,	
-17,	 82,	-114,	-59,	-93,	
 -3,	 76,	-69,	 86,	-113,	
-27,	-89,	-83,	 72,	-69,	
 22,	-34,	-11,	-93,	

 23,	-28,	  0,	  3,	 -3,
 66,	 59,	 22,	-98,	-11,	
-125,	-19,	 88,	 59,	-106,	
-113,	-11,	 34,	-19,	 88,	
 59,	-42,	-97,	-75,	 42,	
 -2,	 88,	 62,	-44,	-117,	
-79,	104,	 -1,	 88,	 46,	
-44,	-93,	-15,	 98,	 -1,	
 80,	 47,	-59,	-125,	

 25,	-28,	  1,	  2,	 -3,
 96,	-65,	 80,	-113,	-59,	
-125,	 -3,	 64,	 59,	 22,	
-97,	-11,	-126,	-19,	 74,	
 63,	-106,	 11,	-11,	-120,	
 -4,	 64,	 63,	-42,	 11,
-11,	  0,	 -2,	 88,	 46,	
-42,	 35,	-15,	  9,	 -5,	
 88,	 46,	-42,	 35,	

 22,	-21,	 -3,	  1,	-15,	
 41,	 -1,	 88,	 15,	-44,	
 39,	 -7,	 32,	-65,	 88,	
-97,	-92,	-89,	-19,	 96,	
 63,	 88,	-97,	-76,	-89,	
-19,	 96,	 62,	-110,	-97,	
-75,	-128,	-19,	 98,	126,	
-46,	 11,	-75,	-119,	 -8,	
 90,	126,	-42,	  3,	

 13,	-10,	 -8,	 -3,	-75,	
 41,	 -2,	 74,	110,	-42,	
 39,	-31,	 41,	 -5,	 88,	
 14,	-42,	 39,	-19,	 41,	
-69,	 88,	 30,	-58,	 39,	
-19,	 32,	 59,	 88,	-97,	
-92,	-121,	-19,	 96,	 62,	
 24,	-97,	-76,	-126,	-19,	
102,	126,	-104,	 31,	

  8,	  0,	 -9,	-10,	-75,	
-64,	-19,	 96,	126,	-110,
 27,	-75,	-63,	 -8,	 96,	
108,	-106,	 19,	-91,	-124,	
-14,	 97,	124,	-46,	 67,	
-95,	-44,	-14,	 73,	108,	
-122,	 83,	-55,	-60,	-14,	
 73,	110,	 39,	 83,	-39,	
-124,	-72,	-99,	 79,	

  7,	 -1,	-12,	 -6,	 98,	
 19,	-54,	101,	-67,	-103,
 79,	112,	 18,	-30,	101,	
-67,	-55,	 75,	 72,	 18,	
 -9,	 37,	-67,	-96,	 75,	
 28,	-106,	-10,	  5,	 60,	
 50,	 79,	-36,	-106,	-10,
-63,	 46,	114,	 91,	-34,	
  4,	-79,	-63,	111,	

 10,	 -5,	-13,	 -1,	120,	
 90,	-53,	  4,	 -4,	-55,	
111,	 56,	 18,	-25,	  5,	
-67,	-32,	107,	-115,	 22,	
 -9,	-123,	-84,	-74,	 75,	
-36,	 22,	-78,	-111,	 47,	
112,	 91,	-54,	  4,	 -8,	
-63,	111,	120,	 27,	-61,	
101,	 -3,	-31,	107,	

 12,	 -6,	-13,	  0,	 44,	
 18,	 -9,	  5,	-67,	-28,	
 75,	-116,	 22,	 -9,	-111,	
 46,	 48,	 91,	-34,	 22,	
-80,	-47,	110,	112,	 90,	
-61,	 68,	-67,	-63,	107,	
 45,	 18,	-25,	  5,	-67,	
-32,	107,	-100,	 22,	 -9,	
-127,	-84,	 52,	 91,	

 13,	-10,	-12,	  3,	-36,	
 22,	-78,	-103,	126,	 48,	
 91,	-54,	  4,	 -7,	-63,
111,	120,	 26,	-25,	  5,	
-67,	-32,	 79,	-116,	 22,	
 -9,	-123,	-84,	 48,	 95,	
-98,	 22,	-14,	-63,	 62,	
120,	 91,	-37,	 20,	-71,	
-31,	127,	124,	 90,	

 17,	-19,	 -9,	 10,	-29,	
 20,	-68,	-27,	 99,	-115,	
 18,	 -9,	 21,	-84,	-76,
 75,	-116,	 86,	-77,	-107,	
-81,	 49,	 90,	-50,	 86,	
-70,	-59,	 47,	113,	 90,	
-49,	 68,	-72,	-59,	115,	
 57,	 18,	-29,	 20,	-20,
-27,	 99,	-115,	 82,	

 17,	-20,	 -8,	  9,	-13,	
-107,	-116,	-76,	 75,	-50,	
 86,	 51,	-47,	 46,	 49,	
 90,	-49,	 70,	 56,	-59,	
 47,	 57,	 88,	-29,	 84,	
-68,	-27,	107,	-83,	 82,	
-29,	 21,	-84,	-12,	 75,	
-84,	 87,	-77,	-107,	-114,	
 49,	 75,	-50,	 86,	

 21,	-25,	 -4,	  8,	-78,	
-43,	 14,	 57,	 72,	-53,	
 86,	 56,	-59,	115,	 57,	
 82,	-21,	 20,	-83,	-27,	
 35,	-84,	 83,	-77,	-108,	
-84,	-11,	 99,	-84,	 82,	
-77,	-43,	-114,	-75,	 75,	
-82,	 82,	 51,	-47,	 46,	
 49,	 78,	-49,	 70,	

 26,	-31,	  1,	  6,	 58,	
-59,	 43,	 57,	 72,	-49,	
 84,	 58,	-27,	 35,	 57,	
 88,	-21,	 20,	-84,	-27,
 51,	-83,	 82,	-77,	-108,	
-116,	-11,	 99,	-84,	 82,	
-77,	-44,	 14,	 49,	106,	
-49,	 82,	 58,	-43,	-82,	
-71,	 72,	-49,	 86,	

 32,	-41,	 11,	  0,	 56,	
-27,	-117,	 61,	 64,	-53,	
 16,	-84,	-11,	 35,	-84,	
 90,	-21,	-44,	-114,	-15,
 99,	-81,	 88,	-69,	-43,	
-114,	-71,	 98,	-49,	 80,	
 58,	-27,	-114,	-67,	 64,	
-21,	 22,	-82,	-11,	 11,	
-68,	 88,	 -5,	-42,	

 45,	-58,	 30,	-11,	114,	
-79,	  3,	 46,	 89,	-22,	
-59,	-34,	 61,	 34,	-17,	
 68,	-116,	-27,	-117,	 61,	
102,	-49,	  0,	 56,	-11,	
-102,	 44,	 89,	-53,	-108,	
115,	 57,	 34,	-49,	 93,	
-52,	-60,	 12,	-19,	 39,	
 51,	 16,	-116,	-12,	

 27,	-30,	  1,	  5,	-120,	
 -4,	 67,	 63,	-42,	 35,	
-11,	 24,	-69,	 88,	-113,	
-42,	106,	 -7,	102,	-69,	
 16,	-113,	-27,	  8,	 -7,	
 70,	-65,	-108,	 35,	-75,	
 24,	-18,	 88,	-82,	-44,	
115,	-19,	 10,	-69,	 80,	
-50,	-27,	 10,	 -3,	

 28,	-28,	  0,	  5,	 66,	
 59,	-108,	-53,	-75,	 12,	
-18,	 82,	-113,	-44,	 51,	
-71,	 72,	-65,	 80,	-50,	
-27,	-120,	-19,	 67,	 59,
-106,	-93,	-75,	 12,	 -2,	
 88,	-113,	-44,	 35,	-19,	
 98,	 62,	 22,	-113,	-75,	
-120,	 -8,	 90,	 62,	

 26,	-23,	 -3,	  5,	-42,	
-93,	-15,	 12,	-65,	 88,	
-49,	-91,	-94,	-19,	 67,	
122,	-108,	-53,	-75,	 13,	
-21,	 90,	-82,	-59,	-93,
-67,	106,	 59,	 22,	-53,	
-75,	 40,	-18,	 91,	 46,	
-44,	-73,	-71,	104,	-77,	
 86,	-98,	-75,	-94,	

 23,	-25,	 -2,	  4,	-20,	
 90,	 59,	-44,	-125,	-71,	
104,	-69,	 82,	-114,	-27,	
 50,	-19,	 90,	 63,	-42,	
 43,	-79,	104,	 -5,	 82,	
-114,	-59,	-93,	-19,	 74,	
-65,	-108,	-113,	-75,	 72,	
-17,	 88,	-82,	-60,	 51,	
-19,	 66,	 59,	-108,	

 24,	-22,	 -1,	  0,	-117,	
-75,	109,	-18,	 90,	 46,	
-43,	-93,	-67,	 98,	 59,	
 20,	-53,	-75,	 40,	-18,	
 91,	 58,	-44,	-93,	-67,	
 74,	 59,	 22,	-50,	-11,	
-88,	-18,	 91,	 46,	-44,	
-93,	-67,	104,	-69,	 86,	
-114,	-11,	-94,	-20,	

 23,	-22,	 -1,	 -1,	 90,	
 46,	-44,	-89,	-71,	104,	
-65,	 80,	-114,	-11,	-94,	
-20,	 90,	123,	-44,	-125,	
-71,	104,	 -5,	 80,	-50,	
-11,	-120,	-20,	 67,	 62,
-44,	 35,	-71,	 72,	-69,	
 84,	-114,	-11,	 34,	-18,	
 83,	 46,	-44,	 51,	

 21,	-16,	 -3,	 -4,	-67,	
 72,	 59,	 22,	-34,	-75,	
 32,	-18,	 82,	 12,	-43,	
-93,	-67,	106,	 59,	 22,	
-114,	-11,	 40,	-17,	 90,	
 46,	-59,	-93,	 -3,	 72,
 59,	-106,	-117,	-75,	 73,	
-21,	 88,	-114,	-59,	-93,	
-19,	 66,	 59,	-42,	

 19,	 -6,	 -1,	-16,	  3,	
 53,	 41,	-81,	 83,	 12,	
-28,	 50,	-51,	 66,	122,	
-44,	-125,	 57,	 76,	-29,	
 20,	-116,	-11,	 42,	-33,	
 71,	 48,	-59,	 51,	125,	
 30,	-125,	-47,	-51,	-79,	
 40,	-98,	 82,	-95,	-11,	
 58,	 12,	 83,	 39,	

 18,	 -9,	 -2,	-11,	-44,	
-88,	 57,	 78,	-53,	 86,	
-88,	-11,	 58,	-116,	 87,	
 50,	-44,	 43,	125,	 14,	
-93,	 20,	-20,	-75,	106,	
-98,	 87,	 48,	-59,	 42,	
109,	 90,	-89,	-107,	-52,	
 49,	 74,	-97,	 70,	-87,	
-27,	106,	 12,	 83,	

 21,	-19,	 -4,	  0,	-77,	
-47,	-82,	 57,	 74,	-53,	
 84,	-83,	-27,	 99,	-114,	
 82,	-78,	-43,	 43,	121,	
 90,	-29,	-108,	-83,	-15,	
 99,	-98,	 86,	-88,	-27,	
 59,	 60,	 90,	-25,	-107,
-24,	-79,	 78,	-33,	 86,	
-87,	-27,	122,	 44,	

 33,	-39,	 10,	  0,	 90,	
-77,	-107,	-114,	 49,	106,	
-50,	 86,	 60,	-27,	 35,	
-116,	 90,	-77,	-107,	-49,	
113,	 10,	-93,	 86,	-84,	
-27,	 35,	-116,	 83,	 58,	
-43,	-85,	 57,	 72,	-29,
 22,	-18,	-11,	 10,	-34,	
 90,	 56,	-59,	-85,	

 38,	-47,	 17,	 -4,	 61,	
 98,	-73,	-106,	-114,	-75,	
 98,	-34,	 88,	-70,	-27,	
-89,	 45,	 66,	-77,	-42,	
-98,	 49,	 96,	-49,	 80,	
 58,	-11,	-125,	-84,	 88,	
-69,	-44,	 11,	 57,	104,	
-13,	 22,	-114,	-27,	 99,	
-50,	 92,	 58,	-59,	

 48,	-60,	 31,	-12,	-117,	
 61,	 96,	-21,	-105,	106,	
-79,	118,	-34,	 93,	-88,	
-28,	-38,	-116,	 73,	-86,	
-42,	 43,	 57,	112,	-21,	
 18,	122,	-11,	-38,	-82,	
 93,	-70,	-60,	-98,	-83,	
102,	 58,	-41,	107,	 57,	
 54,	-50,	 65,	-116,	

 32,	-32,	  8,	 -5,	-27,	
-94,	-20,	 92,	-82,	-44,	
-125,	-67,	114,	 59,	 18,	
-113,	-75,	 32,	-18,	 90,	
 47,	-59,	-61,	-51,	 98,	
122,	-41,	 35,	-79,	 41,	
-21,	 88,	-98,	-75,	-56,	
 -6,	 76,	 47,	-42,	  7,
-83,	118,	122,	-102,	

 23,	-24,	  2,	 -3,	 11,	
-75,	-127,	 -5,	 88,	 78,	
-90,	-108,	-51,	100,	124,	
-46,	 67,	-87,	-127,	 -5,	
 25,	 75,	 52,	 20,	-22,	
100,	110,	-122,	 83,	 89,	
 77,	 56,	 41,	  2,	-17,	
-59,	-46,	 -2,	105,	 72,
 -8,	-59,	 19,	-49,	

 47,	-57,	 40,	-22,	 66,	
109,	-70,	100,	-125,	125,	
-125,	  3,	-46,	-42,	-93,	
121,	108,	 99,	-106,	-89,	
-16,	 24,	 95,	-94,	 21,	
 61,	 -7,	 66,	-101,	-48,	
-108,	 63,	 44,	 89,	-21,	
-28,	  6,	-65,	 25,	103,	
 50,	-95,	 55,	 35,	

 55,	-58,	 42,	-24,	 19,	
  8,	-83,	 15,	 72,	-27,	
 -7,	-85,	 93,	-61,	-40,	
-90,	 12,	-16,	102,	-102,	
-16,	-106,	 79,	 44,	 68,	
 41,	 -3,	  5,	-37,	-54,	
 17,	115,	-82,	 81,	-79,	
-16,	-106,	 27,	-54,	-106,	
110,	-67,	 97,	 35,	

 60,	-60,	 45,	-26,	-24,	
-106,	125,	-50,	 23,	-102,	
 57,	 54,	115,	 42,	100,	
-57,	-116,	 23,	-40,	-23,	
121,	 46,	 28,	-59,	-25,	
114,	 77,	-102,	-95,	-40,	
 55,	 35,	-109,	 99,	-119,	
-27,	 61,	-116,	  2,	-45,	
125,	 40,	 99,	-45,

 58,	-56,	 35,	-17,	  4,	
-54,	 57,	-99,	 35,	-55,	
-27,	-85,	-82,	 91,	 79,	
-64,	117,	 58,	 43,	 87,	
-126,	-15,	  1,	 15,	-79,	
-108,	120,	 -8,	 68,	 40,	
-13,	-108,	-105,	-54,	-27,	
 76,	122,	-124,	-60,	-32,	
 50,	  2,	116,	-83,

 54,	-54,	 35,	-17,	-67,	
 13,	118,	-81,	  5,	-63,	
-65,	 89,	 19,	-116,	-31,	
 28,	115,	 31,	 73,	-94,	
-76,	-62,	 12,	-41,	  8,	
-10,	 73,	-113,	122,	-107,	
-58,	 59,	  9,	 88,	-29,	
-31,	 97,	 62,	 59,	 20,	
-121,	-20,	-39,	 18,	

 58,	-65,	 42,	-15,	-29,	
-128,	112,	-54,	112,	 11,	
-43,	 41,	125,	-76,	 41,	
-86,	 12,	-91,	 -7,	121,	
 40,	-25,	-27,	-78,	 14,	
 94,	 77,	-90,	 38,	-25,	
-97,	 95,	 95,	112,	-35,	
-93,	  3,	 96,	-35,	-54,	
 13,	 34,	-29,	-103,	

 45,	-46,	 19,	 -2,	  3,	
-82,	 19,	 77,	-118,	 14,	
 22,	-14,	 61,	 76,	 58,	
-75,	 97,	-68,	-120,	 81,	
-89,	-70,	-119,	-100,	-18,	
 69,	 31,	-76,	 73,	 78,	
124,	-28,	-91,	-15,	-118,	
 19,	-113,	-108,	 90,	-66,	
 65,	 47,	 99,	 82,	

 52,	-57,	 31,	 -8,	-78,	
110,	-82,	 90,	104,	-79,	
-15,	 49,	-105,	 39,	 15,	
 88,	-49,	-119,	-111,	  1,	
-97,	-86,	 28,	 92,	-115,	
-33,	-70,	-127,	 74,	-68,	
-42,	 17,	-24,	-36,	-127,	
 87,	-81,	 56,	-104,	-13,	
-107,	-97,	-30,	 93,	

 56,	-53,	 28,	-10,	 41,	
-77,	-92,	-88,	 79,	 11,	
-61,	-63,	 65,	120,	 56,	
 22,	-26,	 -5,	  9,	121,	
-21,	-46,	 83,	108,	120,	
 62,	-43,	-121,	-100,	-126,	
 11,	 61,	-98,	 59,	118,	
 73,	104,	 63,	-86,	 82,	
 55,	121,	-72,	-115,	

 44,	-33,	 14,	 -5,	-10,	
 66,	-32,	 21,	-43,	-34,	
-50,	 98,	-30,	 16,	-37,	
 44,	 81,	104,	-117,	 79,	
-122,	 56,	123,	-33,	 22,	
-64,	-91,	110,	107,	 83,	
-92,	-11,	-83,	108,	 14,	
-40,	-48,	-15,	120,	 78,	
 23,	-104,	-33,	 83,	

};	//4050

#ifdef PLAY_COM_BEEP
const BYTE SND0_BEEP[SND0_BEEP_SIZE] = {

  0,	 25,	-11,	 26,	-30,	
-41,	 -3,	117,	 -1,	 77,	
127,	-37,	 95,	-10,	-41,	
 -3,	-75,	 -1,	109,	 63,	
-38,	111,	-10,	 35,	 -3,	
-120,	 -1,	 98,	-65,	-40,
-81,	-32,	-53,	 -3,	-118,	
 -2,	 40,	-65,	-64,	 63,	
-10,	 43,	 -3,	-116,	 -2,	

 25,	-11,	 27,	-31,	106,	
 63,	-120,	-81,	-10,	 35,	
 -3,	-118,	 -2,	 10,	-65,	
-40,	-81,	-10,	 43,	 -4,	
 11,	 -2,	 10,	-65,	-40,	
-81,	-10,	 43,	 -4,	 42,
 -1,	 98,	-65,	-120,	-81,	
-10,	 35,	 -3,	-120,	 -1,	
 98,	-65,	-62,	 63,	

 25,	-11,	 27,	-31,	-30,	
 43,	 -3,	-120,	 -1,	 98,	
-65,	-64,	-65,	-32,	-85,	
 -3,	-118,	 -1,	 98,	-65,	
-62,	-65,	-30,	-117,	 -4,	
 10,	 -1,	 98,	-65,	-56,	
 47,	-10,	 35,	 -3,	-120,	
 -1,	 98,	-65,	-56,	-81,	
-10,	 35,	 -3,	-118,	

}; //133


const BYTE SND1_BEEP[SND1_BEEP_SIZE] = {

  0,	 -7,	  0,	  0,	 -3,	
 87,	125,	117,	 63,	117,	
119,	-28,	121,	-12,	 87,	
125,	117,	 63,	117,	119,	
-28,	105,	-76,	 87,	125,	
117,	 59,	113,	118,	-28,	
104,	-76,	 86,	125,	117,	
 59,	113,	118,	-28,	104,	
-76,	 86,	125,	117,	 59,	

 -7,	  0,	  0,	 -3,	113,	
118,	-28,	104,	-76,	 86,
125,	117,	 59,	113,	118,	
-28,	104,	-76,	 86,	125,	
117,	 59,	113,	118,	-28,	
104,	-76,	 86,	125,	117,	
 59,	113,	118,	-28,	104,	
-76,	 86,	125,	117,	 59,	
113,	118,	-28,	104,	

 -7,	  0,	  0,	 -3,	-76,	
 86,	125,	117,	 59,	113,
118,	-28,	104,	-76,	 86,	
125,	117,	 59,	113,	118,	
-28,	104,	-76,	 86,	125,	
117,	 59,	113,	118,	-28,	
104,	-76,	 86,	125,	117,	
 59,	113,	118,	-28,	104,	
-76,	 86,	125,	117,	

};	//133

const BYTE SND2_BEEP[SND2_BEEP_SIZE] = {

  0,	 10,	 -4,	 11,	  3,	
127,	-33,	 52,	-15,	 -1,	
124,	-37,	-57,	 -3,	-13,	
111,	 31,	 -9,	-51,	-68,	
127,	-33,	 54,	-16,	 -1,	
124,	-37,	-61,	 -3,	-13,	
110,	 15,	-25,	-51,	-72,	
 63,	-97,	 54,	-32,	 -2,	
124,	-37,	-125,	 -7,	-13,	

  9,	 -4,	 11,	  4,	110,	
 15,	-25,	-51,	-72,	 63,	
-97,	 54,	-32,	 -2,	124,	
-37,	-125,	 -7,	-13,	110,	
 15,	-25,	-51,	-72,	 63,	
-97,	 54,	-32,	 -2,	124,	
-37,	-125,	 -7,	-13,	110,	
 15,	-25,	-51,	-72,	 63,	
-97,	 54,	-32,	 -2,

  9,	 -4,	 11,	  4,	124,	
-37,	-125,	 -7,	-13,	110,	
 15,	-25,	-51,	-72,	 63,	
-97,	 54,	-32,	 -2,	124,	
-37,	-125,	 -7,	-13,	110,	
 15,	-25,	-51,	-72,	 63,	
-97,	 54,	-32,	 -2,	124,	
-37,	-125,	 -7,	-13,	110,	
 15,	-25,	-51,	-72,

}; //133


const BYTE SND3_BEEP[SND3_BEEP_SIZE] = {

  0,	 32,	 -5,	 33,	-37,	
-43,	 93,	 -1,	-33,	 93,	
117,	-33,	 -3,	117,	-41,	
125,	-13,	-40,	 89,	-13,	
-118,	-93,	-91,	-97,	-85,	
 54,	-15,	 76,	-22,	-94,	
 60,	 86,	-21,	-24,	 47,	
-108,	111,	-14,	-125,	-63,	
 99,	 -1,	104,	-15,	 99,	

 33,	 -5,	 34,	-39,	-86,	
-80,	 63,	 82,	 59,	-94,	
-113,	-43,	-85,	-52,	-117,	
-11,	 79,	-88,	-56,	 -3,	
 72,	 -5,	 34,	 63,	 86,	
-81,	 50,	 47,	-44,	 58,	
-22,	 11,	-11,	 99,	-18,	
 32,	 -4,	 82,	-65,	-58,	
-66,	 80,	-18,	-52,	

 33,	 -5,	 34,	-39,	 47,	
-43,	-82,	-84,	-125,	-15,	
 74,	 -5,	  8,	 -3,	 83,	
-22,	 50,	 63,	 86,	 62,	
-62,	-113,	-43,	-22,	-82,
 11,	-11,	 78,	-24,	-94,	
 -3,	 88,	 -5,	 10,	 63,	
 86,	-81,	-96,	-81,	-43,	
 59,	-93,	 11,	-11,	
}; //133


const BYTE SND4_BEEP[SND4_BEEP_SIZE] = {

  0,	 19,	-18,	 20,	-36,
 87,	125,	-107,	-33,	117,	
119,	-35,	 93,	-10,	 87,	
125,	-43,	-33,	117,	115,	
 28,	 90,	-121,	  6,	-119,	
-47,	-94,	117,	104,	-100,	
 90,	-105,	 22,	-119,	-47,	
-94,	113,	 76,	-100,	 90,	
-121,	 22,	-127,	-43,	-94,	

 20,	-18,	 20,	-37,	113,	
104,	 28,	 90,	  7,	 86,	
  1,	-47,	-94,	113,	104,	
 28,	 90,	-121,	 22,	-127,	
-59,	-88,	113,	106,	-100,	
 90,	-89,	 23,	 33,	-43,	
-94,	113,	106,	 28,	 90,	
-89,	 23,	 49,	-59,	-94,	
113,	106,	 28,	 90,	

 20,	-18,	 20,	-37,	-89,	
 22,	-87,	-59,	-52,	113,	
106,	-100,	 90,	-89,	 22,	
-87,	-59,	-52,	113,	104,
-99,	 90,	 39,	 22,	-95,	
-59,	-52,	113,	104,	-100,	
 90,	-121,	 22,	-95,	-59,	
-86,	113,	106,	-100,	 92,	
-57,	 22,	-119,	-59,	

}; //133


const BYTE SND5_BEEP[SND5_BEEP_SIZE] = {

  0,	 30,	 -7,	 30,	-35,	
 85,	 93,	 -1,	-47,	 85,	
119,	 -1,	 69,	 85,	-33,	
-67,	 21,	 95,	125,	-41,	
 20,	 12,	-128,	 30,	 85,	
 58,	  1,	121,	 84,	-24,	
  1,	-27,	 83,	-96,	 23,
-107,	 78,	-128,	 78,	 85,	
 58,	-103,	 57,	 80,	-22,	

 30,	 -7,	 31,	-36,	 68,	
-27,	 82,	-23,	 19,	-107,	
 30,	-128,	 94,	 84,	 42,	
-123,	121,	 81,	-24,	  1,	
-27,	 88,	-24,	 71,	-107,	
 11,	 38,	 94,	 84,	 44,	
-112,	121,	 80,	-70,	 68,	
-27,	 82,	-23,	 19,	-107,	
 30,	-128,	 30,	 85,	

 30,	 -7,	 31,	-36,	-84,	
-127,	121,	 81,	-24,	  5,	
-27,	 66,	-88,	 87,	-107,	
 75,	-127,	 30,	 84,	 42,	
-123,	121,	 84,	-72,	 17,	
-27,	 66,	-88,	 87,	-43,	
 11,	-124,	 14,	 85,	 58,	
 36,	121,	 80,	-84,	 17,	
-27,	 82,	-32,	 71,	

};  //133
#else
const SHORT SND0_OBEEP[SND0_OBEEP_SIZE] = {

	   -16,	    48,	    80,	   -32,
	   -48,	   -64,	  -160,	   -16,	   112,
	   -80,	   112,	   288,	  -112,	  -160,
	  -128,	  -480,	   -80,	   176,	  -272,
	   288,	   656,	  -240,	  -240,	  -192,
	 -1040,	  -176,	    80,	  -816,	   560,
	  1232,	  -512,	  -272,	  -288,	 -2048,
	  -224,	   160,	 -1712,	  1104,	  2352,
	 -1088,	  -448,	  -528,	 -4032,	  -336,
	   336,	 -3424,	  2208,	  4608,	 -2208,
	  -864,	 -1056,	 -8000,	  -656,	   656,
	 -6752,	  4432,	  6720,	 -5152,	  -704,
	 -1920,	-13728,	   128,	  1376,	 -8240,
	  9184,	  7216,	 -8736,	   -64,	 -5088,
	-20000,	  1776,	  1024,	 -6912,	  9632,
	  8992,	 -7056,	  -688,	 -5632,	-21008,
	   240,	   208,	 -7040,	  9328,	  9632,
	 -6512,	 -1136,	 -6016,	-21872,	  -176,
	    16,	 -7072,	  9536,	  5920,	 -9280,
	 -2288,	 -9152,	-23232,	  1920,	   240,
	 -5792,	 12416,	  5744,	-10112,	 -2464,
	-12016,	-20528,	  -976,	  1408,	 -9520,
	 10736,	  8848,	-10416,	 -1184,	 -7152,
	-25216,	  1712,	  1136,	 -7968,	 12160,
	  6912,	-11392,	 -2128,	-10496,	-21376,
	  -752,	 -2144,	 -9264,	 12256,	  7632,
	 -7776,	  2704,	 -6160,	-21712,	 -1952,
	   832,	 -6512,	 12448,	  6800,	 -9264,
	  -448,	 -8992,	-23584,	  2080,	  -544,
	 -6928,	 12528,	  5696,	 -9728,	  -672,
	-10400,	-24576,	  2816,	  -848,	 -6656,
	  8640,	  7376,	 -9136,	 -5584,	-11968,
	-20816,	  2912,	   384,	 -8432,	  9904,
	  9056,	-10016,	 -3216,	 -9264,	-21776,
	 -2640,	 -1984,	 -5712,	  9952,	  6576,
	 -6192,	  -304,	 -8112,	-21232,	  1248,
	 -1440,	 -6720,	 11168,	  8992,	 -6624,
	  -224,	 -7872,	-23968,	   624,	 -1264,
	 -8208,	 11648,	  5872,	-10432,	  -896,
	-10432,	-20672,	     0,	  1664,	 -6928,
	  9312,	  7104,	 -8848,	 -1088,	 -6416,
	-21536,	  1408,	   752,	 -7152,	 10848,
	  6240,	 -9728,	  -704,	 -8304,	-23360,
	  2432,	    64,	 -7392,	 12784,	  6064,
	-10512,	  -240,	-10048,	-25680,	 -2480,
	  1488,	 -5600,	 12192,	  6320,	-10688,
	 -2832,	-11680,	-21440,	 -1248,	  1760,
	 -6080,	  9568,	  8048,	 -7824,	 -1184,
	 -6320,	-21488,	   560,	   336,	 -7216,
	 10304,	  6288,	 -9280,	  -752,	 -8000,
	-22896,	  2256,	    64,	 -7264,	 12384,
	  5920,	-10416,	  -512,	-10032,	-25424,
	 -2576,	  1568,	-10016,	  9152,	  9600,
	 -9728,	  -544,	 -4640,	-23728,	  1312,
	  1808,	 -9088,	 10768,	  7312,	-11680,
	 -1360,	 -8016,	-20736,	  -288,	  -960,
	 -6384,	 10400,	  6240,	 -6848,	  1200,
	 -6448,	-19568,	  2016,	  -976,	 -7248,
	 10336,	  7968,	 -6752,	   928,	 -5952,
	-21056,	  1312,	  -688,	 -8064,	 10240,
	  9056,	 -7312,	   336,	 -5968,	-22752,
	  1008,	  -224,	 -8576,	 10688,	  5984,
	-10560,	  -752,	 -8784,	-24720,	 -2528,
	  2432,	 -9968,	 12656,	  8480,	-13136,
	 -1264,	 -8928,	-23472,	  -320,	 -1120,
	 -7424,	 11712,	  7104,	 -7680,	  1648,
	 -6896,	-21792,	  2320,	 -1056,	 -8336,
	 11408,	  8816,	 -7680,	  1168,	 -6400,
	-23312,	  1616,	  -624,	 -9040,	 11344,
	  5776,	-10880,	   -80,	 -8912,	-25040,
	 -2000,	  2256,	 -5712,	 11744,	  6208,
	-11296,	 -3392,	-11600,	-21568,	 -1264,
	  2272,	 -5904,	  9616,	  8400,	 -7904,
	 -1440,	 -6256,	-21696,	   304,	   480,
	 -7248,	 10240,	  6560,	 -9216,	  -800,
	 -7824,	-22944,	  2096,	   128,	 -7360,
	 12240,	  6016,	-10432,	  -576,	 -9888,
	-25392,	 -2624,	  1680,	-10016,	  9072,
	  5824,	-13264,	 -2992,	 -8992,	-21072,
	   128,	  -208,	 -9520,	 12432,	  8400,
	 -9200,	  2448,	 -5680,	-23280,	 -1872,
	  1616,	 -7856,	  9680,	  9168,	 -7808,
	   448,	 -4144,	-20848,	   816,	   768,
	 -8480,	  9264,	  6256,	 -9712,	  -224,
	 -6176,	-21552,	 -2064,	 -1472,	 -8192,
	 12336,	  8976,	 -6496,	  3376,	 -4864,
	-21056,	  1856,	 -1280,	 -9632,	  9968,
	  8320,	 -7808,	  1776,	 -4624,	-21440,
	  2112,	   144,	 -9056,	 10224,	  9248,
	 -8496,	   304,	 -5520,	-23408,	  1360,
	   496,	 -9024,	 10960,	  6496,	-11184,
	  -752,	 -8464,	-25344,	 -2528,	 -2304,
	 -8960,	 10848,	  7728,	 -7648,	  1600,
	 -6432,	-22576,	  2352,	  -720,	 -8784,
	 11472,	  9376,	 -8416,	   352,	 -6992,
	-25088,	  1456,	  -288,	 -9280,	 12144,
	  6496

};  //480

const SHORT SND1_OBEEP[SND1_OBEEP_SIZE] = {

	    16,	    48,	    48,	   -48,
	    48,	   -64,	   -64,	    64,	    96,
	   -96,	   112,	    96,	    16,	  -112,
	  -112,	  -144,	   176,	  -176,	   224,
	   192,	   208,	  -272,	   304,	  -368,
	  -304,	   -64,	   352,	    96,	   352,
	  -432,	   -96,	   384,	  -512,	  -368,
	   592,	    64,	   544,	   512,	   496,
	  -768,	   848,	 -1008,	  -800,	  1216,
	   848,	 -1312,	  1648,	  1136,	   288,
	 -1456,	 -1520,	 -1648,	  2272,	 -2496,
	  2992,	  2288,	  2384,	 -3488,	  3952,
	 -4784,	 -3680,	  -688,	  4160,	  1216,
	  4384,	 -2288,	 -1360,	  4080,	 -2480,
	 -3344,	  5008,	   416,	  4448,	  4256,
	  4128,	 -6512,	  7152,	 -8544,	 -6496,
	 10064,	  7024,	-10800,	 13616,	  9120,
	  1968,	-10784,	 -3216,	-11360,	 14096,
	-13904,	  6752,	 10928,	  9296,	-12832,
	 13984,	 -7344,	-10672,	 -1264,	 10432,
	  2816,	 11552,	 -6000,	 -3488,	  3792,
	 -4624,	 -7200,	 10832,	  1232,	  9440,
	  9120,	  8848,	 -5712,	 11536,	-14944,
	-10320,	 14480,	  8864,	-12672,	 15232,
	  8512,	  1936,	-10640,	 -3376,	-11280,
	 14080,	-13920,	  6768,	 10912,	  9296,
	-12832,	 13984,	 -7344,	-10672,	 -1264,
	 10432,	  2816,	 11552,	 -6000,	 -3488,
	  3792,	 -4624,	 -7200,	 10832,	  1232,
	  9440,	  9120,	  8848,	 -5712,	 11536,
	-14944,	-10320,	 14480,	  8864,	-12672,
	 15232,	  8512,	  1936,	-10640,	 -3376,
	-11280,	 14080,	-13920,	  6768,	 10912,
	  9296,	-12832,	 13984,	 -7344,	-10672,
	 -1264,	 10432,	  2816,	 11552,	 -6000,
	 -3488,	  3792,	 -4624,	 -7200,	 10832,
	  1232,	  9440,	  9120,	  8848,	 -5712,
	 11536,	-14944,	-10320,	 14480,	  8864,
	-12672,	 15232,	  8512,	  1936,	-10640,
	 -3376,	-11280,	 14080,	-13920,	  6768,
	 10912,	  9296,	-12832,	 13984,	 -7344,
	-10672,	 -1264,	 10432,	  2816,	 11552,
	 -6000,	 -3488,	  3792,	 -4624,	 -7200,
	 10832,	  1232,	  9440,	  9120,	  8848,
	 -5712,	 11536,	-14944,	-10320,	 14480,
	  8864,	-12672,	 15232,	  8512,	  1936,
	-10640,	 -3376,	-11280,	 14080,	-13920,
	  6768,	 10912,	  9296,	-12832,	 13984,
	 -7344,	-10672,	 -1264,	 10432,	  2816,
	 11552,	 -6000,	 -3488,	  3792,	 -4624,
	 -7200,	 10832,	  1232,	  9440,	  9120,
	  8848,	 -5712,	 11536,	-14944,	-10320,
	 14480,	  8864,	-12672,	 15232,	  8512,
	  1936,	-10640,	 -3376,	-11280,	 14080,
	-13920,	  6768,	 10912,	  9296,	-12832,
	 13984,	 -7344,	-10672,	 -1264,	 10432,
	  2816,	 11552,	 -6000,	 -3488,	  3792,
	 -4624,	 -7200,	 10832,	  1232,	  9440,
	  9120,	  8848,	 -5712,	 11536,	-14944,
	-10320,	 14480,	  8864,	-12672,	 15232,
	  8512,	  1936,	-10640,	 -3376,	-11280,
	 14080,	-13920,	  6768,	 10912,	  9296,
	-12832,	 13984,	 -7344,	-10672,	 -1264,
	 10432,	  2816,	 11552,	 -6000,	 -3488,
	  3792,	 -4624,	 -7200,	 10832,	  1232,
	  9440,	  9120,	  8848,	 -5712,	 11536,
	-14944,	-10320,	 14480,	  8864,	-12672,
	 15232,	  8512,	  1936,	-10640,	 -3376,
	-11280,	 14080,	-13920,	  6768,	 10912,
	  9296,	-12832,	 13984,	 -7344,	-10672,
	 -1264,	 10432,	  2816,	 11552,	 -6000,
	 -3488,	  3792,	 -4624,	 -7200,	 10832,
	  1232,	  9440,	  9120,	  8848,	 -5712,
	 11536,	-14944,	-10320,	 14480,	  8864,
	-12672,	 15232,	  8512,	  1936,	-10640,
	 -3376,	-11280,	 14080,	-13920,	  6768,
	 10912,	  9296,	-12832,	 13984,	 -7344,
	-10672,	 -1264,	 10432,	  2816,	 11552,
	 -6000,	 -3488,	  3792,	 -4624,	 -7200,
	 10832,	  1232,	  9440,	  9120,	  8848,
	 -5712,	 11536,	-14944,	-10320,	 14480,
	  8864,	-12672,	 15232,	  8512,	  1936,
	-10640,	 -3376,	-11280,	 14080,	-13920,
	  6768,	 10912,	  9296,	-12832,	 13984,
	 -7344,	-10672,	 -1264,	 10432,	  2816,
	 11552,	 -6000,	 -3488,	  3792,	 -4624,
	 -7200,	 10832,	  1232,	  9440,	  9120,
	  8848,	 -5712,	 11536,	-14944,	-10320,
	 14480,	  8864,	-12672,	 15232,	  8512,
	  1936,	-10640,	 -3376,	-11280,	 14080,
	-13920,	  6768,	 10912,	  9296,	-12832,
	 13984,	 -7344,	-10672,	 -1264,	 10432,
	  2816,	 11552,	 -6000,	 -3488,	  3792,
	 -4624,	 -7200,	 10832,	  1232,	  9440,
	  9120,	  8848,	 -5712,	 11536,	-14944,
	-10320,	 14480,	  8864,	-12672,	 15232,
	  8512

};  //480

const SHORT SND2_OBEEP[SND2_OBEEP_SIZE] = {

	    16,	   -48,	   -48,	   -48,
	   -64,	    48,	   -64,	   -96,	    32,
	   -64,	    48,	    48,	   -96,	  -112,
	    32,	    96,	  -112,	  -144,	  -112,
	  -176,	    80,	  -160,	  -288,	    32,
	  -192,	    80,	   -64,	  -272,	  -288,
	    32,	   208,	  -304,	  -384,	  -304,
	  -448,	   176,	  -448,	  -752,	    48,
	  -496,	   160,	  -160,	  -704,	  -720,
	    80,	   464,	  -752,	  -944,	  -784,
	 -1104,	   416,	 -1088,	 -1792,	   112,
	 -1168,	   384,	  -352,	 -1680,	 -1712,
	   176,	  1088,	 -1840,	 -2288,	 -1888,
	 -2672,	   976,	 -2624,	 -4304,	   240,
	 -2832,	   832,	  -864,	 -4000,	 -4160,
	   384,	   448,	 -4304,	 -4576,	 -4128,
	 -5648,	  1760,	 -5232,	 -8592,	   368,
	 -5600,	  1568,	 -1712,	 -7856,	 -8128,
	   736,	   832,	 -8448,	 -8944,	 -8080,
	-11056,	  3408,	-10240,	-16768,	   688,
	-10928,	  3072,	 -3296,	-15328,	 -7552,
	  2720,	   384,	-12704,	-13248,	-12976,
	 -9456,	  5600,	-14464,	-20000,	  1360,
	-12464,	  2432,	 -3360,	-15648,	 -7920,
	  2592,	   304,	-12832,	-13328,	-13008,
	 -9504,	  5552,	-14480,	-20016,	  1344,
	-12464,	  2416,	 -3376,	-15648,	 -7920,
	  2592,	   304,	-12832,	-13328,	-13008,
	 -9504,	  5552,	-14480,	-20016,	  1344,
	-12464,	  2416,	 -3376,	-15648,	 -7920,
	  2592,	   304,	-12832,	-13328,	-13008,
	 -9504,	  5552,	-14480,	-20016,	  1344,
	-12464,	  2368,	 -3936,	-15648,	 -7792,
	  2720,	   112,	-13264,	-13248,	-12592,
	 -9216,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736,	   144,	-13248,	-13232,	-12576,
	 -9200,	  5472,	-14880,	-19936,	  1680,
	-12416,	  2336,	 -3856,	-15584,	 -7792,
	  2736

};  //480

const SHORT SND3_OBEEP[SND3_OBEEP_SIZE] = {

	   -16,	    48,	    80,	    80,
	   144,	   176,	    48,	   112,	   -16,
	  -240,	  -224,	  -368,	  -560,	  -208,
	  -352,	  -528,	   160,	   304,	  -128,
	   736,	   992,	     0,	   944,	  1264,
	  -448,	   736,	   272,	 -1984,	 -1216,
	 -1856,	 -3984,	 -1280,	     0,	 -2432,
	  1792,	  4160,	  -272,	  4480,	  7040,
	  -832,	  4416,	  3088,	 -7728,	   544,
	 -3072,	-15008,	 -2832,	 -6688,	-18096,
	  1856,	  -592,	 -8128,	 15408,	 15072,
	  2528,	 24304,	 12960,	 -9280,	 10400,
	 -7072,	-28336,	 -3024,	-15760,	-30368,
	   192,	 -7328,	-15376,	 14176,	  6048,
	 -3728,	 24624,	 14720,	  -960,	 23840,
	  5600,	-16160,	  5744,	-11904,	-29728,
	 -5280,	-14656,	-27264,	  6096,	   -16,
	-12640,	 16864,	 10592,	  -768,	 27232,
	 16320,	 -4336,	 18976,	   416,	-22016,
	   816,	-14880,	-31520,	 -3200,	-10832,
	-21232,	 11552,	  4080,	 -7680,	 23248,
	 14240,	   592,	 27424,	 11200,	 -9584,
	 12112,	 -6048,	-26816,	 -4272,	-17152,
	-30528,	  -256,	 -5904,	-14608,	 15424,
	  7696,	 -3024,	 24672,	 14208,	  -592,
	 22912,	  6560,	-13248,	  5808,	-11920,
	-29936,	 -4432,	-15904,	-26656,	  5424,
	  -672,	-10304,	 18944,	 11600,	  -288,
	 25296,	 14320,	 -3408,	 17280,	   832,
	-19568,	  -560,	-15744,	-32112,	 -3136,
	-12048,	-22144,	 11792,	  2704,	 -9120,
	 23552,	 13984,	  1168,	 25952,	 11328,
	 -8832,	 11232,	 -6192,	-25872,	 -3136,
	-16224,	-30768,	  -112,	 -6368,	-15024,
	 16800,	  8784,	 -3232,	 27168,	 16112,
	  -592,	 22992,	  6912,	-15200,	  6032,
	-11488,	-30560,	 -4432,	-14928,	-27024,
	  5152,	  -320,	-10432,	 20912,	 11888,
	   144,	 28224,	 14800,	 -3456,	 18528,
	   224,	-20992,	   112,	-14544,	-31712,
	 -3168,	-11664,	-21504,	 11488,	  4080,
	 -6336,	 23488,	 14080,	  1152,	 27344,
	 12208,	 -8096,	 11696,	 -6432,	-26288,
	 -3712,	-16032,	-30480,	   -48,	 -6768,
	-15344,	 16496,	  8304,	 -3296,	 27040,
	 15696,	  -592,	 23072,	  6688,	-14816,
	  5296,	-11248,	-30880,	 -4448,	-15136,
	-26656,	  5728,	   -16,	 -9872,	 21344,
	 11728,	   288,	 28352,	 14528,	 -3472,
	 18464,	  -240,	-21264,	  -272,	-15088,
	-32064,	 -3392,	-11952,	-21424,	 11696,
	  4112,	 -6128,	 23600,	 14144,	  1520,
	 26256,	 11152,	 -8400,	 11824,	 -5920,
	-26016,	 -3088,	-16400,	-29968,	   512,
	 -6336,	-15136,	 16928,	  8848,	 -2752,
	 27120,	 15232,	  -128,	 23104,	  6112,
	-14304,	  5536,	-11584,	-30000,	 -5248,
	-15264,	-26624,	  5168,	   160,	 -9376,
	 21344,	 12512,	    32,	 27104,	 13680,
	 -3728,	 17712,	  -176,	-20112,	   752,
	-15776,	-31680,	 -3296,	-11248,	-21008,
	 11616,	  4352,	 -6384,	 23936,	 14560,
	  1184,	 26384,	 11264,	 -8832,	 11968,
	 -6816,	-26208,	 -3632,	-16560,	-30480,
	     0,	 -6176,	-15344,	 16464,	  8736,
	 -3504,	 26784,	 15920,	   512,	 23792,
	  6240,	-14928,	  5888,	-11840,	-29872,
	 -5248,	-15792,	-26752,	  5056,	  -336,
	 -9488,	 21232,	 11968,	    32,	 27328,
	 13648,	 -3184,	 18320,	   -32,	-19680,
	   928,	-15200,	-30848,	 -3024,	-11952,
	-21328,	 11808,	  4064,	 -5840,	 24144,
	 14080,	  1328,	 27376,	 11504,	 -8352,
	 11616,	 -7008,	-26208,	 -3328,	-16208,
	-29888,	   624,	 -6768,	-14800,	 17056,
	  8192,	 -2848,	 27200,	 14944,	   544,
	 23728,	  6352,	-13648,	  5568,	-12160,
	-30528,	 -4880,	-15296,	-26704,	  4944,
	  -320,	-10016,	 20496,	 11408,	   480,
	 28160,	 15088,	 -4224,	 17200,	  -736,
	-21792,	   176,	-15120,	-31936,	 -3664,
	-11504,	-20928,	 11744,	  4848,	 -5392,
	 23824,	 14640,	  1616,	 27024,	 12032,
	 -8368,	 12240,	 -6992,	-26864,	 -3392,
	-16704,	-29904,	   224,	 -6512,	-14944,
	 16704,	  8640,	 -2672,	 26976,	 15280,
	   368,	 23248,	  6416,	-13840,	  5344,
	-11744,	-30192,	 -4720,	-14704,	-26288,
	  5072,	    32,	 -9856,	 20432,	 11664,
	   320,	 27600,	 14736,	 -3120,	 18048,
	   272,	-20688,	  -544,	-15888,	-31488,
	 -3728,	-11616,	-20832,	 11376,	  4624,
	 -5232,	 23712,	 14544,	  1712,	 26672,
	 11696,	 -8224,	 12080,	 -6880,	-26240,
	 -3104,	-16352,	-30192,	   624,	 -6080,
	-15248,	 16896,	  8704,	 -3456,	 26928,
	 15392

};  //480

const SHORT SND4_OBEEP[SND4_OBEEP_SIZE] = {

	    16,	    48,	    48,	   -48,
	    16,	   -64,	  -160,	    64,	    16,
	    32,	   272,	   160,	  -128,	    96,
	  -160,	  -464,	   160,	   -48,	    16,
	   720,	   400,	  -336,	   288,	  -464,
	 -1216,	   448,	  -176,	    16,	  1920,
	   976,	  -848,	   784,	 -1248,	 -3072,
	  1184,	   272,	   112,	  4304,	  2176,
	 -2336,	  1328,	 -2592,	 -6592,	  2624,
	  -304,	   -80,	  9776,	  4848,	 -4800,
	  3760,	 -5984,	-15232,	  5984,	 -1456,
	  -352,	 22944,	 11280,	-10800,	  4128,
	-15152,	-22032,	 15104,	 -1888,	 -2256,
	 32752,	 10480,	-12288,	  5024,	-18880,
	-24480,	 16784,	 -1952,	 -1168,	 32752,
	  6352,	-12864,	  6336,	-15568,	-24128,
	 15056,	  -736,	   592,	 31952,	  6752,
	-12320,	  4624,	-15888,	-23440,	 13744,
	   192,	  1744,	 32752,	  8848,	-12144,
	  2944,	-16256,	-24816,	 12688,	  1168,
	 -1008,	 32752,	 10928,	-13200,	  4160,
	-17840,	-22000,	 16784,	  -560,	  -640,
	 32752,	  6800,	-13632,	  5296,	-15504,
	-24416,	 15056,	   368,	   912,	 31872,
	  7120,	-12944,	  3840,	-15728,	-23648,
	 13744,	  1072,	 -1600,	 31680,	  9168,
	 -9744,	  3264,	-16064,	-23952,	 11008,
	  -224,	  -656,	 32096,	 11280,	-11312,
	  4256,	-17872,	-24624,	 12976,	  -304,
	  -464,	 32752,	  9168,	-12256,	  5088,
	-15376,	-22528,	 13728,	    48,	  1200,
	 32752,	  8432,	-12288,	  3744,	-16208,
	-24688,	 12512,	  1024,	  -720,	 32752,
	 10880,	-12512,	  4144,	-15568,	-24528,
	 12320,	  1232,	 -1200,	 32016,	 10528,
	-12624,	  4480,	-14976,	-24240,	 12096,
	  1376,	  1328,	 32752,	 10512,	-12000,
	  6160,	-14960,	-24528,	 12576,	  -192,
	   592,	 31088,	  8304,	-11104,	  4112,
	-16096,	-24432,	 10912,	   656,	  -464,
	 31456,	 10496,	-11328,	  4320,	-15264,
	-23760,	 10880,	   928,	  -880,	 30128,
	  9792,	-11392,	  4448,	-16800,	-24064,
	 11232,	   656,	   -32,	 30816,	  8928,
	-11328,	  4560,	-15568,	-22768,	 11056,
	   816,	  -448,	 28928,	  8096,	-11120,
	  4576,	-16384,	-22400,	 11184,	   544,
	   176,	 28832,	  7200,	-10864,	  4592,
	-16768,	-23344,	 10416,	   624,	   368,
	 29152,	  7760,	-10592,	  4544,	-16848,
	-23664,	  9824,	   720,	   512,	 28928,
	  7952,	-12128,	  5312,	-15552,	-22768,
	 11696,	   944,	   912,	 29872,	  7440,
	-11312,	  4000,	-15840,	-23152,	 10448,
	  1328,	    16,	 28736,	  8304,	-11072,
	  4096,	-16288,	-22384,	 10624,	   992,
	   496,	 28256,	  7248,	-10736,	  4128,
	-16432,	-22880,	  9952,	  1024,	   624,
	 28192,	  7568,	-12224,	  4976,	-16992,
	-22864,	 12688,	   576,	   -48,	 30144,
	  6896,	-11856,	  4992,	-15616,	-23248,
	 11312,	   992,	  -784,	 29008,	  7824,
	-11536,	  4960,	-16144,	-22480,	 11376,
	   688,	  -176,	 28528,	  6848,	-11104,
	  4896,	-16320,	-22976,	 10576,	   720,
	    32,	 28432,	  7216,	-10720,	  4752,
	-16224,	-22944,	  9936,	   768,	   192,
	 27952,	  7280,	-12000,	  5408,	-16544,
	-22528,	 12432,	   384,	  -384,	 29376,
	  6496,	-11600,	  5344,	-16928,	-23488,
	 11472,	   448,	  -128,	 29632,	  7168,
	-11200,	  5200,	-16992,	-23792,	 10720,
	   544,	    96,	 29376,	  7440,	-10848,
	  5008,	-16800,	-23616,	 10112,	   624,
	   240,	 28752,	  7424,	-12128,	  5632,
	-17056,	-23088,	 12608,	   256,	  -336,
	 30064,	  6592,	-11712,	  5536,	-15568,
	-23040,	 11280,	   640,	   816,	 30016,
	  7776,	-10976,	  4176,	-15872,	-23392,
	 10128,	  1088,	   -48,	 28864,	  8560,
	-10816,	  4240,	-16320,	-22576,	 10384,
	   816,	   448,	 28368,	  7472,	-12496,
	  5232,	-17200,	-23024,	 13344,	   320,
	  -256,	 30960,	  6976,	-12176,	  5296,
	-15920,	-23856,	 11824,	   832,	 -1008,
	 30032,	  8208,	-11856,	  5232,	-16688,
	-23312,	 11872,	   544,	  -304,	 29776,
	  7248,	-11504,	  5168,	-17040,	-22480,
	 11856,	   288,	   240,	 29152,	  6320,
	-11072,	  5072,	-17088,	-22944,	 11008,
	   384,	   400,	 28960,	  6752,	-10704,
	  4896,	-16880,	-22912,	 10304,	   464,
	   496,	 28400,	  6880,	-11968,	  5552,
	-17104,	-22496,	 12736,	   112,	  -112,
	 29744,	  6128,	-11568,	  5456,	-15616,
	-22528,	 11392,	   528,	  -784,	 28352,
	  6928

};  //480

const SHORT SND5_OBEEP[SND5_OBEEP_SIZE] = {

	    16,	    48,	    80,	    96,
	   128,	   160,	    32,	    64,	   -48,
	  -256,	  -256,	  -336,	  -464,	  -112,
	    32,	   144,	   576,	   688,	   672,
	   896,	   800,	    80,	   288,	  -288,
	 -1248,	 -1120,	 -1520,	 -2096,	  -512,
	    16,	   400,	  2320,	  2752,	  2624,
	  3632,	  3120,	   336,	  1152,	 -1152,
	 -4784,	 -3264,	 -4720,	 -6896,	 -1104,
	   240,	   848,	  7440,	  8400,	  7440,
	 11152,	  4400,	 -3104,	  1712,	 -7888,
	-15952,	 -2640,	-10928,	 -8016,	 13120,
	  -416,	  3040,	 24960,	 12736,	 10144,
	 23536,	  5504,	 -8768,	  3152,	-14304,
	-21072,	 -1824,	 -9840,	 -9152,	 15184,
	  3632,	   496,	 22688,	 10288,	  5264,
	 23488,	  6288,	 -9216,	  3248,	-13360,
	-21552,	 -2000,	 -9392,	 -7904,	 16640,
	  4624,	  1392,	 23552,	 10656,	  5632,
	 24048,	  6352,	 -9792,	  2720,	-14256,
	-22480,	 -2304,	 -9552,	 -9952,	 15408,
	  4576,	   304,	 23248,	 11264,	  4928,
	 23648,	  6720,	-10016,	  2992,	-13232,
	-22384,	 -2144,	 -9040,	 -8336,	 16864,
	  5264,	  1200,	 23856,	 11200,	  5280,
	 24080,	  6576,	-10368,	  2592,	-14112,
	-22976,	 -2304,	 -9232,	 -7824,	 15424,
	  4448,	  1520,	 22336,	 10256,	  5360,
	 22400,	  5744,	 -9328,	  2352,	-13472,
	-23968,	 -1744,	-10704,	 -9968,	 15488,
	  2912,	   -80,	 23696,	 10752,	  6064,
	 22240,	  4528,	 -9680,	  1728,	-14512, 
	-23712,	 -1616,	 -8544,	 -7872,	 16976,
	  5360,	  1312,	 23840,	 10448,	  4208,
	 23376,	  5168,	 -7936,	  3136,	-14864,
	-23936,	 -1840,	-10080,	 -8464,	 16960,
	  4096,	  1168,	 24848,	 10672,	  5632,
	 22304,	  6416,	 -9568,	  1984,	-13680,
	-22208,	 -2672,	 -9184,	 -7744,	 17648,
	  5536,	  1728,	 25296,	 11840,	  6048,
	 22432,	  3904,	 -8544,	  3408,	-14416,
	-22720,	 -3088,	 -9632,	 -8048,	 17264,
	  5728,	  2256,	 25248,	 11776,	  5760,
	 21536,	  6304,	-10416,	   656,	-13920,
	-22704,	 -3264,	 -8528,	 -9696,	 15376,
	  5984,	   640,	 23632,	 12336,	  4560,
	 23760,	  3568,	 -7456,	  3744,	-16080,
	-23136,	 -3600,	-10912,	 -9696,	 16224,
	  4704,	  1552,	 25568,	 12272,	  6464,
	 22848,	  4080,	 -8400,	   928,	-13792,
	-22000,	 -2224,	-10640,	 -8656,	 17376,
	  3952,	  1200,	 25792,	 11312,	  6576,
	 23776,	  3968,	 -7840,	  1584,	-14176,
	-21984,	 -1776,	 -8448,	 -8992,	 16704,
	  5216,	   176,	 24192,	 11456,	  4576,
	 21760,	  4208,	 -8848,	  1424,	-15136,
	-23552,	 -2368,	 -9344,	 -7648,	 16560,
	  5072,	  2064,	 23936,	 10544,	  5088,
	 23424,	  5040,	 -7440,	  2768,	-15376,
	-23744,	 -2336,	-10560,	 -8128,	 16736,
	  3952,	  1792,	 24864,	 10656,	  6240,
	 22208,	  6208,	 -9232,	  1664,	-14048,
	-21984,	 -2976,	 -9456,	 -9776,	 15056,
	  4784,	   560,	 23616,	 11696,	  5088,
	 24320,	  3408,	 -9856,	  1936,	-14480,
	-23344,	 -3280,	-10144,	 -8816,	 17184,
	  5584,	  2032,	 25728,	 12128,	  5904,
	 22160,	  6592,	-10512,	   896,	-14064,
	-23200,	 -3328,	 -8816,	 -7776,	 17936,
	  6624,	  2144,	 25680,	 12640,	  5920,
	 22112,	  3968,	 -9264,	  2720,	-14464,
	-23248,	 -3360,	 -9152,	 -8000,	 17488,
	  6496,	  2400,	 25344,	 12208,	  5488,
	 24704,	  6128,	 -8192,	  2208,	-16128,
	-22752,	 -3712,	 -9344,	 -8032,	 17136,
	  6016,	  2112,	 25376,	 12656,	  6512,
	 22352,	  4336,	 -8576,	  2816,	-14448,
	-23056,	 -3760,	 -9568,	 -8112,	 16992,
	  6192,	  2544,	 25216,	 12304,	  5968,
	 24816,	  6320,	 -7792,	  2128,	-16208,
	-22656,	 -4048,	 -9600,	 -8016,	 16848,
	  5904,	  2320,	 25312,	 12752,	  6864,
	 22352,	  4400,	 -8352,	  2656,	-14560,
	-22992,	 -4032,	 -9728,	 -8032,	 16800,
	  6144,	  -144,	 23824,	 12768,	  5536,
	 22608,	  6352,	 -8128,	   560,	-15312,
	-22000,	 -1728,	 -8224,	 -7680,	 15440,
	  4528,	   816,	 22256,	 10096,	  4560,
	 22928,	  5936,	 -9872,	  3472,	-13280,
	-22112,	 -3984,	 -8960,	 -9888,	 14528,
	  5328,	   400,	 23456,	 12912,	  5856,
	 21680,	  5712,	 -8032,	  3184,	-14848,
	-21744,	 -2816,	 -9408,	 -8864,	 15648,
	  4960,	  1264,	 23744,	 11280,	  5152,
	 23920,	  6144,	 -7312,	  2992,	-14816,
	-21392,	 -3232,	 -9280,	 -8320,	 15696,
	  5008

};  //480

#endif
