/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   str.c
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   strlen, strcpy
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "stdafx.h"
#include "datatype.h"

unsigned int strlen(signed char *string)
{
	signed  char *r1 = string - 1;
	
	do {} while (*++r1);
	
	return r1 - string;
}

int strcmp(signed char *string1, signed  char *string2)
{
	signed char *r1 = (signed char *)string1 - 1;
	signed char *r2 = (signed char *)string2 - 1;
	signed char cp;
	
	do {} while ( (*++r2 == (cp = *++r1)) && cp );
	
	return *r1 - *r2;
}

signed char *strcpy(signed char *dest,signed  char *src)
{
	signed char *result = dest;
	
	while (*dest++ = *src++);
	return result;
}

#ifdef PC_SIM
void strcpy(signed const char *dest, const char *src)
{
    long i = 0;
	
	while (src[i])
		*(char*) (dest+i) = src[i++];
	*(char*)(dest+i) = 0x00;
	return;
}
#endif
