/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this
file except in compliance with the License.

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
for the specific language governing rights and limitations under the License.

The Original Code is VT-OS Ver. 1.1 Operating System, released
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   pr3910.h
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio
Date:	    :   October 1st, 1999
Purpose:	:   CPU-dependent definitions for the MIPS pr3910 architecture
Revision    :   1.1
Note        :   1. Aliases for general register
 				2. Virtual addresses of memory segments
 				3. Cacheable exception vector addresses
 				4. System control coprocessor (CP0) registers and their
                   related bits
===========================================================================
*/


#ifndef _PR3910_
#define _PR3910_


#define USER_INTS		(STATUS_IP4 | STATUS_IP2 | STATUS_SW1 | STATUS_SW0)

/* Aliases for general registers */
#define zero		$0
#define	AT			$1		/* assembler temporaries */
#define	v0			$2		/* value holders */
#define	v1			$3
#define	a0			$4		/* arguments */
#define	a1			$5
#define	a2			$6
#define	a3			$7
#define	t0			$8		/* temporaries */
#define	t1			$9
#define	t2			$10
#define	t3			$11
#define	t4			$12
#define	t5			$13
#define	t6			$14
#define	t7			$15
#define	s0			$16		/* saved registers */
#define	s1			$17
#define	s2			$18
#define	s3			$19
#define	s4			$20
#define	s5			$21
#define	s6			$22
#define	s7			$23
#define	t8			$24		/* temporaries */
#define	t9			$25
#define	k0			$26		/* kernel registers */
#define	k1			$27
#define	gp			$28		/* global pointer */
#define	sp			$29		/* stack pointer */
#define	s8			$30		/* saved register */
#define	ra			$31		/* return address */

/* Virtual addresses of memory segments */
#define KUBASE		0x00000000
#define KUSIZE		0x80000000
#define K0BASE 		0x80000000
#define K0SIZE 		0x20000000
#define K1BASE		0xA0000000
#define K1SIZE 		0x20000000
#define K2BASE 		0xC0000000
#define IS_KUSEG(a)	((unsigned)(a)>=KUBASE && (unsigned)(a)<K0BASE)
#define	IS_K0SEG(a)	((unsigned)(a)>=K0BASE && (unsigned)(a)<K1BASE)
#define	IS_K1SEG(a)	((unsigned)(a)>=K1BASE && (unsigned)(a)<K2BASE)
#define IS_K2SEG(a)	((unsigned)(a)>=K2BASE)

/* Cacheable exception vector addresses */
#define UTLB_VECT 	0x80000000
#define GEN_VECT 	0x80000080

/* System control coprocessor (CP0) registers and their related bits */
	/* Exception handling registers */
#define C0_CAUSE	$13		/* Exception Cause */
#define C0_EPC		$14		/* Exception PC */
#define C0_STATUS	$12		/* Processor Status */
#define C0_BADVADDR	$8		/* Bad Virtual Address */
#define C0_PRID		$15		/* Processor Rev Indentifier */
#define C0_CACHE	$7		/* Cache Control */
#define C0_CONFIG	$3		/* Configuration */

	/* Virtual memory handling registers */
#define C0_CONTEXT	$4		/* Context */
#define C0_ENTRYHI	$10		/* TLB EntryHi */
#define C0_ENTRYLO	$2		/* TLB EntryLo */
#define C0_INDEX	$0		/* TLB Index */
#define C0_RAND		$1		/* TLB Random */

	/* Cause Register */
#define CAUSE_BD		(1 << 31)	/* Branch Delay */
#define CAUSE_CEMASK	(3 << 28)	/* Coprocessor Error */
#define CAUSE_CE3		(3 << 28)	/* Coprocessor 3 Error */
#define CAUSE_CE2		(2 << 28)	/* Coprocessor 2 Error */
#define CAUSE_CE1		(1 << 28)	/* Coprocessor 1 Error */
#define CAUSE_CE0		(1 << 28)	/* Coprocessor 0 Error */
#define CAUSE_IP5		(1 << 15)	/*  (Intr5) */
#define CAUSE_IP4		(1 << 14)	/*  (Intr4) */
#define CAUSE_IP3		(1 << 13)	/*  (Intr3) */
#define CAUSE_IP2		(1 << 12)	/*  (Intr2) */
#define CAUSE_IP1		(1 << 11)	/*  (Intr1) */
#define CAUSE_IP0		(1 << 10)	/*  (Intr0) */
#define CAUSE_SW1		(1 << 9)	/*  (Software Int 1) */
#define CAUSE_SW0		(1 << 8)	/*  (Software Int 0) */
#define CAUSE_EXCMASK	(0x1F << 2)	/* Exception Code */
#define EXC_INT			(0 << 2)	/* External interrupt */
#define EXC_MOD			(1 << 2)	/* TLB modification */
#define EXC_TLBL		(2 << 2)    /* TLB miss (Load or Ifetch) */
#define EXC_TLBS		(3 << 2)	/* TLB miss (Save) */
#define EXC_ADEL		(4 << 2)    /* Addr error (Load or Ifetch) */
#define EXC_ADES		(5 << 2)	/* Address error (Save) */
#define EXC_IBE			(6 << 2)	/* Bus error (Ifetch) */
#define EXC_DBE			(7 << 2)	/* Bus error (data load/store) */
#define EXC_SYS			(8 << 2)	/* System call */
#define EXC_BP			(9 << 2)	/* Break point */
#define EXC_RI			(10 << 2)	/* Reserved instruction */
#define EXC_CPU			(11 << 2)	/* Coprocessor unusable */
#define EXC_OVF			(12 << 2)	/* Arithmetic overflow */

	/* Status Register */
#define	STATUS_CU3		(1 << 31)	/* Coprocessor 3 usable */
#define STATUS_CU2		(1 << 30)	/* Coprocessor 2 usable */
#define STATUS_CU1		(1 << 29)	/* Coprocessor 1 usable */
#define STATUS_CU0		(1 << 28)	/* Coprocessor 0 usable */
#define STATUS_RE		(1 << 25)	/* Reverse Endian */
#define STATUS_BEV		(1 << 22)	/* Bootstrap Exception Vector */
#define STATUS_TS		(1 << 21)	/* TLB shutdown */
#define STATUS_PE		(1 << 20)	/* Parity Error */
#define STATUS_IP5		(1 << 15)	/*  (Intr5) */
#define STATUS_IP4		(1 << 14)	/*  (Intr4) */
#define STATUS_IP3		(1 << 13)	/*  (Intr3) */
#define STATUS_IP2		(1 << 12)	/*  (Intr2) */
#define STATUS_IP1		(1 << 11)	/*  (Intr1) */
#define STATUS_IP0		(1 << 10)	/*  (Intr0) */
#define STATUS_SW1		(1 << 9)	/*  (Software Interrupt 1) */
#define STATUS_SW0		(1 << 8)	/*  (Software Interrupt 0) */
#define STATUS_KUO		(1 << 5)	/* Kernel/User mode, old */
#define STATUS_IEO		(1 << 4)	/* Interrupt Enable, old */
#define STATUS_KUP		(1 << 3)	/* Kernel/User mode, previous */
#define STATUS_IEP		(1 << 2)	/* Interrupt Enable, previous */
#define STATUS_KUC		(1 << 1)	/* Kernel/User mode, current */
#define STATUS_IEC		(1 << 0)	/* Interrupt Enable, current */

	/* TLB EntryHi Register */
#define	ENTRYHI_VPNMASK	(0xFFFFF << 12)	/* Virtual Page Number */
#define ENTRYHI_ASIDMASK	(0x3F << 6)	/* Address Space Identifier */
#define ENTRYHI_ASID(a)	((a << 6) & ENTRYHI_ASIDMASK)	/* Address Space Identifier */

	/* TLB EntryLo Register */
#define ENTRYLO_PFNMASK	(0xFFFFF << 12)	/* Page Frame Number */
#define ENTRYLO_N			(1 << 11)	/* Cache Control Bit */
#define ENTRYLO_D			(1 << 10)	/* Dirty Control Bit */
#define ENTRYLO_V			(1 << 9)	/* Valid Control Bit */
#define ENTRYLO_G			(1 << 8)	/* Global Control Bit */

	/* TLB Index Register */
#define INDEX_P			(1 << 31)	/* Probe Failure */
#define INDEX_INDEXMASK	(0x1F << 8)	/* Index */
#define INDEX_INDEX(a)	((a << 8) & INDEX_INDEXMASK) /* Index */

	/* TLB Random Register */
#define RAND_RANDMASK	(0x1F << 8)	/* Random */
#define RAND_RAND(a) 	((a & RAND_RANDMASK) >> 8) /* Random */

	/* TLB Context Register */
#define CONTEXT_PTEMASK	(0x7FF << 21) /* Page Table */
#define CONTEXT_PTE(a)	((a & CONTEXT_PTEMASK) >> 21)	/* Page Table */
#define CONTEXT_BADVPNMASK	(0x7FFFF << 2) /* Bad Virtual Page Number */
#define CONTEXT_BADVPN(a)	((a & CONTEXT_BADVPNMASK) >> 2)	/* Bad Virtual Page Number */

#endif /* _PR3910_ */
