/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   pr31700s.h
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   CPU-dependent definitions for the PHILIPS pr31700 architecture
Revision    :   1.1
Note        :   1. Memory configuration
 			    2. Video control
 				3. SIB control
 				4. IR control
 				5. UART control
 				6. Interrupt
 				7. Timer
 				8. SPI control
 				9. Multi-function IO
 				10. Clock control
 				11. Power control
 				12. CHI control
===========================================================================
*/              


#ifndef _PR31700S_
#define _PR31700S_

/* Base address of CPU registers */
#define CPU_REGS_BASE_ADDR		0xB0C00000
#define SDRAM_BANK_0_REG		0xB0E00000
#define SDRAM_BANK_1_REG		0xB0F00000

	/* Memory configuration */
#define MEM_CONFIG_0		0x000
#define MEM_CONFIG_1		0x004
#define MEM_CONFIG_2		0x008
#define MEM_CONFIG_3		0x00C
#define MEM_CONFIG_4		0x010
#define MEM_CONFIG_5		0x014
#define MEM_CONFIG_6		0x018
#define MEM_CONFIG_7		0x01C
#define MEM_CONFIG_8		0x020

	/* Video control */
#define VIDEO_CTRL_1		0x028
#define VIDEO_CTRL_2		0x02C
#define VIDEO_CTRL_3		0x030
#define VIDEO_CTRL_4		0x034
#define VIDEO_CTRL_5		0x038
#define VIDEO_CTRL_6		0x03C
#define VIDEO_CTRL_7		0x040
#define VIDEO_CTRL_8		0x044
#define VIDEO_CTRL_9		0x048
#define VIDEO_CTRL_10		0x04C
#define VIDEO_CTRL_11		0x050
#define VIDEO_CTRL_12		0x054
#define VIDEO_CTRL_13		0x058
#define VIDEO_CTRL_14		0x05C

	/* SIB control */
#define SIB_SIZE			0x060
#define SIB_SND_RX_START	0x064
#define SIB_SND_TX_START	0x068
#define SIB_TEL_RX_START	0x06C
#define SIB_TEL_TX_START	0x070
#define SIB_CTRL			0x074
#define SIB_SND_HLDG		0x078
#define SIB_TEL_HLDG		0x07C
#define SIB_SF0_CTRL		0x080
#define SIB_SF1_CTRL		0x084
#define SIB_SF0_STATUS		0x088
#define SIB_SF1_STATUS		0x08C
#define SIB_DMA_CTRL		0x090

	/* IR control */
#define IR_CTRL_1			0x0A0
#define IR_CTRL_2			0x0A4
#define IR_HLDG				0x0A8

	/* UART control */
#define UARTA_CTRL_1		0x0B0
#define UARTA_CTRL_2		0x0B4
#define UARTA_DMA_CTRL_1	0x0B8
#define UARTA_DMA_CTRL_2	0x0BC
#define UARTA_DMA_CNT		0x0C0
#define UARTA_HLDG			0x0C4
#define UARTB_CTRL_1		0x0C8
#define UARTB_CTRL_2		0x0CC
#define UARTB_DMA_CTRL_1	0x0D0
#define UARTB_DMA_CTRL_2    0x0D4
#define UARTB_DMA_CNT       0x0D8
#define UARTB_HLDG          0x0DC

	/* Interrupt */
#define INT_STATUS_1        0x100
#define INT_STATUS_2        0x104
#define INT_STATUS_3        0x108
#define INT_STATUS_4        0x10C
#define INT_STATUS_5        0x110
#define INT_STATUS_6        0x114
#define INT_ENABLE_1        0x118
#define INT_ENABLE_2        0x11C
#define INT_ENABLE_3        0x120
#define INT_ENABLE_4        0x124
#define INT_ENABLE_5        0x128
#define INT_ENABLE_6        0x12C

	/* Timer */
#define RTC_HIGH            0x140
#define RTC_LOW             0x144
#define ALARM_HIGH          0x148
#define ALARM_LOW           0x14C
#define TIMER_CTRL          0x150
#define PERIODIC_TIMER      0x154

	/* SPI control */
#define SPI_CTRL            0x160
#define SPI_HLDG            0x164

	/* Multi-function IO */
#define IO_CTRL             0x180
#define MFIO_DATA_OUT       0x184
#define MFIO_DIRECTN        0x188
#define MFIO_DATA_IN        0x18C
#define MFIO_SEL            0x190
#define IO_POWER_DOWN       0x194
#define MFIO_POVER_DOWN     0x198

	/* Clock control */
#define CLK_CTRL            0x1C0

	/* Power control */
#define POWER_CTRL          0x1C4
#define SIU_TEST            0x1C8

	/* CHI control */
#define CHI_CTRL            0x1D8
#define CHI_PTR_ENABLE      0x1DC
#define CHI_RX_PTR_A        0x1E0
#define CHI_RX_PTR_B        0x1E4
#define CHI_TX_PTR_A        0x1E8
#define CHI_TX_PTR_B        0x1EC
#define CHI_SIZE            0x1F0
#define CHI_RX_START        0x1F4
#define CHI_TX_START        0x1F8
#define CHI_HLDG            0x1FC

/* CPU register bit definition */

	/* Memory configuration 0 register */
#define BANK1CONFMASK		(3 << 18)
#define BANK0CONFMASK		(3 << 16)
#define ROWSEL1MASK			(3 << 14)
#define ROWSEL0MASK			(3 << 12)
#define COLSEL1MASK			(0xF << 8)
#define COLSEL0MASK			(0xF << 4)

#define ENDCLKOUTTRI		(1 << 30)
#define DISDQMINIT			(1 << 29)
#define ENSDRAMPD			(1 << 28)
#define SHOWCPUID			(1 << 27)
#define ENRMAP2				(1 << 26)
#define ENRMAP1				(1 << 25)
#define ENWRINPAGE			(1 << 24)
#define ENCS3USER			(1 << 23)
#define ENCS2USER			(1 << 22)
#define ENCS1USER			(1 << 21)
#define ENCS1DRAM			(1 << 20)
#define BANK1CONF(a)		((a << 18) & BANK1CONFMASK)
#define BANK0CONF(a)		((a << 16) & BANK0CONFMASK)
#define ROWSEL1(a)			((a << 14) & ROWSEL1MASK)
#define ROWSEL0(a)			((a << 12) & ROWSEL0MASK)
#define COLSEL1(a)			((a << 8) & COLSEL1MASK)
#define COLSEL0(a)			((a << 4) & COLSEL0MASK)
#define CS3SIZE				(1 << 3)
#define CS2SIZE				(1 << 2)
#define CS1SIZE				(1 << 1)
#define CS0SIZE				(1 << 0)

	/* Memory configuration 1 register */
#define MCS3ACCVAL1MASK		(0xF << 28)
#define MCS3ACCVAL2MASK		(0xF << 24)
#define MCS2ACCVAL1MASK		(0xF << 20)
#define MCS2ACCVAL2MASK		(0xF << 16)
#define MCS1ACCVAL1MASK		(0xF << 12)
#define MCS1ACCVAL2MASK		(0xF << 8)
#define MCS0ACCVAL1MASK		(0xF << 4)
#define MCS0ACCVAL2MASK		(0xF << 0)

#define MCS3ACCVAL1(a)		((a << 28) & MCS3ACCVAL1MASK)
#define MCS3ACCVAL2(a)		((a << 24) & MCS3ACCVAL2MASK)
#define MCS2ACCVAL1(a)		((a << 20) & MCS2ACCVAL1MASK)
#define MCS2ACCVAL2(a)		((a << 16) & MCS2ACCVAL2MASK)
#define MCS1ACCVAL1(a)		((a << 12) & MCS1ACCVAL1MASK)
#define MCS1ACCVAL2(a)		((a << 8) & MCS1ACCVAL2MASK)
#define MCS0ACCVAL1(a)		((a << 4) & MCS0ACCVAL1MASK)
#define MCS0ACCVAL2(a)		((a << 0) & MCS0ACCVAL2MASK)

	/* Memory configuration 2 register */
#define CS3ACCVAL1MASK		(0xF << 28)
#define CS3ACCVAL2MASK		(0xF << 24)
#define CS2ACCVAL1MASK		(0xF << 20)
#define CS2ACCVAL2MASK		(0xF << 16)
#define CS1ACCVAL1MASK		(0xF << 12)
#define CS1ACCVAL2MASK		(0xF << 8)
#define CS0ACCVAL1MASK		(0xF << 4)
#define CS0ACCVAL2MASK		(0xF << 0)

#define CS3ACCVAL1(a)		((a << 28) & CS3ACCVAL1MASK)
#define CS3ACCVAL2(a)		((a << 24) & CS3ACCVAL2MASK)
#define CS2ACCVAL1(a)		((a << 20) & CS2ACCVAL1MASK)
#define CS2ACCVAL2(a)		((a << 16) & CS2ACCVAL2MASK)
#define CS1ACCVAL1(a)		((a << 12) & CS1ACCVAL1MASK)
#define CS1ACCVAL2(a)		((a << 8) & CS1ACCVAL2MASK)
#define CS0ACCVAL1(a)		((a << 4) & CS0ACCVAL1MASK)
#define CS0ACCVAL2(a)		((a << 0) & CS0ACCVAL2MASK)

	/* Memory cofiguration 3 register */
#define CARD2ACCVALMASK		(0xF << 28)
#define CARD1ACCVALMASK		(0xF << 24)
#define CARD2IOACCVALMASK	(0xF << 20)
#define CARD1IOACCVALMASK	(0xF << 16)

#define CARD2ACCVAL(a)		((a << 28) & CARD2ACCVALMASK)
#define CARD1ACCVAL(a)		((a << 24) & CARD1ACCVALMASK)
#define CARD2IOACCVAL(a)	((a << 20) & CARD2IOACCVALMASK)
#define CARD1IOACCVAL(a)	((a << 16) & CARD1IOACCVALMASK)
#define ENMCS3PAGE			(1 << 15)
#define ENMCS2PAGE			(1 << 14)
#define ENMCS1PAGE			(1 << 13)
#define ENMCS0PAGE			(1 << 12)
#define ENCS3PAGE			(1 << 11)
#define ENCS2PAGE			(1 << 10)
#define ENCS1PAGE			(1 << 9)
#define ENCS0PAGE  			(1 << 8)
#define CARD2WAITEN			(1 << 7)
#define CARD1WAITEN			(1 << 6)
#define CARD2IOEN			(1 << 5)
#define CARD1IOEN			(1 << 4)
#define _8PORTSEL			(1 << 3)

	/* Memory configuration 4 register */
#define WATCHTIMEVALMASK	(0xF << 20)
#define RFSHVAL1MASK		(0x3F << 8)
#define RFSHVAL0MASK		(0x3F << 0)

#define ENEDOBANK1			(1 << 31)
#define ENEDOBANK0			(1 << 30)
#define ENARB				(1 << 29)
#define DISSNOOP			(1 << 28)
#define CLRWRBUSERRINT		(1 << 27)
#define ENBANK1OPT			(1 << 26)
#define ENBANK0OPT			(1 << 25)
#define ENWATCH				(1 << 24)
#define WATCHTIMEVAL(a)		(a << 20)
#define MEMPOWERDOWN		(1 << 16)
#define ENRFSH1				(1 << 15)
#define ENRFSH0				(1 << 14)
#define RFSHVAL1(a)			((a << 8) & RFSHVAL1MASK)
#define RFSHVAL0(a)			((a << 0) & RFSHVAL0MASK)

	/* Memory configuration 5 register */
#define STARTVAL2MASK		(0x7FFFFF << 9)
#define MASK2MASK    		(0xF << 0)

#define STARTVAL2(a) 		((a << 9) & STARTVAL2MASK)
#define MASK2(a)			((a << 0) & MASK2MASK)

	/* Memory configuration 6 register */
#define STARTVAL1MASK		(0x7FFFFF << 9)
#define MASK1MASK    		(0xF << 0)

#define STARTVAL1(a) 		((a << 9) & STARTVAL1MASK)
#define MASK1(a)			((a << 0) & MASK1MASK)

	/* Memory configuration 7 register */
#define RMAPADD2MASK		(0x7FFFFF << 9)

#define RMAPADD2(a)			((a << 9) & STARTVAL1MASK)

	/* Memory configuration 8 register */
#define RMAPADD1MASK		(0x7FFFFF << 9)

#define RMAPADD1(a)			((a << 9) & STARTVAL1MASK)

        /*      Video Control 1 Register        */
#define LINECNTMASK                     (0x3FF << 22)
#define BAUDVALMASK                     (0x1F << 16)
#define VIDDONEVALMASK                  (0x7F << 9)
#define BITSELMASK                      (3 << 6)

#define LINECNT(a)                      ((a << 22) & LINECNTMASK)
#define LOADDLY                         (1 << 21)
#define BAUDVAL(a)                      ((a << 16) & BAUDVALMASK)
#define VIDDONEVAL(a)                   ((a << 9) & VIDDONEVALMASK)
#define ENFREEZEFRAME                   (1 << 8)
#define BITSEL(a)                       ((a << 6) & BITSELMASK)
#define DISPSPLIT                       (1 << 5)
#define DISP8                           (1 << 4)
#define DFMODE                          (1 << 3)
#define INVVID                          (1 << 2)
#define DISPON                          (1 << 1)
#define ENVID                           (1 << 0)

        /*      Video Control 2 Register        */
#define VIDRATEMASK                     (0x3FF << 22)
#define HORZVALMASK                     (0x1FF << 12)
#define LINEVALMASK                     (0x3FF << 0)

#define VIDRATE(a)                      ((a << 22) & VIDRATEMASK)
#define HORZVAL(a)                      ((a << 12) & HORZVALMASK)
#define LINEVAL(a)                      ((a << 0) & LINEVALMASK)

        /*      Video Control 3 Register        */
#define VIDBANKMASK                     (0xFFF << 20)
#define VIDBASEHIMASK                   (0xFFFF << 4)

#define VIDBANK(a)                      ((a << 20) & VIDBANKMASK)
#define VIDBASEHI(a)                    ((a << 4) & VIDBASEHIMASK)

        /*      Video Control 4 Register        */
#define DFVALMASK                       (0xFF << 24)
#define FRAMEMASKVALMASK                (0xF << 20)
#define VIDBASELOMASK                   (0xFFFF << 4)

#define DFVAL(a)                        ((a << 24) & DFVALMASK)
#define FRAMEMASKVAL(a)                 ((a << 20) & FRAMEMASKVALMASK)
#define VIDBASELO(a)                    ((a << 4) & VIDBASELOMASK)

        /*      SIB Size Register    */
#define SNDSIZEMASK                     (0xFFF << 18)
#define TELSIZEMASK                     (0xFFF << 2)

#define SNDSIZE(a)                      ((a << 16) & SNDSIZEMASK)
#define TELSIZE(a)                      ((a << 0) & TELSIZEMASK)

        /*      SIB Sound Receive Start */
#define SNDRXSTARTMASK                  (0x3FFFFFFF << 2)

#define SNDRXSTART(a)                   ((a << 0) & SNDRXSTARTMASK)

        /*      SIB Sound Transmit Start        */
#define SNDTXSTARTMASK                  (0x3FFFFFFF << 2)

#define SNDTXSTART(a)                   ((a << 0) & SNDRXSTARTMASK)

        /*      SIB Tel Receive Start   */
#define TELRXSTARTMASK                  (0x3FFFFFFF << 2)

#define TELRXSTART(a)                   ((a << 0) & TELRXSTARTMASK)

        /*      SIB Tel Transmit Start  */
#define TELTXSTARTMASK                  (0x3FFFFFFF << 2)

#define TELTXSTART(a)                   ((a << 0) & TELRXSTARTMASK)

        /*      SIB Control     */
#define SCLKDIVMASK                     (7 << 24)
#define TELFSDIVMASK                    (0x7F << 16)
#define SNDFSDIVMASK                    (0x7F << 8)

#define SIBIRQ                          (1 << 31)
#define ENCNTTEST                       (1 << 30)
//#define ENDMATEST                       (1 << 29)
#define SNDMONO                         (1 << 28)
#define RMONOSNDIN                      (1 << 27)
#define SCLKDIV(a)                      ((a << 24) & SCLKDIVMASK)
#define TEL16                           (1 << 23)
#define TELFSDIV(a)                     ((a << 16) & TELFSDIVMASK)
#define SND16                           (1 << 15)
#define SNDFSDIV(a)                     ((a << 8) & SNDFSDIVMASK)
#define SELTELSF1                       (1 << 7)
#define SELSNDSF1                       (1 << 6)
#define ENTEL                           (1 << 5)
#define ENSND                           (1 << 4)
#define SIBLOOP                         (1 << 3)
#define ENSF1                           (1 << 2)
#define ENSF0                           (1 << 1)
#define ENSIB                           (1 << 0)

        /*      SIB Subframe 1 Control Register */
#define SF0ADDRMASK                     (0xF << 27)
#define SF0DATAMASK                     (0xFFFF << 0)

#define SF0ADDR(a)                      ((a << 27) & SF0ADDRMASK)
#define SF0WRITEBIT                     (1 << 26)
#define SF0AUDVALIDFLAG                 (1 << 17)
#define SF0TELVALIDFLAG                 (1 << 16)
#define SF0DATA(a)                      ((a << 0) & SF0DATAMASK)

        /*      SIB DMA Control Register        */
#define SNDDMAPTRMASK                   (0xFFF << 18)
#define TELDMAPTRMASK                   (0xFFF << 2)

#define SNDBUFF1TIME                    (1 << 31)
#define SNDDMALOOP                      (1 << 30)
#define ENDMARXSND                      (1 << 17)
#define ENDMATXSND                      (1 << 16)
#define TELBUFF1TIME                    (1 << 15)
#define TELDMALOOP                      (1 << 14)
#define ENDMARXTEL                      (1 << 1)
#define ENDMATXTEL                      (1 << 0)

        /*      UART Control 1 Register */
#define UARTON                          (1 << 31)
#define EMPTY                           (1 << 30)
#define PRXHOLDFULL                     (1 << 29)
#define RXHOLDFULL                      (1 << 28)
#define ENDMARX                         (1 << 15)
#define ENDMATX                         (1 << 14)
#define TESTMODE                        (1 << 13)
#define ENBREAKHALT                     (1 << 12)
#define ENDMATEST                       (1 << 11)
#define ENDMALOOP                       (1 << 10)
#define PULSEOPT2                       (1 << 9)
#define PULSEOPT1                       (1 << 8)
#define DTINVERT                        (1 << 7)
#define DISTXD                          (1 << 6)
#define TWOSTOP                         (1 << 5)
#define LOOPBACK                        (1 << 4)
#define BIT_7                           (1 << 3)
#define EVENPARITY                      (1 << 2)
#define ENPARITY                        (1 << 1)
#define ENUART                          (1 << 0)

        /*      UART Control 2 Register */
#define BAUDRATEMASK                    (0x3FF << 0)

#define BAUDRATE(a)                     ((a << 0) & BAUDRATEMASK)

        /*      UART Control 3 Register */
#define BAUDRATEMASK                    (0x3FF << 0)

#define BAUDRATE(a)                     ((a << 0) & BAUDRATEMASK)

        /*      UART DMA Control 1 Register     */
#define DMASTARTVALMASK                 (0x3FFFFFFF << 2)

#define DMASTARTVAL(a)                  ((a << 2) & DMASTARTVALMASK)

        /*      UART DMA Control 2 Register     */
#define DMALENGTHMASK                   (0xFFFF << 0)

#define DMALENGTH(a)                    ((a << 0) & DMALENGTHMASK)

        /*      UART DMA Count  */
#define DMACNTMASK                      (0xFFFF << 0)

#define DMACNT(a)                       ((a << 0) & DMACNTMASK)

        /*      UART Transmit Holding Register  */
#define TXDATAMASK                      (0xFF << 0)

#define BREAK                           (1 << 8)
#define TXDATA(a)                       ((a << 0) & TXDATAMASK)

        /*      UART Receiver Holding Register  */
#define RXDATAMASK                      (0xFF << 0)

#define RXDATA(a)                       ((a << 0) & RXDATAMASK)

	/* Interrupt status and enable 1 register */
#define LCDINT				(1 << 31)
#define DFINT               (1 << 30)
#define CHI0_5INT           (1 << 29)
#define CHI1_0INT           (1 << 28)
#define CHIDMACNTINT        (1 << 27)
#define CHIININTA           (1 << 26)
#define CHIININTB           (1 << 25)
#define CHIACTINT           (1 << 24)
#define CHIERRINT           (1 << 23)
#define SND0_5INT           (1 << 22)
#define SND1_0INT           (1 << 21)
#define TEL0_5INT           (1 << 20)
#define TEL1_0INT           (1 << 19)
#define SNDDMACNTINT        (1 << 18)
#define TELDMACNTINT        (1 << 17)
#define LSNDCLIPINT         (1 << 16)
#define RSNDCLIPINT         (1 << 15)
#define VALSNDPOSINT        (1 << 14)
#define VALSNDNEGINT        (1 << 13)
#define VALTELPOSINT        (1 << 12)
#define VALTELNEGINT        (1 << 11)
#define SNDININT            (1 << 10)
#define TELININT            (1 << 9)
#define SIBSF0INT           (1 << 8)
#define SIBSF1INT           (1 << 7)
#define SIBIRQPOSINT        (1 << 6)
#define SIBIRQNEGINT        (1 << 5)

	/* Interrupt status and enable 2 register */
#define UARTARXINT          (1 << 31)
#define UARTARXOVERRUNINT   (1 << 30)
#define UARTAFRAMEERRINT    (1 << 29)
#define UARTABREAKINT       (1 << 28)
#define UARTAPARITYERRINT   (1 << 27)
#define UARTATXINT          (1 << 26)
#define UARTATXOVERRUNINT   (1 << 25)
#define UARTAEMPTYINT       (1 << 24)
#define UARTADMAFULLINT     (1 << 23)
#define UARTADMAHALFINT     (1 << 22)
#define UARTBRXINT          (1 << 21)
#define UARTBRXOVERRUNINT   (1 << 20)
#define UARTBFRAMEERRINT    (1 << 19)
#define UARTBBREAKINT       (1 << 18)
#define UARTBPARITYERRINT   (1 << 17)
#define UARTBTXINT          (1 << 16)
#define UARTBTXOVERRUNINT   (1 << 15)
#define UARTBEMPTYINT       (1 << 14)
#define UARTBDMAFULLINT     (1 << 13)
#define UARTBDMAHALFINT     (1 << 12)

	/* Interrupt status and enable 3 register */
#define MFIOPOSINT(a)		(1 << a)

	/* Interrupt status and enable 4 register */
#define MFIONEGINT(a)		(1 << a)

	/* Interrupt status and enable 5 register */
#define IOPOSINTMASK        (0x7F << 7)
#define IONEGINTMASK        (0x7F << 0)

#define RTCINT              (1 << 31)
#define ALARMINT            (1 << 30)
#define PERINT              (1 << 29)
#define STPTIMERINT         (1 << 28)
#define POSPWRINT           (1 << 27)
#define NEGPWRINT           (1 << 26)
#define POSPWROKINT         (1 << 25)
#define NEGPWROKINT         (1 << 24)
#define POSONBUTNINT        (1 << 23)
#define NEGONBUTNINT        (1 << 22)
#define SPIBUFAVAILINT      (1 << 21)
#define SPIERRINT           (1 << 20)
#define SPIRCVINT           (1 << 19)
#define SPIEMPTYINT         (1 << 18)
#define IRCONSMINT          (1 << 17)
#define CARSTINT            (1 << 16)
#define POSCARINT           (1 << 15)
#define NEGCARINT           (1 << 14)
#define IOPOSINT(a)         ((1 << (a+7)) & IOPOSINTMASK)
#define IONEGINT(a)         ((1 << a) & IONEGINTMASK)

	/* Interrupt status 6 register */

#define IRQHIGH             (1 << 31)
#define IRQLOW              (1 << 30)
#define INTVECTMASK         (0xF << 2)
#define VECT_PWROKINT		(15 << 2)
#define VECT_ALARMINT		(14 << 2)
#define VECT_PERINT			(13 << 2)
#define VECT_UARTARXINT		(11 << 2)
#define VECT_UARTBRXINT		(10 << 2)
#define VECT_IOPOSINT_56	(8 << 2)
#define VECT_IONEGINT_56	(6 << 2)
#define VECT_SNDDMACNTINT	(4 << 2)
#define VECT_TELDMACNTINT	(3 << 2)
#define VECT_CHIDMACNTINT	(2 << 2)
#define VECT_IOINT_0		(1 << 2)

	/* Interrupt enable 6 register */
#define PRIORITYMASKMASK    (0xFFFF << 0)

#define GLOBALEN            (1 << 18)
#define IRQPRITEST          (1 << 17)
#define IRQTEST             (1 << 16)
#define PRIORITYMASK(a)     ((a << 0) & PRIORITYMASKMASK)
#define PRI_PWROKINT		(1 << 15)
#define PRI_ALARMINT		(1 << 14)
#define PRI_PERINT			(1 << 13)
#define PRI_UARTARXINT		(1 << 11)
#define PRI_UARTBRXINT		(1 << 10)
#define PRI_IOPOSINT_56		(1 << 8)
#define PRI_IONEGINT_56		(1 << 6)
#define PRI_SNDDMACNTINT	(1 << 4)
#define PRI_TELDMACNTINT	(1 << 3)
#define PRI_CHIDMACNTINT	(1 << 2)
#define PRI_IOINT_0			(1 << 1)
#define PRI_STDINT			(1 << 0)

        /*      RTC Register    */
#define RTCHIGHMASK                        (0x7F << 0)

#define RTCHIGH(a)                         ((a << 0) & RTCHIGHMASK)
#define RTCLOW(a)                         (a << 0)

        /*      Alarm Register  */
#define ALARMHIGHMASK                      (0x7F << 0)

#define ALARMHIGH(a)                       ((a << 0) & ALARMHIGHMASK)
#define ALARMLOW(a)                       (a << 0)

        /*      Timer Control Register  */
#define FREEZEPRE                       (1 << 7)
#define FREEZERTC                       (1 << 6)
#define FREEZETIMER                     (1 << 5)
#define ENPERTIMER                      (1 << 4)
#define RTCCLR                          (1 << 3)
#define TESTC8MS                        (1 << 2)
#define ENTESTCLK                       (1 << 1)
#define ENRTCTST                        (1 << 0)

        /*      Periodic Timer Register */
#define PERCNTMASK                      (0xFFFF << 16)
#define PERVALMASK                      (0xFFFF << 0)

#define PERCNT(a)                       ((a << 16) & PERCNTMASK)
#define PERVAL(a)                       ((a << 0) & PERVALMASK)

        /*      Clock Control Register  */
#define CHICLKDIVMASK                   (0xFF << 24)
#define SIBMCLKDIVMASK                  (7 << 8)
#define CSERDIVMASK                     (7 << 4)

#define CHICLKDIV(a)                    ((a << 24) & CHICLKDIVMASK)
#define ENCLKTEST                       (1 << 23)
#define CLKTESTSELSIB                   (1 << 22)
#define CHIMCLKSEL                      (1 << 21)
#define CHICLKDIR                       (1 << 20)
#define ENCHIMCLK                       (1 << 19)
#define ENVIDCLK                        (1 << 18)
#define ENMBUSCLK                       (1 << 17)
#define ENSPICLK                        (1 << 16)
#define ENTIMERCLK                      (1 << 15)
#define ENFASTTIMERCLK                  (1 << 14)
#define SIBMCLKDIR                      (1 << 13)
#define ENSIBMCLK                       (1 << 11)
#define SIBMCLKDIV(a)                   ((a << 8) & SIBMCLKDIVMASK)
#define CSERSEL                         (1 << 7)
#define CSERDIV(a)                      ((a << 4) & CSERDIVMASK)
#define ENCSERCLK                       (1 << 3)
#define ENIRCLK                         (1 << 2)
#define ENUARTACLK                      (1 << 1)
#define ENUARTBCLK                      (1 << 0)

		/*      Power Control Register  */
#define VIDRFMASK						(3 << 27)
#define STPTIMERVALMASK					(0xF << 12)

#define ONBUTN                          (1 << 31)
#define PWRINT                          (1 << 30)
#define PWROK                           (1 << 29)
#define VIDRF(a)                        ((a << 27) & VIDRFMASK)
#define SLOWBUS                         (1 << 26)
#define DIVMOD                          (1 << 25)
#define STPTIMERVAL(a)                  ((a << 12) & STPTIMERVALMASK)
#define ENSTPTIMER                      (1 << 11)
#define ENFORCESHUTDOWN                 (1 << 10)
#define FORCESHUTDOWN                   (1 << 9)
#define FORCESHUTDOWNOCC                (1 << 8)
#define SELC2MS                         (1 << 7)
#define BPDBVCC3                        (1 << 5)
#define STOPCPU                         (1 << 4)
#define DBNCONBUTN                      (1 << 3)
#define COLDSTART                       (1 << 2)
#define PWRCS                           (1 << 1)
#define VCCON                           (1 << 0)

#endif	/* _PR31700S_ */
