/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   tododb.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __TODODB_H_
#define __TODODB_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "todo.h"
#include "alarmgr.h"

/*****************************************************************
************** Global Variables APPLICATIONS STATUS **************
*****************************************************************/
typedef struct _AppStatus
{
	RecordID	rec_id;				/* the rec_id */
	RecordID	sound_rec_id;
	BYTE		completed_status;
	BYTE		alarm_status;
	BYTE		priority_status;
	SHORT		sch_year;
	SHORT		sch_month;
	SHORT		sch_day;
	SHORT		alarm_year;
	SHORT		alarm_month;
	SHORT		alarm_day;
	BYTE		edit_mode;			/* 0= TO_DO_NEW, 1= TO_DO_VIEWING */
	BYTE		new_sort_mode;
}AppStatus;

typedef struct _CheckStatus
{
	BYTE		completed_status;
	BYTE		alarm_status;
	BYTE		priority_status;
	SHORT		sch_year;
	SHORT		sch_month;
	SHORT		sch_day;
	SHORT		alarm_year;
	SHORT		alarm_month;
	SHORT		alarm_day;
	BOOLEAN		field_change;
	BYTE		new_entry_hit;
}CheckStatus;

/*****************************************************************
***************** Global Variables ALARM_SETTINGS ****************
*****************************************************************/
typedef struct _ALARM_SETTINGS
{
	DatabaseID	dbid;
	RecordID	temp_recid;
	BOOLEAN		rec_stop;
	BOOLEAN		play_stop;
	BOOLEAN		recorded;
	UWORD		play_pause_frame;
	BYTE		temp_alarm_status;
}AlarmSettings;

/*==================== To Do Records =========================*/
typedef	struct _RecordIDBlock
{
	BYTE		num_records;
	RecordID	record_id[20];
	DatabaseID	dbid[20];
	struct		_RecordIDBlock *next;
}RecordIDBlock;

typedef	struct _TableDisplay
{	
	ObjectID	table_id;
	USHORT		num_rows_displayed;
	USHORT		total_num_rows;
	USHORT		top_row_num;
	RecordIDBlock *record_id_block;
}TableDisplay;

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern DatabaseID	tdl_dbid;
//extern UWORD		do_tone_on[16];
//extern UWORD		do_voice_on[16];
//extern UWORD		do_no_alarm[16];
extern ObjectID		pressed_object1;
extern ObjectID		pressed_object2;
extern BYTE			restart_form;
extern BYTE			detail_date;
extern BYTE			alarm_date;
extern BYTE			show_line;
extern BYTE			entry_hit;
extern BOOLEAN		pen_down;
extern BOOLEAN		edit_change;
extern WORD			field_top_line, field_insert_pt_pos;
extern ObjectID		low_memory_form_id;
extern BOOLEAN		entry_low_memory, entry_old_edit;

/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
BOOLEAN ToDoTableDisplayDraw(TableDisplay *table_display);
BOOLEAN TableDisplayDeleteAllRecordID(TableDisplay *table_display);
BOOLEAN ToDoListSetTableTopRowNum(BYTE sorted_by, UWORD top_record);
BOOLEAN ToDoCompareScheduleDay(DatabaseID dbid, RecordID rec_id, BOOLEAN shift);
BOOLEAN ToDoCompareAlarmDay(USHORT input_year, USHORT input_month, USHORT input_day);
void ToDoDatabaseInit();
void TableDisplayInsertRecordID(TableDisplay *table_display, RecordID record_id,DatabaseID dbid);
void ToDoRecordToTable(DatabaseID dbid, BYTE sorted_by);
void ToDoListSortPriority(RecordID *priority_table, UWORD total_num);
void ToDoListDatabaseChecking();
void ToDoSoundDatabaseChecking();
void ToDoSetAllRecordsAlarm(UWORD rec_num);
void ToDoDelAnAlarm(RecordID rec_id);
void ToDoSetNextRecordAlarm(RecordID alarmhit_rec_id);
void ToDoListAppRestore(BOOLEAN restart);
void ToDoListAppSave();

#endif
