/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   todofunc.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __TODOFUNC_H_
#define __TODOFUNC_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "SySetup.h"
#include "Todo.h"
#include "ToDoDB.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern TableDisplay	to_do_list;
extern DatabaseID	tdl_dbid;
extern BYTE **		tdl_field_buffer;
extern BYTE		alarm_date, detail_date, alarm_set_by;
extern BYTE		show_line, table_font;
extern ObjectID		no_bat_cause;
extern WORD			field_top_line, field_insert_pt_pos;
extern USHORT		time_count;


/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
BOOLEAN ToDoSetUpFieldScreen(ObjectID form_id);
BOOLEAN ToDoFieldSetScrollbar(ObjectID field_id, ObjectID scrollbar_id);
BOOLEAN ToDoEditSetField(ObjectID form_id, ObjectID field_id);
BOOLEAN ToDoListSetScrollbar();
BOOLEAN ToDoFieldUpdateRecord();
BOOLEAN ToDoListChangeFont();
BOOLEAN ToDoListDisplayGetRecordID(TableDisplay *table_display, USHORT row_num, 
								   RecordID *rec_id, DatabaseID *dbid);
BOOLEAN	ToDoCheckAnyChange ();
USHORT TableFindCellNumber(EvtType *Event, TableDisplay *table_display);
Err ToDoListGetClickedCell(	ObjectID table_id, SHORT x_coord, SHORT y_coord,
							USHORT *row_number, USHORT *col_number, USHORT *cell_number);
BOOLEAN ToDoListTableSetScrollbar();
BOOLEAN ToDoViewingSelectedLargeFontOnly();
BOOLEAN ToDoYearShiftUpdate(BOOLEAN shift);
void ToDoScrollbarSetField(ObjectID field_id, ObjectID scrollbar_id, EvtType *Event);
void ToDoViewingSetUpScreen();
void ToDoDateSettingSetUpScreen();
void ToDoChangeUpdateRecord();
void ToDoUnchangeRecord();
void ToDoNewEditScreen();
void ToDoEditExistField();
void ToDoScrollbarSetTable(EvtType *Event);
void ToDoScrollbarSetToDoNew(EvtType *Event);
void ToDoScrollbarSetToDoViewing(EvtType *Event);
void ToDoScrollbarSetReplayVoice(EvtType *Event);
void ToDoAlarmSetUpScreen();
void ToDoFieldToFieldBuffer();
void ToDoFieldBufferToField();
void ToDoInitFieldBuffer();
void ToDoClearFieldBuffer();
void ToDoRecordToFieldBuffer();
void ToDoSetStartOfWeekScreen();
void ToDoDateSettingsUpdate();
void ToDoYearSettingUpdate(SHORT *input_year);
void ToDoSetTableFont();
void ToDoRecordToVariable();
void ToDoPurgeRecord();
void ToDoDateUpdateRecord(SHORT new_year, SHORT new_month, SHORT new_day, USHORT field_num);
void ToDoUpdateCompleteOrPriorityField(USHORT field_num, BYTE org_info);
void ToDoPackDueDate(BYTE *ptr, SHORT year, SHORT month, SHORT day);
void ToDoMenuSelectedAction(USHORT item_num);
void ToDoNewSetUpVariable();
BOOLEAN ToDoSoundRecordStart();
BOOLEAN ToDoSoundReplayStart();
void ToDoSoundReplayStop();
void ToDoSoundRecordStop();
void ToDoFindOutAlarmSetBy ();

#endif
