/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
//#include "resource.h"
#include "kernel.h"
#include "resmgr.h"
#include "ui.h"
#include "uifunc.h"
#include "inlay.h"
#include "system.h"
#include "dev_pwr.h"
#include "todo.h"
#include "todofunc.h"
#include "tododb.h"
#include "ToDoLch.h"
#include "sysetup.h"
#include "alarmgr.h"

///#define      DEBUG

extern UWORD _fdata, etext, _fbss, ebss;
#ifdef PR31700
BOOLEAN (*FormDispatchEvent)(EvtType *Event);
#endif
/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);
AppID app_id;

extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif



/* ==================================================================== */
/* ========================= Global Defines =========================== */
/* ==================================================================== */

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
extern UBYTE	res_data[];
BOOLEAN		restore_status;

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		
		switch (form_id)
		{
		case FORM_TO_DO_LIST:   /* Form 1 */
			FormSetEventHandler(FORM_TO_DO_LIST,(void**)&FormDispatchEvent,(void*)SchedulerToDoList);
			break;
		case FORM_TO_DO_NEW:	/* Form 2 */
			FormSetEventHandler(FORM_TO_DO_NEW,(void**)&FormDispatchEvent,(void*)SchedulerToDoNew);
			break;
		case FORM_TO_DO_VIEWING:/* Form 3 */	
			FormSetEventHandler(FORM_TO_DO_VIEWING,(void**)&FormDispatchEvent,(void*)SchedulerToDoViewing);
			break;
		case FORM_DATE_SETTINGS:/* Form 4 */
			FormSetEventHandler(FORM_DATE_SETTINGS,(void**)&FormDispatchEvent,(void*)SchedulerDateSettings);
			break;
		case FORM_REPLAY_VOICE:	/* Form 8 */
			FormSetEventHandler(FORM_REPLAY_VOICE,(void**)&FormDispatchEvent,(void*)SchedulerReplayVoice);
			break;
		case FORM_ALARM_SETTINGS:/* Form 9 */
			FormSetEventHandler(FORM_ALARM_SETTINGS,(void**)&FormDispatchEvent,(void*)SchedulerAlarmSettings);
			break;
		case FORM_TO_DO_PREF:	/* Form 10 */
			FormSetEventHandler(FORM_TO_DO_PREF,(void**)&FormDispatchEvent,(void*)SchedulerToDoPref);
			break;
		case FORM_TO_DO_DETAILS:/* Form 11 */
			FormSetEventHandler(FORM_TO_DO_DETAILS,(void**)&FormDispatchEvent,(void*)SchedulerToDoDetails);
			break;
		case FORM_SAVE_CHANGES:	/* Form 12 */
			FormSetEventHandler(FORM_SAVE_CHANGES,(void**)&FormDispatchEvent,(void*)SchedulerSaveChanges);
			break;
		case FORM_ITEM_ERASE:	/* Form 13 */
			FormSetEventHandler(FORM_ITEM_ERASE,(void**)&FormDispatchEvent,(void*)SchedulerItemErase);
			break;
		case FORM_ALARM_DATE_SETTINGS:/* Form 14 */
			FormSetEventHandler(FORM_ALARM_DATE_SETTINGS,(void**)&FormDispatchEvent,(void*)SchedulerAlarmDateSettings);
			break;
		case FORM_NO_DUE_DATE:/* Form 15 */
			FormSetEventHandler(FORM_NO_DUE_DATE,(void**)&FormDispatchEvent,(void*)SchedulerNoDueDate);
			break;
		case FORM_RECORD_VOICE: /* Form 16 */
			FormSetEventHandler(FORM_RECORD_VOICE,(void**)&FormDispatchEvent,(void*)SchedulerRecordVoice);
			break;
		case FORM_TO_DO_PURGE:	/* Form 17 */
			FormSetEventHandler(FORM_TO_DO_PURGE,(void**)&FormDispatchEvent,(void*)SchedulerPurgeRecord);
			break;
		case FORM_TO_DO_VOICE_EXISTS:/* Form 18 */
			FormSetEventHandler(FORM_TO_DO_VOICE_EXISTS,(void**)&FormDispatchEvent,(void*)SchedulerAlarmVoiceMemoExists);
			break;
		case FORM_TO_DO_NO_MEM:/* Form 19 */
			FormSetEventHandler(FORM_TO_DO_NO_MEM,(void**)&FormDispatchEvent,(void*)SchedulerToDoNoMem);
			break;
		case FORM_INVALID_ALARM_INPUT:/* Form 20 */
			FormSetEventHandler(FORM_INVALID_ALARM_INPUT,(void**)&FormDispatchEvent,(void*)SchedulerToDoInvalidAlarmInput);
			break;
		case FORM_TO_DO_NO_BAT:/* Form 21 */
			FormSetEventHandler(FORM_TO_DO_NO_BAT,(void**)&FormDispatchEvent,(void*)SchedulerToDoNoBat);
			break;
		case FORM_SYSTEM_LOW_MEM:/* Form 22 */
			FormSetEventHandler(FORM_SYSTEM_LOW_MEM,(void**)&FormDispatchEvent,(void*)SchedulerSysLowMem);
			break;
			
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		
		if (!SystemHandleEvent(&event))
		{		
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);
				
		}	
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}

/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
#ifdef PC_SIM
void LoadRes();
#endif

#ifdef PC_SIM
void main(WORD cmd, void *cmd_ptr)
#else
__main(WORD cmd, void *cmd_ptr)
#endif
{
#ifdef PC_SIM
	MsgQueueCreate (&msgQueue);
	EvtQueueCreate(&evtQueue);
	KeyboardInitKeyboard();
	MMUInit();
	ResInit();
	LcdInit();
	UIInit();
	LoadRes();
	
	cmd = LAUNCH_CMD_NORMAL_LAUNCH;
	//	cmd = LAUNCH_CMD_FIND;
	//	cmd = LAUNCH_CMD_GOTO_REC;
	//	cmd = LAUNCH_CMD_ALARM_HIT;
	
	if (cmd == LAUNCH_CMD_NORMAL_LAUNCH)
	{
		cmd_ptr = NULL;
		ToDoDatabaseInit();
	}
	else if (cmd == LAUNCH_CMD_FIND)
	{
		cmd_ptr = (BYTE*)pmalloc(30*sizeof(BYTE));
		strcpy((BYTE*)cmd_ptr, (BYTE*)("A"));
	}
	else if (cmd == LAUNCH_CMD_GOTO_REC)
	{
		cmd_ptr = (GotoRec*)pmalloc(sizeof(GotoRec));
		((GotoRec*)cmd_ptr)->dbid = tdl_dbid;
		((GotoRec*)cmd_ptr)->rec_id = 1000;
		((GotoRec*)cmd_ptr)->field_num = 5;
		((GotoRec*)cmd_ptr)->find_string = (BYTE*)pmalloc(30*sizeof(BYTE));
		strcpy(((GotoRec*)cmd_ptr)->find_string, (BYTE*)("powerful"));
		//		((GotoRec*)cmd_ptr)->find_string = NULL;
		
		ToDoDatabaseInit();
	}
	else
	{
		cmd_ptr = NULL;
	}
	
#endif
	
	ToDoAppLaunch(cmd, (void*)cmd_ptr);
	
}

/********************************************************
* Function:	LoadRes
* Purpose: 	Load the Resource Data
* Scope:	Application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
#ifdef PC_SIM
void LoadRes()
{
	UBYTE *ptr;
	UWORD *ptable;
	AppID app_id;
    unsigned long res_size = 25369;
	unsigned long i;
	
	MemoryInstallProg(TODOLIST, res_size, 0, FALSE, 0, &app_id, (UBYTE **) &ptr, (UWORD **)&ptable);
	
	if(ptr == NULL)
	{
		return;
	}
	for(i=0;i<res_size;i++)
		ptr[i] = res_data[i];
}
#endif
