/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   todo.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/


#include "stdafx.h"
#include "uidef.h"
#include "uifunc.h"
#include "dev_pwr.h"
#include "Todo.h"
#include "ToDoFunc.h"
#include "ToDoDB.h"
#include "todosize.h"

//#define      DEBUG

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
DatabaseID	tdl_dbid;
ObjectID	pressed_object1, pressed_object2, no_bat_cause;
BYTE		alarm_date, detail_date, alarm_set_by;
BYTE **		tdl_field_buffer;
BYTE		restart_form, show_line, table_font;
BOOLEAN		edit_change, pen_down, goto_highlight;
USHORT		time_count = 0;
SHORT		backup_year, backup_month, backup_day;
WORD		field_top_line, field_insert_pt_pos;
ObjectID	low_memory_form_id;
BOOLEAN		entry_low_memory, entry_old_edit;


/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/
/******************************************************************
* Function:	SchedulerToDoList
* Purpose: 	This function is the event handler for the 
*			TO DO LIST of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerToDoList(EvtType* Event)
{	
#ifdef PR31700
    AppID		appid;
#endif
	static ObjectID old_cell_ui_id;
	static	SHORT	highlight_row;
	static	BOOLEAN	not_table_clear = FALSE;
	BYTE		*buffer, object_type, priority;
	BYTE            text_color, text_bg_color;
	USHORT		table_row_num;
	USHORT		row_number, col_number, cell_number;
	UWORD		rec_num, byte_read, table_return;
	RecordID	rec_id;
	ObjectID	cell_ui_id;
	Table		*table_addr;
	String		*string_addr, *table_string;
	Form		*form_addr;
	Bitmap		*bitmap_addr;
	Err		result;	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_NEW_RECORD;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_PURGE || Event->para1 == SLETTER_PURGE)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_PURGE;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_SORT || Event->para1 == SLETTER_SORT)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_SORT_RECORD;
				Event->evtPBP = NULL;
			}			
			else if(Event->para1 == LLETTER_CATE || Event->para1 == SLETTER_CATE)
			{
				ControlPopupPopupTrigger(POPUP_TRIGGER_CATE);
				return	FALSE;
			}
		}	
	}
	
	switch (Event->eventType)
	{
		/* Draw the default screen */
	case	EVT_FORM_OPEN:
		app_status.edit_mode = TO_DO_LIST;
		restart_form = RESTART_TO_DO_LIST;
		
		FormGetObjectPointer(TABLE_FIRST_STRING, &object_type, (void **)&table_string);
		table_font = table_string->text_font;
		
		FormDrawForm(FORM_TO_DO_LIST);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		/* If NEW or SORT is clicked */
		if (Event->eventID == BUTTON_TO_DO_NEW_RECORD)
		{
			if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_TO_DO_LIST;
				FormPopupForm(FORM_SYSTEM_LOW_MEM);	
				return TRUE;
			}											
			
			if (FormGetObjectPointer(FORM_TO_DO_NEW, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_TO_DO_NEW);
			if (FormGetObjectPointer(FORM_TO_DO_DETAILS, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_TO_DO_DETAILS);
			
			ToDoInitFieldBuffer();
			/* Set up the Global variable */
			chk_status.field_change = FALSE;
			field_top_line = 0;
			field_insert_pt_pos = 0;
			ToDoNewSetUpVariable();
			FormPopupForm(FORM_TO_DO_NEW);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_TO_DO_SORT_RECORD)
		{
			if (FormGetObjectPointer(FORM_TO_DO_PREF, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_TO_DO_PREF);
			
			FormPopupForm(FORM_TO_DO_PREF);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_TO_DO_PURGE)
		{
			if (FormGetObjectPointer(FORM_TO_DO_PURGE, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_TO_DO_PURGE);
			
			FormPopupForm(FORM_TO_DO_PURGE);
			return TRUE;
		}
		/* If any CHECK BOX in the table is clicked */
		else if (Event->para2 == CHECKBOX)
		{
			table_row_num = Event->eventID - TO_DO_CHECKBOX_OFFSET + to_do_list.top_row_num;
			ToDoListDisplayGetRecordID(&to_do_list,table_row_num,&rec_id,&tdl_dbid);
			/* Get Field 0 of To Do List Record */
			DataRecIDtoNum(tdl_dbid, rec_id, &rec_num);
			DataOpenRecord(tdl_dbid, rec_num, &rec_id, NULL);
			DataGetField(tdl_dbid, rec_id, 0, &buffer, &byte_read);
			
			if (*buffer != COMPLETED)
				*buffer = COMPLETED;
			else
				*buffer = INCOMPLETED;
#ifdef	SORT_MODIFY
			ToDoUpdateCompleteOrPriorityField(0, *buffer);
#else
			DataWriteField(tdl_dbid,rec_id,0,1,buffer);
#endif
			DataCloseRecord(tdl_dbid,rec_id);
			qfree(buffer);
			return TRUE;
		}
		return TRUE;
		
	case	EVT_CONTROL_POPUP_SELECT:
		/* If any POPUP in the table is clicked */
		if (Event->eventID != POPUP_TRIGGER_CATE)
		{
			table_row_num = Event->eventID - TO_DO_POPUP_OFFSET + to_do_list.top_row_num;
			ToDoListDisplayGetRecordID(&to_do_list,table_row_num,&rec_id,&tdl_dbid);
			DataRecIDtoNum(tdl_dbid, rec_id, &rec_num);
			DataOpenRecord(tdl_dbid, rec_num, &rec_id, NULL);
			/* Add 1 map to correct priority level */
			priority = Event->para1 + 1;
#ifdef	SORT_MODIFY
			ToDoUpdateCompleteOrPriorityField(2, priority);
#else
			DataWriteField(tdl_dbid,rec_id,2,1,&priority);
#endif
			DataCloseRecord(tdl_dbid,rec_id);
			return TRUE;
		}
		else
			ToDoLaunchApplication();
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		if (Event->eventID >= TO_DO_TONE_OFFSET && Event->eventID < TO_DO_TONE_OFFSET + TO_DO_LIST_NUM_OF_ROW)
			table_row_num = Event->eventID - TO_DO_TONE_OFFSET + to_do_list.top_row_num;
		else if (Event->eventID >= TO_DO_VOICE_OFFSET && Event->eventID < TO_DO_VOICE_OFFSET + TO_DO_LIST_NUM_OF_ROW)
			table_row_num = Event->eventID - TO_DO_VOICE_OFFSET + to_do_list.top_row_num;
		else
			return FALSE;
		
		ToDoListDisplayGetRecordID(&to_do_list,table_row_num,&app_status.rec_id,&tdl_dbid);
		pressed_object1 = FORM_TO_DO_LIST;
		
		DataRecIDtoNum(tdl_dbid, app_status.rec_id, &rec_num);
		DataOpenRecord(tdl_dbid, rec_num, &rec_id, NULL);
		DataGetField(tdl_dbid, rec_id, 1, &buffer, &byte_read);
		
		if (*buffer == VOICE_ALARM || *buffer == VOICE_NO_ALARM)
		{
			if (CheckBatteryLow() == 1)
			{
				no_bat_cause = FORM_TO_DO_LIST;
				FormPopupForm(FORM_TO_DO_NO_BAT);
				return FALSE;
			}
			if (FormGetObjectPointer(FORM_REPLAY_VOICE, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_REPLAY_VOICE);
			
			FormGetObjectPointer(BITMAP_REPLAY_VOICE_PLAY, &object_type, (void **)&bitmap_addr);
			bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
			bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
			
			result = DataGetField(tdl_dbid, app_status.rec_id, 6, &buffer, &byte_read);
			app_status.sound_rec_id = *(RecordID *)buffer;
			FormPopupForm(FORM_REPLAY_VOICE);
		}
		qfree(buffer);
		return TRUE;
		
	case	EVT_MENU_SELECT_ITEM:
		FormGetObjectPointer(TABLE_FIRST_STRING, &object_type, (void **)&table_string);
		if (table_string->text_font == SMALL_FONT)
			table_font = MEDIUM_FONT;
		else
			table_font = SMALL_FONT;
		
		ToDoSetTableFont();
		ToDoTableDisplayDraw(&to_do_list);
		ToDoListTableSetScrollbar();
		TableDrawTable(TABLE_TO_DO_LIST);
		return TRUE;
		
	case	PEN_EVENT:
		table_return = ToDoListGetClickedCell(TABLE_TO_DO_LIST,(SHORT)(Event->para1),(SHORT)(Event->para2),
			&row_number,&col_number,&cell_number);
		
		if (table_return == TRUE && cell_number < 65)
		{
			FormGetObjectPointer(TABLE_TO_DO_LIST, &object_type, (void **)&table_addr);
			cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell_number]))->table_item_ui_id;
			not_table_clear = FALSE;
			
			if (cell_ui_id >= TO_DO_LIST_CONTENT_OFFSET && cell_ui_id < TO_DO_LIST_DATE_OFFSET+TO_DO_LIST_NUM_OF_ROW)
			{
				FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string_addr);
				
				if (Event->eventID == PEN_DOWN && object_type == STRING)
				{
					if (string_addr->string_text[0] != 0)
					{
						text_color = string_addr->string_color;
						text_bg_color = string_addr->string_bg_color;
						
						string_addr->string_color = COLOR_WHITE;
						string_addr->string_bg_color = COLOR_BLACK;
						StringDrawString(cell_ui_id);
						
						string_addr->string_color = text_color;
						string_addr->string_bg_color = text_bg_color;
					}
					/* Clear the old highlighted cell */
					if ((old_cell_ui_id >= TO_DO_LIST_CONTENT_OFFSET && old_cell_ui_id < TO_DO_LIST_DATE_OFFSET+TO_DO_LIST_NUM_OF_ROW) &&
						old_cell_ui_id != cell_ui_id)
					{
						if (FormGetObjectPointer(old_cell_ui_id, &object_type, (void **)&string_addr) == TRUE)
							StringDrawString(old_cell_ui_id);
					}
					old_cell_ui_id = cell_ui_id;
					highlight_row = row_number;
					pen_down = TRUE;
				}					
				else if (Event->eventID == PEN_MOVE && old_cell_ui_id != cell_ui_id && 
					cell_ui_id >= TO_DO_LIST_CONTENT_OFFSET && pen_down == TRUE)
				{
					if (old_cell_ui_id < TO_DO_LIST_CONTENT_OFFSET || 
						old_cell_ui_id >= TO_DO_LIST_DATE_OFFSET + TO_DO_LIST_NUM_OF_ROW)
						return FALSE;
					
					StringDrawString(old_cell_ui_id);
					
					if (string_addr->string_text[0] != 0)
					{
						text_color = string_addr->string_color;
						text_bg_color = string_addr->string_bg_color;
						
						string_addr->string_color = COLOR_WHITE;
						string_addr->string_bg_color = COLOR_BLACK;
						StringDrawString(cell_ui_id);
						
						string_addr->string_color = text_color;
						string_addr->string_bg_color = text_bg_color;
					}
					old_cell_ui_id = cell_ui_id;
					highlight_row = row_number;
				}					
				else if (Event->eventID == PEN_UP && pen_down == TRUE)
				{
					if (cell_ui_id < TO_DO_LIST_DATE_OFFSET)
						table_row_num = cell_ui_id - TO_DO_LIST_CONTENT_OFFSET + to_do_list.top_row_num;
					else 
						table_row_num = cell_ui_id - TO_DO_LIST_DATE_OFFSET + to_do_list.top_row_num;
					
					if (ToDoListDisplayGetRecordID(&to_do_list,table_row_num,&rec_id,&tdl_dbid) == FALSE)
						return FALSE; /* Exit if clicked on empty row */
					
					app_status.rec_id = rec_id;
					
					if (col_number == TO_DO_LIST_CONTENTS)
					{
						if (FormGetObjectPointer(FORM_TO_DO_VIEWING, &object_type, (void **)&form_addr)
							== ERR_UI_RES_NOT_FOUND)
							FormInitAllFormObjects(FORM_TO_DO_VIEWING);
						
						alarm_settings.recorded = FALSE;
						alarm_date = VIEWING_ALARM_DATE;
						field_top_line = 0;
						field_insert_pt_pos = 0;
						
						ToDoRecordToVariable();
						ToDoViewingSetUpScreen();
						/* Set the selected item of the popup trigger in the viewing screen */
						DataRecIDtoNum(tdl_dbid, app_status.rec_id, &rec_num);
						DataOpenRecord(tdl_dbid, rec_num, &app_status.rec_id, NULL);
						DataGetField(tdl_dbid, app_status.rec_id, 2, &buffer, &byte_read);
						ControlPopupSetSelectedItem(POPUP_TRIGGER_PRIORITY_VIEWING,(*buffer -1));
						DataCloseRecord(tdl_dbid, app_status.rec_id);
						qfree(buffer);
						/* Disable the field object */
						show_line = FALSE;
						goto_highlight = FALSE;
						SndPlaySndEffect(SNDRES5_BEEP);
						FormPopupForm(FORM_TO_DO_VIEWING);
					}
					else if (col_number == TO_DO_LIST_DUE_DATE)
					{
						if (FormGetObjectPointer(FORM_DATE_SETTINGS, &object_type, (void **)&form_addr)
							== ERR_UI_RES_NOT_FOUND)
							FormInitAllFormObjects(FORM_DATE_SETTINGS);
						
						if (FormGetObjectPointer(FORM_TO_DO_LIST, &object_type, (void **)&form_addr)
							== ERR_UI_RES_NOT_FOUND)
							FormInitAllFormObjects(FORM_TO_DO_LIST);
						
						ToDoRecordToVariable();
						ToDoDateSettingSetUpScreen();							
						pressed_object1 = FORM_TO_DO_LIST;
						pressed_object2 = FORM_DATE_SETTINGS;
						
						if (app_status.sch_year != 0)
						{
							restart_form = RESTART_TO_DO_DATE;
							SndPlaySndEffect(SNDRES5_BEEP);
							FormPopupForm(FORM_DATE_SETTINGS);
						}
						else 
						{
							pen_down = FALSE;
							return FALSE;
						}
					}
					pen_down = FALSE;
					return TRUE;
				}
					}
					else
					{
						/* Clear the old highlighted cell */
						if (old_cell_ui_id >= TO_DO_LIST_CONTENT_OFFSET && old_cell_ui_id < TO_DO_LIST_DATE_OFFSET+TO_DO_LIST_NUM_OF_ROW)
						{
							if (FormGetObjectPointer(old_cell_ui_id, &object_type, (void **)&string_addr) == TRUE)
							{
								if (row_number == highlight_row)
								{
									StringDrawString(old_cell_ui_id);
									highlight_row = -1;
								}
							}
						}
					}
				}
				else
				{
					/* Clear the old highlighted cell */
					if ((old_cell_ui_id >= TO_DO_LIST_CONTENT_OFFSET && old_cell_ui_id < TO_DO_LIST_DATE_OFFSET+TO_DO_LIST_NUM_OF_ROW) &&
						(to_do_list.total_num_rows != 0))
					{
						if (FormGetObjectPointer(old_cell_ui_id, &object_type, (void **)&string_addr) == TRUE)
						{
							if (not_table_clear == FALSE)
							{
								StringDrawString(old_cell_ui_id);
								not_table_clear = TRUE;
							}
						}
					}
				}
				return TRUE;
				
		case	EVT_SCROLLBAR_REPEAT:
		case	EVT_SCROLLBAR_SELECT:
			ToDoScrollbarSetTable(Event);
			return TRUE;
			
		case 	EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_TO_DO_LIST, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_TO_DO_LIST, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
			
        case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				SysGetAppID(MAINMENU, &appid);
				EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
				EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
			}
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerToDoNew
* Purpose: 	This function is the event handler for the 
*			TO DO NEW edit screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerToDoNew(EvtType* Event)
{	
	Form	*form_addr;
	Field	*fld_addr;
	BYTE	object_type, original_font;
	USHORT	num_items;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_DETAILS || Event->para1 == SLETTER_DETAILS)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_DETAILS;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		AlarmMgrEnable(TRUE);
		/* Set up the edit mode */
		app_status.edit_mode = TO_DO_NEW;
		restart_form = RESTART_TO_DO_NEW;
		show_line = TRUE;
		
		FormSetActiveForm(FORM_TO_DO_NEW);
		MenuGetNumOfItems(TO_DO_LIST_MENU, &num_items);
		if (num_items == 1)
		{
			MenuDeleteItem(TO_DO_LIST_MENU, 0);
			MenuInsertItem(TO_DO_LIST_MENU, 0, TODOCOPY);
			MenuInsertItem(TO_DO_LIST_MENU, 1, TODOCUT);
			MenuInsertItem(TO_DO_LIST_MENU, 2, TODOPASTE);
			MenuInsertItem(TO_DO_LIST_MENU, 3, TODOUNDO);
		}
		FieldGetFont(FIELD_TO_DO_NEW, &original_font);
		MenuDeleteItem(TO_DO_LIST_MENU, 4);
		if (original_font == SMALL_FONT)
			MenuInsertItem(TO_DO_LIST_MENU, 4, TODOLFONT);
		else
			MenuInsertItem(TO_DO_LIST_MENU, 4, TODOSFONT);
		
		FormSetFormActiveObject(FORM_TO_DO_NEW, FIELD_TO_DO_NEW);
		FieldSetTopLineNum(FIELD_TO_DO_NEW, field_top_line);
		FieldSetInsertPointOn(FIELD_TO_DO_NEW);
		FieldSetInsertPointPositionByCharPos(FIELD_TO_DO_NEW, field_insert_pt_pos);
		
		ToDoSetUpFieldScreen(FORM_TO_DO_NEW);
		ToDoFieldSetScrollbar(FIELD_TO_DO_NEW, SCROLLBAR_TO_DO_NEW);
		FormDrawForm(FORM_TO_DO_NEW);
		ToDoFindOutAlarmSetBy();
		return TRUE;
		
	case	EVT_KEYBOARD_STATUS:
		ToDoSetUpFieldScreen(FORM_TO_DO_NEW);
		ToDoEditSetField(FORM_TO_DO_NEW, FIELD_TO_DO_NEW);
		ToDoFieldSetScrollbar(FIELD_TO_DO_NEW, SCROLLBAR_TO_DO_NEW);
		FieldGetTopLineNum(FIELD_TO_DO_NEW, &field_top_line);
		FieldEraseField(FIELD_TO_DO_NEW);
		FieldDrawField(FIELD_TO_DO_NEW);
		return TRUE;
		
	case	EVT_SCROLLBAR_REPEAT:
		if (show_line == TRUE)
		{
			FormSetFormActiveObject(FORM_TO_DO_NEW, FIELD_TO_DO_NEW);
			FormGetObjectPointer(FIELD_TO_DO_NEW, &object_type, (void **)&fld_addr);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldGetInsertPointPosition(FIELD_TO_DO_NEW, &field_insert_pt_pos);
		}
		ToDoScrollbarSetField(FIELD_TO_DO_NEW, SCROLLBAR_TO_DO_NEW, Event);
		
		if (show_line == TRUE)
		{
			FieldSetInsertPointPositionByCharPos(FIELD_TO_DO_NEW, field_insert_pt_pos);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldSetInsertPointOn(FIELD_TO_DO_NEW);
			else
				FieldSetInsertPointOff(FIELD_TO_DO_NEW);
		}
		return TRUE;
		
		
	case	EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_TO_DO_NEW);
		return TRUE;
	case 	EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_TO_DO_NEW, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_TO_DO_NEW, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
		
	case	EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			ToDoEditSetField(FORM_TO_DO_NEW, FIELD_TO_DO_NEW);
			ToDoFieldSetScrollbar(FIELD_TO_DO_NEW, SCROLLBAR_TO_DO_NEW);
			FieldAddKeyInChar(FIELD_TO_DO_NEW,(BYTE)(Event->para1));
			return TRUE;
		}
		
	case	EVT_FIELD_CHANGED:
		ToDoFieldSetScrollbar(FIELD_TO_DO_NEW, SCROLLBAR_TO_DO_NEW);
		return TRUE;
		
	case	EVT_FIELD_MODIFIED:
		chk_status.field_change = TRUE;
		FieldGetTopLineNum(FIELD_TO_DO_NEW, &field_top_line);
		FieldGetInsertPointPosition(FIELD_TO_DO_NEW, &field_insert_pt_pos);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_TO_DO_DETAILS:
			if (FormGetObjectPointer(FORM_TO_DO_DETAILS, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_TO_DO_DETAILS);
			
			pressed_object1 = FORM_TO_DO_DETAILS;
			pressed_object2 = FORM_TO_DO_NEW;
			FormPopupForm(FORM_TO_DO_DETAILS);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_MENU_SELECT_ITEM:
			ToDoMenuSelectedAction((USHORT)(Event->para1));
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
				if (FormGetObjectPointer(FORM_TO_DO_LIST, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_TO_DO_LIST);
#ifdef	PR31700
				if (chk_status.new_entry_hit == TRUE ||chk_status.field_change == TRUE || alarm_settings.recorded == TRUE)
#else
					if (chk_status.new_entry_hit == TRUE ||alarm_settings.recorded == TRUE)
#endif
					{
						/* Save the content from FIELD object to field buffer */
						ToDoFieldToFieldBuffer();
						/* Copy the content from the field buffer th Field 3 */
						ToDoFieldUpdateRecord();
						ToDoChangeUpdateRecord();
					}
					else
					{
						if (tdl_field_buffer[0] !=0 && app_status.edit_mode != TO_DO_VIEWING)
						{
							strcpy(tdl_field_buffer[0],(BYTE*)(""));
							ToDoFieldBufferToField();
							ToDoClearFieldBuffer();
						}
					}
					FieldSetInsertPointOff(FIELD_TO_DO_NEW);
					ToDoSetTableFont();
					ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
					FormPopupForm(FORM_TO_DO_LIST);
					return TRUE;
					
			case	INLAY_EXIT:
				if (FormGetObjectPointer(FORM_SAVE_CHANGES, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_SAVE_CHANGES);
				
				ToDoFieldToFieldBuffer();
				pressed_object1 = FORM_TO_DO_LIST;
				pressed_object2 = FORM_TO_DO_NEW;
				FieldSetInsertPointOff(FIELD_TO_DO_NEW);
				
#ifdef	PR31700
				if (chk_status.new_entry_hit == TRUE || chk_status.field_change == TRUE || alarm_settings.recorded == TRUE)
#else
					if (chk_status.new_entry_hit == TRUE || alarm_settings.recorded == TRUE)
#endif
					{
						// =============================================================================================
						// modified at 30062000
						ToDoSetUpFieldScreen(FORM_TO_DO_NEW);
						ToDoEditSetField(FORM_TO_DO_NEW, FIELD_TO_DO_NEW);
						ToDoFieldSetScrollbar(FIELD_TO_DO_NEW, SCROLLBAR_TO_DO_NEW);
						FormDrawForm(FORM_TO_DO_NEW);
						// =============================================================================================
						FormPopupForm(FORM_SAVE_CHANGES);
					}
					else
					{
						if (tdl_field_buffer[0] !=0 && app_status.edit_mode != TO_DO_VIEWING)
						{
							strcpy(tdl_field_buffer[0],(BYTE*)(""));
							ToDoFieldBufferToField();
							ToDoClearFieldBuffer();
						}
						ToDoSetTableFont();
						ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
						FormPopupForm(FORM_TO_DO_LIST);
					}
					return TRUE;
					
			default:
				return FALSE;
			}
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerToDoViewing
* Purpose: 	This function is the event handler for the 
*			TO DO VIEWING screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerToDoViewing(EvtType* Event)
{
	Bitmap	*bmp_addr;
	Control	*ctl_addr;
	Field	*fld_addr;
	Form	*form_addr;
	USHORT	num_items, count;
	BYTE	*buffer, object_type, original_font;
	BYTE	text_buffer[20];
	UWORD	rec_num, byte_read;
	RTM		time;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_ALARM || Event->para1 == SLETTER_ALARM)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_ALARM;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_DEL;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_DUE_DATE || Event->para1 == SLETTER_DUE_DATE)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_CHANGE_DUE_DATE;
				Event->evtPBP = NULL;
			}			
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		AlarmMgrEnable(TRUE);
		app_status.edit_mode = TO_DO_VIEWING;
		restart_form = RESTART_TO_DO_VIEWING;
		
		FormSetActiveForm(FORM_TO_DO_VIEWING);
		FormGetObjectPointer(FIELD_TO_DO_VIEWING, &object_type, (void **)&fld_addr);
		
		if (show_line == FALSE)
		{
			fld_addr->field_attr.field_insert_pt_visible = FALSE;
			fld_addr->field_attr.field_enable = FALSE;
			fld_addr->field_back_line = NO_LINE;
			
			MenuGetNumOfItems(TO_DO_LIST_MENU, &num_items);
			
			for (count =0; count < num_items; count++)
				MenuDeleteItem(TO_DO_LIST_MENU, 0);
			
			FieldGetFont(FIELD_TO_DO_VIEWING, &original_font);
			
			if (original_font == SMALL_FONT)
				MenuInsertItem(TO_DO_LIST_MENU, 0, TODOLFONT);
			else
				MenuInsertItem(TO_DO_LIST_MENU, 0, TODOSFONT);
		}
		else
		{
			FormSetFormActiveObject(FORM_TO_DO_VIEWING, FIELD_TO_DO_VIEWING);
			fld_addr->field_attr.field_insert_pt_visible = TRUE;
			fld_addr->field_attr.field_enable = TRUE;
			fld_addr->field_attr.field_active = TRUE;
			fld_addr->field_back_line = GREY_LINE;
			
			MenuDeleteItem(TO_DO_LIST_MENU, 4);
			FieldGetFont(FIELD_TO_DO_VIEWING, &original_font);
			if (original_font == SMALL_FONT)
				MenuInsertItem(TO_DO_LIST_MENU, 4, TODOLFONT);
			else
				MenuInsertItem(TO_DO_LIST_MENU, 4, TODOSFONT);
		}
		/* Highlight the selection text */
		if (goto_highlight == FALSE)
		{
			fld_addr->field_attr.field_highlight = FALSE;
			fld_addr->field_highlight_length = 0;
		}
		FieldSetTopLineNum(FIELD_TO_DO_VIEWING, field_top_line);
		FieldSetInsertPointPositionByCharPos(FIELD_TO_DO_VIEWING, field_insert_pt_pos);
		
		ToDoSetUpFieldScreen(FORM_TO_DO_VIEWING);
		ToDoFieldSetScrollbar(FIELD_TO_DO_VIEWING, SCROLLBAR_TO_DO_VIEWING);
		ToDoFindOutAlarmSetBy();
		FormDrawForm(FORM_TO_DO_VIEWING);
		return TRUE;
		
	case	EVT_SCROLLBAR_REPEAT:
		if (show_line == TRUE)
		{
			FormSetFormActiveObject(FORM_TO_DO_VIEWING, FIELD_TO_DO_VIEWING);
			FormGetObjectPointer(FIELD_TO_DO_VIEWING, &object_type, (void **)&fld_addr);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldGetInsertPointPosition(FIELD_TO_DO_VIEWING, &field_insert_pt_pos);
		}
		ToDoScrollbarSetField(FIELD_TO_DO_VIEWING, SCROLLBAR_TO_DO_VIEWING, Event);
		
		if (show_line == TRUE)
		{
			if (!fld_addr->field_attr.field_highlight)
				FieldSetInsertPointPositionByCharPos(FIELD_TO_DO_VIEWING, field_insert_pt_pos);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
			{
				if (!fld_addr->field_attr.field_highlight)	    
					FieldSetInsertPointOn(FIELD_TO_DO_VIEWING);
			}
			else
				FieldSetInsertPointOff(FIELD_TO_DO_VIEWING);
		}
		return TRUE;
		
		
	case	EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_TO_DO_VIEWING);
		return TRUE;
		
	case 	EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_TO_DO_VIEWING, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_TO_DO_VIEWING, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
		
	case	EVT_KEYBOARD_STATUS:
		ToDoSetUpFieldScreen(FORM_TO_DO_VIEWING);
		ToDoEditSetField(FORM_TO_DO_VIEWING, FIELD_TO_DO_VIEWING);
		ToDoFieldSetScrollbar(FIELD_TO_DO_VIEWING, SCROLLBAR_TO_DO_VIEWING);
		FieldGetTopLineNum(FIELD_TO_DO_VIEWING, &field_top_line);
		FieldEraseField(FIELD_TO_DO_VIEWING);
		FieldDrawField(FIELD_TO_DO_VIEWING);
		return TRUE;
		
	case	EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			FormGetObjectPointer(FIELD_TO_DO_VIEWING, &object_type, (void **)&fld_addr);
			ToDoEditSetField(FORM_TO_DO_VIEWING, FIELD_TO_DO_VIEWING);
			ToDoFieldSetScrollbar(FIELD_TO_DO_VIEWING, SCROLLBAR_TO_DO_VIEWING);
			if (fld_addr->field_attr.field_enable == TRUE && (fld_addr->field_attr.field_insert_pt_visible == TRUE ||
				fld_addr->field_attr.field_highlight == TRUE))
			{
				
				if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
				{
					low_memory_form_id = FORM_TO_DO_VIEWING;
					FormPopupForm(FORM_SYSTEM_LOW_MEM);	
					return TRUE;
				}											
				
				FieldAddKeyInChar(FIELD_TO_DO_VIEWING,(BYTE)(Event->para1));
			}
			return TRUE;
		}
		
	case	EVT_FIELD_CHANGED:
		ToDoFieldSetScrollbar(FIELD_TO_DO_VIEWING, SCROLLBAR_TO_DO_VIEWING);
		return TRUE;
		
		
	case	EVT_FIELD_MODIFIED:
		chk_status.field_change = TRUE;
		FieldGetTopLineNum(FIELD_TO_DO_VIEWING, &field_top_line);
		FieldGetInsertPointPosition(FIELD_TO_DO_VIEWING, &field_insert_pt_pos);
		return TRUE;
		
	case	PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
			FormGetObjectPointer(FIELD_TO_DO_VIEWING, &object_type, (void **)&fld_addr);
			
			if ((Event->para1 >= fld_addr->bounds.xcoord && Event->para1 < fld_addr->bounds.xcoord + fld_addr->bounds.width &&
				Event->para2 >= fld_addr->bounds.ycoord && Event->para2 < fld_addr->bounds.ycoord + fld_addr->bounds.height) &&
				fld_addr->field_attr.field_enable == FALSE)
			{
				MenuDeleteItem(TO_DO_LIST_MENU, 0);				
				MenuInsertItem(TO_DO_LIST_MENU, 0, TODOCOPY);
				MenuInsertItem(TO_DO_LIST_MENU, 1, TODOCUT);
				MenuInsertItem(TO_DO_LIST_MENU, 2, TODOPASTE);
				MenuInsertItem(TO_DO_LIST_MENU, 3, TODOUNDO);
				FieldGetFont(FIELD_TO_DO_VIEWING, &original_font);
				
				if (original_font == SMALL_FONT)
					MenuInsertItem(TO_DO_LIST_MENU, 4, TODOLFONT);
				else
					MenuInsertItem(TO_DO_LIST_MENU, 4, TODOSFONT);
				
				fld_addr->field_attr.field_insert_pt_visible = TRUE;
				fld_addr->field_attr.field_enable = TRUE;
				fld_addr->field_attr.field_active = TRUE;
				fld_addr->field_attr.field_highlight = FALSE;
				fld_addr->field_highlight_length = 0;
				fld_addr->field_back_line = GREY_LINE;
				show_line = TRUE;
				/* Set the  Insert Point Positino by pen's X &Y */
				FieldSetInsertPointPositionByXY(FIELD_TO_DO_VIEWING, (SHORT)Event->para1, (SHORT)Event->para2);
				FormSetFormActiveObject(FORM_TO_DO_VIEWING, FIELD_TO_DO_VIEWING);
				FormDrawForm(FORM_TO_DO_VIEWING);
			}
		}
		return TRUE;				
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_TO_DO_ALARM:
			if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_ALARM_SETTINGS);
			
			pressed_object1 = FORM_TO_DO_VIEWING;
			pressed_object2 = FORM_TO_DO_VIEWING;
			ToDoFieldToFieldBuffer();
			ToDoAlarmSetUpScreen();
			FormPopupForm(FORM_ALARM_SETTINGS);
			return TRUE;
			
		case	BUTTON_TO_DO_DEL:
			if (FormGetObjectPointer(FORM_ITEM_ERASE, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_ITEM_ERASE);
			
			pressed_object1 = FORM_TO_DO_LIST;
			pressed_object2 = FORM_TO_DO_VIEWING;
			FormPopupForm(FORM_ITEM_ERASE);
			return TRUE;
			
		case	BUTTON_TO_DO_VIEW_DATE:
			if (FormGetObjectPointer(FORM_DATE_SETTINGS, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_DATE_SETTINGS);
			
			pressed_object1 = FORM_TO_DO_VIEWING;
			pressed_object2 = FORM_DATE_SETTINGS;
			ToDoFieldToFieldBuffer();
			ToDoDateSettingSetUpScreen();
			FormPopupForm(FORM_DATE_SETTINGS);
			return	TRUE;
			
		case	BUTTON_TO_DO_CHANGE_DUE_DATE:
			if (app_status.sch_year != 0)
			{
				FormGetObjectPointer(BUTTON_TO_DO_VIEW_DATE, &object_type, (void **)&ctl_addr);
				ctl_addr->control_attr.control_enable = FALSE;
				ctl_addr->control_attr.control_visible = FALSE;
				
				app_status.sch_year = 0;
				app_status.sch_month = 0;
				app_status.sch_day = 0;
				ControlEraseControl(BUTTON_TO_DO_VIEW_DATE);
				
				if (alarm_set_by == ALARM_DUE_DATE || alarm_set_by == ALARM_BEFORE_DUE_DATE)
				{
					app_status.alarm_year = 0;
					app_status.alarm_month = 0;
					app_status.alarm_day = 0;
					app_status.alarm_status = NO_ALARM;
					detail_date = NO_DUE_DATE;
					
					FormGetObjectPointer(BITMAP_TO_DO_TONE_VIEWING, &object_type, (void **)&bmp_addr);
					bmp_addr->bitmap_attr.bitmap_enable = FALSE;
					bmp_addr->bitmap_attr.bitmap_active = FALSE;
					bmp_addr->bitmap_attr.bitmap_visible = FALSE;
					
					FormGetObjectPointer(BITMAP_TO_DO_VOICE_VIEWING, &object_type, (void **)&bmp_addr);
					bmp_addr->bitmap_attr.bitmap_enable = FALSE;
					bmp_addr->bitmap_attr.bitmap_active = FALSE;
					bmp_addr->bitmap_attr.bitmap_visible = FALSE;
				}
				
				strcpy((char *)text_buffer,TODO_ADD_DUE_DATE);
				ControlSetLabel(BUTTON_TO_DO_CHANGE_DUE_DATE, text_buffer);	
				FormDrawForm(FORM_TO_DO_VIEWING);
				return TRUE;
			}
			else
			{
				RtcGetTime(&time);
				app_status.sch_year = time.year;
				app_status.sch_month = time.mon + 1;
				app_status.sch_day = time.mday;
				
				if (app_status.alarm_status == NO_ALARM)									
					detail_date = TODAY;
				
				if (FormGetObjectPointer(FORM_DATE_SETTINGS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_DATE_SETTINGS);
				
				pressed_object1 = FORM_TO_DO_VIEWING;
				pressed_object2 = FORM_DATE_SETTINGS;
				ToDoFieldToFieldBuffer();
				ToDoDateSettingSetUpScreen();
				FormPopupForm(FORM_DATE_SETTINGS);
			}
			return TRUE;
			
		case	CHECKBOX_TO_DO_VIEWING:
			FormGetObjectPointer(CHECKBOX_TO_DO_VIEWING, &object_type, (void**)&ctl_addr);
			if (((ControlTemplateCheckBox*)(ctl_addr->control_template))->control_value == TRUE)
				app_status.completed_status = TRUE;
			else
				app_status.completed_status = FALSE;
			return TRUE;
		default:
			return FALSE;
				}
				
		case	EVT_CONTROL_POPUP_SELECT:
			app_status.priority_status = Event->para1 + 1;
			return TRUE;
			
		case	EVT_BITMAP_SELECT:
			if (app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == VOICE_NO_ALARM)
			{
				if (CheckBatteryLow() == 1)
				{
					no_bat_cause = FORM_TO_DO_VIEWING;
					FormPopupForm(FORM_TO_DO_NO_BAT);
					return FALSE;
				}
				if (FormGetObjectPointer(FORM_REPLAY_VOICE, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_REPLAY_VOICE);
				
				pressed_object1 = FORM_TO_DO_VIEWING;
				ToDoFieldToFieldBuffer();
				FormPopupForm(FORM_REPLAY_VOICE);
			}
			return TRUE;
			
		case	EVT_MENU_SELECT_ITEM:
			MenuGetNumOfItems(TO_DO_LIST_MENU, &num_items);
			
			if (num_items == 1)
				ToDoViewingSelectedLargeFontOnly();
			else
				ToDoMenuSelectedAction((USHORT)(Event->para1));
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
				if (FormGetObjectPointer(FORM_TO_DO_LIST, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_TO_DO_LIST);
				
				ToDoFieldToFieldBuffer();
				/* Copy the content from the field buffer th Field 3 */
				ToDoFieldUpdateRecord();
				/* Save changes to record */
				ToDoChangeUpdateRecord();
				ToDoSetTableFont();
				/* Update the total number of rows in the Table Display */
				ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
				/* Disable the field for next use */
				show_line = FALSE;
				FieldSetInsertPointOff(FIELD_TO_DO_VIEWING);
				FormPopupForm(FORM_TO_DO_LIST);
				return TRUE;
				
			case	INLAY_EXIT:
				ToDoFieldToFieldBuffer();
				pressed_object1 = FORM_TO_DO_LIST;			
				pressed_object2 = FORM_TO_DO_VIEWING;			
				FieldSetInsertPointOff(FIELD_TO_DO_VIEWING);
				
				if (ToDoCheckAnyChange() == TRUE)
				{
					if (FormGetObjectPointer(FORM_SAVE_CHANGES, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(FORM_SAVE_CHANGES);
					
					FormPopupForm(FORM_SAVE_CHANGES);
				}
				else
				{
					if (FormGetObjectPointer(FORM_TO_DO_LIST, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(FORM_TO_DO_LIST);
					
					/* Disable the field for next use */
					show_line = FALSE;
					ToDoSetTableFont();
					ToDoRecordToTable(tdl_dbid, app_status.new_sort_mode);
					FormPopupForm(FORM_TO_DO_LIST);
				}
				return TRUE;	
			default:
				return FALSE;
			}
			
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerToDoPref
* Purpose: 	This function is the event handler for the 
*			TO DO PREF screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerToDoPref(EvtType* Event)
{
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_PREF_1 || Event->para1 == SLETTER_PREF_1)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = PUSHBUTTON_TO_DO_PREF_N1;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_PREF_2 || Event->para1 == SLETTER_PREF_2)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = PUSHBUTTON_TO_DO_PREF_N2;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_PREF_3 || Event->para1 == LLETTER_PREF_3)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = PUSHBUTTON_TO_DO_PREF_N3;
				Event->evtPBP = NULL;
			}			
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		/* Set up the default key of the PRIORITY */
		switch (app_status.new_sort_mode)
		{
		case	COMPLETED_ITEMS:
			FormSetControlGroupSelection(FORM_TO_DO_PREF,PUSHBUTTON_TO_DO_PREF_N1);
			break;
			
		case	PRIORITY:
			FormSetControlGroupSelection(FORM_TO_DO_PREF,PUSHBUTTON_TO_DO_PREF_N2);
			break;
			
		case	DUE_DATE:
			FormSetControlGroupSelection(FORM_TO_DO_PREF,PUSHBUTTON_TO_DO_PREF_N3);
			break;
			
		default:
			return FALSE;
		}
		FormDrawForm(FORM_TO_DO_PREF);
		return TRUE;
		
		case	EVT_BITMAP_SELECT:
			FormPopupForm(FORM_TO_DO_LIST);
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
				FormPopupForm(FORM_TO_DO_LIST);
			return TRUE;
			
		case	EVT_CONTROL_SELECT:
			switch (Event->eventID)
			{
			case	PUSHBUTTON_TO_DO_PREF_N1:
				app_status.new_sort_mode = COMPLETED_ITEMS;
				ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
				FormPopupForm(FORM_TO_DO_LIST);
				return TRUE;
				
			case	PUSHBUTTON_TO_DO_PREF_N2:
				app_status.new_sort_mode = PRIORITY;
				ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
				FormPopupForm(FORM_TO_DO_LIST);
				return TRUE;
				
			case	PUSHBUTTON_TO_DO_PREF_N3:
				app_status.new_sort_mode = DUE_DATE;
				ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
				FormPopupForm(FORM_TO_DO_LIST);
				return TRUE;
				
			default:
				return FALSE;
			}
			
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerToDoDetails
* Purpose: 	This function is the event handler for the 
*			TO DO DETAILS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerToDoDetails(EvtType* Event)
{
	RTM		time;
	BYTE	buffer[20], object_type;
	BYTE	*ptr = buffer;
	Form	*form_addr;	
	SHORT	temp_month;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_ALARM || Event->para1 == SLETTER_ALARM)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_DETAILS_ALARM;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_DETAILS_DATE || Event->para1 == SLETTER_DETAILS_DATE)
			{
				ControlPopupPopupTrigger(POPUP_TRIGGER_DETAILS_DATE);
				return	FALSE;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		app_status.edit_mode = TO_DO_DETAILS;
		FormSetControlGroupSelection(FORM_TO_DO_DETAILS,FORM_TO_DO_DETAILS
											 + app_status.priority_status);
		
		if (detail_date == CHOOSE_DATE)
		{
			ToDoPackDueDate(ptr, app_status.sch_year, app_status.sch_month,	app_status.sch_day);
			ControlSetLabel(POPUP_TRIGGER_DETAILS_DATE,buffer);
		}
		else
		{
			ControlPopupSetSelectedItem(POPUP_TRIGGER_DETAILS_DATE, detail_date);
		}
		FormDrawForm(FORM_TO_DO_DETAILS);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	PUSHBUTTON_TO_DO_DETAILS_N1:
			app_status.priority_status = 1;
			chk_status.new_entry_hit = TRUE;
			return TRUE;
			
		case	PUSHBUTTON_TO_DO_DETAILS_N2:
			app_status.priority_status = 2;
			chk_status.new_entry_hit = TRUE;
			return TRUE;
			
		case	PUSHBUTTON_TO_DO_DETAILS_N3:
			app_status.priority_status = 3;
			chk_status.new_entry_hit = TRUE;
			return TRUE;
			
		case	PUSHBUTTON_TO_DO_DETAILS_N4:
			app_status.priority_status = 4;
			chk_status.new_entry_hit = TRUE;
			return TRUE;
			
		case	PUSHBUTTON_TO_DO_DETAILS_N5:
			app_status.priority_status = 5;
			chk_status.new_entry_hit = TRUE;
			return TRUE;
			
		case	BUTTON_DETAILS_ALARM:
			FormEraseForm(FORM_TO_DO_DETAILS);
			
			if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_ALARM_SETTINGS);
			
			//--------------------------------------------------------------------------
			//Michelle added 17-Aug-2000
			app_status.alarm_year = 0;
			app_status.alarm_month = 0;
			app_status.alarm_day = 0;
			app_status.alarm_status = NO_ALARM;
			//--------------------------------------------------------------------------
			
			ToDoAlarmSetUpScreen();
			FormPopupForm(FORM_ALARM_SETTINGS);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_CONTROL_POPUP_SELECT:
			chk_status.new_entry_hit = TRUE;
			
			if (Event->para1 == TODAY)
			{
				detail_date = TODAY;
				RtcGetTime(&time);
				app_status.sch_year = time.year;
				app_status.sch_month = time.mon + 1;
				app_status.sch_day = time.mday;					
				
				if (alarm_date == ALARM_DUE_DATE)
				{
					app_status.alarm_year = app_status.sch_year;
					app_status.alarm_month = app_status.sch_month;
					app_status.alarm_day = app_status.sch_day;
				}
				else if (alarm_date == ALARM_BEFORE_DUE_DATE)
				{
					app_status.alarm_year = app_status.sch_year;
					temp_month = app_status.sch_month -1;
					app_status.alarm_day = app_status.sch_day;
					
					RtcDaysShift(&app_status.alarm_year, &temp_month, &app_status.alarm_day,-1);
					app_status.alarm_month = temp_month + 1;
				}
			}
			else if (Event->para1 == TOMORROW)
			{
				detail_date = TOMORROW;
				RtcGetTime(&time);
				/* Call function to get tomorrow */
				RtcDaysShift(&time.year, &time.mon, &time.mday,1);
				app_status.sch_year = time.year;
				app_status.sch_month = time.mon + 1;
				app_status.sch_day = time.mday;
				
				if (alarm_date == ALARM_DUE_DATE)
				{
					app_status.alarm_year = app_status.sch_year;
					app_status.alarm_month = app_status.sch_month;
					app_status.alarm_day = app_status.sch_day;
				}
				else if (alarm_date == ALARM_BEFORE_DUE_DATE)
				{
					app_status.alarm_year = app_status.sch_year;
					temp_month = app_status.sch_month -1;
					app_status.alarm_day = app_status.sch_day;
					
					RtcDaysShift(&app_status.alarm_year, &temp_month, &app_status.alarm_day,-1);
					app_status.alarm_month = temp_month + 1;
				}
			}
			else if (Event->para1 == NO_DUE_DATE)
			{
				detail_date = NO_DUE_DATE;
				alarm_date = NO_ALARM_DATE;
				RtcGetTime(&time);
				app_status.sch_year = time.year;
				app_status.sch_month = time.mon + 1;
				app_status.sch_day = time.mday;
				app_status.alarm_year = 0;
				app_status.alarm_month = 0;
				app_status.alarm_day = 0;
			}
			else if (Event->para1 == CHOOSE_DATE)
			{
				detail_date = CHOOSE_DATE;
				
				if (FormGetObjectPointer(FORM_DATE_SETTINGS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_DATE_SETTINGS);
				
				ToDoYearSettingUpdate(&app_status.sch_year);
				FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_JAN	+ (app_status.sch_month-1));
				/* Set up the specified start of week */
				ToDoDateSettingsUpdate();
				FormPopupForm(FORM_DATE_SETTINGS);
			}
			return TRUE;
			
		case	EVT_BITMAP_SELECT:
			FormPopupForm(FORM_TO_DO_NEW);
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
				if (FormGetObjectPointer(pressed_object2, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(pressed_object2);
				
				FormPopupForm(pressed_object2);
				//							AlarmMgrEnable(TRUE);
				return TRUE;
				
			case	INLAY_EXIT:
				if (FormGetObjectPointer(pressed_object2, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(pressed_object2);
				
				FormPopupForm(pressed_object2);
				//							AlarmMgrEnable(TRUE);
				return TRUE;
				
			default:
				return FALSE;
			}
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerConfirmItemErase
* Purpose: 	This function is the event handler for the 
*			CONFIRM ITEM ERASE screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerItemErase(EvtType* Event)
{
	BOOLEAN control_value;
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_ERASE_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_ERASE_NO;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_ITEM_ERASE);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_TO_DO_ERASE_YES)
		{
			if (FormGetObjectPointer(pressed_object1, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(pressed_object1);
			
			/* Check the check box's setting and delete the record */ 
			FormGetControlValue(CHECKBOX_TO_DO_ERASE, &control_value);
			DataCloseRecord(tdl_dbid, app_status.rec_id);
			DataDeleteRecord(tdl_dbid,app_status.rec_id, control_value);
			ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
			/* Del the coorersponding Alarm Event */
			if (app_status.alarm_status != NO_ALARM)
				ToDoDelAnAlarm(app_status.rec_id);
			
			FormPopupForm(pressed_object1);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_TO_DO_ERASE_NO)
		{
			if (FormGetObjectPointer(pressed_object2, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(pressed_object2);
			
			FormPopupForm(pressed_object2);
			return TRUE;
		}
		break;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerDateSettings
* Purpose: 	This function is the event handler for the 
*			DATE SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerDateSettings(EvtType* Event)
{
	BYTE		*control_text, *table_text;
	RTM			time;
	BYTE		buffer[20], object_type;
	BYTE		*ptr = buffer;
	Form		*form_addr;
	SHORT		temp_month;
	ObjectID	control_id;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_TODAY || Event->para1 == SLETTER_TODAY)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_DATE_SETTING_TODAY;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		backup_year = app_status.sch_year;
		backup_month = app_status.sch_month;
		backup_day = app_status.sch_day;
		
		FormDrawForm(FORM_DATE_SETTINGS);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		switch (Event->eventID)
		{
		case	BITMAP_DATE_SETTING_N1:
			if (ToDoYearShiftUpdate(BACKWARD) == TRUE)
			{
				ControlGetPushedPushButton(FORM_DATE_SETTINGS, 2, &control_id);
				ControlGetLabel(control_id, &control_text);
				app_status.sch_year = (USHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
			}
			return TRUE;
			
		case	BITMAP_DATE_SETTING_N2:
			if (ToDoYearShiftUpdate(FORWARD) == TRUE)
			{
				ControlGetPushedPushButton(FORM_DATE_SETTINGS, 2, &control_id);
				ControlGetLabel(control_id, &control_text);
				app_status.sch_year = (USHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
			}
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_CONTROL_SELECT:
			switch (Event->eventID)
			{
			case	PUSHBUTTON_DATE_SETTING_Y1:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y1, &control_text);
				app_status.sch_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y2:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y2, &control_text);
				app_status.sch_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y3:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y3, &control_text);
				app_status.sch_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y4:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y4, &control_text);
				app_status.sch_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y5:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y5, &control_text);
				app_status.sch_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_JAN:
				app_status.sch_month = 1;
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_FEB:
				app_status.sch_month = 2;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_MAR:
				app_status.sch_month = 3;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_APR:
				app_status.sch_month = 4;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_MAY:
				app_status.sch_month = 5;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_JUN:
				app_status.sch_month = 6;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_JUL:
				app_status.sch_month = 7;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_AUG:
				app_status.sch_month = 8;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_SEP:
				app_status.sch_month = 9;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_OCT:
				app_status.sch_month = 10;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_NOV:
				app_status.sch_month = 11;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_DEC:
				app_status.sch_month = 12;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	BUTTON_DATE_SETTING_TODAY:
				RtcGetTime(&time);
				FormSetControlGroupSelection(FORM_DATE_SETTINGS,
					PUSHBUTTON_DATE_SETTING_JAN + time.mon);
				app_status.sch_year = time.year;
				app_status.sch_month = time.mon + 1;
				app_status.sch_day = time.mday;
				ToDoYearSettingUpdate(&app_status.sch_year);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			default:
				return FALSE;
				}
				
		case	EVT_TABLE_SELECT:
			TableGetItemText (TABLE_DATE_SETTING, (USHORT)Event->para1, (USHORT)Event->para2, &table_text);
			if (table_text[0] != 0)
			{
				app_status.sch_day = (SHORT)atol((const char *)table_text);
				ToDoDateSettingsUpdate();
			}
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
				if (pressed_object1 == FORM_TO_DO_LIST)
				{
					if (FormGetObjectPointer(FORM_TO_DO_LIST, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(FORM_TO_DO_LIST);
					
					ToDoChangeUpdateRecord();
					ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
					
					FormPopupForm(FORM_TO_DO_LIST);
				}
				else if (pressed_object1 == FORM_TO_DO_DETAILS)
				{
					if (FormGetObjectPointer(FORM_TO_DO_DETAILS, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(FORM_TO_DO_DETAILS);
					
					ToDoPackDueDate(ptr, app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
					ControlSetLabel(POPUP_TRIGGER_DETAILS_DATE,buffer);
					ControlDrawControl(POPUP_TRIGGER_DETAILS_DATE);
					
					FormEraseForm(FORM_DATE_SETTINGS);
					FormDrawForm(FORM_TO_DO_NEW);
					
					if (alarm_date == ALARM_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						app_status.alarm_month = app_status.sch_month;
						app_status.alarm_day = app_status.sch_day;
					}
					else if (alarm_date == ALARM_BEFORE_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						temp_month = app_status.sch_month -1;
						app_status.alarm_day = app_status.sch_day;
						
						RtcDaysShift(&app_status.alarm_year, &temp_month, &app_status.alarm_day,-1);
						app_status.alarm_month = temp_month + 1;
					}
					/* Need to add one day before due day */
					FormPopupForm(FORM_TO_DO_DETAILS);
				}
				else if (pressed_object1 == FORM_TO_DO_VIEWING)
				{
					if (FormGetObjectPointer(FORM_TO_DO_VIEWING, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(FORM_TO_DO_VIEWING);
					
					if (alarm_set_by == ALARM_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						app_status.alarm_month = app_status.sch_month;
						app_status.alarm_day = app_status.sch_day;
					}
					else if (alarm_set_by == ALARM_BEFORE_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						temp_month = app_status.sch_month -1;
						app_status.alarm_day = app_status.sch_day;
						
						RtcDaysShift(&app_status.alarm_year, &temp_month, &app_status.alarm_day,-1);
						app_status.alarm_month = temp_month + 1;
					}
					
					ToDoViewingSetUpScreen();
					FormPopupForm(FORM_TO_DO_VIEWING);
				}
				return TRUE;
				
			case	INLAY_EXIT:
				if (pressed_object1 == FORM_TO_DO_LIST)
				{
					if ((chk_status.sch_year != app_status.sch_year) ||
						(chk_status.sch_month != app_status.sch_month) ||
						(chk_status.sch_day != app_status.sch_day))
					{
						if (FormGetObjectPointer(FORM_SAVE_CHANGES, &object_type, (void **)&form_addr)
							== ERR_UI_RES_NOT_FOUND)
							FormInitAllFormObjects(FORM_SAVE_CHANGES);
						
						FormPopupForm(FORM_SAVE_CHANGES);
					}
					else
					{
						if (FormGetObjectPointer(FORM_TO_DO_LIST, &object_type, (void **)&form_addr)
							== ERR_UI_RES_NOT_FOUND)
							FormInitAllFormObjects(FORM_TO_DO_LIST);
						
						app_status.sch_year = backup_year;
						app_status.sch_month = backup_month;
						app_status.sch_day = backup_day;
						
						ToDoTableDisplayDraw(&to_do_list);
						FormPopupForm(FORM_TO_DO_LIST);
					}
				}
				else if (pressed_object1 == FORM_TO_DO_DETAILS)
				{
					if (FormGetObjectPointer(FORM_TO_DO_DETAILS, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(FORM_TO_DO_DETAILS);
					
					app_status.sch_year = backup_year;
					app_status.sch_month = backup_month;
					app_status.sch_day = backup_day;
					
					ToDoPackDueDate(ptr, app_status.sch_year, app_status.sch_month,
						app_status.sch_day);
					ControlSetLabel(POPUP_TRIGGER_DETAILS_DATE,buffer);
					ControlDrawControl(POPUP_TRIGGER_DETAILS_DATE);
					
					FormEraseForm(FORM_DATE_SETTINGS);
					FormDrawForm(FORM_TO_DO_NEW);
					
					if (alarm_date == ALARM_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						app_status.alarm_month = app_status.sch_month;
						app_status.alarm_day = app_status.sch_day;
					}
					else if (alarm_date == ALARM_BEFORE_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						temp_month = app_status.sch_month -1;
						app_status.alarm_day = app_status.sch_day;
						
						RtcDaysShift(&app_status.alarm_year, &temp_month, &app_status.alarm_day,-1);
						app_status.alarm_month = temp_month + 1;
					}
					/* Need to add one day before due day */
					FormPopupForm(FORM_TO_DO_DETAILS);
				}
				else if (pressed_object1 == FORM_TO_DO_VIEWING)
				{
					if (FormGetObjectPointer(FORM_TO_DO_VIEWING, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(FORM_TO_DO_VIEWING);
					
					app_status.sch_year = backup_year;
					app_status.sch_month = backup_month;
					app_status.sch_day = backup_day;
					
					if (alarm_set_by == ALARM_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						app_status.alarm_month = app_status.sch_month;
						app_status.alarm_day = app_status.sch_day;
					}
					else if (alarm_set_by == ALARM_BEFORE_DUE_DATE)
					{
						app_status.alarm_year = app_status.sch_year;
						temp_month = app_status.sch_month -1;
						app_status.alarm_day = app_status.sch_day;
						
						RtcDaysShift(&app_status.alarm_year, &temp_month, &app_status.alarm_day,-1);
						app_status.alarm_month = temp_month + 1;
					}
					
					ToDoViewingSetUpScreen();
					FormPopupForm(FORM_TO_DO_VIEWING);
				}
				return TRUE;	
				
			default:
				return FALSE;
				}
				
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerAlarmDateSettings
* Purpose: 	This function is the event handler for the 
*			DATE SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerAlarmDateSettings(EvtType* Event)
{
	BYTE		*control_text, *table_text;
	RTM			time;
	BYTE		buffer[20], object_type;
	BYTE		*ptr = buffer;
	Form		*form_addr;
	ObjectID	control_id;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_TODAY || Event->para1 == LLETTER_TODAY)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_DATE_SETTING_TODAY;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		backup_year = app_status.alarm_year;
		backup_month = app_status.alarm_month;
		backup_day = app_status.alarm_day;
		
		FormDrawForm(FORM_ALARM_DATE_SETTINGS);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		switch (Event->eventID)
		{
		case	BITMAP_DATE_SETTING_N1:
			if(ToDoYearShiftUpdate(BACKWARD) == TRUE)
			{
				ControlGetPushedPushButton(FORM_ALARM_DATE_SETTINGS, 2, &control_id);
				ControlGetLabel(control_id, &control_text);
				app_status.alarm_year = (USHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
			}
			return TRUE;
			
		case	BITMAP_DATE_SETTING_N2:
			if(ToDoYearShiftUpdate(FORWARD) == TRUE)
			{
				ControlGetPushedPushButton(FORM_ALARM_DATE_SETTINGS, 2, &control_id);
				ControlGetLabel(control_id, &control_text);
				app_status.alarm_year = (USHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
			}
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_CONTROL_SELECT:
			switch (Event->eventID)
			{
			case	PUSHBUTTON_DATE_SETTING_Y1:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y1, &control_text);
				app_status.alarm_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y2:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y2, &control_text);
				app_status.alarm_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y3:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y3, &control_text);
				app_status.alarm_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y4:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y4, &control_text);
				app_status.alarm_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_Y5:
				ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y5, &control_text);
				app_status.alarm_year = (SHORT)atol((const char *)control_text);
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_JAN:
				app_status.alarm_month = 1;
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_FEB:
				app_status.alarm_month = 2;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_MAR:
				app_status.alarm_month = 3;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_APR:
				app_status.alarm_month = 4;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_MAY:
				app_status.alarm_month = 5;
				ToDoDateSettingsUpdate();
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_JUN:
				app_status.alarm_month = 6;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_JUL:
				app_status.alarm_month = 7;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_AUG:
				app_status.alarm_month = 8;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_SEP:
				app_status.alarm_month = 9;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_OCT:
				app_status.alarm_month = 10;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_NOV:
				app_status.alarm_month = 11;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	PUSHBUTTON_DATE_SETTING_DEC:
				app_status.alarm_month = 12;
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			case	BUTTON_DATE_SETTING_TODAY:
				RtcGetTime(&time);
				FormSetControlGroupSelection(FORM_ALARM_DATE_SETTINGS,
					PUSHBUTTON_DATE_SETTING_JAN + time.mon);
				app_status.alarm_year = time.year;
				app_status.alarm_month = time.mon + 1;
				app_status.alarm_day = time.mday;
				ToDoYearSettingUpdate(&app_status.alarm_year);
				ToDoDateSettingsUpdate();	
				return TRUE;
				
			default:
				return FALSE;
				}
				
		case	EVT_TABLE_SELECT:
			TableGetItemText (TABLE_DATE_SETTING, (USHORT)Event->para1, (USHORT)Event->para2, &table_text);
			if (table_text[0] != 0)
			{
				app_status.alarm_day = (SHORT)atol((const char *)table_text);
				ToDoDateSettingsUpdate();	
			}
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
				if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_ALARM_SETTINGS);
				
				ToDoPackDueDate(ptr, app_status.alarm_year, app_status.alarm_month,
					app_status.alarm_day);
				ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
				ControlDrawControl(POPUP_TRIGGER_ALARM_DATE);								
				FormEraseForm(FORM_ALARM_DATE_SETTINGS);
				
				if (pressed_object1 == FORM_TO_DO_DETAILS)
					FormDrawForm(FORM_TO_DO_NEW);
				else if (pressed_object1 == FORM_TO_DO_VIEWING)
					FormDrawForm(FORM_TO_DO_VIEWING);
				
				FormPopupForm(FORM_ALARM_SETTINGS);
				return TRUE;
				
			case	INLAY_EXIT:
				if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_ALARM_SETTINGS);
				
				app_status.alarm_year = backup_year;
				app_status.alarm_month = backup_month;
				app_status.alarm_day = backup_day;
				
				ToDoPackDueDate(ptr, app_status.alarm_year, app_status.alarm_month,
					app_status.alarm_day);
				ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
				ControlDrawControl(POPUP_TRIGGER_ALARM_DATE);								
				FormEraseForm(FORM_ALARM_DATE_SETTINGS);
				
				if (pressed_object1 == FORM_TO_DO_DETAILS)
					FormDrawForm(FORM_TO_DO_NEW);
				else if (pressed_object1 == FORM_TO_DO_VIEWING)
					FormDrawForm(FORM_TO_DO_VIEWING);
				
				FormPopupForm(FORM_ALARM_SETTINGS);
				return TRUE;	
				
			default:
				return FALSE;
			}
			
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerSaveChanges
* Purpose: 	This function is the event handler for the 
*			Save Changes screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerSaveChanges(EvtType* Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_NO;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_SAVE_CHANGES);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		if (FormGetObjectPointer(pressed_object2, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(pressed_object2);
		
		FormPopupForm(pressed_object2);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_SAVE_CHANGES_YES:
			if (FormGetObjectPointer(pressed_object1, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(pressed_object1);
			
			ToDoFieldUpdateRecord();
			/* Save changes to record */
			ToDoChangeUpdateRecord();
			ToDoSetTableFont();
			/* Update the total number of rows in the Table Display */
			ToDoRecordToTable(tdl_dbid,app_status.new_sort_mode);
			FormPopupForm(pressed_object1);
			return TRUE;
			
		case	BUTTON_SAVE_CHANGES_NO:
			if (FormGetObjectPointer(pressed_object1, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(pressed_object1);
			
			if (tdl_field_buffer[0] !=0 && app_status.edit_mode != TO_DO_VIEWING)
			{
				strcpy(tdl_field_buffer[0],(BYTE*)(""));
				ToDoFieldBufferToField();
				ToDoClearFieldBuffer();
			}
			/* Delete the Voice Record */
			if (alarm_settings.recorded == TRUE)
			{	
				DataDeleteRecord(alarm_settings.dbid, alarm_settings.temp_recid, FALSE);
				alarm_settings.recorded = FALSE;
			}
			ToDoSetTableFont();
			ToDoRecordToTable(tdl_dbid, app_status.new_sort_mode);
			FormPopupForm(pressed_object1);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		default:
			return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerPurgeRecord
* Purpose: 	This function is called to handle the event for the form
*			FORM_SCH_PURGE
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerPurgeRecord(EvtType *Event)
{
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_PURGE_PROCEED || Event->para1 == SLETTER_PURGE_PROCEED)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_PURGE_PROCEED;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_PURGE_CANCEL || Event->para1 == LLETTER_PURGE_CANCEL)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_PURGE_CANCEL;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_TO_DO_PURGE);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_TO_DO_PURGE_PROCEED)
		{	
			ToDoPurgeRecord();
			/* Delete all the Alarm Manager's settings */
			ToDoDelAnAlarm(app_status.rec_id);
			FormPopupForm(FORM_TO_DO_LIST);
		}
		else if (Event->eventID == BUTTON_TO_DO_PURGE_CANCEL)
			FormPopupForm(FORM_TO_DO_LIST);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
		{
			ToDoPurgeRecord();
			/* Delete all the Alarm Manager's settings */
			ToDoDelAnAlarm(app_status.rec_id);
			FormPopupForm(FORM_TO_DO_LIST);
		}
		else if (Event->para1 == INLAY_EXIT)
			FormPopupForm(FORM_TO_DO_LIST);
		return TRUE;
		
	default: return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerReplayVoice
* Purpose: 	This function is the event handler for the
*			REPLAY VOICE MEMO screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerReplayVoice(EvtType* Event)
{
	BYTE		object_type;
	Bitmap		*bitmap_addr;	
	UWORD		rec_num;
	Scrollbar	*scroll_ptr;
	SoundSettings sound;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_PAUSE_PLAY || Event->para1 == SLETTER_PAUSE_PLAY)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				
				FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
				if (bitmap_addr->bitmap_attr.bitmap_enable == TRUE)
					Event->eventID = BITMAP_REPLAY_VOICE_PAUSE;
				else 
					Event->eventID = BITMAP_REPLAY_VOICE_PLAY;
				
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_STOP || Event->para1 == SLETTER_STOP)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_REPLAY_VOICE_STOP;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_STOP)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (CheckBatteryLow() == 1)
		{
			no_bat_cause = pressed_object1;
			FormPopupForm(FORM_TO_DO_NO_BAT);
			return FALSE;
		}
		
		ToDoSoundDatabaseChecking();
		InlaySetEnableStatus(FALSE);
		BatteryWarningSetEnableStatus(FALSE);
		AlarmMgrEnable(FALSE);
		SystemSetMappedHardwareKeyStatus(FALSE);
		alarm_settings.play_stop = TRUE;
		alarm_settings.play_pause_frame = 0;
		
		if (alarm_settings.recorded == FALSE)
		{
			DataTotalRecord(alarm_settings.dbid, &rec_num);
			DataNumtoRecID(alarm_settings.dbid,  0, &rec_num);
			DataRecIDtoNum(alarm_settings.dbid, app_status.sound_rec_id, &rec_num);
			DataOpenRecord(alarm_settings.dbid, rec_num, &app_status.sound_rec_id, NULL);
			SndPlay(alarm_settings.play_pause_frame, alarm_settings.dbid, app_status.sound_rec_id, 0);
		}
		else
		{
			DataRecIDtoNum(alarm_settings.dbid, alarm_settings.temp_recid, &rec_num);
			DataOpenRecord(alarm_settings.dbid, rec_num, &alarm_settings.temp_recid, NULL);
			
			SndPlay(alarm_settings.play_pause_frame, alarm_settings.dbid, alarm_settings.temp_recid, 0);
		}
		FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
		bitmap_addr->bounds.ycoord = TODO_YCOORD1;
		bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
		bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
		
		FormGetObjectPointer(BITMAP_REPLAY_VOICE_STOP, &object_type, (void **)&bitmap_addr);
		bitmap_addr->bounds.ycoord = TODO_YCOORD2;
		SySetupGetSoundSettings(&sound);
		FormGetObjectPointer(SCROLLBAR_REPLAY_VOICE, &object_type, (void**)&scroll_ptr);
		scroll_ptr->scrollbar_min = sound.vol_min;
		scroll_ptr->scrollbar_total_num_lines = sound.vol_max;
		scroll_ptr->scrollbar_max = sound.vol_max - 1;
		scroll_ptr->scrollbar_value = sound.vol_curr;
		FormDrawForm(FORM_REPLAY_VOICE);			
		return TRUE;
		
	case	POWER_EVENT:
		if (Event->eventID == BAT_MAIN_LOW)
		{
			no_bat_cause = FORM_REPLAY_VOICE;
			
			FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
			bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
			bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
			BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
			
			FormGetObjectPointer(BITMAP_REPLAY_VOICE_PLAY, &object_type, (void **)&bitmap_addr);
			bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
			bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_REPLAY_VOICE_PLAY);
			
			SndStop();
			if (alarm_settings.recorded == FALSE)
				DataCloseRecord(alarm_settings.dbid, app_status.sound_rec_id);
			else
				DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
			
			alarm_settings.play_pause_frame = 0;
			alarm_settings.play_stop = TRUE;
			FormPopupForm(FORM_TO_DO_NO_BAT);
		}
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		switch (Event->eventID)
		{
		case	BITMAP_REPLAY_VOICE_PLAY:
			ToDoSoundReplayStart();
			return TRUE;
			
		case	BITMAP_REPLAY_VOICE_STOP:
			ToDoSoundReplayStop();
			return TRUE;
			
		case	BITMAP_REPLAY_VOICE_PAUSE:
			FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
			bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
			bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
			BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
			
			FormGetObjectPointer(BITMAP_REPLAY_VOICE_PLAY, &object_type, (void **)&bitmap_addr);
			bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
			bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_REPLAY_VOICE_PLAY);
			alarm_settings.play_pause_frame = SndPause();
			alarm_settings.play_stop = FALSE;
			return TRUE;
			
		case	BITMAP_DIALOG_EXIT:
			alarm_settings.play_stop = TRUE;
			alarm_settings.play_pause_frame = 0;
			SndStop();
			if (alarm_settings.recorded == FALSE)
				DataCloseRecord(alarm_settings.dbid, app_status.sound_rec_id);
			else
			{
				DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
				DataCloseDB(alarm_settings.dbid);
			}
			FormPopupForm(pressed_object1);
			InlaySetEnableStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			//							AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_SCROLLBAR_SELECT:
			ToDoScrollbarSetReplayVoice(Event);
			return TRUE;
			
		case	EVT_SCROLLBAR_REPEAT:
			ScrollbarDrawScrollbar(SCROLLBAR_REPLAY_VOICE);
			return TRUE;
			
		case	SND_MGR_EVT:
			if (Event->eventID == REC_END)
			{
				FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void**)&bitmap_addr);
				bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
				BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
				
				FormGetObjectPointer(BITMAP_REPLAY_VOICE_PLAY, &object_type, (void **)&bitmap_addr);
				bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
				bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_REPLAY_VOICE_PLAY);
				SndStop();
				
				if (alarm_settings.recorded == FALSE)
					DataCloseRecord(alarm_settings.dbid, app_status.sound_rec_id);
				else
				{
					DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
					DataCloseDB(alarm_settings.dbid);
				}
				alarm_settings.play_stop = TRUE;
				alarm_settings.play_pause_frame = 0;
				
				InlaySetEnableStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
				//					AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				return TRUE;
			}
			return FALSE;
			
		case	EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_REPLAY_VOICE, SCROLLBAR_DOWN_ARROW);
				//					ScrollbarHardButtonSetScrollbar(SCROLLBAR_REPLAY_VOICE, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_REPLAY_VOICE, SCROLLBAR_UP_ARROW);
				//					ScrollbarHardButtonSetScrollbar(SCROLLBAR_REPLAY_VOICE, SCROLLBAR_DOWN_ARROW);
				else if (Event->para2 == IO_SOUND_PLAY)
				{
					FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
					if (bitmap_addr->bitmap_attr.bitmap_enable == FALSE)
						ToDoSoundReplayStart();
					else
					{
						FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
						bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
						bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
						BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
						
						FormGetObjectPointer(BITMAP_REPLAY_VOICE_PLAY, &object_type, (void **)&bitmap_addr);
						bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
						bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
						BitmapDrawBitmap(BITMAP_REPLAY_VOICE_PLAY);
						alarm_settings.play_pause_frame = SndPause();
						alarm_settings.play_stop = FALSE;
						return TRUE;
					}
				}
				else if (Event->para2 == IO_SOUND_STOP)
					ToDoSoundReplayStop();
				return TRUE;
			}
			return FALSE;
			
		case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				alarm_settings.play_stop = TRUE;
				alarm_settings.play_pause_frame = 0;
				SndStop();
				if (alarm_settings.recorded == FALSE)
					DataCloseRecord(alarm_settings.dbid, app_status.sound_rec_id);
				else
				{
					DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
					DataCloseDB(alarm_settings.dbid);
				}
				FormPopupForm(pressed_object1);
				InlaySetEnableStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
				//					AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
			}
			return TRUE;
			
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerRecordVoiceMemo
* Purpose: 	This function is the event handler for the
*			RECORD VOICE MEMO screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerRecordVoice(EvtType* Event)
{
	Bitmap	*bitmap_addr;
    Form    *form_addr;
	BYTE	object_type;
	UWORD	field_size;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_PAUSE_PLAY || Event->para1 == SLETTER_PAUSE_PLAY)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_REPLAY_VOICE_PAUSE;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_REC || Event->para1 == SLETTER_REC)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_REPLAY_VOICE_REC;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_STOP || Event->para1 == SLETTER_STOP)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_REPLAY_VOICE_STOP;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		ToDoSoundDatabaseChecking();
		
		alarm_settings.rec_stop = TRUE;
		
		FormGetObjectPointer(BITMAP_REPLAY_VOICE_REC, &object_type, (void **)&bitmap_addr);
		bitmap_addr->bounds.ycoord = TODO_YCOORD3;
		bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
		bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
		
		FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
		bitmap_addr->bounds.ycoord = TODO_YCOORD4;
		bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
		bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
		
		FormGetObjectPointer(BITMAP_REPLAY_VOICE_STOP, &object_type, (void **)&bitmap_addr);
		bitmap_addr->bounds.ycoord = TODO_YCOORD5;
		bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
		bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
		FormDrawForm(FORM_RECORD_VOICE);
		return TRUE;
		
	case	POWER_EVENT:
		if (Event->eventID == BAT_MAIN_LOW)
		{
			no_bat_cause = FORM_RECORD_VOICE;
			app_status.alarm_status = TONE_ALARM;
			
			if (alarm_settings.recorded == TRUE)
				ToDoSoundRecordStop();
			
			FormPopupForm(FORM_TO_DO_NO_BAT);
		}
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		switch (Event->eventID)
		{
		case	BITMAP_REPLAY_VOICE_REC:
			ToDoSoundRecordStart();
			return	TRUE;
			
		case	BITMAP_REPLAY_VOICE_STOP:
			ToDoSoundRecordStop();
			return TRUE;
			
		case	BITMAP_REPLAY_VOICE_PAUSE:
			FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
			bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
			bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
			BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
			
			FormGetObjectPointer(BITMAP_REPLAY_VOICE_REC, &object_type, (void **)&bitmap_addr);
			bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
			bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_REPLAY_VOICE_REC);
			SndPause();
			return TRUE;
			
		case	BITMAP_DIALOG_EXIT:
			alarm_settings.rec_stop = TRUE;
			SndStop();
			DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
			DataCloseDB(alarm_settings.dbid);
			
			if (no_bat_cause == FORM_RECORD_VOICE)
				ToDoAlarmSetUpScreen();
			
			FormPopupForm(FORM_ALARM_SETTINGS);
			/* Enable other event */
			InlaySetEnableStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			//							AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case 	EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS)
			{
				if (Event->para2 == IO_SOUND_RECORD)
				{
					FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
					if (bitmap_addr->bitmap_attr.bitmap_enable == FALSE)
						ToDoSoundRecordStart();
					else
					{
						FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
						bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
						bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
						BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
						
						FormGetObjectPointer(BITMAP_REPLAY_VOICE_REC, &object_type, (void **)&bitmap_addr);
						bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
						bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
						BitmapDrawBitmap(BITMAP_REPLAY_VOICE_REC);
						SndPause();
						return TRUE;
					}
				}
				else if (Event->para2 == IO_SOUND_STOP)
					ToDoSoundRecordStop();
				
				return	TRUE;
			}
			return	FALSE;
			
		case	SND_MGR_EVT:
			if (Event->eventID == LOW_MEM)
			{
				alarm_settings.rec_stop = TRUE;
				FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void**)&bitmap_addr);
				bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_addr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_REPLAY_VOICE_REC, &object_type, (void**)&bitmap_addr);
				bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_REPLAY_VOICE_REC);
				SndStop();
				
				if (alarm_settings.recorded == TRUE)
				{
					DataFieldSize(alarm_settings.dbid, alarm_settings.temp_recid, 0, &field_size);
					if (field_size <= 0)
					{
						DataDeleteRecord(alarm_settings.dbid, alarm_settings.temp_recid, FALSE);
						alarm_settings.recorded = FALSE;
					}
				}
				DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
				DataCloseDB(alarm_settings.dbid);
				
				if (FormGetObjectPointer(FORM_TO_DO_NO_MEM, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_TO_DO_NO_MEM);
				
				FormPopupForm(FORM_TO_DO_NO_MEM);
				/* Enable other event */
				InlaySetEnableStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
				//					AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				return TRUE;
			}
			else if (Event->eventID == REC_TIME && Event->para1)
			{
				time_count++;
				ScrollbarSetScrollbar(SCROLLBAR_TODO_REC, time_count%15, 15, 0, 1, 15);
				ScrollbarDrawScrollbar(SCROLLBAR_TODO_REC);
				return TRUE;
			}
			return FALSE;
			
		case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				alarm_settings.rec_stop = TRUE;
				SndStop();
				
				DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
				DataCloseDB(alarm_settings.dbid);
				
				if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_ALARM_SETTINGS);
				
				if (no_bat_cause == FORM_RECORD_VOICE)
					ToDoAlarmSetUpScreen();
				
				FormPopupForm(FORM_ALARM_SETTINGS);
				/* Enable other event */
				InlaySetEnableStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
				//					AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
			}
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerAlarmVoiceMemoExists
* Purpose: 	This function is the event handler for the FORM_SCH_VOICE_EXISTS
*			page of the Scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerAlarmVoiceMemoExists(EvtType *Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_VOICE_EXISTS_PLAY || Event->para1 == SLETTER_VOICE_EXISTS_PLAY)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_VOICE_EXISTS_PLAY;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_VOICE_EXISTS_REPLACE || Event->para1 == SLETTER_VOICE_EXISTS_REPLACE)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_TO_DO_VOICE_EXISTS_REPLACE;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_TO_DO_VOICE_EXISTS);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		FormEraseForm(FORM_TO_DO_VOICE_EXISTS);
		if (Event->eventID == BUTTON_TO_DO_VOICE_EXISTS_PLAY)
		{
			if (FormGetObjectPointer(FORM_REPLAY_VOICE, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_REPLAY_VOICE);
			
			FormPopupForm(FORM_REPLAY_VOICE); 
		}
		else //	BUTTON_TO_DO_VOICE_EXISTS_REPLACE
		{
			if (FormGetObjectPointer(FORM_RECORD_VOICE, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_RECORD_VOICE);
			/* Draw Background Viewing */
			if (pressed_object1 == FORM_TO_DO_VIEWING)
				FormDrawForm(FORM_TO_DO_VIEWING);
			else
				FormDrawForm(FORM_TO_DO_NEW);
			
			time_count = 0;
			ScrollbarSetScrollbar(SCROLLBAR_TODO_REC, 0, 14, 0, 1, 15);
			FormPopupForm(FORM_RECORD_VOICE);
		}
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_ALARM_SETTINGS);
		
		FormPopupForm(FORM_ALARM_SETTINGS);
		return TRUE;
		
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:    SchedulerNoMem
* Purpose: 	This function is called to handle the event for the form
FORM_SCH_NO_MEM
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerToDoNoMem(EvtType *Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch	(Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_TO_DO_NO_MEM);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		if (alarm_settings.recorded == FALSE)
		{
			if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_ALARM_SETTINGS);
			
			app_status.alarm_status = TONE_ALARM;
			ToDoAlarmSetUpScreen();
			FormPopupForm(FORM_ALARM_SETTINGS);
		}
		else
		{
			if (FormGetObjectPointer(FORM_RECORD_VOICE, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_RECORD_VOICE);
			
			time_count = 0;
			ScrollbarSetScrollbar(SCROLLBAR_TODO_REC, 0, 14, 0, 1, 15);
			FormDrawForm(FORM_ALARM_SETTINGS);
			FormPopupForm(FORM_RECORD_VOICE);
		}
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			if (alarm_settings.recorded == FALSE)
			{
				if (FormGetObjectPointer(FORM_ALARM_SETTINGS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_ALARM_SETTINGS);
				
				app_status.alarm_status = TONE_ALARM;
				ToDoAlarmSetUpScreen();
				FormPopupForm(FORM_ALARM_SETTINGS);
			}
			else
			{
				if (FormGetObjectPointer(FORM_RECORD_VOICE, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_RECORD_VOICE);
				
				time_count = 0;
				ScrollbarSetScrollbar(SCROLLBAR_TODO_REC, 0, 14, 0, 1, 15);
				FormDrawForm(FORM_ALARM_SETTINGS);
				FormPopupForm(FORM_RECORD_VOICE);
			}
		}
		return TRUE;
		
	default:	return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerAlarmSettings
* Purpose: 	This function is the event handler for the
*			ALARM SETTINGS screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerAlarmSettings(EvtType* Event)
{
	Control	*ctl_addr;	
	BOOLEAN	ctl_enable,	ctl_drawn, ctl_save_behind;
	BOOLEAN	ctl_active,	ctl_visible;
	BYTE	buffer[20], object_type;
	BYTE	*ptr = buffer;
	RTM		time;
	SHORT	temp_month;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_ALARM_DATE || Event->para1 == SLETTER_ALARM_DATE)
			{
				ControlPopupPopupTrigger(POPUP_TRIGGER_ALARM_DATE);
				return	FALSE;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		app_status.edit_mode = TO_DO_ALARM_SETTINGS;
		FormDrawForm(FORM_ALARM_SETTINGS);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		chk_status.new_entry_hit = TRUE;
		
		switch (Event->eventID)
		{
		case	PUSHBUTTON_ALARM_ON:
			ControlGetAttributes(PUSHBUTTON_VOICE_MEMO, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(PUSHBUTTON_VOICE_MEMO, TRUE, ctl_drawn, 
				ctl_save_behind, ctl_active, ctl_visible);
			ControlGetAttributes(PUSHBUTTON_TONE, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(PUSHBUTTON_TONE, TRUE, ctl_drawn, ctl_save_behind, 
				ctl_active, ctl_visible);
			ControlGetAttributes(POPUP_TRIGGER_ALARM_DATE, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(POPUP_TRIGGER_ALARM_DATE, TRUE, ctl_drawn, ctl_save_behind, 
				ctl_active, ctl_visible);
			/* Set Tone Alarm as default button */
			FormGetObjectPointer(PUSHBUTTON_TONE, &object_type, (void **)&ctl_addr);
			((ControlTemplatePushButton *) ((ctl_addr->control_template)))->control_value = TRUE;
			FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_TONE);
			app_status.alarm_status = TONE_ALARM;
			return TRUE;
			
		case	PUSHBUTTON_ALARM_OFF:
			/* Delete all the Alarm Manager's settings */
			ToDoDelAnAlarm(app_status.rec_id);
			
			ControlGetAttributes(PUSHBUTTON_VOICE_MEMO, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(PUSHBUTTON_VOICE_MEMO, FALSE, ctl_drawn, 
				ctl_save_behind, ctl_active, ctl_visible);
			ControlGetAttributes(PUSHBUTTON_TONE, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(PUSHBUTTON_TONE, FALSE, ctl_drawn, ctl_save_behind, 
				ctl_active, ctl_visible);
			ControlGetAttributes(POPUP_TRIGGER_ALARM_DATE, &ctl_enable, &ctl_drawn, 
				&ctl_save_behind, &ctl_active, &ctl_visible);
			ControlSetAttributes(POPUP_TRIGGER_ALARM_DATE, FALSE, ctl_drawn, ctl_save_behind, 
				ctl_active, ctl_visible);
			
			FormGetObjectPointer(PUSHBUTTON_TONE, &object_type, (void **)&ctl_addr);
			((ControlTemplatePushButton *) ((ctl_addr->control_template)))->control_value = FALSE;
			ControlDrawControl(PUSHBUTTON_TONE);
			FormGetObjectPointer(PUSHBUTTON_VOICE_MEMO, &object_type, (void **)&ctl_addr);
			((ControlTemplatePushButton *) ((ctl_addr->control_template)))->control_value = FALSE;
			ControlDrawControl(PUSHBUTTON_VOICE_MEMO);
			
			/* Temp Testing */
			strcpy((char *)buffer,TODO_NO_ALARM_DATE);
			ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
			ControlDrawControl(POPUP_TRIGGER_ALARM_DATE);
			app_status.alarm_year = 0;
			app_status.alarm_month = 0;
			app_status.alarm_day = 0;
			/* Update the alarm status of the specified record */
			app_status.alarm_status = NO_ALARM;
			alarm_date = NO_ALARM_DATE;
			return TRUE;
			
		case	PUSHBUTTON_VOICE_MEMO:
			FormEraseForm(FORM_ALARM_SETTINGS);
			FormDrawForm(pressed_object1);
			if ((app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == VOICE_NO_ALARM) && app_status.sound_rec_id != 0)
			{
				if (FormGetObjectPointer(FORM_TO_DO_VOICE_EXISTS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_TO_DO_VOICE_EXISTS);
				
				FormPopupForm(FORM_TO_DO_VOICE_EXISTS);
			}
			else
			{
				if (FormGetObjectPointer(FORM_RECORD_VOICE, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_RECORD_VOICE);
				
				if (FormGetObjectPointer(FORM_REPLAY_VOICE, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_REPLAY_VOICE);
				
				alarm_settings.temp_alarm_status = app_status.alarm_status;
				time_count = 0;
				ScrollbarSetScrollbar(SCROLLBAR_TODO_REC, 0, 14, 0, 1, 15);
				FormPopupForm(FORM_RECORD_VOICE);
			}
			app_status.alarm_status = VOICE_ALARM;
			return TRUE;
			
		case	PUSHBUTTON_TONE:
			app_status.alarm_status = TONE_ALARM;
			return TRUE;
			
		default:
			return FALSE;
		}
		
		case	EVT_CONTROL_POPUP_SELECT:
			chk_status.new_entry_hit = TRUE;
			
			if (Event->para1 == ALARM_DUE_DATE)
			{
				if (detail_date == NO_DUE_DATE || app_status.sch_year == 0)
				{
					alarm_date = NO_ALARM_DATE;
					app_status.alarm_year = 0;
					app_status.alarm_month = 0;
					app_status.alarm_day = 0;
					
					FormEraseForm(FORM_ALARM_SETTINGS);
					
					if (pressed_object1 == FORM_TO_DO_VIEWING)
						FormPopupForm(FORM_INVALID_ALARM_INPUT);
					else
					{
						FormDrawForm(FORM_TO_DO_NEW);
						FormPopupForm(FORM_NO_DUE_DATE);
					}
				}
				else
				{
					alarm_date = ALARM_DUE_DATE;
					app_status.alarm_year = app_status.sch_year;
					app_status.alarm_month = app_status.sch_month;
					app_status.alarm_day = app_status.sch_day;
				}
			}
			else if (Event->para1 == ALARM_BEFORE_DUE_DATE)
			{
				if (detail_date == NO_DUE_DATE || app_status.sch_year == 0)
				{
					alarm_date = NO_ALARM_DATE;
					app_status.alarm_year = 0;
					app_status.alarm_month = 0;
					app_status.alarm_day = 0;
					
					FormEraseForm(FORM_ALARM_SETTINGS);
					
					if (pressed_object1 == FORM_TO_DO_VIEWING)
						FormPopupForm(FORM_INVALID_ALARM_INPUT);
					else
					{
						FormDrawForm(FORM_TO_DO_NEW);
						FormPopupForm(FORM_NO_DUE_DATE);
					}
				}
				else
				{
					alarm_date = ALARM_BEFORE_DUE_DATE;
					app_status.alarm_year = app_status.sch_year;
					app_status.alarm_month = app_status.sch_month;
					app_status.alarm_day = app_status.sch_day;
					temp_month = app_status.alarm_month - 1;
					/* Call Function to get one day before due date */
					RtcDaysShift(&app_status.alarm_year, &temp_month, &app_status.alarm_day,-1);
					app_status.alarm_month = temp_month + 1;
				}
			}
			else
			{
				if (FormGetObjectPointer(FORM_ALARM_DATE_SETTINGS, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(FORM_ALARM_DATE_SETTINGS);
				
				if (alarm_date == NO_ALARM_DATE || app_status.alarm_year == 0)
				{
					RtcGetTime(&time);
					app_status.alarm_year = time.year;
					app_status.alarm_month = time.mon + 1;
					app_status.alarm_day = time.mday;
				}
				alarm_date = ALARM_CHOOSE_DATE;
				ToDoYearSettingUpdate(&app_status.alarm_year);
				FormSetControlGroupSelection(FORM_ALARM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_JAN + (app_status.alarm_month-1));
				/* Set up the specified start of week */
				///					ToDoSetStartOfWeekScreen();
				ToDoDateSettingsUpdate();
				FormPopupForm(FORM_ALARM_DATE_SETTINGS);
			}
			return TRUE;
			
		case	EVT_BITMAP_SELECT:
			FormEraseForm(FORM_ALARM_SETTINGS);
			
			if (app_status.alarm_year == 0 && app_status.alarm_status != NO_ALARM)
			{
				FormDrawForm(pressed_object1);
				FormPopupForm(FORM_INVALID_ALARM_INPUT);
			}
			else
			{
				if (FormGetObjectPointer(pressed_object1, &object_type, (void **)&form_addr)
					== ERR_UI_RES_NOT_FOUND)
					FormInitAllFormObjects(pressed_object1);
				
				if (pressed_object1 == FORM_TO_DO_VIEWING)
					ToDoViewingSetUpScreen();
				
				FormPopupForm(pressed_object1);
			}
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
			case	INLAY_EXIT:
				FormEraseForm(FORM_ALARM_SETTINGS);
				
				if (app_status.alarm_year == 0 && app_status.alarm_status != NO_ALARM)
				{
					FormDrawForm(pressed_object1);
					FormPopupForm(FORM_INVALID_ALARM_INPUT);
				}
				else
				{
					if (FormGetObjectPointer(pressed_object1, &object_type, (void **)&form_addr)
						== ERR_UI_RES_NOT_FOUND)
						FormInitAllFormObjects(pressed_object1);
					
					if (pressed_object1 == FORM_TO_DO_VIEWING)
						ToDoViewingSetUpScreen();
					
					FormPopupForm(pressed_object1);
				}
				return TRUE;
				
			default:
				return FALSE;
			}
			
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerToDoInvalidAlarmInput
* Purpose: 	This function is the event handler for the 
*			Save Changes screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerToDoInvalidAlarmInput(EvtType* Event)
{
	Form	*form_addr;
	BYTE	object_type;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormGetObjectPointer(FORM_INVALID_ALARM_INPUT, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_INVALID_ALARM_INPUT);
		FormDrawForm(FORM_INVALID_ALARM_INPUT);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormEraseForm(FORM_INVALID_ALARM_INPUT);
		FormPopupForm(FORM_ALARM_SETTINGS);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerNoDueDate
* Purpose: 	This function is the event handler for the
*			No Due Date screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN SchedulerNoDueDate(EvtType* Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_NO_DUE_DATE_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormGetObjectPointer(FORM_NO_DUE_DATE, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_NO_DUE_DATE);
		
		FormDrawForm(FORM_NO_DUE_DATE);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		switch (Event->eventID)
		{
		case	BITMAP_NO_DUE_DATE_EXIT:
			if (FormGetObjectPointer(FORM_TO_DO_DETAILS, &object_type, (void **)&form_addr)
				== ERR_UI_RES_NOT_FOUND)
				FormInitAllFormObjects(FORM_TO_DO_DETAILS);
			
			app_status.alarm_status = NO_ALARM;
			FormEraseForm(FORM_NO_DUE_DATE);
			FormPopupForm(FORM_TO_DO_DETAILS);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		default:
			return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerToDoNoBat
* Purpose:
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*		FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerToDoNoBat(EvtType *Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch	(Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormGetObjectPointer(FORM_TO_DO_NO_BAT, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_TO_DO_NO_BAT);
		
		FormDrawForm(FORM_TO_DO_NO_BAT);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(no_bat_cause);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(no_bat_cause);
		
		return TRUE;
		
	default:return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerNoMem
* Purpose: 	This function is called to handle the event for the form
*               NO MEMORY
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*		FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerSysLowMem(EvtType *Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_DIALOG_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch	(Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormGetObjectPointer(FORM_SYSTEM_LOW_MEM, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_SYSTEM_LOW_MEM);
		
		FormDrawForm(FORM_SYSTEM_LOW_MEM);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(low_memory_form_id);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(low_memory_form_id);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}
