/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   todofunc.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "Todo.h"
#include "ToDoFunc.h"
#include "ToDoDB.h"
#include "SySetup.h"
///#define	DEBUG

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/

/********************************************************
* Function:	ToDoSetUpFieldScreen
* Purpose: 	This function is called in order to set the layout of the 
*			To Do New screen
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Success
*			FALSE		NotHandled
* Comment: 	None
*********************************************************/
BOOLEAN ToDoSetUpFieldScreen(ObjectID form_id)
{
	BYTE		object_type;
	Field		*field_ptr;
	Scrollbar	*scroll_ptr;
	
	if (form_id == FORM_TO_DO_NEW || form_id == FORM_TO_DO_VIEWING)
	{
		if (form_id == FORM_TO_DO_NEW)
		{
			FormGetObjectPointer(FIELD_TO_DO_NEW, &object_type, (void**)&field_ptr);
			FormGetObjectPointer(SCROLLBAR_TO_DO_NEW, &object_type, (void**)&scroll_ptr);
		}
		else
		{
			FormGetObjectPointer(FIELD_TO_DO_VIEWING, &object_type, (void**)&field_ptr);
			FormGetObjectPointer(SCROLLBAR_TO_DO_VIEWING, &object_type, (void**)&scroll_ptr);
		}
		
		if (KeyboardCheckKeyboardStatus())
		{
			if (form_id == FORM_TO_DO_VIEWING)
				field_ptr->bounds.height = VIEWING_FIELD_HEIGHT_KEYBOARD_ON;
			else if (form_id == FORM_TO_DO_NEW)
				field_ptr->bounds.height = NEW_FIELD_HEIGHT_KEYBOARD_ON;
			
			scroll_ptr->bounds.height = SCROLLBAR_HEIGHT_KEYBOARD_ON;
		}
		else
		{
			if (form_id == FORM_TO_DO_VIEWING)
				field_ptr->bounds.height = VIEWING_FIELD_HEIGHT_KEYBOARD_OFF;
			else if (form_id == FORM_TO_DO_NEW)
				field_ptr->bounds.height = NEW_FIELD_HEIGHT_KEYBOARD_OFF;
			
			scroll_ptr->bounds.height = SCROLLBAR_HEIGHT_KEYBOARD_OFF;
		}
		return TRUE;
	}		
	return FALSE;	
}

/********************************************************
* Function:	ToDoFieldSetScrollbar
* Purpose: 	This function is called in order to set the 
*			values for a scrollbar		
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE				scrollbar is erased
*			FALSE				scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
*			If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN ToDoFieldSetScrollbar(ObjectID field_id, ObjectID scrollbar_id)
{
	Field		*field_ptr;
	Scrollbar	*scroll_ptr;
	BYTE		font_id;
	BYTE		object_type;
	WORD	max_num_lines;
	WORD	max_value, min_value, pagesize;
	
	
	FormGetObjectPointer(field_id, &object_type, (void**)&field_ptr);
	
	FieldGetFont(field_id, &font_id);
	max_num_lines = field_ptr->bounds.height/(SysGetFontHeight(font_id) + SPACE_LINE);
	
	pagesize = max_num_lines  - 1;
	min_value = 0;	
	max_value = field_ptr->field_total_num_lines - pagesize - 1;	
	
	//	if (field_ptr->field_total_num_lines >= max_num_lines)
	if (field_ptr->field_total_num_lines > max_num_lines)
		ScrollbarSetScrollbarVisible(scrollbar_id, TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(scrollbar_id, FALSE);
		ScrollbarEraseScrollbar(scrollbar_id);
		return FALSE;
	}
	
	FormGetObjectPointer(scrollbar_id, &object_type, (void**)&scroll_ptr);		
	scroll_ptr->scrollbar_draw_pagesize = max_num_lines;
	
	if (field_ptr->field_top_line_num > (field_ptr->field_total_num_lines - max_num_lines))
		ScrollbarSetScrollbar(scrollbar_id, max_value, max_value, min_value,
		pagesize, field_ptr->field_total_num_lines);
	else
		ScrollbarSetScrollbar(scrollbar_id, field_ptr->field_top_line_num, max_value, min_value,
		pagesize, field_ptr->field_total_num_lines);
	ScrollbarDrawScrollbar(scrollbar_id);
	return TRUE;
}

/********************************************************
* Function:	ToDoSetField
* Purpose: 	This function is called in order to set up 
*			the field in the To DO New screen when the 
*			data is first put to Field or the keyboard 
*			is popuped up and down
* Scope:	application
* Input:	form_id		ID value of the form that the field is on
*			field_id	ID value of field object to be scrolled
* Output:	None
* Return:	TRUE		Success
*			FALSE		NotHandled
* Comment: 	None
*********************************************************/
BOOLEAN ToDoEditSetField(ObjectID form_id, ObjectID field_id)
{
	Field	*field_ptr;
	BOOLEAN insert_pt_on = FALSE;
	BOOLEAN highlight_pt_on = FALSE;
	BYTE	font_id;
	BYTE	object_type;
	SHORT	acc_height = 0;
	SHORT   line_height;                    /* line_height = SysGetFontHeight(font_id) + SPACE_LINE;*/
	WORD	count = 0;				/* another temperatory variable */
	WORD	first_visible_char, last_visible_char;
	WORD	line_num, insert_pos;
	WORD	temp;
	
	
	FormGetObjectPointer(field_id, &object_type, (void**)&field_ptr);		
	insert_pt_on = field_ptr->field_attr.field_insert_pt_visible;
	highlight_pt_on = field_ptr->field_attr.field_highlight;
	
	FieldGetFont(field_id, &font_id);
    line_height = SysGetFontHeight(font_id) + SPACE_LINE;
	
	StrAnalyzeLine(field_ptr);
	FieldGetFirstVisibleChar(field_id, &first_visible_char);
	FieldGetLastVisibleChar(field_id, &last_visible_char);
	
	if (insert_pt_on == TRUE || highlight_pt_on == TRUE)
	{
		
		
		if (insert_pt_on)
		{
			for (count = 0; count < field_ptr->field_total_num_lines; count++)
			{
				if (field_ptr->field_insert_pt_char_pos >= field_ptr->field_lineinfo[count].start &&
					field_ptr->field_insert_pt_char_pos <= field_ptr->field_lineinfo[count].start + field_ptr->field_lineinfo[count].length)
					break;
			}
			
			if (field_ptr->field_insert_pt_char_pos < first_visible_char)
				field_ptr->field_top_line_num = count;
			else if (field_ptr->field_insert_pt_char_pos > last_visible_char)
				field_ptr->field_top_line_num = count - field_ptr->field_num_lines_displayed;
			
			if (field_ptr->field_num_lines_displayed < (field_ptr->bounds.height/(line_height)))
			{
				if (field_ptr->field_top_line_num > (field_ptr->field_total_num_lines - (field_ptr->bounds.height/(line_height))))
					field_ptr->field_top_line_num = (field_ptr->field_total_num_lines - (field_ptr->bounds.height/(line_height)));
				
				if (field_ptr->field_top_line_num < 0)
					field_ptr->field_top_line_num = 0;
			}
		}
		StrAnalyzeLine(field_ptr);
		StrCharPosToXY(field_ptr, field_ptr->field_insert_pt_char_pos,&(field_ptr->field_insert_pt_x), &(field_ptr->field_insert_pt_y));
		/* Set up the correct insert pt position when keyboard on */
		FieldGetInsertPointPosition(field_id, &insert_pos);
		FieldGetFirstVisibleChar (field_id, &first_visible_char);
		FieldGetLastVisibleChar (field_id, &last_visible_char);
		
		if (insert_pt_on)
		{
			if(insert_pos > last_visible_char)
			{
				FieldCharPosToLineNum (field_ptr, insert_pos, &line_num);
				FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
			}
			FieldSetInsertPointPositionByCharPos(field_id, insert_pos);
		}
		else
		{
			temp = field_ptr->field_highlight_start_char;
			if (temp < field_ptr->field_highlight_end_char)
				temp = field_ptr->field_highlight_end_char;
			if (temp >= last_visible_char)
			{
				FieldCharPosToLineNum(field_ptr, temp, &line_num);
				if ((line_num - (field_ptr->bounds.height/(line_height)) + 1) < 0)
					FieldSetTopLineNum(field_id, 0);
				else
					FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
			}
			// ------------------------------------------------------------
			// ------------- add at 19052000 ------------------------------
			else
			{
				FieldGetNumOfChars(field_id, &temp);
				FieldCharPosToLineNum(field_ptr, temp, &line_num);
				if ((field_ptr->field_top_line_num + (field_ptr->bounds.height/(line_height))) >= line_num)
					if ((line_num - (field_ptr->bounds.height/(line_height)) + 1) < 0)
						FieldSetTopLineNum(field_id, 0);
					else
						FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
			}
			// ------------------------------------------------------------
		}
	}
	else
	{
		FieldCharPosToLineNum(field_ptr, last_visible_char, &line_num);
		if ((field_ptr->field_top_line_num + (field_ptr->bounds.height/(line_height))) >= line_num)
			if ((line_num - (field_ptr->bounds.height/(line_height)) + 1) < 0)
				FieldSetTopLineNum(field_id, 0);
			else
				FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);		
	}
	return TRUE;
}

/********************************************************
* Function:	ToDoScrollbarSetField
* Purpose: 	This function is called to set up the field
*			object when the scrollbar is moved.
* Scope:	application
* Input:	Event		
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoScrollbarSetField(ObjectID field_id, ObjectID scrollbar_id, EvtType *Event)
{
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	
	ScrollbarGetScrollbar(scrollbar_id, &value, &max, &min, &pagesize, &scroll_total_lines);
	ScrollbarSetScrollbar(scrollbar_id, Event->para2, max, min, pagesize, scroll_total_lines);
	
	FieldSetTopLineNum(field_id, (USHORT)(Event->para2));
	FieldDrawField(field_id);
	
	ScrollbarDrawScrollbar(scrollbar_id);		
	return;
}

/******************************************************************
* Function:	ToDoScrollbarSetTable
* Purpose: 	This function is called to set the To Do List
*			when the scrollbar is moved.
* Scope:	application
* Input:	Event		
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoScrollbarSetTable(EvtType *Event)
{
	WORD		max,min,value,pagesize;
	WORD		scroll_total_lines;
	BYTE		object_type;
	Scrollbar*	scroll_ptr;
	
	ScrollbarGetScrollbar(SCROLLBAR_TO_DO_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);
	
	if ((Event->para2 - Event->para1) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_TO_DO_LIST, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
		to_do_list.top_row_num = (USHORT)(Event->para2) - 1;
	}
	else if ((Event->para1 - Event->para2) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_TO_DO_LIST, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
		to_do_list.top_row_num = (USHORT)(Event->para2) + 1;
	}
	else
	{	
		ScrollbarSetScrollbar(SCROLLBAR_TO_DO_LIST, Event->para2, max, min, pagesize, scroll_total_lines);
		to_do_list.top_row_num = (USHORT)(Event->para2);
	}	
	
	if (Event->para2 != Event->para1)
	{
		ToDoTableDisplayDraw(&to_do_list);
		TableDrawTable(TABLE_TO_DO_LIST);
	}
	
    FormGetObjectPointer(SCROLLBAR_TO_DO_LIST, &object_type, (void**)&scroll_ptr);
    scroll_ptr->scrollbar_draw_pagesize = pagesize;
    ScrollbarDrawScrollbar(SCROLLBAR_TO_DO_LIST);    
}

/********************************************************
* Function:	ToDoListSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:	application
* Input:	BYTE				the starting_char
* Output:	None
* Return:	TRUE		scrollbar is erased
*			FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
*			If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN ToDoListSetScrollbar()
{
	Scrollbar *scroll_ptr;
	BYTE object_type;
	USHORT max_num_rows_display;
	USHORT top_row_num;
	USHORT current_num_rows_display;
	WORD max_value, min_value, pagesize, total_num_rows;
	
	max_num_rows_display = to_do_list.num_rows_displayed;
	total_num_rows = to_do_list.total_num_rows;
	top_row_num = to_do_list.top_row_num;
	current_num_rows_display = to_do_list.num_rows_displayed;
	
	pagesize = max_num_rows_display;
	min_value = 0;
	max_value = total_num_rows - pagesize;	
	
	if (total_num_rows > max_num_rows_display)
		ScrollbarSetScrollbarVisible(SCROLLBAR_TO_DO_LIST,TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_TO_DO_LIST,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_TO_DO_LIST);
		return FALSE;
	}
	
	if (top_row_num > (total_num_rows - max_num_rows_display))
		ScrollbarSetScrollbar(SCROLLBAR_TO_DO_LIST, max_value, max_value, min_value,
		pagesize, total_num_rows);
	else
		ScrollbarSetScrollbar(SCROLLBAR_TO_DO_LIST, top_row_num, max_value, min_value,
		pagesize, total_num_rows);
	
	FormGetObjectPointer(SCROLLBAR_TO_DO_LIST, &object_type, (void**)&scroll_ptr);
	scroll_ptr->scrollbar_draw_pagesize = pagesize;
	
	ScrollbarDrawScrollbar(SCROLLBAR_TO_DO_LIST);
	return TRUE;
}

/******************************************************************
* Function:	ToDoScrollbarSetToDoViewing
* Purpose: 	
* Scope:	application
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoScrollbarSetToDoViewing(EvtType *Event)
{
	WORD	max,min,current_value,pagesize;
	WORD	scroll_total_lines;
	
	ScrollbarGetScrollbar(SCROLLBAR_TO_DO_VIEWING, &current_value, &max, &min, &pagesize, &scroll_total_lines);
	ScrollbarSetScrollbar(SCROLLBAR_TO_DO_VIEWING, Event->para2, max, min, pagesize, scroll_total_lines);
	ScrollbarDrawScrollbar(SCROLLBAR_TO_DO_VIEWING);
}

/********************************************************
* Function:	TableFindCellNumber
* Purpose: 	This function is called in order to get cell number
*			of the table object
* Scope:	application
* Input:	Event			Event pointer
* Output:	None
* Return:	Cell number
* Comment: 	None
*********************************************************/
USHORT TableFindCellNumber(EvtType *Event, TableDisplay *table_display)
{
	USHORT	cell_num;
	
	cell_num = Event->para2 + ((Event->para1+table_display->top_row_num) * 5);
	return	cell_num;
}

/********************************************************
* Function:	ToDoListDisplayGetRecordID
* Purpose: 	This function is called in order to get the record ID 
*			of a particular table item in the Table object
* Scope:	application
* Input:	table_display	table-display structure
*			item_num		item number
* Output:	rec_id			Pointer to record ID of the list object
* Return:	TRUE    handled
*			FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ToDoListDisplayGetRecordID(TableDisplay *table_display, USHORT row_num, RecordID *rec_id, DatabaseID *dbid)
{
	RecordIDBlock *temp = table_display->record_id_block;
	USHORT count = 0;
	
	if (row_num >= table_display->total_num_rows) return FALSE;
	if (table_display->record_id_block == NULL) return FALSE;
	
	while (temp != NULL)
	{
		if ((row_num >= count) && (row_num < (count + 20)))
		{
			*rec_id = temp->record_id[row_num - count];
			*dbid = temp->dbid[row_num - count];
			return TRUE;
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	return FALSE;
}

/******************************************************************
* Function:	ToDoViewingSetUpScreen
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoViewingSetUpScreen()
{
	CountrySettings country;
	Control	*ctl_addr;
	Bitmap	*bmp_addr;
	BYTE	object_type, text_buffer[12], text_buffer2[20];
	BYTE	*ptr = text_buffer;
	
	
	/* Set up Complete status */
	FormGetObjectPointer(CHECKBOX_TO_DO_VIEWING, &object_type, (void **)&ctl_addr);
	if (app_status.completed_status == COMPLETED)
		((ControlTemplateCheckBox *) ((ctl_addr->control_template)))->control_value = TRUE;
	else
		((ControlTemplateCheckBox *) ((ctl_addr->control_template)))->control_value = FALSE;
	/* Set up Alarm status */
	if (app_status.alarm_status == TONE_ALARM)
	{
		FormGetObjectPointer(BITMAP_TO_DO_TONE_VIEWING, &object_type, (void **)&bmp_addr);
		bmp_addr->bitmap_attr.bitmap_enable = FALSE;
		bmp_addr->bitmap_attr.bitmap_active = FALSE;
		bmp_addr->bitmap_attr.bitmap_visible = TRUE;
		
		FormGetObjectPointer(BITMAP_TO_DO_VOICE_VIEWING, &object_type, (void **)&bmp_addr);
		bmp_addr->bitmap_attr.bitmap_enable = FALSE;
		bmp_addr->bitmap_attr.bitmap_active = FALSE;
		bmp_addr->bitmap_attr.bitmap_visible = FALSE;
	}
	else if (app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == VOICE_NO_ALARM)
	{
		FormGetObjectPointer(BITMAP_TO_DO_TONE_VIEWING, &object_type, (void **)&bmp_addr);
		bmp_addr->bitmap_attr.bitmap_enable = FALSE;
		bmp_addr->bitmap_attr.bitmap_active = FALSE;
		bmp_addr->bitmap_attr.bitmap_visible = FALSE;
		
		FormGetObjectPointer(BITMAP_TO_DO_VOICE_VIEWING, &object_type, (void **)&bmp_addr);
		bmp_addr->bitmap_attr.bitmap_enable = TRUE;
		bmp_addr->bitmap_attr.bitmap_active = TRUE;
		bmp_addr->bitmap_attr.bitmap_visible = TRUE;
	}
	else
	{
		FormGetObjectPointer(BITMAP_TO_DO_TONE_VIEWING, &object_type, (void **)&bmp_addr);
		bmp_addr->bitmap_attr.bitmap_enable = FALSE;
		bmp_addr->bitmap_attr.bitmap_active = FALSE;
		bmp_addr->bitmap_attr.bitmap_visible = FALSE;
		
		FormGetObjectPointer(BITMAP_TO_DO_VOICE_VIEWING, &object_type, (void **)&bmp_addr);
		bmp_addr->bitmap_attr.bitmap_enable = FALSE;
		bmp_addr->bitmap_attr.bitmap_active = FALSE;
		bmp_addr->bitmap_attr.bitmap_visible = FALSE;
	}
	/* Set up Priority */
	sprintf((char*)ptr,"%d",app_status.priority_status);
	ControlSetLabel(POPUP_TRIGGER_PRIORITY_VIEWING, text_buffer);
	/* Set up Field contents */
	FieldSetText(FIELD_TO_DO_VIEWING, tdl_field_buffer[0]);
	/* Set up Field Size */
	FieldSetFont(FIELD_TO_DO_VIEWING, table_font);
	/* Set up Due Date */
	if (app_status.sch_year == 0)
	{
		strcpy((char *)text_buffer2,TODO_ADD_DUE_DATE);
		ControlSetLabel(BUTTON_TO_DO_CHANGE_DUE_DATE, text_buffer2);	
		
		FormGetObjectPointer(BUTTON_TO_DO_VIEW_DATE, &object_type, (void **)&ctl_addr);
		ctl_addr->control_attr.control_enable = FALSE;
		ctl_addr->control_attr.control_visible = FALSE;
	}
	else
	{
		strcpy((char *)text_buffer2,TODO_CANCEL_DUE_DATE);
		ControlSetLabel(BUTTON_TO_DO_CHANGE_DUE_DATE, text_buffer2);	
		
		FormGetObjectPointer(BUTTON_TO_DO_VIEW_DATE, &object_type, (void **)&ctl_addr);
		ctl_addr->control_attr.control_enable = TRUE;
		ctl_addr->control_attr.control_visible = TRUE;
		
		SySetupGetCountrySettings(&country);
		
		if (country.date_fmt == SYSETUP_YMD)
		{
			sprintf((char*)ptr,"%d",app_status.sch_year);
			ptr +=4;
			*(ptr++) = '/';
			sprintf((char*)ptr,"%d",app_status.sch_month);
			if (app_status.sch_month < 10)
				ptr++;
			else
				ptr +=2;
			*(ptr++) = '/';
			if (app_status.sch_day < 10)
			{
				*ptr = '0';
				ptr++;
				sprintf((char*)ptr, "%d", app_status.sch_day);
			}
			else
				sprintf((char*)ptr, "%d", app_status.sch_day);
		}
		else if (country.date_fmt == SYSETUP_DMY)
		{
			if (app_status.sch_day < 10)
			{
				*ptr = '0';
				ptr++;
				sprintf((char*)ptr,"%d",app_status.sch_day);
				ptr++;
			}
			else
			{
				sprintf((char*)ptr,"%d",app_status.sch_day);
				ptr +=2;
			}
			*(ptr++) = '/';
			sprintf((char*)ptr,"%d",app_status.sch_month);
			if (app_status.sch_month < 10)
				ptr++;
			else
				ptr +=2;
			*(ptr++) = '/';
			sprintf((char*)ptr,"%d",app_status.sch_year);
		}
		else 
		{
			sprintf((char*)ptr,"%d",app_status.sch_month);
			if (app_status.sch_month < 10)
				ptr++;
			else
				ptr +=2;
			*(ptr++) = '/';
			if (app_status.sch_day < 10)
			{
				*ptr = '0';
				ptr++;
				sprintf((char*)ptr,"%d",app_status.sch_day);
				ptr++;
			}
			else
			{
				sprintf((char*)ptr,"%d",app_status.sch_day);
				ptr +=2;
			}
			*(ptr++) = '/';
			sprintf((char*)ptr,"%d",app_status.sch_year);
		}
		ControlSetLabel(BUTTON_TO_DO_VIEW_DATE, text_buffer);
	}
}

/******************************************************************
* Function:	ToDoAlarmSetUpScreen
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoAlarmSetUpScreen()
{
	Control	*ctl_addr;
	BOOLEAN	ctl_enable,	ctl_drawn, ctl_save_behind;
	BOOLEAN	ctl_active,	ctl_visible;
	BYTE	object_type, buffer[20];
	BYTE	*ptr = buffer;
	
	
	if (app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == VOICE_NO_ALARM)
	{
		FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_ALARM_ON);
		FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_VOICE_MEMO);
	}
	else if (app_status.alarm_status == TONE_ALARM)
	{
#ifdef	DEBUG
		printf("\n----> Alarm Set Alarm On 1 <----");
#endif
		FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_ALARM_ON);
		FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_TONE);
	}
	else
	{
		FormSetControlGroupSelection(FORM_ALARM_SETTINGS,PUSHBUTTON_ALARM_OFF);
		/* Disable the VOICE MEMO Push button */
		ControlGetAttributes(PUSHBUTTON_VOICE_MEMO, &ctl_enable, &ctl_drawn, &ctl_save_behind, 
			&ctl_active, &ctl_visible);
		ControlSetAttributes(PUSHBUTTON_VOICE_MEMO, FALSE, ctl_drawn, ctl_save_behind, 
			ctl_active, ctl_visible);
		
		FormGetObjectPointer(PUSHBUTTON_VOICE_MEMO, &object_type, (void **)&ctl_addr);
		((ControlTemplatePushButton *) ((ctl_addr->control_template)))->control_value = FALSE;
		/* Disable the TONE Push button */
		ControlGetAttributes(PUSHBUTTON_TONE, &ctl_enable, &ctl_drawn, &ctl_save_behind, 
			&ctl_active, &ctl_visible);
		ControlSetAttributes(PUSHBUTTON_TONE, FALSE, ctl_drawn, ctl_save_behind, 
			ctl_active, ctl_visible);
		
		FormGetObjectPointer(PUSHBUTTON_TONE, &object_type, (void **)&ctl_addr);
		((ControlTemplatePushButton *) ((ctl_addr->control_template)))->control_value = FALSE;
		/* Disable the Alarm Date button */
		ControlGetAttributes(POPUP_TRIGGER_ALARM_DATE, &ctl_enable, &ctl_drawn, &ctl_save_behind, 
			&ctl_active, &ctl_visible);
		ControlSetAttributes(POPUP_TRIGGER_ALARM_DATE, FALSE, ctl_drawn, ctl_save_behind, 
			ctl_active, ctl_visible);
	}
	
#ifdef	DEBUG
	printf("\n----> Alarm Set Alarm On 1-5 Alarm Status %d <----", app_status.alarm_status);
	printf("\n----> Alarm Set Alarm On 1-6 Alarm Date %d <----", alarm_date);
#endif
	
	if ((app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == TONE_ALARM || app_status.alarm_status == VOICE_NO_ALARM ) && 
		alarm_date != NO_ALARM_DATE )
	{
#ifdef	DEBUG
		printf("\n----> Alarm Set Alarm On 2 <----");
#endif
		
		ToDoPackDueDate(ptr, app_status.alarm_year, app_status.alarm_month, app_status.alarm_day);
		ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
		ControlDrawControl(POPUP_TRIGGER_ALARM_DATE);
	}
	else
	{
#ifdef	DEBUG
		printf("\n----> Alarm Set Alarm On 3 <----");
#endif
		
		strcpy((char *)buffer,TODO_NO_ALARM_DATE);
		ControlSetLabel(POPUP_TRIGGER_ALARM_DATE,buffer);
	}
}

/******************************************************************
* Function:	ToDoChangeUpdateRecord
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoChangeUpdateRecord()
{
	UWORD	rec_num;
	Err	result;
	
	DataRecIDtoNum(tdl_dbid, app_status.rec_id, &rec_num);
	DataOpenRecord(tdl_dbid, rec_num, &app_status.rec_id, NULL);
	/* Write Field 0 of To Do List Record */
#ifdef	SORT_MODIFY
	ToDoUpdateCompleteOrPriorityField(0, app_status.completed_status);
#else
	DataWriteField(tdl_dbid,app_status.rec_id,0,1,&app_status.completed_status);
#endif
	/* Write Field 1 of To Do List Record */
	if (app_status.edit_mode == TO_DO_NEW && alarm_date == NO_ALARM_DATE)
		app_status.alarm_status = NO_ALARM;
	DataWriteField(tdl_dbid,app_status.rec_id,1,1,&app_status.alarm_status);
	/* Write Field 2 of To Do List Record */
#ifdef	SORT_MODIFY
	ToDoUpdateCompleteOrPriorityField(2, app_status.priority_status);
#else
	DataWriteField(tdl_dbid,app_status.rec_id,2,1,&app_status.priority_status);
#endif
	/* Write Field 4 of To Do List Record */
	ToDoDateUpdateRecord(app_status.sch_year, app_status.sch_month, app_status.sch_day, 4);
	/* Write Field 5 of To Do List Record */
	ToDoDateUpdateRecord(app_status.alarm_year, app_status.alarm_month, app_status.alarm_day, 5);
	/* Write Field 6 of To Do List Record */
	if (alarm_settings.recorded == TRUE)
	{
		if (app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == VOICE_NO_ALARM)
			DataWriteField(tdl_dbid, app_status.rec_id, 6, 4, (BYTE*)&alarm_settings.temp_recid);
		else
		{
			DataWriteField(tdl_dbid, app_status.rec_id, 6, 1, (BYTE*)"");
			
			if (DataIsDBOpen(alarm_settings.dbid, NULL, NULL) == FALSE)
				DataOpenDB(alarm_settings.dbid,DB_NO_SORT,OPEN_RW);
			
			result = DataDeleteRecord(alarm_settings.dbid, alarm_settings.temp_recid, FALSE);
		}
		alarm_settings.recorded = FALSE;
	}
	else
	{
		//Bug Fixed 23-Feb-2001
		//----------------------------------------------------------- Modifying Codes
		if (app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == VOICE_NO_ALARM)
			DataWriteField(tdl_dbid, app_status.rec_id, 6, 4, (BYTE*)&alarm_settings.temp_recid);
		else
			DataWriteField(tdl_dbid, app_status.rec_id, 6, 1, (BYTE*)"");
		//----------------------------------------------------------- Modifying Codes
	}
	/* Close Record */
	DataCloseRecord(tdl_dbid,app_status.rec_id);
	/* Set Alarm */
	ToDoSetAllRecordsAlarm(0);
}

/******************************************************************
* Function:	ToDoUpdateCompleteOrPriorityField
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
#ifdef	SORT_MODIFY
void ToDoUpdateCompleteOrPriorityField(USHORT field_num, BYTE org_info)
{
	SHORT	new_year, new_month, new_day, i;
	BYTE	due_date[12];
	BYTE	*ptr = due_date;
	BOOLEAN	add_date;
	
	
	if (detail_date == NO_DUE_DATE && app_status.edit_mode == TO_DO_NEW)
	{
		new_year  = 0;
		new_month = 0;
		new_day   = 0;
		add_date = FALSE;
	}
	else
	{
		new_year  = app_status.sch_year;
		new_month = app_status.sch_month;
		new_day   = app_status.sch_day;
		add_date = TRUE;
	}
	/* Load Complete Status || Priorty Status */
	due_date[0] = org_info;
	ptr++;
	/* Load year to buffer */
	if (add_date == FALSE)
	{
		for (i=0; i<4; i++)
		{
			*ptr = '0';
			ptr++;
		}
	}
	else
	{
		sprintf((char*)ptr,"%d",new_year);
		ptr += 4;
	}
	*(ptr++) = '/';
	/* Load month to buffer */
	if (new_month < 10)
	{
		*ptr = '0';
		ptr++;
		sprintf((char*)ptr,"%d",new_month);
		ptr++;
	}
	else
	{
		sprintf((char*)ptr,"%d",new_month);
		ptr += 2;
	}
	*(ptr++) = '/';
	/* Load day to buffer */
	if (new_day < 10)
	{
		*ptr = '0';
		ptr++;
		sprintf((char*)ptr,"%d",new_day);
	}
	else
		sprintf((char*)ptr,"%d",new_day);
	
	DataWriteField(tdl_dbid,app_status.rec_id,field_num,12,due_date);
}
#endif
/******************************************************************
* Function:	ToDoDateUpdateRecord
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoDateUpdateRecord(SHORT new_year, SHORT new_month, SHORT new_day, USHORT field_num)
{	
	BYTE	schedule_date[11];
	BYTE	*ptr = schedule_date;
	
	
	
	if ((field_num == 4 && detail_date == NO_DUE_DATE && app_status.edit_mode == TO_DO_NEW) ||
		(field_num == 5 && alarm_date == NO_ALARM_DATE && app_status.edit_mode == TO_DO_NEW) )
	{
		new_year  = 0;
		new_month = 0;
		new_day   = 0;
	}
	/* Load year to buffer */
	sprintf((char*)ptr,"%d",new_year);
	ptr += 4;
	*(ptr++) = '/';
	/* Load month to buffer */
	if (new_month < 10)
	{
		*ptr = '0';
		ptr++;
		sprintf((char*)ptr,"%d",new_month);
		ptr++;
	}
	else
	{
		sprintf((char*)ptr,"%d",new_month);
		ptr += 2;
	}
	*(ptr++) = '/';
	/* Load day to buffer */
	if (new_day < 10)
	{
		*ptr = '0';
		ptr++;
		sprintf((char*)ptr,"%d",new_day);
	}
	else
		sprintf((char*)ptr,"%d",new_day);
	
	DataWriteField(tdl_dbid,app_status.rec_id,field_num,(strlen(schedule_date) + 1),schedule_date);
}

/********************************************************
* Function:	ToDoClearFieldBuffer
* Purpose: 	This function is used to clear the field 
*			buffer of the To Do List Application
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoClearFieldBuffer()
{
	if (tdl_field_buffer[0] !=0)
	{
		qfree(tdl_field_buffer[0]);
		tdl_field_buffer[0] = 0;
	}
}

/********************************************************
* Function:	ToDoInitFieldBuffer
* Purpose: 	This function is used to init the field buffer
*			of the To Do List Application
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoInitFieldBuffer()
{
	
	if (tdl_field_buffer[0] !=0)
		qfree(tdl_field_buffer[0]);
	tdl_field_buffer[0] = (BYTE*)qmalloc(sizeof(BYTE));
	strcpy(tdl_field_buffer[0],(BYTE*)(""));
}

/********************************************************
* Function:	ToDoFieldtoFieldBuffer
* Purpose: 	This function is called in order to put the data
*			in the field object to field buffer
* Scope:	application
* Input:	dbid			The ID of the database
*			record_id		The ID of the record that is required to be 
*							put in the field objects
* Output:	None
* Return:	TRUE			Success
*			FALSE			FALSE
* Comment: 	None
*********************************************************/
void ToDoFieldToFieldBuffer()
{
	BYTE *temp, object_type;
	Form *form_addr;
	
	if (tdl_field_buffer[0] != 0)
		qfree(tdl_field_buffer[0]);
	
	if (app_status.edit_mode == TO_DO_NEW)
	{
		if (FormGetObjectPointer(FORM_TO_DO_NEW, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_TO_DO_NEW);
		
		FieldGetTextPointer(FIELD_TO_DO_NEW, &temp);
	}
	else
	{
		if (FormGetObjectPointer(FORM_TO_DO_VIEWING, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_TO_DO_VIEWING);
		
		FieldGetTextPointer(FIELD_TO_DO_VIEWING, &temp);
	}
	
	tdl_field_buffer[0] = (BYTE*)qmalloc((strlen(temp) + 1)*sizeof(BYTE));
	strcpy(tdl_field_buffer[0],temp);
}

/********************************************************
* Function:	ToDoFieldUpdate
* Purpose: 	This function is called in order to save the edited record
*			back into database.
* Scope:	application
* Input:	dbid			The ID of the database
*			record_id		The ID of the record that is required to be 
*							put in the field object
*			new_record		BOOLENA variable to show whether new record or 
*							old record 
* Output:	None
* Return:	TRUE			Success
*			FALSE			FALSE
* Comment: 	None
*********************************************************/
BOOLEAN ToDoFieldUpdateRecord()
{
	UWORD	rec_num;
	BYTE	read_status = FALSE;
	
	
	if (app_status.edit_mode == TO_DO_NEW)
	{	
		DataNewRecord(tdl_dbid,0,TO_DO_LIST_NUM_FIELD,&app_status.rec_id);
		app_status.completed_status = FALSE;
		DataWriteField(tdl_dbid,app_status.rec_id,3,(strlen(tdl_field_buffer[0]) + 1),tdl_field_buffer[0]);
		DataCloseRecord(tdl_dbid,app_status.rec_id);
	}
	else if (app_status.edit_mode == TO_DO_VIEWING)
	{
		if (alarm_settings.recorded == TRUE && (app_status.alarm_status == NO_ALARM || app_status.alarm_status == TONE_ALARM))
		{	
			DataOpenDB(alarm_settings.dbid,DB_NO_SORT,OPEN_RW);
			DataDeleteRecord(alarm_settings.dbid, alarm_settings.temp_recid, FALSE);
			DataCloseDB(alarm_settings.dbid);
		}
		
		DataRecIDtoNum(tdl_dbid, app_status.rec_id, &rec_num);
		DataOpenRecord(tdl_dbid, rec_num, &app_status.rec_id, NULL);
		DataWriteField(tdl_dbid,app_status.rec_id,3,(strlen(tdl_field_buffer[0]) + 1),tdl_field_buffer[0]);
		DataCloseRecord(tdl_dbid,app_status.rec_id);
	}	
	/* Clear the field buffer and the corresponding Field object */
	strcpy(tdl_field_buffer[0],(BYTE*)(""));
	ToDoFieldBufferToField();
	ToDoClearFieldBuffer();
	return TRUE;
}
/********************************************************
* Function:	ToDoFieldBufferToField
* Purpose: 	This function is called to send data from field buffer to 
*			corresponding FIELD objects
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE			success
*			FALSE			error occure
* Comment: 	
*********************************************************/
void ToDoFieldBufferToField()
{	
	if (app_status.edit_mode == TO_DO_NEW)
		FieldSetText(FIELD_TO_DO_NEW, tdl_field_buffer[0]);
	else
		FieldSetText(FIELD_TO_DO_VIEWING, tdl_field_buffer[0]);
}

/********************************************************
* Function:	ToDoRecordToFieldBuffer
* Purpose: 	This function is called in order to store all 
*			data from record to field buffer
* Scope:	application
* Input:	rec_id			The record 
* Output:	None
* Return:	TRUE		Success
*			FALSE		NotHandled
* Comment: 	None
*********************************************************/
void ToDoRecordToFieldBuffer()
{
	UWORD rec_num;
	BYTE *buffer;
	UWORD byte_read;
	
	
	DataRecIDtoNum(tdl_dbid, app_status.rec_id, &rec_num);
	DataOpenRecord(tdl_dbid, rec_num, &app_status.rec_id, NULL);
	/* Get the To Do List Text Body */
	DataGetField(tdl_dbid, app_status.rec_id, 3, &buffer, &byte_read);
	
	if (tdl_field_buffer[0] != 0)
		qfree(tdl_field_buffer[0]);
	
	tdl_field_buffer[0] = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
	strcpy(tdl_field_buffer[0], buffer);
	qfree(buffer);
	
	DataCloseRecord(tdl_dbid, app_status.rec_id);
}

/********************************************************
* Function:	TableGetClickedCell
* Purpose:		To get the row, column & cell number of the
*				particular position
* Scope:		Application
* Input:		table_id			DBID of table object
*				x_coord				pen x-coordinate
*				y_coord				pen y-coordinate
* Output:		row_number			the row number
*				col_number			the column number
*				cell_number			the cell number
* Output:		None
* Return:		TRUE if no error
*				ErrUIResNotFound
* Comment:     None
*********************************************************/
Err ToDoListGetClickedCell(	ObjectID table_id,SHORT x_coord,SHORT y_coord,
						   USHORT *row_number,USHORT *col_number,USHORT *cell_number)
{
	Table	*addr;
	BYTE	object_type;
	USHORT	i,j,temp_height = 0,top_row,count=0,draw_height=0;
	ObjectBounds temp;
	
	if (UISearchForAddress(table_id,&object_type,(void **)&addr) != TRUE) return ERR_UI_RES_NOT_FOUND;
	if (addr->table_attr.table_drawn == FALSE) return FALSE;
	if (addr->table_attr.table_enable == FALSE) return FALSE;
	
	count = (addr->table_top_row_num*addr->table_num_column);
	
	for (i=0; i< (addr->table_num_row-addr->table_top_row_num); i++)
		draw_height += addr->table_row_height[i+addr->table_top_row_num];
	/* If table fully display on screen */
	if (draw_height < addr->bounds.height)
	{
		if (x_coord >= addr->bounds.xcoord && x_coord < addr->bounds.xcoord+addr->bounds.width &&
			y_coord >= addr->bounds.ycoord && y_coord < addr->bounds.ycoord+addr->bounds.height)
		{
			temp.xcoord = addr->bounds.xcoord;
			temp.ycoord = addr->bounds.ycoord;
			
			for (i=addr->table_top_row_num; i< addr->table_num_row; i++)
			{
				for (j=0; j< addr->table_num_column; j++)
				{
					if (x_coord >= temp.xcoord && x_coord <= temp.xcoord+addr->table_column_width[j] &&
						y_coord >= temp.ycoord && y_coord <= temp.ycoord+addr->table_row_height[i])
					{
						*row_number = i;
						*col_number = j;
						*cell_number = count;
						return TRUE;
					}
					temp.xcoord = temp.xcoord+addr->table_column_width[j];
					count++;
				}
				temp.xcoord = addr->bounds.xcoord;
				temp.ycoord = temp.ycoord+addr->table_row_height[i];
			}
		}
		else
			return ERR_UI_INV_INPUT_COORD;
	}
	/* The table cannot fully display on screen */
	else
	{
		/* Get the top row of the display table */
		top_row = addr->table_top_row_num;
		
		for (i=0; i< addr->table_num_row_display; i++)
			temp_height = temp_height+addr->table_row_height[i+top_row];
		/* Pen within the display region */
		if (x_coord >= addr->bounds.xcoord && x_coord < addr->bounds.xcoord+addr->bounds.width &&
			y_coord >= addr->bounds.ycoord && y_coord < addr->bounds.ycoord+temp_height)
		{
			temp.xcoord = addr->bounds.xcoord;
			temp.ycoord = addr->bounds.ycoord;
			
			for (i=addr->table_top_row_num; i< addr->table_num_row; i++)
			{
				for (j=0; j< addr->table_num_column; j++)
				{
					if (x_coord >= temp.xcoord && x_coord <= temp.xcoord+addr->table_column_width[j] &&
						y_coord >= temp.ycoord && y_coord <= temp.ycoord+addr->table_row_height[i])
					{
						*row_number = i;
						*col_number = j;
						*cell_number = count;
						return TRUE;
					}
					count++;
					temp.xcoord = temp.xcoord+addr->table_column_width[j];
				}
				temp.xcoord = addr->bounds.xcoord;
				temp.ycoord = temp.ycoord+addr->table_row_height[i];
			}
		}
		else
			return ERR_UI_INV_INPUT_COORD;
	}
	return FALSE;
}

/******************************************************************
* Function:	ToDoSetOfWeekScreen
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoSetStartOfWeekScreen()
{
	CountrySettings	country;
	BYTE	day_buffer[60];
	
	
	SySetupGetCountrySettings(&country);
	
	if (country.start_of_week == SYSETUP_SUN)
		strcpy(day_buffer,TODOSTR1);
	else
		strcpy(day_buffer,TODOSTR2);
	
	StringSetText(STRING_DATE_SETTINGS,day_buffer);
}

/******************************************************************
* Function:	ToDoDateSettingSetUpScreen
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoDateSettingSetUpScreen()
{	
	BYTE	year_buffer[5], day_buffer[3];
	SHORT	year, month, day, wday, nth_week, num_days, start_cell;
	USHORT	row, col, count=1;
	CountrySettings country;
	
	
	
	year = app_status.sch_year - 2;
	ltoa((long)year, (char *)year_buffer, 10);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
	year++;
	ltoa((long)year, (char *)year_buffer, 10);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
	year++;
	ltoa((long)year, (char *)year_buffer, 10);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
	year++;
	ltoa((long)year, (char *)year_buffer, 10);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
	year++;
	ltoa((long)year, (char *)year_buffer, 10);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
	FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y3);
	/* Set up the specified month */
	month = app_status.sch_month;
	FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_JAN+month-1);
	/* Clear the table */
	day_buffer[0] = 0;
	for (row=0; row<6; row++)
		for (col=0; col<7; col++)
		{
			TableSetItemText(TABLE_DATE_SETTING, row, col, day_buffer);
			TableSetHighlightCell(TABLE_DATE_SETTING, row, col, FALSE);
		}
		/* Set up the days on the specified table */
		day = app_status.sch_day;
		RtcYMDToWday1(app_status.sch_year, app_status.sch_month-1, 1, &wday, &nth_week);
		num_days = RtcGetDaysInMonth(year, month-1);
		
		SySetupGetCountrySettings(&country);
		/* Set up the specified Start of week */
		ToDoSetStartOfWeekScreen();
		/* Find out the day of month */
		start_cell = wday - country.start_of_week;
		if (start_cell < 0)
			start_cell = 7 + start_cell;
		
		for (row=0; row<6; row++)
		{
			for (col=start_cell; col<7; col++)
			{
				if (count > num_days)
					break;
				if (count == day)
					TableSetHighlightCell(TABLE_DATE_SETTING, row, col, TRUE);
				
				ltoa((long)count, (char *)day_buffer, 10);
				TableSetItemText(TABLE_DATE_SETTING, row, col, day_buffer);
				count++;
			}
			start_cell = 0;
		}
		
		DataCloseRecord(tdl_dbid,app_status.rec_id);
}

/******************************************************************
* Function:	ToDoDateSettingYearUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoDateSettingsUpdate()
{	
	CountrySettings country;
	BYTE	/*year_buffer[10],*/ day_buffer[5];
	USHORT	row, col, count=1;
	SHORT	/*result,*/ wday, nth_week, num_days, start_cell;
	SHORT	year, month, day;	
	
	
	if (app_status.edit_mode == TO_DO_LIST || app_status.edit_mode == TO_DO_VIEWING ||
		app_status.edit_mode == TO_DO_DETAILS)
	{
		year = app_status.sch_year;
		month = app_status.sch_month;
		day = app_status.sch_day;
	}
	else if (app_status.edit_mode == TO_DO_ALARM_SETTINGS)
	{
		year = app_status.alarm_year;
		month = app_status.alarm_month;
		day = app_status.alarm_day;
	}
	/* Clear the table */
	day_buffer[0] = 0;
	for (row=0; row<6; row++)
		for (col=0; col<7; col++)
		{
			TableSetItemText(TABLE_DATE_SETTING, row, col, day_buffer);
			TableSetHighlightCell(TABLE_DATE_SETTING, row, col, FALSE);
		}
		/* Set up the days on the specified table */
		RtcYMDToWday1(year, month-1, 1, &wday, &nth_week);
		num_days = RtcGetDaysInMonth(year, month-1);
		SySetupGetCountrySettings(&country);
		/* Set up the specified start of week */
		ToDoSetStartOfWeekScreen();
		/* Find out the day of month */
		start_cell = wday - country.start_of_week;
		if (start_cell < 0)
			start_cell = 7 + start_cell;
		
		for (row=0; row<6; row++)
		{
			for (col=start_cell; col<7; col++)
			{
				if (count > num_days)
					break;
				if (count == day)
					TableSetHighlightCell(TABLE_DATE_SETTING, row, col, TRUE);
				
				ltoa((long)count, (char *)day_buffer, 10);
				TableSetItemText(TABLE_DATE_SETTING, row, col, day_buffer);
				count++;
			}
			start_cell = 0;
		}
		DataCloseRecord(tdl_dbid,app_status.rec_id);
		
		if (app_status.edit_mode == TO_DO_LIST || app_status.edit_mode == TO_DO_VIEWING ||
			app_status.edit_mode == TO_DO_DETAILS)
		{
			app_status.sch_year = year;
			app_status.sch_month = month;
			app_status.sch_day = day;
		}
		else if (app_status.edit_mode = TO_DO_ALARM_SETTINGS)
		{
			app_status.alarm_year = year;
			app_status.alarm_month = month;
			app_status.alarm_day = day;
		}
		TableEraseTable(TABLE_DATE_SETTING);
		TableDrawTable(TABLE_DATE_SETTING);
}

/******************************************************************
* Function:	AnnYearSettingUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoYearSettingUpdate(SHORT *input_year)
{
	BYTE	year_buffer[10];
	
	
	/* Set up the specified year */
    year_buffer[0] = 0;
	/* Clear all push buttons */
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
	ControlDrawControl(BUTTON_DISABLE);
	
	if (app_status.edit_mode == TO_DO_ALARM_SETTINGS)
		FormSetControlGroupSelection(FORM_ALARM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y3);
	else
		FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y3);
	
	// -------------------------------------------------------------------
	// 28072000
	if (*input_year > 2097)
	{
		sprintf((char*)year_buffer, "%s", "2095");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
		
		sprintf((char*)year_buffer, "%s", "2096");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
		
		sprintf((char*)year_buffer, "%s", "2097");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
		
		sprintf((char*)year_buffer, "%s", "2098");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
		if (*input_year == 2098)
		{
			if (app_status.edit_mode == TO_DO_ALARM_SETTINGS)
				FormSetControlGroupSelection(FORM_ALARM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y4);
			else
				FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y4);
		}
		
		sprintf((char*)year_buffer, "%s", "2099");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
		if (*input_year == 2099)
		{
			if (app_status.edit_mode == TO_DO_ALARM_SETTINGS)
				FormSetControlGroupSelection(FORM_ALARM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y5);
			else
				FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y5);
		}
	}
	else if (*input_year < 1907)
	{
		sprintf((char*)year_buffer, "%s", "1905");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
		if (*input_year == 1905)
		{
			if (app_status.edit_mode == TO_DO_ALARM_SETTINGS)
				FormSetControlGroupSelection(FORM_ALARM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y1);
			else
				FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y1);
		}
		
		sprintf((char*)year_buffer, "%s", "1906");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
		if (*input_year == 1906)
		{
			if (app_status.edit_mode == TO_DO_ALARM_SETTINGS)
				FormSetControlGroupSelection(FORM_ALARM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y2);
			else
				FormSetControlGroupSelection(FORM_DATE_SETTINGS,PUSHBUTTON_DATE_SETTING_Y2);
		}
		
		sprintf((char*)year_buffer, "%s", "1907");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
		
		sprintf((char*)year_buffer, "%s", "1908");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
		
		sprintf((char*)year_buffer, "%s", "1909");
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
	}
	else
	{
		sprintf((char*)year_buffer,"%d", *input_year - 2);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y1);
		
		sprintf((char*)year_buffer,"%d", *input_year - 1);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y2);
		
		sprintf((char*)year_buffer,"%d", *input_year);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y3);
		
		sprintf((char*)year_buffer,"%d", *input_year + 1);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y4);
		
		sprintf((char*)year_buffer,"%d", *input_year + 2);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y5);
	}
	// -------------------------------------------------------------------
}

/******************************************************************
* Function:	ToDoRecordToVariable
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoRecordToVariable()
{
	UWORD	rec_num, byte_read;
	BYTE	*buffer;
	BYTE	year_buffer[5], month_buffer[3], day_buffer[3];
	
	DataRecIDtoNum(tdl_dbid, app_status.rec_id, &rec_num);
	DataOpenRecord(tdl_dbid, rec_num, &app_status.rec_id, NULL);
	/* Get Field 0 of To Do List Record */
	DataGetField(tdl_dbid, app_status.rec_id, 0, &buffer, &byte_read);
	if (buffer[0] == COMPLETED)
		app_status.completed_status = COMPLETED;
	else
		app_status.completed_status = INCOMPLETED;
	qfree(buffer);
	/* Get Field 1 of To Do List Record */
	DataGetField(tdl_dbid, app_status.rec_id, 1, &buffer, &byte_read);
	if (*buffer == TONE_ALARM)
		app_status.alarm_status = TONE_ALARM;
	else if (*buffer == VOICE_ALARM)
		app_status.alarm_status = VOICE_ALARM;
	else if (*buffer == VOICE_NO_ALARM)
		app_status.alarm_status = VOICE_NO_ALARM;
	else
		app_status.alarm_status = NO_ALARM;
	qfree(buffer);
	/* Get Field 2 of To Do List Record */
	DataGetField(tdl_dbid, app_status.rec_id, 2, &buffer, &byte_read);
	app_status.priority_status = buffer[0];
	qfree(buffer);
	/* Get Field 3 of To Do List Record */
	DataGetField(tdl_dbid, app_status.rec_id, 3, &buffer, &byte_read);
	
	if (tdl_field_buffer[0] != 0)
		qfree(tdl_field_buffer[0]);
	
	tdl_field_buffer[0] = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
	strcpy(tdl_field_buffer[0], buffer);
	qfree(buffer);
	/* Get Field 4 of To Do List Record */
	DataGetField(tdl_dbid, app_status.rec_id, 4, &buffer, &byte_read);
	/* Set up the specified year */
	year_buffer[0] = buffer[0];
	year_buffer[1] = buffer[1];
	year_buffer[2] = buffer[2];
	year_buffer[3] = buffer[3];
	year_buffer[4] = 0;
	app_status.sch_year = (SHORT)atol((const char *)year_buffer);
	/* Set up the specified month */
	month_buffer[0] = buffer[5];
	month_buffer[1] = buffer[6];
	month_buffer[2] = 0;
	app_status.sch_month = (SHORT)atol((const char *)month_buffer);
	/* Set up the specified day */
	day_buffer[0] = buffer[8];
	day_buffer[1] = buffer[9];
	day_buffer[2] = 0;
	app_status.sch_day = (SHORT)atol((const char *)day_buffer);
	qfree(buffer);
	/* Get Field 5 of To Do List Record */
	DataGetField(tdl_dbid, app_status.rec_id, 5, &buffer, &byte_read);
	/* Set up the specified alarm */
	year_buffer[0] = buffer[0];
	year_buffer[1] = buffer[1];
	year_buffer[2] = buffer[2];
	year_buffer[3] = buffer[3];
	year_buffer[4] = 0;
	app_status.alarm_year = (SHORT)atol((const char *)year_buffer);
	/* Set up the specified alarm */
	month_buffer[0] = buffer[5];
	month_buffer[1] = buffer[6];
	month_buffer[2] = 0;
	app_status.alarm_month = (SHORT)atol((const char *)month_buffer);
	/* Set up the specified alarm */
	day_buffer[0] = buffer[8];
	day_buffer[1] = buffer[9];
	day_buffer[2] = 0;
	app_status.alarm_day = (SHORT)atol((const char *)day_buffer);
	qfree(buffer);
	/* Save application status */
	chk_status.completed_status = app_status.completed_status;
	chk_status.alarm_status = app_status.alarm_status;	
	chk_status.priority_status = app_status.priority_status;
	chk_status.sch_year		= app_status.sch_year;
	chk_status.sch_month	= app_status.sch_month;
	chk_status.sch_day		= app_status.sch_day;
	chk_status.alarm_year	= app_status.alarm_year;
	chk_status.alarm_month	= app_status.alarm_month;
	chk_status.alarm_day	= app_status.alarm_day;
	chk_status.field_change = FALSE;
	
	if (app_status.alarm_status == VOICE_ALARM || app_status.alarm_status == VOICE_NO_ALARM)
	{
		DataGetField(tdl_dbid, app_status.rec_id, 6, &buffer, &byte_read);
		app_status.sound_rec_id = *(RecordID *)buffer;
	}
	else
		app_status.sound_rec_id = 0;
	
	DataCloseRecord(tdl_dbid,app_status.rec_id);
}

/******************************************************************
* Function:	ToDoPackDueDate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoPackDueDate(BYTE *ptr, SHORT year, SHORT month, SHORT day)
{
	SHORT	wday, nth_week;
	SHORT	wlen;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	RtcYMDToWday1(year, month-1, day, &wday, &nth_week);
	
	if (wday == SYSETUP_SUN)
	{
		strcpy(ptr,TODOSUN);
		wlen = strlen(TODOSUN);
	}
	else if (wday == SYSETUP_MON)
	{
		strcpy(ptr,TODOMON);
		wlen = strlen(TODOMON);
	}
	else if (wday == SYSETUP_TUE)
	{
		strcpy(ptr,TODOTUE);
		wlen = strlen(TODOTUE);
	}
	else if (wday == SYSETUP_WED)
	{
		strcpy(ptr,TODOWED);
		wlen = strlen(TODOWED);
	}
	else if (wday == SYSETUP_THU)
	{
		strcpy(ptr,TODOTHU);
		wlen = strlen(TODOTHU);
	}
	else if (wday == SYSETUP_FRI)
	{
		strcpy(ptr,TODOFRI);
		wlen = strlen(TODOFRI);
	}
	else if (wday == SYSETUP_SAT)
	{
		strcpy(ptr,TODOSAT);
		wlen = strlen(TODOSAT);
	}
	
	if (country.date_fmt == SYSETUP_MDY)
	{
		if (month == 1)
		{
			strcat((char*)ptr,TODOJAN);
			wlen += strlen(TODOJAN);
		}
		else if (month == 2)
		{
			strcat((char*)ptr,TODOFEB);
			wlen += strlen(TODOFEB);
		}
		else if (month == 3)
		{
			strcat((char*)ptr,TODOMAR);
			wlen += strlen(TODOJAN);
		}
		else if (month == 4)
		{
			strcat((char*)ptr,TODOAPR);
			wlen += strlen(TODOAPR);
		}
		else if (month == 5)
		{
			strcat((char*)ptr,TODOMAY);
			wlen += strlen(TODOMAY);
		}
		else if (month == 6)
		{
			strcat((char*)ptr,TODOJUN);
			wlen += strlen(TODOJUN);
		}
		else if (month == 7)
		{
			strcat((char*)ptr,TODOJUL);
			wlen += strlen(TODOJUL);
		}
		else if (month == 8)
		{
			strcat((char*)ptr,TODOAUG);
			wlen += strlen(TODOAUG);
		}
		else if (month == 9)
		{
			strcat((char*)ptr,TODOSEP);
			wlen += strlen(TODOSEP);
		}
		else if (month == 10)
		{
			strcat((char*)ptr,TODOOCT);
			wlen += strlen(TODOOCT);
		}
		else if (month == 11)
		{
			strcat((char*)ptr,TODONOV);
			wlen += strlen(TODONOV);
		}
		else if (month == 12)
		{
			strcat((char*)ptr,TODODEC);
			wlen += strlen(TODODEC);
		}
		
		ptr += wlen;
		if (day <10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",day);
			ptr += 2;
		}					
		*(ptr++) = ' ';
		sprintf((char*)ptr,"%d",year);
	}
	else if (country.date_fmt == SYSETUP_DMY)
	{
		ptr += wlen;
		if (day <10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
			ptr++;
		}
		else
		{
			sprintf((char*)ptr,"%d",day);
			ptr += 2;
		}
		*(ptr++) = ' ';
		
		wlen = 0;
		switch(month)
		{
		case 1:
			sprintf((char*)ptr, "%s", TODOJAN);
			wlen = strlen(TODOJAN);
			break;
		case 2:
			sprintf((char*)ptr, "%s", TODOFEB);
			wlen = strlen(TODOFEB);
			break;
		case 3:
			sprintf((char*)ptr, "%s", TODOMAR);
			wlen = strlen(TODOMAR);
			break;
		case 4:
			sprintf((char*)ptr, "%s", TODOAPR);
			wlen = strlen(TODOAPR);
			break;
		case 5:
			sprintf((char*)ptr, "%s", TODOMAY);
			wlen = strlen(TODOMAY);
			break;
		case 6:
			sprintf((char*)ptr, "%s", TODOJUN);
			wlen = strlen(TODOJUN);
			break;
		case 7:
			sprintf((char*)ptr, "%s", TODOJUL);
			wlen = strlen(TODOJUL);
			break;
		case 8:
			sprintf((char*)ptr, "%s", TODOAUG);
			wlen = strlen(TODOAUG);
			break;
		case 9:
			sprintf((char*)ptr, "%s", TODOSEP);
			wlen = strlen(TODOSEP);
			break;
		case 10:
			sprintf((char*)ptr, "%s", TODOOCT);
			wlen = strlen(TODOOCT);
			break;
		case 11:
			sprintf((char*)ptr, "%s", TODONOV);
			wlen = strlen(TODONOV);
			break;
		case 12:
			sprintf((char*)ptr, "%s", TODODEC);
			wlen = strlen(TODODEC);
			break;
		}
		ptr += wlen;
		sprintf((char*)ptr, "%d", year);
	}
	else
	{
		ptr += wlen;
		sprintf((char*)ptr, "%d", year);
		ptr += 4;
		*(ptr++) = ' ';
		
		wlen = 0;
		switch(month)
		{
		case 1:
			sprintf((char*)ptr, "%s", TODOJAN);
			wlen = strlen(TODOJAN);
			break;
		case 2:
			sprintf((char*)ptr, "%s", TODOFEB);
			wlen = strlen(TODOFEB);
			break;
		case 3:
			sprintf((char*)ptr, "%s", TODOMAR);
			wlen = strlen(TODOMAR);
			break;
		case 4:
			sprintf((char*)ptr, "%s", TODOAPR);
			wlen = strlen(TODOAPR);
			break;
		case 5:
			sprintf((char*)ptr, "%s", TODOMAY);
			wlen = strlen(TODOMAY);
			break;
		case 6:
			sprintf((char*)ptr, "%s", TODOJUN);
			wlen = strlen(TODOJUN);
			break;
		case 7:
			sprintf((char*)ptr, "%s", TODOJUL);
			wlen = strlen(TODOJUL);
			break;
		case 8:
			sprintf((char*)ptr, "%s", TODOAUG);
			wlen = strlen(TODOAUG);
			break;
		case 9:
			sprintf((char*)ptr, "%s", TODOSEP);
			wlen = strlen(TODOSEP);
			break;
		case 10:
			sprintf((char*)ptr, "%s", TODOOCT);
			wlen = strlen(TODOOCT);
			break;
		case 11:
			sprintf((char*)ptr, "%s", TODONOV);
			wlen = strlen(TODONOV);
			break;
		case 12:
			sprintf((char*)ptr, "%s", TODODEC);
			wlen = strlen(TODODEC);
			break;
		}
		ptr += wlen;
		if (day <10)
		{
			*ptr = '0';
			ptr++;
			sprintf((char*)ptr,"%d",day);
		}
		else
			sprintf((char*)ptr,"%d",day);
	}
}

/********************************************************
* Function:	ToDoMenuSelectedAction
* Purpose: 	This fucntion is to do an action when 
*			an item in a menu is selected
* Scope:	application/internal
* Input:	item_num	The item number of the selectd menu item
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoMenuSelectedAction(USHORT item_num)
{
	ObjectID active_form_id;
	ObjectID active_object_id;
	BYTE object_type;
	void *addr;
	
	
	FormGetActiveFormID(&active_form_id);
	FormGetActiveObject(active_form_id, &active_object_id);
	if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) == FALSE)
		return;
	
	switch(item_num)
	{
	case	MENU_ITEM_COPY:
		KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_CUT:
		KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_PASTE:
		KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_UNDO:
		if (UIGetUndoStatus() != UNDO_EMPTY)
			KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_ZOOM:
		ToDoListChangeFont();
		break;
		
	default: break;
	}
}

/********************************************************
* Function:	ToDoMenuSelectedAction
* Purpose: 	This fucntion is to do an action when 
*			an item in a menu is selected
* Scope:	application/internal
* Input:	item_num	The item number of the selectd menu item
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
BOOLEAN ToDoViewingSelectedLargeFontOnly()
{
	BYTE	original_font;
	
	
	FieldGetFont(FIELD_TO_DO_VIEWING, &original_font);
	
	switch (original_font)
	{
	case	SMALL_FONT:
		MenuDeleteItem(TO_DO_LIST_MENU, 0);
		MenuInsertItem(TO_DO_LIST_MENU, 0, TODOSFONT);
		original_font = MEDIUM_FONT;
		break;
		
	case	MEDIUM_FONT:
		MenuDeleteItem(TO_DO_LIST_MENU, 0);
		MenuInsertItem(TO_DO_LIST_MENU, 0, TODOLFONT);
		original_font = SMALL_FONT;
		break;
		
	default: 
		return FALSE;
	}
	
	FieldSetFont(FIELD_TO_DO_VIEWING, original_font);
	FieldSetFont(FIELD_TO_DO_NEW, original_font);
	table_font = original_font;
	
	if (show_line == TRUE)
		FieldSetInsertPointOn(FIELD_TO_DO_VIEWING);
	else
		FieldSetInsertPointOff(FIELD_TO_DO_VIEWING);
	
	ToDoEditSetField(FORM_TO_DO_VIEWING, FIELD_TO_DO_VIEWING);
	FieldEraseField(FIELD_TO_DO_VIEWING);
	FieldDrawField(FIELD_TO_DO_VIEWING);
	/* Field update scrollbar */
	ToDoFieldSetScrollbar(FIELD_TO_DO_VIEWING, SCROLLBAR_TO_DO_VIEWING);
	return	TRUE;
}

/********************************************************
* Function:	ToDoListChangeFont
* Purpose: 	This function is called in order to change the font size fo the 
*			font in each field object
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Success
*			FALSE		NotHandled
* Comment: 	None
*********************************************************/
BOOLEAN ToDoListChangeFont()
{
	ObjectID	fld_id, scrollbar_id, form_id;	
	BYTE		original_font;
	BYTE		object_type;
	Field		*fld_addr;
	
	
	if (app_status.edit_mode == TO_DO_VIEWING)
	{
		FormGetObjectPointer(FIELD_TO_DO_VIEWING, &object_type, (void **)&fld_addr);
		FieldGetFont(FIELD_TO_DO_VIEWING, &original_font);
		scrollbar_id = SCROLLBAR_TO_DO_VIEWING;
		fld_id = FIELD_TO_DO_VIEWING;
		form_id = FORM_TO_DO_VIEWING;
	}
	else 
	{
		FormGetObjectPointer(FIELD_TO_DO_NEW, &object_type, (void **)&fld_addr);
		FieldGetFont(FIELD_TO_DO_NEW, &original_font);
		scrollbar_id = SCROLLBAR_TO_DO_NEW;
		fld_id = FIELD_TO_DO_NEW;
	}
	
	switch (original_font)
	{
	case	SMALL_FONT:
		MenuDeleteItem(TO_DO_LIST_MENU, 4);
		MenuInsertItem(TO_DO_LIST_MENU, 4, TODOSFONT);
		original_font = MEDIUM_FONT;
		break;
		
	case	MEDIUM_FONT:
		MenuDeleteItem(TO_DO_LIST_MENU, 4);
		MenuInsertItem(TO_DO_LIST_MENU, 4, TODOLFONT);
		original_font = SMALL_FONT;
		break;
		
	default: 
		return FALSE;
	}
	
	FieldSetFont(FIELD_TO_DO_VIEWING, original_font);
	FieldSetFont(FIELD_TO_DO_NEW, original_font);
	table_font = original_font;
	
	if (show_line == TRUE)
	{		
		if (fld_addr->field_attr.field_highlight == TRUE && 
			fld_addr->field_attr.field_insert_pt_visible == FALSE)
			FieldSetInsertPointOff(fld_id);
		else
			FieldSetInsertPointOn(fld_id);
	}
	else
		FieldSetInsertPointOff(fld_id);
	
	ToDoEditSetField(form_id, fld_id);
	FieldEraseField(fld_id);
	FieldDrawField(fld_id);
	/* Field update scrollbar */
	ToDoFieldSetScrollbar(fld_id, scrollbar_id);
	
	return TRUE;
}

/******************************************************************
* Function:	ToDoScrollbarSetReplayVoice
* Purpose: 	
* Scope:	application
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
void ToDoScrollbarSetReplayVoice(EvtType *Event)
{
	WORD	max,min,current_value,pagesize;
	WORD	scroll_total_lines;
#ifdef PR31700
	SoundSettings sound;
#endif
	
	ScrollbarGetScrollbar(SCROLLBAR_REPLAY_VOICE, &current_value, &max, &min, &pagesize, &scroll_total_lines);
	ScrollbarSetScrollbar(SCROLLBAR_REPLAY_VOICE, Event->para2, max, min, pagesize, scroll_total_lines);
	ScrollbarDrawScrollbar(SCROLLBAR_REPLAY_VOICE);
#ifdef PR31700
	SySetupGetSoundSettings(&sound);
	SySetupScrollbarSetVolSettings(sound.vol_min, sound.vol_max, Event->para2);
#endif
}

/********************************************************
* Function:	SchedulerDayViewPurge
* Purpose: 	This function is called to handle the clicking of button
purge
* Scope:		application/internal
* Input:		vt					The pointer to virtual table object				
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ToDoPurgeRecord()
{
	RecordID	rec_id;
	UWORD		total_num_rec, rec_num=0;
	BOOLEAN		control_value;
	
	DataCloseDB(tdl_dbid);
	DataOpenDB(tdl_dbid, 4, OPEN_RW);
	DataTotalRecord(tdl_dbid, &total_num_rec);
	
	if (total_num_rec != 0)
	{
		while(rec_num < total_num_rec)
		{
			DataNumtoRecID(tdl_dbid, rec_num, &rec_id);
			DataOpenRecord(tdl_dbid, rec_num, &rec_id, NULL);
			if (ToDoCompareScheduleDay(tdl_dbid, rec_id, TRUE) == TRUE)
			{
				FormGetControlValue(CHECKBOX_TO_DO_PURGE, &control_value);
				DataCloseRecord(tdl_dbid, rec_id);
				DataDeleteRecord(tdl_dbid, rec_id, control_value);
				total_num_rec--;
			}
			else
				rec_num++;
		}
		ToDoRecordToTable(tdl_dbid, app_status.new_sort_mode);
	}
}

/********************************************************
* Function:	ToDoCheckAnyChange
* Purpose: 	This function is called to check any entry change
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Updated
*			FALSE		No change
* Comment: 	None
**********************************************************/
BOOLEAN	ToDoCheckAnyChange ()
{
	if ((chk_status.completed_status != app_status.completed_status) ||
		(chk_status.alarm_status != app_status.alarm_status) ||
		(chk_status.priority_status != app_status.priority_status) ||
		(chk_status.sch_year != app_status.sch_year) ||
		(chk_status.sch_month != app_status.sch_month) ||
		(chk_status.sch_day != app_status.sch_day) ||
		(chk_status.alarm_year != app_status.alarm_year) ||
		(chk_status.alarm_month	!= app_status.alarm_month) ||
		(chk_status.alarm_day != app_status.alarm_day) ||
		(chk_status.field_change != FALSE) ||
		(alarm_settings.recorded == TRUE))
		return TRUE;
	else
		return FALSE;
}

/********************************************************
* Function:	ToDoNewSetUpVariable
* Purpose: 	This function is called to set variable for 
*			New Screen
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE		Updated
*			FALSE		No change
* Comment: 	None
**********************************************************/
void ToDoNewSetUpVariable()
{
	RTM	time;
	BYTE	temp_buffer[15];
	BYTE	object_type;
	Field	*field_addr;
	
	
	RtcGetTime(&time);
	app_status.sch_year = time.year;
	app_status.sch_month = time.mon + 1;
	app_status.sch_day = time.mday;
	strcpy(temp_buffer,TODOTODAY);
	
	ControlSetLabel(POPUP_TRIGGER_DETAILS_DATE,temp_buffer);
	
	alarm_settings.recorded = FALSE;
	app_status.alarm_status = NO_ALARM;
	app_status.priority_status = 5;
	
	chk_status.new_entry_hit = FALSE;
	
	detail_date = TODAY;
	alarm_date = NO_ALARM_DATE;
	
	FieldSetFont(FIELD_TO_DO_NEW, table_font);
	FieldSetHighlightSelection(FIELD_TO_DO_NEW, 0, 0);
	FormGetObjectPointer(FIELD_TO_DO_NEW, &object_type, (void **)&field_addr);
	field_addr->field_attr.field_highlight = FALSE;
}

/********************************************************
* Function:	ToDoListTableSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:	application
* Input:	BYTE				the starting_char
* Output:	None
* Return:	TRUE		scrollbar is erased
*			FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
*			If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN ToDoListTableSetScrollbar()
{
	WORD temp_value, max_value, min_value, pagesize, total_num_rows;
	
	ScrollbarGetScrollbar(SCROLLBAR_TO_DO_LIST, &temp_value, &max_value, &min_value, &pagesize, &total_num_rows);
	
	if (to_do_list.total_num_rows > to_do_list.num_rows_displayed)
		ScrollbarSetScrollbarVisible(SCROLLBAR_TO_DO_LIST,TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_TO_DO_LIST,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_TO_DO_LIST);
		return FALSE;
	}
	ScrollbarDrawScrollbar(SCROLLBAR_TO_DO_LIST);
	return TRUE;
}

/******************************************************************
* Function:	AnnYearSettingUpdate
* Purpose: 	
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN ToDoYearShiftUpdate(BOOLEAN shift)
{
	BYTE	year_buffer[10], *year_label;
	USHORT	input_year;
	
	ControlGetLabel(PUSHBUTTON_DATE_SETTING_Y1, &year_label);
	input_year = (USHORT)atol((const char *)year_label);
	
	// ===================================================================
	// modified at 28072000
	/* Set range from 1905 ~ 2095 */
	if((input_year < 1905 && shift == BACKWARD) || (input_year + 5 > 2099 && shift == FORWARD))
		return FALSE;
	if (input_year > 2090 && shift == FORWARD)
		input_year = 2090;
	
	if (input_year < 1910 && shift == BACKWARD)
		input_year = 1910;
	// ===================================================================
	
	/* Set up the specified year */
    year_buffer[0] = 0;
	/* Clear all push buttons */
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
	ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
	ControlDrawControl(BUTTON_DISABLE);
	
	if (shift == FORWARD)
	{
		sprintf((char*)year_buffer,"%d", input_year + 5);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y1);
		
		sprintf((char*)year_buffer,"%d", input_year + 6);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y2);
		
		sprintf((char*)year_buffer,"%d", input_year + 7);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y3);
		
		sprintf((char*)year_buffer,"%d", input_year + 8);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y4);
		
		sprintf((char*)year_buffer,"%d", input_year + 9);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y5);	
	}
	else
	{
		sprintf((char*)year_buffer,"%d", input_year - 5);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y1, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y1);
		
		sprintf((char*)year_buffer,"%d", input_year - 4);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y2, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y2);
		
		sprintf((char*)year_buffer,"%d", input_year - 3);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y3, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y3);
		
		sprintf((char*)year_buffer,"%d", input_year - 2);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y4, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y4);
		
		sprintf((char*)year_buffer,"%d", input_year - 1);
		ControlSetLabel(PUSHBUTTON_DATE_SETTING_Y5, year_buffer);
		ControlDrawControl(PUSHBUTTON_DATE_SETTING_Y5);	
	}
	return TRUE;
}

/********************************************************
* Function:	ToDoSetTableFont
* Purpose: 	This fucntion is to do an action when 
*			an item in a menu is selected
* Scope:	application/internal
* Input:	item_num	The item number of the selectd menu item
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoSetTableFont()
{
	BYTE		object_type, font_height;
	USHORT		row_number;
	String		*string_addr;
	Scrollbar	*scroll_addr;
	
				
	if (table_font == MEDIUM_FONT)
	{
		FormGetObjectPointer(TABLE_FIRST_STRING, &object_type, (void **)&string_addr);
		if (string_addr->text_font == MEDIUM_FONT) return;
		MenuDeleteItem(MENU_CHANGE_FONT, 0);
		MenuInsertItem(MENU_CHANGE_FONT, 0, TODOSFONT);
		font_height = SysGetFontHeight(MEDIUM_FONT);
		
		for (row_number =0; row_number < TO_DO_LIST_LFONT_NUM_OF_ROW; row_number++)
			TableSetRowHeight(TABLE_TO_DO_LIST, row_number, font_height+3);
		
		TableSetColumnWidth(TABLE_TO_DO_LIST, 3, TO_DO_LIST_LCOLUMN);
		FormGetObjectPointer(SCROLLBAR_TO_DO_LIST, &object_type, (void**)&scroll_addr);
		scroll_addr->scrollbar_pagesize = TO_DO_LIST_LFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_draw_pagesize = TO_DO_LIST_LFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_total_num_lines = to_do_list.total_num_rows;
		scroll_addr->scrollbar_value = to_do_list.top_row_num;
		scroll_addr->scrollbar_max = scroll_addr->scrollbar_total_num_lines - scroll_addr->scrollbar_pagesize;
	}
	else
	{	
		FormGetObjectPointer(TABLE_FIRST_STRING, &object_type, (void **)&string_addr);
		if (string_addr->text_font == SMALL_FONT) return;
		MenuDeleteItem(MENU_CHANGE_FONT, 0);
		MenuInsertItem(MENU_CHANGE_FONT, 0, TODOLFONT);
		font_height = SysGetFontHeight(SMALL_FONT);
		
		for (row_number =0; row_number < TO_DO_LIST_SFONT_NUM_OF_ROW; row_number++)
			TableSetRowHeight(TABLE_TO_DO_LIST, row_number, font_height+1);
		TableSetColumnWidth(TABLE_TO_DO_LIST, 3, TO_DO_LIST_SCOLUMN);
		FormGetObjectPointer(SCROLLBAR_TO_DO_LIST, &object_type, (void**)&scroll_addr);
		scroll_addr->scrollbar_pagesize = TO_DO_LIST_SFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_draw_pagesize = TO_DO_LIST_SFONT_NUM_OF_ROW;
		scroll_addr->scrollbar_total_num_lines = to_do_list.total_num_rows;
		scroll_addr->scrollbar_value = to_do_list.top_row_num;
		scroll_addr->scrollbar_max = scroll_addr->scrollbar_total_num_lines - scroll_addr->scrollbar_pagesize;
		
		if (scroll_addr->scrollbar_value < (TO_DO_LIST_SFONT_NUM_OF_ROW - TO_DO_LIST_LFONT_NUM_OF_ROW))
			to_do_list.top_row_num = 0;
		else if (scroll_addr->scrollbar_value == to_do_list.total_num_rows - to_do_list.num_rows_displayed) /* Last row */
			to_do_list.top_row_num = scroll_addr->scrollbar_value - (TO_DO_LIST_SFONT_NUM_OF_ROW - TO_DO_LIST_LFONT_NUM_OF_ROW);
		else
			to_do_list.top_row_num = scroll_addr->scrollbar_value - (TO_DO_LIST_SFONT_NUM_OF_ROW - TO_DO_LIST_LFONT_NUM_OF_ROW -1);
	}
}

/********************************************************
* Function:	ToDoSoundRecordStart
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
BOOLEAN ToDoSoundRecordStart()
{
	Bitmap	*bitmap_addr;
	BYTE	object_type;
	UWORD	field_size;
	
#ifdef	PR31700
	if (CheckBatteryLow() == 1)
	{
		no_bat_cause = FORM_RECORD_VOICE;
		/* Force to Tone Alarm */
		app_status.alarm_status = TONE_ALARM;
		FormPopupForm(FORM_TO_DO_NO_BAT);
		return FALSE;
	}
	
	InlaySetEnableStatus(FALSE);
	AlarmMgrEnable(FALSE);
	SystemSetMappedHardwareKeyStatus(FALSE);
	BatteryWarningSetEnableStatus(FALSE);
#endif
	no_bat_cause = 0;
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_REC, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
	bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
	BitmapEraseBitmap(BITMAP_REPLAY_VOICE_REC);
	
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
	bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
	BitmapDrawBitmap(BITMAP_REPLAY_VOICE_PAUSE);
	/* Delete the orginal sound track */
	if (pressed_object1 == FORM_TO_DO_VIEWING && alarm_settings.recorded == FALSE && 
		alarm_settings.temp_alarm_status != VOICE_ALARM)
	{
		DataFieldSize(alarm_settings.dbid, app_status.sound_rec_id, 0, &field_size);
		
		if (field_size >= 0)
			DataDeleteRecord(alarm_settings.dbid, app_status.sound_rec_id, FALSE);
	}
	
	if (alarm_settings.rec_stop == TRUE)
	{
		if (alarm_settings.recorded == TRUE)
			DataDeleteRecord(alarm_settings.dbid, alarm_settings.temp_recid, FALSE);
		
		DataNewRecord(alarm_settings.dbid, 0x00, SOUND_NUM_FIELD, &alarm_settings.temp_recid);
		alarm_settings.rec_stop = FALSE;
		alarm_settings.recorded = TRUE;
#ifdef PR31700
		SndRec(alarm_settings.dbid, alarm_settings.temp_recid, 0);
#endif
		return TRUE;
	}
	else
	{
#ifdef PR31700
		SndRERec(alarm_settings.dbid, alarm_settings.temp_recid, 0);
#endif
		return TRUE;
	}
}

/********************************************************
* Function:	ToDoSoundRecord
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoSoundRecordStop()
{
	Bitmap	*bitmap_addr;
	BYTE	object_type;
	
	/* Init scrollbar value */
	time_count = 0;
	
	alarm_settings.rec_stop = TRUE;
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
	bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
	BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
	
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_REC, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
	bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
	BitmapDrawBitmap(BITMAP_REPLAY_VOICE_REC);
#ifdef PR31700
	SndStop();
#endif
	DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
	return;
}

/********************************************************
* Function:	ToDoSoundReplayStart
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
BOOLEAN ToDoSoundReplayStart()
{
	BYTE		object_type;
	Bitmap		*bitmap_addr;
	UWORD		rec_num;
	
#ifdef PR31700
	if (CheckBatteryLow() == 1)
	{
		no_bat_cause = FORM_REPLAY_VOICE;
		FormPopupForm(FORM_TO_DO_NO_BAT);
		return	FALSE;
	}
	
	InlaySetEnableStatus(FALSE);
	AlarmMgrEnable(FALSE);
	SystemSetMappedHardwareKeyStatus(FALSE);
	BatteryWarningSetEnableStatus(FALSE);
#endif
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_PLAY, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
	bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
	BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PLAY);
	
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
	bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
	BitmapDrawBitmap(BITMAP_REPLAY_VOICE_PAUSE);
	
	if (alarm_settings.play_stop == TRUE)
	{
		if (alarm_settings.recorded == FALSE)
		{
			ToDoSoundDatabaseChecking();
			DataRecIDtoNum(alarm_settings.dbid, app_status.sound_rec_id, &rec_num);
			DataOpenRecord(alarm_settings.dbid, rec_num, &app_status.sound_rec_id, NULL);
#ifdef PR31700
			SndPlay(alarm_settings.play_pause_frame, alarm_settings.dbid, app_status.sound_rec_id, 0);
#endif
		}
		else
		{
			ToDoSoundDatabaseChecking();
			DataRecIDtoNum(alarm_settings.dbid, alarm_settings.temp_recid, &rec_num);
			DataOpenRecord(alarm_settings.dbid, rec_num, &alarm_settings.temp_recid, NULL);
#ifdef PR31700
			SndPlay(alarm_settings.play_pause_frame, alarm_settings.dbid, alarm_settings.temp_recid, 0);
#endif
		}
	}
	else 
	{
		if (alarm_settings.recorded == FALSE)
		{
			ToDoSoundDatabaseChecking();
			DataRecIDtoNum(alarm_settings.dbid, app_status.sound_rec_id, &rec_num);
			DataOpenRecord(alarm_settings.dbid, rec_num, &app_status.sound_rec_id, NULL);
#ifdef PR31700
			SndREPlay(alarm_settings.play_pause_frame, alarm_settings.dbid, app_status.sound_rec_id, 0);
#endif
		}
		else
		{
			ToDoSoundDatabaseChecking();
			DataRecIDtoNum(alarm_settings.dbid, alarm_settings.temp_recid, &rec_num);
			DataOpenRecord(alarm_settings.dbid, rec_num, &alarm_settings.temp_recid, NULL);
#ifdef	PR31700
			SndREPlay(alarm_settings.play_pause_frame, alarm_settings.dbid, alarm_settings.temp_recid, 0);
#endif
		}
	}
	return TRUE;
}
/********************************************************
* Function:	ToDoSoundRecord
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoSoundReplayStop()
{
	Bitmap	*bitmap_addr;
	BYTE	object_type;
	
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_PAUSE, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = FALSE;
	bitmap_addr->bitmap_attr.bitmap_visible = FALSE;
	BitmapEraseBitmap(BITMAP_REPLAY_VOICE_PAUSE);
	
	FormGetObjectPointer(BITMAP_REPLAY_VOICE_PLAY, &object_type, (void **)&bitmap_addr);
	bitmap_addr->bitmap_attr.bitmap_enable = TRUE;
	bitmap_addr->bitmap_attr.bitmap_visible = TRUE;
	BitmapDrawBitmap(BITMAP_REPLAY_VOICE_PLAY);
	
#ifdef PR31700
	SndStop();
	InlaySetEnableStatus(TRUE);
	BatteryWarningSetEnableStatus(TRUE);
	//	AlarmMgrEnable(TRUE);
	SystemSetMappedHardwareKeyStatus(TRUE);
#endif
	if (alarm_settings.recorded == FALSE)
		DataCloseRecord(alarm_settings.dbid, app_status.sound_rec_id);
	else
		DataCloseRecord(alarm_settings.dbid, alarm_settings.temp_recid);
	
	alarm_settings.play_pause_frame = 0;
	alarm_settings.play_stop = TRUE;
	return;
}
/********************************************************
* Function:	ToDoSoundRecord
* Purpose: 	
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoFindOutAlarmSetBy ()
{
	SHORT	temp_year, temp_month, temp_day;
	
	if (app_status.alarm_status != NO_ALARM)
	{
		if (app_status.sch_year == app_status.alarm_year && 
			app_status.sch_month == app_status.alarm_month &&
			app_status.sch_day == app_status.alarm_day)
			alarm_set_by = ALARM_DUE_DATE;
		else
		{
			temp_year = app_status.sch_year;
			temp_month = app_status.sch_month -1;
			temp_day = app_status.sch_day;
			
			RtcDaysShift(&temp_year, &temp_month, &temp_day, -1);
			temp_month += 1;
			
			if (app_status.alarm_year == temp_year && 
				app_status.alarm_month == temp_month &&
				app_status.alarm_day == temp_day)
				alarm_set_by = ALARM_BEFORE_DUE_DATE;
			else
				alarm_set_by = ALARM_CHOOSE_DATE;
		}
	}
	else
		alarm_set_by = NO_ALARM_DATE;
	
	return;
}