/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   todolch.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "ToDo.h"
#include "ToDoFunc.h"
#include "ToDoDB.h"
#include "ToDoLch.h"
//#define	DEBUG

/********************************************************
* Function:	ToDoAppLaunch
* Purpose: 	This function is called to launch the 
*			To DO List application
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN ToDoAppLaunch(WORD cmd, void *cmd_ptr)
{
#ifdef PR31700
	UWORD		num_rec, count, byte_read;
	USHORT		field_num;
	BYTE		*buffer, *prepare_string, object_type;
	Bitmap		*bmp_addr;
	Form		*form_addr;
#endif
	RecordID	rec_id;
	
	/* Temp Alarm Use */
	DataFindDB(TODODB, &tdl_dbid);
	/* Temp Alarm Use */
	//	if (cmd == LAUNCH_CMD_GOTO_REC && DataRecordInfo(((GotoRec*)cmd_ptr)->dbid, ((GotoRec*)cmd_ptr)->rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
	if (cmd == LAUNCH_CMD_GOTO_REC && DataRecordInfo(tdl_dbid, ((GotoRec*)cmd_ptr)->rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
#ifdef	DEBUG
		printf("\n*** To Do Launch 1 ***\n");
#endif
		
		if (((GotoRec*)cmd_ptr)->find_string != NULL)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		cmd = LAUNCH_CMD_NORMAL_LAUNCH;
	}		
	
	switch(cmd)
	{
	case	LAUNCH_CMD_NORMAL_LAUNCH:
		tdl_field_buffer = NULL;
		
#ifdef	DEBUG
		printf("\n*** To Do Normal Launch ***\n");
#endif
		
		UIApplicationInit();
		ToDoListAppRestore(FALSE);
		EventLoop();
		/* Exit Normal Launch */
#ifdef PR31700
		if (entry_low_memory == FALSE || entry_old_edit == FALSE)
			ToDoListAppSave();
#endif
		
#ifdef PC_SIM
		ToDoListAppSave();
		//				rec_id = 1099;
		//				DataWriteField(tdl_dbid, TDL_EDIT_INFO, 0, 4, (BYTE*)&rec_id);				
		ToDoListAppRestore(FALSE);
		EventLoop();
#endif
		UIDeleteAllAppObjects();
		if (cmd_ptr != NULL)
			pfree(cmd_ptr);
		return TRUE;
		
	case	LAUNCH_CMD_FIND:
#ifdef	PR31700
		app_id = SysGetActiveAppID();
		ToDoListDatabaseChecking();
		DataTotalRecord(tdl_dbid, &num_rec);
		
		for (count =0; count <num_rec; count++)
		{
			DataOpenRecord(tdl_dbid, count, &rec_id, NULL);
			
			for (field_num =3; field_num <6; field_num++)
			{
				DataGetField(tdl_dbid, rec_id, field_num, &buffer, &byte_read);
				
				if (GlobalFindSearchText((BYTE*)cmd_ptr, buffer) >= 0)
				{
					ToDoPrepareFindText(tdl_dbid, rec_id, &prepare_string);
					
					GlobalFindAddItem(app_id, tdl_dbid, rec_id, field_num, prepare_string, FALSE);
					qfree(buffer);
					pfree(prepare_string);
					break;
				}
				qfree(buffer);
			}
			DataCloseRecord(tdl_dbid, rec_id);
		}
		if (cmd_ptr != NULL)
			pfree(cmd_ptr);
		
		DataCloseDB(tdl_dbid);
#endif
		return TRUE;
		
	case	LAUNCH_CMD_GOTO_REC:
#ifdef	DEBUG
		printf("\n\n\n*** To Do GoTo Start ***\n\n\n");
#endif
		tdl_field_buffer = NULL;
		ToDoListDatabaseChecking();
		ToDoGotoItem(((GotoRec*)cmd_ptr)->dbid, ((GotoRec*)cmd_ptr)->rec_id,
			((GotoRec*)cmd_ptr)->field_num, ((GotoRec*)cmd_ptr)->find_string);
		/* Check Goto from Find or Other Application */
		if (cmd_ptr != NULL)
		{
			if (((GotoRec*)cmd_ptr)->find_string != NULL)
				pfree(((GotoRec*)cmd_ptr)->find_string);
			pfree(cmd_ptr);
		}
		EventLoop();
		/* Exit Goto Record */
#ifdef PR31700
		if (entry_low_memory == FALSE || entry_old_edit == FALSE)
			ToDoListAppSave();
#endif
		UIDeleteAllAppObjects();
     			return TRUE;
				
	case	LAUNCH_CMD_ALARM_HIT:
		tdl_field_buffer = NULL;
#ifdef PC_SIM
		///				UIApplicationInit();
		
		if (DataFindDB(TODODB, &tdl_dbid) != TRUE)
		{
			ToDoDatabaseInit();
			ToDoListAppRestore(TRUE);
		}
		else
			ToDoListAppRestore(FALSE);
		/* Exit Normal Launch */
		ToDoListAppSave();
		UIDeleteAllAppObjects();
		ToDoSetAllRecordsAlarm(0);
#endif
#ifdef	PR31700
#ifdef	DEBUG
		printf("\n*** LAUNCH_CMD_ALARM_HIT ***");
#endif
		ToDoListDatabaseChecking();
		rec_id = ((AlarmEventHit *) cmd_ptr)->rec_id;
		
#ifdef	DEBUG
		printf("\n*** Set Next Alarm ID = %d ***", rec_id);
#endif 
#else
		rec_id = 1010;
#endif
#ifdef	DEBUG
        printf("\n*** Set Next Alarm Start ***\n");
#endif
		ToDoSetNextRecordAlarm(rec_id);
#ifdef	DEBUG
		printf("\n*** Set Next Alarm Finish ***\n");
#endif
		
		if (cmd_ptr != NULL)
			pfree(cmd_ptr);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	ToDoPrepareFindText
* Purpose: 	This function is called to prepare the text 
*			for a record to be displayed in the global find 
*			application
* Scope:	application/internal
* Input:	dbid
*			rec_id
*			prepare_string
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoPrepareFindText(DatabaseID dbid, RecordID rec_id, BYTE **prepare_string)
{
	SHORT			string_content_width, string_schdate_width;
	ObjectBounds	content_bounds, schdate_bounds;
	BYTE			*content, *schdate, *buffer;
	UWORD			byte_read, name_num_chars;
	
	
	
	content_bounds.xcoord	=0;
	content_bounds.ycoord	=0;
	content_bounds.width	=67;
	content_bounds.height	=9;
	
	schdate_bounds.xcoord	=0;
	schdate_bounds.ycoord	=0;
	schdate_bounds.width	=60;
	schdate_bounds.height	=9;
	
	*prepare_string = (BYTE*)pmalloc(100*sizeof(BYTE));
	/* Get To Do Content */
	DataGetField(dbid, rec_id, 3, &buffer, &byte_read);
    content = (BYTE*)pmalloc((strlen(buffer) + 10) *sizeof(BYTE));
	strcpy(content, buffer);
    qfree(buffer);
	StrChopString(&content_bounds, content, SMALL_FONT, TRUE, 0);
	string_content_width = StrGetWidth(content, SMALL_FONT);
	/* Get Schedule Date */
	DataGetField(dbid, rec_id, 4, &buffer, &byte_read);
    schdate = (BYTE*)pmalloc((strlen(buffer) + 10) *sizeof(BYTE));
	strcpy(schdate, buffer);
	qfree(buffer);
	StrChopString(&schdate_bounds, schdate, SMALL_FONT, TRUE, 0);
	string_schdate_width = StrGetWidth(schdate, SMALL_FONT);
	
	strcpy(*prepare_string, content);
	name_num_chars = strlen(content);
	(*prepare_string)[name_num_chars] = 11;
	(*prepare_string)[name_num_chars + 1] = 139 - string_content_width - string_schdate_width;
	
	if (schdate[0] == '0')
		schdate[0] = '\0';
	
	sprintf((char*)(*prepare_string + name_num_chars + 2), "%s", schdate);	
	pfree(content);
	pfree(schdate);
}

/********************************************************
* Function:	ToDoGotoItem
* Purpose: 	This function is called to init all related variables
*			and goto the specific form to display the required record
* Scope:	application/internal
* Input:	dbid
*			rec_id
*			field_num
*			search_string
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void ToDoGotoItem(DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *search_string)
{
	BYTE		object_type, *buffer;
	Field		*fld_addr;
	Form		*form_addr;
	WORD		total_num_lines;
	WORD		highlight_char_pos =0, line_num;
	UWORD		byte_read, rec_num;
	BOOLEAN		found =FALSE;
	
	/* Set up app_status variables */
	app_status.rec_id = rec_id;
	/* Allocate global variable */
	if(tdl_field_buffer != NULL)
		qfree(tdl_field_buffer);
	tdl_field_buffer = (BYTE**)qmalloc(1*sizeof(BYTE*));
	tdl_field_buffer[0] = NULL;
	/* Set up app_status variables */
	ToDoRecordToVariable();
	//	sorted_by = PRIORITY;
	pressed_object1 = 0;
	pressed_object2 = 0;
	pen_down = FALSE;
	alarm_date = VIEWING_ALARM_DATE;
	detail_date = TODAY;	/* Don't care */
	
	edit_change = FALSE;
	alarm_settings.dbid = tdl_dbid;
	alarm_settings.play_pause_frame = 0;
	alarm_settings.play_stop = TRUE;
	alarm_settings.rec_stop = TRUE;
	alarm_settings.recorded = FALSE;
	ToDoListDatabaseChecking();
	/* Initialisation all the Forms */
	if (FormGetObjectPointer(FORM_TO_DO_VIEWING, &object_type, (void **)&form_addr)
		== ERR_UI_RES_NOT_FOUND)
		FormInitAllFormObjects(FORM_TO_DO_VIEWING);
	
	DataGetField(tdl_dbid, TDL_EDIT_INFO, 29, &buffer, &byte_read);
	table_font = (BYTE)(*buffer);
	qfree(buffer);
	
	field_top_line = 0;
	field_insert_pt_pos = 0;
	ToDoViewingSetUpScreen();
	FormGetObjectPointer(FIELD_TO_DO_VIEWING, &object_type, (void **)&fld_addr);
	
	/* Goto to select text */
	if (search_string != NULL)
	{
		DataRecIDtoNum(tdl_dbid, rec_id, &rec_num);
		DataOpenRecord(tdl_dbid, rec_num, &rec_id, NULL);
		DataGetField(tdl_dbid, rec_id, 3, &buffer, &byte_read);
		strcpy(tdl_field_buffer[0], buffer);
		qfree(buffer);
		
		highlight_char_pos = GlobalFindSearchText(search_string, tdl_field_buffer[0]);
		total_num_lines = fld_addr->field_total_num_lines;
		
		for (line_num =0; line_num <total_num_lines; line_num++)
		{
			if ((highlight_char_pos >= fld_addr->field_lineinfo[line_num].start) &&
				(highlight_char_pos <= (fld_addr->field_lineinfo[line_num].start +
				fld_addr->field_lineinfo[line_num].length -1)))
			{
				found = TRUE;
				
				if (line_num > (total_num_lines - fld_addr->field_num_lines_displayed))
					line_num = (total_num_lines - fld_addr->field_num_lines_displayed);
				fld_addr->field_top_line_num = line_num;
				break;
			}
		}
		
		if (!found)
			fld_addr->field_top_line_num = 0;
		
		field_top_line = fld_addr->field_top_line_num;
		ToDoSetUpFieldScreen(FORM_TO_DO_VIEWING);
		ToDoFieldSetScrollbar(FIELD_TO_DO_VIEWING, SCROLLBAR_TO_DO_VIEWING);
		
		fld_addr->field_highlight_start_char = highlight_char_pos;
		fld_addr->field_highlight_end_char = highlight_char_pos + strlen(search_string) - 1;
		fld_addr->field_highlight_length = strlen(search_string);
		fld_addr->field_attr.field_highlight = TRUE;
		FormSetFormActiveObject(FORM_TO_DO_VIEWING, fld_addr->identification.ui_object_id);
	}
	/* Disable the field object */
	show_line = FALSE;
	goto_highlight = TRUE;
	FormPopupForm(FORM_TO_DO_VIEWING);
}

/*****************************************************************
* Function:	ToDoLaunchApplication
* Purpose: 	This function is used to launch to other application
*		depend on the selection
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*****************************************************************/
#ifdef PR31700
void ToDoLaunchApplication()
{
	SHORT	popup_item_num;
	AppID   appid;
	BYTE    *launchtosch;
	
	ControlPopupGetSelectedItem(POPUP_TRIGGER_CATE, &popup_item_num);
	
	if (popup_item_num == 4)
	{
		SysGetAppID(ANN, &appid);
		EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
		EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_NORMAL_LAUNCH, 0, NULL);
	}
	else if (popup_item_num != 0)
	{
		SysGetAppID(SCHEDULER, &appid);
		EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
		
		launchtosch = (BYTE*)pmalloc(1*sizeof(BYTE));
		
		switch(popup_item_num)
		{
		case 1:	*launchtosch = 0;
			break;
			
		case 2:	*launchtosch = 1;
			break;
			
		case 3:	*launchtosch = 2;
			break;
		}
		EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_NORMAL_LAUNCH, 0, launchtosch);
	}
}
#endif
