#include <stdio.h>
#include "crc.h"

#define POLY 0x1021

static unsigned short CRCtable[256];

/* initialize CRC table */

void InitCRC(void)
{int i;
 for(i=0;i<256;i++) CRCtable[i] = CalcTable(i,POLY,0);
}

/* calculate CRC table entry */

unsigned short CalcTable(
   unsigned short data,
   unsigned short genpoly,
   unsigned short accum)
{static int i;
 data <<= 8;
 for(i=8;i>0;i--)
         {
          if((data^accum) & 0x8000) accum = (accum << 1) ^ genpoly;
          else accum <<= 1;
          data <<= 1;
         }
 return(accum);
}

/* compute updated CRC */

unsigned short UpdateCRC(unsigned short crc, unsigned char byte)
{
 return( (crc << 8) ^ CRCtable[ (crc >> 8) ^ byte ] );
}
