#include <system.h>
#include "res\resource.h"
#include "../stdlib/my_stdio.h"
#include <uartmgr.h>
#include "ascii.h"

void FormGotoApp(BYTE* app_name);
void EventLoop(void);
BOOLEAN ApplicationHandleEvent(EvtType *event);
BOOLEAN FormIfaceHandleEvent(EvtType* event);
BOOLEAN FormTypeHandleEvent(EvtType* event);
BOOLEAN FormAboutHandleEvent(EvtType* event);
BOOLEAN (*FormDispatchEvent)(EvtType *Event);

int downloading = 0;
int baud = UART_BAUD9600;
char ftype[65];

int __main(WORD cmd, void *cmd_arg)
{
  strcpy(ftype, "Text");

  switch(cmd) {
  case LAUNCH_CMD_NORMAL_LAUNCH:
    UIApplicationInit();		//initialize UI resources
    FormPopupForm(FORM_IFACE);	//start main form
    EventLoop();			//run main event loop
    UIDeleteAllAppObjects();	        //main event loop has stopped, cleanup
    break;
  case LAUNCH_CMD_GOTO_REC:
    if(((GotoRec*)cmd_arg)->find_string)
      pfree(((GotoRec*)cmd_arg)->find_string);
  case LAUNCH_CMD_FIND:
  case LAUNCH_CMD_ALARM_HIT:
    pfree(cmd_arg);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

void EventLoop(void)
{
  EvtType event;

  while(1) {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);

    if(event.eventType==EVT_APP_STOP) break;
  }
}

BOOLEAN ApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType) {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress((ObjectID)event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects((ObjectID)event->eventID);
    if(UISearchForAddress((ObjectID)event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_IFACE: evtHandler = (void*)FormIfaceHandleEvent; break;
    case FORM_TYPE:  evtHandler = (void*)FormTypeHandleEvent;  break;
    case FORM_ABOUT: evtHandler = (void*)FormAboutHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler((ObjectID)event->eventID,(void**)&FormDispatchEvent,evtHandler);
    FormSetActiveForm((ObjectID)event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}


void Upload(char *name)
{
  char buff[2048];
  FntClearScreen();
  SetupSerial(baud);
  InitCRC();
  if(TxyModem(1,name,buff,TRUE,TRUE))
    TxyModem(1,"",buff,TRUE,TRUE);
  DestroySerial();
  SioDelay(3);
  FormPopupForm(FORM_IFACE);
}

void Download()
{
  char buff[2048];
  char fname[100];
  int err;
  filetype(ftype);
  FntClearScreen();
  SetupSerial(baud);
  //  CpuChangeSpeed(0);
  downloading=1;
  do {
    InitCRC();
    err=RxyModem(1,fname, buff, 'C', TRUE);   
  } while ((fname[0]!=0) && (err==TRUE));
  downloading=0;
  PutChar(1,ACK);
  SioDelay(1);
  DestroySerial();
  SioDelay(3);
  FormPopupForm(FORM_IFACE);
}





BOOLEAN FormIfaceHandleEvent(EvtType* event)
{
  SHORT item;
  BYTE *ptr;
	
  switch(event->eventType) {
  case EVT_FORM_OPEN:
    FormDrawForm(event->eventID);
    ListDeleteAllItems(LIST_IFACE);
    ListAllDBs(NULL, LIST_IFACE);
    ListSetSelectedItem(LIST_IFACE, NO_SELECTION);
    ListDrawList(LIST_IFACE);
    break;

  case EVT_MENU_SELECT_ITEM:
    switch(event->para1) {
    case 0: FormPopupForm(FORM_TYPE); break;
    case 1: baud = UART_BAUD57600; break;
    case 2: baud = UART_BAUD38400; break;
    case 3: baud = UART_BAUD19200; break;
    case 4: baud = UART_BAUD9600; break;
    case 5: baud = UART_BAUD4800; break;
    case 6: baud = UART_BAUD2400; break;
    case 7: baud = UART_BAUD1200; break;
    case 8: FormPopupForm(FORM_ABOUT); break;
    }
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(event->eventID, event->para1);
    ListSetHighlightedItem(event->eventID, event->para1);
    ListDrawList(event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormGotoApp("Mainmenu");
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    if (event->eventID==DOWNLOAD_BUTTON) Download();
    else {
      ListGetTotalItems(LIST_IFACE, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_IFACE, &item);
      if (item == NO_SELECTION) return TRUE;
      ListGetListItem(LIST_IFACE, item, (BYTE **)&ptr);
      Upload(ptr);
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}


void TypeOK()
{
  BYTE *text_ptr;

  TextboxGetTextPointer(TEXT_TYPE, &text_ptr);
  strcpy(ftype, text_ptr);
  TextboxSetInsertPointOff(TEXT_TYPE);
  FormRestoreBitBehind(FORM_TYPE);
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_TYPE, 0, 0, NULL);
  FormPopupForm(FORM_IFACE);
}


BOOLEAN FormTypeHandleEvent(EvtType* event)
{
  switch(event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(event->eventID);
    FormDrawForm(event->eventID);
    TextboxSetText(TEXT_TYPE, ftype);
    TextboxSetInsertPointPositionByCharPos(TEXT_TYPE, strlen(ftype));
    TextboxSetInsertPointOn(TEXT_TYPE);
    TextboxDrawTextbox(TEXT_TYPE);
    FormObjectSetFocus(TEXT_TYPE);
    break;
	
  case EVT_KEY:
    if (event->eventID == SOFT_KEY) {	
      if ((BYTE)(event->para1) == 13)
	TypeOK();
      else
	TextboxAddKeyInChar(TEXT_TYPE, (BYTE)(event->para1));
    }
    return TRUE;
    break;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
      TypeOK();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      TextboxSetInsertPointOff(TEXT_TYPE);
      FormRestoreBitBehind(FORM_TYPE);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_TYPE, 0, 0, NULL);
      FormPopupForm(FORM_IFACE);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}

BOOLEAN FormAboutHandleEvent(EvtType* event)
{
  switch(event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(event->eventID);
    FormDrawForm(event->eventID);
    break;
	

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormRestoreBitBehind(FORM_ABOUT);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_ABOUT, 0, 0, NULL);
      FormPopupForm(FORM_IFACE);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}


void FormGotoApp(BYTE* app_name)
{
  ObjectID objid;
  FormGetActiveFormID(&objid);
  EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
  SysGetAppID(app_name,&objid);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
}
