#include "../stdlib/Fnt.h"
#include <system.h>
#include "ascii.h"

int SioPutc(int p, int c);
int SioGetc(int p, int secs);

int x=0;
int y=0;
void ResetDisplay()
{
  x=0;
  y=0;
  FntClearScreen();
  FntSetFont(smallFixedFont);
}


void DisplayLine(char *str, void *ign0, int ign1)
{
  ObjectBounds bnds;
  BitmapTemplate b;
  extern int downloading;

  bnds.xcoord = x;
  bnds.ycoord = y;
  bnds.width = 160-bnds.xcoord;
  bnds.height = FntLineHeight();
  LcdEraseRegion(&bnds);
  FntDrawString(str, x, y, FALSE);
  y += FntLineHeight();
  if (y+FntLineHeight()>160) {
    if (downloading) {
      y=0;
    } else {
      b.xcoord = 0;
      b.ycoord = FntLineHeight();
      b.width = 160;
      b.height = 160-b.ycoord;
      LcdGetBitmap(&b);
      b.ycoord = 0;
      LcdDrawBitmap(&b, FALSE);
      qfree(b.bitmap_data);
      y-= FntLineHeight();
      LcdEraseRegion(&bnds);
    }
  }
  x = 0;
}


void SioDelay(int dly)
{
  TmrWaitTime(dly*1000);
}


int SioKeyPress()
{
  // TBD
  return 0;
}

int SioKeyRead()
{
  // TBD
  return 0;
}

/*** output character to serial port ***/

int PutChar(int P, char ch)
{int rc;
 /* transmit character */
 rc = SioPutc(P,ch);
 return(rc);
}

/*** receive character from serial port ***/

int GetChar(int P, int Timeout)
{int rc;
 rc = SioGetc(P,Timeout);
 return(rc);
}

/*** display the error text ***/

void SayError(int P, char *ptr)
{
 DisplayLine("Error!!!",NULL,0);
 DisplayLine(ptr,NULL,0);
 /* cancel remote */
 PutChar(P,CAN);
 PutChar(P,CAN);
 PutChar(P,CAN);
} /* end SayError */

WORD port;
#include <uartmgr.h>

volatile char dbuf[2];
int read0;

WORD  UartRxData(WORD port, BYTE *data)
{
    {
        if (~CPU ->REG_UARTA_CTRL_1 & RXHOLDFULL)   /* receive buffer empty */
            return (UART_BUF_EMPTY);
        *data = (char)(CPU ->REG_UARTA_HLDG );
    }
    return (UART_SUCCESS);
}



void SetupSerial(int baud)
{
  Err err;
  CpuChangeSpeed(1<<10);

  err = ComOpenPort(0, &port);
  err = ComConfigPort(port, baud, UART_PARITY_NONE | UART_DATABIT8 | UART_STOPBIT1);
  err = ComCapture(port, COM_MODE_CHAR, 0, 0, NULL);

  CpuChangeSpeed(0<<10);
  ResetDisplay();
}

void DestroySerial()
{
  Err err;
  err = ComClosePort(port);
}


int SioPutc(int p, int c)
{
  ComSendChar(port, c);
  //  CpuChangeSpeed(1<<10);
  // UartTxData( port, c);
  //  CpuChangeSpeed(0<<10);

  return 0;
}

int SioPutBuff(int p, char *buff, int cnt)
{
  //  CpuChangeSpeed(1<<10);
   while(cnt--)
     //    UartTxData(port, *(buff++));
     //  CpuChangeSpeed(0<<10);
     ComSendChar(port, *(buff++));
  return 0;
}

int SioRxFlush(int p)
{
  BYTE data;
  // TBD
  CpuChangeSpeed(1<<10);
  while (UartRxData(UART_A, &data)!=UART_BUF_EMPTY);
  CpuChangeSpeed(0<<10);
  return 0;
}

int holdchar = -1;
int SioUnGetc(int p, int c)
{
  holdchar = c;
  return 0;
}


UWORD timer;

void TimerCallback()
{
  EvtAppendEvt(RTC_EVENT, 0, 0, 0, NULL);
  TmrIntDisable(timer);
}

int SioGetc(int p, int secs)
{
  int c;
  unsigned int dly;
  EvtType event, e1;
  BYTE data;

  if (holdchar>=0) {
    c = holdchar;
    holdchar = -1;
    return c;
  }
  if (secs<1) secs=1;

  timer = TmrIntEnable(secs*1000,TimerCallback);
  do {
    EvtGetEvent(&event);
  }while (event.eventType!=EVT_UART_GET_CHAR && event.eventType!=RTC_EVENT);
  
  if (event.eventType==EVT_UART_GET_CHAR) {
    TmrIntDisable(timer);
    // Clear out any possible timer messages
    EvtAppendEvt(0xbabe,0,0,0,NULL);
    do EvtGetEvent(&e1); while (e1.eventType!=0xbabe);
    ComCapture(port, COM_MODE_CHAR, 0, 0, NULL);
    return event.para1&255;
  }
  CpuChangeSpeed(0);
  DisplayLine("Timeout",0,0);
  return -1;
}

int SioGetBuff(int p, unsigned char *buffer, int size, int timeout)
{
  int code;

  while (size--) {
    code = SioGetc(p, timeout);
    if (code==-1) return -1;
    *(buffer++) =  code;
  }
  return 0;
}
