/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on March 1st, 2000

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 2001.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   
Company     :   
Project     :   Helio 
Date	    :   
Purpose	    :   main file
Revision    :   
Note        :   None
===========================================================================
*/        

#include "main.h"

//main entry point of program
__main(WORD cmd, void *cmd_arg)
{
	switch(cmd)
	{
		case LAUNCH_CMD_NORMAL_LAUNCH:
			UIApplicationInit();		//initialize UI resources
			#ifdef DEBUG
			DBG_APP_BEGIN();
			#endif
			FormPopupForm(FORM_MAIN);	        //start main form
			EventLoop();			//run main event loop
			#ifdef DEBUG
			DBG_APP_END();
			#endif
			UIDeleteAllAppObjects();	        //main event loop has stopped, cleanup
		break;
		case LAUNCH_CMD_GOTO_REC:
			if(((GotoRec*)cmd_arg)->find_string)
				pfree(((GotoRec*)cmd_arg)->find_string);
		case LAUNCH_CMD_FIND:
		case LAUNCH_CMD_ALARM_HIT:
			pfree(cmd_arg);
		break;
		default:
			return FALSE;
	}
	return TRUE;
}

void EventLoop(void)
{
	EvtType event;

	while(1)
	{
		EvtGetEvent(&event);
		if(SystemHandleEvent(&event))
			continue;
		if(MenuHandleEvent(&event))
			continue;
		if(ApplicationHandleEvent(&event))
			continue;
		FormDispatchEvent(&event);
		if(event.eventType==EVT_APP_STOP)
			break;
	}
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	BYTE object_type;
	Form *form_ptr;
	void* evtHandler;
	
	switch(Event->eventType)
	{
		case EVT_FORM_LOAD:
			if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
				FormInitAllFormObjects((ObjectID)Event->eventID);
			if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
				return FALSE;
			switch((ObjectID)Event->eventID)
			{
				case FORM_MAIN:
					evtHandler = (void*)FormMainHandleEvent;
				break;
				default:
					return FALSE;
			}
			FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
			FormSetActiveForm((ObjectID)Event->eventID);
		break;
		default:
			return FALSE;
	}
	return TRUE;
}



BOOLEAN FormMainHandleEvent(EvtType* Event)
{
	switch(Event->eventType)
	{
		case EVT_FORM_OPEN:
			FormDrawForm(Event->eventID);
		break;
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{
				case INLAY_EXIT:
				case INLAY_MAIN_MENU:
					FormGotoApp("Mainmenu");
				break;
				default:
					return FALSE;
			}
		break;

		case EVT_CONTROL_SELECT:
			switch (Event->eventID) 
			{
				case BUTTON_ELOFF:
					OffEL();
					break;
				case BUTTON_ELON:
					OnEL();
				break;
			}
		break;

		default:
			return FALSE;
	}
	return TRUE;
}

void FormGotoApp(BYTE* app_name)
{
	ObjectID objid;
	#ifdef DEBUG
	DBG_MESSAGE("+FormGotoApp()\r\n");
	#endif
	FormGetActiveFormID(&objid);
	EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
	SysGetAppID(app_name,&objid);
	EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
	EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
	#ifdef DEBUG
	DBG_MESSAGE("-FormGotoApp()\r\n");
	#endif
}