/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this
file except in compliance with the License.

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
for the specific language governing rights and limitations under the License.

The Original Code is VT-OS Ver. 1.1 Operating System, released
on March 1st, 2000

The Initial Developer of the Original Code is VTech Informations Ltd.  All
codes are Copyright (C) VTech Informations Ltd. 2001.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Heidi Gerstle
Company     :
Project     :   Helio Bio Rhythm
Date        :   5/7/02
Purpose     :   main file
Revision    :   1.1
Note        :   None
===========================================================================
*/
/*CORRECTED DAY INCREASE AND DECREASE*/

#include "main.h"

DatabaseID     BioDB;
RecordID        rec_id;

RTM     Beg_Date;
RTM     End_Date;
RTM     Change_Date;
USHORT  Days;
char    Channel[40];
short   dispF, dispE,dispI, dispP,dispM,dispS,dispH=0;
char    sz[200];
char    person[100];
USHORT  person_no;
BYTE    Description[41];
char    *about="BIO RHYTHM 1.1 for Helio\r\nHeidi Gerstle\tMay 2002\r\n\rWith code from dvBio for daVinci by Carlos Ruiz";
char    *help="Bio Rhythms\r\nThis program can also be used to calculate day differences. To change the ending day, press the date in the middle.\r\nThe following explanations for the curves have been collected from various sources. I take no responsibility for this. Don't take it too seriously.\r\rCritical days are when the curve crosses the 0-line; the most critical being when it goes from negative from positive. Be extra careful on those days.\r\rPhysical Cycle is 28 days and shows the physical level of activity the body can give in a day.\r\rEmotional Cycle is 28 days and shows the emotional capacity, that is the sensibility level in a given day.\r\rIntellectual cycle is 33 days and shows the intellectual activity level the brain can give in a day.\r\rPassion is the combination of the physical and emotional cycle. The passion is power, guide, incentive,and sexuality. From Passion comes the ability to act.\r\rMastery is the combination of physical and intellectual cycles. While passion gives us the energy to start something, mastery gives us the capacity to complete it. Mastery is the ability to act in that we desire.\r\rWisdom is the combination of the emotional and the intellectual cycles. From here comes the ability to choose the best way. The wisdom guides the passion.";
UWORD   recCount;
BYTE    *buffer;
UWORD   byte_read;
int     Beg_Year;
int     End_Year;
int     Beg_Month;
int     End_Month;
int     Beg_Day;
int     End_Day;
SHORT   Diffdays;
SHORT   Beg_DayofYear;
SHORT   End_DayofYear;
int     Leaps=0;
int     monthdays[]={0,0,31,59,90,120,151,181,212,243,273,301,334};
int     days;
int     Years;
int     Beg_Days;
int     End_Days;
int     End_Dayno;
int     Beg_Dayno;
int     Valid_Year;
int     Valid_Mon;
int     Valid_Day;


int     Draw(void);
int     Curve(int range1, int style);
int     CurveComb(int range1, int range2, int style);
void    AddEdit_Person();
void    Add_Person();
void    Read_Data();
void    Person_toPopup();
void    Delete_Person();
void    Clear_Drawing();
void    Edit_Person();


//main entry point of program
__main(WORD cmd, void *cmd_arg)
{
    BYTE buffer_date[100];
    switch(cmd)
    {
        case LAUNCH_CMD_NORMAL_LAUNCH:
            UIApplicationInit();  //initialize UI resources
            #ifdef DEBUG
                DBG_APP_BEGIN();
            #endif
            RtcGetTime(&End_Date);
            RtcFormatDate(&End_Date, "YY~/MM~/DD", buffer_date);
            ControlSetLabel (BTN_DATE, buffer_date);
            FormPopupForm(FORM_MAIN);         //start main form
            EventLoop();   //run main event loop
            #ifdef DEBUG
                DBG_APP_END();
            #endif
            UIDeleteAllAppObjects();         //main event loop has stopped, cleanup
            break;
        case LAUNCH_CMD_GOTO_REC:
            if(((GotoRec*)cmd_arg)->find_string)
                pfree(((GotoRec*)cmd_arg)->find_string);
            case LAUNCH_CMD_FIND:
            case LAUNCH_CMD_ALARM_HIT:
            pfree(cmd_arg);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

void EventLoop(void)
{
    EvtType event;

    while(1)
    {
        EvtGetEvent(&event);
        if(SystemHandleEvent(&event))
            continue;
        if(MenuHandleEvent(&event))
            continue;
        if(ApplicationHandleEvent(&event))
            continue;
        FormDispatchEvent(&event);
        if(event.eventType==EVT_APP_STOP)
            break;
    }
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
    BYTE object_type;
    Form *form_ptr;
    void* evtHandler;

    switch(Event->eventType)
    {
        case EVT_FORM_LOAD:
            if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
                FormInitAllFormObjects((ObjectID)Event->eventID);
            if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
                return FALSE;
            switch((ObjectID)Event->eventID)
            {
                case FORM_MAIN:
                    evtHandler = (void*)FormMainHandleEvent;
                    break;
                case FORM_ABOUT:
                    evtHandler = (void*)FormAboutHandleEvent;
                    break;
                case FORM_HELP:
                    evtHandler = (void*)FormHelpHandleEvent;
                    break;
                case FORM_PERSON:
                    evtHandler = (void*)FormPersonHandleEvent;
                    break;
                case FORM_DATE:
                    evtHandler = (void*)FormDateHandleEvent;
                    break;
                default:
                    return FALSE;
                }
            FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
            FormSetActiveForm((ObjectID)Event->eventID);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}



BOOLEAN FormMainHandleEvent(EvtType* Event)
{
    ObjectBounds bnds;
    BYTE buffer_date[100];
    int     Days_leap[]={31,29,31,30,31,30,31,31,30,31,30,31};
    int     Days_noleap[]={31,28,31,30,31,30,31,31,30,31,30,31};

    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            End_Year=End_Date.year;
            End_Month=End_Date.mon+1;
            End_Day=End_Date.mday;
            RtcFormatDate(&End_Date, "YY~/MM~/DD", buffer_date);
            ControlSetLabel (BTN_DATE, buffer_date);
            Person_toPopup();
            if(!DataFindDB("BioDB", &BioDB))
            {
                DataNewDB((BYTE*)("BioDB"), 1,(BYTE *)("Heidi"),&BioDB);
                ControlPopupInsertItem(POPUP_PERSON, 1, "??");
            }
            FormDrawForm(Event->eventID);
            Draw();
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                case INLAY_MAIN_MENU:
                    qfree(about);
                    qfree(help);
                    qfree(buffer);
                    FormGotoApp("Mainmenu");
                    break;
                default:
                    return FALSE;
                }
            break;

        case EVT_MENU_SELECT_ITEM:
            switch(Event->para1)
            {
                case 0://Help
                    FormPopupForm(FORM_HELP);
                    break;
                case 1://About
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_ABOUT);
                    break;
            }
            break;


        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case BTN_F:
                // dispF=!dispF;
                    strcpy(Description,"Physical");
                    dispF=1;
                    Curve(23,0);
                    break;
                case BTN_E:
                    dispE=!dispE;
                    strcpy(Description,"Emotional");
                    Curve(28,1);
                    break;
                case BTN_T:
                    dispI=!dispI;
                    strcpy(Description,"Intellectual");
                    Curve(33,2);
                    break;
                case BTN_P:
                    dispP=!dispP;
                    strcpy(Description,"Passion");
                    CurveComb(23,28,0);
                    break;
                case BTN_M:
                    dispM=!dispM;
                    strcpy(Description,"Mastery");
                    CurveComb(23,33,1);
                    break;
                case BTN_W:
                    dispS=!dispS;
                    strcpy( Description,"Wisdom");
                    CurveComb(28,33,2);
                    break;
                case BTN_CLEAR:  //clear
                    Clear_Drawing();
                    Draw();
                    break;
                case BTN_DATE:
                    Clear_Drawing();
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_DATE);
                    Draw();
                    break;
                case BTN_MINUS:
                    Clear_Drawing();
                    End_Day=End_Day-1;
                    End_Date.mday=End_Date.mday-1;
                    if(End_Date.mday<1)
                    {
                        if(End_Date.mon>0)
                            End_Date.mon=End_Date.mon-1;
                        else
                        {
                            End_Date.mon=11;
                            End_Date.year= End_Date.year-1;
                        }

                        if(End_Date.year%4==0)                        
                            End_Date.mday=Days_leap[End_Date.mon];
                        else
                            End_Date.mday=Days_noleap[End_Date.mon];
                    }

                    RtcFormatDate(&End_Date, "YY~/MM~/DD", buffer_date);
                    ControlSetLabel (BTN_DATE, buffer_date);
                    ControlDrawControl (BTN_DATE);
                    Read_Data();
                    sprintf(sz,"%i",Days);
                    StringSetText(STRING_DAYS,sz);
                    StringDrawString(STRING_DAYS);
                    Draw();
                    break;
                case BTN_PLUS:
                    Clear_Drawing();
                    End_Day=End_Day+1;
                    End_Date.mday=End_Date.mday+1;
                    if(
                        (End_Date.year%4==0 &&
                        (End_Date.mday>Days_leap[End_Date.mon]))
                        ||
                        (End_Date.year%4>0 &&
                        (End_Date.mday>Days_noleap[End_Date.mon]))
                        )
                    {
                        End_Date.mday=1;

                        if(End_Date.mon<11)
                            End_Date.mon=End_Date.mon+1;
                        else
                        {
                            End_Date.mon=0;
                            End_Date.year= End_Date.year+1;
                        }
                    }
                    RtcFormatDate(&End_Date, "YY~/MM~/DD", buffer_date);
                    ControlSetLabel (BTN_DATE, buffer_date);
                    ControlDrawControl (BTN_DATE);
                    Read_Data();
                    sprintf(sz,"%i",Days);
                    StringSetText(STRING_DAYS,sz);
                    StringDrawString(STRING_DAYS);
                    Draw();
                    break;
            }
            break;
        case  EVT_CONTROL_POPUP_SELECT:
            ControlPopupGetSelectedItem(POPUP_PERSON, &person_no);
            ControlPopupGetPopupItem(POPUP_PERSON, person_no, &buffer);
            strcpy(person,buffer);
            StringSetText(STRING_DAYS," ");
            StringDrawString(STRING_DAYS);
            if(strstr(person,"Edit Person"))
            {
                AddEdit_Person();
            }
            else
            {
                Draw();
                Days=0;
                Read_Data();
            }
            break;

        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormAboutHandleEvent(EvtType* Event)
{
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            FieldInitField((ObjectID)A_FIELD);
            FieldSetText((ObjectID)A_FIELD,about);
            FormDrawForm(Event->eventID);
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    qfree(about);
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    case INLAY_MAIN_MENU:
                    FormGotoApp("Mainmenu");
                    break;
                default:
                    return FALSE;
                }
            break;

        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case A_BTN_OK:
                    qfree(about);
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
            }
            break;

        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormHelpHandleEvent(EvtType* Event)
{
    WORD value;
    WORD maxValue;
    WORD minValue;
    WORD pageSize;
    WORD totalLines;

    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            ScrollbarInitScrollbar(H_SCROLLBAR);
            FieldInitField((ObjectID)H_FIELD);
            FieldSetText((ObjectID)H_FIELD,help);
            FieldGetTotalNumOfLines (H_FIELD, &totalLines);
            ScrollbarSetScrollbar(H_SCROLLBAR, 0, totalLines - 14, 0, 12, totalLines);
            ScrollbarSetScrollbarDrawPagesize((ObjectID)H_SCROLLBAR, 14);
            FormDrawForm(Event->eventID);
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                case INLAY_MAIN_MENU:
                    FormGotoApp("Mainmenu");
                    break;
                default:
                    return FALSE;
                }
            break;

        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case H_BTN_OK:
                    qfree(help);
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
            }
            break;
        case EVT_SCROLLBAR_REPEAT:
        case EVT_SCROLLBAR_SELECT:
            ScrollbarGetScrollbar(H_SCROLLBAR, &value, &maxValue, &minValue,
                                  &pageSize, &totalLines);
            ScrollbarSetScrollbar(H_SCROLLBAR, Event->para2, maxValue, minValue,
                                  pageSize, totalLines);
            ScrollbarDrawScrollbar(H_SCROLLBAR);
            FieldSetTopLineNum((ObjectID)H_FIELD, value);
            FieldDrawField((ObjectID)H_FIELD);
            break;

        default:
            return FALSE;


        }
    return TRUE;
}

BOOLEAN FormPersonHandleEvent(EvtType* Event)
{
    ObjectID object_type;
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            Person_toPopup();
            FormDrawForm(Event->eventID);
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    FormPopupForm(FORM_MAIN);
                    break;
                case INLAY_OK:
                    Add_Person();
                    break;
                case INLAY_MAIN_MENU:
                    FormGotoApp("Mainmenu");
                    break;
                default:
                    return FALSE;
                }
            break;

        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case BTN_DEL:
                    Delete_Person();
                    break;
            }
            break;
        case EVT_KEY:
            FormGetActiveObject(FORM_PERSON,&object_type);
            TextboxAddKeyInChar(object_type, (BYTE) (Event-> para1));
            TextboxDrawTextbox (object_type);
            break;
        case  EVT_CONTROL_POPUP_SELECT:
            TextboxSetText(TB_NAME, "");
            TextboxSetText(TB_BYEAR, "");
            TextboxSetText(TB_BMON, "");
            TextboxSetText(TB_BDAY, "");
            ControlPopupGetSelectedItem(P_POPUP, &person_no);
            ControlPopupGetPopupItem(P_POPUP, person_no, &buffer);
            strcpy(person,buffer);
            // if edit: take name from popup on edit form
            if(!strstr(person,"New Person"))
            {
                Edit_Person();
            }
            TextboxDrawTextbox (TB_NAME);
            TextboxDrawTextbox (TB_BYEAR);
            TextboxDrawTextbox (TB_BMON);
            TextboxDrawTextbox (TB_BDAY);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormDateHandleEvent(EvtType* Event)
{
    BYTE        *TextField;
    ObjectID    object_type;
    BYTE        buffer_date[100];

    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            FormDrawForm(Event->eventID);
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case INLAY_OK:
                    TextboxGetTextPointer(TB_EYEAR, &TextField);
                    End_Date.year=atol((char *)TextField);
                    End_Year=End_Date.year;
                    TextboxGetTextPointer(TB_EMON, &TextField);
                    End_Date.mon=atol((char *)TextField)-1;
                    End_Month=End_Date.mon+1;
                    TextboxGetTextPointer(TB_EDAY, &TextField);
                    End_Date.mday=atol((char *)TextField);
                    End_Year=End_Date.year;
                    End_Day=End_Date.mday;
                    TextboxGetTextPointer(TB_EYEAR, &TextField);
                    Valid_Year=atol((char *)TextField);
                    TextboxGetTextPointer(TB_EMON, &TextField);
                    Valid_Mon=atol((char *)TextField);
                    TextboxGetTextPointer(TB_EDAY, &TextField);
                    Valid_Day=atol((char *)TextField);
                    if((Valid_Year)&&
                        (Valid_Mon<13) &&
                       (Valid_Day<32))
                    {
                        Read_Data();
                        sprintf(sz,"%i",Days);
                        StringSetText(STRING_DAYS,sz);
                        StringDrawString(STRING_DAYS);
                        ControlSetLabel (BTN_DATE, buffer_date);
                        FormSaveBehindBits(FORM_MAIN);
                        FormPopupForm(FORM_MAIN);
                        Draw();
                    }
                    qfree(TextField);
                    break;
                case INLAY_MAIN_MENU:
                    FormGotoApp("Mainmenu");
                    break;
                default:
                    return FALSE;
                }
            break;

        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case BTN_TODAY:
                    RtcGetTime(&End_Date);
                    End_Year=End_Date.year;
                    End_Month=End_Date.mon+1;
                    End_Day=End_Date.mday;
                    RtcFormatDate(&End_Date, "YY~/MM~/DD", buffer_date);
                    sprintf(sz,"%i",(char *)End_Year);
                    TextboxSetText(TB_EYEAR, sz);
                    sprintf(sz,"%i",End_Month);
                    TextboxSetText(TB_EMON, sz);
                    sprintf(sz,"%i",End_Day);
                    TextboxSetText(TB_EDAY, sz);
                    ControlSetLabel (BTN_DATE, buffer_date);
                    TextboxDrawTextbox (TB_EYEAR);
                    TextboxDrawTextbox (TB_EMON);
                    TextboxDrawTextbox (TB_EDAY);
                    break;
            }
            break;
        case EVT_KEY:
            FormGetActiveObject(FORM_DATE,&object_type);
            TextboxAddKeyInChar(object_type, (BYTE) (Event-> para1));
            TextboxDrawTextbox (object_type);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

void FormGotoApp(BYTE* app_name)
{
    ObjectID objid;
    #ifdef DEBUG
        DBG_MESSAGE("+FormGotoApp()\r\n");
    #endif
    FormGetActiveFormID(&objid);
    EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
    SysGetAppID(app_name,&objid);
    EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
    EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
    #ifdef DEBUG
        DBG_MESSAGE("-FormGotoApp()\r\n");
    #endif
}

int Draw(void)
{
    int             x;
    ObjectBounds    bnds;

    bnds.xcoord = 0;
    bnds.ycoord = 39;  //from 39
    bnds.width = 160;
    bnds.height = 90;  //from 64
    LcdDrawLine(0,90-9,160,90-9,1,1,15,15);
    LcdDrawLine(80,40-9,80,140-9,1,1,15,15);
    for(x=10;x<=150;x=x+10)
    {

        LcdDrawLine(x,89-9,x,91-9,1,1,15,15);
    }
}

int Curve(int range1, int style)
{
    int         drawing1, drawing2=1;
    int         x,y;
    double      dy;
    USHORT      dayresult;
    ObjectBounds bnds;

    dayresult=Days%range1;

    for(x=0;x<160;x++)
    {
        if(style==1)  drawing1=x%2;
        else if(style==2)    drawing2=x%3;
        if(style==0||
            (style==1 && drawing1==0)||
           (style==2 &&  (drawing2==0||drawing2==1)))
        {
            //type mismatch:
            dy=(double)sin(((double)dayresult+(((double)x-80)/10))/(double)range1*6.2831853078);
            y=-(dy*50)+90;
            LcdSetPixel(x,y-9,COLOR_BLACK); //added -9
            if(x==0)
            {
                bnds.xcoord = 0;
                if(y<50) y=50;
                if(y>135) y=125;
                else y=y-20;
                bnds.ycoord = y;
                bnds.width = 100;
                bnds.height = 12;
            }
        }
    }
    strncat(&Description, ": ",3);
    strncat(&Description, person,strlen(person)+1);
    LcdDrawFixedStringS(&bnds, Description, COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE,0);
    sprintf(sz,"%i",Days);
    StringSetText(STRING_DAYS,sz);
    StringDrawString(STRING_DAYS);
}

int CurveComb(int range1, int range2, int style)
{
    int         drawing1, drawing2=1;
    int         x,y;
    double      dy, dy1,dy2;
    ObjectBounds bnds;
    USHORT      dayresult1, dayresult2;

    dayresult1=Days%range1;
    dayresult2=Days%range2;
    for(x=0;x<160;x++)
    {
        if(style==1)
            drawing1=x%2;
        else if(style==2)
            drawing2=x%3;
        if(style==0||
            (style==1&&drawing1==0)||
           (style==2&&(drawing2==0||drawing2==1)))
        {
            dy1=(double)sin(((double)dayresult1+(((double)x-80)/10))/(double)range1*6.2831853078);
            dy2=(double)sin(((double)dayresult2+(((double)x-80)/10))/(double)range2*6.2831853078);
            dy=(double)dy1+(double)dy2;
            dy=(double)dy/(double)2;
            y=-(dy*50)+90;
            LcdSetPixel(x,y-9,COLOR_BLACK);
            if(x==0)
            {
                bnds.xcoord = 0;
                if(y<50) y=50;
                if(y>135) y=125;
                else y=y-20;
                bnds.ycoord = y;
                bnds.width = 100;
                bnds.height = 12;
            }
        }
    }
    strncat(&Description, ": ",3);
    strncat(&Description, person,strlen(person)+1);
    LcdDrawFixedStringS(&bnds, Description, COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE,0);
    sprintf(sz,"%i",Days);
    StringSetText(STRING_DAYS,sz);
    StringDrawString(STRING_DAYS);

}

void AddEdit_Person()
{
    FormSetFormActiveObject(FORM_PERSON, TB_NAME);
    FormPopupForm (FORM_PERSON);
    TextboxSetInsertPointOn(TB_NAME);

}

void Add_Person()
{
    BYTE        *TextField;
    double      buffer;

    TextboxGetTextPointer(TB_BYEAR, &TextField);
    Valid_Year=atol((char *)TextField);
    TextboxGetTextPointer(TB_BMON, &TextField);
    Valid_Mon=atol((char *)TextField);
    TextboxGetTextPointer(TB_BDAY, &TextField);
    Valid_Day=atol((char *)TextField);
    if((Valid_Year)&&(Valid_Mon)&&(Valid_Day)&&
        (Valid_Mon<13) &&
       (Valid_Day<32))
    {
        TextboxGetTextPointer(TB_NAME, &TextField);
        if(strcmp(TextField,"")!=0)
        {
            if(DataOpenDB(BioDB,0,OPEN_RW))
            {

                if(DataNewRecord(BioDB,0,4,&rec_id))
                {
                    DataWriteField(BioDB,rec_id, 0, 31,  TextField);
                    TextboxGetTextPointer(TB_BYEAR, &TextField);
                    DataWriteField(BioDB,rec_id, 1, 5,  TextField);
                    TextboxGetTextPointer(TB_BMON, &TextField);
                    DataWriteField(BioDB,rec_id, 2, 3, TextField);
                    TextboxGetTextPointer(TB_BDAY, &TextField);
                    DataWriteField(BioDB,rec_id, 3, 3,TextField);
                    DataCloseRecord(BioDB,rec_id);
                }
                DataCloseDB(BioDB);
            }
        }
        qfree(TextField);
        Person_toPopup();
        FormPopupForm(FORM_MAIN);
    }
}

void Read_Data()
{
    int     x;
    UBYTE   rec_cat;

    if(DataFindDB("BioDB", &BioDB))
    {
        if(DataOpenDB(BioDB,0,OPEN_RW))
        {
            DataTotalRecord(BioDB, &recCount);
            for(x=0;x<recCount;x++)
            {
                if(DataOpenRecord(BioDB,x,&rec_id,NULL))
                {
                    DataRecordInfo(BioDB,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==0)
                    {

                        DataGetField(BioDB, rec_id, 0, &buffer, &byte_read);
                        if(strstr(buffer,person))
                        {
                            DataGetField(BioDB, rec_id, 1, &buffer, &byte_read);
                            Beg_Year=atol((char *)buffer);
                            DataGetField(BioDB, rec_id, 2, &buffer, &byte_read);
                            Beg_Month=atol((char *)buffer);
                            DataGetField(BioDB, rec_id, 3, &buffer, &byte_read);
                            Beg_Day=atol((char *)buffer);
                            qfree(buffer);
                        }
                    }
                    DataCloseRecord(BioDB,rec_id);
                }
            }
            DataCloseDB(BioDB);
        }

    }
    Leaps=0;
    //Check no. of leap years
    for (x=Beg_Year;x<End_Year+1;x++)
        if(x%4==0) Leaps=Leaps+1;

    //Days in Whole years
    Years=End_Year-Beg_Year;


    Days=Leaps*366+(Years-Leaps)*365;

    //adj for less or more than full year
    Beg_Dayno=monthdays[Beg_Month]+Beg_Day;

    //Adj for beg.year being leapyear
    if((Beg_Year%4==0)&&(Beg_Month>2)) Beg_Dayno=Beg_Dayno+1;

    End_Dayno=monthdays[End_Month]+End_Day;

    if((End_Year%4==0)&&(End_Month>2)) End_Dayno=End_Dayno+1;

    Days=Days+(End_Dayno-Beg_Dayno);

}

void Person_toPopup()
{
    UBYTE   rec_cat;
    int     x=0;

    ControlPopupDeleteAllItems(POPUP_PERSON);
    ControlPopupDeleteAllItems(P_POPUP);

    //read categories from database category 1
    if(DataFindDB("BioDB", &BioDB))
    {
        if(DataOpenDB(BioDB,0,OPEN_RW))
        {
            DataTotalRecord(BioDB, &recCount);
            for(x=0;x<recCount;x++)
            {
                if(DataOpenRecord(BioDB,x,&rec_id,NULL))
                {
                    DataRecordInfo(BioDB,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==0)
                    {
                        DataGetField(BioDB, rec_id, 0, &buffer, &byte_read);
                        {
                            ControlPopupInsertItem(POPUP_PERSON, x, buffer);
                            ControlPopupInsertItem(P_POPUP, x, buffer);
                        }
                    }
                    DataCloseRecord(BioDB,rec_id);
                }
            }
            DataCloseDB(BioDB);
        }
    }
    ControlPopupInsertItem(POPUP_PERSON, x+1, "Edit Person");
    ControlPopupInsertItem(P_POPUP, x+1, "New Person");
    qfree(buffer);


}

void Edit_Person()
{
    int   x=0;

    if(DataFindDB("BioDB", &BioDB))
    {
        if(DataOpenDB(BioDB,0,OPEN_RW))
        {
            DataTotalRecord(BioDB, &recCount);
            for(x=0;x<recCount;x++)
            {
                if(DataOpenRecord(BioDB,x,&rec_id,NULL))
                {
                    DataGetField(BioDB, rec_id, 0, &buffer, &byte_read);

                    if(strcmp(buffer,person)==0)
                    {
                        TextboxSetText(TB_NAME, person);
                        DataGetField(BioDB, rec_id, 1, &buffer, &byte_read);

                        TextboxSetText(TB_BYEAR, buffer);
                        DataGetField(BioDB, rec_id, 2, &buffer, &byte_read);

                        TextboxSetText(TB_BMON, buffer);
                        DataGetField(BioDB, rec_id, 3, &buffer, &byte_read);
                        TextboxSetText(TB_BDAY, buffer);

                    }
                    qfree(buffer);
                    DataCloseRecord(BioDB,rec_id);
                    DataDeleteRecord(BioDB, rec_id, FALSE);
                }

            }
            DataCloseDB(BioDB);
        }
    }
}

void Delete_Person()
{
    int         x=0;
    BYTE        *TextField;

    TextboxGetTextPointer(TB_NAME, &TextField);
    if(strcmp(TextField,"")!=0)
    {
        if(DataFindDB("BioDB", &BioDB))
        {
            if(DataOpenDB(BioDB,0,OPEN_RW))
            {
                DataTotalRecord(BioDB, &recCount);
                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(BioDB,x,&rec_id,NULL))
                    {
                        DataGetField(BioDB, rec_id, 0, &buffer, &byte_read);
                        DataCloseRecord(BioDB,rec_id);
                        if(strcmp(buffer,TextField)==0)
                            DataDeleteRecord(BioDB, rec_id, FALSE);
                        qfree(buffer);
                    }

                }
                DataCloseDB(BioDB);
            }
        }
    }
    qfree(TextField);
    FormPopupForm(FORM_MAIN);
}

void Clear_Drawing()
{
    ObjectBounds bnds;

    bnds.xcoord=0;
    bnds.ycoord = 30;
    bnds.width = 160;
    bnds.height = 103;
    LcdEraseRegion(&bnds);
}


//old date calc

//Days=16073;  //04/15/02
//Beg_Date.year=(BYTE)1958;  //+2000=1910
// Beg_Date.mon=(BYTE)04;
// Beg_Date.mday=(BYTE)15;
// Beg_Date.hour=0;
// Beg_Date.min=0;
// Beg_Date.sec=0;

//RtcGetTime(&End_Date);

// Beg_Year=1952;
// Beg_Month=03;
// Beg_Day=02;

// End_Year=2002;
// End_Month=04;
// End_Day=18;

/*

    Beg_DayofYear=Dt_Date_YDay (1918, 01, 01);
    End_DayofYear=Dt_Date_YDay (2002, 12, 31);
    Leaps=(2002-1918)/4;
    Days=Leaps*366+(2002-1918-Leaps)*365+(End_DayofYear-Beg_DayofYear);
    */
/*
    DayofYear=Dt_Date_YDay (1958, 04, 15);
    Dt_YDay_Date (1958, DayofYear, &Beg_Date);
    DayofYear=Dt_Date_YDay (2002, 04, 17);
    Dt_YDay_Date (2002, DayofYear, &End_Date)/(24*60*60L);
    */