// Pendientes -- ToDo
// Validaciones de fecha
// En la captura de las fechas no deja claramente posarse en el ultimo caracter
// Internacionalizar el programa (espaol e ingls por lo menos),
//   desplegar dependiendo del lenguaje configurado en la Davinci

// dvBio
//
// (http://members.tripod.com/~c_ruiz)
//
// Desarrollado por Carlos Ruiz (cruiz@starmedia.com)
//
// Marzo 8, 2000 - inicio del desarrollo (v0.9)
// Septiembre 8, 2000 - first version (v1.0)

// dvbio.c - Biorhythm program for daVinci SDK

#include <type.h>
#include <nexus.h>
#include <gccattrs.h>                  // for WITH_BITMAP_ATTRS
#include <math.h>
#include <fprefmgr.h>

#include <jrglobal.h>
#include <string.h>
#include <advform.h>

#define F_BUTTON_ID    2100
#define E_BUTTON_ID    2200
#define I_BUTTON_ID    2300
#define P_BUTTON_ID    2400
#define M_BUTTON_ID    2500
#define S_BUTTON_ID    2600
#define G_BUTTON_ID    2700
#define H_BUTTON_ID    2800
#define TOOLBOX_ID     3000
#define SIZEBMP        15
#define XF 0
#define YF 144
#define XE 16
#define YE 144
#define XI 32
#define YI 144
#define XM 48
#define YM 144
#define XW 64
#define YW 144
#define XS 80
#define YS 144
#define XG 96
#define YG 144
#define XH 112
#define YH 144

DATE_TIME fechaIni;
DATE_TIME fechaFin;
DATE_TIME fechaCam;
U32 dias;
char cadena[40];
int renglon;
short dispF, dispE, dispI, dispP, dispM, dispS, dispH = false;
ToolBoxPtr pToolBox;
ObjectPtr btnObject;
AREA_INFO_TYPE myFieldArea = {
35,75,70,95,
};
LINE_TYPE myField;
char *cadTmp;
int camfec = 0;
int espanol = FALSE;

const char  AppName[] = "DVBio";     // application's name
const DWord AppCreator = 'DVBR';         // must be unique
const Word  AppID = 1;         // must be unique
const DWord AppVersion = 'v1.0';        // version of application

const Byte AppIconBmpUp[] WITH_BITMAP_ATTRS = {
   #include "appiconbmpup.inc"
};

const Byte AppIconBmpDn[] WITH_BITMAP_ATTRS = {
   #include "appiconbmpdn.inc"
};

const Byte G_BmpOn[] WITH_BITMAP_ATTRS = {
   #include "g_on.inc"
};

const Byte H_BmpOn[] WITH_BITMAP_ATTRS = {
   #include "h_on.inc"
};

WORD ChildFormProc(P_SYSTEM_EVENT_TYPE pEvent, ObjectPtr pObject){
    switch (pEvent->eventType) {
      case FORM_LOAD_EVENT:
        FrmClearCurrentFormRegion();
        AdvDrawFormBound();
        myField.areaInfoPtr = &myFieldArea;
        myField.displayWidth = 40;
        myField.maxChar = 20;
        myField.numChar = 0;
        myField.font = 1;
        if (camfec == 1) {
            sprintf(myField.charPtr,"%d/%d/%d",
                    fechaIni.year,fechaIni.month,fechaIni.day);
        } else if (camfec == 2) {
            sprintf(myField.charPtr,"%d/%d/%d",
                    fechaFin.year,fechaFin.month,fechaFin.day);
        }
        FntSetFont(FONT5);
        DisplayLineField(&myField);
        break;
      case PRESS_OK_EVENT:
        FntSetFont(FONT5);
        cadTmp = strtok(myField.charPtr, "/");
        fechaCam.year = (U16) atoi(cadTmp);
        cadTmp = strtok(NULL,"/");
        fechaCam.month = (U16) atoi(cadTmp);
        cadTmp = strtok(NULL,"/");
        fechaCam.day = (U16) atoi(cadTmp);
        // ?? Validaciones de fecha
        FrmCloseForm();
	if (camfec == 1) {
	    // nacimiento
	    fechaIni.year = fechaCam.year;
	    fechaIni.month = fechaCam.month;
	    fechaIni.day = fechaCam.day;
	} else if (camfec == 2){
	    // bioritmo
	    fechaFin.year = fechaCam.year;
	    fechaFin.month = fechaCam.month;
	    fechaFin.day = fechaCam.day;
	}
	redespliegue();
	camfec = 0;
        break;
      case PEN_EVENT:
        LineEditPenInput(pEvent,&myField);
        break;
      case KEY_CODE_INPUT:
        ClearRectangle(35,67,48,38);
        LineEditKeyInput(pEvent,&myField);
        DisplayLineField(&myField);
        break;
    }
    return 1;
}

redespliegue() {
    ClearRectangle(0, 0, 160, 37);
    FntSetFont(FONT5);
    if (espanol) {
	sprintf(cadena,"Fecha Nacimiento : %d/%d/%d",
		fechaIni.year,fechaIni.month,fechaIni.day);
    } else {
	sprintf(cadena,"Birth Date : %d/%d/%d",
		fechaIni.year,fechaIni.month,fechaIni.day);
    }
    DisplayChr(cadena,0,0,jstrlen(cadena));
    if (espanol) {
	sprintf(cadena,"Fecha Biorritmo : %d/%d/%d",
		fechaFin.year,fechaFin.month,fechaFin.day);
    } else {
	sprintf(cadena,"Biorhythm Date : %d/%d/%d",
		fechaFin.year,fechaFin.month,fechaFin.day);
    }
    DisplayChr(cadena,0,13,jstrlen(cadena));
    dias = (DateTimeToSeconds(&fechaFin) -
	    DateTimeToSeconds(&fechaIni)) / SecondsInDay;
    if (espanol) {
	sprintf(cadena,"Dias : %d", dias);
    } else {
	sprintf(cadena,"Days : %d", dias);
    }
    DisplayChr(cadena,0,26,jstrlen(cadena));
}

void inihelp() {
    ClearRectangle(0, 39, 160, 103);
    FntSetFont(FONT5);
    renglon = 0;
}

void dishelp(char *cad) {
    DisplayChr(cad,0,39 + (12 * renglon),jstrlen(cad));
    renglon++;
}

void dishelpopt(char opt) {
    inihelp();
    if (espanol) {
	switch (opt) {
	  case 'F':
	    dishelp("Ciclo Fisico");
	    dishelp("El ciclo fisico tiene 23 dias, muestra");
	    dishelp("el nivel de actividad fisica que en un");
	    dishelp("dia determinado el cuerpo puede dar");
	    break;
	  case 'E':
	    dishelp("Ciclo Emocional");
	    dishelp("El ciclo emocional tiene 28 dias,");
	    dishelp("muestra la capacidad emocional, esto");
	    dishelp("es, el nivel de sensibilidad que se");
	    dishelp("tiene en un dia determinado");
	    break;
	  case 'I':
	    dishelp("Ciclo Intelectual");
	    dishelp("El ciclo intelectual tiene 33 dias,");
	    dishelp("muestra el nivel de actividad");
	    dishelp("intelectual que en un dia determinado");
	    dishelp("el cerebro puede brindar");
	    break;
	  case 'P':
	    dishelp("Pasion");
	    dishelp("Es la combinacion de los ciclos fisico y");
	    dishelp("emocional.");
	    dishelp("La pasion es poder, guia, incentivo,");
	    dishelp("sexualidad.  De la pasion viene la");
	    dishelp("habilidad para actuar");
	    break;
	  case 'M':
	    dishelp("Maestria");
	    dishelp("Es la combinacion de los ciclos fisico e");
	    dishelp("intelectual.");
	    dishelp("Mientras la pasion nos da la energia");
	    dishelp("para iniciar algo, la maestria nos da la");
	    dishelp("capacidad para completarlo (sin pasion");
	    dishelp("tarda mucho mas) Maestria es la");
	    dishelp("habilidad de actuar en lo que se desea");
	    break;
	  case 'S':
	    dishelp("Sabiduria");
	    dishelp("Es la combinacion de los ciclos");
	    dishelp("emocional e intelectual.");
	    dishelp("De aqui viene la habilidad para elegir el");
	    dishelp("mejor camino.  La sabiduria guia la");
	    dishelp("pasion");
	    break;
	  case 'G':
	    dishelp("Ejecutar");
	    dishelp("Este boton permite dibujar los graficos");
	    dishelp("de los ciclos seleccionados");
	    break;
	}
    } else {
	switch (opt) {
	  case 'F':
	    dishelp("Physical Cycle");
	    dishelp("The physical cycle has 23 days, shows");
	    dishelp("the physical level activity the body");
	    dishelp("can give in a day");
	    break;
	  case 'E':
	    dishelp("Emotional Cycle");
	    dishelp("The emotional cycle has 28 days,");
	    dishelp("shows the emotional capacity, this is,");
	    dishelp("the sensibility level in a given date");
	    break;
	  case 'I':
	    dishelp("Intellectual Cycle");
	    dishelp("The intellectual cycle has 33 days,");
	    dishelp("shows the intellectual activity");
	    dishelp("level the brain can give in a day");
	    break;
	  case 'P':
	    dishelp("Passion");
	    dishelp("Is the combination between physical");
	    dishelp("and emocional cycles.");
	    dishelp("The passion is power, guide, incentive,");
	    dishelp("sexuality.  From passion comes the");
	    dishelp("ability to act");
	    break;
	  case 'M':
	    dishelp("Mastery");
	    dishelp("Is the combination between physical");
	    dishelp("and intellectual cycles.");
	    dishelp("While passion gives us the energy");
	    dishelp("to start something, mastery gives us");
	    dishelp("the capacity to complete it (without");
	    dishelp("passion takes more time) Mastery is");
	    dishelp("the ability to act in that we desire");
	    break;
	  case 'S':
	    dishelp("Wisdom");
	    dishelp("Is the combination between emotional");
	    dishelp("and intellectual cycles.");
	    dishelp("From here comes the ability to choose");
	    dishelp("the best way.  The wisdom guides the");
	    dishelp("passion");
	    break;
	  case 'G':
	    dishelp("Go");
	    dishelp("This button allows to draw the graphics");
	    dishelp("for selected cycles");
	    break;
	}
    }
}

void errMsg() {
    DialogDoModal(
	cadena,
	"Prefs",
	NULL,
	DIALOG_ICON_EXCLAMATION);
}

void set_nacimiento() {
    Err errPref;
    char fechChar[10];
    sprintf(fechChar,"%d/%d/%d",
	    fechaIni.year,fechaIni.month,fechaIni.day);
    errPref = FPrefSetAppPreferences(AppCreator,AppID,fechChar,10);
    if (errPref != 0) {
	if (espanol) {
	    sprintf(cadena,"Error %d al fijar fecha",
		    errPref);
	} else {
	    sprintf(cadena,"Error %d fixing date",
		    errPref);
	}
	errMsg();
    }
}

void get_nacimiento(Boolean dispErr) {
    char fechChar[10];
    Err errPref;
    errPref = FPrefGetAppPreferences(AppCreator,AppID,fechChar,10);
    if (errPref != 0) {
        fechaIni.year = 1967;
        fechaIni.month = 12;
        fechaIni.day = 1;
        fechaIni.hour = 0;
        fechaIni.minute = 0;
        fechaIni.second = 0;
	if (espanol) {
	    sprintf(cadena,"Error %d al recuperar fecha",
		    errPref);
	} else {
	    sprintf(cadena,"Error %d retrieving date",
		    errPref);
	}
	if (dispErr) errMsg();
    } else {
	cadTmp = strtok(fechChar, "/");
	fechaIni.year = (U16) atoi(cadTmp);
	cadTmp = strtok(NULL,"/");
	fechaIni.month = (U16) atoi(cadTmp);
	cadTmp = strtok(NULL,"/");
	fechaIni.day = (U16) atoi(cadTmp);
    }
    if (dispErr) redespliegue();
}

void del_nacimiento() {
    Err errPref;
    errPref = FPrefRemoveAppPreference(AppCreator,AppID,TRUE);
    if (errPref != 0) {
	if (espanol) {
	    sprintf(cadena,"Error %d al borrar fecha",
		    errPref);
	} else {
	    sprintf(cadena,"Error %d clearing date",
		    errPref);
	}
	errMsg();
    }
}

WORD BioFormProc(P_SYSTEM_EVENT_TYPE pEvent, ObjectPtr pObject) {

    DECLARE_DYNAMIC_LAYOUT(Bio, 9)
    NORMAL_BUTTON_DECLARE(Bio, F_BUTTON_ID)
    NORMAL_BUTTON_DECLARE(Bio, E_BUTTON_ID)
    NORMAL_BUTTON_DECLARE(Bio, I_BUTTON_ID)
    NORMAL_BUTTON_DECLARE(Bio, P_BUTTON_ID)
    NORMAL_BUTTON_DECLARE(Bio, M_BUTTON_ID)
    NORMAL_BUTTON_DECLARE(Bio, S_BUTTON_ID)
    NORMAL_BUTTON_DECLARE(Bio, G_BUTTON_ID)
    NORMAL_BUTTON_DECLARE(Bio, H_BUTTON_ID)
    TOOLBOX_DECLARE(Bio, TOOLBOX_ID);

    // ?? INT como se usa enum FPrefGetPreference(FSystemPreferenceChoice.FprefLanguage, language);

    switch (pEvent->eventType) {
      case FORM_LOAD_EVENT:
        CREATE_DYNAMIC_LAYOUT(Bio, 9);
        NORMAL_BUTTON_CREATE(Bio, F_BUTTON_ID, 0, XF, YF, 0, 0);
            BUTTON_SET_SIZE(Bio, 15, 15);
            btnObject = ObjGetObjectPtr(FrmGetCurrentFormPtr(), F_BUTTON_ID);
            if (espanol) {
		AdvAssignStringToButton(btnObject, "F", 0);
            } else {
		AdvAssignStringToButton(btnObject, "P", 0);
            }
            AdvDrawButtonBound(btnObject);
        NORMAL_BUTTON_CREATE(Bio, E_BUTTON_ID, 0, XE, YE, 0, 0);
            BUTTON_SET_SIZE(Bio, 15, 15);
            btnObject = ObjGetObjectPtr(FrmGetCurrentFormPtr(), E_BUTTON_ID);
            AdvAssignStringToButton(btnObject, "E", 0);
            AdvDrawButtonBound(btnObject);
        NORMAL_BUTTON_CREATE(Bio, I_BUTTON_ID, 0, XI, YI, 0, 0);
            BUTTON_SET_SIZE(Bio, 15, 15);
            btnObject = ObjGetObjectPtr(FrmGetCurrentFormPtr(), I_BUTTON_ID);
            AdvAssignStringToButton(btnObject, "I", 0);
            AdvDrawButtonBound(btnObject);
        NORMAL_BUTTON_CREATE(Bio, P_BUTTON_ID, 0, XM, YM, 0, 0);
            BUTTON_SET_SIZE(Bio, 15, 15);
            btnObject = ObjGetObjectPtr(FrmGetCurrentFormPtr(), P_BUTTON_ID);
            AdvAssignStringToButton(btnObject, "P", 0);
            AdvDrawButtonBound(btnObject);
        NORMAL_BUTTON_CREATE(Bio, M_BUTTON_ID, 0, XW, YW, 0, 0);
            BUTTON_SET_SIZE(Bio, 15, 15);
            btnObject = ObjGetObjectPtr(FrmGetCurrentFormPtr(), M_BUTTON_ID);
            AdvAssignStringToButton(btnObject, "M", 0);
            AdvDrawButtonBound(btnObject);
        NORMAL_BUTTON_CREATE(Bio, S_BUTTON_ID, 0, XS, YS, 0, 0);
            BUTTON_SET_SIZE(Bio, 15, 15);
            btnObject = ObjGetObjectPtr(FrmGetCurrentFormPtr(), S_BUTTON_ID);
            if (espanol) {
		AdvAssignStringToButton(btnObject, "S", 0);
            } else {
		AdvAssignStringToButton(btnObject, "W", 0);
            }
            AdvDrawButtonBound(btnObject);
        NORMAL_BUTTON_CREATE(Bio, G_BUTTON_ID, 0, XG, YG, G_BmpOn, NULL);
        NORMAL_BUTTON_CREATE(Bio, H_BUTTON_ID, 0, XH, YH, H_BmpOn, NULL);
        if (espanol) {
	    TOOLBOX_CREATE(Bio, TOOLBOX_ID,
		"DVBIO",
		"Acerca de", NULL, "Nacimiento", "Fecha Bio", NULL, NULL,
		"Prefs",
		"Fijar Fecha Nac", "Leer Fecha Nac", "Borrar Fecha Nac", NULL, NULL, NULL,
		NULL,
		NULL, NULL, NULL, NULL, NULL, NULL);
        } else {
	    TOOLBOX_CREATE(Bio, TOOLBOX_ID,
		"DVBIO",
		"About", NULL, "Birth Date", "Bio Date", NULL, NULL,
		"Prefs",
		"Fix Birth Date", "Read Birth Date", "Clear Birth Date", NULL, NULL, NULL,
		NULL,
		NULL, NULL, NULL, NULL, NULL, NULL);
        }
        get_nacimiento(FALSE);
        {U16 y,m,d,h,min,sec;
            NexusDateTimeRead(&y,&m,&d,&h,&min,&sec);
            fechaFin.year=y;
            fechaFin.month=m;
            fechaFin.day=d;
            fechaFin.hour=0;
            fechaFin.minute=0;
            fechaFin.second=0;
        }
        redespliegue();
        NexusDrawLine(0, 38, 160, 38, 0);
        NexusDrawLine(0, 142, 160, 142, 0);
        break;

      case OBJECT_SELECT_EVENT:
        switch (pObject->pObjectLayoutPtr->objectID) {
          case F_BUTTON_ID:
	    if (dispH) {
		dishelpopt('F');
	    } else {
                dispF = ! dispF;
                InvRectangle(XF+1,YF+1,SIZEBMP-2,SIZEBMP-2);
            }
	    break;
          case E_BUTTON_ID:
	    if (dispH) {
		dishelpopt('E');
	    } else {
                dispE = ! dispE;
                InvRectangle(XE+1,YE+1,SIZEBMP-2,SIZEBMP-2);
            }
            break;
          case I_BUTTON_ID:
	    if (dispH) {
		dishelpopt('I');
	    } else {
                dispI = ! dispI;
                InvRectangle(XI+1,YI+1,SIZEBMP-2,SIZEBMP-2);
            }
            break;
          case P_BUTTON_ID:
	    if (dispH) {
		dishelpopt('P');
	    } else {
                dispP = ! dispP;
                InvRectangle(XM+1,YM+1,SIZEBMP-2,SIZEBMP-2);
            }
            break;
          case M_BUTTON_ID:
	    if (dispH) {
		dishelpopt('M');
	    } else {
                dispM = ! dispM;
                InvRectangle(XW+1,YW+1,SIZEBMP-2,SIZEBMP-2);
            }
            break;
          case S_BUTTON_ID:
	    if (dispH) {
		dishelpopt('S');
	    } else {
                dispS = ! dispS;
                InvRectangle(XS+1,YS+1,SIZEBMP-2,SIZEBMP-2);
            }
            break;
          case G_BUTTON_ID:
	    if (dispH) {
		dishelpopt('G');
	    } else {
                InvRectangle(XG+1,YG+1,SIZEBMP-2,SIZEBMP-2);
                Dibuje();
                InvRectangle(XG+1,YG+1,SIZEBMP-2,SIZEBMP-2);
            }
            break;
          case H_BUTTON_ID:
            inihelp();
            dispH = ! dispH;
            InvRectangle(XH+1,YH+1,SIZEBMP-2,SIZEBMP-2);
            break;
        }
        break;

      case TOOL_BOX_EVENT:
        pToolBox = FrmGetCurrentFormPtr ()->pToolBox;
        switch ((int)pToolBox->posItem) {
          case 1:
            // About
            camfec = 0;
            if (espanol) {
		DialogDoModal(
		    "por Carlos Antonio Ruiz Gmez - v1.0",
		    "Biorritmo",
		    NULL,
		    DIALOG_ICON_EXCLAMATION);
            } else {
		DialogDoModal(
		    "by Carlos Antonio Ruiz Gmez - v1.0",
		    "Biorhythm",
		    NULL,
		    DIALOG_ICON_EXCLAMATION);
            }
            break;
          case 3:
            // Cambiar fecha de nacimiento
            camfec = 1;
            FrmOpenForm(30,65,60,50,ChildFormProc,2);
            break;
          case 4:
            // Cambiar fecha objetivo
            camfec = 2;
            FrmOpenForm(30,65,60,50,ChildFormProc,2);
            break;
          case 8:
            // Fijar fecha de nacimiento
            set_nacimiento();
            break;
          case 9:
            // Leer fecha de nacimiento
            get_nacimiento(TRUE);
            break;
          case 10:
            // Borrar fecha de nacimiento
            del_nacimiento();
            break;
        }
        break;

      case RETURN_FROM_CHILD_FORM_EVENT:
        break;

      case FORM_EXIT_EVENT:
        RESET_DYNAMIC_LAYOUT (Bio);
        break;

      default:
        return 0;

    }

}

int Dibuje(void) {
    int x;
    ClearRectangle(0, 39, 160, 103);
    NexusDrawLine(0, 90, 160, 90, 0); // eje x
    NexusDrawLine(80, 40, 80, 140, 0); // eje y
    for (x = 10; x <= 150; x=x+10) {
	NexusDrawLine(x, 89, x, 91, 0);
    }
    if (dispF) {
        Curva(23, 0);
    }
    if (dispE) {
        Curva(28, 1);
    }
    if (dispI) {
        Curva(33, 2);
    }
    if (dispP) {
        CurvaComb(23, 28, 0);
    }
    if (dispM) {
        CurvaComb(23, 33, 1);
    }
    if (dispS) {
        CurvaComb(28, 33, 2);
    }
}

int Curva(int rango1, int estilo) {
// estilo
//    0 - continuo   ...........
//    1 - punteado   . . . . . .
//    2 - rayado     .. .. .. ..
    int dibuje1, dibuje2 = TRUE;
    int x, y;
    double dy;
    U32 diasres;
    diasres = dias % rango1;
    for (x = 0; x < 160; x++) {
        if (estilo == 1) {
            dibuje1 = x % 2;
        } else if (estilo == 2) {
            dibuje2 = x % 3;
        }
        if ( estilo == 0 ||
            (estilo == 1 && dibuje1 == 0) ||
            (estilo == 2 && (dibuje2 == 0 || dibuje2 == 1))) {
            dy = (double) sin(((double) diasres + (((double) x - 80) / 10)) /
                                 (double) rango1 * 6.2831853078);
            y = - (dy * 50) + 90;
            NexusDrawDot(x, y);
        }
    }
}

int CurvaComb(int rango1, int rango2, int estilo) {
// estilo
//    0 - continuo   ...........
//    1 - punteado   . . . . . .
//    2 - rayado     .. .. .. ..
    int dibuje1, dibuje2 = TRUE;
    int x, y;
    double dy, dy1, dy2;
    U32 diasres1, diasres2;
    diasres1 = dias % rango1;
    diasres2 = dias % rango2;
    for (x = 0; x < 160; x++) {
        if (estilo == 1) {
            dibuje1 = x % 2;
        } else if (estilo == 2) {
            dibuje2 = x % 3;
        }
        if ( estilo == 0 ||
            (estilo == 1 && dibuje1 == 0) ||
            (estilo == 2 && (dibuje2 == 0 || dibuje2 == 1))) {
            dy1 = (double) sin(((double) diasres1 + (((double) x - 80) / 10)) /
                                  (double) rango1 * 6.2831853078);
            dy2 = (double) sin(((double) diasres2 + (((double) x - 80) / 10)) /
                                  (double) rango2 * 6.2831853078);
            dy = (double) dy1 + (double) dy2;
            dy = (double) dy / (double) 2;
            y = - (dy * 50) + 90;
            NexusDrawDot(x, y);
        }
    }
}

DWord NexusMain(Word cmd, Ptr cmdPBP, Word launchFlags) {

    SYSTEM_EVENT_TYPE  evt;

    switch (cmd) {
      case sysAppLaunchCmdNormalLaunch:
        FrmGotoForm(0, 0, 160, 160, BioFormProc, 0);
        do {
            NexusEvtGetEvent(&evt, WAIT_FOREVER);
            if (!SystemHandleEvent(&evt))
                if (ClockHandleEvent(&evt) != TRUE)
                    if (!ToolBoxHandleEvent (&evt))
                        FrmHandleEvent(&evt);
        } while (evt.eventType != appStopEvent);
        FrmCloseAllForms();
        break;
    }

    return 0;
}


int atoi ( char *valor) {
        char *s;
         int v=0;
         s=valor;
         while (*s!=NULL) {
                 v=(v*10)+((char)*s-48);s++;
        }
        return v;
}
