//Categ.c Part of Helio shopping list application
//Deals with the form for adding/editing categories, and getting the category name
//to the popuptriggers.
//The category is not the same as that used by VTech. See the description of the
//records in the shopping database in main.c

#include "main.h"

//variables
int         cat_chk=0;
BYTE        *cat_name;

//functions
void        Add_Category();
void        CategoryToPopupTrigger();
void        Delete_Category();
void        Edit_Category();

//BOOLEAN FormCatHandleEvent(EvtType* Event)
//BOOLEAN FormCatNameHandleEvent(EvtType* Event)


BOOLEAN FormCatHandleEvent(EvtType* Event)
{    
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            CategoryToPopupTrigger();  
            ListDrawList(CLIST_CAT);
            FormDrawForm(Event->eventID);  
            cat_chk=0;        
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    FormPopupForm(FORM_ADD_EDIT);
                    break;
                case INLAY_OK:
                    FormPopupForm(FORM_ADD_EDIT);
                    break;
                default:
                    return FALSE;
            }
            break;
        case EVT_LIST_SELECT:
            ListGetSelectedItem(CLIST_CAT, &listno);
            ListGetListItem(CLIST_CAT, listno, (BYTE **) &recordText);
            ListSetHighlightedItem(CLIST_CAT, listno);
            ListDrawList(Event->eventID);
            cat_chk=1;
            break;
       case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case CBTN_NEW:
                    FormSaveBehindBits(FORM_CAT);
                    FormSetFormActiveObject(FORM_EDITCAT, CTB_CATNAME);
                    FormPopupForm(FORM_EDITCAT);
                    break;
                case CBTN_DEL:
                    Delete_Category();
                    break;
                case CBTN_RENAME:
                    if(listno!=NO_SELECTION) 
                    {
                       cat_chk==1;
                       TextboxSetText(CTB_CATNAME, recordText);
                       TextboxSetInsertPointOn(CTB_CATNAME);
                       FormSetFormActiveObject(FORM_EDITCAT, CTB_CATNAME);
                       FormPopupForm(FORM_EDITCAT);
                    }
                    break;
            }
            break;

        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormCatNameHandleEvent(EvtType* Event)
{
    ObjectID object_type;

    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            if(cat_chk==1)  //edit text
            {
                //   TextboxSetText(CTB_CATNAME, record_text);
                //edit_chk=0;
            }
            else
            {
                TextboxSetText(CTB_CATNAME, "");
            }
            TextboxSetInsertPointOn(CTB_CATNAME);
            TextboxDrawTextbox(CTB_CATNAME);
            FormSetFormActiveObject(FORM_EDITCAT, CTB_CATNAME);
            FormDrawForm(Event->eventID);
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    FormRestoreBitBehind(FORM_CAT);  
                    FormPopupForm(FORM_CAT);        
                    break;
                case INLAY_OK:  
                    TextboxGetTextPointer(CTB_CATNAME, &cat_name);
                    if(strcmp(cat_name,"")!=0)
                    {
                        if(cat_chk==1)
                        {
                            record_category=cat_name;
                            Edit_Category();
                        }
                        Add_Category();
                        record_category=cat_name;
                        edit_chk=4;    
                    }             
                    FormRestoreBitBehind(FORM_CAT);
                    FormPopupForm(FORM_CAT);
                    break;
                default:
                    return FALSE;
                }
            break;
        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case CBTN_X:
                    FormRestoreBitBehind(FORM_CAT);  
                    FormPopupForm(FORM_CAT);       
                    break;
            }
            break;
        case EVT_KEY:
            FormGetActiveObject(FORM_EDITCAT,&object_type);
            TextboxAddKeyInChar(object_type, (BYTE) (Event-> para1));
            TextboxDrawTextbox (object_type);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

void Add_Category()
{
    if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
    {
       TextboxGetTextPointer(CTB_CATNAME, &cat_name);
       if(DataNewRecord(ShopperdbID,1,1,&rec_id))
       {
          DataWriteField(ShopperdbID,rec_id, 0, 31,  cat_name);
          DataCloseRecord(ShopperdbID,rec_id);
       }
       DataCloseDB(ShopperdbID);
       ListDeleteAllItems(CLIST_CAT);
       CategoryToPopupTrigger();

       // add category as record to category 1
       ListDrawList(CLIST_CAT);
    }
}

void Edit_Category()
{
    UBYTE rec_cat;
    int   x=0;

    if(listno!=NO_SELECTION) 
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,0,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                       DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                        //check for category records
                       if(rec_cat==1) 
                       {
                           DataGetField(ShopperdbID, rec_id, 0, &record_cate, &byte_read);                       
                           //recordText is the text in the list that was selected
                           if(strcmp(record_cate,recordText)==0)
                           {
                                  DataWriteField(ShopperdbID,rec_id, 0, 31,  cat_name);
                                  DataCloseRecord(ShopperdbID,rec_id);
                                  //without this there will be 2 identical records.
                                  DataDeleteRecord(ShopperdbID, rec_id, FALSE); 
                           }
                       }
                       else DataCloseRecord(ShopperdbID,rec_id);
                    }
                }      
                DataCloseDB(ShopperdbID);
            }
            //The following code changes the category for each item
            if(DataOpenDB(ShopperdbID,0,OPEN_RW))
            {
               DataTotalRecord(ShopperdbID, &recCount);
               for(x=0;x<recCount;x++)
               {
                   if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                   {
                      DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                       //regular records
                      if(rec_cat==0)
                      {
                          DataGetField(ShopperdbID, rec_id, 2, &record_cate, &byte_read);
                          if(strcmp(recordText,record_cate)==0)
                              DataWriteField(ShopperdbID,rec_id, 2, 31,record_category);
                      }
                      DataCloseRecord(ShopperdbID,rec_id);   
                   }               
               }   
               DataCloseDB(ShopperdbID);  
            }
        }    
    }
}

void Delete_Category()
{
    UBYTE rec_cat;
    int   x=0;

    if(listno!=NO_SELECTION)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,0,OPEN_RW))
            {
               DataTotalRecord(ShopperdbID, &recCount);

               for(x=0;x<recCount;x++)
               {
                   if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                   {
                      DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                      if(rec_cat==1)
                      {
                          DataGetField(ShopperdbID, rec_id, 0, &record_cate, &byte_read);
                          DataCloseRecord(ShopperdbID,rec_id);
                          if(strcmp(record_cate,recordText)==0)
                              DataDeleteRecord(ShopperdbID, rec_id, FALSE);
                      }
                   }
               }      
               DataCloseDB(ShopperdbID);
            }
        }    
    }
    ListDeleteAllItems(CLIST_CAT);
    CategoryToPopupTrigger();
    ListDrawList(CLIST_CAT);    
}

void CategoryToPopupTrigger()          //from VTOS source
{
    UBYTE rec_cat;
    int     x=0;

    ControlPopupDeleteAllItems(POPUP_CATEGORY);
    ControlPopupDeleteAllItems(POPUP_CAT);
    ListDeleteAllItems(CLIST_CAT);

    ControlPopupInsertItem(POPUP_CATEGORY, 0, "All");
    ControlPopupInsertItem(POPUP_CATEGORY, 1, "Shopping List");
    ControlPopupInsertItem(POPUP_CATEGORY, 2, "Unfiled");
    ControlPopupInsertItem(POPUP_CAT, 0, "Unfiled");

    //read categories from database category 1
    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
            DataTotalRecord(ShopperdbID, &recCount);
            for(x=0;x<recCount;x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==1)
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        {
                            ListInsertItem(CLIST_CAT,x,buffer);
                            ControlPopupInsertItem(POPUP_CATEGORY, x+3, buffer);
                            ControlPopupInsertItem(POPUP_CAT, x+1, buffer);
                        }
                    }
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
    }
    ControlPopupInsertItem(POPUP_CAT, x+1, "Edit Categories");
    qfree(buffer);
}