//Edit.c Part of Helio shopping list application
//Deals with the code from the Edit item form


#include "main.h"

//variables  qfree in main.c
BYTE            *record_aisle; 
BYTE            *record_edittext; 
BYTE            *record_qty;     

//functions: 
void            Edit_Item();

//BOOLEAN FormDeleteHandleEvent(EvtType* Event)
//BOOLEAN FormEditHandleEvent(EvtType* Event)
//BOOLEAN FormSaveHandleEvent(EvtType* Event)

extern void     Add_Record();       //see Database.c
extern void     Delete_Record();    //see Database.c

BOOLEAN FormEditHandleEvent(EvtType* Event)
{
    ObjectID object_type;

    switch (Event->eventType)
    {
        case EVT_FORM_OPEN:
            ControlGetLabel(POPUP_CAT, &item_cat);
            ControlGetLabel(EPOPUP_STORE, &item_store);
            if(edit_chk==1)
            {
                TextboxSetText(TB_ITEM, (char *)record_text);
                TextboxSetText(TB_QTY, record_qty);
                TextboxSetText(TB_AISLE, record_aisle);
                
                ControlSetLabel(EPOPUP_STORE, record_store);
                ControlSetLabel(POPUP_CAT, record_category);
            }
            
            if(edit_chk>1)  //cat/store edit form has been edited  new
            {
                if (edit_chk==2) //no editing
                {   
                       ControlSetLabel(EPOPUP_STORE,"Any");
                       ControlSetLabel(POPUP_CAT, "Unfiled");   
                } 
                
                if (edit_chk==3) //store has been edited
                {
                        if(strstr(store,"Edit Stores"))
                            store="Any";
                       ControlSetLabel(EPOPUP_STORE, store); 
                }                              
            
                if(edit_chk==4)    //category has been edited
                {
                    if(strstr(record_category,"Edit Categories"))
                             record_category="Unfiled";     
                     ControlSetLabel(POPUP_CAT, record_category);                     
                }                       
            }
           
            if(edit_chk==0)            
            {
                TextboxSetText(TB_ITEM, "");
                TextboxSetText(TB_AISLE, "");
                TextboxSetText(TB_QTY, "0");
                
                ControlSetLabel(EPOPUP_STORE, "Any");
                ControlSetLabel(POPUP_CAT, "Unfiled");
            }
                    
            FormSetFormActiveObject(FORM_ADD_EDIT, TB_ITEM);
            FormDrawForm(FORM_ADD_EDIT);
            TextboxSetInsertPointOn(TB_ITEM);
            break;
        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case BTN_DEL:
                    FormSaveBehindBits(FORM_ADD_EDIT);
                    FormPopupForm(FORM_DELETE);
                    break;
            }
            break;
        case EVT_CONTROL_POPUP_SELECT:

            switch(Event->eventID)
            {
                case POPUP_CAT:
                    ControlPopupGetSelectedItem(POPUP_CAT, &item_no);
                    ControlPopupGetPopupItem(POPUP_CAT, item_no, &item_cat);
                    if(strstr(item_cat,"Edit Categories"))
                    {
                        edit_chk=2;
                        TextboxGetTextPointer(TB_ITEM, &record_edittext);
                        TextboxGetTextPointer(TB_QTY, &record_qty);
                        TextboxGetTextPointer(TB_AISLE, &record_aisle); 
                        FormPopupForm(FORM_CAT);
                    }
                    break;
                case EPOPUP_STORE:
                    ControlPopupGetSelectedItem(EPOPUP_STORE, &item_no);
                    ControlPopupGetPopupItem(EPOPUP_STORE, item_no, &item_store);
                    if(strstr(item_store,"Edit Stores"))
                    {
                        edit_chk=2;
                        TextboxGetTextPointer(TB_ITEM, &record_edittext);                        
                        TextboxGetTextPointer(TB_AISLE, &record_aisle);
                        TextboxGetTextPointer(TB_QTY, &record_qty);
                        FormPopupForm(FORM_STORES);
                    }
                    break;
            }
            break;

        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_OK:
                    Add_Record();
                    break;
                case INLAY_EXIT:
                    FormSaveBehindBits(FORM_ADD_EDIT);
                    FormPopupForm(FORM_SAVE);
                    break;
                default:
                    return FALSE;
                }
            break;
        case EVT_KEY:
            FormGetActiveObject(FORM_ADD_EDIT,&object_type);
            TextboxAddKeyInChar(object_type, (BYTE) (Event-> para1));
            TextboxDrawTextbox (object_type);
            break;
    }
    return TRUE;
}

BOOLEAN FormSaveHandleEvent(EvtType* Event)
{
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            FormDrawForm(Event->eventID);
            FormSetActiveForm(FORM_SAVE);
            break;

        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case SBTN_YES:
                    FormRestoreBitBehind(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_ADD_EDIT);
                    FormPopupForm(FORM_ADD_EDIT);
                    Add_Record();
                    FormSetActiveForm(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case SBTN_NO:
                    FormRestoreBitBehind(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_ADD_EDIT);
                    FormPopupForm(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case SBTN_X:
                    FormRestoreBitBehind(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_ADD_EDIT);
                    FormPopupForm(FORM_ADD_EDIT);
                    break;
            }
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormDeleteHandleEvent(EvtType* Event)
{
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            FormDrawForm(Event->eventID);
            FormSetActiveForm(FORM_DELETE);
            break;

        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case DEL_BTN_YES:
                    Delete_Record();
                    listno=-1;
                    FormRestoreBitBehind(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_ADD_EDIT);
                    FormPopupForm(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case DEL_BTN_NO:
                    FormRestoreBitBehind(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_ADD_EDIT);
                    FormPopupForm(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
               case DEL_BTN_X:
                    FormRestoreBitBehind(FORM_ADD_EDIT);
                    FormSetActiveForm(FORM_ADD_EDIT);
                    FormPopupForm(FORM_ADD_EDIT);
                    break;
            }
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

void Edit_Item()
{    
    int   x=0;

    if(listno!=NO_SELECTION)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
            {
               DataTotalRecord(ShopperdbID, &recCount);
               ListGetListItem(LIST_ITEMS, listno, (BYTE **) &recordText);               
               for(x=0;x<recCount;x++)
               {
                   if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                   {
                       DataGetField(ShopperdbID, rec_id, 0, &record_text, &byte_read);
                       DataGetField(ShopperdbID, rec_id, 1, &record_qty, &byte_read);
                       DataGetField(ShopperdbID, rec_id, 2, &record_category, &byte_read);
                       DataGetField(ShopperdbID, rec_id, 3, &record_store, &byte_read);
                       DataGetField(ShopperdbID, rec_id, 4, &record_aisle, &byte_read);
                       DataGetField(ShopperdbID, rec_id, 5, &record_done, &byte_read);  //new
                       DataCloseRecord(ShopperdbID,rec_id);
                   
                       if(strcmp(record_text,recordText)==0)
                       {                    
                               edit_id=rec_id;
                               break;                    
                       }
                   }
               }    
               DataCloseDB(ShopperdbID);
            }
        }  
    }
    ListSetHighlightedItem (LIST_ITEMS, -1);  
    ListSetHighlightedItem (LIST_DONE, -1); 
    ListSetHighlightedItem (LIST_AISLE, -1); 
    ListSetHighlightedItem (LIST_QTY, -1);   
}