//Store.c Part of Helio shopping list application
//Deals with the form for adding/editing stores, and getting the store name
//to the popuptriggers.

#include "main.h"

//functions:
void    Add_Store();
void    Delete_Store();
void    Edit_Store();
void    StoreToPopupTrigger();
BYTE    *store_name;   //new

//BOOLEAN FormStoreHandleEvent(EvtType* Event)
//BOOLEAN FormStoreNameHandleEvent(EvtType* Event)


BOOLEAN FormStoreHandleEvent(EvtType* Event)
{    
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            StoreToPopupTrigger();          
            ListDrawList(LIST_STORES);
            FormDrawForm(Event->eventID);
            cat_chk=0;                      
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    FormPopupForm(FORM_ADD_EDIT);
                    break;
                case INLAY_OK:
                    FormPopupForm(FORM_ADD_EDIT);
                    break;
                default:
                    return FALSE;
                }
            break;
        case EVT_LIST_SELECT:
            ListGetSelectedItem(LIST_STORES, &listno);
            ListGetListItem(LIST_STORES, listno, (BYTE **) &recordText);
            ListSetHighlightedItem(LIST_STORES, listno);
            ListDrawList(Event->eventID);
            cat_chk=1;
            break;
       case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case STBTN_NEW:
                    FormSaveBehindBits(FORM_EDITSTORES);
                    TextboxSetInsertPointOn(STTB_STORENAME);
                    FormSetFormActiveObject(FORM_EDITSTORES, STTB_STORENAME);
                    FormPopupForm(FORM_EDITSTORES);
                    break;
                case STBTN_DEL:
                    Delete_Store();
                    break;
                case STBTN_RENAME:
                    if(listno!=NO_SELECTION) 
                    {
                       cat_chk==1;         
                       TextboxSetText(STTB_STORENAME, recordText);
                       TextboxSetInsertPointOn(STTB_STORENAME);
                       FormSetFormActiveObject(FORM_EDITSTORES, STTB_STORENAME);
                       FormPopupForm(FORM_EDITSTORES);
                    }
                    break;
            }
            break;

        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormStoreNameHandleEvent(EvtType* Event)
{
    ObjectID object_type;

    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            if(cat_chk==1)
            {
                //   TextboxSetText(CTB_CATNAME, record_text);
                //edit_chk=0;
            }
            //if(cat_chk==0)
            else
            {
                TextboxSetText(STTB_STORENAME, "");
            }
            TextboxSetInsertPointOn(STTB_STORENAME);
            TextboxDrawTextbox(STTB_STORENAME);
            FormSetFormActiveObject(FORM_EDITSTORES, STTB_STORENAME);
            FormDrawForm(Event->eventID);
            break;
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    FormRestoreBitBehind(FORM_STORES); 
                    FormPopupForm(FORM_STORES);     
                    break;
                case INLAY_OK:   
                    TextboxGetTextPointer(STTB_STORENAME, &store_name);
                    if(strcmp(store_name,"")!=0)
                    {
                        if(cat_chk==1)
                        {
                            record_store=store_name;
                            Edit_Store();
                        }
                        Add_Store();
                        store=store_name;
                        edit_chk=3;
                    }
                    FormRestoreBitBehind(FORM_STORES);
                    FormPopupForm(FORM_STORES);
                    break;
                default:
                    return FALSE;
                }
            break;
        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case STBTN_X:
                    FormRestoreBitBehind(FORM_STORES); 
                    FormPopupForm(FORM_STORES);
                    break;
            }
            break;
        case EVT_KEY:
            FormGetActiveObject(FORM_EDITSTORES,&object_type);
            TextboxAddKeyInChar(object_type, (BYTE) (Event-> para1));
            TextboxDrawTextbox (object_type);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

void Add_Store()
{    
    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
        {
            TextboxGetTextPointer(STTB_STORENAME, &store_name);
            if(DataNewRecord(ShopperdbID,2,1,&rec_id))
            {
                DataWriteField(ShopperdbID,rec_id, 0, 31,  store_name);
                DataCloseRecord(ShopperdbID,rec_id);
            }
            DataCloseDB(ShopperdbID);
            ListDeleteAllItems(LIST_STORES);
            StoreToPopupTrigger();
            
            // add category as record to category 1
            ListDrawList(LIST_STORES);
        }        
    }
}

void Edit_Store()
{
    UBYTE rec_cat;
    BYTE  *record_sto;
    int   x=0;

    if(listno!=NO_SELECTION)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,0,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                        DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                        //check for store records
                        if(rec_cat==2)
                        {  
                            DataGetField(ShopperdbID, rec_id, 0, &record_sto, &byte_read);
                            if(strcmp(record_sto,recordText)==0)
                            {
                                DataWriteField(ShopperdbID,rec_id, 0, 31,  store_name);
                                DataCloseRecord(ShopperdbID,rec_id);   
                                DataDeleteRecord(ShopperdbID, rec_id, FALSE);
                            }
                        }
                        else DataCloseRecord(ShopperdbID,rec_id);  
                    }
                }
                DataCloseDB(ShopperdbID);
            }
            //The following code changes the store for each item
            if(DataOpenDB(ShopperdbID,0,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                       DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                       //check for store records
                       if(rec_cat==0) 
                       {
                           DataGetField(ShopperdbID, rec_id, 3, &record_sto, &byte_read);
                           if(strcmp(recordText,record_sto)==0)
                                DataWriteField(ShopperdbID,rec_id, 3, 31,record_store);
                       }
                       DataCloseRecord(ShopperdbID,rec_id);
                    }                 
                }   
                 DataCloseDB(ShopperdbID);  
            }             
    }
    qfree(record_sto);
    }
}

void Delete_Store()
{
    UBYTE rec_cat;
    BYTE  *record_sto;
    int   x=0;
   
    if(listno!=NO_SELECTION)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,0,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                        DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                        if(rec_cat==2)
                        {
                            DataGetField(ShopperdbID, rec_id, 0, &record_sto, &byte_read);
                            DataCloseRecord(ShopperdbID,rec_id);

                            if(strcmp(record_sto,recordText)==0)
                                 DataDeleteRecord(ShopperdbID, rec_id, FALSE);
                        }
                    }
                }     
                DataCloseDB(ShopperdbID);
            }
            qfree(record_sto);
        }     
    }
    ListDeleteAllItems(LIST_STORES);

    StoreToPopupTrigger();
    ListDrawList(LIST_STORES);
}


void    StoreToPopupTrigger()
{
    UBYTE rec_cat;
    int     x=0;

    ControlPopupDeleteAllItems(POPUP_STORE);
    ControlPopupDeleteAllItems(EPOPUP_STORE);
    ListDeleteAllItems(LIST_STORES);

    ControlPopupInsertItem(POPUP_STORE, 0, "All Stores");
    ControlPopupInsertItem(POPUP_STORE, 1, "Any");
    ControlPopupInsertItem(EPOPUP_STORE, 0, "Any");

    //read categories from database category 1

    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
            DataTotalRecord(ShopperdbID, &recCount);

            for(x=0;x<recCount;x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==2)
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        {
                            ListInsertItem(LIST_STORES,x,buffer);
                            ControlPopupInsertItem(POPUP_STORE, x+2, buffer);
                            ControlPopupInsertItem(EPOPUP_STORE, x+1, buffer);
                        }
                    }
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
    }
    ControlPopupInsertItem(EPOPUP_STORE, x+1, "Edit Stores");
    qfree(buffer);
}
